/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.internals.generated.TransactionLogKey;
import kafka.log.UnifiedLog;
import kafka.server.ActionQueue;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r]f\u0001B2e\u0001-DQA\u001d\u0001\u0005\u0002MDqA\u001e\u0001C\u0002\u0013\u0005q\u000f\u0003\u0004|\u0001\u0001\u0006I\u0001\u001f\u0005\by\u0002\u0011\r\u0011\"\u0001x\u0011\u0019i\b\u0001)A\u0005q\"9a\u0010\u0001b\u0001\n\u00039\bBB@\u0001A\u0003%\u0001\u0010C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001\u0002\u0004!A\u00111\u0004\u0001!\u0002\u0013\t)\u0001\u0003\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0001x\u0011\u001d\ty\u0002\u0001Q\u0001\naD\u0011\"!\t\u0001\u0005\u0004%\t!a\t\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003KA\u0011\"a\u0011\u0001\u0005\u0004%\t!!\u0012\t\u0011\u0005M\u0003\u0001)A\u0005\u0003\u000fB\u0011\"!\u0016\u0001\u0005\u0004%\t!a\u0016\t\u0011\u0005%\u0004\u0001)A\u0005\u00033B\u0011\"a\u001b\u0001\u0005\u0004%\t!!\u001c\t\u0011\u0005m\u0004\u0001)A\u0005\u0003_B\u0011\"! \u0001\u0005\u0004%\t!a \t\u0011\u0005-\u0005\u0001)A\u0005\u0003\u0003C\u0011\"!$\u0001\u0005\u0004%\t!a$\t\u0011\u0005m\u0005\u0001)A\u0005\u0003#C\u0011\"!(\u0001\u0005\u0004%\t!a(\t\u0011\u0005\u001d\u0006\u0001)A\u0005\u0003CC\u0011\"!+\u0001\u0005\u0004%\t!a+\t\u0011\u0005M\u0006\u0001)A\u0005\u0003[C\u0011\"!.\u0001\u0005\u0004%\t!a.\t\u0011\u0005=\u0007\u0001)A\u0005\u0003sC\u0011\"!5\u0001\u0005\u0004%\t!a.\t\u0011\u0005M\u0007\u0001)A\u0005\u0003sC\u0011\"!6\u0001\u0005\u0004%\t!a6\t\u0011\u0005\u0015\b\u0001)A\u0005\u00033D\u0011\"a:\u0001\u0005\u0004%\t!a6\t\u0011\u0005%\b\u0001)A\u0005\u00033D\u0011\"a;\u0001\u0005\u0004%\t!!<\t\u0011\u0005u\b\u0001)A\u0005\u0003_D\u0011\"a@\u0001\u0001\u0004%\tA!\u0001\t\u0013\t%\u0001\u00011A\u0005\u0002\t-\u0001\u0002\u0003B\f\u0001\u0001\u0006KAa\u0001\t\u0013\te\u0001\u00011A\u0005\u0002\t\u0005\u0001\"\u0003B\u000e\u0001\u0001\u0007I\u0011\u0001B\u000f\u0011!\u0011\t\u0003\u0001Q!\n\t\r\u0001\"\u0003B\u0012\u0001\u0001\u0007I\u0011\u0001B\u0013\u0011%\u0011\u0019\u0004\u0001a\u0001\n\u0003\u0011)\u0004\u0003\u0005\u0003:\u0001\u0001\u000b\u0015\u0002B\u0014\u0011\u001d\u0011Y\u0004\u0001C\u0001\u0005{AqA!\u0016\u0001\t\u0003\u0011i\u0004C\u0004\u0003`\u0001!\tA!\u0010\t\u000f\t%\u0004\u0001\"\u0001\u0003>!9!Q\u000e\u0001\u0005\u0002\tu\u0002b\u0002B9\u0001\u0011\u0005!Q\b\u0005\b\u0005k\u0002A\u0011\u0001B\u001f\u0011\u001d\u0011I\b\u0001C\u0001\u0005{AqA! \u0001\t\u0003\u0011i\u0004C\u0004\u0003\u0002\u0002!\tA!\u0010\t\u000f\t\u0015\u0005\u0001\"\u0001\u0003>!9!\u0011\u0012\u0001\u0005\u0002\tu\u0002b\u0002BG\u0001\u0011\u0005!Q\b\u0005\b\u0005#\u0003A\u0011\u0001B\u001f\u0011\u001d\u0011)\n\u0001C\u0001\u0005{AqA!'\u0001\t\u0003\u0011i\u0004C\u0004\u0003\u001e\u0002!\tA!\u0010\t\u000f\t\u0005\u0006\u0001\"\u0001\u0003>!9!Q\u0015\u0001\u0005\u0002\tu\u0002b\u0002BU\u0001\u0011\u0005!Q\b\u0005\b\u0005[\u0003A\u0011\u0001B\u001f\u0011\u001d\u0011\t\f\u0001C\u0001\u0005{AqA!.\u0001\t\u0003\u0011i\u0004C\u0004\u0003:\u0002!\tA!\u0010\t\u000f\tu\u0006\u0001\"\u0001\u0003>!9!\u0011\u0019\u0001\u0005\u0002\tu\u0002b\u0002Bc\u0001\u0011\u0005!Q\b\u0005\b\u0005\u0013\u0004A\u0011\u0001B\u001f\u0011\u001d\u0011i\r\u0001C\u0001\u0005{AqA!5\u0001\t\u0003\u0011i\u0004C\u0004\u0003V\u0002!\tA!\u0010\t\u000f\te\u0007\u0001\"\u0001\u0003>!9!Q\u001c\u0001\u0005\n\t}\u0007b\u0002B~\u0001\u0011%!Q \u0005\b\u0007\u0007\u0001A\u0011BB\u0003\u0011\u001d\u00199\u0001\u0001C\u0001\u0005{Aqaa\u0003\u0001\t\u0003\u0011i\u0004C\u0004\u0004\u0010\u0001!Ia!\u0005\t\u000f\r]\u0001\u0001\"\u0003\u0004\u001a!91Q\u0004\u0001\u0005\n\r}\u0001bBB\u0015\u0001\u0011%11\u0006\u0005\b\u0007\u0007\u0002A\u0011BB#\u0011\u001d\u0019i\u0005\u0001C\u0005\u0007\u001fBqaa\u0018\u0001\t\u0013\u0019\t\u0007C\u0004\u0004h\u0001!Ia!\u001b\t\u000f\r5\u0004\u0001\"\u0003\u0004p!I1Q\u0010\u0001\u0012\u0002\u0013%1q\u0010\u0005\n\u0007+\u0003\u0011\u0013!C\u0005\u0007/Cqaa'\u0001\t\u0013\u0019i\nC\u0004\u0004*\u0002!Iaa+\t\u000f\r=\u0006\u0001\"\u0001\u0003>!911\u0017\u0001\u0005\u0002\tu\"a\u0007+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002fM\u0006YAO]1og\u0006\u001cG/[8o\u0015\t9\u0007.A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A5\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0002_\u0006)1oY1mC&\u0011\u0011O\u001c\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\bCA;\u0001\u001b\u0005!\u0017a\u00039beRLG/[8o\u0013\u0012,\u0012\u0001\u001f\t\u0003[fL!A\u001f8\u0003\u0007%sG/\u0001\u0007qCJ$\u0018\u000e^5p]&#\u0007%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\u0006)BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u00185\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0004d_6lwN\u001c\u0006\u0004S\u0006=!\u0002BA\t\u0003'\ta!\u00199bG\",'BAA\u000b\u0003\ry'oZ\u0005\u0005\u00033\tIA\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\n\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002#\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007%\u0001\u0006uq:\u0014VmY8sIN,\"!!\n\u0011\r\u0005\u001d\u0012\u0011GA\u001b\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003_q\u0017AC2pY2,7\r^5p]&!\u00111GA\u0015\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQA!a\u000f\u0002\n\u00051!/Z2pe\u0012LA!a\u0010\u0002:\ta1+[7qY\u0016\u0014VmY8sI\u0006YA\u000f\u001f8SK\u000e|'\u000fZ:!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\t\u00055\u0013\u0011B\u0001\u0006kRLGn]\u0005\u0005\u0003#\nYE\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0002ZA!\u00111LA3\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014\u0001B;uS2TA!a\u0019\u0002\u000e\u000511/\u001a:wKJLA!a\u001a\u0002^\tiQj\\2l'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003!Q8n\u00117jK:$XCAA8!\u0011\t\t(a\u001e\u000e\u0005\u0005M$bAA;Q\u0006\u0011!p[\u0005\u0005\u0003s\n\u0019HA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\nu.\u001cE.[3oi\u0002\naB]3qY&\u001c\u0017-T1oC\u001e,'/\u0006\u0002\u0002\u0002B!\u00111QAD\u001b\t\t)IC\u0002\u0002d!LA!!#\u0002\u0006\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u000f5,GO]5dgV\u0011\u0011\u0011\u0013\t\u0005\u0003'\u000b9*\u0004\u0002\u0002\u0016*!\u0011QRA\u0005\u0013\u0011\tI*!&\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%A\u0005uq:\u001cuN\u001c4jOV\u0011\u0011\u0011\u0015\t\u0004k\u0006\r\u0016bAASI\n\tBK]1og\u0006\u001cG/[8o\u0007>tg-[4\u0002\u0015QDhnQ8oM&<\u0007%\u0001\nue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014XCAAW!\r)\u0018qV\u0005\u0004\u0003c#'a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0003M!(/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:!\u0003A!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017'\u0006\u0002\u0002:B!\u00111XAe\u001d\u0011\ti,!2\u0011\u0007\u0005}f.\u0004\u0002\u0002B*\u0019\u00111\u00196\u0002\rq\u0012xn\u001c;?\u0013\r\t9M\\\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0017Q\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001dg.A\tue\u0006t7/Y2uS>t\u0017\r\\%ec\u0001\n\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u001a\u0002#Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0014\u0004%A\nuq:lUm]:bO\u0016\\U-\u001f\"zi\u0016\u001c\u0018'\u0006\u0002\u0002ZB)Q.a7\u0002`&\u0019\u0011Q\u001c8\u0003\u000b\u0005\u0013(/Y=\u0011\u00075\f\t/C\u0002\u0002d:\u0014AAQ=uK\u0006!B\u000f\u001f8NKN\u001c\u0018mZ3LKf\u0014\u0015\u0010^3tc\u0001\n1\u0003\u001e=o\u001b\u0016\u001c8/Y4f\u0017\u0016L()\u001f;fgJ\nA\u0003\u001e=o\u001b\u0016\u001c8/Y4f\u0017\u0016L()\u001f;fgJ\u0002\u0013a\u00039s_\u0012,8-\u001a:JIN,\"!a<\u0011\u0011\u0005E\u00181_A]\u0003ol!!!\f\n\t\u0005U\u0018Q\u0006\u0002\u0004\u001b\u0006\u0004\bcA7\u0002z&\u0019\u00111 8\u0003\t1{gnZ\u0001\raJ|G-^2fe&#7\u000fI\u0001\ribtW*\u001a;bI\u0006$\u0018-M\u000b\u0003\u0005\u0007\u00012!\u001eB\u0003\u0013\r\u00119\u0001\u001a\u0002\u0014)J\fgn]1di&|g.T3uC\u0012\fG/Y\u0001\u0011ibtW*\u001a;bI\u0006$\u0018-M0%KF$BA!\u0004\u0003\u0014A\u0019QNa\u0004\n\u0007\tEaN\u0001\u0003V]&$\b\"\u0003B\u000bO\u0005\u0005\t\u0019\u0001B\u0002\u0003\rAH%M\u0001\u000eibtW*\u001a;bI\u0006$\u0018-\r\u0011\u0002\u0019QDh.T3uC\u0012\fG/\u0019\u001a\u0002!QDh.T3uC\u0012\fG/\u0019\u001a`I\u0015\fH\u0003\u0002B\u0007\u0005?A\u0011B!\u0006+\u0003\u0003\u0005\rAa\u0001\u0002\u001bQDh.T3uC\u0012\fG/\u0019\u001a!\u00035)\u0007\u0010]3di\u0016$WI\u001d:peV\u0011!q\u0005\t\u0005\u0005S\u0011y#\u0004\u0002\u0003,)!!QFA\u0005\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B\u0019\u0005W\u0011a!\u0012:s_J\u001c\u0018!E3ya\u0016\u001cG/\u001a3FeJ|'o\u0018\u0013fcR!!Q\u0002B\u001c\u0011%\u0011)\"LA\u0001\u0002\u0004\u00119#\u0001\bfqB,7\r^3e\u000bJ\u0014xN\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0005\t5\u0001fA\u0018\u0003BA!!1\tB)\u001b\t\u0011)E\u0003\u0003\u0003H\t%\u0013aA1qS*!!1\nB'\u0003\u001dQW\u000f]5uKJTAAa\u0014\u0002\u0014\u0005)!.\u001e8ji&!!1\u000bB#\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0001G!\u0017\u0011\t\t\r#1L\u0005\u0005\u0005;\u0012)EA\u0005BMR,'/R1dQ\u0006qB/Z:u-\u0006d\u0017\u000eZ1uKR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f\u001e\u0015\u0004c\t\r\u0004\u0003\u0002B\"\u0005KJAAa\u001a\u0003F\t!A+Z:u\u00039!Xm\u001d;BI\u0012<U\r\u001e)jIND3A\rB2\u0003M!Xm\u001d;EK2,G/\u001a)beRLG/[8oQ\r\u0019$1M\u0001\u001bi\u0016\u001cH\u000fR3mKR,Gj\\1eS:<\u0007+\u0019:uSRLwN\u001c\u0015\u0004i\t\r\u0014!\u000b;fgRdu.\u00193B]\u0012\u0014V-\\8wKR\u0013\u0018M\\:bGRLwN\\:G_J\u0004\u0016M\u001d;ji&|g\u000eK\u00026\u0005G\n\u0011\u0006^3ti\u000e{W\u000e\u001d7fi\u0016$&/\u00198tSRLwN\\,iK:\f\u0005\u000f]3oIN+8mY3fI\u0016$\u0007f\u0001\u001c\u0003d\u0005aC/Z:u\u0003B\u0004XM\u001c3GC&dGk\\\"p_J$\u0017N\\1u_Jtu\u000e^!wC&d\u0017M\u00197f\u000bJ\u0014xN\u001d\u0015\u0004o\t\r\u0014a\t;fgR\f\u0005\u000f]3oI\u001a\u000b\u0017\u000e\u001c+p\u001d>$8i\\8sI&t\u0017\r^8s\u000bJ\u0014xN\u001d\u0015\u0004q\t\r\u0014a\n;fgR\f\u0005\u000f]3oI\u001a\u000b\u0017\u000e\u001c+p\u0007>|'\u000fZ5oCR|'\u000fT8bI&tw-\u0012:s_JD3!\u000fB2\u0003q!Xm\u001d;BaB,g\u000e\u001a$bS2$v.\u00168l]><h.\u0012:s_JD3A\u000fB2\u0003\u0015\"Xm\u001d;QK:$\u0017N\\4Ti\u0006$XMT8u%\u0016\u001cX\r^(o%\u0016$(/_!qa\u0016tG\rK\u0002<\u0005G\nQ\u0006^3ti\u0006\u0003\b/\u001a8e)J\fgn]1di&|g\u000eV8M_\u001e<\u0006.\u001b7f!J|G-^2fe\u001a+gnY3eQ\ra$1M\u00013i\u0016\u001cH/\u00119qK:$GK]1og\u0006\u001cG/[8o)>dunZ,iS2,\u0007+\u001a8eS:<7\u000b^1uK\u000eC\u0017M\\4fI\"\u001aQHa\u0019\u0002\u007fMDw.\u001e7e%\u0016$XO\u001d8O_R\u001cun\u001c:eS:\fGo\u001c:FeJ|'/\u00134Ue\u0006t7/Y2uS>t\u0017\n\u001a)beRLG/[8o\u001d>$xj\u001e8fI\"\u001aaHa\u0019\u0002iQ,7\u000f\u001e'jgR$&/\u00198tC\u000e$\u0018n\u001c8t/&$\bnQ8pe\u0012Lg.\u0019;pe2{\u0017\rZ5oO&s\u0007K]8he\u0016\u001c8\u000fK\u0002@\u0005G\nQ\u0004^3ti2K7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u001ch)\u001b7uKJLgn\u001a\u0015\u0004\u0001\n\r\u0014AN:i_VdGm\u00148ms\u000e{gn]5eKJ$&/\u00198tC\u000e$\u0018n\u001c8t\u0013:$\u0006.Z(oO>LgnZ*uCR,Gk\\!c_J$\bfA!\u0003d\u0005A4\u000f[8vY\u0012<&/\u001b;f)btW*\u0019:lKJ\u001chi\u001c:Ue\u0006t7/Y2uS>t\u0017J\u001c)sKB\f'/\u001a3D_6l\u0017\u000e^*uCR,\u0007f\u0001\"\u0003d\u000594\u000f[8vY\u0012<&/\u001b;f)btW*\u0019:lKJ\u001chi\u001c:Ue\u0006t7/Y2uS>t\u0017J\u001c)sKB\f'/\u001a3BE>\u0014Ho\u0015;bi\u0016D3a\u0011B2\u0003E\u001a\bn\\;mIJ+Wn\u001c<f\u0007>l\u0007\u000f\\3uK\u000e{W.\\5u\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JIND3\u0001\u0012B2\u0003A\u001a\bn\\;mIJ+Wn\u001c<f\u0007>l\u0007\u000f\\3uK\u0006\u0013wN\u001d;FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%eg\"\u001aQIa\u0019\u0002QMDw.\u001e7e%\u0016lwN^3F[B$\u00180\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:)\u0007\u0019\u0013\u0019'\u0001\u001ctQ>,H\u000e\u001a(piJ+Wn\u001c<f\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JINLe\rT8h\u0003B\u0004XM\u001c3GC&d7\u000fK\u0002H\u0005G\nae\u001d5pk2$gj\u001c;SK6|g/Z(oO>Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\rA%1M\u0001,g\"|W\u000f\u001c3O_R\u0014V-\\8wKB\u0013X\r]1sK\u0006\u0013wN\u001d;Ue\u0006t7/Y2uS>t\u0017\r\\%eg\"\u001a\u0011Ja\u0019\u0002YMDw.\u001e7e\u001d>$(+Z7pm\u0016\u0004&/\u001a9be\u0016\u001cu.\\7jiR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\bf\u0001&\u0003d\u0005\u0001D/Z:u)J\fgn]1di&|g.\u00197FqBL'/\u0019;j_:<\u0016\u000e\u001e5U_>\u001cV.\u00197m\u0005\u0006$8\r[*ju\u0016D3a\u0013B2\u00031\"Xm\u001d;Ue\u0006t7/Y2uS>t\u0017\r\\#ya&\u0014\u0018\r^5p]^KG\u000f[(gM2Lg.\u001a'pO\u0012K'\u000fK\u0002M\u0005G\nq\u0006^3tiR\u0013\u0018M\\:bGRLwN\\#ya&\u0014\u0018\r^5p]NCw.\u001e7e%\u0016\u001c\b/Z2u\u0005\u0006$8\r[*ju\u0016D3!\u0014B2\u0003)#Xm\u001d;Ue\u0006t7/Y2uS>tW\t\u001f9je\u0006$\u0018n\u001c8TQ>,H\u000e\u001a(pi\u001a\u000b\u0017\u000e\\,ji\",f.\u001b8ji&\fG.\u001b>fIR\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1)\u00079\u0013\u0019'A\u0013d_2dWm\u0019;Ue\u0006t7/Y2uS>t\u0017\r\\%eg\u001a\u0013x.\u001c+p[\n\u001cHo\u001c8fgR!!\u0011\u001dBt!\u0019\tYLa9\u0002:&!!Q]Ag\u0005\r\u0019V\r\u001e\u0005\b\u0005S|\u0005\u0019\u0001Bv\u0003=\t\u0007\u000f]3oI\u0016$'+Z2pe\u0012\u001c\b\u0003CA\u0014\u0005[\f)Aa<\n\t\u0005U\u0018\u0011\u0006\t\u0007\u0003O\u0011\tP!>\n\t\tM\u0018\u0011\u0006\u0002\u0007\u0005V4g-\u001a:\u0011\t\u0005]\"q_\u0005\u0005\u0005s\fIDA\u0007NK6|'/\u001f*fG>\u0014Hm]\u0001\u001cY>\fG-\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:\u0015\t\t\u0005(q \u0005\u0007\u0007\u0003\u0001\u0006\u0019\u0001=\u0002'9,X\u000e\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:\u0002;1L7\u000f^#ya&\u0014\u0018M\u00197f)J\fgn]1di&|g.\u00197JIN$\"A!9\u00027Q,7\u000f^*vG\u000e,7o\u001d4vYJ+\u0017.\\7jOJ\fG/[8oQ\r\u0011&1M\u0001,i\u0016\u001cH\u000fT8bIR\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1XSRD7i\u001c:skB$X\r\u001a'pO\"\u001a1Ka\u0019\u0002EY,'/\u001b4z\u001b\u0016$\u0018\rZ1uC\u0012{Wm]#ySN$\u0018I\u001c3JgV\u001b\u0018M\u00197f)\u0011\u0011iaa\u0005\t\u000f\rUA\u000b1\u0001\u0002:\u0006yAO]1og\u0006\u001cG/[8oC2LE-A\rwKJLg-_'fi\u0006$\u0017\r^1E_\u0016\u001ch\u000e^#ySN$H\u0003\u0002B\u0007\u00077Aqa!\u0006V\u0001\u0004\tI,A\u0010fqB,7\r\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:$bA!\u0004\u0004\"\r\u0015\u0002bBB\u0012-\u0002\u0007!qE\u0001\fCB\u0004XM\u001c3FeJ|'\u000fC\u0004\u0004(Y\u0003\rAa;\u0002\u001f\r\f\u0007\u000f^;sK\u0012\f\u0005\u000f]3oIN\fQ\u0004\\8bIR\u0013\u0018M\\:bGRLwN\\:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0005\u001b\u0019i\u0003C\u0004\u00040]\u0003\ra!\r\u0002\u0019A\f'\u000f^5uS>t\u0017\nZ:\u0011\u000b\rM2Q\b=\u000f\t\rU2\u0011\b\b\u0005\u0003\u007f\u001b9$C\u0001p\u0013\r\u0019YD\\\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019yd!\u0011\u0003\u0007M+\u0017OC\u0002\u0004<9\fq\"\u001a=qK\u000e$Hj\\4D_:4\u0017n\u001a\u000b\u0007\u0005\u001b\u00199e!\u0013\t\u000f\r=\u0002\f1\u0001\u00042!111\n-A\u0002a\fA\"\\1y\u0005\u0006$8\r[*ju\u0016\fAe]3ukB\fe\u000e\u001a*v]R\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0005\u0010]5sCRLwN\u001c\u000b\u0007\u0005\u001b\u0019\tf!\u0016\t\u000f\rM\u0013\f1\u0001\u0003(\u0005)QM\u001d:pe\"91qK-A\u0002\re\u0013\u0001\u0003;y]N#\u0018\r^3\u0011\u0007U\u001cY&C\u0002\u0004^\u0011\u0014\u0001\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3\u0002IY,'/\u001b4z/JLG/Z:Uq:l\u0015M]6feNLe\u000e\u0015:fa\u0006\u0014Xm\u0015;bi\u0016$BA!\u0004\u0004d!91Q\r.A\u0002\re\u0013!B:uCR,\u0017AD1tg\u0016\u0014HoQ1mY\n\f7m\u001b\u000b\u0005\u0005\u001b\u0019Y\u0007C\u0004\u0004Tm\u0003\rAa\n\u0002'Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0015\u0015\t\r1\u0011OB:\u0007o\u001aI\bC\u0004\u0004\u0016q\u0003\r!!/\t\u000f\rUD\f1\u0001\u0002x\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u0013\r\u0015D\f%AA\u0002\re\u0003\u0002CB>9B\u0005\t\u0019\u0001=\u0002\u0015QDh\u000eV5nK>,H/A\u000fue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019\tI\u000b\u0003\u0004Z\r\r5FABC!\u0011\u00199i!%\u000e\u0005\r%%\u0002BBF\u0007\u001b\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r=e.\u0001\u0006b]:|G/\u0019;j_:LAaa%\u0004\n\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002;Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIQ*\"a!'+\u0007a\u001c\u0019)A\u0007qe\u0016\u0004\u0018M]3Uq:dun\u001a\u000b\t\u0005\u001b\u0019yj!)\u0004&\"9\u0011\u0011A0A\u0002\u0005\u0015\u0001bBBR?\u0002\u0007\u0011q_\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0004\u0004(~\u0003\rA!>\u0002\u000fI,7m\u001c:eg\u0006Q\u0002O]3qCJ,gi\u001c:Uq:lUm]:bO\u0016\f\u0005\u000f]3oIR!!QBBW\u0011\u001d\u0019\u0019\u0006\u0019a\u0001\u0005O\tq\u0003^3tiB\u000b'\u000f^5uS>tGj\\1e\u001b\u0016$(/[2)\u0007\u0005\u0014\u0019'A\u000euKN$\u0018j\u001a8pe\u0016,fn\u001b8po:\u0014VmY8sIRK\b/\u001a\u0015\u0004E\n\r\u0004")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final Metrics metrics;
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.transactionManager().startup((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.numPartitions(), false);
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId1()));
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @AfterEach
    public void tearDown() {
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2()));
    }

    @Test
    public void testDeletePartition() {
        TransactionMetadata metadata1 = this.transactionMetadata("b", 5L, this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        TransactionMetadata metadata2 = this.transactionMetadata("a", 10L, this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        Assertions.assertEquals((int)0, (int)this.transactionManager().partitionFor(metadata1.transactionalId()));
        Assertions.assertEquals((int)1, (int)this.transactionManager().partitionFor(metadata2.transactionalId()));
        this.transactionManager().addLoadedTransactionsToCache(0, this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(metadata1);
        this.transactionManager().addLoadedTransactionsToCache(1, this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(metadata2);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata1.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
        this.transactionManager().removeTransactionsForTxnTopicPartition(0);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
    }

    @Test
    public void testDeleteLoadingPartition() {
        long startOffset = 0L;
        long endOffset = 1L;
        FileRecords fileRecordsMock = (FileRecords)Mockito.mock(FileRecords.class);
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicPartition())).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecordsMock));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()))});
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecordsMock.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            latch.await();
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(records.buffer().duplicate());
            return buffer.flip();
        });
        int coordinatorEpoch = 0;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(this.partitionId(), coordinatorEpoch);
        Thread loadingThread = new Thread(() -> this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), coordinatorEpoch, (Function4 & Serializable & scala.Serializable)(x$3, x$4, x$5, x$6) -> {
            TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$3(BoxesRunTime.unboxToInt((Object)x$3), x$4, x$5, x$6);
            return BoxedUnit.UNIT;
        }));
        loadingThread.start();
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$4(this, partitionAndLeaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId());
        Assertions.assertFalse((boolean)this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch));
        latch.countDown();
        loadingThread.join();
        Assertions.assertEquals((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR), (Object)this.transactionManager().getTransactionState(this.txnMetadata1().transactionalId()));
    }

    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$7 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$8 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId2()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$9, x$10, x$11, x$12) -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$5(BoxesRunTime.unboxToInt((Object)x$9), x$10, x$11, x$12);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString()), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString())));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            throw new AssertionError((Object)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString());
        }, (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString());
        }));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            throw new AssertionError((Object)new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state access returns error ").append(err).toString());
        }, (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(50).append(this.transactionalId2()).append("'s transaction state was not loaded into the cache").toString());
        }));
        Assertions.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assertions.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$13 -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state is still in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$14 -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state is still in the cache").toString()));
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        String x$1 = this.transactionalId1();
        int x$2 = this.coordinatorEpoch();
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, newMetadata, (Function1)x$4, x$6, x$5);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        String x$7 = this.transactionalId1();
        int x$8 = 10;
        Function1 & Serializable & scala.Serializable x$10 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, x$8, failedMetadata, (Function1)x$10, x$12, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        String x$13 = this.transactionalId1();
        int x$14 = 10;
        Function1 & Serializable & scala.Serializable x$16 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$18 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$13, x$14, failedMetadata, (Function1)x$16, x$18, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        String x$19 = this.transactionalId1();
        int x$20 = 10;
        Function1 & Serializable & scala.Serializable x$22 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$24 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$19, x$20, failedMetadata, (Function1)x$22, x$24, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_OR_FOLLOWER);
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        String x$7 = this.transactionalId1();
        int x$8 = 10;
        Function1 & Serializable & scala.Serializable x$10 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, x$8, failedMetadata, (Function1)x$10, x$12, requestLocal);
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        String x$13 = this.transactionalId1();
        int x$14 = 10;
        Function1 & Serializable & scala.Serializable x$16 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$18 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$13, x$14, failedMetadata, (Function1)x$16, x$18, requestLocal);
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        String x$19 = this.transactionalId1();
        int x$20 = 10;
        Function1 & Serializable & scala.Serializable x$22 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$24 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$19, x$20, failedMetadata, (Function1)x$22, x$24, requestLocal);
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, failedMetadata, (Function1)x$4, x$6, x$5);
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        String x$7 = this.transactionalId1();
        int x$8 = 10;
        Function1 & Serializable & scala.Serializable x$10 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, x$8, failedMetadata, (Function1)x$10, x$12, requestLocal);
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testPendingStateNotResetOnRetryAppend$2(x$15)), RequestLocal$.MODULE$.withThreadConfinedCaching());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        String x$1 = this.transactionalId1();
        int x$2 = 10;
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, newMetadata, (Function1)x$4, x$6, x$5);
    }

    @Test
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> {
            String x$1 = this.transactionalId1();
            int x$2 = 10;
            Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
                this.assertCallback(error);
                return BoxedUnit.UNIT;
            };
            RequestLocal x$5 = RequestLocal$.MODULE$.withThreadConfinedCaching();
            Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
            this.transactionManager().appendTransactionToLog(x$1, x$2, newMetadata, (Function1)x$4, x$6, x$5);
        });
    }

    @Test
    public void shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned() {
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$16 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
    }

    @Test
    public void testListTransactionsWithCoordinatorLoadingInProgress() {
        this.transactionManager().addLoadingPartition(0, 15);
        ListTransactionsResponseData listResponse = this.transactionManager().listTransactionStates(Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Set().empty());
        Assertions.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)Errors.forCode((short)listResponse.errorCode()));
    }

    @Test
    public void testListTransactionsFiltering() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        this.putTransaction$1("t0", 0L, (TransactionState)Ongoing$.MODULE$);
        this.putTransaction$1("t1", 1L, (TransactionState)Ongoing$.MODULE$);
        this.putTransaction$1("t2", 2L, (TransactionState)PrepareCommit$.MODULE$);
        this.putTransaction$1("t3", 3L, (TransactionState)PrepareAbort$.MODULE$);
        this.putTransaction$1("t4", 4L, (TransactionState)CompleteCommit$.MODULE$);
        this.putTransaction$1("t5", 5L, (TransactionState)CompleteAbort$.MODULE$);
        this.putTransaction$1("t6", 6L, (TransactionState)CompleteAbort$.MODULE$);
        this.putTransaction$1("t7", 7L, (TransactionState)PrepareEpochFence$.MODULE$);
        this.putTransaction$1("t8", 8L, (TransactionState)Dead$.MODULE$);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1", "t2", "t3", "t4", "t5", "t6", "t7"})), TransactionStateManagerTest.assertListTransactions$default$2$1(), TransactionStateManagerTest.assertListTransactions$default$3$1());
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1"}));
        scala.collection.immutable.Set x$2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ongoing"}));
        scala.collection.immutable.Set x$3 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$1, x$3, x$2);
        scala.collection.immutable.Set x$4 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1"}));
        scala.collection.immutable.Set x$5 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ongoing", "UnknownState"}));
        scala.collection.immutable.Set x$6 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$4, x$6, x$5);
        scala.collection.immutable.Set x$7 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2", "t4"}));
        scala.collection.immutable.Set x$8 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PrepareCommit", "CompleteCommit"}));
        scala.collection.immutable.Set x$9 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$7, x$9, x$8);
        scala.collection.immutable.Set x$10 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Set x$11 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnknownState"}));
        scala.collection.immutable.Set x$12 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$10, x$12, x$11);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t5"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5L})), TransactionStateManagerTest.assertListTransactions$default$3$1());
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t5", "t6"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5L, 6L, 8L, 9L})), TransactionStateManagerTest.assertListTransactions$default$3$1());
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t4"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{4L, 5L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit"})));
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t4", "t5"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{4L, 5L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit", "CompleteAbort"})));
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{3L, 6L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnknownState"})));
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{10L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit"})));
        scala.collection.immutable.Set x$13 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Set x$14 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dead"}));
        scala.collection.immutable.Set x$15 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        this.assertListTransactions$1(x$13, x$15, x$14);
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assertions.assertEquals((Object)new .colon.colon((Object)new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0), (List)Nil$.MODULE$), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void testTransactionalExpirationWithTooSmallBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 16;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map attemptedAppends = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.MESSAGE_TOO_LARGE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)attemptedAppends);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any());
        attemptedAppends.values().foreach((Function1 & Serializable & scala.Serializable)batches -> {
            batches.foreach((Function1 & Serializable & scala.Serializable)batch -> {
                TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(maxBatchSize$1, batch);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionalExpirationWithOfflineLogDir() {
        void var9_9;
        void var8_8;
        int onlinePartitionId = 0;
        int offlinePartitionId = 1;
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId, offlinePartitionId}));
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId}))), maxBatchSize);
        Mockito.when((Object)this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", offlinePartitionId))).thenReturn((Object)None$.MODULE$);
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId})), (Object)appendedRecords.keySet().map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.partition()), scala.collection.Set$.MODULE$.canBuildFrom()));
        Tuple2 tuple2 = allTransactionalIds.partition((Function1 & Serializable & scala.Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithOfflineLogDir$2(this, onlinePartitionId, transactionalId)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set transactionalIdsForOnlinePartition = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set transactionalIdsForOfflinePartition = (scala.collection.immutable.Set)tuple2._2();
        void transactionalIdsForOnlinePartition2 = var8_8;
        void transactionalIdsForOfflinePartition2 = var9_9;
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals((Object)transactionalIdsForOnlinePartition2, expiredTransactionalIds);
        Assertions.assertEquals((Object)transactionalIdsForOfflinePartition2, this.listExpirableTransactionalIds());
    }

    @Test
    public void testTransactionExpirationShouldRespectBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(1000);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.listExpirableTransactionalIds());
        Assertions.assertEquals((Object)partitionIds.toSet(), (Object)appendedRecords.keys().map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.partition()), Iterable$.MODULE$.canBuildFrom()));
        appendedRecords.values().foreach((Function1 & Serializable & scala.Serializable)batches -> {
            TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$2(maxBatchSize, batches);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, expiredTransactionalIds);
    }

    @Test
    public void testTransactionExpirationShouldNotFailWithUninitializedTransactionMetadata() {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 512;
        String transactionalId = "id";
        scala.collection.immutable.Set allTransactionalIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{transactionalId}));
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, 1L, (short)-1, this.transactionTimeoutMs(), (TransactionState)Empty$.MODULE$, this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(txnMetadata);
        this.time().sleep((long)(this.txnConfig().transactionalIdExpirationMs() + 1));
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any());
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals((Object)allTransactionalIds, expiredTransactionalIds);
    }

    private scala.collection.immutable.Set<String> collectTransactionalIdsFromTombstones(scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> appendedRecords) {
        scala.collection.mutable.Set expiredTransactionalIds = Set$.MODULE$.empty();
        appendedRecords.values().foreach((Function1 & Serializable & scala.Serializable)batches -> {
            batches.foreach((Function1 & Serializable & scala.Serializable)records -> {
                TransactionStateManagerTest.$anonfun$collectTransactionalIdsFromTombstones$2($this, expiredTransactionalIds$1, records);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return expiredTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> loadExpiredTransactionalIds(int numTransactionalIds) {
        scala.collection.mutable.Set allTransactionalIds = Set$.MODULE$.empty();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numTransactionalIds).foreach((Function1 & Serializable & scala.Serializable)i -> TransactionStateManagerTest.$anonfun$loadExpiredTransactionalIds$1(this, allTransactionalIds, BoxesRunTime.unboxToInt((Object)i)));
        return allTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> listExpirableTransactionalIds() {
        return ((TraversableOnce)((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.transactionManager().listTransactionStates(Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Set().empty()).transactionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.transactionalId(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$listExpirableTransactionalIds$2(this, transactionalId)))).toSet();
    }

    @Test
    public void testSuccessfulReimmigration() {
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$23, x$24, x$25, x$26) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$1(BoxesRunTime.unboxToInt((Object)x$23), x$24, x$25, x$26);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable & scala.Serializable)(x$27, x$28, x$29, x$30) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$2(BoxesRunTime.unboxToInt((Object)x$27), x$28, x$29, x$30);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        Assertions.assertTrue((boolean)this.transactionManager().transactionMetadataCache().contains((Object)BoxesRunTime.boxToInteger((int)this.partitionId())));
        Assertions.assertEquals((int)1, (int)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId()))).coordinatorEpoch());
    }

    @Test
    public void testLoadTransactionMetadataWithCorruptedLog() {
        long startOffset = 0L;
        long endOffset = 10L;
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicPartition())).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)MemoryRecords.EMPTY));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$31, x$32, x$33, x$34) -> {
            TransactionStateManagerTest.$anonfun$testLoadTransactionMetadataWithCorruptedLog$1(BoxesRunTime.unboxToInt((Object)x$31), x$32, x$33, x$34);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).getLog(this.topicPartition());
        ((UnifiedLog)Mockito.verify((Object)logMock)).logStartOffset();
        ((UnifiedLog)Mockito.verify((Object)logMock)).read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true));
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.times((int)2))).getLogEndOffset(this.topicPartition());
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
    }

    private void verifyMetadataDoesExistAndIsUsable(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Assertions.assertTrue((boolean)((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata().pendingState().isEmpty(), (String)"metadata shouldn't be in a pending state");
            return;
        }
        throw new MatchError((Object)either);
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            if ((Option)right.value() instanceof Some) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
            return;
        }
        throw new MatchError((Object)either);
    }

    private void expectTransactionalIdExpiration(Errors appendError, scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> capturedAppends) {
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        this.replicaManager().appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)recordsCapture.capture(), (Function1)callbackCapture.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$35 -> {
            TransactionStateManagerTest.$anonfun$expectTransactionalIdExpiration$1(callbackCapture, recordsCapture, capturedAppends, appendError, x$35);
            return BoxedUnit.UNIT;
        });
    }

    private void loadTransactionsForPartitions(Seq<Object> partitionIds) {
        partitionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
    }

    private void expectLogConfig(Seq<Object> partitionIds, int maxBatchSize) {
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logConfig.maxMessageSize())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxBatchSize));
        partitionIds.foreach((Function1 & Serializable & scala.Serializable)partitionId -> TransactionStateManagerTest.$anonfun$expectLogConfig$1(this, logConfig, BoxesRunTime.unboxToInt((Object)partitionId)));
    }

    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        Range partitionIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        this.expectLogConfig((Seq<Object>)partitionIds, 0x10000C);
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2());
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(error, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        this.transactionManager().removeExpiredTransactionalIds();
        if (Empty$.MODULE$.equals(txnState) ? true : (CompleteCommit$.MODULE$.equals(txnState) ? true : CompleteAbort$.MODULE$.equals(txnState))) {
            int partitionId = this.transactionManager().partitionFor(this.transactionalId1());
            TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
            SimpleRecord expectedTombstone = new SimpleRecord(this.time().milliseconds(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null);
            MemoryRecords expectedRecords = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{expectedTombstone});
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})), (Object)appendedRecords.keySet());
            Assertions.assertEquals((Object)new .colon.colon((Object)expectedRecords, (List)Nil$.MODULE$), (Object)((SeqLike)appendedRecords.apply((Object)topicPartition)).toSeq());
            return;
        }
        Assertions.assertEquals((Object)scala.collection.Map$.MODULE$.empty(), (Object)appendedRecords);
    }

    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(coordinatorEpoch, command, metadata, newMetadata) -> {
            TransactionStateManagerTest.rememberTxnMarkers$1(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), command, metadata, newMetadata, txnId);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    private void assertCallback(Errors error) {
        Assertions.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records) {
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        FileRecords fileRecordsMock = (FileRecords)Mockito.mock(FileRecords.class);
        long endOffset = startOffset + (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        Mockito.when((Object)this.replicaManager().getLog(topicPartition)).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(topicPartition)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecordsMock));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecordsMock.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$36 -> {
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(records.buffer().duplicate());
            return buffer.flip();
        });
    }

    private void prepareForTxnMessageAppend(Errors error) {
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        ArgumentCaptor capturedArgument = ArgumentCaptor.forClass(Function1.class);
        this.replicaManager().appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)capturedArgument.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$37 -> {
            TransactionStateManagerTest.$anonfun$prepareForTxnMessageAppend$1(this, capturedArgument, error, x$37);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.replicaManager().getMagic((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
    }

    @Test
    public void testPartitionLoadMetric() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.server");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics().addReporter((MetricsReporter)reporter);
        Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName), (double)0.0);
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName), (double)0.0);
        Assertions.assertTrue((boolean)reporter.containsMbean(mBeanName));
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$38, x$39, x$40, x$41) -> {
            TransactionStateManagerTest.$anonfun$testPartitionLoadMetric$1(BoxesRunTime.unboxToInt((Object)x$38), x$39, x$40, x$41);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testIgnoreUnknownRecordType() {
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 0L;
        TransactionLogKey unknownKey = new TransactionLogKey();
        byte[] unknownMessage = MessageUtil.toVersionPrefixedBytes((short)Short.MAX_VALUE, (Message)unknownKey);
        SimpleRecord unknownRecord = new SimpleRecord(unknownMessage, unknownMessage);
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)new .colon.colon((Object)unknownRecord, (List)Nil$.MODULE$).$plus$plus(this.txnRecords(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable & scala.Serializable)(x$42, x$43, x$44, x$45) -> {
            TransactionStateManagerTest.$anonfun$testIgnoreUnknownRecordType$1(BoxesRunTime.unboxToInt((Object)x$42), x$43, x$44, x$45);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        Assertions.assertTrue((boolean)this.transactionManager().transactionMetadataCache().contains((Object)BoxesRunTime.boxToInteger((int)this.partitionId())));
        Pool txnMetadataPool = ((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId()))).metadataPerTransactionalId();
        Assertions.assertFalse((boolean)txnMetadataPool.isEmpty());
        Assertions.assertTrue((boolean)txnMetadataPool.contains((Object)this.transactionalId1()));
        TransactionMetadata txnMetadata = (TransactionMetadata)txnMetadataPool.get((Object)this.transactionalId1());
        Assertions.assertEquals((Object)this.txnMetadata1().transactionalId(), (Object)txnMetadata.transactionalId());
        Assertions.assertEquals((long)this.txnMetadata1().producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((long)this.txnMetadata1().lastProducerId(), (long)txnMetadata.lastProducerId());
        Assertions.assertEquals((short)this.txnMetadata1().producerEpoch(), (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)this.txnMetadata1().lastProducerEpoch(), (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((int)this.txnMetadata1().txnTimeoutMs(), (int)txnMetadata.txnTimeoutMs());
        Assertions.assertEquals((Object)this.txnMetadata1().state(), (Object)txnMetadata.state());
        Assertions.assertEquals((Object)this.txnMetadata1().topicPartitions(), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((int)1, (int)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId()))).coordinatorEpoch());
    }

    public static final /* synthetic */ short $anonfun$testDeletePartition$1(CoordinatorEpochAndTxnMetadata x$1) {
        return x$1.transactionMetadata().producerEpoch();
    }

    private final Option cachedProducerEpoch$1(String transactionalId) {
        return this.transactionManager().getTransactionState(transactionalId).toOption().flatten(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToShort((short)TransactionStateManagerTest.$anonfun$testDeletePartition$1(x$1)));
    }

    public static final /* synthetic */ void $anonfun$testDeleteLoadingPartition$3(int x$3, TransactionResult x$4, TransactionMetadata x$5, TxnTransitMetadata x$6) {
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLoadingPartition$4(TransactionStateManagerTest $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ String $anonfun$testDeleteLoadingPartition$5() {
        return "Timed out waiting for loading partition";
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$3(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$5(int x$9, TransactionResult x$10, TransactionMetadata x$11, TxnTransitMetadata x$12) {
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$15(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$17(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ boolean $anonfun$testPendingStateNotResetOnRetryAppend$2(Errors x$15) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    private final void putTransaction$1(String transactionalId, long producerId, TransactionState state) {
        TransactionMetadata txnMetadata = this.transactionMetadata(transactionalId, producerId, state, this.transactionMetadata$default$4());
        this.transactionManager().putTransactionStateIfNotExists(txnMetadata).left().toOption().foreach((Function1 & Serializable & scala.Serializable)error -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Failed to insert transaction ").append(txnMetadata).append(" due to error ").append(error).toString()));
    }

    public static final /* synthetic */ boolean $anonfun$testListTransactionsFiltering$4(String state) {
        return TransactionState$.MODULE$.fromName(state).isEmpty();
    }

    private final void assertListTransactions$1(scala.collection.immutable.Set expectedTransactionalIds, scala.collection.immutable.Set filterProducerIds, scala.collection.immutable.Set filterStates) {
        ListTransactionsResponseData listResponse = this.transactionManager().listTransactionStates(filterProducerIds, filterStates);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)listResponse.errorCode()));
        Assertions.assertEquals((Object)expectedTransactionalIds, (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(listResponse.transactionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.transactionalId(), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)filterStates.filter((Function1 & Serializable & scala.Serializable)state -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testListTransactionsFiltering$4(state)))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(listResponse.unknownStateFilters()).asScala()).toSet());
    }

    private static final scala.collection.immutable.Set assertListTransactions$default$2$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final scala.collection.immutable.Set assertListTransactions$default$3$1() {
        return Predef$.MODULE$.Set().empty();
    }

    public static final /* synthetic */ void $anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(int maxBatchSize$1, MemoryRecords batch) {
        Assertions.assertTrue((batch.sizeInBytes() > maxBatchSize$1 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionalExpirationWithOfflineLogDir$2(TransactionStateManagerTest $this, int onlinePartitionId$1, String transactionalId) {
        return $this.transactionManager().partitionFor(transactionalId) == onlinePartitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionExpirationShouldRespectBatchSize$3(int maxBatchSize$2, MemoryRecords x$21) {
        return x$21.sizeInBytes() < maxBatchSize$2;
    }

    public static final /* synthetic */ void $anonfun$testTransactionExpirationShouldRespectBatchSize$2(int maxBatchSize$2, Buffer batches) {
        Assertions.assertTrue((batches.size() > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)batches.forall((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$3(maxBatchSize$2, x$21))));
    }

    public static final /* synthetic */ void $anonfun$collectTransactionalIdsFromTombstones$2(TransactionStateManagerTest $this, scala.collection.mutable.Set expiredTransactionalIds$1, MemoryRecords records) {
        records.records().forEach(record -> {
            String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
            Assertions.assertNull((Object)record.value());
            expiredTransactionalIds$1.$plus$eq((Object)transactionalId);
            Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)$this.transactionManager().getTransactionState(transactionalId));
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$loadExpiredTransactionalIds$1(TransactionStateManagerTest $this, scala.collection.mutable.Set allTransactionalIds$1, int i) {
        String txnlId = new StringBuilder(3).append("id_").append(i).toString();
        TransactionMetadata txnMetadata = $this.transactionMetadata(txnlId, i, $this.transactionMetadata$default$3(), $this.transactionMetadata$default$4());
        txnMetadata.txnLastUpdateTimestamp_$eq($this.time().milliseconds() - (long)$this.txnConfig().transactionalIdExpirationMs());
        $this.transactionManager().putTransactionStateIfNotExists(txnMetadata);
        return (scala.collection.mutable.Set)allTransactionalIds$1.$plus$eq((Object)txnlId);
    }

    public static final /* synthetic */ boolean $anonfun$listExpirableTransactionalIds$2(TransactionStateManagerTest $this, String transactionalId) {
        Option option;
        Either either = $this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Right && (option = (Option)((Right)either).value()) instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
            return $this.time().milliseconds() - txnMetadata.txnLastUpdateTimestamp() >= (long)$this.txnConfig().transactionalIdExpirationMs() && txnMetadata.state().isExpirationAllowed() && txnMetadata.pendingState().isEmpty();
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$1(int x$23, TransactionResult x$24, TransactionMetadata x$25, TxnTransitMetadata x$26) {
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$2(int x$27, TransactionResult x$28, TransactionMetadata x$29, TxnTransitMetadata x$30) {
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionMetadataWithCorruptedLog$1(int x$31, TransactionResult x$32, TransactionMetadata x$33, TxnTransitMetadata x$34) {
    }

    public static final /* synthetic */ void $anonfun$expectTransactionalIdExpiration$1(ArgumentCaptor callbackCapture$1, ArgumentCaptor recordsCapture$1, scala.collection.mutable.Map capturedAppends$1, Errors appendError$1, InvocationOnMock x$35) {
        ((Function1)callbackCapture$1.getValue()).apply((Object)((TraversableOnce)((TraversableLike)recordsCapture$1.getValue()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                MemoryRecords records = (MemoryRecords)x0$1._2();
                ((Buffer)capturedAppends$1.getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> {
                    Buffer batches = (Buffer)Buffer$.MODULE$.empty();
                    capturedAppends$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)batches));
                    return batches;
                })).$plus$eq((Object)records);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ProduceResponse.PartitionResponse(appendError$1, 0L, -1L, 0L));
            }
            throw new MatchError(null);
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$expectLogConfig$1(TransactionStateManagerTest $this, LogConfig logConfig$1, int partitionId) {
        return Mockito.when((Object)$this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", partitionId))).thenReturn((Object)new Some((Object)logConfig$1));
    }

    private static final void rememberTxnMarkers$1(int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = metadata.transactionalId();
    }

    public static final /* synthetic */ void $anonfun$prepareForTxnMessageAppend$1(TransactionStateManagerTest $this, ArgumentCaptor capturedArgument$1, Errors error$1, InvocationOnMock x$37) {
        ((Function1)capturedArgument$1.getValue()).apply((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", $this.partitionId())), (Object)new ProduceResponse.PartitionResponse(error$1, 0L, -1L, 0L))})));
    }

    private static final double partitionLoadTime$1(String attribute, MBeanServer server$1, String mBeanName$1) {
        return BoxesRunTime.unboxToDouble((Object)server$1.getAttribute(new ObjectName(mBeanName$1), attribute));
    }

    public static final /* synthetic */ void $anonfun$testPartitionLoadMetric$1(int x$38, TransactionResult x$39, TransactionMetadata x$40, TxnTransitMetadata x$41) {
    }

    public static final /* synthetic */ void $anonfun$testIgnoreUnknownRecordType$1(int x$42, TransactionResult x$43, TransactionMetadata x$44, TxnTransitMetadata x$45) {
    }

    public TransactionStateManagerTest() {
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        Mockito.when((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions())));
        this.metrics = new Metrics();
        this.txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
        this.transactionManager = new TransactionStateManager(0, (Scheduler)this.scheduler(), this.replicaManager(), this.txnConfig(), (Time)this.time(), this.metrics());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        this.producerIds = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1()), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2()), (Object)BoxesRunTime.boxToLong((long)2L))}));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.expectedError = Errors.NONE;
    }
}

