/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LocalLogTest;
import kafka.log.LocalLogTest$KeyValue$;
import kafka.log.LogTestUtils$;
import kafka.log.LogTruncation;
import kafka.log.SegmentDeletionReason;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011]b\u0001\u00025j\u00019DQ!\u001e\u0001\u0005\u0002YD\u0011\"\u001f\u0001A\u0002\u0003\u0007I\u0011\u0001>\t\u0017\u0005\r\u0001\u00011AA\u0002\u0013\u0005\u0011Q\u0001\u0005\u000b\u0003#\u0001\u0001\u0019!A!B\u0013Y\b\"CA\n\u0001\t\u0007I\u0011AA\u000b\u0011!\t9\u0003\u0001Q\u0001\n\u0005]\u0001\"CA\u0015\u0001\t\u0007I\u0011AA\u000b\u0011!\tY\u0003\u0001Q\u0001\n\u0005]\u0001\"CA\u0017\u0001\t\u0007I\u0011AA\u0018\u0011!\t9\u0005\u0001Q\u0001\n\u0005E\u0002\"CA%\u0001\t\u0007I\u0011AA&\u0011!\ty\u0006\u0001Q\u0001\n\u00055\u0003\"CA1\u0001\t\u0007I\u0011AA2\u0011!\t\u0019\b\u0001Q\u0001\n\u0005\u0015\u0004\u0002\u00036\u0001\u0005\u0004%\t!!\u001e\t\u0011\u0005u\u0004\u0001)A\u0005\u0003oBq!a \u0001\t\u0003\t\t\tC\u0004\u0002\u001a\u0002!\t!!!\u0007\r\u0005\r\u0006\u0001QAS\u0011)\t\u0019l\u0005BK\u0002\u0013\u0005\u0011Q\u0017\u0005\u000b\u0003\u001b\u001c\"\u0011#Q\u0001\n\u0005]\u0006BCAh'\tU\r\u0011\"\u0001\u00026\"Q\u0011\u0011[\n\u0003\u0012\u0003\u0006I!a.\t\rU\u001cB\u0011AAj\u0011\u001d\tin\u0005C\u0001\u0003?D\u0011\"!@\u0014#\u0003%\t!a@\t\u0013\tU1#!A\u0005\u0002\t]\u0001\"\u0003B\u000f'E\u0005I\u0011\u0001B\u0010\u0011%\u0011\u0019cEI\u0001\n\u0003\u0011y\u0002C\u0005\u0003&M\t\t\u0011\"\u0011\u0003(!I!1G\n\u0002\u0002\u0013\u0005!Q\u0007\u0005\n\u0005{\u0019\u0012\u0011!C\u0001\u0005\u007fA\u0011B!\u0013\u0014\u0003\u0003%\tEa\u0013\t\u0013\te3#!A\u0005\u0002\tm\u0003\"\u0003B3'\u0005\u0005I\u0011\tB4\u0011%\u0011IgEA\u0001\n\u0003\u0012Y\u0007C\u0005\u0003nM\t\t\u0011\"\u0011\u0003p\u001d9!1\u000f\u0001\t\u0002\tUdaBAR\u0001!\u0005!q\u000f\u0005\u0007k\u001e\"\tA!\u001f\t\u000f\tmt\u0005\"\u0001\u0003~!I!qQ\u0014\u0002\u0002\u0013\u0005%\u0011\u0012\u0005\n\u0005\u001f;\u0013\u0011!CA\u0005#CqAa)\u0001\t\u0013\u0011)\u000bC\u0004\u0003@\u0002!IA!1\t\u000f\t%\u0007\u0001\"\u0003\u0003L\"I!Q\u001b\u0001\u0012\u0002\u0013%!q\u001b\u0005\n\u00057\u0004\u0011\u0013!C\u0005\u0003\u007fDqA!8\u0001\t\u0013\u0011y\u000eC\u0005\u0004\b\u0001\t\n\u0011\"\u0003\u0003X\"I1\u0011\u0002\u0001\u0012\u0002\u0013%\u0011q \u0005\n\u0007\u0017\u0001\u0011\u0013!C\u0005\u0007\u001bA\u0011b!\u0005\u0001#\u0003%Iaa\u0005\t\u0013\r]\u0001!%A\u0005\n\re\u0001\"CB\u000f\u0001E\u0005I\u0011BB\n\u0011\u001d\u0019y\u0002\u0001C\u0001\u0003\u0003Cqa!\u000b\u0001\t\u0003\t\t\tC\u0004\u0004.\u0001!\t!!!\t\u000f\rE\u0002\u0001\"\u0001\u0002\u0002\"91Q\u0007\u0001\u0005\u0002\u0005\u0005\u0005bBB\u001d\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u0007{\u0001A\u0011AAA\u0011\u001d\u0019\t\u0005\u0001C\u0001\u0003\u0003Cqa!\u0012\u0001\t\u0003\t\t\tC\u0004\u0004J\u0001!\t!!!\t\u000f\r5\u0003\u0001\"\u0001\u0002\u0002\"91\u0011\u000b\u0001\u0005\u0002\u0005\u0005\u0005bBB+\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u00073\u0002A\u0011BB.\u0011\u001d\u0019\t\u0007\u0001C\u0001\u0003\u0003Cqa!\u001a\u0001\t\u0003\t\t\tC\u0004\u0004j\u0001!Iaa\u001b\t\u000f\r=\u0004\u0001\"\u0001\u0002\u0002\"911\u000f\u0001\u0005\u0002\u0005\u0005\u0005bBB<\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u0007w\u0002A\u0011AAA\u0011\u001d\u0019y\b\u0001C\u0001\u0003\u0003Cqaa!\u0001\t\u0003\t\t\tC\u0004\u0004\b\u0002!Ia!#\t\u000f\rM\u0005\u0001\"\u0001\u0002\u0002\"91q\u0013\u0001\u0005\u0002\u0005\u0005\u0005bBBN\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u0007?\u0003A\u0011AAA\u0011\u001d\u0019\u0019\u000b\u0001C\u0001\u0003\u0003Cqaa*\u0001\t\u0003\t\t\tC\u0004\u0004,\u0002!\t!!!\t\u000f\r=\u0006\u0001\"\u0001\u0002\u0002\"911\u0017\u0001\u0005\u0002\u0005\u0005\u0005bBB\\\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u0007w\u0003A\u0011AAA\u0011\u001d\u0019y\f\u0001C\u0001\u0003\u0003Cqaa1\u0001\t\u0003\t\t\tC\u0004\u0004H\u0002!\t!!!\t\u000f\r-\u0007\u0001\"\u0001\u0002\u0002\"91q\u001a\u0001\u0005\n\rE\u0007\"\u0003C\b\u0001E\u0005I\u0011\u0002C\t\u0011%!)\u0002AI\u0001\n\u0013!9\u0002C\u0005\u0005\u001c\u0001\t\n\u0011\"\u0003\u0002\u0000\"IAQ\u0004\u0001\u0012\u0002\u0013%1\u0011\u0004\u0005\n\t?\u0001\u0011\u0013!C\u0005\tCA\u0011\u0002\"\n\u0001#\u0003%I\u0001b\n\t\u0013\u0011-\u0002!%A\u0005\n\u00115\u0002\"\u0003C\u0019\u0001E\u0005I\u0011\u0002C\u001a\u00051aunY1m\u0019><G+Z:u\u0015\tQ7.A\u0002m_\u001eT\u0011\u0001\\\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u000e\u0005\u0002qg6\t\u0011OC\u0001s\u0003\u0015\u00198-\u00197b\u0013\t!\u0018O\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0004\"\u0001\u001f\u0001\u000e\u0003%\faaY8oM&<W#A>\u0011\u0005q|X\"A?\u000b\u0005y\\\u0017AB:feZ,'/C\u0002\u0002\u0002u\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004a\u0006%\u0011bAA\u0006c\n!QK\\5u\u0011!\tyaAA\u0001\u0002\u0004Y\u0018a\u0001=%c\u000591m\u001c8gS\u001e\u0004\u0013A\u0002;na\u0012K'/\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0012\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011AA5p\u0015\t\t\t#\u0001\u0003kCZ\f\u0017\u0002BA\u0013\u00037\u0011AAR5mK\u00069A/\u001c9ESJ\u0004\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011\u0011\u0011\u0007\t\u0005\u0003g\t\u0019%\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u0019\u0019w.\\7p]*\u0019A.a\u000f\u000b\t\u0005u\u0012qH\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u0005\u0013aA8sO&!\u0011QIA\u001b\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0016\u0005\u00055\u0003\u0003BA(\u00037j!!!\u0015\u000b\u0007)\f\u0019F\u0003\u0003\u0002V\u0005]\u0013!C5oi\u0016\u0014h.\u00197t\u0015\u0011\tI&!\u000f\u0002\u000fM$xN]1hK&!\u0011QLA)\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0006)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004\u0013\u0001C7pG.$\u0016.\\3\u0016\u0005\u0005\u0015\u0004\u0003BA4\u0003_j!!!\u001b\u000b\t\u0005-\u0014QN\u0001\u0005kRLGNC\u0002\u007f\u0003sIA!!\u001d\u0002j\tAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fAU\u0011\u0011q\u000f\t\u0004q\u0006e\u0014bAA>S\nAAj\\2bY2{w-\u0001\u0003m_\u001e\u0004\u0013!B:fiV\u0003HCAA\u0004Q\r\t\u0012Q\u0011\t\u0005\u0003\u000f\u000b)*\u0004\u0002\u0002\n*!\u00111RAG\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u001f\u000b\t*A\u0004kkBLG/\u001a:\u000b\t\u0005M\u0015qH\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003/\u000bII\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004%\u0005u\u0005\u0003BAD\u0003?KA!!)\u0002\n\nI\u0011I\u001a;fe\u0016\u000b7\r\u001b\u0002\t\u0017\u0016Lh+\u00197vKN11c\\AT\u0003[\u00032\u0001]AU\u0013\r\tY+\u001d\u0002\b!J|G-^2u!\r\u0001\u0018qV\u0005\u0004\u0003c\u000b(\u0001D*fe&\fG.\u001b>bE2,\u0017aA6fsV\u0011\u0011q\u0017\t\u0005\u0003s\u000b9M\u0004\u0003\u0002<\u0006\r\u0007cAA_c6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003l\u0017A\u0002\u001fs_>$h(C\u0002\u0002FF\fa\u0001\u0015:fI\u00164\u0017\u0002BAe\u0003\u0017\u0014aa\u0015;sS:<'bAAcc\u0006!1.Z=!\u0003\u00151\u0018\r\\;f\u0003\u00191\u0018\r\\;fAQ1\u0011Q[Am\u00037\u00042!a6\u0014\u001b\u0005\u0001\u0001bBAZ1\u0001\u0007\u0011q\u0017\u0005\b\u0003\u001fD\u0002\u0019AA\\\u0003!!xNU3d_J$G\u0003BAq\u0003[\u0004B!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0005\u0003O\f)$\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003W\f)O\u0001\u0007TS6\u0004H.\u001a*fG>\u0014H\rC\u0005\u0002pf\u0001J\u00111\u0001\u0002r\u0006IA/[7fgR\fW\u000e\u001d\t\u0006a\u0006M\u0018q_\u0005\u0004\u0003k\f(\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0007A\fI0C\u0002\u0002|F\u0014A\u0001T8oO\u0006\u0011Bo\u001c*fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\tA\u000b\u0003\u0002x\n\r1F\u0001B\u0003!\u0011\u00119A!\u0005\u000e\u0005\t%!\u0002\u0002B\u0006\u0005\u001b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=\u0011/\u0001\u0006b]:|G/\u0019;j_:LAAa\u0005\u0003\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003+\u0014IBa\u0007\t\u0013\u0005M6\u0004%AA\u0002\u0005]\u0006\"CAh7A\u0005\t\u0019AA\\\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\t+\t\u0005]&1A\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!\u0011\u0006\t\u0005\u0005W\u0011\t$\u0004\u0002\u0003.)!!qFA\u0010\u0003\u0011a\u0017M\\4\n\t\u0005%'QF\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005o\u00012\u0001\u001dB\u001d\u0013\r\u0011Y$\u001d\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u0003\u00129\u0005E\u0002q\u0005\u0007J1A!\u0012r\u0005\r\te.\u001f\u0005\n\u0003\u001f\u0001\u0013\u0011!a\u0001\u0005o\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u001b\u0002bAa\u0014\u0003V\t\u0005SB\u0001B)\u0015\r\u0011\u0019&]\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B,\u0005#\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!Q\fB2!\r\u0001(qL\u0005\u0004\u0005C\n(a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u001f\u0011\u0013\u0011!a\u0001\u0005\u0003\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005o\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005S\ta!Z9vC2\u001cH\u0003\u0002B/\u0005cB\u0011\"a\u0004&\u0003\u0003\u0005\rA!\u0011\u0002\u0011-+\u0017PV1mk\u0016\u00042!a6('\u00119s.!,\u0015\u0005\tU\u0014A\u00034s_6\u0014VmY8sIR!\u0011Q\u001bB@\u0011\u001d\t9/\u000ba\u0001\u0005\u0003\u0003B!a9\u0003\u0004&!!QQAs\u0005\u0019\u0011VmY8sI\u0006)\u0011\r\u001d9msR1\u0011Q\u001bBF\u0005\u001bCq!a-+\u0001\u0004\t9\fC\u0004\u0002P*\u0002\r!a.\u0002\u000fUt\u0017\r\u001d9msR!!1\u0013BP!\u0015\u0001(Q\u0013BM\u0013\r\u00119*\u001d\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fA\u0014Y*a.\u00028&\u0019!QT9\u0003\rQ+\b\u000f\\33\u0011%\u0011\tkKA\u0001\u0002\u0004\t).A\u0002yIA\nAb\u001b<t)>\u0014VmY8sIN$BAa*\u0003:B1!\u0011\u0016BZ\u0003CtAAa+\u00030:!\u0011Q\u0018BW\u0013\u0005\u0011\u0018b\u0001BYc\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B[\u0005o\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005c\u000b\bb\u0002B^Y\u0001\u0007!QX\u0001\nW\u0016Lh+\u00197vKN\u0004bA!+\u00034\u0006U\u0017\u0001\u0004:fG>\u0014Hm\u001d+p\u0017Z\u001cH\u0003\u0002B_\u0005\u0007DqA!2.\u0001\u0004\u00119-A\u0004sK\u000e|'\u000fZ:\u0011\r\t%&1\u0017BA\u00035\t\u0007\u000f]3oIJ+7m\u001c:egRA\u0011q\u0001Bg\u0005\u001f\u0014\t\u000eC\u0004\u0003F:\u0002\rAa*\t\u0011)t\u0003\u0013!a\u0001\u0003oB\u0011Ba5/!\u0003\u0005\r!a>\u0002\u001b%t\u0017\u000e^5bY>3gm]3u\u0003]\t\u0007\u000f]3oIJ+7m\u001c:eg\u0012\"WMZ1vYR$#'\u0006\u0002\u0003Z*\"\u0011q\u000fB\u0002\u0003]\t\u0007\u000f]3oIJ+7m\u001c:eg\u0012\"WMZ1vYR$3'A\u0006sK\u0006$'+Z2pe\u0012\u001cHC\u0004Bq\u0005O\u0014IO!<\u0003t\n]81\u0001\t\u0005\u0003\u001f\u0012\u0019/\u0003\u0003\u0003f\u0006E#!\u0004$fi\u000eDG)\u0019;b\u0013:4w\u000e\u0003\u0005kcA\u0005\t\u0019AA<\u0011%\u0011Y/\rI\u0001\u0002\u0004\t90A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\b\"\u0003BxcA%\t\u0019\u0001By\u0003%i\u0017\r\u001f'f]\u001e$\b\u000eE\u0003q\u0003g\u00149\u0004C\u0005\u0003vF\u0002\n\u00111\u0001\u0003^\u0005iQ.\u001b8P]\u0016lUm]:bO\u0016D\u0011B!?2!\u0013\u0005\rAa?\u0002#5\f\u0007p\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\rE\u0003q\u0003g\u0014i\u0010\u0005\u0003\u0002P\t}\u0018\u0002BB\u0001\u0003#\u0012\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011%\u0019)!\rI\u0001\u0002\u0004\u0011i&\u0001\nj]\u000edW\u000fZ3BE>\u0014H/\u001a3Uq:\u001c\u0018!\u0006:fC\u0012\u0014VmY8sIN$C-\u001a4bk2$H%M\u0001\u0016e\u0016\fGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003U\u0011X-\u00193SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM*\"aa\u0004+\t\t]\"1A\u0001\u0016e\u0016\fGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019)B\u000b\u0003\u0003^\t\r\u0011!\u0006:fC\u0012\u0014VmY8sIN$C-\u001a4bk2$H%N\u000b\u0003\u00077QCA!@\u0003\u0004\u0005)\"/Z1e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u00122\u0014\u0001\b;fgRdun\u001a#fY\u0016$XmU3h[\u0016tGo]*vG\u000e,7o\u001d\u0015\u0004q\r\r\u0002\u0003BAD\u0007KIAaa\n\u0002\n\n!A+Z:u\u0003i!Xm\u001d;S_2dW)\u001c9us\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uQ\rI41E\u00017i\u0016\u001cH\u000fT8h\t\u0016dW\r^3ESJ\u001cVoY2fgN<\u0006.\u001a8F[B$\u00180\u00118e\r\u0006LG.\u001e:f/\",gNT8o\u000b6\u0004H/\u001f\u0015\u0004u\r\r\u0012\u0001\u0005;fgR,\u0006\u000fZ1uK\u000e{gNZ5hQ\rY41E\u0001\u0019i\u0016\u001cH\u000fT8h\t&\u0014(+\u001a8b[\u0016$vNT3x\t&\u0014\bf\u0001\u001f\u0004$\u0005iB/Z:u\u0019><G)\u001b:SK:\fW.\u001a+p\u000bbL7\u000f^5oO\u0012K'\u000fK\u0002>\u0007G\tA\u0002^3ti2{wM\u00127vg\"D3APB\u0012\u00035!Xm\u001d;M_\u001e\f\u0005\u000f]3oI\"\u001aqha\t\u0002'Q,7\u000f\u001e'pO\u000ecwn]3Tk\u000e\u001cWm]:)\u0007\u0001\u001b\u0019#\u0001\fuKN$Hj\\4DY>\u001cX-\u00133f[B|G/\u001a8uQ\r\t51E\u0001,i\u0016\u001cH\u000fT8h\u00072|7/\u001a$bS2,(/Z,iK:Le.T3n_JL()\u001e4gKJ\u001cEn\\:fI\"\u001a!ia\t\u0002)Q,7\u000f\u001e'pO\u000ecwn]3IC:$G.\u001a:tQ\r\u001951E\u0001\u001fi\u0016\u001cH\u000fT8h\u00072|7/\u001a%b]\u0012dWM]:JI\u0016l\u0007o\u001c;f]RD3\u0001RB\u0012\u0003m!Xm\u001d;SK6|g/Z!oI\u0012+G.\u001a;f'\u0016<W.\u001a8ugR!\u0011qAB/\u0011\u001d\u0019y&\u0012a\u0001\u0005;\n1\"Y:z]\u000e$U\r\\3uK\u0006yB/Z:u%\u0016lwN^3B]\u0012$U\r\\3uKN+w-\\3oiN\u001c\u0016P\\2)\u0007\u0019\u001b\u0019#\u0001\u0011uKN$(+Z7pm\u0016\fe\u000e\u001a#fY\u0016$XmU3h[\u0016tGo]!ts:\u001c\u0007fA$\u0004$\u00051B/Z:u\t\u0016dW\r^3TK\u001elWM\u001c;GS2,7\u000f\u0006\u0003\u0002\b\r5\u0004bBB0\u0011\u0002\u0007!QL\u0001\u001bi\u0016\u001cH\u000fR3mKR,7+Z4nK:$h)\u001b7fgNKhn\u0019\u0015\u0004\u0013\u000e\r\u0012a\u0007;fgR$U\r\\3uKN+w-\\3oi\u001aKG.Z:Bgft7\rK\u0002K\u0007G\t!\u0004^3ti\u000e\u0013X-\u0019;f\u0003:$G)\u001a7fi\u0016\u001cVmZ7f]RD3aSB\u0012\u0003m!Xm\u001d;UeVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;Bi\"\u001aAja\t\u0002\u001dQ,7\u000f\u001e+sk:\u001c\u0017\r^3U_\"\u001aQja\t\u00023Q,7\u000f\u001e(p]\u0006\u001bG/\u001b<f'\u0016<W.\u001a8ug\u001a\u0013x.\u001c\u0015\u0004\u001d\u000e\r\u0012A\u0005;pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u0016$b!a.\u0004\f\u000e=\u0005bBBG\u001f\u0002\u0007\u0011qW\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0007#{\u0005\u0019AA\\\u0003%\u0001\u0018M\u001d;ji&|g.A\u000euKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a\u0015\u0004!\u000e\r\u0012\u0001\u000e;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lWmV5uQB+'/[8e\r>\u0014H)\u001a7fi\u0016$Gk\u001c9jG\"\u001a\u0011ka\t\u0002OQ,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X)\u001c9us:\u000bW.\u001a\u0015\u0004%\u000e\r\u0012A\t;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lWMR8s\u001dVdG\u000eK\u0002T\u0007G\ta\u0006^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:NSN\u001c\u0018N\\4TKB\f'/\u0019;pe\"\u001aAka\t\u0002UQ,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X*[:tS:<Gk\u001c9jG\"\u001aQka\t\u0002]Q,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X*[:tS:<\u0007+\u0019:uSRLwN\u001c\u0015\u0004-\u000e\r\u0012A\f;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lWMR8s\u0013:4\u0018\r\\5e!\u0006\u0014H/\u001b;j_:D3aVB\u0012\u0003A\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'/\u0012=jgRLgnZ%om\u0006d\u0017\u000e\u001a#je\"\u001a\u0001la\t\u0002)Q,7\u000f\u001e'pO\u0012+G.\u001a;f\t&\u0014h*Y7fQ\rI61E\u0001\u0013i\u0016\u001cHo\u00144gg\u0016$hI]8n\r&dW\rK\u0002[\u0007G\t\u0001\u0005^3tiJ{G\u000e\\*fO6,g\u000e\u001e+iCR\fEN]3bIf,\u00050[:ug\"\u001a1la\t\u00021Q,7\u000f\u001e(foN+w-\\3oiN\fe\r^3s%>dG\u000eK\u0002]\u0007G\t1\u0006^3tiJ{G\u000e\\*fO6,g\u000e^#se>\u0014x\u000b[3o\u001d\u0016DHo\u00144gg\u0016$\u0018j]%mY\u0016<\u0017\r\u001c\u0015\u0004;\u000e\r\u0012A\u0007;fgR4E.^:iS:<gj\u001c8Fq&\u001cH/\u001a8u\t&\u0014\bf\u00010\u0004$\u0005y2M]3bi\u0016dunY1m\u0019><w+\u001b;i\u0003\u000e$\u0018N^3TK\u001elWM\u001c;\u0015)\u0005]41[Bl\u0007?\u001cIo!<\u0004r\u000emH1\u0002C\u0007\u0011%\u0019)n\u0018I\u0001\u0002\u0004\t9\"A\u0002eSJDa!_0A\u0002\re\u0007\u0003BA(\u00077LAa!8\u0002R\tIAj\\4D_:4\u0017n\u001a\u0005\n\u0007C|\u0006\u0013!a\u0001\u0007G\f\u0001b]3h[\u0016tGo\u001d\t\u0005\u0003\u001f\u001a)/\u0003\u0003\u0004h\u0006E#a\u0003'pON+w-\\3oiND\u0011ba;`!\u0003\u0005\r!a>\u0002\u001bI,7m\u001c<fef\u0004v.\u001b8u\u0011%\u0019yo\u0018I\u0001\u0002\u0004\u0011i0\u0001\noKb$xJ\u001a4tKRlU\r^1eCR\f\u0007\"CBz?B\u0005\t\u0019AB{\u0003%\u00198\r[3ek2,'\u000f\u0005\u0003\u0002h\r]\u0018\u0002BB}\u0003S\u0012\u0011bU2iK\u0012,H.\u001a:\t\u0013\rux\f%AA\u0002\r}\u0018\u0001\u0002;j[\u0016\u0004B\u0001\"\u0001\u0005\b5\u0011A1\u0001\u0006\u0005\t\u000b\t)$A\u0003vi&d7/\u0003\u0003\u0005\n\u0011\r!\u0001\u0002+j[\u0016D\u0011\"!\f`!\u0003\u0005\r!!\r\t\u0013\u0005%s\f%AA\u0002\u00055\u0013!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0005\u0014)\"\u0011q\u0003B\u0002\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011A\u0011\u0004\u0016\u0005\u0007G\u0014\u0019!A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H\u0005N\u0001*GJ,\u0017\r^3M_\u000e\fG\u000eT8h/&$\b.Q2uSZ,7+Z4nK:$H\u0005Z3gCVdG\u000fJ\u001b\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t!\u0019C\u000b\u0003\u0004v\n\r\u0011!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$s'\u0006\u0002\u0005*)\"1q B\u0002\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%qU\u0011Aq\u0006\u0016\u0005\u0003c\u0011\u0019!A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H%O\u000b\u0003\tkQC!!\u0014\u0003\u0004\u0001")
public class LocalLogTest {
    private volatile LocalLogTest$KeyValue$ KeyValue$module;
    private KafkaConfig config;
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("test_topic", 1);
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final MockTime mockTime = new MockTime();
    private final LocalLog log;

    public LocalLogTest$KeyValue$ KeyValue() {
        if (this.KeyValue$module == null) {
            this.KeyValue$lzycompute$1();
        }
        return this.KeyValue$module;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public LocalLog log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        try {
            this.log().close();
        }
        catch (KafkaStorageException kafkaStorageException) {}
        Utils.delete((File)this.tmpDir());
    }

    private Iterable<SimpleRecord> kvsToRecords(Iterable<KeyValue> keyValues) {
        return (Iterable)keyValues.map((Function1 & Serializable & scala.Serializable)kv -> kv.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> kv.toRecord$default$1()), Iterable$.MODULE$.canBuildFrom());
    }

    private Iterable<KeyValue> recordsToKvs(Iterable<Record> records) {
        return (Iterable)records.map((Function1 & Serializable & scala.Serializable)r -> this.KeyValue().fromRecord((Record)r), Iterable$.MODULE$.canBuildFrom());
    }

    private void appendRecords(Iterable<SimpleRecord> records, LocalLog log, long initialOffset) {
        log.append(initialOffset + (long)records.size() - 1L, ((SimpleRecord)records.head()).timestamp(), initialOffset, MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])((SimpleRecord[])records.toList().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))));
    }

    private LocalLog appendRecords$default$2() {
        return this.log();
    }

    private long appendRecords$default$3() {
        return 0L;
    }

    private FetchDataInfo readRecords(LocalLog log, long startOffset, Function0<Object> maxLength, boolean minOneMessage, Function0<LogOffsetMetadata> maxOffsetMetadata, boolean includeAbortedTxns) {
        return log.read(startOffset, maxLength.apply$mcI$sp(), minOneMessage, (LogOffsetMetadata)maxOffsetMetadata.apply(), includeAbortedTxns);
    }

    private LocalLog readRecords$default$1() {
        return this.log();
    }

    private long readRecords$default$2() {
        return 0L;
    }

    private int readRecords$default$3() {
        return this.log().segments().activeSegment().size();
    }

    private boolean readRecords$default$4() {
        return false;
    }

    private LogOffsetMetadata readRecords$default$5() {
        return this.log().logEndOffsetMetadata();
    }

    private boolean readRecords$default$6() {
        return false;
    }

    @Test
    public void testLogDeleteSegmentsSuccess() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        Vector segmentsBeforeDelete = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.log().segments().values()).asScala()).toVector();
        Iterable deletedSegments = this.log().deleteAllSegments();
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)segmentsBeforeDelete, (Object)deletedSegments);
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().checkIfMemoryMappedBufferClosed());
        Assertions.assertTrue((boolean)this.logDir().exists());
    }

    @Test
    public void testRollEmptyActiveSegment() {
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    @Test
    public void testLogDeleteDirSuccessWhenEmptyAndFailureWhenNonEmpty() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        Assertions.assertThrows(IllegalStateException.class, () -> this.log().deleteEmptyDir());
        Assertions.assertTrue((boolean)this.logDir().exists());
        this.log().deleteAllSegments();
        this.log().deleteEmptyDir();
        Assertions.assertFalse((boolean)this.logDir().exists());
    }

    @Test
    public void testUpdateConfig() {
        LogConfig oldConfig = this.log().config();
        Assertions.assertEquals((Object)oldConfig, (Object)this.log().config());
        int x$1 = oldConfig.segmentSize + 1;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        int x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        boolean x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        LogConfig newConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
        this.log().updateConfig(newConfig);
        Assertions.assertEquals((Object)newConfig, (Object)this.log().config());
    }

    @Test
    public void testLogDirRenameToNewDir() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        File newLogDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        Assertions.assertTrue((boolean)this.log().renameDir(newLogDir.getName()));
        Assertions.assertFalse((boolean)this.logDir().exists());
        Assertions.assertTrue((boolean)newLogDir.exists());
        Assertions.assertEquals((Object)newLogDir, (Object)this.log().dir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().parentDir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().dir().getParent());
        this.log().segments().values().forEach(segment -> Assertions.assertEquals((Object)newLogDir.getPath(), (Object)segment.log().file().getParentFile().getPath()));
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
    }

    @Test
    public void testLogDirRenameToExistingDir() {
        Assertions.assertFalse((boolean)this.log().renameDir(this.log().dir().getName()));
    }

    @Test
    public void testLogFlush() {
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        this.log().flush(newSegment.baseOffset());
        this.log().markFlushed(newSegment.baseOffset());
        Assertions.assertEquals((long)1L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogAppend() {
        void readRecords_includeAbortedTxns;
        LocalLog x$2 = this.readRecords$default$1();
        long x$3 = this.readRecords$default$2();
        boolean x$4 = this.readRecords$default$4();
        boolean x$6 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfoBeforeAppend = x$2.read(x$3, LocalLogTest.$anonfun$testLogAppend$1(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfoBeforeAppend.records.records()).asScala()).isEmpty());
        this.mockTime().sleep(1L);
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        boolean bl = this.readRecords$default$6();
        boolean readRecords_minOneMessage = this.readRecords$default$4();
        FetchDataInfo fetchDataInfo = this.readRecords$default$1().read(this.readRecords$default$2(), this.readRecords$default$3(), readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).size());
        Assertions.assertEquals((Object)keyValues, this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala())));
    }

    @Test
    public void testLogCloseSuccess() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().close();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseSuccess$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseIdempotent() {
        this.log().close();
        this.log().close();
    }

    @Test
    public void testLogCloseFailureWhenInMemoryBufferClosed() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().closeHandlers();
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().close());
    }

    @Test
    public void testLogCloseHandlers() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().closeHandlers();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseHandlers$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseHandlersIdempotent() {
        this.log().closeHandlers();
        this.log().closeHandlers();
    }

    private void testRemoveAndDeleteSegments(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testRemoveAndDeleteSegments$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        public class Kafka_log_LocalLogTest$TestDeletionReason$1
        implements SegmentDeletionReason {
            private Iterable<LogSegment> _deletedSegments;

            private Iterable<LogSegment> _deletedSegments() {
                return this._deletedSegments;
            }

            private void _deletedSegments_$eq(Iterable<LogSegment> x$1) {
                this._deletedSegments = x$1;
            }

            public void logReason(List<LogSegment> toDelete) {
                this._deletedSegments_$eq((Iterable<LogSegment>)((Iterable)Nil$.MODULE$.$plus$plus(toDelete, List$.MODULE$.canBuildFrom())));
            }

            public Iterable<LogSegment> deletedSegments() {
                return this._deletedSegments();
            }

            public Kafka_log_LocalLogTest$TestDeletionReason$1(LocalLogTest $outer) {
                this._deletedSegments = Nil$.MODULE$;
            }
        }
        Kafka_log_LocalLogTest$TestDeletionReason$1 reason = new Kafka_log_LocalLogTest$TestDeletionReason$1(null);
        Vector toDelete = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.log().segments().values()).asScala()).toVector();
        this.log().removeAndDeleteSegments((Iterable)toDelete, asyncDelete, (SegmentDeletionReason)reason);
        if (asyncDelete) {
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)toDelete, reason.deletedSegments());
        toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testRemoveAndDeleteSegments$2(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveAndDeleteSegmentsSync() {
        this.testRemoveAndDeleteSegments(false);
    }

    @Test
    public void testRemoveAndDeleteSegmentsAsync() {
        this.testRemoveAndDeleteSegments(true);
    }

    private void testDeleteSegmentFiles(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeleteSegmentFiles$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        Vector toDelete = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.log().segments().values()).asScala()).toVector();
        LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable)toDelete, asyncDelete, this.log().dir(), this.log().topicPartition(), this.log().config(), this.log().scheduler(), this.log().logDirFailureChannel(), "");
        if (asyncDelete) {
            toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
                LocalLogTest.$anonfun$testDeleteSegmentFiles$2(segment);
                return BoxedUnit.UNIT;
            });
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testDeleteSegmentFiles$3(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDeleteSegmentFilesSync() {
        this.testDeleteSegmentFiles(false);
    }

    @Test
    public void testDeleteSegmentFilesAsync() {
        this.testDeleteSegmentFiles(true);
    }

    @Test
    public void testCreateAndDeleteSegment() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        long newOffset = this.log().segments().activeSegment().baseOffset() + 1L;
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        LogSegment newActiveSegment = this.log().createAndDeleteSegment(newOffset, this.log().segments().activeSegment(), true, (SegmentDeletionReason)new LogTruncation(this.log()));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)newActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertEquals((long)newOffset, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)newOffset, (long)this.log().logEndOffset());
        LocalLog x$2 = this.readRecords$default$1();
        boolean x$4 = this.readRecords$default$4();
        boolean x$6 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$2.read(newOffset, this.readRecords$default$3(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).isEmpty());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testTruncateFullyAndStartAt$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(8), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
            .colon.colon x$4 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
            long x$5 = offset;
            LocalLog x$6 = this.appendRecords$default$2();
            this.appendRecords((Iterable<SimpleRecord>)x$4, x$6, x$5);
        });
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Vector expected = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.log().segments().values()).asScala()).toVector();
        Iterable deleted = this.log().truncateFullyAndStartAt(10L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)10L, (long)this.log().logEndOffset());
        long x$7 = 10L;
        LocalLog x$8 = this.readRecords$default$1();
        boolean x$10 = this.readRecords$default$4();
        boolean x$12 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$8.read(x$7, this.readRecords$default$3(), x$10, this.readRecords$default$5(), x$12);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).isEmpty());
    }

    @Test
    public void testTruncateTo() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testTruncateTo$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)12L, (long)this.log().logEndOffset());
        Vector expected = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.log().segments().values(9L, this.log().logEndOffset() + 1L)).asScala()).toVector();
        Iterable deleted = this.log().truncateTo(7L);
        Assertions.assertEquals((Object)expected, (Object)deleted.toVector());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)6L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)7L, (long)this.log().logEndOffset());
        long x$4 = 6L;
        LocalLog x$5 = this.readRecords$default$1();
        boolean x$7 = this.readRecords$default$4();
        boolean x$9 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$5.read(x$4, this.readRecords$default$3(), x$7, this.readRecords$default$5(), x$9);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).size());
        Assertions.assertEquals((Object)new .colon.colon((Object)new KeyValue(this, "", "a"), (List)Nil$.MODULE$), this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala())));
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$10 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$11 = 7L;
        LocalLog x$12 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$10, x$12, x$11);
        Assertions.assertEquals((long)8L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNonActiveSegmentsFrom() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)i -> LocalLogTest.$anonfun$testNonActiveSegmentsFrom$1(this, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)5L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5), (Object)this.nonActiveBaseOffsetsFrom$1(0L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.nonActiveBaseOffsetsFrom$1(5L));
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(2), 5), (Object)this.nonActiveBaseOffsetsFrom$1(2L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.nonActiveBaseOffsetsFrom$1(6L));
    }

    private String topicPartitionName(String topic, String partition) {
        return new StringBuilder(1).append(topic).append("-").append(partition).toString();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic());
        Assertions.assertEquals((int)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (int)topicPartition.partition());
    }

    @Test
    public void testParseTopicPartitionNameWithPeriodForDeletedTopic() {
        String topic = "foo.bar-testtopic";
        String partition = "42";
        File dir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition)).toInt())));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic(), (String)"Unexpected topic name parsed");
        Assertions.assertEquals((int)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (int)topicPartition.partition(), (String)"Unexpected partition number parsed");
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        File dir = new File("");
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        Assertions.assertThrows(KafkaException.class, () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$1(null), () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$2(null));
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(this.logDir(), new StringBuilder(0).append(topic).append(partition).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition)).toInt())));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(new StringBuilder(0).append(this.logDir().getPath()).append(this.topicPartitionName(topic, partition)).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(this.topicPartitionName(topic, partition)).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForInvalidPartition() {
        String topic = "test_topic";
        String partition = "1999a";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForExistingInvalidDir() {
        File dir1 = new File(new StringBuilder(14).append(this.logDir().getPath()).append("/non_kafka_dir").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir1), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir1.getCanonicalPath()).toString());
        File dir2 = new File(new StringBuilder(21).append(this.logDir().getPath()).append("/non_kafka_dir-delete").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir2), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir2.getCanonicalPath()).toString());
    }

    @Test
    public void testLogDeleteDirName() {
        String name1 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition("foo", 3));
        Assertions.assertTrue((name1.length() <= 255 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("foo-3\\.[0-9a-z]{32}-delete").matcher(name1).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name1).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name1).matches());
        String name2 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(new StringBuilder(1).append("n").append(String.join((CharSequence)"", Collections.nCopies(248, "o"))).toString(), 5));
        Assertions.assertEquals((int)255, (int)name2.length());
        Assertions.assertTrue((boolean)Pattern.compile("n[o]{212}-5\\.[0-9a-z]{32}-delete").matcher(name2).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name2).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name2).matches());
    }

    @Test
    public void testOffsetFromFile() {
        long offset = 23423423L;
        File logFile = LogFileUtils.logFile((File)this.tmpDir(), (long)offset);
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)logFile));
        File offsetIndexFile = LogFileUtils.offsetIndexFile((File)this.tmpDir(), (long)offset);
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)offsetIndexFile));
        File timeIndexFile = LogFileUtils.timeIndexFile((File)this.tmpDir(), (long)offset);
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)timeIndexFile));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRollSegmentThatAlreadyExists() {
        void readRecords_includeAbortedTxns;
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Expect 1 segment after roll() empty segment with base offset.");
        .colon.colon keyValues1 = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)Nil$.MODULE$);
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues1), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        .colon.colon keyValues2 = new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)Nil$.MODULE$);
        Iterable x$1 = (Iterable)keyValues2.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.mockTime().milliseconds() + 10L), List$.MODULE$.canBuildFrom());
        long x$22 = 1L;
        LocalLog x$3 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$22);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        boolean bl = this.readRecords$default$6();
        boolean readRecords_minOneMessage = this.readRecords$default$4();
        FetchDataInfo readResult = this.readRecords$default$1().read(this.readRecords$default$2(), this.readRecords$default$3(), readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(readResult.records.records()).asScala()).size());
        Assertions.assertEquals((Object)keyValues1.$plus$plus((GenTraversableOnce)keyValues2, List$.MODULE$.canBuildFrom()), this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(readResult.records.records()).asScala())));
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)2L, (long)this.log().segments().activeSegment().baseOffset(), (String)"Expect base offset of active segment to be LEO");
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments(), (String)"Expect two segments.");
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNewSegmentsAfterRoll() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)0L, (long)newSegment.baseOffset());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)0L, (long)this.log().logEndOffset());
        KeyValue qual$1 = new KeyValue(this, "k1", "v1");
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> qual$1.toRecord$default$1();
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)qual$1.toRecord((Function0<Object>)x$1), (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        LogSegment newSegment2 = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)1L, (long)newSegment2.baseOffset());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)1L, (long)this.log().logEndOffset());
        KeyValue qual$2 = new KeyValue(this, "k2", "v2");
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> qual$2.toRecord$default$1();
        .colon.colon x$3 = new .colon.colon((Object)qual$2.toRecord((Function0<Object>)x$2), (List)Nil$.MODULE$);
        long x$4 = 1L;
        LocalLog x$5 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$3, x$5, x$4);
        LogSegment newSegment3 = this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((long)2L, (long)newSegment3.baseOffset());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testRollSegmentErrorWhenNextOffsetIsIllegal() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)new .colon.colon((Object)new KeyValue(this, "k3", "v3"), (List)Nil$.MODULE$)));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)3L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)3L, (long)this.log().segments().activeSegment().baseOffset());
        this.log().updateLogEndOffset(1L);
        Assertions.assertThrows(KafkaException.class, () -> this.log().roll(this.log().roll$default$1()));
    }

    @Test
    public void testFlushingNonExistentDir() {
        LocalLog spyLog = (LocalLog)Mockito.spy((Object)this.log());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        ((LocalLog)Mockito.doReturn((Object)new File("__NON_EXISTENT__"), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)spyLog)).dir();
        Assertions.assertDoesNotThrow(() -> spyLog.flush(newSegment.baseOffset()));
    }

    private LocalLog createLocalLogWithActiveSegment(File dir, LogConfig config, LogSegments segments, long recoveryPoint, LogOffsetMetadata nextOffsetMetadata, Scheduler scheduler, Time time, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        segments.add(LogSegment.open((File)dir, (long)0L, (LogConfig)config, (Time)time, (int)config.initFileSize(), (boolean)config.preallocate));
        return new LocalLog(dir, config, segments, recoveryPoint, nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
    }

    private File createLocalLogWithActiveSegment$default$1() {
        return this.logDir();
    }

    private LogSegments createLocalLogWithActiveSegment$default$3() {
        return new LogSegments(this.topicPartition());
    }

    private long createLocalLogWithActiveSegment$default$4() {
        return 0L;
    }

    private LogOffsetMetadata createLocalLogWithActiveSegment$default$5() {
        return new LogOffsetMetadata(0L, 0L, 0);
    }

    private Scheduler createLocalLogWithActiveSegment$default$6() {
        return this.mockTime().scheduler;
    }

    private Time createLocalLogWithActiveSegment$default$7() {
        return this.mockTime();
    }

    private TopicPartition createLocalLogWithActiveSegment$default$8() {
        return this.topicPartition();
    }

    private LogDirFailureChannel createLocalLogWithActiveSegment$default$9() {
        return this.logDirFailureChannel();
    }

    private final void KeyValue$lzycompute$1() {
        synchronized (this) {
            if (this.KeyValue$module == null) {
                this.KeyValue$module = new LocalLogTest$KeyValue$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$testLogAppend$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testLogCloseSuccess$1(LocalLogTest $this, Seq keyValues$1) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$1);
        long x$2 = 2L;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
    }

    public static final /* synthetic */ void $anonfun$testLogCloseHandlers$1(LocalLogTest $this, Seq keyValues$2) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$2);
        long x$2 = 2L;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
    }

    public static final /* synthetic */ LogSegment $anonfun$testRemoveAndDeleteSegments$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndDeleteSegments$2(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeleteSegmentFiles$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$2(LogSegment segment) {
        Assertions.assertFalse((boolean)segment.deleted());
        Assertions.assertTrue((boolean)segment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$3(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyAndStartAt$1(LocalLogTest $this, SimpleRecord record$1, int offset) {
        .colon.colon x$1 = new .colon.colon((Object)record$1, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateTo$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 3 == 2) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogSegment $anonfun$testNonActiveSegmentsFrom$1(LocalLogTest $this, int i) {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue($this, Integer.toString(i), Integer.toString(i)), (List)Nil$.MODULE$);
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues);
        long x$2 = i;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    private final Seq nonActiveBaseOffsetsFrom$1(long startOffset) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.log().segments().nonActiveLogSegmentsFrom(startOffset)).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testParseTopicPartitionNameForNull$1(File dir$2) {
        LocalLog$.MODULE$.parseTopicPartitionName(dir$2);
    }

    public static final /* synthetic */ String $anonfun$testParseTopicPartitionNameForNull$2(File dir$2) {
        return new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir$2).toString();
    }

    public LocalLogTest() {
        LogConfig x$1 = LogTestUtils$.MODULE$.createLogConfig(LogTestUtils$.MODULE$.createLogConfig$default$1(), LogTestUtils$.MODULE$.createLogConfig$default$2(), LogTestUtils$.MODULE$.createLogConfig$default$3(), LogTestUtils$.MODULE$.createLogConfig$default$4(), LogTestUtils$.MODULE$.createLogConfig$default$5(), LogTestUtils$.MODULE$.createLogConfig$default$6(), LogTestUtils$.MODULE$.createLogConfig$default$7(), LogTestUtils$.MODULE$.createLogConfig$default$8(), LogTestUtils$.MODULE$.createLogConfig$default$9(), LogTestUtils$.MODULE$.createLogConfig$default$10(), LogTestUtils$.MODULE$.createLogConfig$default$11(), LogTestUtils$.MODULE$.createLogConfig$default$12(), LogTestUtils$.MODULE$.createLogConfig$default$13());
        File x$2 = this.createLocalLogWithActiveSegment$default$1();
        LogSegments x$3 = this.createLocalLogWithActiveSegment$default$3();
        long x$4 = this.createLocalLogWithActiveSegment$default$4();
        LogOffsetMetadata x$5 = this.createLocalLogWithActiveSegment$default$5();
        Scheduler x$6 = this.createLocalLogWithActiveSegment$default$6();
        Time x$7 = this.createLocalLogWithActiveSegment$default$7();
        TopicPartition x$8 = this.createLocalLogWithActiveSegment$default$8();
        LogDirFailureChannel x$9 = this.createLocalLogWithActiveSegment$default$9();
        this.log = this.createLocalLogWithActiveSegment(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
    }

    public class KeyValue
    implements Product,
    scala.Serializable {
        private final String key;
        private final String value;
        public final /* synthetic */ LocalLogTest $outer;

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public SimpleRecord toRecord(Function0<Object> timestamp) {
            return new SimpleRecord(timestamp.apply$mcJ$sp(), this.key().getBytes(), this.value().getBytes());
        }

        public long toRecord$default$1() {
            return this.kafka$log$LocalLogTest$KeyValue$$$outer().mockTime().milliseconds();
        }

        public KeyValue copy(String key, String value) {
            return new KeyValue(this.kafka$log$LocalLogTest$KeyValue$$$outer(), key, value);
        }

        public String copy$default$1() {
            return this.key();
        }

        public String copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "KeyValue";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.value();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyValue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof KeyValue && ((KeyValue)x$1).kafka$log$LocalLogTest$KeyValue$$$outer() == this.kafka$log$LocalLogTest$KeyValue$$$outer())) break block3;
                    KeyValue keyValue = (KeyValue)x$1;
                    String string = this.key();
                    String string2 = keyValue.key();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.value();
                    String string4 = keyValue.value();
                    if ((string3 != null ? !string3.equals(string4) : string4 != null) || !keyValue.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LocalLogTest kafka$log$LocalLogTest$KeyValue$$$outer() {
            return this.$outer;
        }

        public KeyValue(LocalLogTest $outer, String key, String value) {
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

