/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerLagIntegrationTest$;
import kafka.log.UnifiedLog;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001\u0002\f\u0018\u0001qAQa\n\u0001\u0005\u0002!BqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00043\u0001\u0001\u0006I\u0001\f\u0005\bg\u0001\u0011\r\u0011\"\u0001,\u0011\u0019!\u0004\u0001)A\u0005Y!9Q\u0007\u0001b\u0001\n\u00031\u0004B\u0002#\u0001A\u0003%q\u0007C\u0004F\u0001\t\u0007I\u0011\u0001$\t\r)\u0003\u0001\u0015!\u0003H\u0011\u001dY\u0005A1A\u0005\u0002-Ba\u0001\u0014\u0001!\u0002\u0013a\u0003bB'\u0001\u0005\u0004%\tA\u0014\u0005\u00071\u0002\u0001\u000b\u0011B(\t\u000be\u0003A\u0011\u0001.\t\u000bq\u0004A\u0011B?\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a\u001d9\u0011\u0011G\f\t\u0002\u0005MbA\u0002\f\u0018\u0011\u0003\t)\u0004\u0003\u0004(%\u0011\u0005\u0011Q\b\u0005\b\u0003\u007f\u0011B\u0011AA!\u0011\u00191(\u0003\"\u0001\u0002j\taBj\\4DY\u0016\fg.\u001a:MC\u001eLe\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\r\u001a\u0003\rawn\u001a\u0006\u00025\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u001eCA\u0011adH\u0007\u0002/%\u0011\u0001e\u0006\u0002\"\u0003\n\u001cHO]1di2{wm\u00117fC:,'/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\t\u0003E\u0015j\u0011a\t\u0006\u0003Ie\tQ!\u001e;jYNL!AJ\u0012\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\u000b\t\u0003=\u0001\t\u0011\"\\:QKJDu.\u001e:\u0016\u00031\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u00121!\u00138u\u0003)i7\u000fU3s\u0011>,(\u000fI\u0001\u0011[&t7i\\7qC\u000e$\u0018n\u001c8MC\u001e\f\u0011#\\5o\u0007>l\u0007/Y2uS>tG*Y4!\u0003\u0011!\u0018.\\3\u0016\u0003]\u0002\"\u0001\u000f\"\u000e\u0003eR!AO\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0003yu\naa]3sm\u0016\u0014(B\u0001\u000e?\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rK$\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002!\rdW-\u00198fe\n\u000b7m[(gM6\u001bX#A$\u0011\u00055B\u0015BA%/\u0005\u0011auN\\4\u0002#\rdW-\u00198fe\n\u000b7m[(gM6\u001b\b%A\u0006tK\u001elWM\u001c;TSj,\u0017\u0001D:fO6,g\u000e^*ju\u0016\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003=\u00032!\f)S\u0013\t\tfFA\u0003BeJ\f\u0017\u0010\u0005\u0002T-6\tAK\u0003\u0002V{\u000511m\\7n_:L!a\u0016+\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0001Bo\u001c9jGB\u000b'\u000f^5uS>t7\u000fI\u0001\fG2,\u0017M\\3s)\u0016\u001cH\u000f\u0006\u0002\\=B\u0011Q\u0006X\u0005\u0003;:\u0012A!\u00168ji\")qL\u0004a\u0001A\u0006)1m\u001c3fGB\u0011\u0011\rZ\u0007\u0002E*\u00111\rV\u0001\u0007e\u0016\u001cwN\u001d3\n\u0005\u0015\u0014'aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3)\t997\u000f\u001e\t\u0003QFl\u0011!\u001b\u0006\u0003U.\f\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003Y6\fa\u0001]1sC6\u001c(B\u00018p\u0003\u001dQW\u000f]5uKJT!\u0001\u001d!\u0002\u000b),h.\u001b;\n\u0005IL'\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&A;\"\u0003Y\f!\u0002]1sC6,G/\u001a:tQ\tq\u0001\u0010\u0005\u0002zu6\t1.\u0003\u0002|W\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\u0017I,\u0017\r\u001a$s_6dun\u001a\u000b\u0004}\u0006=\u0001#B@\u0002\u0006\u0005%QBAA\u0001\u0015\r\t\u0019AL\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0004\u0003\u0003\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0006[\u0005-A\u0006L\u0005\u0004\u0003\u001bq#A\u0002+va2,'\u0007\u0003\u0004\u0019\u001f\u0001\u0007\u0011\u0011\u0003\t\u0004=\u0005M\u0011bAA\u000b/\tQQK\\5gS\u0016$Gj\\4\u0002\u0013]\u0014\u0018\u000e^3EkB\u001cH\u0003DA\u000e\u0003C\t)#!\u000b\u0002,\u00055\u0002#B@\u0002\u001e\u0005%\u0011\u0002BA\u0010\u0003\u0003\u00111aU3r\u0011\u0019\t\u0019\u0003\u0005a\u0001Y\u00059a.^7LKf\u001c\bBBA\u0014!\u0001\u0007A&A\u0004ok6$U\u000f]:\t\ra\u0001\u0002\u0019AA\t\u0011\u0015y\u0006\u00031\u0001a\u0011\u0019\ty\u0003\u0005a\u0001\u000f\u0006IA/[7fgR\fW\u000e]\u0001\u001d\u0019><7\t\\3b]\u0016\u0014H*Y4J]R,wM]1uS>tG+Z:u!\tq\"cE\u0002\u0013\u0003o\u00012!LA\u001d\u0013\r\tYD\f\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005M\u0012\u0001D8oKB\u000b'/Y7fi\u0016\u0014XCAA\"!\u0019\t)%!\u0014\u0002R5\u0011\u0011q\t\u0006\u0004u\u0005%#BAA&\u0003\u0011Q\u0017M^1\n\t\u0005=\u0013q\t\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0003B\u0017Q\u0003'\u0002B!!\u0016\u0002d9!\u0011qKA0!\r\tIFL\u0007\u0003\u00037R1!!\u0018\u001c\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\r\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\t)'a\u001a\u0003\rM#(/\u001b8h\u0015\r\t\tGL\u000b\u0003\u0003W\u0002b!!\u001c\u0002t\u0005]TBAA8\u0015\u0011\t\t(a\u0012\u0002\rM$(/Z1n\u0013\u0011\t)(a\u001c\u0003\rM#(/Z1n!\rA\u0017\u0011P\u0005\u0004\u0003wJ'!C!sOVlWM\u001c;t\u0001")
public class LogCleanerLagIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements Logging {
    private final int msPerHour;
    private final int minCompactionLag;
    private final MockTime time;
    private final long cleanerBackOffMs;
    private final int segmentSize;
    private final TopicPartition[] topicPartitions;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Stream<Arguments> parameters() {
        return LogCleanerLagIntegrationTest$.MODULE$.parameters();
    }

    public static Collection<String[]> oneParameter() {
        return LogCleanerLagIntegrationTest$.MODULE$.oneParameter();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int msPerHour() {
        return this.msPerHour;
    }

    public int minCompactionLag() {
        return this.minCompactionLag;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public long cleanerBackOffMs() {
        return this.cleanerBackOffMs;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void cleanerTest(CompressionType codec) {
        WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$22 = this.cleanerBackOffMs();
        long x$3 = this.minCompactionLag();
        int x$4 = this.segmentSize();
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        int x$7 = this.makeCleaner$default$5();
        int x$8 = this.makeCleaner$default$7();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$12, x$5, x$6, x$22, x$7, x$3, x$8, x$4, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        long T0 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends0 = this.writeDups(100, 3, log, codec, T0);
        long startSizeBlock0 = log.size();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("total log size at T0: ").append(startSizeBlock0).toString());
        LogSegment activeSegAtT0 = log.activeSegment();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("active segment at T0 has base offset: ").append(activeSegAtT0.baseOffset()).toString());
        int sizeUpToActiveSegmentAtT0 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("log size up to base offset of active segment at T0: ").append(sizeUpToActiveSegmentAtT0).toString());
        this.cleaner().startup();
        this.time().sleep((long)(this.minCompactionLag() / 2));
        Thread.sleep(5L * this.cleanerBackOffMs());
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the compaction lag has passed");
        this.time().sleep((long)(this.minCompactionLag() / 2 + 1));
        long T1 = this.time().milliseconds();
        Seq appends1 = (Seq)appends0.$plus$plus(this.writeDups(100, 3, log, codec, T1), Seq$.MODULE$.canBuildFrom());
        long firstBlock1SegmentBaseOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$122 = new TopicPartition("log", 0);
        long x$13 = activeSegAtT0.baseOffset();
        long x$14 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$122, x$13, x$14);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        Assertions.assertEquals((Object)appends1.toMap(Predef$.MODULE$.$conforms()), (Object)read1.toMap(Predef$.MODULE$.$conforms()), (String)"Contents of the map shouldn't change.");
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("after cleaning the compacted size up to active segment at T0: ").append(compactedSize).toString());
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assertions.assertTrue((lastCleaned >= firstBlock1SegmentBaseOffset ? 1 : 0) != 0, (String)new StringBuilder(65).append("log cleaner should have processed up to offset ").append(firstBlock1SegmentBaseOffset).append(", but lastCleaned=").append(lastCleaned).toString());
        Assertions.assertTrue((sizeUpToActiveSegmentAtT0 > compactedSize ? 1 : 0) != 0, (String)new StringBuilder(90).append("log should have been compacted: size up to offset of active segment at T0=").append(sizeUpToActiveSegmentAtT0).append(" compacted size=").append(compactedSize).toString());
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(UnifiedLog log) {
        return (Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(log.logSegments()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, UnifiedLog log, CompressionType codec, long timestamp) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerLagIntegrationTest.$anonfun$writeDups$1(this, numKeys, log, codec, timestamp, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(LogCleanerLagIntegrationTest $this, UnifiedLog log$1, CompressionType codec$1, long timestamp$1, int key) {
        int count = $this.counter();
        byte[] x$1 = Integer.toString($this.counter()).getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5(), log$1.appendAsLeader$default$6());
        log$1.updateHighWatermark(log$1.logEndOffset());
        $this.incCounter();
        return new Tuple2.mcII.sp(key, count);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDups$1(LogCleanerLagIntegrationTest $this, int numKeys$1, UnifiedLog log$1, CompressionType codec$1, long timestamp$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerLagIntegrationTest.$anonfun$writeDups$2($this, log$1, codec$1, timestamp$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public LogCleanerLagIntegrationTest() {
        Logging.$init$((Logging)this);
        this.msPerHour = 3600000;
        this.minCompactionLag = 1 * this.msPerHour();
        Assertions.assertTrue((this.minCompactionLag() % 2 == 0 ? 1 : 0) != 0, (String)"compactionLag must be divisible by 2 for this test");
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerBackOffMs = 200L;
        this.segmentSize = 512;
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

