/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.log.LogConcurrencyTest$FetchedBatch$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.server.Defaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\tEe\u0001B\u001c9\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015Cq\u0001\u0013\u0001C\u0002\u0013%\u0011\n\u0003\u0004Q\u0001\u0001\u0006IA\u0013\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u0019I\u0006\u0001)A\u0005'\"9!\f\u0001b\u0001\n\u0013Y\u0006BB4\u0001A\u0003%A\fC\u0004i\u0001\t\u0007I\u0011B5\t\rI\u0004\u0001\u0015!\u0003k\u0011\u001d\u0019\bA1A\u0005\n%Da\u0001\u001e\u0001!\u0002\u0013Q\u0007\"B;\u0001\t\u00031\bBBA\u0006\u0001\u0011\u0005a\u000f\u0003\u0004\u0002\u0016\u0001!\tA\u001e\u0005\u0007\u0003?\u0001A\u0011\u0001<\t\u000f\u0005U\u0001\u0001\"\u0001\u0002$\u00191\u0011Q\u0006\u0001\u0005\u0003_A\u0011\"O\t\u0003\u0002\u0003\u0006I!a\n\t\u0015\u0005-\u0013C!A!\u0002\u0013\ti\u0005\u0003\u0004E#\u0011\u0005\u00111\u000b\u0005\n\u0003;\n\"\u0019!C\u0001\u0003?B\u0001B!\u0006\u0012A\u0003%\u0011\u0011\r\u0005\u0007\u0005/\tB\u0011\t<\u0007\r\te\u0001\u0001\u0002B\u000e\u0011%I\u0004D!A!\u0002\u0013\t9\u0003\u0003\u0006\u0002La\u0011\t\u0011)A\u0005\u0003\u000fCa\u0001\u0012\r\u0005\u0002\tu\u0001B\u0002B\f1\u0011\u0005c\u000fC\u0004\u0003&\u0001!IAa\n\t\u0013\t}\u0002!%A\u0005\n\t\u0005\u0003b\u0002B#\u0001\u0011%!q\t\u0004\u0007\u0003g\u0002A)!\u001e\t\u0015\u0005\r\u0005E!f\u0001\n\u0003\t)\t\u0003\u0006\u0002\u000e\u0002\u0012\t\u0012)A\u0005\u0003\u000fC!\"a$!\u0005+\u0007I\u0011AAI\u0011)\t\u0019\n\tB\tB\u0003%\u0011Q\n\u0005\u0007\t\u0002\"\t!!&\t\u000f\u0005m\u0005\u0005\"\u0011\u0002\u001e\"I\u0011Q\u0017\u0011\u0002\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0003{\u0003\u0013\u0013!C\u0001\u0003\u007fC\u0011\"!6!#\u0003%\t!a6\t\u0013\u0005m\u0007%!A\u0005B\u0005u\u0007\"CArA\u0005\u0005I\u0011AAI\u0011%\t)\u000fIA\u0001\n\u0003\t9\u000fC\u0005\u0002t\u0002\n\t\u0011\"\u0011\u0002v\"I\u0011q \u0011\u0002\u0002\u0013\u0005!\u0011\u0001\u0005\n\u0005\u0017\u0001\u0013\u0011!C!\u0005\u001bA\u0011Ba\u0004!\u0003\u0003%\tE!\u0005\b\u0013\t}\u0003!!A\t\n\t\u0005d!CA:\u0001\u0005\u0005\t\u0012\u0002B2\u0011\u0019!%\u0007\"\u0001\u0003r!I\u00111\u0014\u001a\u0002\u0002\u0013\u0015#1\u000f\u0005\n\u0005k\u0012\u0014\u0011!CA\u0005oB\u0011B! 3\u0003\u0003%\tIa \u0003%1{wmQ8oGV\u0014(/\u001a8dsR+7\u000f\u001e\u0006\u0003si\n1\u0001\\8h\u0015\u0005Y\u0014!B6bM.\f7\u0001A\n\u0003\u0001y\u0002\"a\u0010\"\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001G!\t9\u0005!D\u00019\u0003A\u0011'o\\6feR{\u0007/[2Ti\u0006$8/F\u0001K!\tYe*D\u0001M\u0015\ti%(\u0001\u0004tKJ4XM]\u0005\u0003\u001f2\u0013\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0002#\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001c\b%\u0001\u0004sC:$w.\\\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011a\u000bQ\u0001\u0005kRLG.\u0003\u0002Y+\n1!+\u00198e_6\fqA]1oI>l\u0007%A\u0005tG\",G-\u001e7feV\tA\f\u0005\u0002^K6\taL\u0003\u0002W?*\u0011Q\n\u0019\u0006\u0003w\u0005T!AY2\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0017aA8sO&\u0011aM\u0018\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0007i6\u0004H)\u001b:\u0016\u0003)\u0004\"a\u001b9\u000e\u00031T!!\u001c8\u0002\u0005%|'\"A8\u0002\t)\fg/Y\u0005\u0003c2\u0014AAR5mK\u00069A/\u001c9ESJ\u0004\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u000bM,G/\u001e9\u0015\u0003]\u0004\"a\u0010=\n\u0005e\u0004%\u0001B+oSRD#\u0001D>\u0011\u0007q\f9!D\u0001~\u0015\tqx0A\u0002ba&TA!!\u0001\u0002\u0004\u00059!.\u001e9ji\u0016\u0014(bAA\u0003G\u0006)!.\u001e8ji&\u0019\u0011\u0011B?\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005tQV$Hm\\<oQ\ri\u0011q\u0002\t\u0004y\u0006E\u0011bAA\n{\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001fi\u0016\u001cH/\u00168d_6l\u0017\u000e\u001e;fI\u0012\u000bG/\u0019(pi\u000e{gn];nK\u0012D3ADA\r!\ra\u00181D\u0005\u0004\u0003;i(\u0001\u0002+fgR\f!\u0007^3tiVs7m\\7nSR$X\r\u001a#bi\u0006tu\u000e^\"p]N,X.\u001a3Ge\u0016\fX/\u001a8u'\u0016<W.\u001a8u%>dGn\u001d\u0015\u0004\u001f\u0005eAcA<\u0002&!1\u0011\b\u0005a\u0001\u0003O\u00012aRA\u0015\u0013\r\tY\u0003\u000f\u0002\u000b+:Lg-[3e\u0019><'\u0001D\"p]N,X.\u001a:UCN\\7#B\t\u00022\u0005u\u0002\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]b.\u0001\u0003mC:<\u0017\u0002BA\u001e\u0003k\u0011aa\u00142kK\u000e$\b#BA \u0003\u000f:XBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002W]&!\u0011\u0011JA!\u0005!\u0019\u0015\r\u001c7bE2,\u0017A\u00037bgR|eMZ:fiB\u0019q(a\u0014\n\u0007\u0005E\u0003IA\u0002J]R$b!!\u0016\u0002Z\u0005m\u0003cAA,#5\t\u0001\u0001\u0003\u0004:)\u0001\u0007\u0011q\u0005\u0005\b\u0003\u0017\"\u0002\u0019AA'\u0003=\u0019wN\\:v[\u0016$')\u0019;dQ\u0016\u001cXCAA1!\u0019\t\u0019'!\u001c\u0002r5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0004nkR\f'\r\\3\u000b\u0007\u0005-\u0004)\u0001\u0006d_2dWm\u0019;j_:LA!a\u001c\u0002f\tQA*[:u\u0005V4g-\u001a:\u0011\u0007\u0005]\u0003E\u0001\u0007GKR\u001c\u0007.\u001a3CCR\u001c\u0007n\u0005\u0004!}\u0005]\u0014Q\u0010\t\u0004\u007f\u0005e\u0014bAA>\u0001\n9\u0001K]8ek\u000e$\bcA \u0002\u0000%\u0019\u0011\u0011\u0011!\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0015\t\f7/Z(gMN,G/\u0006\u0002\u0002\bB\u0019q(!#\n\u0007\u0005-\u0005I\u0001\u0003M_:<\u0017a\u00032bg\u0016|eMZ:fi\u0002\nQ!\u001a9pG\",\"!!\u0014\u0002\r\u0015\u0004xn\u00195!)\u0019\t\t(a&\u0002\u001a\"9\u00111Q\u0013A\u0002\u0005\u001d\u0005bBAHK\u0001\u0007\u0011QJ\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u0014\t\u0005\u0003C\u000byK\u0004\u0003\u0002$\u0006-\u0006cAAS\u00016\u0011\u0011q\u0015\u0006\u0004\u0003Sc\u0014A\u0002\u001fs_>$h(C\u0002\u0002.\u0002\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAY\u0003g\u0013aa\u0015;sS:<'bAAW\u0001\u0006!1m\u001c9z)\u0019\t\t(!/\u0002<\"I\u00111Q\u0014\u0011\u0002\u0003\u0007\u0011q\u0011\u0005\n\u0003\u001f;\u0003\u0013!a\u0001\u0003\u001b\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002B*\"\u0011qQAbW\t\t)\r\u0005\u0003\u0002H\u0006EWBAAe\u0015\u0011\tY-!4\u0002\u0013Ut7\r[3dW\u0016$'bAAh\u0001\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0017\u0011\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u00033TC!!\u0014\u0002D\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a8\u0011\t\u0005M\u0012\u0011]\u0005\u0005\u0003c\u000b)$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005%\u0018q\u001e\t\u0004\u007f\u0005-\u0018bAAw\u0001\n\u0019\u0011I\\=\t\u0013\u0005EH&!AA\u0002\u00055\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002xB1\u0011\u0011`A~\u0003Sl!!!\u001b\n\t\u0005u\u0018\u0011\u000e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0004\t%\u0001cA \u0003\u0006%\u0019!q\u0001!\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011\u001f\u0018\u0002\u0002\u0003\u0007\u0011\u0011^\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QJ\u0001\u0007KF,\u0018\r\\:\u0015\t\t\r!1\u0003\u0005\n\u0003c\u0004\u0014\u0011!a\u0001\u0003S\f\u0001cY8ogVlW\r\u001a\"bi\u000eDWm\u001d\u0011\u0002\t\r\fG\u000e\u001c\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012$\u0016m]6\u0014\u000ba\t\t$!\u0010\u0015\r\t}!\u0011\u0005B\u0012!\r\t9\u0006\u0007\u0005\u0007sm\u0001\r!a\n\t\u000f\u0005-3\u00041\u0001\u0002\b\u0006I1M]3bi\u0016dun\u001a\u000b\u0005\u0003O\u0011I\u0003C\u0005\u0003,u\u0001\n\u00111\u0001\u0003.\u000511m\u001c8gS\u001e\u0004BAa\f\u0003<5\u0011!\u0011\u0007\u0006\u0004s\tM\"\u0002\u0002B\u001b\u0005o\t\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0007\te\u0002-A\u0004ti>\u0014\u0018mZ3\n\t\tu\"\u0011\u0007\u0002\n\u0019><7i\u001c8gS\u001e\f1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uIE*\"Aa\u0011+\t\t5\u00121Y\u0001\u0015m\u0006d\u0017\u000eZ1uK\u000e{gn];nK\u0012$\u0015\r^1\u0015\u000b]\u0014IEa\u0013\t\rez\u0002\u0019AA\u0014\u0011\u001d\tif\ba\u0001\u0005\u001b\u0002bAa\u0014\u0003Z\u0005Ed\u0002\u0002B)\u0005+rA!!*\u0003T%\t\u0011)C\u0002\u0003X\u0001\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\\\tu#\u0001C%uKJ\f'\r\\3\u000b\u0007\t]\u0003)\u0001\u0007GKR\u001c\u0007.\u001a3CCR\u001c\u0007\u000eE\u0002\u0002XI\u001aRA\rB3\u0003{\u0002\"Ba\u001a\u0003n\u0005\u001d\u0015QJA9\u001b\t\u0011IGC\u0002\u0003l\u0001\u000bqA];oi&lW-\u0003\u0003\u0003p\t%$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!\u0011\r\u000b\u0003\u0003?\fQ!\u00199qYf$b!!\u001d\u0003z\tm\u0004bBABk\u0001\u0007\u0011q\u0011\u0005\b\u0003\u001f+\u0004\u0019AA'\u0003\u001d)h.\u00199qYf$BA!!\u0003\u000eB)qHa!\u0003\b&\u0019!Q\u0011!\u0003\r=\u0003H/[8o!\u001dy$\u0011RAD\u0003\u001bJ1Aa#A\u0005\u0019!V\u000f\u001d7fe!I!q\u0012\u001c\u0002\u0002\u0003\u0007\u0011\u0011O\u0001\u0004q\u0012\u0002\u0004")
public class LogConcurrencyTest {
    private volatile LogConcurrencyTest$FetchedBatch$ FetchedBatch$module;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1());
    private final Random kafka$log$LogConcurrencyTest$$random = new Random();
    private final KafkaScheduler scheduler = new KafkaScheduler(1);
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());

    private LogConcurrencyTest$FetchedBatch$ FetchedBatch() {
        if (this.FetchedBatch$module == null) {
            this.FetchedBatch$lzycompute$1();
        }
        return this.FetchedBatch$module;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Random kafka$log$LogConcurrencyTest$$random() {
        return this.kafka$log$LogConcurrencyTest$$random;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private File logDir() {
        return this.logDir;
    }

    @BeforeEach
    public void setup() {
        this.scheduler().startup();
    }

    @AfterEach
    public void shutdown() {
        this.scheduler().shutdown();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testUncommittedDataNotConsumed() {
        this.testUncommittedDataNotConsumed(this.createLog(this.createLog$default$1()));
    }

    @Test
    public void testUncommittedDataNotConsumedFrequentSegmentRolls() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(237));
        LogConfig logConfig = new LogConfig((Map)logProps);
        this.testUncommittedDataNotConsumed(this.createLog(logConfig));
    }

    public void testUncommittedDataNotConsumed(UnifiedLog log) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            int maxOffset = 5000;
            ConsumerTask consumer = new ConsumerTask(this, log, maxOffset);
            LogAppendTask appendTask = new LogAppendTask(this, log, maxOffset);
            Future<BoxedUnit> consumerFuture = executor.submit(consumer);
            executor.submit(appendTask).get();
            consumerFuture.get();
            this.validateConsumedData(log, (Iterable<FetchedBatch>)consumer.consumedBatches());
        }
        finally {
            executor.shutdownNow();
        }
    }

    private UnifiedLog createLog(LogConfig config) {
        File x$1 = this.logDir();
        long x$3 = 0L;
        long x$4 = 0L;
        KafkaScheduler x$5 = this.scheduler();
        BrokerTopicStats x$6 = this.brokerTopicStats();
        Time x$7 = Time.SYSTEM;
        int x$8 = 300000;
        ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false);
        int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$13 = true;
        boolean x$14 = UnifiedLog$.MODULE$.apply$default$12();
        ConcurrentMap x$15 = UnifiedLog$.MODULE$.apply$default$15();
        boolean x$16 = UnifiedLog$.MODULE$.apply$default$16();
        LogOffsetsListener x$17 = UnifiedLog$.MODULE$.apply$default$17();
        return UnifiedLog$.MODULE$.apply(x$1, config, x$3, x$4, (Scheduler)x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$14, (Option)x$12, x$13, x$15, x$16, x$17);
    }

    private LogConfig createLog$default$1() {
        return new LogConfig((Map)new Properties());
    }

    private void validateConsumedData(UnifiedLog log, Iterable<FetchedBatch> consumedBatches) {
        Iterator iter = consumedBatches.iterator();
        log.logSegments().forEach(segment -> segment.log().batches().forEach(batch -> {
            if (iter.hasNext()) {
                FetchedBatch consumedBatch = (FetchedBatch)iter.next();
                try {
                    Assertions.assertEquals((int)batch.partitionLeaderEpoch(), (int)consumedBatch.epoch(), (String)"Consumed batch with unexpected leader epoch");
                    Assertions.assertEquals((long)batch.baseOffset(), (long)consumedBatch.baseOffset(), (String)"Consumed batch with unexpected base offset");
                    return;
                }
                catch (Throwable t) {
                    throw new AssertionError(new StringBuilder(58).append("Consumed batch ").append(consumedBatch).append(" ").append("does not match next expected batch in log ").append(batch).toString(), t);
                }
            }
        }));
    }

    private final void FetchedBatch$lzycompute$1() {
        synchronized (this) {
            if (this.FetchedBatch$module == null) {
                this.FetchedBatch$module = new LogConcurrencyTest$FetchedBatch$(this);
            }
            return;
        }
    }

    private class ConsumerTask
    implements Callable<BoxedUnit> {
        private final UnifiedLog log;
        private final int lastOffset;
        private final ListBuffer<FetchedBatch> consumedBatches;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public ListBuffer<FetchedBatch> consumedBatches() {
            return this.consumedBatches;
        }

        @Override
        public void call() {
            LongRef fetchOffset = LongRef.create((long)0L);
            while (this.log.highWatermark() < (long)this.lastOffset) {
                this.log.read((long)fetchOffset.elem, (int)1, (FetchIsolation)FetchIsolation.HIGH_WATERMARK, (boolean)true).records.batches().forEach(batch -> {
                    this.consumedBatches().$plus$eq((Object)new FetchedBatch(this.kafka$log$LogConcurrencyTest$ConsumerTask$$$outer(), batch.baseOffset(), batch.partitionLeaderEpoch()));
                    fetchOffset$1.elem = batch.lastOffset() + 1L;
                });
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$ConsumerTask$$$outer() {
            return this.$outer;
        }

        public ConsumerTask(LogConcurrencyTest $outer, UnifiedLog log, int lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.consumedBatches = (ListBuffer)ListBuffer$.MODULE$.empty();
        }
    }

    private class FetchedBatch
    implements Product,
    scala.Serializable {
        private final long baseOffset;
        private final int epoch;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public long baseOffset() {
            return this.baseOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        public String toString() {
            return new StringBuilder(33).append("FetchedBatch(baseOffset=").append(this.baseOffset()).append(", epoch=").append(this.epoch()).append(")").toString();
        }

        public FetchedBatch copy(long baseOffset, int epoch) {
            return new FetchedBatch(this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer(), baseOffset, epoch);
        }

        public long copy$default$1() {
            return this.baseOffset();
        }

        public int copy$default$2() {
            return this.epoch();
        }

        public String productPrefix() {
            return "FetchedBatch";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.baseOffset());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.epoch());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchedBatch;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.baseOffset())), (int)this.epoch()), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FetchedBatch && ((FetchedBatch)x$1).kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() == this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer())) break block3;
                    FetchedBatch fetchedBatch = (FetchedBatch)x$1;
                    if (this.baseOffset() != fetchedBatch.baseOffset() || this.epoch() != fetchedBatch.epoch() || !fetchedBatch.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() {
            return this.$outer;
        }

        public FetchedBatch(LogConcurrencyTest $outer, long baseOffset, int epoch) {
            this.baseOffset = baseOffset;
            this.epoch = epoch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class LogAppendTask
    implements Callable<BoxedUnit> {
        private final UnifiedLog log;
        private final long lastOffset;
        public final /* synthetic */ LogConcurrencyTest $outer;

        @Override
        public void call() {
            int leaderEpoch = 1;
            boolean isLeader = true;
            block4: while (this.log.highWatermark() < this.lastOffset) {
                int n = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(2);
                switch (n) {
                    case 0: {
                        LogOffsetMetadata logEndOffsetMetadata = this.log.logEndOffsetMetadata();
                        long logEndOffset = logEndOffsetMetadata.messageOffset;
                        int batchSize = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(9) + 1;
                        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), batchSize).map((Function1 & Serializable & scala.Serializable)i -> LogAppendTask.$anonfun$call$2(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                        if (isLeader) {
                            this.log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), leaderEpoch, this.log.appendAsLeader$default$3(), this.log.appendAsLeader$default$4(), this.log.appendAsLeader$default$5(), this.log.appendAsLeader$default$6());
                            this.log.maybeIncrementHighWatermark(logEndOffsetMetadata);
                            continue block4;
                        }
                        byte x$4 = TestUtils$.MODULE$.records$default$2();
                        CompressionType x$5 = TestUtils$.MODULE$.records$default$3();
                        long x$6 = TestUtils$.MODULE$.records$default$4();
                        short x$7 = TestUtils$.MODULE$.records$default$5();
                        int x$8 = TestUtils$.MODULE$.records$default$6();
                        this.log.appendAsFollower(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$4, x$5, x$6, x$7, x$8, logEndOffset, leaderEpoch));
                        this.log.updateHighWatermark(logEndOffset);
                        continue block4;
                    }
                    case 1: {
                        isLeader = !isLeader;
                        ++leaderEpoch;
                        if (isLeader) continue block4;
                        this.log.truncateTo(this.log.highWatermark());
                        continue block4;
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$LogAppendTask$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ SimpleRecord $anonfun$call$2(int i) {
            return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        }

        public LogAppendTask(LogConcurrencyTest $outer, UnifiedLog log, long lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

