/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%BQ\u0001\f\u0001\u0005\u00025BQA\u0010\u0001\u0005\u00025BQ\u0001\u0011\u0001\u0005\u00025BQA\u0011\u0001\u0005\u00025BQ\u0001\u0012\u0001\u0005\u00025BQA\u0012\u0001\u0005\u00025BQ\u0001\u0013\u0001\u0005\u00025BQA\u0013\u0001\u0005\u00025BQ\u0001\u0014\u0001\u0005\u00025BQA\u0014\u0001\u0005\u00025BQ\u0001\u0015\u0001\u0005\u00025BQA\u0015\u0001\u0005\nMCQ\u0001\u001a\u0001\u0005\n\u0015DQ!\u001c\u0001\u0005\u00025BQa\u001c\u0001\u0005\u00025BQ!\u001d\u0001\u0005\u00025BQa\u001d\u0001\u0005\u00025BQ!\u001e\u0001\u0005\nYDa!!\t\u0001\t\u0003i\u0003bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003+\u0002A\u0011AA,\u0011\u001d\t)\u0007\u0001C\u0001\u0003OBq!!\u001e\u0001\t\u0003\t9\b\u0003\u0004\u0002\u0006\u0002!\t!\f\u0005\u0007\u0003\u0013\u0003A\u0011A\u0017\u0003\u001b1{wmQ8oM&<G+Z:u\u0015\tib$A\u0002m_\u001eT\u0011aH\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0002\"a\u000b\u0001\u000e\u0003q\t1&\u001a8tkJ,gj\\*uCRL7-\u00138ji&\fG.\u001b>bi&|gn\u0014:eKJ$U\r]3oI\u0016t7-\u001f\u000b\u0002]A\u00111eL\u0005\u0003a\u0011\u0012A!\u00168ji\"\u0012!A\r\t\u0003gqj\u0011\u0001\u000e\u0006\u0003kY\n1!\u00199j\u0015\t9\u0004(A\u0004kkBLG/\u001a:\u000b\u0005eR\u0014!\u00026v]&$(\"A\u001e\u0002\u0007=\u0014x-\u0003\u0002>i\t!A+Z:u\u0003Y!Xm\u001d;LC\u001a\\\u0017mQ8oM&<Gk\u001c)s_B\u001c\bFA\u00023\u0003Q!Xm\u001d;Ge>l\u0007K]8qg&sg/\u00197jI\"\u0012AAM\u0001\u001fi\u0016\u001cH/\u00138wC2LGmQ8na\u0006\u001cG/[8o\u0019\u0006<7i\u001c8gS\u001eD#!\u0002\u001a\u0002KMDw.\u001e7e-\u0006d\u0017\u000eZ1uKRC'o\u001c;uY\u0016$'+\u001a9mS\u000e\f7oQ8oM&<\u0007F\u0001\u00043\u0003=!Xm\u001d;U_\"#X\u000e\u001c+bE2,\u0007FA\u00043\u0003)!Xm\u001d;U_\"#X\u000e\u001c\u0015\u0003\u0011I\n\u0011\u0003^3tiR{WI\u001c:jG\",GMU:uQ\tI!'A\u0005uKN$Hk\u001c*ti\"\u0012!BM\u0001\u0013i\u0016\u001cHoR3u\u0007>tg-[4WC2,X\r\u000b\u0002\fe\u0005)C/Z:u\u001fZ,'O]5eI\u0016t7i\u001c8gS\u001e\u001c\u0018i\u001d'pO\u001e\f'\r\\3TiJLgn\u001a\u0015\u0003\u0019I\nq![:WC2LG\r\u0006\u0002U/B\u00111%V\u0005\u0003-\u0012\u0012qAQ8pY\u0016\fg\u000eC\u0003Y\u001b\u0001\u0007\u0011,A\u0006d_:4\u0017n\u001a,bYV,\u0007C\u0001.b\u001d\tYv\f\u0005\u0002]I5\tQL\u0003\u0002_A\u00051AH]8pizJ!\u0001\u0019\u0013\u0002\rA\u0013X\rZ3g\u0013\t\u00117M\u0001\u0004TiJLgn\u001a\u0006\u0003A\u0012\nQ#Y:tKJ$\bK]8qKJ$\u00180\u00138wC2LG\rF\u0002/M\"DQa\u001a\bA\u0002e\u000bAA\\1nK\")\u0011N\u0004a\u0001U\u00061a/\u00197vKN\u00042aI6#\u0013\taGE\u0001\u0006=e\u0016\u0004X-\u0019;fIz\n\u0011\u0005^3ti2{7-\u00197M_\u001e\u0014V\r^3oi&|g\u000eR3sSZ,G\r\u0015:paND#a\u0004\u001a\u0002QQ,7\u000f\u001e'pG\u0006dGj\\4SKR,g\u000e^5p]\u0012+'/\u001b<fI\u0012+g-Y;miB\u0013x\u000e]:)\u0005A\u0011\u0014A\u0007;fgRdunY1m\u0019><'+\u001a;f]RLwN\u001c)s_B\u001c\bFA\t3\u0003\u0005\"Xm\u001d;J]Z\fG.\u001b3M_\u000e\fG\u000eT8h%\u0016$XM\u001c;j_:\u0004&o\u001c9tQ\t\u0011\"'A\u0012e_R+7\u000f^%om\u0006d\u0017\u000e\u001a'pG\u0006dGj\\4SKR,g\u000e^5p]B\u0013x\u000e]:\u0015\u0013]\f)!a\u0004\u0002\u001a\u0005u\u0001c\u0001=\u0002\u00025\t\u0011P\u0003\u0002{w\u000611m\u001c8gS\u001eT!\u0001`?\u0002\r\r|W.\\8o\u0015\tybP\u0003\u0002\u0000u\u00051\u0011\r]1dQ\u0016L1!a\u0001z\u0005=\u0019uN\u001c4jO\u0016C8-\u001a9uS>t\u0007bBA\u0004'\u0001\u0007\u0011\u0011B\u0001\u0011Y>\u001c\u0017\r\u001c*fi\u0016tG/[8o\u001bN\u00042aIA\u0006\u0013\r\ti\u0001\n\u0002\u0005\u0019>tw\rC\u0004\u0002\u0012M\u0001\r!a\u0005\u0002'1|7-\u00197SKR,g\u000e^5p]\nKH/Z:\u0011\u0007\r\n)\"C\u0002\u0002\u0018\u0011\u00121!\u00138u\u0011\u001d\tYb\u0005a\u0001\u0003'\taB]3uK:$\u0018n\u001c8CsR,7\u000fC\u0004\u0002 M\u0001\r!!\u0003\u0002\u0017I,G/\u001a8uS>tWj]\u0001+i\u0016\u001cH/\u00128bE2,'+Z7pi\u0016dunZ*u_J\fw-Z(o\u0007>l\u0007/Y2uK\u0012$v\u000e]5dQ\t!\"'\u0001\u000euKN$XI\\1cY\u0016\u0014V-\\8uK2{wm\u0015;pe\u0006<W\rF\u0002/\u0003SAa!a\u000b\u0016\u0001\u0004!\u0016aF:zgJ+Wn\u001c;f'R|'/Y4f\u000b:\f'\r\\3eQ\u001d)\u0012qFA \u0003\u0003\u0002B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$\u0001\u0005qe>4\u0018\u000eZ3s\u0015\r\tIDN\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005u\u00121\u0007\u0002\f-\u0006dW/Z*pkJ\u001cW-\u0001\u0005c_>dW-\u00198tY\u0011\t\u0019%!\u0012\u001a\u0003\u0005I\u0012\u0001\u0001\u0015\u0007+\u0005%s-!\u0015\u0011\t\u0005-\u0013QJ\u0007\u0003\u0003oIA!a\u0014\u00028\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\"\u0005\u0005M\u0013\u0001\u0010;fgR,e.\u00192mKJ+Wn\u001c;f\u0019><7\u000b^8sC\u001e,\u0007e^5uQ\u0002\u001a\u0018p\u001d*f[>$Xm\u0015;pe\u0006<W-\u00128bE2,GM\u000f\u0011|au\f\u0011\u0006^3tiR{\u0007/[2De\u0016\fG/[8o/&$\b.\u00138wC2LGMU3uK:$\u0018n\u001c8US6,Gc\u0001\u0018\u0002Z!1\u00111\u0006\fA\u0002QCsAFA\u0018\u0003\u007f\ti\u0006\f\u0003\u0002D\u0005\u0015\u0003F\u0002\f\u0002J\u001d\f\t'\t\u0002\u0002d\u0005YE/Z:u)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8XSRD\u0017J\u001c<bY&$'+\u001a;f]RLwN\u001c+j[\u0016\u0004s/\u001b;iAML8OU3n_R,7\u000b^8sC\u001e,WI\\1cY\u0016$'\bI>1{\u0006IC/Z:u)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8XSRD\u0017J\u001c<bY&$'+\u001a;f]RLwN\\*ju\u0016$2ALA5\u0011\u0019\tYc\u0006a\u0001)\":q#a\f\u0002@\u00055D\u0006BA\"\u0003\u000bBcaFA%O\u0006E\u0014EAA:\u0003-#Xm\u001d;U_BL7m\u0011:fCRLwN\\,ji\"LeN^1mS\u0012\u0014V\r^3oi&|gnU5{K\u0002:\u0018\u000e\u001e5!gf\u001c(+Z7pi\u0016\u001cFo\u001c:bO\u0016,e.\u00192mK\u0012T\u0004e\u001f\u0019~\u0003q!Xm\u001d;WC2LG-\u0019;f\u0005J|7.\u001a:M_\u001e\u001cuN\u001c4jON$2ALA=\u0011\u0019\tY\u0003\u0007a\u0001)\":\u0001$a\f\u0002@\u0005uD\u0006BA\"\u0003\u000bBc\u0001GA%O\u0006\u0005\u0015EAAB\u0003y\"Xm\u001d;WC2LG-\u0019;f\u0005J|7.\u001a:M_\u001e\u001cuN\u001c4jON\u0004s/\u001b;iAML8OU3n_R,7\u000b^8sC\u001e,WI\\1cY\u0016$'\bI>1{\u0006aC/Z:u)&lWm\u001d;b[B\u0014UMZ8sK6\u000b\u00070T:Vg\u0016\u001cH)\u001a9sK\u000e\fG/\u001a3D_:4\u0017n\u001a\u0015\u00033I\n!\u0006^3tiZ\u000bG.\u001b3bi\u0016<\u0016\u000e\u001e5NKR\fG-\u0019;b-\u0016\u00148/[8o\u0015\n|GmU;qa>\u0014H\u000f\u000b\u0002\u001be\u0001")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assertions.assertNotNull((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp());
        Assertions.assertTrue((boolean)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(LogConfig.configNames()).asScala()).filter((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config)))).forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$2(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        long millisInDay = 24L * millisInHour;
        long bytesInGB = 0x40000000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "960");
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
        kafkaProps.put("log.local.retention.ms", "2592000000");
        kafkaProps.put("log.local.retention.bytes", "4294967296");
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.jitter.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(40L * millisInDay)), logProps.get("retention.ms"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1.version(), logProps.get("message.format.version"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(30L * millisInDay)), logProps.get("local.retention.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(4L * bytesInGB)), logProps.get("local.retention.bytes"));
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig.configNames().forEach(name -> {
            if ("unclean.leader.election.enable".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
                return;
            }
            if ("retention.bytes".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                return;
            }
            if ("retention.ms".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                return;
            }
            if ("cleanup.policy".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                return;
            }
            if ("min.cleanable.dirty.ratio".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                return;
            }
            if ("min.insync.replicas".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                return;
            }
            if ("message.format.version".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{""}));
                return;
            }
            if ("remote.storage.enable".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                return;
            }
            if ("local.retention.ms".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                return;
            }
            if ("local.retention.bytes".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                return;
            }
            this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty("max.compaction.lag.ms", "100");
        props.setProperty("min.compaction.lag.ms", "200");
        Assertions.assertThrows(Exception.class, () -> LogConfig.validate((Properties)props));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assertions.assertTrue((boolean)this.isValid("*"));
        Assertions.assertTrue((boolean)this.isValid("* "));
        Assertions.assertTrue((boolean)this.isValid(""));
        Assertions.assertTrue((boolean)this.isValid(" "));
        Assertions.assertTrue((boolean)this.isValid("100:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assertions.assertTrue((boolean)this.isValid("100:0,"));
        Assertions.assertFalse((boolean)this.isValid("100"));
        Assertions.assertFalse((boolean)this.isValid("100:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100:0,10 :   "));
        Assertions.assertFalse((boolean)this.isValid("*,100:10"));
        Assertions.assertFalse((boolean)this.isValid("* ,100:10"));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToHtml() {
        String html = LogConfig.configDefCopy().toHtml(4, key -> new StringBuilder(7).append("prefix_").append((String)key).toString(), Collections.emptyMap());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testToRst() {
        String rst = LogConfig.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, new StringBuilder(4).append(configNameWithNoServerMapping).append(" doc").toString());
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, "Server Default Property");
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assertions.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, "Server Default Property"));
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(KafkaConfig$.MODULE$.SslKeyPasswordProp(), "somekeypassword");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "50");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty("min.insync.replicas", "2");
        topicOverrides.setProperty("retention.bytes", "100");
        topicOverrides.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        LogConfig logConfig = LogConfig.fromProps((Map)kafkaConfig.extractLogConfigMap(), (Properties)topicOverrides);
        Assertions.assertEquals((Object)"{min.insync.replicas=2, retention.bytes=100, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator.ensureValidString((String)"", (String)configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions.assertThrows(Exception.class, () -> new LogConfig((Map)props));
        });
    }

    @Test
    public void testLocalLogRetentionDerivedProps() {
        Properties props = new Properties();
        int retentionBytes = 1024;
        long retentionMs = 1000L;
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)retentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)retentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionDerivedDefaultProps() {
        LogConfig logConfig = new LogConfig((Map)new Properties());
        Assertions.assertEquals((long)604800000L, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)-1L, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionProps() {
        Properties props = new Properties();
        int localRetentionMs = 500;
        int localRetentionBytes = 1000;
        props.put("retention.bytes", Integer.toString(2000));
        props.put("retention.ms", Integer.toString(1000));
        props.put("local.retention.ms", Integer.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)localRetentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)localRetentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testInvalidLocalLogRetentionProps() {
        this.doTestInvalidLocalLogRetentionProps(-3L, 10, 2, 500L);
        this.doTestInvalidLocalLogRetentionProps(500L, -3, 2, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, 2, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(500L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(-1L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, -1, 100, 1000L);
    }

    private ConfigException doTestInvalidLocalLogRetentionProps(long localRetentionMs, int localRetentionBytes, int retentionBytes, long retentionMs) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties props = new Properties();
        props.put("remote.storage.enable", "true");
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        props.put("local.retention.ms", Long.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)props, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())));
    }

    @Test
    public void testEnableRemoteLogStorageOnCompactedTopic() {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("cleanup.policy", "delete");
        logProps.put("remote.storage.enable", "true");
        LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()));
        logProps.put("cleanup.policy", "compact");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())));
        logProps.put("cleanup.policy", "delete,compact");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())));
        logProps.put("cleanup.policy", "compact,delete");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())));
    }

    @ParameterizedTest(name="testEnableRemoteLogStorage with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testEnableRemoteLogStorage(boolean sysRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", "true");
        if (sysRemoteStorageEnabled) {
            LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()));
            return;
        }
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())))).getMessage().contains("Tiered Storage functionality is disabled in the broker"));
    }

    @ParameterizedTest(name="testTopicCreationWithInvalidRetentionTime with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testTopicCreationWithInvalidRetentionTime(boolean sysRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "1000");
        kafkaProps.put("log.local.retention.ms", "900");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", Boolean.toString(sysRemoteStorageEnabled));
        logProps.put("retention.ms", "500");
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())))).getMessage().contains("local.retention.ms"));
            return;
        }
        LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()));
    }

    @ParameterizedTest(name="testTopicCreationWithInvalidRetentionSize with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testTopicCreationWithInvalidRetentionSize(boolean sysRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        props.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1024");
        props.put("log.local.retention.bytes", "512");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", Boolean.toString(sysRemoteStorageEnabled));
        logProps.put("retention.bytes", "128");
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())))).getMessage().contains("local.retention.bytes"));
            return;
        }
        LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()));
    }

    @ParameterizedTest(name="testValidateBrokerLogConfigs with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testValidateBrokerLogConfigs(boolean sysRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        props.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1024");
        props.put("log.local.retention.bytes", "2048");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validateBrokerLogConfigValues((Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())))).getMessage().contains("local.retention.bytes"));
            return;
        }
        LogConfig.validateBrokerLogConfigValues((Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()));
    }

    @Test
    public void testTimestampBeforeMaxMsUsesDeprecatedConfig() {
        long oneDayInMillis = 86400000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageTimestampBeforeMaxMsProp(), Long.toString(Long.MAX_VALUE));
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageTimestampAfterMaxMsProp(), Long.toString(Long.MAX_VALUE));
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp(), Long.toString(oneDayInMillis));
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)oneDayInMillis), logProps.get("message.timestamp.before.max.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)oneDayInMillis), logProps.get("message.timestamp.after.max.ms"));
    }

    @Test
    public void testValidateWithMetadataVersionJbodSupport() {
        LogConfigTest.validate$1(MetadataVersion.IBP_3_6_IV2, false);
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV0, false);
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV2, false);
        Assertions.assertThrows(IllegalArgumentException.class, () -> LogConfigTest.validate$1(MetadataVersion.IBP_3_6_IV2, true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV0, true));
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV2, true);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        return !LogConfig.CONFIGS_WITH_NO_SERVER_DEFAULTS.contains(config);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$2(String config) {
        Optional serverConfigOpt = LogConfig.serverConfigName((String)config);
        return serverConfigOpt.isPresent() && serverConfigOpt.get() != null;
    }

    private static final void validate$1(MetadataVersion metadataVersion, boolean jbodConfig) {
        int x$1 = 0;
        int x$3 = jbodConfig ? 2 : 1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$12 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$17 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$3, x$18, x$19, x$20, x$21)).validateWithMetadataVersion(metadataVersion);
    }
}

