/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalLong;
import kafka.log.LogTestUtils$;
import kafka.server.Defaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.BatchMetadata;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegmentOffsetOverflowException;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.RollParams;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004I\u0001\u0001\u0006I!\u0010\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0011\u0019a\u0006\u0001)A\u0005\u0017\"IQ\f\u0001a\u0001\u0002\u0004%IA\u0018\u0005\nO\u0002\u0001\r\u00111A\u0005\n!D\u0011B\u001c\u0001A\u0002\u0003\u0005\u000b\u0015B0\t\u000b=\u0004A\u0011\u00019\t\u0013\u0005\u001d\u0001!%A\u0005\u0002\u0005%\u0001\"CA\u0010\u0001E\u0005I\u0011AA\u0011\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\u0016\u0001\t\u0003\t9\u0006C\u0004\u0002p\u0001!\t!a\u0016\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u0011\u0011\u0019\u0001\u0005\u0002\u0005]\u0003bBAf\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0003\u001f\u0004A\u0011AA,\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003/Bq!a6\u0001\t\u0003\t9\u0006C\u0004\u0002\\\u0002!\t!a\u0016\t\u000f\u0005}\u0007\u0001\"\u0001\u0002X!9\u00111\u001d\u0001\u0005\u0002\u0005]\u0003bBAt\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0003W\u0004A\u0011AA,\u0011\u001d\ty\u000f\u0001C\u0001\u0003/Bq!a=\u0001\t\u0003\t9\u0006C\u0004\u0002x\u0002!\t!a\u0016\t\u000f\u0005m\b\u0001\"\u0001\u0002X!9\u0011q \u0001\u0005\n\t\u0005\u0001\"\u0003B\u0015\u0001E\u0005I\u0011BA\u0005\u0011%\u0011Y\u0003AI\u0001\n\u0013\tI\u0001C\u0005\u0003.\u0001\t\n\u0011\"\u0003\u00030!9!1\u0007\u0001\u0005\u0002\u0005]\u0003b\u0002B\u001c\u0001\u0011\u0005\u0011q\u000b\u0005\u0007_\u0002!IAa\u000f\t\u000f\tE\u0003\u0001\"\u0001\u0002X!9!Q\u000b\u0001\u0005\u0002\u0005]\u0003b\u0002B-\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0005;\u0002A\u0011AA,\u0011\u001d\u0011\t\u0007\u0001C\u0005\u0005G\u0012a\u0002T8h'\u0016<W.\u001a8u)\u0016\u001cHO\u0003\u0002-[\u0005\u0019An\\4\u000b\u00039\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001cA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001d\u0011\u0005i\u0002Q\"A\u0016\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\tQ\b\u0005\u0002?\r6\tqH\u0003\u0002A\u0003\u000611m\\7n_:T!A\f\"\u000b\u0005\r#\u0015AB1qC\u000eDWMC\u0001F\u0003\ry'oZ\u0005\u0003\u000f~\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003!\u0019XmZ7f]R\u001cX#A&\u0011\u00071\u000b6+D\u0001N\u0015\tqu*A\u0004nkR\f'\r\\3\u000b\u0005A\u001b\u0014AC2pY2,7\r^5p]&\u0011!+\u0014\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0002U56\tQK\u0003\u0002--*\u0011q\u000bW\u0001\nS:$XM\u001d8bYNT!!W!\u0002\u000fM$xN]1hK&\u00111,\u0016\u0002\u000b\u0019><7+Z4nK:$\u0018!C:fO6,g\u000e^:!\u0003\u0019awn\u001a#jeV\tq\f\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u0006\u0011\u0011n\u001c\u0006\u0002I\u0006!!.\u0019<b\u0013\t1\u0017M\u0001\u0003GS2,\u0017A\u00037pO\u0012K'o\u0018\u0013fcR\u0011\u0011\u000e\u001c\t\u0003e)L!a[\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b[\u001e\t\t\u00111\u0001`\u0003\rAH%M\u0001\bY><G)\u001b:!\u00035\u0019'/Z1uKN+w-\\3oiR!1+\u001d<|\u0011\u0015\u0011\u0018\u00021\u0001t\u0003\u0019ygMZ:fiB\u0011!\u0007^\u0005\u0003kN\u0012A\u0001T8oO\"9q/\u0003I\u0001\u0002\u0004A\u0018AE5oI\u0016D\u0018J\u001c;feZ\fGNQ=uKN\u0004\"AM=\n\u0005i\u001c$aA%oi\"9A0\u0003I\u0001\u0002\u0004i\u0018\u0001\u0002;j[\u0016\u00042A`A\u0002\u001b\u0005y(bAA\u0001\u007f\u0005)Q\u000f^5mg&\u0019\u0011QA@\u0003\tQKW.Z\u0001\u0018GJ,\u0017\r^3TK\u001elWM\u001c;%I\u00164\u0017-\u001e7uII*\"!a\u0003+\u0007a\fia\u000b\u0002\u0002\u0010A!\u0011\u0011CA\u000e\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011!C;oG\",7m[3e\u0015\r\tIbM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u000f\u0003'\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003]\u0019'/Z1uKN+w-\\3oi\u0012\"WMZ1vYR$3'\u0006\u0002\u0002$)\u001aQ0!\u0004\u0002\u000fI,7m\u001c:egR1\u0011\u0011FA\u001b\u0003o\u0001B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_y\u0014A\u0002:fG>\u0014H-\u0003\u0003\u00024\u00055\"!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0003s\u0019\u0001\u00071\u000fC\u0004\u0002&1\u0001\r!!\u000f\u0011\u000bI\nY$a\u0010\n\u0007\u0005u2G\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002B!!\u0011\u0002P9!\u00111IA&!\r\t)eM\u0007\u0003\u0003\u000fR1!!\u00130\u0003\u0019a$o\\8u}%\u0019\u0011QJ\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t&a\u0015\u0003\rM#(/\u001b8h\u0015\r\tieM\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002S\"\u001aQ\"a\u0017\u0011\t\u0005u\u00131N\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005\u0019\u0011\r]5\u000b\t\u0005\u0015\u0014qM\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tI\u0007R\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003[\nyF\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0004\u001d\u0005M\u0004\u0003BA/\u0003kJA!a\u001e\u0002`\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001/i\u0016\u001cH/\u00119qK:$gi\u001c:M_\u001e\u001cVmZ7f]R|eMZ:fi>3XM\u001d4m_^,\u0005pY3qi&|g\u000eF\u0003j\u0003{\n\t\t\u0003\u0004\u0002\u0000=\u0001\ra]\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\bBBAB\u001f\u0001\u00071/A\u0007mCJ<Wm\u001d;PM\u001a\u001cX\r\u001e\u0015\b\u001f\u0005\u001d\u0015qSAM!\u0011\tI)a%\u000e\u0005\u0005-%\u0002BAG\u0003\u001f\u000b\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0003#\u000b\u0019'\u0001\u0004qCJ\fWn]\u0005\u0005\u0003+\u000bYIA\u0005DgZ\u001cv.\u001e:dK\u0006)a/\u00197vK2r\u00111TAP\u0003G\u000b9+a+\u00020\u0006M\u0016EAAO\u00039\u0001D\u0006I\u00173cQ:D\u0007O\u001a7ia\n#!!)\u0002\u001bAb\u0003EM\u00195oQB4G\u000e\u001b9C\t\t)+\u0001\u00032Y\u0001\u0002\u0014EAAU\u0003\u001d\t\u0004\u0007\r\u0017!cA\n#!!,\u0002\u001bI\nDg\u000e\u001b9gY\"\u0004\b\f\u00111C\t\t\t,\u0001\b.eE\"t\u0007\u000e\u001d4mQBD\u0006\t\u0019\"\u0005\u0005U\u0016!\u0006\u001a2i]\"\u0004h\r\u001c5q1\"$'\u000f\u001b:m]\u0012\u0014H\u000e\u0015\u0004\u001f\u0005e\u0006\u0003BA^\u0003{k!!a$\n\t\u0005}\u0016q\u0012\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018A\u0006;fgR\u0014V-\u00193P]\u0016k\u0007\u000f^=TK\u001elWM\u001c;)\u0007A\t)\r\u0005\u0003\u0002^\u0005\u001d\u0017\u0002BAe\u0003?\u0012A\u0001V3ti\u0006IB/Z:u%\u0016\fGMQ3g_J,g)\u001b:ti>3gm]3uQ\r\t\u0012QY\u0001\u0012i\u0016\u001cHOU3bI\u00063G/\u001a:MCN$\bf\u0001\n\u0002F\u0006yA/Z:u%\u0016\fGM\u0012:p[\u001e\u000b\u0007\u000fK\u0002\u0014\u0003\u000b\fA\u0002^3tiR\u0013XO\\2bi\u0016D3\u0001FAc\u0003a!Xm\u001d;UeVt7-\u0019;f\u000b6\u0004H/_*fO6,g\u000e\u001e\u0015\u0004+\u0005\u0015\u0017A\u000e;fgR\u0014V\r\\8bI2\u000b'oZ3tiRKW.Z:uC6\u0004\u0018I\u001c3OKb$xJ\u001a4tKR\fe\r^3s)J,hnY1uS>t\u0007f\u0001\f\u0002F\u0006\u0001B/Z:u)J,hnY1uK\u001a+H\u000e\u001c\u0015\u0004/\u0005\u0015\u0017!\u0007;fgR4\u0015N\u001c3PM\u001a\u001cX\r\u001e\"z)&lWm\u001d;b[BD3\u0001GAc\u0003e!Xm\u001d;OKb$xJ\u001a4tKR\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8)\u0007e\t)-\u0001\fuKN$8\t[1oO\u00164\u0015\u000e\\3Tk\u001a4\u0017\u000e_3tQ\rQ\u0012QY\u0001\u001ei\u0016\u001cHOU3d_Z,'/\u001f$jq\u0016\u001c8i\u001c:skB$\u0018J\u001c3fq\"\u001a1$!2\u00027Q,7\u000f\u001e*fG>4XM\u001d+sC:\u001c\u0018m\u0019;j_:Le\u000eZ3yQ\ra\u0012QY\u0001\u001fi\u0016\u001cHOU3d_Z,'/\u001f*fEVLG\u000eZ:Fa>\u001c\u0007nQ1dQ\u0016D3!HAc\u00035)g\u000e\u001a+y]J+7m\u001c:egR\u0001\u0012\u0011\u0006B\u0002\u0005\u001b\u0011\tBa\u0007\u0003\u001e\t\u0005\"Q\u0005\u0005\b\u0005\u000bq\u0002\u0019\u0001B\u0004\u0003E\u0019wN\u001c;s_2\u0014VmY8sIRK\b/\u001a\t\u0005\u0003W\u0011I!\u0003\u0003\u0003\f\u00055\"!E\"p]R\u0014x\u000e\u001c*fG>\u0014H\rV=qK\"1!q\u0002\u0010A\u0002M\f!\u0002\u001d:pIV\u001cWM]%e\u0011\u001d\u0011\u0019B\ba\u0001\u0005+\tQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007c\u0001\u001a\u0003\u0018%\u0019!\u0011D\u001a\u0003\u000bMCwN\u001d;\t\u000bIt\u0002\u0019A:\t\u0011\t}a\u0004%AA\u0002a\fA\u0003]1si&$\u0018n\u001c8MK\u0006$WM]#q_\u000eD\u0007\u0002\u0003B\u0012=A\u0005\t\u0019\u0001=\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007\u0002\u0003B\u0014=A\u0005\t\u0019A:\u0002\u0013QLW.Z:uC6\u0004\u0018aF3oIRChNU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003])g\u000e\u001a+y]J+7m\u001c:eg\u0012\"WMZ1vYR$c'A\ff]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!\u0011\u0007\u0016\u0004g\u00065\u0011!\t;fgR\u0014VmY8wKJLh)\u001b=fg\u000e{'O];qiRKW.Z%oI\u0016D\bf\u0001\u0012\u0002F\u0006qB/Z:u%\u0016\u001cwN^3ss^KG\u000f[\"peJ,\b\u000f^'fgN\fw-\u001a\u0015\u0004G\u0005\u0015G#C*\u0003>\t}\"\u0011\nB'\u0011\u0019\ty\b\na\u0001g\"9!\u0011\t\u0013A\u0002\t\r\u0013!\u00054jY\u0016\fEN]3bIf,\u00050[:ugB\u0019!G!\u0012\n\u0007\t\u001d3GA\u0004C_>dW-\u00198\t\r\t-C\u00051\u0001y\u00031Ig.\u001b;GS2,7+\u001b>f\u0011\u001d\u0011y\u0005\na\u0001\u0005\u0007\n1\u0002\u001d:fC2dwnY1uK\u00069C/Z:u\u0007J,\u0017\r^3XSRD\u0017J\\5u\r&dWmU5{K\u0006\u0003\b/\u001a8e\u001b\u0016\u001c8/Y4fQ\r)\u0013QY\u0001(i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0013:LGOR5mKNK'0Z\"mK\u0006\u00148\u000b[;uI><h\u000eK\u0002'\u0003\u000b\faf\u001d5pk2$GK];oG\u0006$X-\u0012<f]&3wJ\u001a4tKR\u0004v.\u001b8ugR{\u0017iR1q\u0013:$\u0006.\u001a'pO\"\u001aq%!2\u0002%Q,7\u000f^!qa\u0016tGM\u0012:p[\u001aKG.\u001a\u0015\u0004Q\u0005\u0015\u0017a\u00068foB\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s)\t\u0011)\u0007E\u0002U\u0005OJ1A!\u001bV\u0005Q\u0001&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u0002")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private File logDir;

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        LogSegment seg = LogTestUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public MemoryRecords records(long offset, Seq<String> records) {
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
    }

    @BeforeEach
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void teardown() {
        this.segments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @ParameterizedTest
    @CsvSource(value={"0, -2147483648", "0, 2147483648", "1, 0", "100, 10", "2147483648, 0", "-2147483648, 0", "2147483648,4294967296"})
    public void testAppendForLogSegmentOffsetOverflowException(long baseOffset, long largestOffset) {
        LogSegment seg = this.createSegment(baseOffset, this.createSegment$default$2(), this.createSegment$default$3());
        long currentTime = Time.SYSTEM.milliseconds();
        MemoryRecords memoryRecords = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
        Assertions.assertThrows(LogSegmentOffsetOverflowException.class, () -> seg.append(largestOffset, currentTime, largestOffset, memoryRecords));
    }

    @Test
    public void testReadOnEmptySegment() {
        Assertions.assertNull((Object)this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3()).read(40L, 300), (String)"Read beyond the last offset in the segment should be null");
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, -1L, -1L, ms);
        Records read = seg.read((long)41L, (int)300).records;
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        Assertions.assertNull((Object)seg.read(52L, 200), (String)"Read beyond the last offset in the segment should give null");
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records.records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords ms1 = this.records(offset$2.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)offset$2.elem, -1L, -1L, ms1);
            MemoryRecords ms2 = this.records(offset$2.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)(offset$2.elem + 1), -1L, -1L, ms2);
            FetchDataInfo read = seg.read((long)offset$2.elem, 10000);
            Assertions.assertEquals((Object)new .colon.colon((Object)((Record)ms1.records().iterator().next()), (List)new .colon.colon((Object)((Record)ms2.records().iterator().next()), (List)Nil$.MODULE$)), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(read.records.records()).asScala()).toList());
            seg.truncateTo((long)(offset$2.elem + 1));
            FetchDataInfo read2 = seg.read((long)offset$2.elem, 10000);
            Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(read2.records.records()).asScala()).size());
            TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records.records().iterator());
            ++offset$2.elem;
        });
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        long x$1 = 0L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.timeIndex();
        seg.offsetIndex();
        seg.close();
        long x$4 = 0L;
        int x$6 = this.createSegment$default$2();
        LogSegment reopened = this.createSegment(x$4, x$6, (Time)time);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().sizeInBytes());
        Assertions.assertEquals((int)0, (int)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assertions.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)reopened.timeIndex().isFull());
        Assertions.assertFalse((boolean)reopened.offsetIndex().isFull());
        RollParams rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        time.sleep((long)(maxSegmentMs + 1));
        Assertions.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, (long)Integer.MAX_VALUE + 200L, 1024, time.milliseconds());
        Assertions.assertTrue((boolean)reopened.shouldRoll(rollParams));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            seg.append((long)offset$3.elem, (long)offset$3.elem, (long)offset$3.elem, this.records(offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
            ++offset$3.elem;
        });
        Assertions.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assertions.assertEquals((int)expectedNumEntries, (int)seg.timeIndex().entries(), (String)new StringBuilder(25).append("Should have ").append(expectedNumEntries).append(" time indexes").toString());
        seg.truncateTo(41L);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().entries(), (String)"Should have 0 time indexes");
        Assertions.assertEquals((long)400L, (long)seg.largestTimestamp(), (String)"Largest timestamp should be 400");
        Assertions.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime();
        long x$1 = 40L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        time.sleep(500L);
        Assertions.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        seg.truncateTo(0L);
        Assertions.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)seg.timeIndex().isFull());
        Assertions.assertFalse((boolean)seg.offsetIndex().isFull());
        Assertions.assertNull((Object)seg.read(0L, 1024), (String)"Segment should be empty.");
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append("msg").append(i).toString()}))));
        Assertions.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assertions.assertEquals((long)42L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)420L, (long)0L).get()).offset);
        Assertions.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)421L, (long)0L).get()).offset);
        Assertions.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)430L, (long)0L).get()).offset);
        Assertions.assertEquals((long)44L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)431L, (long)0L).get()).offset);
        Assertions.assertEquals(Optional.empty(), (Object)seg.findOffsetByTimestamp(491L, 0L));
        Assertions.assertEquals((long)41L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)401L, (long)0L).get()).offset);
        Assertions.assertEquals((long)40L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)399L, (long)0L).get()).offset);
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assertions.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, -1L, -1L, this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assertions.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        File logFile = seg.log().file();
        File indexFile = seg.offsetIndexFile();
        File timeIndexFile = seg.timeIndexFile();
        Assertions.assertFalse((boolean)seg.offsetIndexFile().exists());
        Assertions.assertFalse((boolean)seg.timeIndexFile().exists());
        seg.changeFileSuffixes("", ".deleted");
        Assertions.assertFalse((boolean)seg.offsetIndexFile().exists());
        Assertions.assertFalse((boolean)seg.timeIndexFile().exists());
        Assertions.assertEquals((Object)new StringBuilder(8).append(logFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(indexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.offsetIndexFile().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(timeIndexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.timeIndexFile().getAbsolutePath());
        Assertions.assertTrue((boolean)seg.log().file().exists());
        seg.offsetIndex();
        Assertions.assertTrue((boolean)seg.offsetIndexFile().exists());
        seg.timeIndex();
        Assertions.assertTrue((boolean)seg.timeIndexFile().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, -1L, -1L, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File indexFile = seg.offsetIndexFile();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(this.newProducerStateManager(), Optional.empty());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Iterable records = seg$5.read((long)((long)i), (int)1, (long)((long)seg$5.size()), (boolean)true).records.records();
            Assertions.assertEquals((long)i, (long)((Record)records.iterator().next()).offset());
        });
    }

    @Test
    public void testRecoverTransactionIndex() {
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        segment.append(101L, -1L, 100L, MemoryRecords.withTransactionalRecords((long)100L, (CompressionType)CompressionType.NONE, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(103L, -1L, 102L, MemoryRecords.withTransactionalRecords((long)102L, (CompressionType)CompressionType.NONE, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(partitionLeaderEpoch), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(106L, -1L, 106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        segment.append(107L, -1L, 107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        ProducerStateManager stateManager = this.newProducerStateManager();
        segment.recover(stateManager, Optional.empty());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        java.util.List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.get(0);
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = this.newProducerStateManager();
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, producerEpoch, 0, -1L, OptionalLong.of(75L), Optional.of(new BatchMetadata(10, 10L, 5, -1L))));
        segment.recover(stateManager, Optional.empty());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.get(0);
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRecoveryRebuildsEpochCache() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
            private Seq<EpochEntry> epochs;

            public void write(Collection<EpochEntry> x$1) {
                super.write(x$1);
            }

            private Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public void write(Collection<EpochEntry> epochs, boolean ignored) {
                this.epochs_$eq((Seq<EpochEntry>)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(epochs).asScala()).toSeq());
            }

            public java.util.List<EpochEntry> read() {
                return (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.epochs()).asJava();
            }
            {
                this.epochs = Nil$.MODULE$;
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.topicPartition(), checkpoint);
        seg.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(107L, -1L, 106L, MemoryRecords.withRecords((long)106L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(1), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(109L, -1L, 108L, MemoryRecords.withRecords((long)108L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(1), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(111L, -1L, 110L, MemoryRecords.withRecords((long)110L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.recover(this.newProducerStateManager(), Optional.of(cache));
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(0, 104L), new EpochEntry(1, 106L), new EpochEntry(2, 110L)}), (Object)cache.epochEntries());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, (long)(i * 10), (long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File timeIndexFile = seg.timeIndexFile();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(this.newProducerStateManager(), Optional.empty());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)seg$6.findOffsetByTimestamp((long)((long)(i * 10)), (long)0L).get()).offset);
            if (i < 99) {
                Assertions.assertEquals((long)(i + 1), (long)((FileRecords.TimestampAndOffset)seg$6.findOffsetByTimestamp((long)((long)(i * 10 + 1)), (long)0L).get()).offset);
                return;
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messagesAppended).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, -1L, -1L, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
            int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended);
            int position = seg.log().searchForOffsetWithSize((long)((long)offsetToBeginCorruption), (int)0).position + TestUtils$.MODULE$.random().nextInt(15);
            TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
            seg.recover(this.newProducerStateManager(), Optional.empty());
            Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(seg.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.lastOffset()), Iterable$.MODULE$.canBuildFrom())).toList(), (String)"Should have truncated off bad messages.");
            seg.deleteIfExists();
        });
    }

    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.interval.bytes"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.index.bytes"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.jitter.ms"), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava());
        LogSegment seg = LogSegment.open((File)tempDir, (long)baseOffset, (LogConfig)logConfig, (Time)Time.SYSTEM, (boolean)fileAlreadyExists, (int)initFileSize, (boolean)preallocate, (String)"");
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records.records().iterator());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.interval.bytes"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.index.bytes"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.jitter.ms"), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava());
        LogSegment seg = LogSegment.open((File)tempDir, (long)40L, (LogConfig)logConfig, (Time)Time.SYSTEM, (int)0x20000000, (boolean)true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records.records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assertions.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assertions.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment.open((File)tempDir, (long)40L, (LogConfig)logConfig, (Time)Time.SYSTEM, (boolean)true, (int)0x20000000, (boolean)true, (String)"");
        this.segments().$plus$eq((Object)segReopen);
        FetchDataInfo readAgain = segReopen.read(55L, 200);
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records.records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assertions.assertEquals((long)oldPosition, (long)position);
        Assertions.assertEquals((int)oldSize, (int)size);
        Assertions.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, -1L, -1L, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), -1L, -1L, ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, 10000);
        Assertions.assertEquals((long)offset, (long)((RecordBatch)log.records.batches().iterator().next()).baseOffset());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(log.records.batches()).asScala()).size());
    }

    @Test
    public void testAppendFromFile() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        FileRecords fileRecords = FileRecords.open((File)LogFileUtils.logFile((File)tempDir, (long)0L));
        fileRecords.append(LogSegmentTest.records$2(0L, 1024));
        fileRecords.append(LogSegmentTest.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(LogSegmentTest.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)bytesAppended);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assertions.assertEquals((int)(sizeAfterOverflow - sizeBeforeOverflow), (int)overflowBytesAppended);
        Assertions.assertEquals((int)overflowBytesAppended, (int)overflowSegment.size());
        Utils.delete((File)tempDir);
    }

    private ProducerStateManager newProducerStateManager() {
        return new ProducerStateManager(this.topicPartition(), this.logDir(), 300000, new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false), (Time)new MockTime());
    }

    private static final MemoryRecords records$1(long offset, String record) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())});
    }

    private static final MemoryRecords records$2(long offset, int size) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new byte[size])});
    }
}

