/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001\u0002\n\u0014\u0001aAQa\b\u0001\u0005\u0002\u0001Bqa\t\u0001C\u0002\u0013\u0005A\u0005\u0003\u00041\u0001\u0001\u0006I!\n\u0005\nc\u0001\u0001\r\u00111A\u0005\u0002IB\u0011b\u000f\u0001A\u0002\u0003\u0007I\u0011\u0001\u001f\t\u0013\t\u0003\u0001\u0019!A!B\u0013\u0019\u0004\"B\"\u0001\t\u0013!\u0005b\u00021\u0001#\u0003%I!\u0019\u0005\bY\u0002\t\n\u0011\"\u0003n\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015a\b\u0001\"\u0001q\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAa!!\u000f\u0001\t\u0003\u0001\bBBA\"\u0001\u0011\u0005\u0001\u000f\u0003\u0004\u0002H\u0001!\t\u0001\u001d\u0005\u0007\u0003\u0017\u0002A\u0011\u00019\t\r\u0005=\u0003\u0001\"\u0001q\u0005=aunZ*fO6,g\u000e^:UKN$(B\u0001\u000b\u0016\u0003\rawn\u001a\u0006\u0002-\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001a!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\t\t\u0003E\u0001i\u0011aE\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005)\u0003C\u0001\u0014/\u001b\u00059#B\u0001\u0015*\u0003\u0019\u0019w.\\7p]*\u0011aC\u000b\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014x-\u0003\u00020O\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\r1|w\rR5s+\u0005\u0019\u0004C\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\tIwNC\u00019\u0003\u0011Q\u0017M^1\n\u0005i*$\u0001\u0002$jY\u0016\f!\u0002\\8h\t&\u0014x\fJ3r)\ti\u0004\t\u0005\u0002\u001b}%\u0011qh\u0007\u0002\u0005+:LG\u000fC\u0004B\u000b\u0005\u0005\t\u0019A\u001a\u0002\u0007a$\u0013'A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u001b\r\u0014X-\u0019;f'\u0016<W.\u001a8u)\u0011)ej\u0015-\u0011\u0005\u0019cU\"A$\u000b\u0005QA%BA%K\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002LS\u000591\u000f^8sC\u001e,\u0017BA'H\u0005)aunZ*fO6,g\u000e\u001e\u0005\u0006\u001f\u001e\u0001\r\u0001U\u0001\u0007_\u001a47/\u001a;\u0011\u0005i\t\u0016B\u0001*\u001c\u0005\u0011auN\\4\t\u000fQ;\u0001\u0013!a\u0001+\u0006\u0011\u0012N\u001c3fq&sG/\u001a:wC2\u0014\u0015\u0010^3t!\tQb+\u0003\u0002X7\t\u0019\u0011J\u001c;\t\u000fe;\u0001\u0013!a\u00015\u0006!A/[7f!\tYf,D\u0001]\u0015\tiv%A\u0003vi&d7/\u0003\u0002`9\n!A+[7f\u0003]\u0019'/Z1uKN+w-\\3oi\u0012\"WMZ1vYR$#'F\u0001cU\t)6mK\u0001e!\t)'.D\u0001g\u0015\t9\u0007.A\u0005v]\u000eDWmY6fI*\u0011\u0011nG\u0001\u000bC:tw\u000e^1uS>t\u0017BA6g\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0018GJ,\u0017\r^3TK\u001elWM\u001c;%I\u00164\u0017-\u001e7uIM*\u0012A\u001c\u0016\u00035\u000e\fQa]3ukB$\u0012!\u0010\u0015\u0003\u0015I\u0004\"a\u001d>\u000e\u0003QT!!\u001e<\u0002\u0007\u0005\u0004\u0018N\u0003\u0002xq\u00069!.\u001e9ji\u0016\u0014(BA=-\u0003\u0015QWO\\5u\u0013\tYHO\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0003\u0017y\u0004\"a]@\n\u0007\u0005\u0005AOA\u0005BMR,'/R1dQ\u0006Y\u0011m]:feR,e\u000e\u001e:z)\u0015i\u0014qAA\u0006\u0011\u0019\tI\u0001\u0004a\u0001\u000b\u000691/Z4nK:$\bbBA\u0007\u0019\u0001\u0007\u0011qB\u0001\u0007i\u0016\u001cH/\u001a3\u0011\u000f\u0005E\u0011\u0011FA\u0018\u000b:!\u00111CA\u0012\u001d\u0011\t)\"a\b\u000f\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007\u0018\u0003\u0019a$o\\8u}%\t\u0001(C\u0002\u0002\"]\nA!\u001e;jY&!\u0011QEA\u0014\u0003\ri\u0015\r\u001d\u0006\u0004\u0003C9\u0014\u0002BA\u0016\u0003[\u0011Q!\u00128uefTA!!\n\u0002(A!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026]\nA\u0001\\1oO&\u0019!+a\r\u0002'Q,7\u000f\u001e\"bg&\u001cw\n]3sCRLwN\\:)\u00075\ti\u0004E\u0002t\u0003\u007fI1!!\u0011u\u0005\u0011!Vm\u001d;\u0002#Q,7\u000f^*fO6,g\u000e^!dG\u0016\u001c8\u000fK\u0002\u000f\u0003{\t!\u0004^3ti\u000ecwn]3ti6\u000bGo\u00195Pa\u0016\u0014\u0018\r^5p]ND3aDA\u001f\u0003I!Xm\u001d;IS\u001eDWM]*fO6,g\u000e^:)\u0007A\ti$\u0001\u000buKN$8+\u001b>f\r>\u0014H*\u0019:hK2{wm\u001d\u0015\u0004#\u0005u\u0002")
public class LogSegmentsTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private File logDir;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        return LogTestUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
    }

    private int createSegment$default$2() {
        return 10;
    }

    private Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @BeforeEach
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void teardown() {
        Utils.delete((File)this.logDir());
    }

    private void assertEntry(LogSegment segment, Map.Entry<Long, LogSegment> tested) {
        Assertions.assertEquals((long)segment.baseOffset(), (Long)tested.getKey());
        Assertions.assertEquals((Object)segment, (Object)tested.getValue());
    }

    @Test
    public void testBasicOperations() {
        LogSegments segments = new LogSegments(this.topicPartition());
        Assertions.assertTrue((boolean)segments.isEmpty());
        Assertions.assertFalse((boolean)segments.nonEmpty());
        int offset1 = 40;
        LogSegment seg1 = this.createSegment(offset1, this.createSegment$default$2(), this.createSegment$default$3());
        int offset2 = 80;
        LogSegment seg2 = this.createSegment(offset2, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg3 = this.createSegment(offset1, this.createSegment$default$2(), this.createSegment$default$3());
        segments.add(seg1);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)1, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset1));
        Assertions.assertEquals(Optional.of(seg1), (Object)segments.get((long)offset1));
        segments.add(seg2);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)2, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset2));
        Assertions.assertEquals(Optional.of(seg2), (Object)segments.get((long)offset2));
        segments.add(seg3);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)2, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset1));
        Assertions.assertEquals(Optional.of(seg3), (Object)segments.get((long)offset1));
        segments.remove((long)offset2);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)1, (int)segments.numberOfSegments());
        Assertions.assertFalse((boolean)segments.contains((long)offset2));
        segments.clear();
        Assertions.assertTrue((boolean)segments.isEmpty());
        Assertions.assertFalse((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)0, (int)segments.numberOfSegments());
        Assertions.assertFalse((boolean)segments.contains((long)offset1));
        segments.close();
    }

    @Test
    public void testSegmentAccess() {
        LogSegments segments = new LogSegments(this.topicPartition());
        int offset1 = 1;
        LogSegment seg1 = this.createSegment(offset1, this.createSegment$default$2(), this.createSegment$default$3());
        int offset2 = 2;
        LogSegment seg2 = this.createSegment(offset2, this.createSegment$default$2(), this.createSegment$default$3());
        int offset3 = 3;
        LogSegment seg3 = this.createSegment(offset3, this.createSegment$default$2(), this.createSegment$default$3());
        int offset4 = 4;
        LogSegment seg4 = this.createSegment(offset4, this.createSegment$default$2(), this.createSegment$default$3());
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)seg -> {
            LogSegmentsTest.$anonfun$testSegmentAccess$1(this, segments, seg1, seg);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{offset1, offset2, offset3, offset4})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(segments.baseOffsets()).asScala()).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(segments.values()).asScala()).toSeq());
        Assertions.assertThrows(IllegalArgumentException.class, () -> segments.values(2L, 1L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(segments.values(1L, 1L)).asScala()).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)Nil$.MODULE$), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(segments.values(1L, 2L)).asScala()).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)Nil$.MODULE$)), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(segments.values(1L, 3L)).asScala()).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)Nil$.MODULE$))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(segments.values(1L, 4L)).asScala()).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)Nil$.MODULE$)), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(segments.values(2L, 4L)).asScala()).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg3, (List)Nil$.MODULE$), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(segments.values(3L, 4L)).asScala()).toSeq());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(segments.values(4L, 4L)).asScala()).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg4, (List)Nil$.MODULE$), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(segments.values(4L, 5L)).asScala()).toSeq());
        segments.close();
    }

    @Test
    public void testClosestMatchOperations() {
        LogSegments segments = new LogSegments(this.topicPartition());
        LogSegment seg1 = this.createSegment(1L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg2 = this.createSegment(3L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg3 = this.createSegment(5L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg4 = this.createSegment(7L, this.createSegment$default$2(), this.createSegment$default$3());
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> segments.add(x$1));
        Assertions.assertEquals(Optional.of(seg1), (Object)segments.floorSegment(2L));
        Assertions.assertEquals(Optional.of(seg2), (Object)segments.floorSegment(3L));
        Assertions.assertEquals(Optional.of(seg1), (Object)segments.lowerSegment(3L));
        Assertions.assertEquals(Optional.of(seg2), (Object)segments.lowerSegment(4L));
        Assertions.assertEquals(Optional.of(seg3), (Object)segments.higherSegment(4L));
        this.assertEntry(seg3, (Map.Entry)segments.higherEntry(4L).get());
        Assertions.assertEquals(Optional.of(seg4), (Object)segments.higherSegment(5L));
        this.assertEntry(seg4, (Map.Entry)segments.higherEntry(5L).get());
        segments.close();
    }

    @Test
    public void testHigherSegments() {
        LogSegments segments = new LogSegments(this.topicPartition());
        LogSegment seg1 = this.createSegment(1L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg2 = this.createSegment(3L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg3 = this.createSegment(5L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg4 = this.createSegment(7L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg5 = this.createSegment(9L, this.createSegment$default$2(), this.createSegment$default$3());
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> segments.add(x$1));
        Iterator iterator = segments.higherSegments(0L).iterator();
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogSegmentsTest.$anonfun$testHigherSegments$2(iterator, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = segments.higherSegments(1L).iterator();
        new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogSegmentsTest.$anonfun$testHigherSegments$3(iterator2, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)iterator2.hasNext());
        Iterator iterator3 = segments.higherSegments(8L).iterator();
        Assertions.assertTrue((boolean)iterator3.hasNext());
        Assertions.assertEquals((Object)seg5, iterator3.next());
        Assertions.assertFalse((boolean)iterator3.hasNext());
        Assertions.assertFalse((boolean)segments.higherSegments(9L).iterator().hasNext());
    }

    @Test
    public void testSizeForLargeLogs() {
        long largeSize = (long)Integer.MAX_VALUE * 2L;
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        Assertions.assertEquals((long)Integer.MAX_VALUE, (long)LogSegments.sizeInBytes(Arrays.asList((Object[])new LogSegment[]{logSegment})));
        Assertions.assertEquals((long)largeSize, (long)LogSegments.sizeInBytes(Arrays.asList((Object[])new LogSegment[]{logSegment, logSegment})));
        Assertions.assertTrue((UnifiedLog$.MODULE$.sizeInBytes(Arrays.asList((Object[])new LogSegment[]{logSegment, logSegment})) > Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSegmentAccess$1(LogSegmentsTest $this, LogSegments segments$1, LogSegment seg1$1, LogSegment seg) {
        segments$1.add(seg);
        $this.assertEntry(seg1$1, (Map.Entry)segments$1.firstEntry().get());
        Assertions.assertEquals(Optional.of(seg1$1), (Object)segments$1.firstSegment());
        $this.assertEntry(seg, (Map.Entry)segments$1.lastEntry().get());
        Assertions.assertEquals(Optional.of(seg), (Object)segments$1.lastSegment());
    }

    public static final /* synthetic */ void $anonfun$testHigherSegments$2(Iterator iterator$1, LogSegment segment) {
        Assertions.assertTrue((boolean)iterator$1.hasNext());
        Assertions.assertEquals((Object)segment, iterator$1.next());
    }

    public static final /* synthetic */ void $anonfun$testHigherSegments$3(Iterator iterator$2, LogSegment segment) {
        Assertions.assertTrue((boolean)iterator$2.hasNext());
        Assertions.assertEquals((Object)segment, iterator$2.next());
    }
}

