/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import kafka.log.OffsetMapTest$;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001m4A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)q\u0006\u0001C\u0001=!)\u0011\u0007\u0001C\u0001=!)1\u0007\u0001C\u0001i!)\u0011\t\u0001C\u0001\u0005\"9\u0011\fAI\u0001\n\u0003Qv!B3\u000e\u0011\u00031g!\u0002\u0007\u000e\u0011\u00039\u0007\"B\r\n\t\u0003A\u0007\"B5\n\t\u0003Q'!D(gMN,G/T1q)\u0016\u001cHO\u0003\u0002\u000f\u001f\u0005\u0019An\\4\u000b\u0003A\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"A\u0007\u0002'Q,7\u000f\u001e\"bg&\u001cg+\u00197jI\u0006$\u0018n\u001c8\u0015\u0003}\u0001\"\u0001\u0006\u0011\n\u0005\u0005*\"\u0001B+oSRD#AA\u0012\u0011\u0005\u0011jS\"A\u0013\u000b\u0005\u0019:\u0013aA1qS*\u0011\u0001&K\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQ3&A\u0003kk:LGOC\u0001-\u0003\ry'oZ\u0005\u0003]\u0015\u0012A\u0001V3ti\u0006IA/Z:u\u00072,\u0017M\u001d\u0015\u0003\u0007\r\nq\u0002^3ti\u001e+Go\u00165f]\u001a+H\u000e\u001c\u0015\u0003\t\r\n1a[3z)\t)T\b\u0005\u00027w5\tqG\u0003\u00029s\u0005\u0019a.[8\u000b\u0003i\nAA[1wC&\u0011Ah\u000e\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B\u001a\u0006\u0001\u0004q\u0004C\u0001\u000b@\u0013\t\u0001UC\u0001\u0003M_:<\u0017a\u0003<bY&$\u0017\r^3NCB$2aQ(U!\t!U*D\u0001F\u0015\tqaI\u0003\u0002H\u0011\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003\u0013*\u000bqa\u001d;pe\u0006<WM\u0003\u0002\u0011\u0017*\u0011AjK\u0001\u0007CB\f7\r[3\n\u00059+%aD*lS6\u0004\u0018p\u00144gg\u0016$X*\u00199\t\u000bA3\u0001\u0019A)\u0002\u000b%$X-\\:\u0011\u0005Q\u0011\u0016BA*\u0016\u0005\rIe\u000e\u001e\u0005\b+\u001a\u0001\n\u00111\u0001W\u0003)aw.\u00193GC\u000e$xN\u001d\t\u0003)]K!\u0001W\u000b\u0003\r\u0011{WO\u00197f\u0003U1\u0018\r\\5eCR,W*\u00199%I\u00164\u0017-\u001e7uII*\u0012a\u0017\u0016\u0003-r[\u0013!\u0018\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\t,\u0012AC1o]>$\u0018\r^5p]&\u0011Am\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!D(gMN,G/T1q)\u0016\u001cH\u000f\u0005\u0002\u001d\u0013M\u0011\u0011b\u0005\u000b\u0002M\u0006!Q.Y5o)\ty2\u000eC\u0003m\u0017\u0001\u0007Q.\u0001\u0003be\u001e\u001c\bc\u0001\u000boa&\u0011q.\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003cbt!A\u001d<\u0011\u0005M,R\"\u0001;\u000b\u0005U\f\u0012A\u0002\u001fs_>$h(\u0003\u0002x+\u00051\u0001K]3eK\u001aL!!\u001f>\u0003\rM#(/\u001b8h\u0015\t9X\u0003")
public class OffsetMapTest {
    public static void main(String[] stringArray) {
        OffsetMapTest$.MODULE$.main(stringArray);
    }

    @Test
    public void testBasicValidation() {
        this.validateMap(10, this.validateMap$default$2());
        this.validateMap(100, this.validateMap$default$2());
        this.validateMap(1000, this.validateMap$default$2());
        this.validateMap(5000, this.validateMap$default$2());
    }

    @Test
    public void testClear() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4000);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> map.put(this.key(i), (long)i));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> Assertions.assertEquals((long)i, (long)map.get(this.key(i))));
        map.clear();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> Assertions.assertEquals((long)map.get(this.key(i)), (long)-1L));
    }

    @Test
    public void testGetWhenFull() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4096);
        long i = 37L;
        while (map.size() < map.slots()) {
            map.put(this.key(i), i);
            ++i;
        }
        Assertions.assertEquals((long)map.get(this.key(i)), (long)-1L);
        Assertions.assertEquals((long)map.get(this.key(i - 1L)), (long)(i - 1L));
    }

    public ByteBuffer key(long key) {
        return ByteBuffer.wrap(Long.toString(key).getBytes());
    }

    public SkimpyOffsetMap validateMap(int items, double loadFactor) {
        SkimpyOffsetMap map = new SkimpyOffsetMap((int)((double)items / loadFactor * (double)24));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> map.put(this.key(i), (long)i));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> Assertions.assertEquals((long)map.get(this.key(i)), (long)i));
        return map;
    }

    public double validateMap$default$2() {
        return 0.5;
    }
}

