/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.AbstractIndex;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.RemoteIndexCache;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u0005g\u0001\u0002'N\u0001QCQa\u0017\u0001\u0005\u0002qCqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004e\u0001\u0001\u0006I!\u0019\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0011\u0019y\u0007\u0001)A\u0005O\"9\u0001\u000f\u0001b\u0001\n\u0013\t\bBB?\u0001A\u0003%!\u000fC\u0004\u007f\u0001\t\u0007I\u0011B@\t\u0011\u0005\u001d\u0001\u0001)A\u0005\u0003\u0003A\u0001\"!\u0003\u0001\u0005\u0004%I\u0001\u0019\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003b\u0011!\ti\u0001\u0001b\u0001\n\u0013\u0001\u0007bBA\b\u0001\u0001\u0006I!\u0019\u0005\t\u0003#\u0001!\u0019!C\u0005\u007f\"A\u00111\u0003\u0001!\u0002\u0013\t\t\u0001C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0003\u0002\u0018!A\u0011\u0011\u0006\u0001!\u0002\u0013\tI\u0002C\u0006\u0002,\u0001\u0001\r\u00111A\u0005\n\u00055\u0002bCA \u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0003B1\"!\u0014\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00020!Y\u0011q\n\u0001A\u0002\u0003\u0007I\u0011BA)\u0011-\tI\u0006\u0001a\u0001\u0002\u0004%I!a\u0017\t\u0017\u0005}\u0003\u00011A\u0001B\u0003&\u00111\u000b\u0005\f\u0003C\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0007C\u0006\u0002v\u0001\u0001\r\u00111A\u0005\n\u0005]\u0004bCA>\u0001\u0001\u0007\t\u0011)Q\u0005\u0003KB1\"! \u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002d!Y\u0011q\u0010\u0001A\u0002\u0003\u0007I\u0011BAA\u0011-\t)\t\u0001a\u0001\u0002\u0003\u0006K!!\u001a\t\u0017\u0005\u001d\u0005\u00011AA\u0002\u0013%\u0011\u0011\u0012\u0005\f\u0003/\u0003\u0001\u0019!a\u0001\n\u0013\tI\nC\u0006\u0002\u001e\u0002\u0001\r\u0011!Q!\n\u0005-\u0005bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003s\u0003A\u0011AAQ\u0011\u001d\t\u0019\r\u0001C\u0001\u0003CCq!!4\u0001\t\u0003\t\t\u000bC\u0004\u0002R\u0002!\t!!)\t\u000f\u0005U\u0007\u0001\"\u0001\u0002\"\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005\u0005\u0006bBAo\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003C\u0004A\u0011AAQ\u0011\u001d\t)\u000f\u0001C\u0001\u0003CCq!!;\u0001\t\u0003\t\t\u000bC\u0004\u0002n\u0002!\t!!)\t\u000f\u0005E\b\u0001\"\u0001\u0002\"\"9\u0011Q\u001f\u0001\u0005\u0002\u0005\u0005\u0006bBA}\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003{\u0004A\u0011AAQ\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0003CCqA!\u0002\u0001\t\u0003\t\t\u000bC\u0004\u0003\n\u0001!\t!!)\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010!9!Q\u000f\u0001\u0005\u0002\u0005\u0005\u0006b\u0002B=\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0005{\u0002A\u0011AAQ\u0011\u001d\u0011\t\t\u0001C\u0001\u0005\u0007CqAa$\u0001\t\u0003\t\t\u000bC\u0004\u0003\u0014\u0002!IA!&\t\u0013\t=\u0006!%A\u0005\n\tE\u0006b\u0002Bd\u0001\u0011%!\u0011\u001a\u0005\b\u0005;\u0004A\u0011\u0002Bp\u0011\u001d\u0011)\u000f\u0001C\u0005\u0005OD\u0011ba\u0001\u0001#\u0003%Ia!\u0002\t\u000f\r%\u0001\u0001\"\u0003\u0004\f!911\u0004\u0001\u0005\n\ru\u0001bBB\u0012\u0001\u0011%1Q\u0005\u0005\b\u0007c\u0001A\u0011BB\u001a\u0011\u001d\u0019y\u0004\u0001C\u0005\u0007\u0003Bqa!\u0015\u0001\t\u0013\u0019\u0019\u0006C\u0004\u0004^\u0001!Iaa\u0018\t\u000f\r\u0005\u0004\u0001\"\u0003\u0004d!91q\r\u0001\u0005\n\r%\u0004bBB7\u0001\u0011%1q\u000e\u0005\b\u0007g\u0002A\u0011BB;\u0011\u001d\u0019Y\b\u0001C\u0005\u0007{\u0012ACU3n_R,\u0017J\u001c3fq\u000e\u000b7\r[3UKN$(B\u0001(P\u0003\u0019\u0011X-\\8uK*\u0011\u0001+U\u0001\u0004Y><'\"\u0001*\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00021\u0006)1oY1mC&\u0011!l\u0016\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0006C\u00010\u0001\u001b\u0005i\u0015\u0001\t3fM\u0006,H\u000e\u001e*f[>$X-\u00138eKb\u001c\u0015m\u00195f'&TXMQ=uKN,\u0012!\u0019\t\u0003-\nL!aY,\u0003\t1{gnZ\u0001\"I\u00164\u0017-\u001e7u%\u0016lw\u000e^3J]\u0012,\u0007pQ1dQ\u0016\u001c\u0016N_3CsR,7\u000fI\u0001\u0007Y><w-\u001a:\u0016\u0003\u001d\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u000bMdg\r\u000e6\u000b\u00031\f1a\u001c:h\u0013\tq\u0017N\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u0011!\u0018.\\3\u0016\u0003I\u0004\"a]>\u000e\u0003QT!!\u001e<\u0002\tU$\u0018\u000e\u001c\u0006\u0003ob\faa]3sm\u0016\u0014(B\u0001*z\u0015\tQ8.\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003yR\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\tEJ|7.\u001a:JIV\u0011\u0011\u0011\u0001\t\u0004-\u0006\r\u0011bAA\u0003/\n\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013A\u00032bg\u0016|eMZ:fi\u0006Y!-Y:f\u001f\u001a47/\u001a;!\u0003)a\u0017m\u001d;PM\u001a\u001cX\r^\u0001\fY\u0006\u001cHo\u00144gg\u0016$\b%A\u0006tK\u001elWM\u001c;TSj,\u0017\u0001D:fO6,g\u000e^*ju\u0016\u0004\u0013a\u0001:t[V\u0011\u0011\u0011\u0004\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u001d\u0019Ho\u001c:bO\u0016T1ATA\u0012\u0015\t\u0001f/\u0003\u0003\u0002(\u0005u!\u0001\u0006*f[>$Xm\u0015;pe\u0006<W-T1oC\u001e,'/\u0001\u0003sg6\u0004\u0013!B2bG\",WCAA\u0018!\u0011\t\t$a\u000f\u000e\u0005\u0005M\"b\u0001)\u00026)!\u0011qGA\u001d\u0003%Ig\u000e^3s]\u0006d7OC\u0002\u0002 aLA!!\u0010\u00024\t\u0001\"+Z7pi\u0016Le\u000eZ3y\u0007\u0006\u001c\u0007.Z\u0001\nG\u0006\u001c\u0007.Z0%KF$B!a\u0011\u0002JA\u0019a+!\u0012\n\u0007\u0005\u001dsK\u0001\u0003V]&$\b\"CA&'\u0005\u0005\t\u0019AA\u0018\u0003\rAH%M\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\u0002\u0017Id7/T3uC\u0012\fG/Y\u000b\u0003\u0003'\u0002B!a\u0007\u0002V%!\u0011qKA\u000f\u0005a\u0011V-\\8uK2{wmU3h[\u0016tG/T3uC\u0012\fG/Y\u0001\u0010e2\u001cX*\u001a;bI\u0006$\u0018m\u0018\u0013fcR!\u00111IA/\u0011%\tYEFA\u0001\u0002\u0004\t\u0019&\u0001\u0007sYNlU\r^1eCR\f\u0007%\u0001\u0004m_\u001e$\u0015N]\u000b\u0003\u0003K\u0002B!a\u001a\u0002r5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'\u0001\u0002j_*\u0011\u0011qN\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002t\u0005%$\u0001\u0002$jY\u0016\f!\u0002\\8h\t&\u0014x\fJ3r)\u0011\t\u0019%!\u001f\t\u0013\u0005-\u0013$!AA\u0002\u0005\u0015\u0014a\u00027pO\u0012K'\u000fI\u0001\u0006iB$\u0015N]\u0001\niB$\u0015N]0%KF$B!a\u0011\u0002\u0004\"I\u00111\n\u000f\u0002\u0002\u0003\u0007\u0011QM\u0001\u0007iB$\u0015N\u001d\u0011\u0002\u0017%$\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003\u0017\u0003B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0004\u0003#C\u0018AB2p[6|g.\u0003\u0003\u0002\u0016\u0006=%\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003=IG\rU1si&$\u0018n\u001c8`I\u0015\fH\u0003BA\"\u00037C\u0011\"a\u0013 \u0003\u0003\u0005\r!a#\u0002\u0019%$\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u000bM,G/\u001e9\u0015\u0005\u0005\r\u0003fA\u0011\u0002&B!\u0011qUA[\u001b\t\tIK\u0003\u0003\u0002,\u00065\u0016aA1qS*!\u0011qVAY\u0003\u001dQW\u000f]5uKJT1!a-l\u0003\u0015QWO\\5u\u0013\u0011\t9,!+\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0004dY\u0016\fg.\u001e9)\u0007\t\ni\f\u0005\u0003\u0002(\u0006}\u0016\u0002BAa\u0003S\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002EQ,7\u000f^%oI\u0016Dh)\u001b7f\u001d\u0006lW-\u00118e\u0019>\u001c\u0017\r^5p]>sG)[:lQ\r\u0019\u0013q\u0019\t\u0005\u0003O\u000bI-\u0003\u0003\u0002L\u0006%&\u0001\u0002+fgR\fq\u0004^3ti\u001a+Go\u00195J]\u0012,\u0007P\u0012:p[J+Wn\u001c;f'R|'/Y4fQ\r!\u0013qY\u0001)i\u0016\u001cHOR3uG\"Le\u000eZ3y\r>\u0014X*[:tS:<GK]1og\u0006\u001cG/[8o\u0013:$W\r\u001f\u0015\u0004K\u0005\u001d\u0017\u0001\r;fgR\u0004vn]5uS>tgi\u001c:O_:,\u00050[:uS:<\u0017J\u001c3fq\u001a\u0013x.\u001c*f[>$Xm\u0015;pe\u0006<W\rK\u0002'\u0003\u000f\fA\u0003^3ti\u000e\u000b7\r[3F]R\u0014\u00180\u0012=qSJL\bfA\u0014\u0002H\u0006YB/Z:u\u000f\u0016$\u0018J\u001c3fq\u00063G/\u001a:DC\u000eDWm\u00117pg\u0016D3\u0001KAd\u0003U!Xm\u001d;DY>\u001cX-S:JI\u0016l\u0007o\u001c;f]RD3!KAd\u0003\u0001\"Xm\u001d;DC\u000eDW-\u00128uefL5\u000fR3mKR,Gm\u00148SK6|g/\u00197)\u0007)\n9-A\ruKN$8\t\\3b]\u0016\u0014H\u000b\u001b:fC\u0012\u001c\u0006.\u001e;e_^t\u0007fA\u0016\u0002H\u0006IA/Z:u\u00072|7/\u001a\u0015\u0004Y\u0005\u001d\u0017!\n;fgR\u001cuN\\2veJ,g\u000e\u001e*fC\u0012<&/\u001b;f\u0003\u000e\u001cWm]:G_J\u001c\u0015m\u00195fQ\ri\u0013qY\u0001\u001ai\u0016\u001cHOU3m_\u0006$7)Y2iK\u00063G/\u001a:DY>\u001cX\rK\u0002/\u0003\u000f\fa\u0002^3tiJ+Wn\u001c<f\u0013R,W\u000eK\u00020\u0003\u000f\f\u0011\u0004^3tiJ+Wn\u001c<f\u001d>tW\t_5ti\u0016tG/\u0013;f[\"\u001a\u0001'a2\u0002/Q,7\u000f\u001e*f[>4X-T;mi&\u0004H.Z%uK6\u001c\bfA\u0019\u0002H\u0006QC/Z:u\u00072,\u0017M]\"bG\",\u0017I\u001c3J]\u0012,\u0007PR5mKN<\u0006.\u001a8SKNL'0Z\"bG\",\u0007f\u0001\u001a\u0002H\u0006\u0019D/Z:u\u0007>\u0014(/Z2u]\u0016\u001c8OR8s\u0007\u0006\u001c\u0007.Z!oI&sG-\u001a=GS2,7o\u00165f]J+7/\u001b>f\u0007\u0006\u001c\u0007.\u001a\u0015\u0004g\u0005\u001d\u0017\u0001\f;fgR\u001cuN\u001d:vaR\u001c\u0015m\u00195f\u0013:$W\r\u001f$jY\u0016,\u00050[:ug\n+HOT8u\u0013:\u001c\u0015m\u00195f)\u0011\t\u0019E!\u0005\t\u000f\tMA\u00071\u0001\u0003\u0016\u0005I\u0011N\u001c3fqRK\b/\u001a\t\u0005\u0005/\u0011yD\u0004\u0003\u0003\u001a\tmb\u0002\u0002B\u000e\u0005sqAA!\b\u000389!!q\u0004B\u001b\u001d\u0011\u0011\tCa\r\u000f\t\t\r\"\u0011\u0007\b\u0005\u0005K\u0011yC\u0004\u0003\u0003(\t5RB\u0001B\u0015\u0015\r\u0011YcU\u0001\u0007yI|w\u000e\u001e \n\u00031L!A_6\n\u0005IK\u0018BA<y\u0013\t\u0001f/C\u0002O\u0003GIA!a\b\u0002\"%!!QHA\u000f\u0003Q\u0011V-\\8uKN#xN]1hK6\u000bg.Y4fe&!!\u0011\tB\"\u0005%Ie\u000eZ3y)f\u0004XM\u0003\u0003\u0003>\u0005u\u0001f\u0003\u001b\u0003H\t]#\u0011\fB.\u0005;\u0002BA!\u0013\u0003T5\u0011!1\n\u0006\u0005\u0005\u001b\u0012y%\u0001\u0005qe>4\u0018\u000eZ3s\u0015\u0011\u0011\t&!,\u0002\rA\f'/Y7t\u0013\u0011\u0011)Fa\u0013\u0003\u0015\u0015sW/\\*pkJ\u001cW-A\u0003wC2,Xm\t\u0002\u0003\u0016\u0005)a.Y7fg22!q\fB2\u0005O\n#A!\u0019\u0002\r=3eiU#UC\t\u0011)'A\u0005U\u00136+5\u000bV!N!\u0006\u0012!\u0011N\u0001\f)J\u000bejU!D)&{e\nK\u00025\u0005[\u0002BAa\u001c\u0003r5\u0011!qJ\u0005\u0005\u0005g\u0012yEA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f\u0001\u0005^3ti\u000e{gnY;se\u0016tGOU3n_Z,'+Z1e\r>\u00148)Y2iK\"\u001aQ'a2\u0002gQ,7\u000f^'vYRL\u0007\u000f\\3J]\u0012,\u00070\u00128ue&,7/\u0012=fGV$\u0018n\u001c8J]\u000e{'O];qi\u0016C8-\u001a9uS>t\u0007f\u0001\u001c\u0002H\u0006aC/Z:u\u0013:$W\r\u001f$jY\u0016\fEN]3bIf,\u00050[:u\u001f:$\u0015n]6CkRtu\u000e^%o\u0007\u0006\u001c\u0007.\u001a\u0015\u0004o\u0005\u001d\u0017a\b;fgR\u00146+\u0014*fiV\u0014hnQ8seV\u0004H/\u001a3J]\u0012,\u0007PR5mKR!\u00111\tBC\u0011\u001d\u00119\t\u000fa\u0001\u0005+\tQ\u0002^3ti&sG-\u001a=UsB,\u0007f\u0003\u001d\u0003H\t]#\u0011\fB.\u0005\u0017ccAa\u0018\u0003d\t\u001d\u0004f\u0001\u001d\u0003n\u0005!C/Z:u\u0007>t7-\u001e:sK:$8)Y2iK\u0012+G.\u001a;fI\u001aKG.Z#ySN$8\u000fK\u0002:\u0003\u000f\fQcZ3oKJ\fG/Z*qs\u000e\u000b7\r[3F]R\u0014\u0018\u0010\u0006\u0003\u0003\u0018\n\u0015\u0006\u0003\u0002BM\u0005?sA!!\r\u0003\u001c&!!QTA\u001a\u0003A\u0011V-\\8uK&sG-\u001a=DC\u000eDW-\u0003\u0003\u0003\"\n\r&!B#oiJL(\u0002\u0002BO\u0003gA\u0011Ba*;!\u0003\u0005\rA!+\u0002%I,Wn\u001c;f\u0019><7+Z4nK:$\u0018\n\u001a\t\u0005\u00037\u0011Y+\u0003\u0003\u0003.\u0006u!A\u0005*f[>$X\rT8h'\u0016<W.\u001a8u\u0013\u0012\fqdZ3oKJ\fG/Z*qs\u000e\u000b7\r[3F]R\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\u0019L\u000b\u0003\u0003*\nU6F\u0001B\\!\u0011\u0011ILa1\u000e\u0005\tm&\u0002\u0002B_\u0005\u007f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0005w+\u0001\u0006b]:|G/\u0019;j_:LAA!2\u0003<\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002/\u0005\u001c8/\u001a:u\u0003RdU-Y:u\u001f:,\u0007K]3tK:$HCBA\"\u0005\u0017\u0014i\rC\u0004\u0002,q\u0002\r!a\f\t\u000f\t=G\b1\u0001\u0003R\u0006)Q/^5egB)aKa5\u0003X&\u0019!Q[,\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0003\u0002\u000e\ne\u0017\u0002\u0002Bn\u0003\u001f\u0013A!V;jI\u0006y\u0011m]:feR\u001c\u0015m\u00195f'&TX\r\u0006\u0003\u0002D\t\u0005\bb\u0002Br{\u0001\u0007\u0011\u0011A\u0001\rKb\u0004Xm\u0019;fINK'0Z\u0001\u001bm\u0016\u0014\u0018NZ=GKR\u001c\u0007.\u00138eKbLeN^8dCRLwN\u001c\u000b\u0007\u0003\u0007\u0012IO!<\t\u000f\t-h\b1\u0001\u0002\u0002\u0005)1m\\;oi\"I!q\u001e \u0011\u0002\u0003\u0007!\u0011_\u0001\u000bS:$W\r\u001f+za\u0016\u001c\bC\u0002Bz\u0005{\u0014)B\u0004\u0003\u0003v\neh\u0002\u0002B\u0014\u0005oL\u0011\u0001W\u0005\u0004\u0005w<\u0016a\u00029bG.\fw-Z\u0005\u0005\u0005\u007f\u001c\tAA\u0002TKFT1Aa?X\u0003\u00112XM]5gs\u001a+Go\u00195J]\u0012,\u00070\u00138w_\u000e\fG/[8oI\u0011,g-Y;mi\u0012\u0012TCAB\u0004U\u0011\u0011\tP!.\u0002?\r\u0014X-\u0019;f)bLe\u000eZ3y\r>\u00148+Z4nK:$X*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0004\u000e\rM1q\u0003\t\u0005\u0003c\u0019y!\u0003\u0003\u0004\u0012\u0005M\"\u0001\u0005+sC:\u001c\u0018m\u0019;j_:Le\u000eZ3y\u0011\u001d\u0019)\u0002\u0011a\u0001\u0003'\n\u0001\"\\3uC\u0012\fG/\u0019\u0005\b\u00073\u0001\u0005\u0019AA3\u0003\r!\u0017N]\u0001(GJ,\u0017\r^3D_J\u0014X\u000f\u001d;Uq:Le\u000eZ3y\r>\u00148+Z4nK:$X*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0004\u000e\r}1\u0011\u0005\u0005\b\u00073\t\u0005\u0019AA3\u0011\u001d\u0019)\"\u0011a\u0001\u0003'\n\u0011e\u0019:fCR,G+[7f\u0013:$W\r\u001f$peN+w-\\3oi6+G/\u00193bi\u0006$baa\n\u0004.\r=\u0002\u0003BA\u0019\u0007SIAaa\u000b\u00024\tIA+[7f\u0013:$W\r\u001f\u0005\b\u0007+\u0011\u0005\u0019AA*\u0011\u001d\u0019IB\u0011a\u0001\u0003K\n1e\u0019:fCR,wJ\u001a4tKRLe\u000eZ3y\r>\u00148+Z4nK:$X*\u001a;bI\u0006$\u0018\r\u0006\u0004\u00046\rm2Q\b\t\u0005\u0003c\u00199$\u0003\u0003\u0004:\u0005M\"aC(gMN,G/\u00138eKbDqa!\u0006D\u0001\u0004\t\u0019\u0006C\u0004\u0004\u001a\r\u0003\r!!\u001a\u0002A\u001d,g.\u001a:bi\u0016\u0014V-\\8uK2{wmU3h[\u0016tG/T3uC\u0012\fG/\u0019\u000b\u0007\u0007\u0007\u001aIe!\u0014\u0011\r\tM8QIA*\u0013\u0011\u00199e!\u0001\u0003\t1K7\u000f\u001e\u0005\b\u0007\u0017\"\u0005\u0019AA\u0001\u0003\u0011\u0019\u0018N_3\t\u000f\r=C\t1\u0001\u0002\f\u0006!A\u000f]%e\u0003]i\u0017-\u001f2f\u0003B\u0004XM\u001c3J]\u0012,\u00070\u00128ue&,7\u000f\u0006\u0004\u0002D\rU3\u0011\f\u0005\b\u0007/*\u0005\u0019AB\u001b\u0003-ygMZ:fi&sG-\u001a=\t\u000f\rmS\t1\u0001\u0004(\u0005IA/[7f\u0013:$W\r_\u0001\u001aKN$\u0018.\\1uK>sW-\u00128uef\u0014\u0015\u0010^3t'&TX\rF\u0001b\u0003EiwnY6Sg64U\r^2i\u0013:$W\r\u001f\u000b\u0005\u0003\u0007\u001a)\u0007C\u0004\u0002\u0016\u001d\u0003\r!!\u0007\u00029\r\u0014X-\u0019;f\u0007>\u0014(/\u001e9u\u001f\u001a47/\u001a;J]\u0012,\u0007PR5mKR!\u00111IB6\u0011\u001d\u0019I\u0002\u0013a\u0001\u0003K\n\u0001e\u0019:fCR,7i\u001c:skB$H+[7f\u0013:$W\r_(gMN,GOR5mKR!\u00111IB9\u0011\u001d\u0019I\"\u0013a\u0001\u0003K\n\u0001d\u0019:fCR,7i\u001c:skB$X\rZ%oI\u0016Dh)\u001b7f)\u0019\t\u0019ea\u001e\u0004z!9!1\u0003&A\u0002\tU\u0001bBB\r\u0015\u0002\u0007\u0011QM\u0001\u001fO\u0016$\u0018J\u001c3fq\u001aKG.\u001a$s_6\u0014V-\\8uK\u000e\u000b7\r[3ESJ$baa \u0004,\u000e5\u0006\u0007BBA\u0007\u001f\u0003baa!\u0004\b\u000e-UBABC\u0015\r)\u0018QN\u0005\u0005\u0007\u0013\u001b)I\u0001\u0005PaRLwN\\1m!\u0011\u0019iia$\r\u0001\u0011Y1\u0011S&\u0002\u0002\u0003\u0005)\u0011ABJ\u0005\ty\u0016'\u0005\u0003\u0004\u0016\u000em\u0005c\u0001,\u0004\u0018&\u00191\u0011T,\u0003\u000f9{G\u000f[5oOB!1QTBT\u001b\t\u0019yJ\u0003\u0003\u0004\"\u000e\r\u0016\u0001\u00024jY\u0016TAa!*\u0002n\u0005\u0019a.[8\n\t\r%6q\u0014\u0002\u0005!\u0006$\b\u000eC\u0004\u0002,-\u0003\r!a\f\t\u000f\r=6\n1\u0001\u00042\u000611/\u001e4gSb\u0004Baa-\u0004<:!1QWB\\!\r\u00119cV\u0005\u0004\u0007s;\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0004>\u000e}&AB*ue&twMC\u0002\u0004:^\u0003")
public class RemoteIndexCacheTest {
    private final long defaultRemoteIndexCacheSizeBytes;
    private final Logger logger = LoggerFactory.getLogger(RemoteIndexCacheTest.class);
    private final MockTime time = new MockTime();
    private final int brokerId;
    private final long baseOffset = (long)Integer.MAX_VALUE + 101337L;
    private final long lastOffset = this.baseOffset() + 30L;
    private final int segmentSize;
    private final RemoteStorageManager rsm = (RemoteStorageManager)Mockito.mock(RemoteStorageManager.class);
    private RemoteIndexCache cache;
    private RemoteLogSegmentMetadata rlsMetadata;
    private File logDir;
    private File tpDir;
    private TopicIdPartition idPartition;

    private long defaultRemoteIndexCacheSizeBytes() {
        return this.defaultRemoteIndexCacheSizeBytes;
    }

    private Logger logger() {
        return this.logger;
    }

    private MockTime time() {
        return this.time;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private long baseOffset() {
        return this.baseOffset;
    }

    private long lastOffset() {
        return this.lastOffset;
    }

    private int segmentSize() {
        return this.segmentSize;
    }

    private RemoteStorageManager rsm() {
        return this.rsm;
    }

    private RemoteIndexCache cache() {
        return this.cache;
    }

    private void cache_$eq(RemoteIndexCache x$1) {
        this.cache = x$1;
    }

    private RemoteLogSegmentMetadata rlsMetadata() {
        return this.rlsMetadata;
    }

    private void rlsMetadata_$eq(RemoteLogSegmentMetadata x$1) {
        this.rlsMetadata = x$1;
    }

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private File tpDir() {
        return this.tpDir;
    }

    private void tpDir_$eq(File x$1) {
        this.tpDir = x$1;
    }

    private TopicIdPartition idPartition() {
        return this.idPartition;
    }

    private void idPartition_$eq(TopicIdPartition x$1) {
        this.idPartition = x$1;
    }

    @BeforeEach
    public void setup() {
        this.idPartition_$eq(new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0)));
        this.logDir_$eq(TestUtils.tempDirectory((String)new StringBuilder(6).append("kafka-").append(this.getClass().getSimpleName()).toString()));
        this.tpDir_$eq(new File(this.logDir(), this.idPartition().toString()));
        Files.createDirectory(this.tpDir().toPath(), new FileAttribute[0]);
        RemoteLogSegmentId remoteLogSegmentId = RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition());
        this.rlsMetadata_$eq(new RemoteLogSegmentMetadata(remoteLogSegmentId, this.baseOffset(), this.lastOffset(), this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L))));
        this.cache_$eq(new RemoteIndexCache(this.defaultRemoteIndexCacheSizeBytes(), this.rsm(), this.tpDir().toString()));
        this.mockRsmFetchIndex(this.rsm());
    }

    @AfterEach
    public void cleanup() {
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        try {
            Utils.delete((File)this.logDir());
        }
        catch (IOException iOException) {}
        TestUtils$.MODULE$.assertNoNonDaemonThreads("remote-log-index-cleaner");
    }

    @Test
    public void testIndexFileNameAndLocationOnDisk() {
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Path offsetIndexFile = entry.offsetIndex().file().toPath();
        Path txnIndexFile = entry.txnIndex().file().toPath();
        Path timeIndexFile = entry.timeIndex().file().toPath();
        String expectedOffsetIndexFileName = RemoteIndexCache.remoteOffsetIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTimeIndexFileName = RemoteIndexCache.remoteTimeIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTxnIndexFileName = RemoteIndexCache.remoteTransactionIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        Assertions.assertEquals((Object)expectedOffsetIndexFileName, (Object)((Object)offsetIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTxnIndexFileName, (Object)((Object)txnIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTimeIndexFileName, (Object)((Object)timeIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)offsetIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(46).append("offsetIndex=").append(offsetIndexFile).append(" is created under incorrect parent").toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)txnIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(43).append("txnIndex=").append(txnIndexFile).append(" is created under incorrect parent").toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)timeIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(44).append("timeIndex=").append(timeIndexFile).append(" is created under incorrect parent").toString());
    }

    @Test
    public void testFetchIndexFromRemoteStorage() {
        OffsetIndex offsetIndex = this.cache().getIndexEntry(this.rlsMetadata()).offsetIndex();
        OffsetPosition offsetPosition1 = offsetIndex.entry(1);
        int resultPosition = this.cache().lookupOffset(this.rlsMetadata(), offsetPosition1.offset);
        Assertions.assertEquals((int)offsetPosition1.position, (int)resultPosition);
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$)));
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        OffsetPosition offsetPosition2 = offsetIndex.entry(2);
        int resultPosition2 = this.cache().lookupOffset(this.rlsMetadata(), offsetPosition2.offset);
        Assertions.assertEquals((int)offsetPosition2.position, (int)resultPosition2);
        Assertions.assertNotNull((Object)this.cache().getIndexEntry(this.rlsMetadata()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.rsm()});
    }

    @Test
    public void testFetchIndexForMissingTransactionIndex() {
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                throw new RemoteResourceNotFoundException("txn index not found");
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Assertions.assertTrue((boolean)entry.txnIndex().file().exists());
        Assertions.assertEquals((long)0L, (long)entry.txnIndex().file().length());
    }

    @Test
    public void testPositionForNonExistingIndexFromRemoteStorage() {
        OffsetIndex offsetIndex = this.cache().getIndexEntry(this.rlsMetadata()).offsetIndex();
        int lastOffsetPosition = this.cache().lookupOffset(this.rlsMetadata(), offsetIndex.lastOffset());
        long greaterOffsetThanLastOffset = offsetIndex.lastOffset() + 1L;
        Assertions.assertEquals((int)lastOffsetPosition, (int)this.cache().lookupOffset(this.rlsMetadata(), greaterOffsetThanLastOffset));
        OffsetPosition nonExistentOffsetPosition = new OffsetPosition(this.baseOffset(), 0);
        long lowerOffsetThanBaseOffset = offsetIndex.baseOffset() - 1L;
        Assertions.assertEquals((int)nonExistentOffsetPosition.position, (int)this.cache().lookupOffset(this.rlsMetadata(), lowerOffsetThanBaseOffset));
    }

    @Test
    public void testCacheEntryExpiry() {
        long estimateEntryBytesSize = this.estimateOneEntryBytesSize();
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        this.cache_$eq(new RemoteIndexCache(2L * estimateEntryBytesSize, this.rsm(), this.tpDir().toString()));
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(2, this.verifyFetchIndexInvocation$default$2());
        Assertions.assertNotNull((Object)this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.last()));
        this.assertAtLeastOnePresent(this.cache(), (Seq<Uuid>)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{((RemoteLogSegmentMetadata)metadataList.apply(1)).remoteLogSegmentId().id(), ((RemoteLogSegmentMetadata)metadataList.head()).remoteLogSegmentId().id()}));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(3, this.verifyFetchIndexInvocation$default$2());
        Option missingEntryOpt = metadataList.find((Function1 & Serializable & scala.Serializable)segmentMetadata -> BoxesRunTime.boxToBoolean((boolean)RemoteIndexCacheTest.$anonfun$testCacheEntryExpiry$1(this, segmentMetadata)));
        Assertions.assertFalse((boolean)missingEntryOpt.isEmpty());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)missingEntryOpt.get());
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(4, this.verifyFetchIndexInvocation$default$2());
    }

    @Test
    public void testGetIndexAfterCacheClose() {
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        this.cache_$eq(new RemoteIndexCache(2L * this.estimateOneEntryBytesSize(), this.rsm(), this.tpDir().toString()));
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        this.cache().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head()));
    }

    @Test
    public void testCloseIsIdempotent() {
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        this.cache().internalCache().put((Object)this.rlsMetadata().remoteLogSegmentId().id(), (Object)spyEntry);
        this.cache().close();
        this.cache().close();
        ((RemoteIndexCache.Entry)Mockito.verify((Object)spyEntry)).close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCacheEntryIsDeletedOnRemoval() {
        Uuid internalIndexKey = this.rlsMetadata().remoteLogSegmentId().id();
        RemoteIndexCache.Entry cacheEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        Assertions.assertTrue((boolean)this.getIndexFileFromDisk$1(".index").isPresent(), (String)new StringBuilder(47).append("Offset index file should be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertTrue((boolean)this.getIndexFileFromDisk$1(".txnindex").isPresent(), (String)new StringBuilder(44).append("Txn index file should be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertTrue((boolean)this.getIndexFileFromDisk$1(".timeindex").isPresent(), (String)new StringBuilder(45).append("Time index file should be present on disk at ").append(this.tpDir().toPath()).toString());
        this.cache().internalCache().put((Object)internalIndexKey, (Object)cacheEntry);
        Assertions.assertEquals((int)0, (int)this.cache().expiredIndexes().size(), (String)"expiredIndex queue should be zero at start of test");
        this.cache().remove(internalIndexKey);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!cacheEntry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCacheEntryIsDeletedOnRemoval$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!cacheEntry.isCleanStarted()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCacheEntryIsDeletedOnRemoval$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((RemoteIndexCache.Entry)Mockito.verify((Object)cacheEntry, (VerificationMode)Mockito.times((int)2))).markForCleanup();
        ((RemoteIndexCache.Entry)Mockito.verify((Object)cacheEntry)).cleanup();
        ((AbstractIndex)Mockito.verify((Object)cacheEntry.timeIndex())).renameTo((File)ArgumentMatchers.any(File.class));
        ((AbstractIndex)Mockito.verify((Object)cacheEntry.offsetIndex())).renameTo((File)ArgumentMatchers.any(File.class));
        ((TransactionIndex)Mockito.verify((Object)cacheEntry.txnIndex())).renameTo((File)ArgumentMatchers.any(File.class));
        Assertions.assertFalse((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent(), (String)new StringBuilder(51).append("Offset index file should not be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertFalse((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".txnindex").isPresent(), (String)new StringBuilder(48).append("Txn index file should not be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertFalse((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".timeindex").isPresent(), (String)new StringBuilder(49).append("Time index file should not be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertFalse((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".deleted").isPresent(), (String)new StringBuilder(64).append("Index file marked for deletion should not be present on disk at ").append(this.tpDir().toPath()).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanerThreadShutdown() {
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().isEmpty());
        TestUtils$.MODULE$.numThreadsRunning("remote-log-index-cleaner", true);
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        spyEntry.cleanup();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException("kaboom! I am expected exception in unit test.")});
        Uuid key = Uuid.randomUuid();
        this.cache().internalCache().put((Object)key, (Object)spyEntry);
        this.cache().internalCache().invalidate((Object)key);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!spyEntry.isCleanStarted()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCleanerThreadShutdown$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Thread.sleep(100L);
        Set<Thread> threads = TestUtils$.MODULE$.numThreadsRunning("remote-log-index-cleaner", true);
        Assertions.assertEquals((int)1, (int)threads.size(), (String)new StringBuilder(26).append("Found unexpected ").append(threads.size()).append(" threads=").append(((TraversableOnce)threads.map((Function1 & Serializable & scala.Serializable)t -> t.getName(), Set$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        this.cache().close();
        threads = TestUtils$.MODULE$.numThreadsRunning("remote-log-index-cleaner", true);
        Assertions.assertTrue((boolean)threads.isEmpty(), (String)new StringBuilder(26).append("Found unexpected ").append(threads.size()).append(" threads=").append(((TraversableOnce)threads.map((Function1 & Serializable & scala.Serializable)t -> t.getName(), Set$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        Assertions.assertFalse((boolean)this.cache().cleanerThread().isRunning(), (String)"Unexpected thread state=running. Check error logs.");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClose() {
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        this.cache().internalCache().put((Object)this.rlsMetadata().remoteLogSegmentId().id(), (Object)spyEntry);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testClose$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testClose$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.cache().close();
        ((RemoteIndexCache.Entry)Mockito.verify((Object)spyEntry)).close();
        ((TransactionIndex)Mockito.verify((Object)spyEntry.txnIndex())).close();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.offsetIndex())).close();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.timeIndex())).close();
        ((TransactionIndex)Mockito.verify((Object)spyEntry.txnIndex(), (VerificationMode)Mockito.times((int)0))).deleteIfExists();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.offsetIndex(), (VerificationMode)Mockito.times((int)0))).deleteIfExists();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.timeIndex(), (VerificationMode)Mockito.times((int)0))).deleteIfExists();
        Assertions.assertTrue((boolean)this.cache().cleanerThread().isShutdownComplete());
    }

    @Test
    public void testConcurrentReadWriteAccessForCache() {
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$)));
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        CountDownLatch latchForCacheHit = new CountDownLatch(1);
        CountDownLatch latchForCacheMiss = new CountDownLatch(1);
        Runnable readerCacheHit = () -> {
            this.logger().debug(new StringBuilder(38).append("Waiting for signal to begin read from ").append(Thread.currentThread()).toString());
            latchForCacheHit.await();
            Assertions.assertNotNull((Object)this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head()));
            this.logger().debug(new StringBuilder(36).append("Signaling CacheMiss to unblock from ").append(Thread.currentThread()).toString());
            latchForCacheMiss.countDown();
        };
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(x$2 -> {
            RemoteIndexCacheTest.$anonfun$testConcurrentReadWriteAccessForCache$2(this, latchForCacheHit, latchForCacheMiss, x$2);
            return BoxedUnit.UNIT;
        });
        Runnable readerCacheMiss = () -> Assertions.assertNotNull((Object)this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.last()));
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            executor.submit(readerCacheMiss);
            executor.submit(readerCacheHit);
            Assertions.assertTrue((boolean)latchForCacheMiss.await(30L, TimeUnit.SECONDS));
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testReloadCacheAfterClose() {
        long estimateEntryBytesSize = this.estimateOneEntryBytesSize();
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        this.cache_$eq(new RemoteIndexCache(2L * estimateEntryBytesSize, this.rsm(), this.tpDir().toString()));
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.assertCacheSize(2);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(2, this.verifyFetchIndexInvocation$default$2());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(2);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(3, this.verifyFetchIndexInvocation$default$2());
        this.cache().close();
        RemoteIndexCache reloadedCache = new RemoteIndexCache(2L * estimateEntryBytesSize, this.rsm(), this.tpDir().toString());
        Assertions.assertEquals((int)2, (int)reloadedCache.internalCache().asMap().size());
        reloadedCache.close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.rsm()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRemoveItem() {
        RemoteLogSegmentId segmentId = this.rlsMetadata().remoteLogSegmentId();
        Uuid segmentUuid = segmentId.id();
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(segmentId);
        this.cache().internalCache().put((Object)segmentUuid, (Object)spyEntry);
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        Assertions.assertFalse((boolean)spyEntry.isMarkedForCleanup());
        this.cache().remove(segmentId.id());
        Assertions.assertFalse((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!spyEntry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testRemoveItem$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testRemoveNonExistentItem() {
        RemoteLogSegmentId segmentId = this.rlsMetadata().remoteLogSegmentId();
        Uuid segmentUuid = segmentId.id();
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(segmentId);
        this.cache().internalCache().put((Object)segmentUuid, (Object)spyEntry);
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        this.cache().remove(Uuid.randomUuid());
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        Assertions.assertFalse((boolean)spyEntry.isMarkedForCleanup());
    }

    @Test
    public void testRemoveMultipleItems() {
        HashMap uuidAndEntryList = new HashMap();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            RemoteLogSegmentId segmentId = RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition());
            Uuid segmentUuid = segmentId.id();
            RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(segmentId);
            uuidAndEntryList.put(segmentUuid, spyEntry);
            this.cache().internalCache().put((Object)segmentUuid, (Object)spyEntry);
            Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
            Assertions.assertFalse((boolean)spyEntry.isMarkedForCleanup());
        });
        this.cache().removeAll(uuidAndEntryList.keySet());
        uuidAndEntryList.values().forEach(entry -> {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!entry.isMarkedForCleanup()) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testRemoveMultipleItems$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearCacheAndIndexFilesWhenResizeCache() {
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(1, tpId);
        this.assertCacheSize(0);
        RemoteIndexCache.Entry cacheEntry = this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".txnindex").isPresent());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".timeindex").isPresent());
        this.cache().resizeCacheSize(1L);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!cacheEntry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!cacheEntry.isCleanStarted()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$6(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$7(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$8(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$9(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$10(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$11(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$12(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.assertCacheSize(0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorrectnessForCacheAndIndexFilesWhenResizeCache() {
        long estimateEntryBytesSize = this.estimateOneEntryBytesSize();
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        RemoteIndexCache.Entry cacheEntry = this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".txnindex").isPresent());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".timeindex").isPresent());
        this.cache().resizeCacheSize(1L);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!cacheEntry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$14());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!cacheEntry.isCleanStarted()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$16());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$17(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$18(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$19(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$20(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$21(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$22(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$23(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$24(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.assertCacheSize(0);
        this.cache().resizeCacheSize(2L * estimateEntryBytesSize);
        this.assertCacheSize(0);
        RemoteIndexCache.Entry entry0 = this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(0));
        RemoteIndexCache.Entry entry1 = this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(2);
        this.verifyEntryIsEvicted$1((RemoteLogSegmentMetadata)metadataList.apply(0), entry0);
        this.cache().resizeCacheSize(1L * estimateEntryBytesSize);
        this.assertCacheSize(1);
        this.verifyEntryIsEvicted$1((RemoteLogSegmentMetadata)metadataList.apply(1), entry1);
        this.cache().resizeCacheSize(1L * estimateEntryBytesSize);
        this.verifyEntryIsKept$1((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(1);
        this.cache().resizeCacheSize(2L * estimateEntryBytesSize);
        this.verifyEntryIsKept$1((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(1);
    }

    @ParameterizedTest
    @EnumSource(value=RemoteStorageManager.IndexType.class, names={"OFFSET", "TIMESTAMP", "TRANSACTION"})
    public void testCorruptCacheIndexFileExistsButNotInCache(RemoteStorageManager.IndexType indexType) {
        this.createCorruptedIndexFile(indexType, this.cache().cacheDir());
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Path offsetIndexFile = entry.offsetIndex().file().toPath();
        Path txnIndexFile = entry.txnIndex().file().toPath();
        Path timeIndexFile = entry.timeIndex().file().toPath();
        String expectedOffsetIndexFileName = RemoteIndexCache.remoteOffsetIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTimeIndexFileName = RemoteIndexCache.remoteTimeIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTxnIndexFileName = RemoteIndexCache.remoteTransactionIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        Assertions.assertEquals((Object)expectedOffsetIndexFileName, (Object)((Object)offsetIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTxnIndexFileName, (Object)((Object)txnIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTimeIndexFileName, (Object)((Object)timeIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)offsetIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(46).append("offsetIndex=").append(offsetIndexFile).append(" is created under incorrect parent").toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)txnIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(43).append("txnIndex=").append(txnIndexFile).append(" is created under incorrect parent").toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)timeIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(44).append("timeIndex=").append(timeIndexFile).append(" is created under incorrect parent").toString());
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
    }

    @Test
    public void testConcurrentRemoveReadForCache() {
        RemoteLogSegmentMetadata rlsMetadata = new RemoteLogSegmentMetadata(RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition()), this.baseOffset(), this.lastOffset(), this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L)));
        TimeIndex timeIndex = (TimeIndex)Mockito.spy((Object)this.createTimeIndexForSegmentMetadata(rlsMetadata, new File(this.tpDir(), "remote-log-index-cache")));
        TransactionIndex txIndex = (TransactionIndex)Mockito.spy((Object)this.createTxIndexForSegmentMetadata(rlsMetadata, new File(this.tpDir(), "remote-log-index-cache")));
        OffsetIndex offsetIndex = (OffsetIndex)Mockito.spy((Object)this.createOffsetIndexForSegmentMetadata(rlsMetadata, new File(this.tpDir(), "remote-log-index-cache")));
        RemoteIndexCache.Entry spyEntry = (RemoteIndexCache.Entry)Mockito.spy((Object)new RemoteIndexCache.Entry(offsetIndex, timeIndex, txIndex));
        this.cache().internalCache().put((Object)rlsMetadata.remoteLogSegmentId().id(), (Object)spyEntry);
        this.assertCacheSize(1);
        ObjectRef entry = ObjectRef.create(null);
        CountDownLatch latchForCacheRead = new CountDownLatch(1);
        CountDownLatch latchForCacheRemove = new CountDownLatch(1);
        CountDownLatch latchForTestWait = new CountDownLatch(1);
        ((RemoteIndexCache.Entry)Mockito.doAnswer(arg_0 -> RemoteIndexCacheTest.$anonfun$testConcurrentRemoveReadForCache$1(IntRef.create((int)0), latchForCacheRead, latchForCacheRemove, latchForTestWait, arg_0)).when((Object)spyEntry)).markForCleanup();
        Runnable removeCache = () -> this.cache().remove(rlsMetadata.remoteLogSegmentId().id());
        Runnable readCache = () -> {
            latchForCacheRead.await();
            entry$2.elem = this.cache().getIndexEntry(rlsMetadata);
            latchForCacheRemove.countDown();
        };
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            Future<?> removeCacheFuture = executor.submit(removeCache);
            Future<?> readCacheFuture = executor.submit(readCache);
            removeCacheFuture.get();
            readCacheFuture.get();
            latchForTestWait.await();
            if (this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent()) {
                this.assertCacheSize(1);
            } else {
                this.assertCacheSize(0);
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testMultipleIndexEntriesExecutionInCorruptException() {
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            TransactionIndex txnIdx = this.createTxIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            this.createCorruptTimeIndexOffsetFile(this.tpDir());
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdx.file());
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
        Assertions.assertThrows(CorruptIndexException.class, () -> this.cache().getIndexEntry(this.rlsMetadata()));
        Assertions.assertNull((Object)this.cache().internalCache().getIfPresent((Object)this.rlsMetadata().remoteLogSegmentId().id()));
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$)));
        this.verifyFetchIndexInvocation(0, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.TRANSACTION, (List)Nil$.MODULE$));
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        Files.walk(this.tpDir().toPath(), 1, new FileVisitOption[0]).filter(x$3 -> Files.isRegularFile(x$3, new LinkOption[0])).forEach(path -> Files.deleteIfExists(path));
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            TransactionIndex txnIdx = this.createTxIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdx.file());
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
        this.cache().getIndexEntry(this.rlsMetadata());
        this.verifyFetchIndexInvocation(0, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)Nil$.MODULE$));
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$));
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.TRANSACTION, (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIndexFileAlreadyExistOnDiskButNotInCache() {
        File remoteIndexCacheDir = this.cache().cacheDir();
        String tempSuffix = ".tmptest";
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        Files.copy(entry.offsetIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.offsetIndex().file().getPath(), (String)"", (String)tempSuffix), new String[0]), new CopyOption[0]);
        Files.copy(entry.txnIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.txnIndex().file().getPath(), (String)"", (String)tempSuffix), new String[0]), new CopyOption[0]);
        Files.copy(entry.timeIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.timeIndex().file().getPath(), (String)"", (String)tempSuffix), new String[0]), new CopyOption[0]);
        this.cache().remove(this.rlsMetadata().remoteLogSegmentId().id());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!entry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testIndexFileAlreadyExistOnDiskButNotInCache$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!entry.isCleanStarted()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testIndexFileAlreadyExistOnDiskButNotInCache$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        RemoteIndexCacheTest.renameRemoteCacheIndexFileFromDisk$1(tempSuffix, remoteIndexCacheDir, tempSuffix);
        Assertions.assertNull((Object)this.cache().internalCache().getIfPresent((Object)this.rlsMetadata().remoteLogSegmentId().id()));
        this.cache().getIndexEntry(this.rlsMetadata());
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent(), (String)new StringBuilder(47).append("Offset index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".txnindex").isPresent(), (String)new StringBuilder(44).append("Txn index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".timeindex").isPresent(), (String)new StringBuilder(45).append("Time index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
    }

    @ParameterizedTest
    @EnumSource(value=RemoteStorageManager.IndexType.class, names={"OFFSET", "TIMESTAMP", "TRANSACTION"})
    public void testRSMReturnCorruptedIndexFile(RemoteStorageManager.IndexType testIndexType) {
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            TransactionIndex txnIdx = this.createTxIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            this.createCorruptedIndexFile(testIndexType, this.tpDir());
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdx.file());
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
        Assertions.assertThrows(CorruptIndexException.class, () -> this.cache().getIndexEntry(this.rlsMetadata()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConcurrentCacheDeletedFileExists() {
        File remoteIndexCacheDir = this.cache().cacheDir();
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent(), (String)new StringBuilder(47).append("Offset index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".txnindex").isPresent(), (String)new StringBuilder(44).append("Txn index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".timeindex").isPresent(), (String)new StringBuilder(45).append("Time index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
        Files.copy(entry.offsetIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.offsetIndex().file().getPath(), (String)"", (String)".deleted"), new String[0]), new CopyOption[0]);
        Files.copy(entry.txnIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.txnIndex().file().getPath(), (String)"", (String)".deleted"), new String[0]), new CopyOption[0]);
        Files.copy(entry.timeIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.timeIndex().file().getPath(), (String)"", (String)".deleted"), new String[0]), new CopyOption[0]);
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".deleted").isPresent(), (String)new StringBuilder(55).append("Deleted Offset index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
        this.cache().remove(this.rlsMetadata().remoteLogSegmentId().id());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!entry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!entry.isCleanStarted()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$6(remoteIndexCacheDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$7(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$8(remoteIndexCacheDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$9(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$10(remoteIndexCacheDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$11(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$12(remoteIndexCacheDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private RemoteIndexCache.Entry generateSpyCacheEntry(RemoteLogSegmentId remoteLogSegmentId) {
        RemoteLogSegmentMetadata rlsMetadata = new RemoteLogSegmentMetadata(remoteLogSegmentId, this.baseOffset(), this.lastOffset(), this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L)));
        TimeIndex timeIndex = (TimeIndex)Mockito.spy((Object)this.createTimeIndexForSegmentMetadata(rlsMetadata, this.tpDir()));
        TransactionIndex txIndex = (TransactionIndex)Mockito.spy((Object)this.createTxIndexForSegmentMetadata(rlsMetadata, this.tpDir()));
        OffsetIndex offsetIndex = (OffsetIndex)Mockito.spy((Object)this.createOffsetIndexForSegmentMetadata(rlsMetadata, this.tpDir()));
        return (RemoteIndexCache.Entry)Mockito.spy((Object)new RemoteIndexCache.Entry(offsetIndex, timeIndex, txIndex));
    }

    private RemoteLogSegmentId generateSpyCacheEntry$default$1() {
        return RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition());
    }

    private void assertAtLeastOnePresent(RemoteIndexCache cache, Seq<Uuid> uuids) {
        Object object = new Object();
        try {
            uuids.foreach((Function1 & Serializable & scala.Serializable)uuid -> {
                RemoteIndexCacheTest.$anonfun$assertAtLeastOnePresent$1(cache, object, uuid);
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"all uuids are not present in cache");
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void assertCacheSize(int expectedSize) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$assertCacheSize$1(this, expectedSize)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$assertCacheSize$2(expectedSize));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyFetchIndexInvocation(int count, Seq<RemoteStorageManager.IndexType> indexTypes) {
        indexTypes.foreach((Function1 & Serializable & scala.Serializable)indexType -> ((RemoteStorageManager)Mockito.verify((Object)this.rsm(), (VerificationMode)Mockito.times((int)count))).fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.eq((Object)indexType)));
    }

    private Seq<RemoteStorageManager.IndexType> verifyFetchIndexInvocation$default$2() {
        return new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TRANSACTION, (List)Nil$.MODULE$)));
    }

    private TransactionIndex createTxIndexForSegmentMetadata(RemoteLogSegmentMetadata metadata, File dir) {
        File txnIdxFile = RemoteIndexCache.remoteTransactionIndexFile((File)dir, (RemoteLogSegmentMetadata)metadata);
        txnIdxFile.createNewFile();
        return new TransactionIndex(metadata.startOffset(), txnIdxFile);
    }

    private TransactionIndex createCorruptTxnIndexForSegmentMetadata(File dir, RemoteLogSegmentMetadata metadata) {
        File txnIdxFile = RemoteIndexCache.remoteTransactionIndexFile((File)dir, (RemoteLogSegmentMetadata)metadata);
        txnIdxFile.createNewFile();
        TransactionIndex txnIndex = new TransactionIndex(metadata.startOffset(), txnIdxFile);
        new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            txnIndex.append(x$1);
            return BoxedUnit.UNIT;
        });
        txnIndex.close();
        return new TransactionIndex(100L, txnIdxFile);
    }

    private TimeIndex createTimeIndexForSegmentMetadata(RemoteLogSegmentMetadata metadata, File dir) {
        int maxEntries = (int)(metadata.endOffset() - metadata.startOffset());
        return new TimeIndex(RemoteIndexCache.remoteTimeIndexFile((File)dir, (RemoteLogSegmentMetadata)metadata), metadata.startOffset(), maxEntries * 12);
    }

    private OffsetIndex createOffsetIndexForSegmentMetadata(RemoteLogSegmentMetadata metadata, File dir) {
        int maxEntries = (int)(metadata.endOffset() - metadata.startOffset());
        return new OffsetIndex(RemoteIndexCache.remoteOffsetIndexFile((File)dir, (RemoteLogSegmentMetadata)metadata), metadata.startOffset(), maxEntries * 8);
    }

    private List<RemoteLogSegmentMetadata> generateRemoteLogSegmentMetadata(int size, TopicIdPartition tpId) {
        Buffer metadataList = (Buffer)Buffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> metadataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RemoteLogSegmentMetadata[]{new RemoteLogSegmentMetadata(new RemoteLogSegmentId(tpId, Uuid.randomUuid()), this.baseOffset() * (long)i, this.baseOffset() * (long)i + 10L, this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L)))})));
        return metadataList.toList();
    }

    private void maybeAppendIndexEntries(OffsetIndex offsetIndex, TimeIndex timeIndex) {
        if (!offsetIndex.isFull()) {
            long curTime = this.time().milliseconds();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetIndex.maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                long offset = offsetIndex.baseOffset() + (long)i;
                offsetIndex.append(offset, i);
                timeIndex.maybeAppend(curTime + (long)i, offset, true);
            });
            offsetIndex.flush();
            timeIndex.flush();
            return;
        }
    }

    private long estimateOneEntryBytesSize() {
        TopicPartition tp = new TopicPartition("estimate-entry-bytes-size", 0);
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), tp);
        File tpDir = new File(this.logDir(), tpId.toString());
        Files.createDirectory(tpDir.toPath(), new FileAttribute[0]);
        RemoteStorageManager rsm = (RemoteStorageManager)Mockito.mock(RemoteStorageManager.class);
        this.mockRsmFetchIndex(rsm);
        RemoteIndexCache cache = new RemoteIndexCache(2L, rsm, tpDir.toString());
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(1, tpId);
        long entrySizeInBytes = cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.head()).entrySizeBytes();
        Utils.closeQuietly((AutoCloseable)cache, (String)"RemoteIndexCache created for estimating entry size");
        return entrySizeInBytes;
    }

    private void mockRsmFetchIndex(RemoteStorageManager rsm) {
        Mockito.when((Object)rsm.fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            TransactionIndex txnIdx = this.createTxIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdx.file());
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
    }

    private void createCorruptOffsetIndexFile(File dir) {
        PrintWriter pw = new PrintWriter(RemoteIndexCache.remoteOffsetIndexFile((File)dir, (RemoteLogSegmentMetadata)this.rlsMetadata()));
        pw.write("Hello, world");
        pw.close();
    }

    private void createCorruptTimeIndexOffsetFile(File dir) {
        PrintWriter pw = new PrintWriter(RemoteIndexCache.remoteTimeIndexFile((File)dir, (RemoteLogSegmentMetadata)this.rlsMetadata()));
        pw.write("Hello, world1");
        pw.close();
    }

    private void createCorruptedIndexFile(RemoteStorageManager.IndexType indexType, File dir) {
        block9: {
            block8: {
                RemoteStorageManager.IndexType indexType2;
                RemoteStorageManager.IndexType indexType3;
                block7: {
                    RemoteStorageManager.IndexType indexType4 = indexType;
                    RemoteStorageManager.IndexType indexType5 = RemoteStorageManager.IndexType.OFFSET;
                    if (!(indexType4 != null ? !indexType4.equals(indexType5) : indexType5 != null)) {
                        this.createCorruptOffsetIndexFile(dir);
                        return;
                    }
                    RemoteStorageManager.IndexType indexType6 = indexType;
                    RemoteStorageManager.IndexType indexType7 = RemoteStorageManager.IndexType.TIMESTAMP;
                    if (!(indexType6 != null ? !indexType6.equals(indexType7) : indexType7 != null)) {
                        this.createCorruptTimeIndexOffsetFile(dir);
                        return;
                    }
                    indexType3 = indexType;
                    indexType2 = RemoteStorageManager.IndexType.TRANSACTION;
                    if (indexType3 != null) break block7;
                    if (indexType2 != null) {
                        return;
                    }
                    break block8;
                }
                if (!indexType3.equals(indexType2)) break block9;
            }
            this.createCorruptTxnIndexForSegmentMetadata(dir, this.rlsMetadata());
            return;
        }
    }

    private Optional<? extends Path> getIndexFileFromRemoteCacheDir(RemoteIndexCache cache, String suffix) {
        try {
            return Files.walk(cache.cacheDir().toPath(), new FileVisitOption[0]).filter(x$5 -> Files.isRegularFile(x$5, new LinkOption[0])).filter(path -> ((Object)path.getFileName()).toString().endsWith(suffix)).findAny();
        }
        catch (Throwable throwable) {
            if (throwable instanceof NoSuchFileException ? true : throwable instanceof UncheckedIOException) {
                return Optional.empty();
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCacheEntryExpiry$1(RemoteIndexCacheTest $this, RemoteLogSegmentMetadata segmentMetadata) {
        Uuid segmentId = segmentMetadata.remoteLogSegmentId().id();
        return !$this.cache().internalCache().asMap().containsKey(segmentId);
    }

    private final Optional getIndexFileFromDisk$1(String suffix) {
        return Files.walk(this.tpDir().toPath(), new FileVisitOption[0]).filter(x$1 -> Files.isRegularFile(x$1, new LinkOption[0])).filter(path -> ((Object)path.getFileName()).toString().endsWith(suffix)).findAny();
    }

    public static final /* synthetic */ String $anonfun$testCacheEntryIsDeletedOnRemoval$4() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ String $anonfun$testCacheEntryIsDeletedOnRemoval$6() {
        return "Failed to cleanup cache entry after invalidation";
    }

    public static final /* synthetic */ String $anonfun$testCleanerThreadShutdown$2() {
        return "Failed while waiting for clean up to start";
    }

    public static final /* synthetic */ boolean $anonfun$testClose$1(RemoteIndexCacheTest $this) {
        return $this.cache().cleanerThread().isStarted();
    }

    public static final /* synthetic */ String $anonfun$testClose$2() {
        return "Cleaner thread should be started";
    }

    public static final /* synthetic */ void $anonfun$testConcurrentReadWriteAccessForCache$2(RemoteIndexCacheTest $this, CountDownLatch latchForCacheHit$1, CountDownLatch latchForCacheMiss$1, InvocationOnMock x$2) {
        $this.logger().debug(new StringBuilder(38).append("Signaling CacheHit to begin read from ").append(Thread.currentThread()).toString());
        latchForCacheHit$1.countDown();
        $this.logger().debug(new StringBuilder(46).append("Waiting for signal to complete rsm fetch from ").append(Thread.currentThread()).toString());
        latchForCacheMiss$1.await();
    }

    public static final /* synthetic */ String $anonfun$testRemoveItem$2() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ String $anonfun$testRemoveMultipleItems$4() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ String $anonfun$testClearCacheAndIndexFilesWhenResizeCache$2() {
        return "Failed to mark cache entry for cleanup after resizing cache.";
    }

    public static final /* synthetic */ String $anonfun$testClearCacheAndIndexFilesWhenResizeCache$4() {
        return "Failed to cleanup cache entry after resizing cache.";
    }

    public static final /* synthetic */ boolean $anonfun$testClearCacheAndIndexFilesWhenResizeCache$5(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".index").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testClearCacheAndIndexFilesWhenResizeCache$6(RemoteIndexCacheTest $this) {
        return new StringBuilder(51).append("Offset index file should not be present on disk at ").append($this.cache().cacheDir()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testClearCacheAndIndexFilesWhenResizeCache$7(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".txnindex").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testClearCacheAndIndexFilesWhenResizeCache$8(RemoteIndexCacheTest $this) {
        return new StringBuilder(48).append("Txn index file should not be present on disk at ").append($this.cache().cacheDir()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testClearCacheAndIndexFilesWhenResizeCache$9(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".timeindex").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testClearCacheAndIndexFilesWhenResizeCache$10(RemoteIndexCacheTest $this) {
        return new StringBuilder(49).append("Time index file should not be present on disk at ").append($this.cache().cacheDir()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testClearCacheAndIndexFilesWhenResizeCache$11(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".deleted").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testClearCacheAndIndexFilesWhenResizeCache$12(RemoteIndexCacheTest $this) {
        return new StringBuilder(64).append("Index file marked for deletion should not be present on disk at ").append($this.cache().cacheDir()).toString();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$2() {
        return "Failed to mark evicted cache entry for cleanup after resizing cache.";
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$4() {
        return "Failed to cleanup evicted cache entry after resizing cache.";
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$5(RemoteIndexCacheTest $this, RemoteLogSegmentMetadata metadataToVerify$1) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), RemoteIndexCache.remoteOffsetIndexFileName((RemoteLogSegmentMetadata)metadataToVerify$1)).isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$6(RemoteIndexCacheTest $this) {
        return new StringBuilder(69).append("Offset index file for evicted entry should not be present on disk at ").append($this.cache().cacheDir()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$7(RemoteIndexCacheTest $this, RemoteLogSegmentMetadata metadataToVerify$1) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), RemoteIndexCache.remoteTimeIndexFileName((RemoteLogSegmentMetadata)metadataToVerify$1)).isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$8(RemoteIndexCacheTest $this) {
        return new StringBuilder(67).append("Time index file for evicted entry should not be present on disk at ").append($this.cache().cacheDir()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$9(RemoteIndexCacheTest $this, RemoteLogSegmentMetadata metadataToVerify$1) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), RemoteIndexCache.remoteTransactionIndexFileName((RemoteLogSegmentMetadata)metadataToVerify$1)).isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$10(RemoteIndexCacheTest $this) {
        return new StringBuilder(66).append("Txn index file for evicted entry should not be present on disk at ").append($this.cache().cacheDir()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$11(RemoteIndexCacheTest $this, RemoteLogSegmentMetadata metadataToVerify$1) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), RemoteIndexCache.remoteDeletedSuffixIndexFileName((RemoteLogSegmentMetadata)metadataToVerify$1)).isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$12(RemoteIndexCacheTest $this) {
        return new StringBuilder(82).append("Index file marked for deletion for evicted entry should not be present on disk at ").append($this.cache().cacheDir()).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyEntryIsEvicted$1(RemoteLogSegmentMetadata metadataToVerify, RemoteIndexCache.Entry entryToVerify) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!entryToVerify.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!entryToVerify.isCleanStarted()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$5(this, metadataToVerify)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$6(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$7(this, metadataToVerify)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$8(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$9(this, metadataToVerify)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$10(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$11(this, metadataToVerify)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$12(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private final void verifyEntryIsKept$1(RemoteLogSegmentMetadata metadataToVerify) {
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), RemoteIndexCache.remoteOffsetIndexFileName((RemoteLogSegmentMetadata)metadataToVerify)).isPresent());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), RemoteIndexCache.remoteTimeIndexFileName((RemoteLogSegmentMetadata)metadataToVerify)).isPresent());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), RemoteIndexCache.remoteTransactionIndexFileName((RemoteLogSegmentMetadata)metadataToVerify)).isPresent());
        Assertions.assertTrue((!this.getIndexFileFromRemoteCacheDir(this.cache(), RemoteIndexCache.remoteDeletedSuffixIndexFileName((RemoteLogSegmentMetadata)metadataToVerify)).isPresent() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$14() {
        return "Failed to mark cache entry for cleanup after resizing cache.";
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$16() {
        return "Failed to cleanup cache entry after resizing cache.";
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$17(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".index").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$18(RemoteIndexCacheTest $this) {
        return new StringBuilder(51).append("Offset index file should not be present on disk at ").append($this.cache().cacheDir()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$19(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".txnindex").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$20(RemoteIndexCacheTest $this) {
        return new StringBuilder(48).append("Txn index file should not be present on disk at ").append($this.cache().cacheDir()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$21(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".timeindex").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$22(RemoteIndexCacheTest $this) {
        return new StringBuilder(49).append("Time index file should not be present on disk at ").append($this.cache().cacheDir()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$23(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".deleted").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$24(RemoteIndexCacheTest $this) {
        return new StringBuilder(64).append("Index file marked for deletion should not be present on disk at ").append($this.cache().cacheDir()).toString();
    }

    public static final /* synthetic */ Object $anonfun$testConcurrentRemoveReadForCache$1(IntRef markForCleanupCallCount$1, CountDownLatch latchForCacheRead$1, CountDownLatch latchForCacheRemove$1, CountDownLatch latchForTestWait$1, InvocationOnMock invocation) {
        ++markForCleanupCallCount$1.elem;
        if (markForCleanupCallCount$1.elem == 1) {
            latchForCacheRead$1.countDown();
            latchForCacheRemove$1.await();
            invocation.callRealMethod();
            latchForTestWait$1.countDown();
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    private static final void renameRemoteCacheIndexFileFromDisk$1(String suffix, File remoteIndexCacheDir$1, String tempSuffix$1) {
        Files.walk(remoteIndexCacheDir$1.toPath(), new FileVisitOption[0]).filter(x$4 -> Files.isRegularFile(x$4, new LinkOption[0])).filter(path -> ((Object)path.getFileName()).toString().endsWith(suffix)).forEach(f -> Utils.atomicMoveWithFallback((Path)f, (Path)f.resolveSibling(new StringOps(Predef$.MODULE$.augmentString(((Object)f.getFileName()).toString())).stripSuffix(tempSuffix$1))));
    }

    public static final /* synthetic */ String $anonfun$testIndexFileAlreadyExistOnDiskButNotInCache$5() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ String $anonfun$testIndexFileAlreadyExistOnDiskButNotInCache$7() {
        return "Failed to cleanup cache entry after invalidation";
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$2() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$4() {
        return "Failed to cleanup cache entry after invalidation";
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$5(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".index").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$6(File remoteIndexCacheDir$2) {
        return new StringBuilder(51).append("Offset index file should not be present on disk at ").append(remoteIndexCacheDir$2.toPath()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$7(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".txnindex").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$8(File remoteIndexCacheDir$2) {
        return new StringBuilder(48).append("Txn index file should not be present on disk at ").append(remoteIndexCacheDir$2.toPath()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$9(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".timeindex").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$10(File remoteIndexCacheDir$2) {
        return new StringBuilder(49).append("Time index file should not be present on disk at ").append(remoteIndexCacheDir$2.toPath()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$11(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".deleted").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$12(File remoteIndexCacheDir$2) {
        return new StringBuilder(64).append("Index file marked for deletion should not be present on disk at ").append(remoteIndexCacheDir$2.toPath()).toString();
    }

    public static final /* synthetic */ void $anonfun$assertAtLeastOnePresent$1(RemoteIndexCache cache$1, Object nonLocalReturnKey1$1, Uuid uuid) {
        if (cache$1.internalCache().asMap().containsKey(uuid)) {
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    public static final /* synthetic */ boolean $anonfun$assertCacheSize$1(RemoteIndexCacheTest $this, int expectedSize$1) {
        return $this.cache().internalCache().asMap().size() == expectedSize$1;
    }

    public static final /* synthetic */ String $anonfun$assertCacheSize$2(int expectedSize$1) {
        return new StringBuilder(41).append("cache did not adhere to expected size of ").append(expectedSize$1).toString();
    }

    public RemoteIndexCacheTest() {
        this.defaultRemoteIndexCacheSizeBytes = 0x100000L;
        this.brokerId = 1;
        this.segmentSize = 1024;
    }
}

