/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson$;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.RequestHeaderDataJsonConverter;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t4A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)q\u0006\u0001C\u0001=!)\u0011\u0007\u0001C\u0001=!)1\u0007\u0001C\u0001=!)Q\u0007\u0001C\u0001=!)q\u0007\u0001C\u0001=!)\u0011\b\u0001C\u0001=!)1\b\u0001C\u0001=!)Q\b\u0001C\u0001}!)1\u000b\u0001C\u0005)\nA\"+Z9vKN$8i\u001c8wKJ$Hk\u001c&t_:$Vm\u001d;\u000b\u00059y\u0011a\u00028fi^|'o\u001b\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011!D\u0001\u001bi\u0016\u001cH/\u00117m%\u0016\fX/Z:u)f\u0004Xm\u001d%b]\u0012dW\r\u001a\u000b\u0002?A\u0011A\u0003I\u0005\u0003CU\u0011A!\u00168ji\"\u0012!a\t\t\u0003I5j\u0011!\n\u0006\u0003M\u001d\n1!\u00199j\u0015\tA\u0013&A\u0004kkBLG/\u001a:\u000b\u0005)Z\u0013!\u00026v]&$(\"\u0001\u0017\u0002\u0007=\u0014x-\u0003\u0002/K\t!A+Z:u\u0003\u0005\"Xm\u001d;BY2\f\u0005/\u001b,feNLwN\\:SKN\u0004xN\\:f\u0011\u0006tG\r\\3eQ\t\u00191%A\u000euKN$\u0018\t\u001c7SKN\u0004xN\\:f)f\u0004Xm\u001d%b]\u0012dW\r\u001a\u0015\u0003\t\r\nQ\u0003^3tiJ+\u0017/^3ti\"+\u0017\rZ3s\u001d>$W\r\u000b\u0002\u0006G\u0005iC/Z:u%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:O_\u0012,w+\u001b;i\t\u0016\u0004(/Z2bi\u0016$\u0017\t]5WKJ\u001c\u0018n\u001c8)\u0005\u0019\u0019\u0013A\u0005;fgR\u001cE.[3oi&sgm\u001c(pI\u0016D#aB\u0012\u0002\u001fQ,7\u000f\u001e*fcV,7\u000f\u001e#fg\u000eD#\u0001C\u0012\u0002-Q,7\u000f\u001e*fcV,7\u000f\u001e#fg\u000elU\r\u001e:jGND#!C\u0012\u0002\u000fI,\u0017/^3tiR\u0011qH\u0012\t\u0003\u0001\u000es!\u0001H!\n\u0005\tk\u0011A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0003\t\u0016\u0013qAU3rk\u0016\u001cHO\u0003\u0002C\u001b!)qI\u0003a\u0001\u0011\u0006\u0019!/Z9\u0011\u0005%\u000bV\"\u0001&\u000b\u0005-c\u0015\u0001\u0003:fcV,7\u000f^:\u000b\u00055s\u0015AB2p[6|gN\u0003\u0002\u0011\u001f*\u0011\u0001kK\u0001\u0007CB\f7\r[3\n\u0005IS%aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\u0002#9,wOU3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0006\u0002V1B\u0011\u0011JV\u0005\u0003/*\u0013aBU3rk\u0016\u001cHoQ8oi\u0016DH\u000fC\u0003Z\u0017\u0001\u0007!,\u0001\u0004ck\u001a4WM\u001d\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000b1A\\5p\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019/\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f")
public class RequestConvertToJsonTest {
    @Test
    public void testAllRequestTypesHandled() {
        ArrayBuffer unhandledKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values())).foreach((Function1 & Serializable & scala.Serializable)key -> {
            short version = key.latestVersion();
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)(ApiKeys.DESCRIBE_ACLS.equals(key) ? ((DescribeAclsRequestData)ApiMessageType.fromApiKey((short)key.id).newRequest()).setPatternTypeFilter((byte)1).setResourceTypeFilter((byte)1).setPermissionType((byte)1).setOperation((byte)1) : ApiMessageType.fromApiKey((short)key.id).newRequest()), (short)version);
            AbstractRequest req = AbstractRequest.parseRequest((ApiKeys)key, (short)version, (ByteBuffer)bytes).request;
            try {
                return RequestConvertToJson$.MODULE$.request(req);
            }
            catch (IllegalStateException illegalStateException) {
                return unhandledKeys.$plus$eq((Object)key.toString());
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledKeys, (String)"Unhandled request keys");
    }

    @Test
    public void testAllApiVersionsResponseHandled() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values())).foreach((Function1 & Serializable & scala.Serializable)key -> {
            RequestConvertToJsonTest.$anonfun$testAllApiVersionsResponseHandled$1(key);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAllResponseTypesHandled() {
        ArrayBuffer unhandledKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values())).foreach((Function1 & Serializable & scala.Serializable)key -> {
            short version = key.latestVersion();
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)ApiMessageType.fromApiKey((short)key.id).newResponse(), (short)version);
            AbstractResponse res = AbstractResponse.parseResponse((ApiKeys)key, (ByteBuffer)bytes, (short)version);
            try {
                return RequestConvertToJson$.MODULE$.response(res, version);
            }
            catch (IllegalStateException illegalStateException) {
                return unhandledKeys.$plus$eq((Object)key.toString());
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledKeys, (String)"Unhandled response keys");
    }

    @Test
    public void testRequestHeaderNode() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), 0);
        RequestHeader header = this.request((AbstractRequest)alterIsrRequest).header();
        ObjectNode expectedNode = (ObjectNode)RequestHeaderDataJsonConverter.write((RequestHeaderData)header.data(), (short)header.headerVersion(), (boolean)false);
        expectedNode.set("requestApiKeyName", (JsonNode)new TextNode(header.apiKey().toString()));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestHeaderNode(header);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestHeaderNodeWithDeprecatedApiVersion() {
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((short)0, (int)0, (int)0, Collections.emptyMap()).build((short)0);
        RequestHeader header = this.request((AbstractRequest)fetchRequest).header();
        ObjectNode expectedNode = (ObjectNode)RequestHeaderDataJsonConverter.write((RequestHeaderData)header.data(), (short)header.headerVersion(), (boolean)false);
        expectedNode.set("requestApiKeyName", (JsonNode)new TextNode(header.apiKey().toString()));
        expectedNode.set("requestApiVersionDeprecated", (JsonNode)BooleanNode.TRUE);
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestHeaderNode(header);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testClientInfoNode() {
        ClientInformation clientInfo = new ClientInformation("name", "1");
        ObjectNode expectedNode = new ObjectNode(JsonNodeFactory.instance);
        expectedNode.set("softwareName", (JsonNode)new TextNode(clientInfo.softwareName()));
        expectedNode.set("softwareVersion", (JsonNode)new TextNode(clientInfo.softwareVersion()));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.clientInfoNode(clientInfo);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDesc() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        ObjectNode expectedNode = new ObjectNode(JsonNodeFactory.instance);
        expectedNode.set("isForwarded", (JsonNode)(req.isForwarded() ? BooleanNode.TRUE : BooleanNode.FALSE));
        expectedNode.set("requestHeader", RequestConvertToJson$.MODULE$.requestHeaderNode(req.header()));
        expectedNode.set("request", (JsonNode)req.requestLog().getOrElse((Function0 & Serializable & scala.Serializable)() -> new TextNode("")));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDescMetrics() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        NetworkSend send = new NetworkSend(req.context().connectionId, alterIsrRequest.toSend(req.header()));
        JsonNode headerLog = RequestConvertToJson$.MODULE$.requestHeaderNode(req.header());
        RequestChannel.SendResponse res = new RequestChannel.SendResponse(req, (Send)send, (Option)new Some((Object)headerLog), (Option)None$.MODULE$);
        boolean totalTimeMs = true;
        int requestQueueTimeMs = 2;
        int apiLocalTimeMs = 3;
        int apiRemoteTimeMs = 4;
        int apiThrottleTimeMs = 5;
        int responseQueueTimeMs = 6;
        int responseSendTimeMs = 7;
        int temporaryMemoryBytes = 8;
        int messageConversionsTimeMs = 9;
        ObjectNode expectedNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        expectedNode.set("response", (JsonNode)res.responseLog().getOrElse((Function0 & Serializable & scala.Serializable)() -> new TextNode("")));
        expectedNode.set("connection", (JsonNode)new TextNode(req.context().connectionId));
        expectedNode.set("totalTimeMs", (JsonNode)new DoubleNode((double)totalTimeMs));
        expectedNode.set("requestQueueTimeMs", (JsonNode)new DoubleNode((double)requestQueueTimeMs));
        expectedNode.set("localTimeMs", (JsonNode)new DoubleNode((double)apiLocalTimeMs));
        expectedNode.set("remoteTimeMs", (JsonNode)new DoubleNode((double)apiRemoteTimeMs));
        expectedNode.set("throttleTimeMs", (JsonNode)new LongNode((long)apiThrottleTimeMs));
        expectedNode.set("responseQueueTimeMs", (JsonNode)new DoubleNode((double)responseQueueTimeMs));
        expectedNode.set("sendTimeMs", (JsonNode)new DoubleNode((double)responseSendTimeMs));
        expectedNode.set("securityProtocol", (JsonNode)new TextNode(req.context().securityProtocol.toString()));
        expectedNode.set("principal", (JsonNode)new TextNode(req.session().principal().toString()));
        expectedNode.set("listener", (JsonNode)new TextNode(req.context().listenerName.value()));
        expectedNode.set("clientInformation", RequestConvertToJson$.MODULE$.clientInfoNode(req.context().clientInformation));
        expectedNode.set("temporaryMemoryBytes", (JsonNode)new LongNode((long)temporaryMemoryBytes));
        expectedNode.set("messageConversionsTime", (JsonNode)new DoubleNode((double)messageConversionsTimeMs));
        ObjectNode actualNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDescMetrics(req.header(), req.requestLog(), res.responseLog(), req.context(), req.session(), req.isForwarded(), (double)totalTimeMs, (double)requestQueueTimeMs, (double)apiLocalTimeMs, (double)apiRemoteTimeMs, (long)apiThrottleTimeMs, (double)responseQueueTimeMs, (double)responseSendTimeMs, (long)temporaryMemoryBytes, (double)messageConversionsTimeMs);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class), RequestChannel.Request$.MODULE$.$lessinit$greater$default$7());
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), false);
    }

    public static final /* synthetic */ void $anonfun$testAllApiVersionsResponseHandled$1(ApiKeys key) {
        ArrayBuffer unhandledVersions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        key.allVersions().forEach(version -> {
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)(ApiKeys.DESCRIBE_LOG_DIRS.equals(key) ? ((DescribeLogDirsResponseData)ApiMessageType.fromApiKey((short)key$1.id).newResponse()).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()) : ApiMessageType.fromApiKey((short)key$1.id).newResponse()), (short)Predef$.MODULE$.Short2short(version));
            AbstractResponse response = AbstractResponse.parseResponse((ApiKeys)key, (ByteBuffer)bytes, (short)Predef$.MODULE$.Short2short(version));
            try {
                RequestConvertToJson$.MODULE$.response(response, Predef$.MODULE$.Short2short(version));
                return;
            }
            catch (IllegalStateException illegalStateException) {
                unhandledVersions.$plus$eq(version);
                return;
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledVersions, (String)new StringBuilder(34).append("API: ").append(key.toString()).append(" - Unhandled request versions").toString());
    }
}

