/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.BrokerEndPoint;
import kafka.server.FailedPartitions;
import kafka.server.FetcherMetrics$;
import kafka.server.FetcherThreadTestUtils$;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.MockFetcherThread;
import kafka.server.MockFetcherThread$;
import kafka.server.MockLeaderEndPoint;
import kafka.server.MockLeaderEndPoint$;
import kafka.server.MockTierStateMachine;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionState;
import kafka.server.PartitionState$;
import kafka.server.Truncating$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.errors.UnknownTopicIdException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\u00181\u0001UBQ\u0001\u0010\u0001\u0005\u0002uBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004F\u0001\u0001\u0006IA\u0011\u0005\b\r\u0002\u0011\r\u0011\"\u0001H\u0011\u0019\t\u0007\u0001)A\u0005\u0011\"9!\r\u0001b\u0001\n\u0003\u0019\u0007BB4\u0001A\u0003%A\rC\u0004i\u0001\t\u0007I\u0011B5\t\r5\u0004\u0001\u0015!\u0003k\u0011\u001dq\u0007A1A\u0005\n%Daa\u001c\u0001!\u0002\u0013Q\u0007b\u00029\u0001\u0005\u0004%I!\u001d\u0005\u0007k\u0002\u0001\u000b\u0011\u0002:\t\u000bY\u0004A\u0011A<\t\u000f\u00055\u0001\u0001\"\u0003\u0002\u0010!1\u00111\u0006\u0001\u0005\u0002]Da!!\u000e\u0001\t\u00039\bBBA\u001d\u0001\u0011\u0005q\u000f\u0003\u0004\u0002>\u0001!\ta\u001e\u0005\u0007\u0003\u0003\u0002A\u0011A<\t\r\u0005\u0015\u0003\u0001\"\u0001x\u0011\u0019\tI\u0005\u0001C\u0001o\"1\u0011Q\n\u0001\u0005\u0002]Da!!\u0015\u0001\t\u00039\bBBA+\u0001\u0011\u0005q\u000f\u0003\u0004\u0002Z\u0001!\ta\u001e\u0005\u0007\u0003;\u0002A\u0011A<\t\r\u0005\u0005\u0004\u0001\"\u0001x\u0011\u0019\t)\u0007\u0001C\u0001o\"1\u0011\u0011\u000e\u0001\u0005\u0002]Da!!\u001c\u0001\t\u00039\bBBA9\u0001\u0011\u0005q\u000f\u0003\u0004\u0002v\u0001!\ta\u001e\u0005\u0007\u0003s\u0002A\u0011A<\t\r\u0005u\u0004\u0001\"\u0001x\u0011\u0019\t\t\t\u0001C\u0001o\"1\u0011Q\u0011\u0001\u0005\u0002]Dq!!#\u0001\t\u0013\tY\t\u0003\u0004\u0002\u0018\u0002!\ta\u001e\u0005\u0007\u00037\u0003A\u0011A<\t\r\u0005}\u0005\u0001\"\u0001x\u0011\u0019\t\u0019\u000b\u0001C\u0001o\"9\u0011q\u0015\u0001\u0005\n\u0005%\u0006BBA[\u0001\u0011\u0005q\u000f\u0003\u0004\u0002:\u0002!\ta\u001e\u0005\u0007\u0003{\u0003A\u0011A<\u00033\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bIR+7\u000f\u001e\u0006\u0003cI\naa]3sm\u0016\u0014(\"A\u001a\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005q\u0004CA \u0001\u001b\u0005\u0001\u0014a\u0004;sk:\u001c\u0017\r^3P]\u001a+Go\u00195\u0016\u0003\t\u0003\"aN\"\n\u0005\u0011C$a\u0002\"p_2,\u0017M\\\u0001\u0011iJ,hnY1uK>sg)\u001a;dQ\u0002\n\u0001\u0002^8qS\u000eLEm]\u000b\u0002\u0011B!\u0011\n\u0014(W\u001b\u0005Q%BA&9\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001b*\u00131!T1q!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0003mC:<'\"A*\u0002\t)\fg/Y\u0005\u0003+B\u0013aa\u0015;sS:<\u0007CA,`\u001b\u0005A&BA-[\u0003\u0019\u0019w.\\7p]*\u00111g\u0017\u0006\u00039v\u000ba!\u00199bG\",'\"\u00010\u0002\u0007=\u0014x-\u0003\u0002a1\n!Q+^5e\u0003%!x\u000e]5d\u0013\u0012\u001c\b%A\u0004wKJ\u001c\u0018n\u001c8\u0016\u0003\u0011\u0004\"aN3\n\u0005\u0019D$!B*i_J$\u0018\u0001\u0003<feNLwN\u001c\u0011\u0002\u0015A\f'\u000f^5uS>t\u0017'F\u0001k!\t96.\u0003\u0002m1\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u00039beRLG/[8oc\u0001\n!\u0002]1si&$\u0018n\u001c83\u0003-\u0001\u0018M\u001d;ji&|gN\r\u0011\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001cX#\u0001:\u0011\u0005}\u001a\u0018B\u0001;1\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/A\tgC&dW\r\u001a)beRLG/[8og\u0002\n1c\u00197fC:lU\r\u001e:jGJ+w-[:uef$\u0012\u0001\u001f\t\u0003oeL!A\u001f\u001d\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u001dq\u00042!`A\u0005\u001b\u0005q(bA@\u0002\u0002\u0005\u0019\u0011\r]5\u000b\t\u0005\r\u0011QA\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t9!X\u0001\u0006UVt\u0017\u000e^\u0005\u0004\u0003\u0017q(A\u0003\"fM>\u0014X-R1dQ\u0006y\u0011\r\u001c7NKR\u0014\u0018nY:OC6,7/\u0006\u0002\u0002\u0012A)\u0011*a\u0005\u0002\u0018%\u0019\u0011Q\u0003&\u0003\u0007M+G\u000f\u0005\u0003\u0002\u001a\u0005\u001db\u0002BA\u000e\u0003G\u00012!!\b9\u001b\t\tyBC\u0002\u0002\"Q\na\u0001\u0010:p_Rt\u0014bAA\u0013q\u00051\u0001K]3eK\u001aL1!VA\u0015\u0015\r\t)\u0003O\u0001\u001di\u0016\u001cH/T3ue&\u001c7OU3n_Z,Gm\u00148TQV$Hm\\<oQ\r\u0001\u0012q\u0006\t\u0004{\u0006E\u0012bAA\u001a}\n!A+Z:u\u0003\r\"Xm\u001d;D_:\u001cX/\\3s\u0019\u0006<'+Z7pm\u0016$w+\u001b;i!\u0006\u0014H/\u001b;j_:D3!EA\u0018\u0003=!Xm\u001d;TS6\u0004H.\u001a$fi\u000eD\u0007f\u0001\n\u00020\u0005IA/Z:u\t\u0016d\u0017-\u001f\u0015\u0004'\u0005=\u0012!\u0006;fgR\u0004\u0016M\u001d;ji&|gn]%o\u000bJ\u0014xN\u001d\u0015\u0004)\u0005=\u0012\u0001\u0006;fgR4UM\\2fIR\u0013XO\\2bi&|g\u000eK\u0002\u0016\u0003_\tq\u0002^3ti\u001a+gnY3e\r\u0016$8\r\u001b\u0015\u0004-\u0005=\u0012A\t;fgR,fn\u001b8po:dU-\u00193fe\u0016\u0003xn\u00195J]R\u0013XO\\2bi&|g\u000eK\u0002\u0018\u0003_\t1\u0005^3tiVs7N\\8x]2+\u0017\rZ3s\u000bB|7\r[,iS2,g)\u001a;dQ&tw\rK\u0002\u0019\u0003_\ta\u0002^3tiR\u0013XO\\2bi&|g\u000eK\u0002\u001a\u0003_\t1\b^3tiR\u0013XO\\2bi\u0016$v\u000eS5hQ^\u000bG/\u001a:nCJ\\\u0017J\u001a'fC\u0012,'/\u00129pG\"\u0014V-];fgRtu\u000e^*vaB|'\u000f^3eQ\rQ\u0012qF\u00019i\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a+p\u0011&<\u0007nV1uKJl\u0017M]6JM2+\u0017\rZ3s\u000bB|7\r[%oM>tu\u000e^!wC&d\u0017M\u00197fQ\rY\u0012qF\u00012i\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a+p\u0011&<\u0007nV1uKJl\u0017M]6EkJLgn\u001a*f[>4X\rU1si&$\u0018n\u001c8tQ\ra\u0012qF\u0001%i\u0016\u001cH\u000f\u0016:v]\u000e\fG/[8o'.L\u0007\u000f]3e\u0013\u001atu.\u00129pG\"\u001c\u0005.\u00198hK\"\u001aQ$a\f\u0002]Q,7\u000f\u001e+sk:\u001c\u0017\r^5p]>sg)\u001a;dQN[\u0017\u000e\u001d9fI&3\u0007+\u0019:uSRLwN\u001c*f[>4X\r\u001a\u0015\u0004=\u0005=\u0012a\b;fgR4u\u000e\u001c7po\u0016\u0014h)\u001a;dQ>+Ho\u00144SC:<W\rS5hQ\"\u001aq$a\f\u0002IQ,7\u000f\u001e$f]\u000e,Gm\u00144gg\u0016$(+Z:fi\u00063G/\u001a:PkR|eMU1oO\u0016D3\u0001IA\u0018\u0003y!Xm\u001d;G_2dwn^3s\r\u0016$8\r[(vi>3'+\u00198hK2{w\u000fK\u0002\"\u0003_\t1\u0007^3tiJ+GO]=BMR,'/\u00168l]><h\u000eT3bI\u0016\u0014X\t]8dQ&sG*\u0019;fgR|eMZ:fi\u001a+Go\u00195)\u0007\t\ny#\u0001\nuKN$8i\u001c:skB$X*Z:tC\u001e,\u0007fA\u0012\u00020\u00051D/Z:u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00115b]\u001e,G)\u001e:j]\u001e4UM\\2fI\u001a+Go\u00195Fa>\u001c\u0007n\u001d$s_6dU-\u00193fe\"\u001aA%a\f\u0002uQ,7\u000f\u001e'fC\u0012,'/\u00129pG\"\u001c\u0005.\u00198hK\u0012+(/\u001b8h'V\u001c7-Z:tMVdg)\u001a;dQ\u0016\u0003xn\u00195t\rJ|W\u000eT3bI\u0016\u0014\bfA\u0013\u00020\u0005\u0001D/Z:u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00115b]\u001e,G)\u001e:j]\u001e4U\r^2i\u000bB|7\r[:Ge>lG*Z1eKJ$2\u0001_AG\u0011\u001d\tyI\na\u0001\u0003#\u000b1\u0003\\3bI\u0016\u0014X\t]8dQ>sG*Z1eKJ\u00042aNAJ\u0013\r\t)\n\u000f\u0002\u0004\u0013:$\u0018a\r;fgR$&/\u001e8dCR,Gk\\#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:EkJLgn\u001a*f[>4X\rU1si&$\u0018n\u001c8tQ\r9\u0013qF\u0001Pi\u0016\u001cH\u000f\u0016:v]\u000e\fG/[8o)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]&3G*Z1eKJ\u0014V\r^;s]N\u0004\u0016M\u001d;ji&|gn\u001d(piJ+\u0017/^3ti\u0016$\u0017J\u001c$fi\u000eDW\t]8dQND3\u0001KA\u0018\u0003a\"Xm\u001d;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a%b]\u0012d\u0017N\\4QCJ$\u0018\u000e^5p]\u001a\u000b\u0017\u000e\\;sK\u0012+(/\u001b8h\u0003B\u0004XM\u001c3j]\u001eD3!KA\u0018\u0003e\"Xm\u001d;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a%b]\u0012d\u0017N\\4QCJ$\u0018\u000e^5p]\u001a\u000b\u0017\u000e\\;sK\u0012+(/\u001b8h)J,hnY1uS>t\u0007f\u0001\u0016\u00020\u0005Yc/\u001a:jMf4U\r^2iKJ$\u0006N]3bI\"\u000bg\u000e\u001a7j]\u001e\u0004\u0016M\u001d;ji&|gNR1jYV\u0014X\rF\u0002y\u0003WCq!!,,\u0001\u0004\ty+A\u0004gKR\u001c\u0007.\u001a:\u0011\u0007}\n\t,C\u0002\u00024B\u0012\u0011#T8dW\u001a+Go\u00195feRC'/Z1e\u0003M!Xm\u001d;ESZ,'oZ5oO\u0016\u0003xn\u00195tQ\ra\u0013qF\u0001/i\u0016\u001cH\u000f\u0016:v]\u000e\fG/Z(o\r\u0016$8\r\u001b#pKNtu\u000e\u001e)s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\rK\u0002.\u0003_\tq\u0003^3ti6\u000b\u0017PY3Va\u0012\fG/\u001a+pa&\u001c\u0017\nZ:)\u00079\ny\u0003")
public class AbstractFetcherThreadTest {
    private final boolean truncateOnFetch;
    private final Map<String, Uuid> topicIds = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)Uuid.randomUuid())}));
    private final short version = ApiKeys.FETCH.latestVersion();
    private final TopicPartition kafka$server$AbstractFetcherThreadTest$$partition1 = new TopicPartition("topic1", 0);
    private final TopicPartition partition2 = new TopicPartition("topic2", 0);
    private final FailedPartitions kafka$server$AbstractFetcherThreadTest$$failedPartitions = new FailedPartitions();

    public boolean truncateOnFetch() {
        return this.truncateOnFetch;
    }

    public Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public short version() {
        return this.version;
    }

    public TopicPartition kafka$server$AbstractFetcherThreadTest$$partition1() {
        return this.kafka$server$AbstractFetcherThreadTest$$partition1;
    }

    private TopicPartition partition2() {
        return this.partition2;
    }

    public FailedPartitions kafka$server$AbstractFetcherThreadTest$$failedPartitions() {
        return this.kafka$server$AbstractFetcherThreadTest$$failedPartitions;
    }

    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Set<String> allMetricsNames() {
        return (Set)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).keySet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), Set$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetricsRemovedOnShutdown() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$22 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$22);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.start();
        scala.collection.immutable.Set brokerTopicStatsMetrics = fetcher.brokerTopicStats().allTopicsStats().metricMap().keySet();
        Set fetcherMetrics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{FetcherMetrics$.MODULE$.BytesPerSec(), FetcherMetrics$.MODULE$.RequestsPerSec(), FetcherMetrics$.MODULE$.ConsumerLag()}));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testMetricsRemovedOnShutdown$2(this, brokerTopicStatsMetrics, fetcherMetrics)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractFetcherThreadTest.$anonfun$testMetricsRemovedOnShutdown$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        fetcher.shutdown();
        scala.collection.immutable.Set metricNames = ((TraversableOnce)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).keySet().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Set$.MODULE$.canBuildFrom())).toSet();
        Assertions.assertTrue((boolean)((SetLike)metricNames.intersect((GenSet)fetcherMetrics)).isEmpty());
        Assertions.assertEquals((Object)brokerTopicStatsMetrics, (Object)metricNames.intersect((GenSet)brokerTopicStatsMetrics));
    }

    @Test
    public void testConsumerLagRemovedWithPartition() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertTrue((boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()), (String)"Failed waiting for consumer lag metric");
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
        Assertions.assertFalse((boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
    }

    @Test
    public void testSimpleFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)2L, (long)replicaState.highWatermark());
    }

    @Test
    public void testDelay() {
        TopicPartition partition = new TopicPartition("topic", 0);
        int fetchBackOffMs = 250;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                throw new UnknownTopicIdException("Topic ID was unknown as expected for this test");
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        int x$4 = MockFetcherThread$.MODULE$.$lessinit$greater$default$3();
        int x$5 = MockFetcherThread$.MODULE$.$lessinit$greater$default$4();
        FailedPartitions x$6 = MockFetcherThread$.MODULE$.$lessinit$greater$default$6();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$4, x$5, fetchBackOffMs, x$6);
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        long timeBeforeFirst = System.currentTimeMillis();
        fetcher.doWork();
        long firstWorkDuration = System.currentTimeMillis() - timeBeforeFirst;
        long timeBeforeSecond = System.currentTimeMillis();
        fetcher.doWork();
        long secondWorkDuration = System.currentTimeMillis() - timeBeforeSecond;
        Assertions.assertTrue((firstWorkDuration < secondWorkDuration ? 1 : 0) != 0);
        Assertions.assertTrue(((long)fetchBackOffMs <= secondWorkDuration ? 1 : 0) != 0, (String)new StringBuilder(70).append("secondWorkDuration: ").append(secondWorkDuration).append(" was not greater than or equal to fetchBackOffMs: ").append(fetchBackOffMs).toString());
    }

    @Test
    public void testPartitionsInError() {
        TopicPartition partition1 = new TopicPartition("topic1", 0);
        TopicPartition partition2 = new TopicPartition("topic2", 0);
        TopicPartition partition3 = new TopicPartition("topic3", 0);
        int fetchBackOffMs = 250;
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this, partition1, partition2, partition3){
            private final TopicPartition partition1$1;
            private final TopicPartition partition2$1;
            private final TopicPartition partition3$1;

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                return (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition1$1), (Object)new FetchResponseData.PartitionData().setErrorCode(Errors.UNKNOWN_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition2$1), (Object)new FetchResponseData.PartitionData().setErrorCode(Errors.INCONSISTENT_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition3$1), (Object)new FetchResponseData.PartitionData().setErrorCode(Errors.NONE.code()))}));
            }
            {
                this.partition1$1 = partition1$1;
                this.partition2$1 = partition2$1;
                this.partition3$1 = partition3$1;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        int x$4 = MockFetcherThread$.MODULE$.$lessinit$greater$default$3();
        int x$5 = MockFetcherThread$.MODULE$.$lessinit$greater$default$4();
        FailedPartitions x$6 = MockFetcherThread$.MODULE$.$lessinit$greater$default$6();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, x$4, x$5, fetchBackOffMs, x$6);
        fetcher.setReplicaState(partition1, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        fetcher.setReplicaState(partition2, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition2), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        fetcher.setReplicaState(partition3, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition3), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition1, leaderState);
        fetcher.mockLeader().setLeaderState(partition2, leaderState);
        fetcher.mockLeader().setLeaderState(partition3, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Option partition1FetchState = fetcher.fetchState(partition1);
        Option partition2FetchState = fetcher.fetchState(partition2);
        Option partition3FetchState = fetcher.fetchState(partition3);
        Assertions.assertTrue((boolean)partition1FetchState.isDefined());
        Assertions.assertTrue((boolean)partition2FetchState.isDefined());
        Assertions.assertTrue((boolean)partition3FetchState.isDefined());
        Assertions.assertTrue((boolean)((PartitionFetchState)partition1FetchState.get()).isDelayed());
        Assertions.assertTrue((boolean)((PartitionFetchState)partition2FetchState.get()).isDelayed());
        Assertions.assertFalse((boolean)((PartitionFetchState)partition3FetchState.get()).isDelayed());
    }

    @Test
    public void testFencedTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        FailedPartitions x$6 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$7 = MockFetcherThread$.MODULE$.$lessinit$greater$default$3();
        int x$8 = MockFetcherThread$.MODULE$.$lessinit$greater$default$4();
        int x$9 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$9, x$6);
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 1, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)0L, (long)replicaState.highWatermark());
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    @Test
    public void testFencedFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        FailedPartitions x$6 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$7 = MockFetcherThread$.MODULE$.$lessinit$greater$default$3();
        int x$8 = MockFetcherThread$.MODULE$.$lessinit$greater$default$4();
        int x$9 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$9, x$6);
        PartitionState replicaState = PartitionState$.MODULE$.apply(0);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
        PartitionState partitionState = fetcher.mockLeader().leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    @Test
    public void testUnknownLeaderEpochInTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$32 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$32, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        FailedPartitions x$6 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$7 = MockFetcherThread$.MODULE$.$lessinit$greater$default$3();
        int x$8 = MockFetcherThread$.MODULE$.$lessinit$greater$default$4();
        int x$9 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$9, x$6);
        PartitionState replicaState = PartitionState$.MODULE$.apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 1))}))), true);
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.state()));
        PartitionState partitionState = fetcher.mockLeader().leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.state()));
    }

    @Test
    public void testUnknownLeaderEpochWhileFetching() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        PartitionState replicaState = PartitionState$.MODULE$.apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 1))})));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)Nil$.MODULE$)), 1, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.state()));
        fetcher.mockLeader().leaderPartitionState(partition).leaderEpoch_$eq(0);
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.state()));
        fetcher.mockLeader().leaderPartitionState(partition).leaderEpoch_$eq(1);
        fetcher.doWork();
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.state()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 0L, PartitionState$.MODULE$.apply$default$4());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 3, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testTruncation$2(fetcher, partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractFetcherThreadTest.$anonfun$testTruncation$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochRequestNotSupported() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){
            private final boolean isTruncationOnFetchSupported;

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                throw new UnsupportedOperationException();
            }

            public boolean isTruncationOnFetchSupported() {
                return this.isTruncationOnFetchSupported;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.isTruncationOnFetchSupported = false;
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndPoint, mockTierStateMachine, highWatermark){
            private final boolean isOffsetForLeaderEpochSupported;
            private final long highWatermark$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assertions.assertEquals((long)this.highWatermark$1, (long)truncationState.offset());
                Assertions.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public boolean isOffsetForLeaderEpochSupported() {
                return this.isOffsetForLeaderEpochSupported;
            }
            {
                this.highWatermark$1 = highWatermark$1;
                super(mockLeaderEndPoint$1, mockTierStateMachine$1, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
                this.isOffsetForLeaderEpochSupported = false;
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, highWatermark, PartitionState$.MODULE$.apply$default$4());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), highWatermark, 5))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assertions.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochInfoNotAvailable() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                throw new UnsupportedOperationException();
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndPoint, mockTierStateMachine, highWatermark){
            private final long highWatermark$2;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assertions.assertEquals((long)this.highWatermark$2, (long)truncationState.offset());
                Assertions.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.highWatermark$2 = highWatermark$2;
                super(mockLeaderEndPoint$2, mockTierStateMachine$2, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, highWatermark, PartitionState$.MODULE$.apply$default$4());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), highWatermark, 5))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assertions.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncateToHighWatermarkDuringRemovePartitions() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, partition){
            private final TopicPartition partition$2;

            public void truncateToHighWatermark(Set<TopicPartition> partitions) {
                this.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$2})));
                super.truncateToHighWatermark(partitions);
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.partition$2 = partition$2;
                super(mockLeaderEndpoint$1, mockTierStateMachine$3, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, highWatermark, PartitionState$.MODULE$.apply$default$4());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), highWatermark, 5))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)((RecordBatch)replicaLog.last()).nextOffset(), (long)replicaState.logEndOffset());
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testTruncationSkippedIfNoEpochChange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncations = IntRef.create((int)0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, truncations){
            private final IntRef truncations$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncations$1.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.truncations$1 = truncations$1;
                super(mockLeaderEndpoint$2, mockTierStateMachine$4, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
            }
        };
        PartitionState replicaState = PartitionState$.MODULE$.apply(5);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 5))}))), true);
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 3, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((int)1, (int)truncations.elem);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        fetcher.doWork();
        Assertions.assertEquals((int)1, (int)truncations.elem);
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testTruncationOnFetchSkippedIfPartitionRemoved() {
        Assumptions.assumeTrue((boolean)this.truncateOnFetch());
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncations = IntRef.create((int)0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, truncations){
            private final IntRef truncations$2;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncations$2.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.truncations$2 = truncations$2;
                super(mockLeaderEndpoint$3, mockTierStateMachine$5, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 6L, 4))})));
        OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(4).setEndOffset(3L);
        fetcher.truncateOnFetchResponse((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)endOffset)})));
        Assertions.assertEquals((int)1, (int)truncations.elem);
        Map offsets = fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Object)offsets.keySet());
        Assertions.assertEquals((long)3L, (long)((PartitionFetchState)offsets.apply((Object)partition)).fetchOffset());
        OffsetForLeaderEpochResponseData.EpochEndOffset newEndOffset = new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(4).setEndOffset(2L);
        fetcher.truncateOnFetchResponse((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)newEndOffset)})));
        Assertions.assertEquals((int)1, (int)truncations.elem);
    }

    @Test
    public void testFollowerFetchOutOfRangeHigh() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 4, 0L, PartitionState$.MODULE$.apply$default$4());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 4))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 4, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.state()));
        leaderState.log().clear();
        leaderState.logEndOffset_$eq(0L);
        leaderState.logStartOffset_$eq(0L);
        leaderState.highWatermark_$eq(0L);
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)0L, (long)replicaState.highWatermark());
    }

    @Test
    public void testFencedOffsetResetAfterOutOfRange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        BooleanRef fetchedEarliestOffset = BooleanRef.create((boolean)false);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this, fetchedEarliestOffset){
            private final BooleanRef fetchedEarliestOffset$1;

            public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int leaderEpoch) {
                this.fetchedEarliestOffset$1.elem = true;
                throw new FencedLeaderEpochException(new StringBuilder(16).append("Epoch ").append(leaderEpoch).append(" is fenced").toString());
            }

            public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int leaderEpoch) {
                this.fetchedEarliestOffset$1.elem = true;
                throw new FencedLeaderEpochException(new StringBuilder(16).append("Epoch ").append(leaderEpoch).append(" is fenced").toString());
            }
            {
                this.fetchedEarliestOffset$1 = fetchedEarliestOffset$1;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        FailedPartitions x$3 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$4 = MockFetcherThread$.MODULE$.$lessinit$greater$default$3();
        int x$5 = MockFetcherThread$.MODULE$.$lessinit$greater$default$4();
        int x$6 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, x$4, x$5, x$6, x$3);
        Nil$ replicaLog = Nil$.MODULE$;
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 4, 0L, PartitionState$.MODULE$.apply$default$4());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 4))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 4, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertTrue((boolean)fetchedEarliestOffset.elem);
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFollowerFetchOutOfRangeLow() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        FailedPartitions x$6 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$7 = MockFetcherThread$.MODULE$.$lessinit$greater$default$3();
        int x$8 = MockFetcherThread$.MODULE$.$lessinit$greater$default$4();
        int x$92 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$92, x$6);
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)Nil$.MODULE$);
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 0, 0L, PartitionState$.MODULE$.apply$default$4());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 0))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 0, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        if (this.truncateOnFetch()) {
            fetcher.doWork();
        }
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.state()));
        Assertions.assertEquals((long)2L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)replicaState.log().toList());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testFollowerFetchOutOfRangeLow$3(fetcher, partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractFetcherThreadTest.$anonfun$testFollowerFetchOutOfRangeLow$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryAfterUnknownLeaderEpochInLatestOffsetFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){
            private final AtomicInteger tries;

            public AtomicInteger tries() {
                return this.tries;
            }

            public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int leaderEpoch) {
                if (this.tries().getAndIncrement() == 0) {
                    throw new UnknownLeaderEpochException("Unexpected leader epoch");
                }
                return super.fetchLatestOffset(topicPartition, leaderEpoch);
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.tries = new AtomicInteger(0);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)Nil$.MODULE$);
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 0, 0L, PartitionState$.MODULE$.apply$default$4());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 0))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 0, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.state()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$3(fetcher, partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractFetcherThreadTest.$anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testCorruptMessage() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){
            private boolean fetchedOnce;

            public boolean fetchedOnce() {
                return this.fetchedOnce;
            }

            public void fetchedOnce_$eq(boolean x$1) {
                this.fetchedOnce = x$1;
            }

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                Map<TopicPartition, FetchResponseData.PartitionData> fetchedData = super.fetch(fetchRequest);
                if (!this.fetchedOnce()) {
                    ByteBuffer buffer = ((MemoryRecords)((FetchResponseData.PartitionData)((Tuple2)fetchedData.head())._2()).records()).buffer();
                    buffer.putInt(15, buffer.getInt(15) ^ 0x5B7E);
                    buffer.putInt(30, buffer.getInt(30) ^ 0x16C3A);
                    this.fetchedOnce_$eq(true);
                }
                return fetchedData;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.fetchedOnce = false;
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.doWork();
        fetcher.doWork();
        PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testLeaderEpochChangeDuringFencedFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(1);
    }

    @Test
    public void testLeaderEpochChangeDuringSuccessfulFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(0);
    }

    private void testLeaderEpochChangeDuringFetchEpochsFromLeader(int leaderEpochOnLeader) {
        TopicPartition partition = new TopicPartition("topic", 1);
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(this){
            private boolean fetchEpochsFromLeaderOnce;

            public boolean fetchEpochsFromLeaderOnce() {
                return this.fetchEpochsFromLeaderOnce;
            }

            public void fetchEpochsFromLeaderOnce_$eq(boolean x$1) {
                this.fetchEpochsFromLeaderOnce = x$1;
            }

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                if (!this.fetchEpochsFromLeaderOnce()) {
                    this.responseCallback().apply$mcV$sp();
                    this.fetchEpochsFromLeaderOnce_$eq(true);
                }
                return fetchedEpochs;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.fetchEpochsFromLeaderOnce = false;
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, initialLeaderEpochOnFollower))}))), true);
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setResponseCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.changeLeaderEpochWhileFetchEpoch$1(fetcher, partition, nextLeaderEpochOnFollower));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)nextLeaderEpochOnFollower)), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.currentLeaderEpoch())));
        if (leaderEpochOnLeader < nextLeaderEpochOnFollower) {
            fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L, PartitionState$.MODULE$.apply$default$4()));
        }
        fetcher.doWork();
        Assertions.assertEquals(fetcher.mockLeader().leaderPartitionState(partition).log(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncateToEpochEndOffsetsDuringRemovePartitions() {
        TopicPartition partition = new TopicPartition("topic", 0);
        int leaderEpochOnLeader = 0;
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                this.responseCallback().apply$mcV$sp();
                return fetchedEpochs;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, initialLeaderEpochOnFollower))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setResponseCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AbstractFetcherThreadTest.changeLeaderEpochDuringFetchEpoch$1(fetcher, partition, nextLeaderEpochOnFollower));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.state()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.currentLeaderEpoch())));
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L, PartitionState$.MODULE$.apply$default$4()));
        fetcher.doWork();
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncationThrowsExceptionIfLeaderReturnsPartitionsNotRequestedInFetchEpochs() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                TopicPartition unrequestedTp = new TopicPartition("topic2", 0);
                return super.fetchEpochEndOffsets(partitions).toMap(Predef$.MODULE$.$conforms()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unrequestedTp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(unrequestedTp.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(0L)));
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        Assertions.assertThrows(IllegalStateException.class, () -> fetcher.doWork());
    }

    @Test
    public void testFetcherThreadHandlingPartitionFailureDuringAppending() {
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcherForAppend = new MockFetcherThread(this, mockLeaderEndpoint, mockTierStateMachine){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
                TopicPartition topicPartition2 = topicPartition;
                TopicPartition topicPartition3 = this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1();
                if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                    throw new KafkaException();
                }
                return super.processPartitionData(topicPartition, fetchOffset, partitionData);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                FailedPartitions x$3 = $outer.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
                int x$4 = MockFetcherThread$.MODULE$.$lessinit$greater$default$3();
                int x$5 = MockFetcherThread$.MODULE$.$lessinit$greater$default$4();
                int x$6 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
                super(mockLeaderEndpoint$4, mockTierStateMachine$6, x$4, x$5, x$6, x$3);
            }
        };
        this.verifyFetcherThreadHandlingPartitionFailure(fetcherForAppend);
    }

    @Test
    public void testFetcherThreadHandlingPartitionFailureDuringTruncation() {
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcherForTruncation = new MockFetcherThread(this, mockLeaderEndpoint, mockTierStateMachine){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                TopicPartition topicPartition2 = topicPartition;
                TopicPartition topicPartition3 = this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1();
                if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                    throw new Exception();
                }
                super.truncate(topicPartition, truncationState);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                FailedPartitions x$3 = $outer.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
                int x$4 = MockFetcherThread$.MODULE$.$lessinit$greater$default$3();
                int x$5 = MockFetcherThread$.MODULE$.$lessinit$greater$default$4();
                int x$6 = MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
                super(mockLeaderEndpoint$5, mockTierStateMachine$7, x$4, x$5, x$6, x$3);
            }
        };
        this.verifyFetcherThreadHandlingPartitionFailure(fetcherForTruncation);
    }

    private void verifyFetcherThreadHandlingPartitionFailure(MockFetcherThread fetcher) {
        fetcher.setReplicaState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1().topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply(0));
        fetcher.setReplicaState(this.partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition2()), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.partition2().topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(this.partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
        fetcher.doWork();
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(this.partition2()).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.state()));
        Assertions.assertFalse((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.partition2()));
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$AbstractFetcherThreadTest$$partition1()})));
        this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().removeAll((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$AbstractFetcherThreadTest$$partition1()})));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1().topic()), 0L, 1))}))), true);
        Assertions.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.state()));
        Assertions.assertFalse((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDivergingEpochs() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 0L, PartitionState$.MODULE$.apply$default$4());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("d".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 2L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testDivergingEpochs$2(fetcher, partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractFetcherThreadTest.$anonfun$testDivergingEpochs$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateOnFetchDoesNotProcessPartitionData() {
        Assumptions.assumeTrue((boolean)this.truncateOnFetch());
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncateCalls = IntRef.create((int)0);
        IntRef processPartitionDataCalls = IntRef.create((int)0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, processPartitionDataCalls, truncateCalls){
            private final IntRef processPartitionDataCalls$1;
            private final IntRef truncateCalls$1;

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
                ++this.processPartitionDataCalls$1.elem;
                return super.processPartitionData(topicPartition, fetchOffset, partitionData);
            }

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncateCalls$1.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.processPartitionDataCalls$1 = processPartitionDataCalls$1;
                this.truncateCalls$1 = truncateCalls$1;
                super(mockLeaderEndpoint$6, mockTierStateMachine$8, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(3L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("d".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(4L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("e".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(5L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("f".getBytes())})), (List)Nil$.MODULE$))))));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 1L, PartitionState$.MODULE$.apply$default$4());
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        Assertions.assertEquals((long)6L, (long)replicaState.logEndOffset());
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(3L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("g".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(4L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("h".getBytes())})), (List)Nil$.MODULE$)))));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 4L, PartitionState$.MODULE$.apply$default$4());
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable & scala.Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((int)1, (int)truncateCalls.elem);
        Assertions.assertEquals((int)0, (int)processPartitionDataCalls.elem);
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)1L, (long)replicaState.highWatermark());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testTruncateOnFetchDoesNotProcessPartitionData$2(fetcher, partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractFetcherThreadTest.$anonfun$testTruncateOnFetchDoesNotProcessPartitionData$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Assertions.assertEquals((int)1, (int)truncateCalls.elem);
        Assertions.assertTrue((processPartitionDataCalls.elem >= 1 ? 1 : 0) != 0);
        Assertions.assertEquals((long)5L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)4L, (long)replicaState.highWatermark());
    }

    @Test
    public void testMaybeUpdateTopicIds() {
        TopicPartition partition = new TopicPartition("topic1", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, MockFetcherThread$.MODULE$.$lessinit$greater$default$3(), MockFetcherThread$.MODULE$.$lessinit$greater$default$4(), MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), MockFetcherThread$.MODULE$.$lessinit$greater$default$6());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)None$.MODULE$, 0L, 0))})));
        AbstractFetcherThreadTest.verifyFetchState$1(fetcher.fetchState(partition), (Option)None$.MODULE$);
        fetcher.maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Function1 & Serializable & scala.Serializable)topicName -> this.topicIds().get(topicName));
        AbstractFetcherThreadTest.verifyFetchState$1(fetcher.fetchState(partition), this.topicIds().get((Object)partition.topic()));
        TopicPartition unknownPartition = new TopicPartition("unknown", 0);
        fetcher.maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition})), (Function1 & Serializable & scala.Serializable)topicName -> this.topicIds().get(topicName));
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownPartition).isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsRemovedOnShutdown$2(AbstractFetcherThreadTest $this, scala.collection.immutable.Set brokerTopicStatsMetrics$1, Set fetcherMetrics$1) {
        Set<String> set = $this.allMetricsNames();
        Set set2 = brokerTopicStatsMetrics$1.$plus$plus((GenTraversableOnce)fetcherMetrics$1);
        return !(set != null ? !set.equals((Object)set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testMetricsRemovedOnShutdown$3() {
        return "Failed waiting for all fetcher metrics to be registered";
    }

    public static final /* synthetic */ boolean $anonfun$testTruncation$2(MockFetcherThread fetcher$10, TopicPartition partition$1) {
        fetcher$10.doWork();
        Buffer<RecordBatch> buffer = fetcher$10.replicaPartitionState(partition$1).log();
        Buffer<RecordBatch> buffer2 = fetcher$10.mockLeader().leaderPartitionState(partition$1).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTruncation$3() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testFollowerFetchOutOfRangeLow$3(MockFetcherThread fetcher$17, TopicPartition partition$3) {
        fetcher$17.doWork();
        Buffer<RecordBatch> buffer = fetcher$17.replicaPartitionState(partition$3).log();
        Buffer<RecordBatch> buffer2 = fetcher$17.mockLeader().leaderPartitionState(partition$3).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testFollowerFetchOutOfRangeLow$4() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$3(MockFetcherThread fetcher$18, TopicPartition partition$4) {
        fetcher$18.doWork();
        Buffer<RecordBatch> buffer = fetcher$18.replicaPartitionState(partition$4).log();
        Buffer<RecordBatch> buffer2 = fetcher$18.mockLeader().leaderPartitionState(partition$4).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$4() {
        return "Failed to reconcile leader and follower logs";
    }

    private final void changeLeaderEpochWhileFetchEpoch$1(MockFetcherThread fetcher$20, TopicPartition partition$5, int nextLeaderEpochOnFollower$1) {
        fetcher$20.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$5})));
        fetcher$20.setReplicaState(partition$5, PartitionState$.MODULE$.apply(nextLeaderEpochOnFollower$1));
        fetcher$20.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition$5), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition$5.topic()), 0L, nextLeaderEpochOnFollower$1))}))), true);
    }

    private static final void changeLeaderEpochDuringFetchEpoch$1(MockFetcherThread fetcher$21, TopicPartition partition$6, int nextLeaderEpochOnFollower$2) {
        fetcher$21.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$6})));
        fetcher$21.setReplicaState(partition$6, PartitionState$.MODULE$.apply(nextLeaderEpochOnFollower$2));
    }

    public static final /* synthetic */ boolean $anonfun$testDivergingEpochs$2(MockFetcherThread fetcher$24, TopicPartition partition$7) {
        fetcher$24.doWork();
        Buffer<RecordBatch> buffer = fetcher$24.replicaPartitionState(partition$7).log();
        Buffer<RecordBatch> buffer2 = fetcher$24.mockLeader().leaderPartitionState(partition$7).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDivergingEpochs$3() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testTruncateOnFetchDoesNotProcessPartitionData$2(MockFetcherThread fetcher$25, TopicPartition partition$8) {
        fetcher$25.doWork();
        Buffer<RecordBatch> buffer = fetcher$25.replicaPartitionState(partition$8).log();
        Buffer<RecordBatch> buffer2 = fetcher$25.mockLeader().leaderPartitionState(partition$8).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTruncateOnFetchDoesNotProcessPartitionData$3() {
        return "Failed to reconcile leader and follower logs";
    }

    private static final void verifyFetchState$1(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    public AbstractFetcherThreadTest() {
        this.truncateOnFetch = true;
    }
}

