/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t\u001df\u0001B\u0015+\u0001=BQ\u0001\u000e\u0001\u0005\u0002UBqa\u000e\u0001A\u0002\u0013E\u0001\bC\u0004F\u0001\u0001\u0007I\u0011\u0003$\t\r=\u0003\u0001\u0015)\u0003:\u0011\u0015\u0001\u0006\u0001\"\u00159\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Daa\u001b\u0001!\u0002\u0013)\u0007b\u00027\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007[\u0002\u0001\u000b\u0011B3\t\u000f9\u0004!\u0019!C\u0005_\"1\u0001\u0010\u0001Q\u0001\nADq!\u001f\u0001C\u0002\u0013%q\u000e\u0003\u0004{\u0001\u0001\u0006I\u0001\u001d\u0005\bw\u0002\u0011\r\u0011\"\u0003p\u0011\u0019a\b\u0001)A\u0005a\"9Q\u0010\u0001b\u0001\n\u0013y\u0007B\u0002@\u0001A\u0003%\u0001\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u0013\u0002A\u0011AA&\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002n\u0001!\t!a\u001c\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0005bBAI\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003;\u0003A\u0011AAP\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!!/\u0001\t\u0013\tY\fC\u0005\u0002f\u0002\t\n\u0011\"\u0003\u0002h\"9\u0011Q \u0001\u0005\n\u0005}\b\"\u0003B\t\u0001E\u0005I\u0011BAt\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqA!\u0019\u0001\t\u0013\u0011\u0019\u0007C\u0004\u0003h\u0001!IA!\u001b\t\u000f\tE\u0004\u0001\"\u0003\u0003t!9!Q\u000f\u0001\u0005\n\t]\u0004b\u0002B?\u0001\u0011%!q\u0010\u0005\b\u0005+\u0003A\u0011\u0002BL\u0011\u001d\u0011i\n\u0001C\u0005\u0005?\u0013A%\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003W1\naa]3sm\u0016\u0014(\"A\u0017\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\r\t\u0003cIj\u0011AK\u0005\u0003g)\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"!\r\u0001\u0002'Q,7\u000f^'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0016\u0003e\u0002\"AO\"\u000e\u0003mR!\u0001P\u001f\u0002\r\r|W.\\8o\u0015\tYcH\u0003\u0002.\u007f)\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h\u0013\t!5HA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003]!Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8o?\u0012*\u0017\u000f\u0006\u0002H\u001bB\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n!QK\\5u\u0011\u001dq5!!AA\u0002e\n1\u0001\u001f\u00132\u0003Q!Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8oA\u0005yQ.\u001a;bI\u0006$\u0018MV3sg&|g.A\u0003tKR,\u0006\u000f\u0006\u0002H'\")AK\u0002a\u0001+\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002W;6\tqK\u0003\u0002Y3\u0006\u0019\u0011\r]5\u000b\u0005i[\u0016a\u00026va&$XM\u001d\u0006\u00039\u0006\u000bQA[;oSRL!AX,\u0003\u0011Q+7\u000f^%oM>D#A\u00021\u0011\u0005Y\u000b\u0017B\u00012X\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0014g\u0006dG/\u001a3QCN\u001cxo\u001c:e\u0005f$Xm]\u000b\u0002KB\u0019\u0001J\u001a5\n\u0005\u001dL%!B!se\u0006L\bC\u0001%j\u0013\tQ\u0017J\u0001\u0003CsR,\u0017\u0001F:bYR,G\rU1tg^|'\u000f\u001a\"zi\u0016\u001c\b%A\u0005tC2$()\u001f;fg\u0006Q1/\u00197u\u0005f$Xm\u001d\u0011\u0002\u000bU\u001cXM]\u0019\u0016\u0003A\u0004\"!\u001d<\u000e\u0003IT!a\u001d;\u0002\t1\fgn\u001a\u0006\u0002k\u0006!!.\u0019<b\u0013\t9(O\u0001\u0004TiJLgnZ\u0001\u0007kN,'/\r\u0011\u0002\u000bU\u001cXM\u001d\u001a\u0002\rU\u001cXM\u001d\u001a!\u0003\u0015)8/\u001a:4\u0003\u0019)8/\u001a:4A\u0005YQO\\6o_^tWk]3s\u00031)hn\u001b8po:,6/\u001a:!\u0003A!Xm\u001d;BYR,'OT8uQ&tw\rF\u0002H\u0003\u0007Aq!!\u0002\u0014\u0001\u0004\t9!\u0001\u0004rk>\u0014X/\u001c\t\u0005\u0003\u0013\t9B\u0004\u0003\u0002\f\u0005M\u0001cAA\u0007\u00136\u0011\u0011q\u0002\u0006\u0004\u0003#q\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0016%\u000ba\u0001\u0015:fI\u00164\u0017bA<\u0002\u001a)\u0019\u0011QC%)\u000fM\ti\"!\f\u00020A!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005\u001d\u0012,\u0001\u0004qCJ\fWn]\u0005\u0005\u0003W\t\tCA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003c\t)$\t\u0002\u00024\u0005)1N]1gi\u0006\u0012\u0011qG\u0001\u0003u.DsaEA\u001e\u0003\u0007\n)\u0005\u0005\u0003\u0002>\u0005}RBAA\u0013\u0013\u0011\t\t%!\n\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA$\u0003\tZH-[:qY\u0006Lh*Y7f{:Z\u0018M]4v[\u0016tGo],ji\"t\u0015-\\3t{\u00069B/Z:u\u00032$XM]*b[\u0016$\u0006.\u001b8h)^L7-\u001a\u000b\u0004\u000f\u00065\u0003bBA\u0003)\u0001\u0007\u0011q\u0001\u0015\b)\u0005u\u0011QFA)Y\u0011\t\t$!\u000e)\u000fQ\tY$a\u0011\u0002F\u0005\u0011B/Z:u\u00032$XM]#naRLXk]3s)\r9\u0015\u0011\f\u0005\b\u0003\u000b)\u0002\u0019AA\u0004Q\u001d)\u0012QDA\u0017\u0003;bC!!\r\u00026!:Q#a\u000f\u0002D\u0005\u0015\u0013!\u0007;fgR\fE\u000e^3s+:\\gn\\<o\u001b\u0016\u001c\u0007.\u00198jg6$2aRA3\u0011\u001d\t)A\u0006a\u0001\u0003\u000fAsAFA\u000f\u0003[\tI\u0007\f\u0003\u00022\u0005U\u0002f\u0002\f\u0002<\u0005\r\u0013QI\u0001\u001ai\u0016\u001cH/\u00117uKJ$vn\u001c$fo&#XM]1uS>t7\u000fF\u0002H\u0003cBq!!\u0002\u0018\u0001\u0004\t9\u0001K\u0004\u0018\u0003;\ti#!\u001e-\t\u0005E\u0012Q\u0007\u0015\b/\u0005m\u00121IA#\u0003i!Xm\u001d;BYR,'\u000fV8p\u001b\u0006t\u00170\u0013;fe\u0006$\u0018n\u001c8t)\r9\u0015Q\u0010\u0005\b\u0003\u000bA\u0002\u0019AA\u0004Q\u001dA\u0012QDA\u0017\u0003\u0003cC!!\r\u00026!:\u0001$a\u000f\u0002D\u0005\u0015\u0013a\t;fgR$U\r\\3uKN{W.\u001a;iS:<G\u000b[1u\t>,7OT8u\u000bbL7\u000f\u001e\u000b\u0004\u000f\u0006%\u0005bBA\u00033\u0001\u0007\u0011q\u0001\u0015\b3\u0005u\u0011QFAGY\u0011\t\t$!\u000e)\u000fe\tY$a\u0011\u0002F\u00051B/Z:u\u00032$XM\u001d(pi\u000e{g\u000e\u001e:pY2,'\u000fF\u0001HQ\rQ\u0012q\u0013\t\u0004-\u0006e\u0015bAAN/\n!A+Z:u\u0003Q!Xm\u001d;BYR,'/\u00118e\t\u0016\u001c8M]5cKR\u0019q)!)\t\u000f\u0005\u00151\u00041\u0001\u0002\b!:1$!\b\u0002.\u0005\u0015F\u0006BA\u0019\u0003kAsaGA\u001e\u0003\u0007\n)%A\ruKN$X*\u001a;bI\u0006$\u0018MV3sg&|g\u000eV8p\u0019><HcA$\u0002.\"9\u0011Q\u0001\u000fA\u0002\u0005\u001d\u0001f\u0002\u000f\u0002\u001e\u00055\u0012\u0011\u0017\u0017\u0003\u0003g\u000b#!!.\u0002\u001b-\u0014\u0018M\u001a;.\u0013\n\u0003vlM05Q\u001da\u00121HA\"\u0003\u000b\nAe]3oI\u0006cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e\u000b\u0007\u0003{\u000bY-!6\u0011\t\u0005}\u0016qY\u0007\u0003\u0003\u0003TA!a1\u0002F\u0006A!/Z9vKN$8O\u0003\u0002=}%!\u0011\u0011ZAa\u0005\u0005\nE\u000e^3s+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKN\u0004xN\\:f\u0011\u001d\ti-\ba\u0001\u0003\u001f\fqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002@\u0006E\u0017\u0002BAj\u0003\u0003\u0014\u0001%\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3ti\"I\u0011q[\u000f\u0011\u0002\u0003\u0007\u0011\u0011\\\u0001\rg>\u001c7.\u001a;TKJ4XM\u001d\t\u0005\u00037\f\t/\u0004\u0002\u0002^*\u0019\u0011q\u001c\u0017\u0002\u000f9,Go^8sW&!\u00111]Ao\u00051\u0019vnY6fiN+'O^3s\u00039\u001aXM\u001c3BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005%(\u0006BAm\u0003W\\#!!<\u0011\t\u0005=\u0018\u0011`\u0007\u0003\u0003cTA!a=\u0002v\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003oL\u0015AC1o]>$\u0018\r^5p]&!\u00111`Ay\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001(g\u0016tG\rR3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000f\u0006\u0004\u0003\u0002\t\u001d!q\u0002\t\u0005\u0003\u007f\u0013\u0019!\u0003\u0003\u0003\u0006\u0005\u0005'\u0001\n#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgB|gn]3\t\u000f\u00055w\u00041\u0001\u0003\nA!\u0011q\u0018B\u0006\u0013\u0011\u0011i!!1\u0003G\u0011+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3ti\"I\u0011q[\u0010\u0011\u0002\u0003\u0007\u0011\u0011\\\u00012g\u0016tG\rR3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003\u0005\u001a\u0007.Z2l\u00032dWI\u001d:peN\fE\u000e^3sS:<7I]3eK:$\u0018.\u00197t)\u001d9%q\u0003B'\u0005;BqA!\u0007\"\u0001\u0004\u0011Y\"\u0001\bsKN,H\u000e^:U_\u000eCWmY6\u0011\r\tu!1\u0005B\u0014\u001b\t\u0011yBC\u0002\u0003\"Q\fA!\u001e;jY&!!Q\u0005B\u0010\u0005\u0011a\u0015n\u001d;\u0011\t\t%\"q\t\b\u0005\u0005W\u0011\tE\u0004\u0003\u0003.\tub\u0002\u0002B\u0018\u0005wqAA!\r\u0003:9!!1\u0007B\u001c\u001d\u0011\tiA!\u000e\n\u0003\tK!\u0001Q!\n\u00055z\u0014B\u0001\u001f?\u0013\u0011\u0011y$!2\u0002\u000f5,7o]1hK&!!1\tB#\u0003\u0015\nE\u000e^3s+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKN\u0004xN\\:f\t\u0006$\u0018M\u0003\u0003\u0003@\u0005\u0015\u0017\u0002\u0002B%\u0005\u0017\u0012q$\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+7/\u001e7u\u0015\u0011\u0011\u0019E!\u0012\t\u000f\t=\u0013\u00051\u0001\u0003R\u0005iQ\r\u001f9fGR,G-\u0012:s_J\u0004BAa\u0015\u0003Z5\u0011!Q\u000b\u0006\u0005\u0005/\n)-\u0001\u0005qe>$xnY8m\u0013\u0011\u0011YF!\u0016\u0003\r\u0015\u0013(o\u001c:t\u0011\u001d\u0011y&\ta\u0001\u0003\u000f\t!bY8oi\u0016DH/T:h\u0003\u0001\u001a\u0007.Z2l\u001d>,%O]8sg\u0006cG/\u001a:j]\u001e\u001c%/\u001a3f]RL\u0017\r\\:\u0015\u0007\u001d\u0013)\u0007C\u0004\u0003\u001a\t\u0002\rAa\u0007\u0002=\rDWmY6Vg\u0016\u0014\u0018\t\u001d9fCJ\u001c\u0018J\\!mi\u0016\u0014(+Z:vYR\u001cH#B$\u0003l\t5\u0004b\u0002B\rG\u0001\u0007!1\u0004\u0005\b\u0005_\u001a\u0003\u0019AA\u0004\u0003\u0011)8/\u001a:\u0002O\u0011,7o\u0019:jE\u0016\fE\u000e\\,ji\"tu\u000eV8q\u0019\u00164X\r\\#se>\u00148i\u001c8gSJlW\r\u001a\u000b\u0003\u0005\u0003\t\u0011f\u00195fG.tu\u000eV8q\u0019\u00164X\r\\#se>\u0014H)Z:de&\u0014\u0017N\\4De\u0016$WM\u001c;jC2\u001cHcA$\u0003z!9!1P\u0013A\u0002\t\u0005\u0011a\u0004:fgB|gn]3U_\u000eCWmY6\u00025\rDWmY6Vg\u0016\u0014\b*Y:Uo>\u001c%/\u001a3f]RL\u0017\r\\:\u0015\u000b\u001d\u0013\tIa%\t\u000f\tea\u00051\u0001\u0003\u0004B1!Q\u0004B\u0012\u0005\u000b\u0003BAa\"\u0003\u000e:!!1\u0006BE\u0013\u0011\u0011YI!\u0012\u0002Q\u0011+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+7\u000f]8og\u0016$\u0015\r^1\n\t\t=%\u0011\u0013\u0002#\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001cX\u000f\u001c;\u000b\t\t-%Q\t\u0005\b\u0005_2\u0003\u0019AA\u0004\u00031\u001a\u0007.Z2l\r>\u00148+\u001b8hY\u0016\u001c\u0006.Y\u001b2e%#XM]1uS>t7\u000fO\u0019:e\r\u0013X\rZ3oi&\fG\u000eF\u0003H\u00053\u0013Y\nC\u0004\u0003\u001a\u001d\u0002\rAa!\t\u000f\t=t\u00051\u0001\u0002\b\u0005)2\r[3dW\u0012+7o\u0019:jE\u00164uN]#se>\u0014HcB$\u0003\"\n\r&Q\u0015\u0005\b\u00053A\u0003\u0019\u0001BB\u0011\u001d\u0011y\u0007\u000ba\u0001\u0003\u000fAqAa\u0014)\u0001\u0004\u0011\t\u0006")
public class AlterUserScramCredentialsRequestTest
extends BaseRequestTest {
    private MetadataVersion testMetadataVersion = MetadataVersion.latestTesting();
    private final byte[] saltedPasswordBytes = "saltedPassword".getBytes(StandardCharsets.UTF_8);
    private final byte[] saltBytes = "salt".getBytes(StandardCharsets.UTF_8);
    private final String user1;
    private final String user2;
    private final String user3;
    private final String unknownUser;

    public MetadataVersion testMetadataVersion() {
        return this.testMetadataVersion;
    }

    public void testMetadataVersion_$eq(MetadataVersion x$1) {
        this.testMetadataVersion = x$1;
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this.testMetadataVersion();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), StandardAuthorizer.class.getName());
            if (testInfo.getDisplayName().contains("quorum=kraft-IBP_3_4")) {
                this.testMetadataVersion_$eq(MetadataVersion.IBP_3_4_IV0);
            }
        } else {
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AlterCredentialsTest.TestAuthorizer.class.getName());
        }
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        super.setUp(testInfo);
    }

    private byte[] saltedPasswordBytes() {
        return this.saltedPasswordBytes;
    }

    private byte[] saltBytes() {
        return this.saltBytes;
    }

    private String user1() {
        return this.user1;
    }

    private String user2() {
        return this.user2;
    }

    private String user3() {
        return this.user3;
    }

    private String unknownUser() {
        return this.unknownUser;
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterNothing(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)0, (int)results.size());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterSameThingTwice(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion1 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion2 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertion1, upsertion2}))).build()), (List)Nil$.MODULE$).foreach((Function1 & Serializable & scala.Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$1(this, request);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletion1, deletion1})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertion2, upsertion2}))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletion1, deletion2})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertion1, upsertion2}))).build()), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$2(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterEmptyUser(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletionEmpty})).setUpsertions(new ArrayList())).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionEmpty}))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletionEmpty, deletionEmpty})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionEmpty}))).build()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterEmptyUser$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterUnknownMechanism(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.UNKNOWN.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionValid1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism((byte)10);
        String user4 = "user4";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionValid4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user5 = "user5";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown5 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user5).setMechanism((byte)10).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user6 = "user6";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown6 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user6).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletionUnknown1, deletionValid1, deletionUnknown2})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionUnknown4, upsertionValid4, upsertionUnknown5, upsertionUnknown6}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)5, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_SASL_MECHANISM, "when altering the credentials with unknown SCRAM mechanisms");
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(results).asScala()).foreach((Function1 & Serializable & scala.Serializable)result -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterUnknownMechanism$1(result);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterTooFewIterations(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(1).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionTooFewIterations}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too few iterations");
        Assertions.assertEquals((Object)"Too few iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterTooManyIterations(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(Integer.MAX_VALUE).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionTooFewIterations}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too many iterations");
        Assertions.assertEquals((Object)"Too many iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testDeleteSomethingThatDoesNotExist(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type())})).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.RESOURCE_NOT_FOUND, "when deleting a non-existing credential");
    }

    @Test
    public void testAlterNotController() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type())})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.notControllerSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.NOT_CONTROLLER, "when routed incorrectly to a non-Controller broker");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterAndDescribe(String quorum) {
        AlterUserScramCredentialsRequest request1_0 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())}))).build();
        java.util.List results1_0 = this.sendAlterUserScramCredentialsRequest(request1_0, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results1_0.size());
        this.checkNoErrorsAlteringCredentials(results1_0);
        this.checkUserAppearsInAlterResults(results1_0, this.user1());
        AlterUserScramCredentialsRequest request1_1 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user3()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())}))).build();
        java.util.List results1_1 = this.sendAlterUserScramCredentialsRequest(request1_1, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)3, (int)results1_1.size());
        this.checkNoErrorsAlteringCredentials(results1_1);
        this.checkUserAppearsInAlterResults(results1_1, this.user1());
        this.checkUserAppearsInAlterResults(results1_1, this.user2());
        this.checkUserAppearsInAlterResults(results1_1, this.user3());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results2 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)3, (int)results2.size());
        this.checkUserHasTwoCredentials(results2, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user2());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user3());
        DescribeUserScramCredentialsRequest request3 = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList((Object[])new DescribeUserScramCredentialsRequestData.UserName[]{new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1())}))).build();
        DescribeUserScramCredentialsResponse response3 = this.sendDescribeUserScramCredentialsRequest(request3, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(response3);
        java.util.List results3 = response3.data().results();
        Assertions.assertEquals((int)1, (int)results3.size());
        this.checkUserHasTwoCredentials(results3, this.user1());
        DescribeUserScramCredentialsRequest requestUnknown = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList((Object[])new DescribeUserScramCredentialsRequestData.UserName[]{new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.unknownUser())}))).build();
        DescribeUserScramCredentialsResponse responseUnknown = this.sendDescribeUserScramCredentialsRequest(requestUnknown, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(responseUnknown);
        java.util.List resultsUnknown = responseUnknown.data().results();
        Assertions.assertEquals((int)2, (int)resultsUnknown.size());
        this.checkUserHasTwoCredentials(resultsUnknown, this.user1());
        this.checkDescribeForError(resultsUnknown, this.unknownUser(), Errors.RESOURCE_NOT_FOUND);
        DescribeUserScramCredentialsRequest requestDuplicateUser = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList((Object[])new DescribeUserScramCredentialsRequestData.UserName[]{new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2())}))).build();
        DescribeUserScramCredentialsResponse responseDuplicateUser = this.sendDescribeUserScramCredentialsRequest(requestDuplicateUser, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(responseDuplicateUser);
        java.util.List resultsDuplicateUser = responseDuplicateUser.data().results();
        Assertions.assertEquals((int)2, (int)resultsDuplicateUser.size());
        this.checkUserHasTwoCredentials(resultsDuplicateUser, this.user1());
        this.checkDescribeForError(resultsDuplicateUser, this.user2(), Errors.DUPLICATE_RESOURCE);
        AlterUserScramCredentialsRequest request4 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())}))).build();
        java.util.List results4 = this.sendAlterUserScramCredentialsRequest(request4, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results4.size());
        this.checkNoErrorsAlteringCredentials(results4);
        this.checkUserAppearsInAlterResults(results4, this.user1());
        this.checkUserAppearsInAlterResults(results4, this.user2());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results5 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)2, (int)results5.size());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user3());
        AlterUserScramCredentialsRequest request6 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user3()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())}))).build();
        java.util.List results6 = this.sendAlterUserScramCredentialsRequest(request6, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results6.size());
        this.checkNoErrorsAlteringCredentials(results6);
        this.checkUserAppearsInAlterResults(results6, this.user1());
        this.checkUserAppearsInAlterResults(results6, this.user3());
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results7 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)0, (int)results7.size());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft-IBP_3_4"})
    public void testMetadataVersionTooLow(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionMetadataVersionTooLow = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionMetadataVersionTooLow}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_VERSION, "when altering the credentials on unsupported IBP version");
        Assertions.assertEquals((Object)"The current metadata version does not support SCRAM", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    private AlterUserScramCredentialsResponse sendAlterUserScramCredentialsRequest(AlterUserScramCredentialsRequest request, SocketServer socketServer) {
        return (AlterUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private SocketServer sendAlterUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private void checkAllErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, Errors expectedError, String contextMsg) {
        Assertions.assertEquals((int)0, (int)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkAllErrorsAlteringCredentials$1(expectedError, x$1)))).size(), (String)new StringBuilder(49).append("Expected all '").append(expectedError.name()).append("' errors when altering credentials ").append(contextMsg).toString());
    }

    private void checkNoErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck) {
        Assertions.assertEquals((int)0, (int)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkNoErrorsAlteringCredentials$1(x$2)))).size(), (String)"Expected no error when altering credentials");
    }

    private void checkUserAppearsInAlterResults(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserAppearsInAlterResults$1(user, x$3))), (String)new StringBuilder(29).append("Expected result to contain '").append(user).append("'").toString());
    }

    private DescribeUserScramCredentialsResponse describeAllWithNoTopLevelErrorConfirmed() {
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest((DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build(), this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(response);
        return response;
    }

    private void checkNoTopLevelErrorDescribingCredentials(DescribeUserScramCredentialsResponse responseToCheck) {
        Assertions.assertEquals((short)Errors.NONE.code(), (short)responseToCheck.data().errorCode(), (String)"Expected no top-level error when describing the credentials");
    }

    private void checkUserHasTwoCredentials(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$1(user, result))), (String)new StringBuilder(50).append("Expected result to contain '").append(user).append("' with 2 credentials: ").append(resultsToCheck).toString());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$2(user, result))), (String)new StringBuilder(90).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_256/4096 and SCRAM_SHA_512/8192 credentials: ").append(resultsToCheck).toString());
    }

    private void checkForSingleSha512Iterations8192Credential(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$1(user, result))), (String)new StringBuilder(49).append("Expected result to contain '").append(user).append("' with 1 credential: ").append(resultsToCheck).toString());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$2(user, result))), (String)new StringBuilder(66).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_512/8192 credential: ").append(resultsToCheck).toString());
    }

    private void checkDescribeForError(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user, Errors expectedError) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkDescribeForError$1(user, expectedError, result))), (String)new StringBuilder(45).append("Expected result to contain '").append(user).append("' with a ").append(expectedError.name()).append(" error: ").append(resultsToCheck).toString());
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        $this.checkNoErrorsAlteringCredentials(results);
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$2(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.DUPLICATE_RESOURCE, "when altering the same credential twice in a single request");
    }

    public static final /* synthetic */ void $anonfun$testAlterEmptyUser$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering an empty user");
        Assertions.assertEquals((Object)"Username must not be empty", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    public static final /* synthetic */ void $anonfun$testAlterUnknownMechanism$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult result) {
        Assertions.assertEquals((Object)"Unknown SCRAM mechanism", (Object)result.errorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$1(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$2() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see 3 users";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$3(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$4() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see only 2 users";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$5(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$6() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see empty user";
    }

    public static final /* synthetic */ boolean $anonfun$checkAllErrorsAlteringCredentials$1(Errors expectedError$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$1) {
        return x$1.errorCode() == expectedError$1.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkNoErrorsAlteringCredentials$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$2) {
        return x$2.errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkUserAppearsInAlterResults$1(String user$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$3) {
        String string = x$3.user();
        return !(string != null ? !string.equals(user$1) : user$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$1(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (result.credentialInfos().size() == 2 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_256.type() && info.iterations() == 4096;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$4(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$2(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.credentialInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$3(info))) && ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.credentialInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$4(info)))) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$1(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$3) : user$3 != null)) {
            if (result.credentialInfos().size() == 1 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$2(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        return !(string != null ? !string.equals(user$3) : user$3 != null) && ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.credentialInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$3(info)));
    }

    public static final /* synthetic */ boolean $anonfun$checkDescribeForError$1(String user$4, Errors expectedError$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$4) : user$4 != null)) {
            if (result.credentialInfos().size() == 0 && result.errorCode() == expectedError$2.code()) {
                return true;
            }
        }
        return false;
    }

    public AlterUserScramCredentialsRequestTest() {
        this.user1 = "user1";
        this.user2 = "user2";
        this.user3 = "user3@user3.com";
        this.unknownUser = "unknownUser";
    }
}

