/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.server.BrokerLifecycleManager;
import kafka.server.KafkaConfig$;
import kafka.server.RegistrationTestContext;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@Timeout(value=12L)
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0007\u000f\u0001MAQA\u0007\u0001\u0005\u0002mAQA\b\u0001\u0005\u0002}AQ\u0001\u000b\u0001\u0005\u0002%BQA\u000f\u0001\u0005\u0002%BQ\u0001\u0010\u0001\u0005\u0002%BQA\u0010\u0001\u0005\u0002%BQ\u0001\u0011\u0001\u0005\u0002%BQA\u0011\u0001\u0005\u0002\rCQ\u0001\u001b\u0001\u0005\u0002%DQa\u001f\u0001\u0005\u0002%BQ! \u0001\u0005\u0002%BQa \u0001\u0005\u0002%\u0012!D\u0011:pW\u0016\u0014H*\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d+fgRT!a\u0004\t\u0002\rM,'O^3s\u0015\u0005\t\u0012!B6bM.\f7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001d!\ti\u0002!D\u0001\u000f\u0003A\u0019wN\u001c4jOB\u0013x\u000e]3si&,7/F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003vi&d'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003I!Xm\u001d;De\u0016\fG/Z!oI\u000ecwn]3\u0015\u0003)\u0002\"!F\u0016\n\u000512\"\u0001B+oSRD#a\u0001\u0018\u0011\u0005=BT\"\u0001\u0019\u000b\u0005E\u0012\u0014aA1qS*\u00111\u0007N\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)d'A\u0003kk:LGOC\u00018\u0003\ry'oZ\u0005\u0003sA\u0012A\u0001V3ti\u00069B/Z:u\u0007J,\u0017\r^3Ti\u0006\u0014H/\u00118e\u00072|7/\u001a\u0015\u0003\t9\n!\u0004^3tiN+8mY3tg\u001a,HNU3hSN$(/\u0019;j_:D#!\u0002\u0018\u0002/Q,7\u000f\u001e*fO&\u001cHO]1uS>tG+[7f_V$\bF\u0001\u0004/\u0003Y!Xm\u001d;D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007FA\u0004/\u0003=\u0001(/\u001a9be\u0016\u0014Vm\u001d9p]N,WC\u0001#N)\r)el\u0019\t\u0004\r&[U\"A$\u000b\u0005!\u0013\u0013AC2p]\u000e,(O]3oi&\u0011!j\u0012\u0002\u0007\rV$XO]3\u0011\u00051kE\u0002\u0001\u0003\u0006\u001d\"\u0011\ra\u0014\u0002\u0002)F\u0011\u0001k\u0015\t\u0003+EK!A\u0015\f\u0003\u000f9{G\u000f[5oOB\u0011A\u000bX\u0007\u0002+*\u0011akV\u0001\te\u0016\fX/Z:ug*\u0011\u0001,W\u0001\u0007G>lWn\u001c8\u000b\u0005EQ&BA.7\u0003\u0019\t\u0007/Y2iK&\u0011Q,\u0016\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\")q\f\u0003a\u0001A\u0006\u00191\r\u001e=\u0011\u0005u\t\u0017B\u00012\u000f\u0005]\u0011VmZ5tiJ\fG/[8o)\u0016\u001cHoQ8oi\u0016DH\u000fC\u0003e\u0011\u0001\u0007Q-\u0001\u0005sKN\u0004xN\\:f!\t!f-\u0003\u0002h+\n\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/Z\u0001\u0005a>dG.\u0006\u0002kYR!1.]:y!\taE\u000eB\u0003O\u0013\t\u0007Q.\u0005\u0002Q]B\u0011Qc\\\u0005\u0003aZ\u00111!\u00118z\u0011\u0015\u0011\u0018\u00021\u0001a\u0003\u001d\u0019wN\u001c;fqRDQ\u0001^\u0005A\u0002U\fq!\\1oC\u001e,'\u000f\u0005\u0002\u001em&\u0011qO\u0004\u0002\u0017\u0005J|7.\u001a:MS\u001a,7-_2mK6\u000bg.Y4fe\")\u00110\u0003a\u0001u\u00061a-\u001e;ve\u0016\u00042AR%l\u0003\u0015\"Xm\u001d;BY^\f\u0017p]*f]\u0012\u001c\u0018iY2v[Vd\u0017\r^3e\u001f\u001a4G.\u001b8f\t&\u00148\u000f\u000b\u0002\u000b]\u0005aB/Z:u%\u0016<\u0017n\u001d;sCRLwN\\%oG2,H-Z:ESJ\u001c\bFA\u0006/\u0003\u001d\"Xm\u001d;Le\u00064GO\u0013\"P\t6+G/\u00193bi\u00064VM]:j_:,\u0006\u000fZ1uK\u00163XM\u001c;)\u00051q\u0003f\u0002\u0001\u0002\u0006\u0005-\u0011Q\u0002\t\u0004_\u0005\u001d\u0011bAA\u0005a\t9A+[7f_V$\u0018!\u0002<bYV,g$\u0001\u0007")
public class BrokerLifecycleManagerTest {
    public Properties configProperties() {
        Properties properties = new Properties();
        properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), "/tmp/foo");
        properties.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        properties.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9093");
        properties.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        properties.setProperty(KafkaConfig$.MODULE$.InitialBrokerRegistrationTimeoutMsProp(), "300000");
        properties.setProperty(KafkaConfig$.MODULE$.BrokerHeartbeatIntervalMsProp(), "100");
        return properties;
    }

    @Test
    public void testCreateAndClose() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        new BrokerLifecycleManager(context.config(), (Time)context.time(), "create-and-close-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"oFoTeS9QT0aAyCyH41v45A")}))).close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateStartAndClose() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "create-start-and-close-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"uiUADXZWTPixVvp6UWFWnw")})));
        Assertions.assertEquals((Object)BrokerState.NOT_RUNNING, (Object)manager.state());
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testCreateStartAndClose$2(manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        manager.close();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager.state());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulRegistration() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "successful-registration-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"gCpDJgRlS2CBCpxoP2VMsQ")})));
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.of(10L));
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistration$2(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistration$3(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        manager.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRegistrationTimeout() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        Node controllerNode = new Node(3000, "localhost", 8021);
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "registration-timeout-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"9XBOAtr4T0Wbx2sbiWh6xg")})));
        context.controllerNodeProvider().node().set(controllerNode);
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        Assertions.assertEquals((int)1, (int)context.mockClient().futureResponses().size());
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$2(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 60000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$3(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        context.time().sleep(300000L);
        TestUtils$ testUtils$3 = TestUtils$.MODULE$;
        long l3 = 60000L;
        if (testUtils$3 == null) {
            throw null;
        }
        TestUtils$ retry_this3 = testUtils$3;
        LongRef retry_wait3 = LongRef.create((long)1L);
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$4(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    retry_this3.logger().underlying().info(retry_this3.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait3)));
                }
                Thread.sleep(retry_wait3.elem);
                retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                continue;
            }
            break;
        }
        manager.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControlledShutdown() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "controlled-shutdown-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"B4RtUz1ySGip3A7ZFYB2dg")})));
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsCaughtUp(true)), controllerNode);
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$2(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsFenced(false)), controllerNode);
        context.time().sleep(20L);
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$3(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        manager.beginControlledShutdown();
        TestUtils$ testUtils$3 = TestUtils$.MODULE$;
        long l3 = 10000L;
        if (testUtils$3 == null) {
            throw null;
        }
        TestUtils$ retry_this3 = testUtils$3;
        LongRef retry_wait3 = LongRef.create((long)1L);
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$4(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    retry_this3.logger().underlying().info(retry_this3.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait3)));
                }
                Thread.sleep(retry_wait3.elem);
                retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                continue;
            }
            break;
        }
        context.mockClient().respond(body -> {
            if (body instanceof BrokerHeartbeatRequest) {
                Assertions.assertTrue((boolean)((BrokerHeartbeatRequest)body).data().wantShutDown());
                return true;
            }
            return false;
        }, (AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setShouldShutDown(true)));
        TestUtils$ testUtils$4 = TestUtils$.MODULE$;
        long l4 = 10000L;
        if (testUtils$4 == null) {
            throw null;
        }
        TestUtils$ retry_this4 = testUtils$4;
        LongRef retry_wait4 = LongRef.create((long)1L);
        long retry_startTime4 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$6(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime4 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this4.logger().underlying().isInfoEnabled()) {
                    retry_this4.logger().underlying().info(retry_this4.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait4)));
                }
                Thread.sleep(retry_wait4.elem);
                retry_wait4.elem += package$.MODULE$.min(retry_wait4.elem, 1000L);
                continue;
            }
            break;
        }
        manager.controlledShutdownFuture().get();
        manager.close();
    }

    public <T extends AbstractRequest> Future<T> prepareResponse(RegistrationTestContext ctx, AbstractResponse response) {
        CompletableFuture result = new CompletableFuture();
        ctx.mockClient().prepareResponseFrom(body -> result.complete(body), response, ctx.controllerNodeProvider().node().get());
        return result;
    }

    public <T> T poll(RegistrationTestContext context, BrokerLifecycleManager manager, Future<T> future) {
        while (!future.isDone() || context.mockClient().hasInFlightRequests()) {
            context.poll();
            manager.eventQueue().wakeup();
            context.time().sleep(5L);
        }
        return future.get();
    }

    @Test
    public void testAlwaysSendsAccumulatedOfflineDirs() {
        RegistrationTestContext ctx = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(ctx.config(), (Time)ctx.time(), "offline-dirs-sent-in-heartbeat-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"0IbF1sjhSGG6FNvnrPbqQg")})));
        Node controllerNode = new Node(3000, "localhost", 8021);
        ctx.controllerNodeProvider().node().set(controllerNode);
        Future registration = this.prepareResponse(ctx, (AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)));
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ctx.highestMetadataOffset().get(), (NodeToControllerChannelManager)ctx.mockChannelManager(), ctx.clusterId(), ctx.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        this.poll(ctx, manager, registration);
        manager.propagateDirectoryFailure(Uuid.fromString((String)"h3sC4Yk-Q9-fd0ntJTocCA"));
        manager.propagateDirectoryFailure(Uuid.fromString((String)"ej8Q9_d2Ri6FXNiTxKFiow"));
        manager.propagateDirectoryFailure(Uuid.fromString((String)"1iF76HVNRPqC7Y4r6647eg"));
        BrokerHeartbeatRequest latestHeartbeat = (BrokerHeartbeatRequest)((TraversableLike)((TraversableLike)Seq$.MODULE$.fill(10, (Function0 & Serializable & scala.Serializable)() -> this.prepareResponse(ctx, (AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData())))).map((Function1 & Serializable & scala.Serializable)x$1 -> (BrokerHeartbeatRequest)this.poll(ctx, manager, (Future)x$1), Seq$.MODULE$.canBuildFrom())).last();
        Assertions.assertEquals((Object)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h3sC4Yk-Q9-fd0ntJTocCA", "ej8Q9_d2Ri6FXNiTxKFiow", "1iF76HVNRPqC7Y4r6647eg"}))).map((Function1 & Serializable & scala.Serializable)x$1 -> Uuid.fromString((String)x$1), Set$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(latestHeartbeat.data().offlineLogDirs()).asScala()).toSet());
        manager.close();
    }

    @Test
    public void testRegistrationIncludesDirs() {
        Set logDirs = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ad5FLIeCTnaQdai5vOjeng", "ybdzUKmYSLK6oiIpI6CPlw"}))).map((Function1 & Serializable & scala.Serializable)x$1 -> Uuid.fromString((String)x$1), Set$.MODULE$.canBuildFrom());
        RegistrationTestContext ctx = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(ctx.config(), (Time)ctx.time(), "registration-includes-dirs-", false, logDirs);
        Node controllerNode = new Node(3000, "localhost", 8021);
        ctx.controllerNodeProvider().node().set(controllerNode);
        Future registration = this.prepareResponse(ctx, (AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)));
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ctx.highestMetadataOffset().get(), (NodeToControllerChannelManager)ctx.mockChannelManager(), ctx.clusterId(), ctx.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        BrokerRegistrationRequest request = (BrokerRegistrationRequest)this.poll(ctx, manager, registration);
        Assertions.assertEquals((Object)logDirs, (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(request.data().logDirs()).asScala()).toSet());
        manager.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testKraftJBODMetadataVersionUpdateEvent() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "successful-registration-", false, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"gCpDJgRlS2CBCpxoP2VMsQ")})));
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.of(10L));
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testKraftJBODMetadataVersionUpdateEvent$2(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testKraftJBODMetadataVersionUpdateEvent$3(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        manager.resendBrokerRegistrationUnlessZkMode();
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1200L)), controllerNode);
        TestUtils$ testUtils$3 = TestUtils$.MODULE$;
        long l3 = 60000L;
        if (testUtils$3 == null) {
            throw null;
        }
        TestUtils$ retry_this3 = testUtils$3;
        LongRef retry_wait3 = LongRef.create((long)1L);
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testKraftJBODMetadataVersionUpdateEvent$4(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    retry_this3.logger().underlying().info(retry_this3.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait3)));
                }
                Thread.sleep(retry_wait3.elem);
                retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                continue;
            }
            break;
        }
        manager.close();
    }

    public static final /* synthetic */ void $anonfun$testCreateStartAndClose$2(BrokerLifecycleManager manager$1) {
        Assertions.assertEquals((Object)BrokerState.STARTING, (Object)manager$1.state());
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistration$2(RegistrationTestContext context$2) {
        Assertions.assertEquals((int)1, (int)context$2.mockChannelManager().unsentQueue().size());
        Assertions.assertEquals((long)10L, (long)((BrokerRegistrationRequest)context$2.mockChannelManager().unsentQueue().getFirst().request().build()).data().previousBrokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistration$3(RegistrationTestContext context$2, BrokerLifecycleManager manager$2) {
        context$2.poll();
        Assertions.assertEquals((long)1000L, (long)manager$2.brokerEpoch());
    }

    private static final void newDuplicateRegistrationResponse$1(RegistrationTestContext context$3, Node controllerNode$1) {
        context$3.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setErrorCode(Errors.DUPLICATE_BROKER_REGISTRATION.code())), controllerNode$1);
        context$3.mockChannelManager().poll();
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$2(RegistrationTestContext context$3) {
        context$3.poll();
        Assertions.assertEquals((int)0, (int)context$3.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$3(RegistrationTestContext context$3, BrokerLifecycleManager manager$3) {
        context$3.time().sleep(100L);
        context$3.poll();
        manager$3.eventQueue().wakeup();
        Assertions.assertEquals((int)0, (int)context$3.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$4(RegistrationTestContext context$3, BrokerLifecycleManager manager$3) {
        context$3.poll();
        manager$3.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager$3.state());
        Assertions.assertTrue((boolean)manager$3.initialCatchUpFuture().isCompletedExceptionally());
        Assertions.assertEquals((long)-1L, (long)manager$3.brokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$2(RegistrationTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RECOVERY, (Object)manager$4.state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$3(RegistrationTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)manager$4.state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$4(RegistrationTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.PENDING_CONTROLLED_SHUTDOWN, (Object)manager$4.state());
        Assertions.assertTrue((boolean)context$4.mockClient().hasInFlightRequests());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$6(RegistrationTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager$4.state());
    }

    public static final /* synthetic */ void $anonfun$testKraftJBODMetadataVersionUpdateEvent$2(RegistrationTestContext context$5) {
        Assertions.assertEquals((int)1, (int)context$5.mockChannelManager().unsentQueue().size());
        Assertions.assertEquals((long)10L, (long)((BrokerRegistrationRequest)context$5.mockChannelManager().unsentQueue().getFirst().request().build()).data().previousBrokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testKraftJBODMetadataVersionUpdateEvent$3(RegistrationTestContext context$5, BrokerLifecycleManager manager$6) {
        context$5.poll();
        Assertions.assertEquals((long)1000L, (long)manager$6.brokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testKraftJBODMetadataVersionUpdateEvent$4(RegistrationTestContext context$5, BrokerLifecycleManager manager$6) {
        context$5.time().sleep(100L);
        context$5.poll();
        manager$6.eventQueue().wakeup();
        Assertions.assertEquals((long)1200L, (long)manager$6.brokerEpoch());
    }
}

