/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import kafka.server.ConfigAdminManager;
import kafka.server.ConfigAdminManager$;
import kafka.server.KafkaConfig;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001\u0002\u0011\"\u0001\u0019BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u0004<\u0001\u0001\u0006Ia\r\u0005\u0006y\u0001!\t!\u0010\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\u0006Q\u0002!\t\u0001\u0014\u0005\u0006S\u0002!\tA\u001b\u0005\u0006c\u0002!\tA\u001b\u0005\be\u0002\u0011\r\u0011\"\u0001t\u0011\u0019Q\b\u0001)A\u0005i\")1\u0010\u0001C\u0001y\"1\u0011q\u0003\u0001\u0005\u0002qDa!a\u0007\u0001\t\u0003a\bBBA\u0010\u0001\u0011\u0005A\u0010\u0003\u0004\u0002$\u0001!\t\u0001 \u0005\u0007\u0003O\u0001A\u0011\u0001'\t\r\u0005%\u0002\u0001\"\u0001M\u0011\u0019\tY\u0003\u0001C\u0001y\"1\u0011q\u0006\u0001\u0005\u0002qDa!a\r\u0001\t\u0003a\bBBA\u001c\u0001\u0011\u0005A\u0010\u0003\u0004\u0002<\u0001!\tA\u001b\u0005\u0007\u0003{\u0001A\u0011\u00016\t\r\u0005}\u0002\u0001\"\u0001}\u0011\u0019\t\u0019\u0005\u0001C\u0001y\"1\u0011q\t\u0001\u0005\u0002qDa!a\u0013\u0001\t\u0003a\u0005BBA'\u0001\u0011\u0005!\u000e\u0003\u0004\u0002P\u0001!\t\u0001 \u0005\u0007\u0003'\u0002A\u0011\u0001?\t\r\u0005]\u0003\u0001\"\u0001}\u0005Y\u0019uN\u001c4jO\u0006#W.\u001b8NC:\fw-\u001a:UKN$(B\u0001\u0012$\u0003\u0019\u0019XM\u001d<fe*\tA%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002_A\u0011\u0001\u0007A\u0007\u0002C\u00051An\\4hKJ,\u0012a\r\t\u0003iej\u0011!\u000e\u0006\u0003m]\nQa\u001d7gi)T\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e6\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013!\u00068fo\u000e{gNZ5h\u0003\u0012l\u0017N\\'b]\u0006<WM\u001d\u000b\u0003}\u0005\u0003\"\u0001M \n\u0005\u0001\u000b#AE\"p]\u001aLw-\u00113nS:l\u0015M\\1hKJDQA\u0011\u0003A\u0002\r\u000b\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0003\t&k\u0011!\u0012\u0006\u0003\r\u001e\u000bA\u0001\\1oO*\t\u0001*\u0001\u0003kCZ\f\u0017B\u0001&F\u0005\u001dIe\u000e^3hKJ\f!C\u0019:pW\u0016\u0014\b'\u00138de\u0016lWM\u001c;bYR\tQ\n\u0005\u0002OK:\u0011qJ\u0019\b\u0003!~s!!\u0015/\u000f\u0005ISfBA*Y\u001d\t!v+D\u0001V\u0015\t1V%\u0001\u0004=e>|GOP\u0005\u0002q%\u0011\u0011lN\u0001\u0007CB\f7\r[3\n\u0005\u0011Z&BA-8\u0013\tif,\u0001\u0004d_6lwN\u001c\u0006\u0003ImK!\u0001Y1\u0002\u000f5,7o]1hK*\u0011QLX\u0005\u0003G\u0012\f!%\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:SKF,Xm\u001d;ECR\f'B\u00011b\u0013\t1wM\u0001\u000bBYR,'oQ8oM&<7OU3t_V\u00148-\u001a\u0006\u0003G\u0012\f\u0011\u0003^8qS\u000e\f\u0015J\\2sK6,g\u000e^1m\u00035\u0011'o\\6feBbUmZ1dsR\t1\u000e\u0005\u0002m_:\u0011q*\\\u0005\u0003]\u0012\fq#\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgR$\u0015\r^1\n\u0005\u0019\u0004(B\u00018e\u00031!x\u000e]5d\u00032+w-Y2z\u0003MIgN^1mS\u0012\u0014V-];fgR,%O]8s+\u0005!\bCA;y\u001b\u00051(BA<b\u0003!\u0011X-];fgR\u001c\u0018BA=w\u0005!\t\u0005/[#se>\u0014\u0018\u0001F5om\u0006d\u0017\u000e\u001a*fcV,7\u000f^#se>\u0014\b%A\u0015uKN$8i\u001c9z/&$\bn\\;u!J,\u0007O]8dKN\u001cX\r\u001a$pe&s7M]3nK:$\u0018\r\u001c\u000b\u0002{B\u0011\u0001F`\u0005\u0003\u007f&\u0012A!\u00168ji\"\u001a1\"a\u0001\u0011\t\u0005\u0015\u00111C\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005\u0019\u0011\r]5\u000b\t\u00055\u0011qB\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\tbN\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003+\t9A\u0001\u0003UKN$\u0018\u0001\n;fgR\u001cu\u000e]=XSRDw.\u001e;Qe\u0016\u0004(o\\2fgN,GMR8s\u0019\u0016<\u0017mY=)\u00071\t\u0019!A\u0011uKN$(+Z1tg\u0016l'\r\\3J]\u000e\u0014X-\\3oi\u0006d'+Z:q_:\u001cX\rK\u0002\u000e\u0003\u0007\tA\u0004^3tiJ+\u0017m]:f[\ndW\rT3hC\u000eL(+Z:q_:\u001cX\rK\u0002\u000f\u0003\u0007\tq\u0005^3tiZ\u000bG.\u001b3bi\u0016\u0014Vm]8ve\u000e,g*Y7f\u0013N\u001cUO\u001d:f]Rtu\u000eZ3JI\"\u001aq\"a\u0001\u00021\t\u0014xn[3s\u0019><w-\u001a:2\u0013:\u001c'/Z7f]R\fG.\u0001\rce>\\WM\u001d'pO\u001e,'OM%oGJ,W.\u001a8uC2\fA\b^3tiB\u0013X\r\u001d:pG\u0016\u001c8/\u00138de\u0016lWM\u001c;bY^KG\u000f[+oCV$\bn\u001c:ju\u0016$'I]8lKJdunZ4fe\u000eC\u0017M\\4fg\"\u001a!#a\u0001\u0002EQ,7\u000f\u001e)sKB\u0014xnY3tg&s7M]3nK:$\u0018\r\\,ji\"tU\u000f\u001c7tQ\r\u0019\u00121A\u0001+i\u0016\u001cH\u000f\u0015:faJ|7-Z:t\u0013:\u001c'/Z7f]R\fGnV5uQ2{wmZ3s\u0007\"\fgnZ3tQ\r!\u00121A\u0001(i\u0016\u001cH\u000f\u0015:faJ|7-Z:t\u0013:\u001c'/Z7f]R\fGnV5uQ\u0012+\b\u000f\\5dCR,7\u000fK\u0002\u0016\u0003\u0007\t1C\u0019:pW\u0016\u0014Hj\\4hKJ\fD*Z4bGf\fQB\u0019:pW\u0016\u0014(\u0007T3hC\u000eL\u0018a\u000b;fgR\u0004&/\u001a9s_\u000e,7o\u001d'fO\u0006\u001c\u0017pV5uQ\n\u0013xn[3s\u0019><w-\u001a:DQ\u0006tw-Z:)\u0007a\t\u0019!A\u000fuKN$\bK]3qe>\u001cWm]:MK\u001e\f7-_,ji\"tU\u000f\u001c7tQ\rI\u00121A\u0001#i\u0016\u001cH\u000f\u0015:faJ|7-Z:t\u0019\u0016<\u0017mY=XSRDG)\u001e9mS\u000e\fG/Z:)\u0007i\t\u0019!\u0001\nv].twn\u001e8J]\u000e\u0014X-\\3oi\u0006d\u0017!D;oW:|wO\u001c'fO\u0006\u001c\u00170\u0001\u0017uKN$\bK]3qe>\u001cWm]:J]\u000e\u0014X-\\3oi\u0006dw+\u001b;i+:\\gn\\<o%\u0016\u001cx.\u001e:dK\"\u001aQ$a\u0001\u0002OQ,7\u000f\u001e)sKB\u0014xnY3tg2+w-Y2z/&$\b.\u00168l]><hNU3t_V\u00148-\u001a\u0015\u0004=\u0005\r\u0011A\u0006;fgR\u001cuN\u001c;bS:\u001cH)\u001e9mS\u000e\fG/Z:)\u0007}\t\u0019\u0001")
public class ConfigAdminManagerTest {
    private final Logger logger = LoggerFactory.getLogger(ConfigAdminManagerTest.class);
    private final ApiError invalidRequestError = new ApiError(Errors.INVALID_REQUEST);

    public Logger logger() {
        return this.logger;
    }

    public ConfigAdminManager newConfigAdminManager(Integer brokerId) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(Predef$.MODULE$.Integer2int(brokerId), null, TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        return new ConfigAdminManager(Predef$.MODULE$.Integer2int(brokerId), new KafkaConfig((Map)config), (ConfigRepository)new MockConfigRepository());
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource broker0Incremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource topicAIncremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource broker0Legacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")}).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource topicALegacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")}).iterator()));
    }

    public ApiError invalidRequestError() {
        return this.invalidRequestError;
    }

    @Test
    public void testCopyWithoutPreprocessedForIncremental() {
        IncrementalAlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource topicA = this.topicAIncremental();
        IncrementalAlterConfigsRequestData request = new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{broker0, topicA}).iterator()));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed1 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed1.put(broker0, ApiError.NONE);
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{topicA.duplicate()}).iterator())), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed1));
        IdentityHashMap processed2 = new IdentityHashMap();
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{broker0.duplicate(), topicA.duplicate()}).iterator())), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed2));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed3 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed3.put(broker0, ApiError.NONE);
        processed3.put(topicA, ApiError.NONE);
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed3));
    }

    @Test
    public void testCopyWithoutPreprocessedForLegacy() {
        AlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Legacy();
        AlterConfigsRequestData.AlterConfigsResource topicA = this.topicALegacy();
        AlterConfigsRequestData request = new AlterConfigsRequestData().setValidateOnly(true).setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{broker0, topicA}).iterator()));
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed1 = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed1.put(broker0, ApiError.NONE);
        Assertions.assertEquals((Object)new AlterConfigsRequestData().setValidateOnly(true).setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{topicA.duplicate()}).iterator())), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed1));
        IdentityHashMap processed2 = new IdentityHashMap();
        Assertions.assertEquals((Object)new AlterConfigsRequestData().setValidateOnly(true).setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{broker0.duplicate(), topicA.duplicate()}).iterator())), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed2));
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed3 = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed3.put(broker0, ApiError.NONE);
        processed3.put(topicA, ApiError.NONE);
        Assertions.assertEquals((Object)new AlterConfigsRequestData().setValidateOnly(true), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed3));
    }

    @Test
    public void testReassembleIncrementalResponse() {
        IncrementalAlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource topicA = this.topicAIncremental();
        IncrementalAlterConfigsRequestData original = new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{broker0, topicA}).iterator()));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessed1 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        preprocessed1.put(broker0, this.invalidRequestError());
        IncrementalAlterConfigsResponseData persistentResponses1 = new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)}));
        Assertions.assertEquals((Object)new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage(Errors.INVALID_REQUEST.message()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)})), (Object)ConfigAdminManager$.MODULE$.reassembleIncrementalResponse(original, preprocessed1, persistentResponses1));
        IdentityHashMap preprocessed2 = new IdentityHashMap();
        IncrementalAlterConfigsResponseData persistentResponses2 = new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)}));
        Assertions.assertEquals((Object)new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)})), (Object)ConfigAdminManager$.MODULE$.reassembleIncrementalResponse(original, preprocessed2, persistentResponses2));
    }

    @Test
    public void testReassembleLegacyResponse() {
        AlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Legacy();
        AlterConfigsRequestData.AlterConfigsResource topicA = this.topicALegacy();
        AlterConfigsRequestData original = new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{broker0, topicA}).iterator()));
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessed1 = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        preprocessed1.put(broker0, this.invalidRequestError());
        AlterConfigsResponseData persistentResponses1 = new AlterConfigsResponseData().setResponses(Arrays.asList((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)}));
        Assertions.assertEquals((Object)new AlterConfigsResponseData().setResponses(Arrays.asList((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage(Errors.INVALID_REQUEST.message()), new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)})), (Object)ConfigAdminManager$.MODULE$.reassembleLegacyResponse(original, preprocessed1, persistentResponses1));
        IdentityHashMap preprocessed2 = new IdentityHashMap();
        AlterConfigsResponseData persistentResponses2 = new AlterConfigsResponseData().setResponses(Arrays.asList((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)}));
        Assertions.assertEquals((Object)new AlterConfigsResponseData().setResponses(Arrays.asList((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)})), (Object)ConfigAdminManager$.MODULE$.reassembleLegacyResponse(original, preprocessed2, persistentResponses2));
    }

    @Test
    public void testValidateResourceNameIsCurrentNodeId() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(5));
        manager.validateResourceNameIsCurrentNodeId("5");
        Assertions.assertEquals((Object)"Node id must be an integer, but it is: ", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateResourceNameIsCurrentNodeId("")).getMessage());
        Assertions.assertEquals((Object)"Unexpected broker id, expected 5, but received 3", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateResourceNameIsCurrentNodeId("3")).getMessage());
        Assertions.assertEquals((Object)"Node id must be an integer, but it is: e", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateResourceNameIsCurrentNodeId("e")).getMessage());
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1Incremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue("INFO").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger2Incremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue(null).setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    @Test
    public void testPreprocessIncrementalWithUnauthorizedBrokerLoggerChanges() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1 = this.brokerLogger1Incremental();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger1, new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED, null)), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1}).iterator())), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithUnauthorizedBrokerLoggerChanges$1(x$1, x$2))));
    }

    @Test
    public void testPreprocessIncrementalWithNulls() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(2));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger2 = this.brokerLogger2Incremental();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger2, new ApiError(Errors.INVALID_REQUEST, new StringBuilder(31).append("Null value not supported for : ").append(this.logger().getName()).toString())), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{brokerLogger2}).iterator())), (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithNulls$1(x$3, x$4))));
    }

    @Test
    public void testPreprocessIncrementalWithLoggerChanges() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1 = this.brokerLogger1Incremental();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger1, new ApiError(Errors.NONE, null)), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1}).iterator())), (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithLoggerChanges$1(x$5, x$6))));
    }

    @Test
    public void testPreprocessIncrementalWithDuplicates() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1a = this.brokerLogger1Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1b = this.brokerLogger1Incremental();
        IdentityHashMap output = manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1a, brokerLogger1b}).iterator())), (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithDuplicates$1(x$7, x$8)));
        Assertions.assertEquals((int)2, (int)output.size());
        new .colon.colon((Object)brokerLogger1a, (List)new .colon.colon((Object)brokerLogger1b, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)r -> {
            ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithDuplicates$2(output, r);
            return BoxedUnit.UNIT;
        });
    }

    public AlterConfigsRequestData.AlterConfigsResource brokerLogger1Legacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue("INFO")}).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource broker2Legacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue(null)}).iterator()));
    }

    @Test
    public void testPreprocessLegacyWithBrokerLoggerChanges() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        AlterConfigsRequestData.AlterConfigsResource brokerLogger1 = this.brokerLogger1Legacy();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger1, new ApiError(Errors.INVALID_REQUEST, "Unknown resource type 8")), (Object)manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1}).iterator()))));
    }

    @Test
    public void testPreprocessLegacyWithNulls() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(2));
        AlterConfigsRequestData.AlterConfigsResource brokerLogger2 = this.broker2Legacy();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger2, new ApiError(Errors.INVALID_REQUEST, new StringBuilder(31).append("Null value not supported for : ").append(this.logger().getName()).toString())), (Object)manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{brokerLogger2}).iterator()))));
    }

    @Test
    public void testPreprocessLegacyWithDuplicates() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        AlterConfigsRequestData.AlterConfigsResource brokerLogger1a = this.brokerLogger1Legacy();
        AlterConfigsRequestData.AlterConfigsResource brokerLogger1b = this.brokerLogger1Legacy();
        IdentityHashMap output = manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{brokerLogger1a, brokerLogger1b}).iterator())));
        Assertions.assertEquals((int)2, (int)output.size());
        new .colon.colon((Object)brokerLogger1a, (List)new .colon.colon((Object)brokerLogger1b, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)r -> {
            ConfigAdminManagerTest.$anonfun$testPreprocessLegacyWithDuplicates$1(output, r);
            return BoxedUnit.UNIT;
        });
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource unknownIncremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("unknown").setResourceType(ConfigResource.Type.UNKNOWN.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource unknownLegacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("unknown").setResourceType(ConfigResource.Type.UNKNOWN.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")}).iterator()));
    }

    @Test
    public void testPreprocessIncrementalWithUnknownResource() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource unknown = this.unknownIncremental();
        Assertions.assertEquals(Collections.singletonMap(unknown, new ApiError(Errors.INVALID_REQUEST, "Unknown resource type 0")), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{unknown}).iterator())), (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithUnknownResource$1(x$9, x$10))));
    }

    @Test
    public void testPreprocessLegacyWithUnknownResource() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        AlterConfigsRequestData.AlterConfigsResource unknown = this.unknownLegacy();
        Assertions.assertEquals(Collections.singletonMap(unknown, new ApiError(Errors.INVALID_REQUEST, "Unknown resource type 0")), (Object)manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{unknown}).iterator()))));
    }

    @Test
    public void testContainsDuplicates() {
        Assertions.assertFalse((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)Nil$.MODULE$));
        Assertions.assertFalse((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)));
        Assertions.assertTrue((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"foo", (List)Nil$.MODULE$))));
        Assertions.assertFalse((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)new .colon.colon((Object)"baz", (List)Nil$.MODULE$)))));
        Assertions.assertTrue((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)new .colon.colon((Object)"baz", (List)new .colon.colon((Object)"foo", (List)Nil$.MODULE$))))));
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithUnauthorizedBrokerLoggerChanges$1(ResourceType x$1, String x$2) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithNulls$1(ResourceType x$3, String x$4) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithLoggerChanges$1(ResourceType x$5, String x$6) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithDuplicates$1(ResourceType x$7, String x$8) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$testPreprocessIncrementalWithDuplicates$2(IdentityHashMap output$1, IncrementalAlterConfigsRequestData.AlterConfigsResource r) {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once."), output$1.get(r));
    }

    public static final /* synthetic */ void $anonfun$testPreprocessLegacyWithDuplicates$1(IdentityHashMap output$2, AlterConfigsRequestData.AlterConfigsResource r) {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once."), output$2.get(r));
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithUnknownResource$1(ResourceType x$9, String x$10) {
        return false;
    }
}

