/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.stream.Collectors;
import kafka.server.ControllerServer;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.ALL, brokers=1)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001\u0002\u0005\n\u00019A\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IA\u0006\u0005\u00069\u0001!\t!\b\u0005\u0006C\u0001!\tA\t\u0005\u0006[\u0001!\tA\t\u0005\u0006\u0013\u0002!\tA\t\u0005\u0006\u0019\u0002!\tA\t\u0005\u0006/\u0002!I\u0001\u0017\u0002\"\u0007>t7/^7fe\u001e\u0013x.\u001e9IK\u0006\u0014HOY3biJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u0015-\taa]3sm\u0016\u0014(\"\u0001\u0007\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\u000f\rdWo\u001d;feB\u0011qCG\u0007\u00021)\u0011\u0011dC\u0001\u0005i\u0016\u001cH/\u0003\u0002\u001c1\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003=\u0001\u0002\"a\b\u0001\u000e\u0003%AQ!\u0006\u0002A\u0002Y\t\u0011\u0007^3ti\u000e{gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCRL5/Q2dKN\u001c\u0018N\u00197f/\",g.\u00128bE2,G\rF\u0001$!\t\u0001B%\u0003\u0002&#\t!QK\\5uQ\t\u0019q\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00051J#aC\"mkN$XM\u001d+fgR\fa\t^3ti\u000e{gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCRL5/Q2dKN\u001c\u0018N\u00197f/\",gNT3x\u000fJ|W\u000f]\"p_J$\u0017N\\1u_JL5/\u00128bE2,G\r\u000b\u0004\u0005O=\u0002TGN\u0001\fG2,8\u000f^3s)f\u0004X\rJ\u00012\u0013\t\u00114'A\u0003L%\u00063EK\u0003\u00025S\u0005!A+\u001f9f\u0003A\u0019XM\u001d<feB\u0013x\u000e]3si&,7\u000fL\u00028\u0003\u001a[S\u0001O\u001e=}}\u0002\"\u0001K\u001d\n\u0005iJ#!F\"mkN$XM]\"p]\u001aLw\r\u0015:pa\u0016\u0014H/_\u0001\u0004W\u0016L\u0018%A\u001f\u0002K\u001d\u0014x.\u001e9/G>|'\u000fZ5oCR|'O\f:fE\u0006d\u0017M\\2f]A\u0014x\u000e^8d_2\u001c\u0018!\u0002<bYV,\u0017%\u0001!\u0002!\rd\u0017m]:jG2\u001awN\\:v[\u0016\u00148&\u0002\u001d<\u0005z\"\u0015%A\"\u00029=4gm]3ug:\"x\u000e]5d]9,XN\f9beRLG/[8og\u0006\nQ)A\u00012W\u0015A4h\u0012 EC\u0005A\u0015\u0001I8gMN,Go\u001d\u0018u_BL7M\f:fa2L7-\u0019;j_:tc-Y2u_J\fA\n^3tiJ+'n\\5oS:<7\u000b^1uS\u000elU-\u001c2fe\u001e+Go]!tg&<g.\\3oiN\u0014\u0015mY6XQ\u0016tg*Z<He>,\boQ8pe\u0012Lg.\u0019;pe&\u001bXI\\1cY\u0016$\u0007FB\u0003(_A*4\nL\u00028\u0003\u001a\u000b\u0001\u000b^3tiN#\u0018\r^5d\u001b\u0016l'-\u001a:SK6|g/\u001a3BMR,'oU3tg&|g\u000eV5nK>,H/\u0012=qSJLx\u000b[3o\u001d\u0016<xI]8va\u000e{wN\u001d3j]\u0006$xN]%t\u000b:\f'\r\\3eQ\u00191qe\f\u00196\u001d2*q'\u0011$P).*\u0001h\u000f)?%\u0006\n\u0011+A\u0011he>,\bOL2p]N,X.\u001a:/g\u0016\u001c8/[8o]QLW.Z8vi:j7/I\u0001T\u0003\u0011)\u0004\u0007\r\u0019,\u000baZTK\u0010*\"\u0003Y\u000bQe\u001a:pkBt3m\u001c8tk6,'OL7j]:\u001aXm]:j_:tC/[7f_V$h&\\:\u0002#\r|gN\\3di\u0006sGMU3dK&4X\r\u0006\u0002ZMB\u0011!\fZ\u0007\u00027*\u0011A,X\u0001\te\u0016\fX/Z:ug*\u0011alX\u0001\u0007G>lWn\u001c8\u000b\u00051\u0001'BA1c\u0003\u0019\t\u0007/Y2iK*\t1-A\u0002pe\u001eL!!Z.\u0003=\r{gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCR\u0014Vm\u001d9p]N,\u0007\"B4\b\u0001\u0004A\u0017a\u0002:fcV,7\u000f\u001e\t\u00035&L!A[.\u0003;\r{gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCR\u0014V-];fgRDC\u0001\u00017?mB\u0011Q\u000e^\u0007\u0002]*\u0011q\u000e]\u0001\u0004CBL'BA9s\u0003\u001dQW\u000f]5uKJT!a\u001d2\u0002\u000b),h.\u001b;\n\u0005Ut'a\u0001+bO\u0006\nq/A\u0006j]R,wM]1uS>t\u0007f\u0002\u0001z_q|\u0018\u0011\u0001\t\u0003QiL!a_\u0015\u0003'\rcWo\u001d;feR+7\u000f\u001e#fM\u0006,H\u000e^:%\u0003uL!A`\u001a\u0002\u0007\u0005cE*A\u0004ce>\\WM]:\u001e\u0003\u0005Ac\u0001AA\u0003}\u0005E\u0001\u0003BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-a.A\u0005fqR,gn]5p]&!\u0011qBA\u0005\u0005))\u0005\u0010^3oI^KG\u000f\u001b\u0017\u0003\u0003'\u0019#!!\u0006\u0011\t\u0005]\u00111D\u0007\u0003\u00033Q!a\u001d\r\n\t\u0005u\u0011\u0011\u0004\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8tQ\u0019\u0001\u0011\u0011\u0005 \u0002(A\u0019Q.a\t\n\u0007\u0005\u0015bNA\u0004US6,w.\u001e;\u001f\u0003a\u0004")
public class ConsumerGroupHeartbeatRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest
    public void testConsumerGroupHeartbeatIsAccessibleWhenEnabled() {
        ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData()).build();
        ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse = this.connectAndReceive(consumerGroupHeartbeatRequest);
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.UNSUPPORTED_VERSION.code()), (Object)consumerGroupHeartbeatResponse.data());
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.KRAFT, serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled() {
        RaftClusterInvocationContext.RaftClusterInstance raftCluster = (RaftClusterInvocationContext.RaftClusterInstance)this.cluster;
        Admin admin = this.cluster.createAdminClient();
        TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(raftCluster.brokers().collect(Collectors.toList())).asScala(), (Seq<ControllerServer>)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(raftCluster.controllerServers()).asScala()).toSeq());
        ObjectRef consumerGroupHeartbeatRequest = ObjectRef.create((Object)((ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava())).build()));
        ObjectRef consumerGroupHeartbeatResponse = ObjectRef.create(null);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$1(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$2(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotNull((Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId());
        Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        Uuid topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, TestUtils$.MODULE$.createTopicWithAdminRaw$default$4(), TestUtils$.MODULE$.createTopicWithAdminRaw$default$5(), TestUtils$.MODULE$.createTopicWithAdminRaw$default$6());
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId()).setMemberEpoch(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch())).build();
        ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
        consumerGroupHeartbeatResponse.elem = null;
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$3(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest, expectedAssignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$4(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)2, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)expectedAssignment, (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId()).setMemberEpoch(-1)).build();
        consumerGroupHeartbeatResponse.elem = this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest.elem);
        Assertions.assertEquals((int)-1, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.KRAFT, serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled() {
        RaftClusterInvocationContext.RaftClusterInstance raftCluster = (RaftClusterInvocationContext.RaftClusterInstance)this.cluster;
        Admin admin = this.cluster.createAdminClient();
        String instanceId = "instanceId";
        TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(raftCluster.brokers().collect(Collectors.toList())).asScala(), (Seq<ControllerServer>)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(raftCluster.controllerServers()).asScala()).toSeq());
        ObjectRef consumerGroupHeartbeatRequest = ObjectRef.create((Object)((ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava())).build()));
        ObjectRef consumerGroupHeartbeatResponse = ObjectRef.create(null);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$1(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$2(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotNull((Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId());
        Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        Uuid topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, TestUtils$.MODULE$.createTopicWithAdminRaw$default$4(), TestUtils$.MODULE$.createTopicWithAdminRaw$default$5(), TestUtils$.MODULE$.createTopicWithAdminRaw$default$6());
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberId(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId()).setMemberEpoch(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch())).build();
        ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
        consumerGroupHeartbeatResponse.elem = null;
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$3(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest, expectedAssignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$4(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotNull((Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId());
        Assertions.assertEquals((int)2, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)expectedAssignment, (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        String oldMemberId = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId();
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberId(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId()).setMemberEpoch(-2)).build();
        consumerGroupHeartbeatResponse.elem = this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest.elem);
        Assertions.assertEquals((int)-2, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava())).build();
        consumerGroupHeartbeatResponse.elem = this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest.elem);
        Assertions.assertNotNull((Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId());
        Assertions.assertEquals((int)2, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)expectedAssignment, (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        Assertions.assertNotEquals((Object)oldMemberId, (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId());
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.KRAFT, serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.consumer.session.timeout.ms", value="5000"), @ClusterConfigProperty(key="group.consumer.min.session.timeout.ms", value="5000")})
    public void testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled() {
        RaftClusterInvocationContext.RaftClusterInstance raftCluster = (RaftClusterInvocationContext.RaftClusterInstance)this.cluster;
        Admin admin = this.cluster.createAdminClient();
        String instanceId = "instanceId";
        TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(raftCluster.brokers().collect(Collectors.toList())).asScala(), (Seq<ControllerServer>)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(raftCluster.controllerServers()).asScala()).toSeq());
        ObjectRef consumerGroupHeartbeatRequest = ObjectRef.create((Object)((ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava())).build()));
        ObjectRef consumerGroupHeartbeatResponse = ObjectRef.create(null);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$1(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$2(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotNull((Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId());
        Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        Uuid topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, TestUtils$.MODULE$.createTopicWithAdminRaw$default$4(), TestUtils$.MODULE$.createTopicWithAdminRaw$default$5(), TestUtils$.MODULE$.createTopicWithAdminRaw$default$6());
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberId(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId()).setMemberEpoch(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch())).build();
        ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
        consumerGroupHeartbeatResponse.elem = null;
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$3(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest, expectedAssignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$4(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)2, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)expectedAssignment, (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava())).build();
        consumerGroupHeartbeatResponse.elem = this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest.elem);
        Assertions.assertEquals((short)Errors.UNRELEASED_INSTANCE_ID.code(), (short)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().errorCode());
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$5(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest, expectedAssignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$6(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)4, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)expectedAssignment, (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
    }

    private ConsumerGroupHeartbeatResponse connectAndReceive(ConsumerGroupHeartbeatRequest request) {
        return (ConsumerGroupHeartbeatResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$1, ObjectRef consumerGroupHeartbeatRequest$1) {
        consumerGroupHeartbeatResponse$1.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$1.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$2(ObjectRef consumerGroupHeartbeatResponse$1) {
        return new StringBuilder(54).append("Could not join the group successfully. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$1, ObjectRef consumerGroupHeartbeatRequest$1, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$1) {
        consumerGroupHeartbeatResponse$1.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$1.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$1) : expectedAssignment$1 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$4(ObjectRef consumerGroupHeartbeatResponse$1) {
        return new StringBuilder(50).append("Could not get partitions assigned. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$2, ObjectRef consumerGroupHeartbeatRequest$2) {
        consumerGroupHeartbeatResponse$2.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$2.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$2(ObjectRef consumerGroupHeartbeatResponse$2) {
        return new StringBuilder(68).append("Static member could not join the group successfully. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$2, ObjectRef consumerGroupHeartbeatRequest$2, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$2) {
        consumerGroupHeartbeatResponse$2.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$2.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$2) : expectedAssignment$2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$4(ObjectRef consumerGroupHeartbeatResponse$2) {
        return new StringBuilder(64).append("Static member could not get partitions assigned. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$3, ObjectRef consumerGroupHeartbeatRequest$3) {
        consumerGroupHeartbeatResponse$3.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$3.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$2(ObjectRef consumerGroupHeartbeatResponse$3) {
        return new StringBuilder(54).append("Could not join the group successfully. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$3, ObjectRef consumerGroupHeartbeatRequest$3, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$3) {
        consumerGroupHeartbeatResponse$3.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$3.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$3) : expectedAssignment$3 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$4(ObjectRef consumerGroupHeartbeatResponse$3) {
        return new StringBuilder(50).append("Could not get partitions assigned. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$5(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$3, ObjectRef consumerGroupHeartbeatRequest$3, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$3) {
        consumerGroupHeartbeatResponse$3.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$3.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$3) : expectedAssignment$3 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$6(ObjectRef consumerGroupHeartbeatResponse$3) {
        return new StringBuilder(57).append("Could not re-join the group successfully. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).append(".").toString();
    }

    public ConsumerGroupHeartbeatRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

