/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZkVersion$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/!)!\u0007\u0001C\u0001g!)\u0001\u000b\u0001C\u0001g\t12i\u001c8ue>dG.\u001a:JI6+GO]5d)\u0016\u001cHO\u0003\u0002\b\u0011\u000511/\u001a:wKJT\u0011!C\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\u0011\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\t\tbB\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tA\u0003\u0005\u0002\u0016\u00015\ta!A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005A\u0002cA\r$M9\u0011!\u0004\t\b\u00037yi\u0011\u0001\b\u0006\u0003;)\ta\u0001\u0010:p_Rt\u0014\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005\u0012\u0013a\u00029bG.\fw-\u001a\u0006\u0002?%\u0011A%\n\u0002\u0004'\u0016\f(BA\u0011#!\t)r%\u0003\u0002)\r\tY1*\u00194lC\u000e{gNZ5hQ\t\u0011!\u0006\u0005\u0002,a5\tAF\u0003\u0002.]\u0005!A.\u00198h\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0017\u0003\u0011=3XM\u001d:jI\u0016\f!\u0003^3tij[7i\u001c8ue>dG.\u001a:JIR\tA\u0007\u0005\u00026m5\t!%\u0003\u00028E\t!QK\\5uQ\u0011\u0019\u0011h\u0012%\u0011\u0005i*U\"A\u001e\u000b\u0005qj\u0014\u0001\u00039s_ZLG-\u001a:\u000b\u0005yz\u0014A\u00029be\u0006l7O\u0003\u0002A\u0003\u00069!.\u001e9ji\u0016\u0014(B\u0001\"D\u0003\u0015QWO\\5u\u0015\u0005!\u0015aA8sO&\u0011ai\u000f\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0003%\u000b\u0013AS\u0001\u0003u.D#a\u0001'\u0011\u00055sU\"A\u001f\n\u0005=k$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!C/Z:u5.\u001cuN\u001c;s_2dWM]%e/\",gN\u00178pI\u0016L5\u000fR3mKR,G\r\u000b\u0003\u0005s\u001d\u0013F&A%)\u0005\u0011a\u0005")
public class ControllerIdMetricTest
extends KafkaServerTestHarness {
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return ((SeqLike)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).map((Function1 & java.io.Serializable & Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1), Seq$.MODULE$.canBuildFrom())).toSeq();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testZkControllerId() {
        KafkaServer server = (KafkaServer)this.servers().head();
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 30000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ControllerIdMetricTest.$anonfun$testZkControllerId$1(server);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testZkControllerIdWhenZnodeIsDeleted() {
        KafkaServer server = (KafkaServer)this.servers().head();
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 30000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ControllerIdMetricTest.$anonfun$testZkControllerIdWhenZnodeIsDeleted$1(this, server);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testZkControllerId$1(KafkaServer server$1) {
        Assertions.assertEquals((int)server$1.config().brokerId(), (int)server$1.getCurrentControllerIdFromOldController());
    }

    public static final /* synthetic */ void $anonfun$testZkControllerIdWhenZnodeIsDeleted$1(ControllerIdMetricTest $this, KafkaServer server$2) {
        $this.zkClient().deleteController(ZkVersion$.MODULE$.MatchAnyVersion());
        Assertions.assertEquals((int)-1, (int)server$2.getCurrentControllerIdFromOldController());
    }
}

