/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.RenewDelegationTokenResult;
import org.apache.kafka.common.errors.DelegationTokenNotFoundException;
import org.apache.kafka.common.errors.InvalidPrincipalTypeException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.utils.SecurityUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\n\u0015\u0001eAQa\t\u0001\u0005\u0002\u0011BQa\n\u0001\u0005R!Bq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004C\u0001\u0001\u0006IA\u000f\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003E\u0011\u0019y\u0005\u0001)A\u0005\u000b\"9\u0001\u000b\u0001b\u0001\n#\n\u0006B\u0002/\u0001A\u0003%!\u000bC\u0004^\u0001\t\u0007I\u0011K)\t\ry\u0003\u0001\u0015!\u0003S\u0011%y\u0006\u00011AA\u0002\u0013\u0005\u0001\rC\u0005j\u0001\u0001\u0007\t\u0019!C\u0001U\"I\u0001\u000f\u0001a\u0001\u0002\u0003\u0006K!\u0019\u0005\u0006c\u0002!\tE\u001d\u0005\u0006m\u0002!\te\u001e\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAq!!\u001b\u0001\t\u0003\nYGA\u000eEK2,w-\u0019;j_:$vn[3o%\u0016\fX/Z:ugR+7\u000f\u001e\u0006\u0003+Y\taa]3sm\u0016\u0014(\"A\f\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0005u1\u0012aA1qS&\u0011q\u0004\b\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tgB\u00111$I\u0005\u0003Eq\u0011\u0011bU1tYN+G/\u001e9\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u0005!\u0012\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m+\u0005I\u0003C\u0001\u00167\u001b\u0005Y#B\u0001\u0017.\u0003\u0011\tW\u000f\u001e5\u000b\u00059z\u0013\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005A\n\u0014AB2p[6|gN\u0003\u0002\u0018e)\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0013\t94F\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\u0006A2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7\u0016\u0003i\u0002\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\t1\fgn\u001a\u0006\u0002\u007f\u0005!!.\u0019<b\u0013\t\tEH\u0001\u0004TiJLgnZ\u0001\u001aW\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNl\u0007%A\rlC\u001a\\\u0017mU3sm\u0016\u00148+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u001cX#A#\u0011\u0007\u0019k%(D\u0001H\u0015\tA\u0015*A\u0005j[6,H/\u00192mK*\u0011!jS\u0001\u000bG>dG.Z2uS>t'\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059;%\u0001\u0002'jgR\f!d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ng\u0002\nAc]3sm\u0016\u00148+Y:m!J|\u0007/\u001a:uS\u0016\u001cX#\u0001*\u0011\u0007M#f+D\u0001L\u0013\t)6J\u0001\u0003T_6,\u0007CA,[\u001b\u0005A&BA-?\u0003\u0011)H/\u001b7\n\u0005mC&A\u0003)s_B,'\u000f^5fg\u0006)2/\u001a:wKJ\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN\u0004\u0013\u0001F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7/A\u000bdY&,g\u000e^*bg2\u0004&o\u001c9feRLWm\u001d\u0011\u0002\u0017\u0005$W.\u001b8DY&,g\u000e^\u000b\u0002CB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003MF\nqa\u00197jK:$8/\u0003\u0002iG\n)\u0011\tZ7j]\u0006y\u0011\rZ7j]\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002l]B\u00111\u000b\\\u0005\u0003[.\u0013A!\u00168ji\"9q\u000eDA\u0001\u0002\u0004\t\u0017a\u0001=%c\u0005a\u0011\rZ7j]\u000ec\u0017.\u001a8uA\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005\u0019\bCA*u\u0013\t)8JA\u0002J]R\fQa]3u+B$\"a\u001b=\t\u000be|\u0001\u0019\u0001>\u0002\u0011Q,7\u000f^%oM>\u00042a_A\u0002\u001b\u0005a(BA\u000f~\u0015\tqx0A\u0004kkBLG/\u001a:\u000b\u0007\u0005\u0005A'A\u0003kk:LG/C\u0002\u0002\u0006q\u0014\u0001\u0002V3ti&sgm\u001c\u0015\u0004\u001f\u0005%\u0001cA>\u0002\f%\u0019\u0011Q\u0002?\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\tde\u0016\fG/Z!e[&t7i\u001c8gS\u001e,\"!a\u0005\u0011\u000f]\u000b)\"!\u0007\u0002.%\u0019\u0011q\u0003-\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u001c\u0005%b\u0002BA\u000f\u0003K\u00012!a\bL\u001b\t\t\tCC\u0002\u0002$a\ta\u0001\u0010:p_Rt\u0014bAA\u0014\u0017\u00061\u0001K]3eK\u001aL1!QA\u0016\u0015\r\t9c\u0013\t\u0004w\u0005=\u0012bAA\u0019y\t1qJ\u00196fGR\f1\u0004^3ti\u0012+G.Z4bi&|g\u000eV8lK:\u0014V-];fgR\u001cHcA6\u00028!9\u0011\u0011H\tA\u0002\u0005e\u0011AB9v_J,X\u000eK\u0004\u0012\u0003{\ti%a\u0014\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005A\u0001O]8wS\u0012,'OC\u0002\u0002Hu\fa\u0001]1sC6\u001c\u0018\u0002BA&\u0003\u0003\u00121BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH\u0006BA)\u0003+\n#!a\u0015\u0002\u000b-\u0014\u0018M\u001a;\"\u0005\u0005]\u0013A\u0001>lQ\u001d\t\u00121LA2\u0003K\u0002B!!\u0018\u0002`5\u0011\u0011QI\u0005\u0005\u0003C\n)EA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u0011qM\u0001#w\u0012L7\u000f\u001d7bs:\u000bW.Z?/w\u0006\u0014x-^7f]R\u001cx+\u001b;i\u001d\u0006lWm]?\u0002\u0011Q,\u0017M\u001d#po:$\u0012a\u001b\u0015\u0004%\u0005=\u0004cA>\u0002r%\u0019\u00111\u000f?\u0003\u0013\u00053G/\u001a:FC\u000eD\u0007")
public class DelegationTokenRequestsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private Admin adminClient;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasAdminLoginModule$default$2() {
        return SaslSetup.jaasAdminLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    public Admin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp(testInfo);
    }

    private Map<String, Object> createAdminConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), (Option<Properties>)this.clientSaslProperties()).forEach((key, value) -> config.put((String)key, value));
        return config;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testDelegationTokenRequests(String quorum) {
        this.adminClient_$eq(Admin.create(this.createAdminConfig()));
        java.util.List renewer1 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)SecurityUtils.parseKafkaPrincipal((String)"User:renewer1"), (List)Nil$.MODULE$)).asJava();
        DelegationToken tokenCreated = (DelegationToken)this.adminClient().createDelegationToken(new CreateDelegationTokenOptions().renewers(renewer1)).delegationToken().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List tokens = (java.util.List)this.adminClient().describeDelegationToken().delegationTokens().get();
        Assertions.assertEquals((int)1, (int)tokens.size());
        DelegationToken token1 = (DelegationToken)tokens.get(0);
        Assertions.assertEquals((Object)token1, (Object)tokenCreated);
        java.util.List renewer2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)SecurityUtils.parseKafkaPrincipal((String)"User:renewer2"), (List)Nil$.MODULE$)).asJava();
        DelegationToken token2 = (DelegationToken)this.adminClient().createDelegationToken(new CreateDelegationTokenOptions().renewers(renewer2)).delegationToken().get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$4(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        tokens = (java.util.List)this.adminClient().describeDelegationToken().delegationTokens().get();
        Assertions.assertTrue((tokens.size() == 2 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DelegationToken[]{token1, token2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(tokens).asScala()).toSet());
        tokens = (java.util.List)this.adminClient().describeDelegationToken(new DescribeDelegationTokenOptions().owners(renewer2)).delegationTokens().get();
        Assertions.assertTrue((tokens.size() == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DelegationToken[]{token2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(tokens).asScala()).toSet());
        Long expiryTimestamp = (Long)this.adminClient().renewDelegationToken(token1.hmac()).expiryTimestamp().get();
        java.util.List renewer3 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)SecurityUtils.parseKafkaPrincipal((String)"User:renewer3"), (List)Nil$.MODULE$)).asJava();
        DelegationToken token3 = (DelegationToken)this.adminClient().createDelegationToken(new CreateDelegationTokenOptions().renewers(renewer3)).delegationToken().get();
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$7(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        DescribeDelegationTokenResult describeResult = this.adminClient().describeDelegationToken();
        String tokenId = token1.tokenInfo().tokenId();
        token1 = (DelegationToken)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)describeResult.delegationTokens().get()).asScala()).filter((Function1 & Serializable & scala.Serializable)dt -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$10(tokenId, dt)))).head();
        Assertions.assertEquals((Long)expiryTimestamp, (long)token1.tokenInfo().expiryTimestamp());
        Long cfr_ignored_0 = (Long)this.adminClient().expireDelegationToken(token1.hmac()).expiryTimestamp().get();
        expiryTimestamp = null;
        Long cfr_ignored_1 = (Long)this.adminClient().expireDelegationToken(token2.hmac()).expiryTimestamp().get();
        expiryTimestamp = null;
        Long cfr_ignored_2 = (Long)this.adminClient().expireDelegationToken(token3.hmac()).expiryTimestamp().get();
        expiryTimestamp = null;
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$11(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$13());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        tokens = (java.util.List)this.adminClient().describeDelegationToken().delegationTokens().get();
        Assertions.assertTrue((tokens.size() == 0 ? 1 : 0) != 0);
        java.util.List renewer4 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)SecurityUtils.parseKafkaPrincipal((String)"Group:Renewer4"), (List)Nil$.MODULE$)).asJava();
        CreateDelegationTokenResult createResult4 = this.adminClient().createDelegationToken(new CreateDelegationTokenOptions().renewers(renewer4));
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> createResult4.delegationToken().get())).getCause() instanceof InvalidPrincipalTypeException));
        RenewDelegationTokenResult renewResultPostDelete = this.adminClient().renewDelegationToken(token1.hmac());
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> renewResultPostDelete.expiryTimestamp().get())).getCause() instanceof DelegationTokenNotFoundException));
        DelegationToken token5 = (DelegationToken)this.adminClient().createDelegationToken(new CreateDelegationTokenOptions().renewers(renewer1).maxlifeTimeMs(60000L)).delegationToken().get();
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$16(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$18());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Thread.sleep(120000L);
        tokens = (java.util.List)this.adminClient().describeDelegationToken().delegationTokens().get();
        Assertions.assertTrue((tokens.size() == 0 ? 1 : 0) != 0);
        ExpireDelegationTokenResult expireResultPostDelete = this.adminClient().expireDelegationToken(token5.hmac());
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> expireResultPostDelete.expiryTimestamp().get())).getCause() instanceof DelegationTokenNotFoundException));
        java.util.List unknownOwner = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)SecurityUtils.parseKafkaPrincipal((String)"User:Unknown"), (List)Nil$.MODULE$)).asJava();
        tokens = (java.util.List)this.adminClient().describeDelegationToken(new DescribeDelegationTokenOptions().owners(unknownOwner)).delegationTokens().get();
        Assertions.assertTrue((boolean)tokens.isEmpty());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.adminClient() != null) {
            this.adminClient().close();
        }
        super.tearDown();
        this.closeSasl();
    }

    public static final /* synthetic */ boolean $anonfun$testDelegationTokenRequests$2(KafkaBroker server) {
        return server.tokenCache().tokens().size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testDelegationTokenRequests$1(DelegationTokenRequestsTest $this) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$2(server)));
    }

    public static final /* synthetic */ String $anonfun$testDelegationTokenRequests$3() {
        return "Timed out waiting for token to propagate to all servers";
    }

    public static final /* synthetic */ boolean $anonfun$testDelegationTokenRequests$5(KafkaBroker server) {
        return server.tokenCache().tokens().size() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testDelegationTokenRequests$4(DelegationTokenRequestsTest $this) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$5(server)));
    }

    public static final /* synthetic */ String $anonfun$testDelegationTokenRequests$6() {
        return "Timed out waiting for token to propagate to all servers";
    }

    public static final /* synthetic */ boolean $anonfun$testDelegationTokenRequests$8(KafkaBroker server) {
        return server.tokenCache().tokens().size() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testDelegationTokenRequests$7(DelegationTokenRequestsTest $this) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$8(server)));
    }

    public static final /* synthetic */ String $anonfun$testDelegationTokenRequests$9() {
        return "Timed out waiting for token to propagate to all servers";
    }

    public static final /* synthetic */ boolean $anonfun$testDelegationTokenRequests$10(String tokenId$1, DelegationToken dt) {
        String string = dt.tokenInfo().tokenId();
        return !(string != null ? !string.equals(tokenId$1) : tokenId$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDelegationTokenRequests$12(KafkaBroker server) {
        return server.tokenCache().tokens().size() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDelegationTokenRequests$11(DelegationTokenRequestsTest $this) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$12(server)));
    }

    public static final /* synthetic */ String $anonfun$testDelegationTokenRequests$13() {
        return "Timed out waiting for token to propagate to all servers";
    }

    public static final /* synthetic */ boolean $anonfun$testDelegationTokenRequests$17(KafkaBroker server) {
        return server.tokenCache().tokens().size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testDelegationTokenRequests$16(DelegationTokenRequestsTest $this) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenRequestsTest.$anonfun$testDelegationTokenRequests$17(server)));
    }

    public static final /* synthetic */ String $anonfun$testDelegationTokenRequests$18() {
        return "Timed out waiting for token to propagate to all servers";
    }

    public DelegationTokenRequestsTest() {
        SaslSetup.$init$(this);
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)"PLAIN", (List)Nil$.MODULE$);
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DelegationTokenSecretKeyProp(), "testKey");
        this.controllerConfig().setProperty(KafkaConfig$.MODULE$.DelegationTokenSecretKeyProp(), "testKey");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DelegationTokenExpiryCheckIntervalMsProp(), "60000");
        this.controllerConfig().setProperty(KafkaConfig$.MODULE$.DelegationTokenExpiryCheckIntervalMsProp(), "60000");
    }
}

