/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestInfoUtils$;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Predef;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001\u0002\u0006\f\u0001AAQ!\u0006\u0001\u0005\u0002YAQ\u0001\u0007\u0001\u0005BeAQA\r\u0001\u0005\u0002MBQ\u0001\u0017\u0001\u0005\u0002eCQA\u0018\u0001\u0005\u0002}CQ\u0001\u001a\u0001\u0005\u0002\u0015DQA\u001b\u0001\u0005\u0002-DQ\u0001\u001d\u0001\u0005\nED\u0011\"!\u0006\u0001#\u0003%I!a\u0006\u0003O\u0011+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u00195\taa]3sm\u0016\u0014(\"\u0001\b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Mi\u0011aC\u0005\u0003)-\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"A\u0005\u0001\u0002\u000bM,G/\u00169\u0015\u0005i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"\u0001B+oSRDQ!\t\u0002A\u0002\t\n\u0001\u0002^3ti&sgm\u001c\t\u0003G1j\u0011\u0001\n\u0006\u0003K\u0019\n1!\u00199j\u0015\t9\u0003&A\u0004kkBLG/\u001a:\u000b\u0005%R\u0013!\u00026v]&$(\"A\u0016\u0002\u0007=\u0014x-\u0003\u0002.I\tAA+Z:u\u0013:4w\u000e\u000b\u0002\u0003_A\u00111\u0005M\u0005\u0003c\u0011\u0012!BQ3g_J,W)Y2i\u0003M!Xm\u001d;EKN\u001c'/\u001b2f\u001d>$\b.\u001b8h)\tQB\u0007C\u00036\u0007\u0001\u0007a'\u0001\u0004rk>\u0014X/\u001c\t\u0003oyr!\u0001\u000f\u001f\u0011\u0005ebR\"\u0001\u001e\u000b\u0005mz\u0011A\u0002\u001fs_>$h(\u0003\u0002>9\u00051\u0001K]3eK\u001aL!a\u0010!\u0003\rM#(/\u001b8h\u0015\tiD\u0004\u000b\u0003\u0004\u0005*[\u0005CA\"I\u001b\u0005!%BA#G\u0003!\u0001(o\u001c<jI\u0016\u0014(BA$'\u0003\u0019\u0001\u0018M]1ng&\u0011\u0011\n\u0012\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u00051s\u0015%A'\u0002\u000b-\u0014\u0018M\u001a;\"\u0003=\u000b!A_6)\t\r\tVK\u0016\t\u0003%Nk\u0011AR\u0005\u0003)\u001a\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003]\u000b!e\u001f3jgBd\u0017-\u001f(b[\u0016lhf_1sOVlWM\u001c;t/&$\bNT1nKNl\u0018\u0001\u0006;fgR$Um]2sS\n,w+\u001b;i\u001dVdG\u000e\u0006\u0002\u001b5\")Q\u0007\u0002a\u0001m!\"AA\u0011&]Y\tae\n\u000b\u0003\u0005#V3\u0016!\u0007;fgR$Um]2sS\n,gj\u001c;D_:$(o\u001c7mKJ$\u0012A\u0007\u0015\u0003\u000b\u0005\u0004\"a\t2\n\u0005\r$#\u0001\u0002+fgR\f\u0011\u0004^3ti\u0012+7o\u0019:jE\u0016\u001c\u0016-\\3Vg\u0016\u0014Hk^5dKR\u0011!D\u001a\u0005\u0006k\u0019\u0001\rA\u000e\u0015\u0005\r\tS\u0005\u000e\f\u0002M\u001d\"\"a!U+W\u0003=!Xm\u001d;V].twn\u001e8Vg\u0016\u0014HC\u0001\u000em\u0011\u0015)t\u00011\u00017Q\u00119!I\u00138-\u00051s\u0005\u0006B\u0004R+Z\u000bqe]3oI\u0012+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR!!/`A\u0003!\t\u001980D\u0001u\u0015\t)h/\u0001\u0005sKF,Xm\u001d;t\u0015\t9\b0\u0001\u0004d_6lwN\u001c\u0006\u0003\u001deT!A\u001f\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0013\taHO\u0001\u0013EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKN\u0004xN\\:f\u0011\u0015q\b\u00021\u0001\u0000\u0003\u001d\u0011X-];fgR\u00042a]A\u0001\u0013\r\t\u0019\u0001\u001e\u0002$\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:u\u0011%\t9\u0001\u0003I\u0001\u0002\u0004\tI!\u0001\u0007t_\u000e\\W\r^*feZ,'\u000f\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty!D\u0001\b]\u0016$xo\u001c:l\u0013\u0011\t\u0019\"!\u0004\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\u0002cM,g\u000e\u001a#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0004\u0016\u0005\u0003\u0013\tYb\u000b\u0002\u0002\u001eA!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012!C;oG\",7m[3e\u0015\r\t9\u0003H\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0016\u0003C\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class DescribeUserScramCredentialsRequestTest
extends BaseRequestTest {
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), StandardAuthorizer.class.getName());
        } else {
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AlterCredentialsTest.TestAuthorizer.class.getName());
        }
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        super.setUp(testInfo);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testDescribeNothing(String quorum) {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.sendDescribeUserScramCredentialsRequest$default$2());
        short error = response.data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Expected no error when describing everything and there are no credentials");
        Assertions.assertEquals((int)0, (int)response.data().results().size(), (String)"Expected no credentials when describing everything and there are no credentials");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testDescribeWithNull(String quorum) {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(null)).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.sendDescribeUserScramCredentialsRequest$default$2());
        short error = response.data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Expected no error when describing everything and there are no credentials");
        Assertions.assertEquals((int)0, (int)response.data().results().size(), (String)"Expected no credentials when describing everything and there are no credentials");
    }

    @Test
    public void testDescribeNotController() {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build();
        short error = this.sendDescribeUserScramCredentialsRequest(request, this.notControllerSocketServer()).data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Did not expect controller error when routed to non-controller");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testDescribeSameUserTwice(String quorum) {
        String user = "user1";
        DescribeUserScramCredentialsRequestData.UserName userName = new DescribeUserScramCredentialsRequestData.UserName().setName(user);
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)userName, (List)new .colon.colon((Object)userName, (List)Nil$.MODULE$))).asJava())).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.sendDescribeUserScramCredentialsRequest$default$2());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode(), (String)"Expected no top-level error");
        Assertions.assertEquals((int)1, (int)response.data().results().size());
        DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result = (DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult)response.data().results().get(0);
        Assertions.assertEquals((short)Errors.DUPLICATE_RESOURCE.code(), (short)result.errorCode(), (String)new StringBuilder(38).append("Expected duplicate resource error for ").append(user).toString());
        Assertions.assertEquals((Object)new StringBuilder(79).append("Cannot describe SCRAM credentials for the same user twice in a single request: ").append(user).toString(), (Object)result.errorMessage());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft", "zk"})
    public void testUnknownUser(String quorum) {
        String unknownUser = "unknownUser";
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new DescribeUserScramCredentialsRequestData.UserName().setName(unknownUser), (List)Nil$.MODULE$)).asJava())).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.sendDescribeUserScramCredentialsRequest$default$2());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode(), (String)"Expected no top-level error");
        Assertions.assertEquals((int)1, (int)response.data().results().size());
        DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result = (DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult)response.data().results().get(0);
        Assertions.assertEquals((short)Errors.RESOURCE_NOT_FOUND.code(), (short)result.errorCode(), (String)new StringBuilder(38).append("Expected duplicate resource error for ").append(unknownUser).toString());
        Assertions.assertEquals((Object)new StringBuilder(59).append("Attempt to describe a user credential that does not exist: ").append(unknownUser).toString(), (Object)result.errorMessage());
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }
}

