/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.network.ConnectionQuotas;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.ZkConfigManager;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@Timeout(value=100L)
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001\u0002\f\u0018\u0001qAQa\t\u0001\u0005\u0002\u0011BQa\n\u0001\u0005\u0002!BQA\u000e\u0001\u0005\u0002]BQA\u001a\u0001\u0005\u0002\u001dDQ\u0001\u001c\u0001\u0005\u00025DQA\u001d\u0001\u0005\nMDq!a\u0007\u0001\t\u0003\ti\u0002C\u0004\u0002(\u0001!\t!!\u000b\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003KBq!a\u001c\u0001\t\u0003\t\t\bC\u0004\u0002|\u0001!\t!! \t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\"9\u00111\u0013\u0001\u0005\u0002\u0005U\u0005bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003W\u0003A\u0011AAW\u0011\u001d\t9\f\u0001C\u0001\u0003sCq!a1\u0001\t\u0013\t)MA\fEs:\fW.[2D_:4\u0017nZ\"iC:<W\rV3ti*\u0011\u0001$G\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003i\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\u0011\u0001%G\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002#?\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011a\u0005A\u0007\u0002/\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001*!\rQ\u0013gM\u0007\u0002W)\u0011A&L\u0001\nS6lW\u000f^1cY\u0016T!AL\u0018\u0002\u0015\r|G\u000e\\3di&|gNC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u00114F\u0001\u0003MSN$\bC\u0001\u00145\u0013\t)tCA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u0005;fgR\u001cuN\u001c4jO\u000eC\u0017M\\4f)\tAD\b\u0005\u0002:u5\tq&\u0003\u0002<_\t!QK\\5u\u0011\u0015i4\u00011\u0001?\u0003\u0019\tXo\u001c:v[B\u0011qH\u0012\b\u0003\u0001\u0012\u0003\"!Q\u0018\u000e\u0003\tS!aQ\u000e\u0002\rq\u0012xn\u001c;?\u0013\t)u&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000f\"\u0013aa\u0015;sS:<'BA#0Q\u0011\u0019!\nW-\u0011\u0005-3V\"\u0001'\u000b\u00055s\u0015\u0001\u00039s_ZLG-\u001a:\u000b\u0005=\u0003\u0016A\u00029be\u0006l7O\u0003\u0002R%\u00069!.\u001e9ji\u0016\u0014(BA*U\u0003\u0015QWO\\5u\u0015\u0005)\u0016aA8sO&\u0011q\u000b\u0014\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0005ic\u0016%A.\u0002\u0005i\\\u0017%A/\u0002\u000b-\u0014\u0018M\u001a;)\t\ry6\r\u001a\t\u0003A\u0006l\u0011AT\u0005\u0003E:\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003\u0015\f!e\u001f3jgBd\u0017-\u001f(b[\u0016lhf_1sOVlWM\u001c;t/&$\bNT1nKNl\u0018\u0001\b;fgR$\u0015P\\1nS\u000e$v\u000e]5d\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0003q!DQ!\u0010\u0003A\u0002yBC\u0001\u0002&YU2\u0012!\f\u0018\u0015\u0005\t}\u001bG-\u0001\u0010uKN$X*Z:tC\u001e,gi\u001c:nCR4VM]:j_:\u001c\u0005.\u00198hKR\u0011\u0001H\u001c\u0005\u0006{\u0015\u0001\rA\u0010\u0015\u0005\u000b)C\u0006\u000fL\u0001[Q\u0011)ql\u00193\u0002+Q,7\u000f^)v_R\f7i\u001c8gS\u001e\u001c\u0005.\u00198hKR1\u0001\b^A\u0002\u0003/AQ!\u001e\u0004A\u0002Y\fa!\u001a8uSRL\bCA<\u0000\u001b\u0005A(BA={\u0003\u0015\tXo\u001c;b\u0015\tYH0\u0001\u0004d_6lwN\u001c\u0006\u00035uT!A +\u0002\r\u0005\u0004\u0018m\u00195f\u0013\r\t\t\u0001\u001f\u0002\u0012\u00072LWM\u001c;Rk>$\u0018-\u00128uSRL\bbBA\u0003\r\u0001\u0007\u0011qA\u0001\u0005kN,'\u000f\u0005\u0003\u0002\n\u0005MQBAA\u0006\u0015\u0011\ti!a\u0004\u0002\t\u0005,H\u000f\u001b\u0006\u0004\u0003#Q\u0018\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005U\u00111\u0002\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0011\u0019\tIB\u0002a\u0001}\u0005A1\r\\5f]RLE-A\u000fuKN$8\t\\5f]RLE-U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4f)\rA\u0014q\u0004\u0005\u0006{\u001d\u0001\rA\u0010\u0015\u0006\u000f)C\u00161\u0005\u0017\u00035rCCaB0dI\u0006IB/Z:u+N,'/U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4f)\rA\u00141\u0006\u0005\u0006{!\u0001\rA\u0010\u0015\u0006\u0011)C\u0016q\u0006\u0017\u00035rCC\u0001C0dI\u0006YB/Z:u+N,'o\u00117jK:$\u0018\nZ)v_R\f7\t[1oO\u0016$2\u0001OA\u001c\u0011\u0015i\u0014\u00021\u0001?Q\u0015I!\nWA\u001eY\tQF\f\u000b\u0003\n?\u000e$\u0017\u0001\n;fgR$UMZ1vYR\u001cE.[3oi&#\u0017+^8uC\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u0007a\n\u0019\u0005C\u0003>\u0015\u0001\u0007a\bK\u0003\u000b\u0015b\u000b9\u0005\f\u0002[9\"\"!bX2e\u0003\u0001\"Xm\u001d;EK\u001a\fW\u000f\u001c;Vg\u0016\u0014\u0018+^8uC\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u0007a\ny\u0005C\u0003>\u0017\u0001\u0007a\bK\u0003\f\u0015b\u000b\u0019\u0006\f\u0002[9\"\"1bX2e\u0003!\"Xm\u001d;EK\u001a\fW\u000f\u001c;Vg\u0016\u00148\t\\5f]RLE-U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4f)\rA\u00141\f\u0005\u0006{1\u0001\rA\u0010\u0015\u0006\u0019)C\u0016q\f\u0017\u00035rCC\u0001D0dI\u00069B/Z:u#V|G/Y%oSRL\u0017\r\\5{CRLwN\u001c\u000b\u0004q\u0005\u001d\u0004\"B\u001f\u000e\u0001\u0004q\u0004&B\u0007K1\u0006-D&\u0001.)\t5y6\rZ\u0001\u001ai\u0016\u001cH/\u00139Rk>$\u0018-\u00138ji&\fG.\u001b>bi&|g\u000eF\u00029\u0003gBQ!\u0010\bA\u0002yBSA\u0004&Y\u0003ob#A\u0017/)\t9y6\rZ\u0001\u0018i\u0016\u001cH/\u00139Rk>$\u0018mQ8oM&<7\t[1oO\u0016$2\u0001OA@\u0011\u0015it\u00021\u0001?Q\u0015y!\nWABY\tQF\f\u000b\u0003\u0010?\u000e$\u0017A\t;fgR\u001cuN\u001c4jO\u000eC\u0017M\\4f\u001f:tuN\\#ySN$\u0018N\\4U_BL7\rF\u00029\u0003\u0017CQ!\u0010\tA\u0002yBS\u0001\u0005&Y\u0003\u001fc\u0013A\u0017\u0015\u0005!}\u001bG-A\u0019uKN$8i\u001c8gS\u001e\u001c\u0005.\u00198hK>sgj\u001c8Fq&\u001cH/\u001b8h)>\u0004\u0018nY,ji\"\fE-\\5o\u00072LWM\u001c;\u0015\u0007a\n9\nC\u0003>#\u0001\u0007a\bK\u0003\u0012\u0015b\u000bY\n\f\u0002[9\"\"\u0011cX2e\u0003]!Xm\u001d;Qe>\u001cWm]:O_RLg-[2bi&|g\u000eF\u00029\u0003GCQ!\u0010\nA\u0002yBSA\u0005&Y\u0003Oc\u0013A\u0017\u0015\u0005%}\u001bG-\u0001\u0014uKN$\u0018J\\2sK6,g\u000e^1m\u00032$XM\u001d#fM\u0006,H\u000e\u001e+pa&\u001c7i\u001c8gS\u001e$2\u0001OAX\u0011\u0015i4\u00031\u0001?Q\u0015\u0019\"\nWAZY\tQF\f\u000b\u0003\u0014?\u000e$\u0017a\u0007;fgR\fE\u000e^3s\t\u00164\u0017-\u001e7u)>\u0004\u0018nY\"p]\u001aLw\rF\u00029\u0003wCQ!\u0010\u000bA\u0002yBS\u0001\u0006&Y\u0003\u007fc#A\u0017/)\tQy6\rZ\u0001\u0012GJ,\u0017\r^3BI6Lgn\u00117jK:$HCAAd!\u0011\tI-a5\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\fQ!\u00193nS:T1!!5}\u0003\u001d\u0019G.[3oiNLA!!6\u0002L\n)\u0011\tZ7j]\":\u0001!!7\u0002f\u0006\u001d\b\u0003BAn\u0003Cl!!!8\u000b\u0007\u0005}\u0007+A\u0002ba&LA!a9\u0002^\n9A+[7f_V$\u0018!\u0002<bYV,g$\u00013")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnectOrNull(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())), (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigChange(String quorum) {
        if (!this.isKRaftTest()) {
            Assertions.assertTrue((boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)ConfigType$.MODULE$.Topic()), (String)"Should contain a ConfigHandler for topics");
        }
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put("flush.messages", oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$1(this, tp, oldVal);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", newVal.toString()), AlterConfigOp.OpType.SET);
                ConfigResource resource2 = new ConfigResource(ConfigResource.Type.BROKER, "");
                AlterConfigOp op2 = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LogFlushIntervalMsProp(), newVal.toString()), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource2), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)op2, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
            }
        } else {
            Properties newProps = new Properties();
            newProps.setProperty("flush.messages", newVal.toString());
            this.adminZkClient().changeTopicConfig(tp.topic(), newProps);
        }
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$2(this, newVal, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicTopicConfigChange(String quorum) {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 1000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Integer.toString(oldSegmentSize));
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$1(this, tp, oldSegmentSize);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        int newSegmentSize = 2000;
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("segment.bytes", Integer.toString(newSegmentSize)), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
            }
        } else {
            Properties newProps = new Properties();
            newProps.put("segment.bytes", Integer.toString(newSegmentSize));
            this.adminZkClient().changeTopicConfig(tp.topic(), newProps);
        }
        LogManager qual$2 = ((KafkaBroker)this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        UnifiedLog log = (UnifiedLog)qual$2.getLog(tp, x$4).get();
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$2(newSegmentSize, log);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.produceMessage(this.brokers(), tp.topic(), Integer.toString(i), TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6()));
        Assertions.assertTrue((boolean)log.logSegments().stream().allMatch(x$1 -> x$1.size() > 1000), (String)"Log segment size change not applied");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testMessageFormatVersionChange(String quorum) {
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put("message.format.version", "0.10.2");
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        KafkaServer server = (KafkaServer)this.servers().head();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$1(server, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$2 = server.logManager();
        boolean x$4 = qual$2.getLog$default$2();
        UnifiedLog log = (UnifiedLog)qual$2.getLog(tp, x$4).get();
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)log.config().messageFormatVersion);
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
        String compressionType = CompressionType.LZ4.name;
        logProps.put("message.format.version", "0.11.0");
        logProps.put("compression.type", compressionType);
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$3(server, tp, compressionType)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)log.config().messageFormatVersion);
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaConfigChange(ClientQuotaEntity entity, KafkaPrincipal user, String clientId) {
        try (Admin admin = this.createAdminClient();){
            java.util.List<Object> alterations = Arrays.asList((Object[])new ClientQuotaAlteration[]{new ClientQuotaAlteration(entity, Arrays.asList((Object[])new ClientQuotaAlteration.Op[]{new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(2000.0))}))});
            admin.alterClientQuotas(alterations).all().get();
            QuotaFactory.QuotaManagers quotaManagers = ((KafkaBroker)this.brokers().head()).dataPlaneRequestProcessor().quotas();
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            long l = 10000L;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ retry_this = testUtils$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$1(quotaManagers, user, clientId);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
            double defaultProducerQuota = Long.MAX_VALUE;
            double defaultConsumerQuota = Long.MAX_VALUE;
            java.util.List<Object> removals = Arrays.asList((Object[])new ClientQuotaAlteration[]{new ClientQuotaAlteration(entity, Arrays.asList((Object[])new ClientQuotaAlteration.Op[]{new ClientQuotaAlteration.Op("producer_byte_rate", null), new ClientQuotaAlteration.Op("consumer_byte_rate", null)}))});
            admin.alterClientQuotas(removals).all().get();
            TestUtils$ testUtils$2 = TestUtils$.MODULE$;
            long l2 = 10000L;
            if (testUtils$2 == null) {
                throw null;
            }
            TestUtils$ retry_this2 = testUtils$2;
            LongRef retry_wait2 = LongRef.create((long)1L);
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$2(quotaManagers, user, clientId, defaultProducerQuota, defaultConsumerQuota);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                    }
                    Thread.sleep(retry_wait2.elem);
                    retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                    continue;
                }
                break;
            }
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClientIdQuotaConfigChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUserQuotaConfigChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUserClientIdQuotaChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultClientIdQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultUserQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultUserClientIdQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testQuotaInitialization(String quorum) {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put("producer_byte_rate", "1000");
        clientIdProps.put("consumer_byte_rate", "2000");
        Properties userProps = new Properties();
        userProps.put("producer_byte_rate", "10000");
        userProps.put("consumer_byte_rate", "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put("producer_byte_rate", "100000");
        userClientIdProps.put("consumer_byte_rate", "200000");
        this.adminZkClient().changeClientIdConfig("overriddenClientId", clientIdProps);
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = "overriddenUser";
        boolean x$3 = qual$1.changeUserOrUserClientIdConfig$default$3();
        qual$1.changeUserOrUserClientIdConfig(x$1, userProps, x$3);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$4 = "ANONYMOUS/clients/overriddenUserClientId";
        boolean x$6 = qual$2.changeUserOrUserClientIdConfig$default$3();
        qual$2.changeUserOrUserClientIdConfig(x$4, userClientIdProps, x$6);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable & scala.Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.dataPlaneRequestProcessor().quotas();
        Assertions.assertEquals((Object)Quota.upperBound((double)1000.0), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)2000.0), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)10000.0), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)20000.0), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)100000.0), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)200000.0), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIpQuotaInitialization(String quorum) {
        KafkaBroker broker = (KafkaBroker)this.brokers().head();
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                java.util.List<Object> alterations = Arrays.asList((Object[])new ClientQuotaAlteration[]{new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0))))});
                admin.alterClientQuotas(alterations).all().get();
            }
        } else {
            broker.shutdown();
            Properties ipDefaultProps = new Properties();
            ipDefaultProps.put("connection_creation_rate", "20");
            this.adminZkClient().changeIpConfig(ConfigEntityName$.MODULE$.Default(), ipDefaultProps);
            Properties ipOverrideProps = new Properties();
            ipOverrideProps.put("connection_creation_rate", "10");
            this.adminZkClient().changeIpConfig("1.2.3.4", ipOverrideProps);
            this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable & scala.Serializable)p -> {
                DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$1(this, p);
                return BoxedUnit.UNIT;
            });
            broker.startup();
        }
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$2(broker);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIpQuotaConfigChange(String quorum) {
        try (Admin admin = this.createAdminClient();){
            java.util.List<Object> alterations = Arrays.asList((Object[])new ClientQuotaAlteration[]{new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0))))});
            admin.alterClientQuotas(alterations).all().get();
            InetAddress overrideQuotaIp = InetAddress.getByName("1.2.3.4");
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(10));
            InetAddress defaultQuotaIp = InetAddress.getByName("2.3.4.5");
            this.verifyConnectionQuota$1(defaultQuotaIp, Predef$.MODULE$.int2Integer(20));
            java.util.List<Object> deletions1 = Arrays.asList((Object[])new ClientQuotaAlteration[]{new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null)))});
            admin.alterClientQuotas(deletions1).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(20));
            java.util.List<Object> deletions2 = Arrays.asList((Object[])new ClientQuotaAlteration[]{new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null)))});
            admin.alterClientQuotas(deletions2).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testConfigChangeOnNonExistingTopic(String quorum) {
        String topic = TestUtils$.MODULE$.tempTopic();
        Properties logProps = new Properties();
        logProps.put("flush.messages", Predef$.MODULE$.int2Integer(10000));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.adminZkClient().changeTopicConfig(topic, logProps));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigChangeOnNonExistingTopicWithAdminClient(String quorum) {
        String topic = TestUtils$.MODULE$.tempTopic();
        try (Admin admin = this.createAdminClient();){
            try {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", "10000"), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
                Assertions.fail((String)"Should fail with UnknownTopicOrPartitionException for topic doesn't exist");
            }
            catch (ExecutionException executionException) {
                Assertions.assertTrue((boolean)(executionException.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testProcessNotification(String quorum) {
        new Properties().put("a.b", "10");
        ConfigHandler handler = (ConfigHandler)Mockito.mock(ConfigHandler.class);
        ZkConfigManager configManager = new ZkConfigManager(this.zkClient(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigType$.MODULE$.Topic()), (Object)handler)})));
        configManager.ConfigChangedNotificationHandler().processNotification("not json".getBytes(StandardCharsets.UTF_8));
        ObjectRef jsonMap = ObjectRef.create((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"garbage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic())}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap.elem).asJava()));
        ((ConfigHandler)Mockito.verify((Object)handler)).processConfigChanges(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.any());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIncrementalAlterDefaultTopicConfig(String quorum) {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, "");
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", "200000"), AlterConfigOp.OpType.SET);
            KafkaFuture future = admin.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all();
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, InvalidRequestException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterDefaultTopicConfig(String quorum) {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, "");
            Config config = new Config(Collections.singleton(new ConfigEntry("flush.messages", "200000")));
            KafkaFuture future = admin.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()).all();
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, InvalidRequestException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        }
    }

    private Admin createAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        return Admin.create((Properties)props);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$1, Long oldVal$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$1, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((Long)oldVal$1, (long)((UnifiedLog)logOpt.get()).config().flushInterval);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$2(DynamicConfigChangeTest $this, Long newVal$1, TopicPartition tp$1) {
        LogManager qual$2 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Assertions.assertEquals((Long)newVal$1, (long)((UnifiedLog)qual$2.getLog((TopicPartition)tp$1, (boolean)x$4).get()).config().flushInterval);
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$2, int oldSegmentSize$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$2, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((int)oldSegmentSize$1, (int)((UnifiedLog)logOpt.get()).config().segmentSize);
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$2(int newSegmentSize$1, UnifiedLog log$1) {
        Assertions.assertEquals((int)newSegmentSize$1, (int)log$1.config().segmentSize);
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$1(KafkaServer server$1, TopicPartition tp$3) {
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(tp$3, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$2() {
        return "Topic metadata propagation failed";
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$3(KafkaServer server$1, TopicPartition tp$3, String compressionType$1) {
        LogManager qual$3 = server$1.logManager();
        boolean x$6 = qual$3.getLog$default$2();
        String string = ((UnifiedLog)qual$3.getLog((TopicPartition)tp$3, (boolean)x$6).get()).config().compressionType;
        return !(string != null ? !string.equals(compressionType$1) : compressionType$1 != null);
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$4() {
        return "Topic config change propagation failed";
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$1(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1) {
        Quota overrideProducerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota overrideConsumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)Quota.upperBound((double)1000.0), (Object)overrideProducerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden producer quota of 1000").toString());
        Assertions.assertEquals((Object)Quota.upperBound((double)2000.0), (Object)overrideConsumerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden consumer quota of 2000").toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$2(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1, double defaultProducerQuota$1, double defaultConsumerQuota$1) {
        Quota producerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota consumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)Quota.upperBound((double)defaultProducerQuota$1), (Object)producerQuota, (String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset producer quota to ").append(defaultProducerQuota$1).toString());
        Assertions.assertEquals((Object)Quota.upperBound((double)defaultConsumerQuota$1), (Object)consumerQuota, (String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset consumer quota to ").append(defaultConsumerQuota$1).toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$3 = $this.zkClient();
        String x$7 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$8 = qual$3.deletePath$default$2();
        boolean x$9 = qual$3.deletePath$default$3();
        qual$3.deletePath(x$7, x$8, x$9);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$2(KafkaBroker broker$1) {
        ConnectionQuotas connectionQuotas = broker$1.socketServer().connectionQuotas();
        Assertions.assertEquals((long)10L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("1.2.3.4")));
        Assertions.assertEquals((long)20L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("2.4.6.8")));
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaConfigChange$1(ConnectionQuotas connectionQuotas$1, InetAddress ip$1, Integer expectedQuota$1) {
        int quota = connectionQuotas$1.connectionRateForIp(ip$1);
        Assertions.assertEquals((Integer)expectedQuota$1, (int)quota, (String)new StringBuilder(24).append("Unexpected quota for IP ").append(ip$1).toString());
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyConnectionQuota$1(InetAddress ip, Integer expectedQuota) {
        ConnectionQuotas connectionQuotas = ((KafkaBroker)this.brokers().head()).socketServer().connectionQuotas();
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaConfigChange$1(connectionQuotas, ip, expectedQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }
}

