/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u000b\u0017\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005BQa\t\u0001\u0005B\u0011B\u0011b\u000b\u0001A\u0002\u0003\u0007I\u0011\u0002\u0017\t\u0013}\u0002\u0001\u0019!a\u0001\n\u0013\u0001\u0005\"\u0003$\u0001\u0001\u0004\u0005\t\u0015)\u0003.\u0011\u001d9\u0005A1A\u0005\n!Ca!\u0015\u0001!\u0002\u0013I\u0005b\u0002*\u0001\u0005\u0004%Ia\u0015\u0005\u00075\u0002\u0001\u000b\u0011\u0002+\t\u000fm\u0003!\u0019!C\u00059\"11\r\u0001Q\u0001\nuCQ\u0001\u001a\u0001\u0005\n\u0015DQ\u0001\u001b\u0001\u0005\n%DQ\u0001\u001c\u0001\u0005B5DQA \u0001\u0005B}Dq!!\u0003\u0001\t#\nY\u0001\u0003\u0004\u0002\u001e\u0001!Ia \u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!a\"\u0001\t\u0013\tII\u0001\rGKR\u001c\u0007NU3rk\u0016\u001cH/T1y\u0005f$Xm\u001d+fgRT!a\u0006\r\u0002\rM,'O^3s\u0015\u0005I\u0012!B6bM.\f7\u0001A\n\u0003\u0001q\u0001\"!\b\u0010\u000e\u0003YI!a\b\f\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#\u0001\u0012\u0011\u0005u\u0001\u0011a\u00032s_.,'oQ8v]R,\u0012!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0004\u0013:$\u0018\u0001\u00039s_\u0012,8-\u001a:\u0016\u00035\u0002BAL\u001c:s5\tqF\u0003\u0002,a)\u0011\u0011GM\u0001\bG2LWM\u001c;t\u0015\tI2G\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<\u0017B\u0001\u001d0\u00055Y\u0015MZ6b!J|G-^2feB\u0019aE\u000f\u001f\n\u0005m:#!B!se\u0006L\bC\u0001\u0014>\u0013\tqtE\u0001\u0003CsR,\u0017\u0001\u00049s_\u0012,8-\u001a:`I\u0015\fHCA!E!\t1#)\u0003\u0002DO\t!QK\\5u\u0011\u001d)E!!AA\u00025\n1\u0001\u001f\u00132\u0003%\u0001(o\u001c3vG\u0016\u0014\b%A\u0005uKN$Hk\u001c9jGV\t\u0011\n\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006!A.\u00198h\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U&\u0003\rM#(/\u001b8h\u0003)!Xm\u001d;U_BL7\rI\u0001\u0013i\u0016\u001cH\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001U!\t)\u0006,D\u0001W\u0015\t9&'\u0001\u0004d_6lwN\\\u0005\u00033Z\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\nuKN$Hk\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\u0005nKN\u001c\u0018mZ3t+\u0005i\u0006c\u00010bs5\tqL\u0003\u0002aO\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\t|&AC%oI\u0016DX\rZ*fc\u0006IQ.Z:tC\u001e,7\u000fI\u0001\u000f[VdG/\u001b\"zi\u0016\f%O]1z)\tId\rC\u0003h\u0019\u0001\u0007Q%\u0001\u0004mK:<G\u000f[\u0001\r_:,')\u001f;f\u0003J\u0014\u0018-\u001f\u000b\u0003s)DQa[\u0007A\u0002q\nQA^1mk\u0016\fQa]3u+B$\"!\u00118\t\u000b=t\u0001\u0019\u00019\u0002\u0011Q,7\u000f^%oM>\u0004\"!\u001d=\u000e\u0003IT!a\u001d;\u0002\u0007\u0005\u0004\u0018N\u0003\u0002vm\u00069!.\u001e9ji\u0016\u0014(BA<6\u0003\u0015QWO\\5u\u0013\tI(O\u0001\u0005UKN$\u0018J\u001c4pQ\tq1\u0010\u0005\u0002ry&\u0011QP\u001d\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0003\u0005C3aDA\u0002!\r\t\u0018QA\u0005\u0004\u0003\u000f\u0011(!C!gi\u0016\u0014X)Y2i\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000fF\u0002B\u0003\u001bAq!a\u0004\u0011\u0001\u0004\t\t\"\u0001\u0006qe>\u0004XM\u001d;jKN\u0004B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/i\u0015\u0001B;uS2LA!a\u0007\u0002\u0016\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u0019\r\u0014X-\u0019;f)>\u0004\u0018nY:\u0002!M,g\u000e\u001a$fi\u000eD'+Z9vKN$HCBA\u0012\u0003_\t\u0019\u0004\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tICV\u0001\te\u0016\fX/Z:ug&!\u0011QFA\u0014\u000551U\r^2i%\u0016\u001c\bo\u001c8tK\"1\u0011\u0011\u0007\nA\u0002\u0015\n\u0001\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0005\b\u0003k\u0011\u0002\u0019AA\u001c\u0003\u001d\u0011X-];fgR\u0004B!!\n\u0002:%!\u00111HA\u0014\u000511U\r^2i%\u0016\fX/Z:u\u0003i!Xm\u001d;D_:\u001cX/\\3Nk2$\u0018\u000e\u001d7f%\u0016\u001cwN\u001d3t)\r\t\u0015\u0011\t\u0005\b\u0003\u0007\u001a\u0002\u0019AA#\u0003\u0019\tXo\u001c:v[B!\u0011qIA+\u001d\u0011\tI%!\u0015\u0011\u0007\u0005-s%\u0004\u0002\u0002N)\u0019\u0011q\n\u000e\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019fJ\u0001\u0007!J,G-\u001a4\n\u0007A\u000b9FC\u0002\u0002T\u001dBsaEA.\u0003W\ni\u0007\u0005\u0003\u0002^\u0005\u001dTBAA0\u0015\u0011\t\t'a\u0019\u0002\u0011A\u0014xN^5eKJT1!!\u001au\u0003\u0019\u0001\u0018M]1ng&!\u0011\u0011NA0\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"\u0011qNA:C\t\t\t(\u0001\u0002{W\u0006\u0012\u0011QO\u0001\u0006WJ\fg\r\u001e\u0015\b'\u0005e\u0014\u0011QAB!\u0011\tY(! \u000e\u0005\u0005\r\u0014\u0002BA@\u0003G\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\u0005\u0015\u0015AI>eSN\u0004H.Y=OC6,WPL>be\u001e,X.\u001a8ug^KG\u000f\u001b(b[\u0016\u001cX0A\tfqB,7\r\u001e(fqR\u0014VmY8sIN$R!QAF\u0003?Cq!!$\u0015\u0001\u0004\ty)\u0001\u0005fqB,7\r^3e!\u0015\t\t*a':\u001d\u0011\t\u0019*a&\u000f\t\u0005-\u0013QS\u0005\u0002Q%\u0019\u0011\u0011T\u0014\u0002\u000fA\f7m[1hK&\u0019!-!(\u000b\u0007\u0005eu\u0005C\u0004\u0002\"R\u0001\r!a)\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\t\u0004M\u0005\u0015\u0016bAATO\t!Aj\u001c8h\u0001")
public class FetchRequestMaxBytesTest
extends BaseRequestTest {
    private KafkaProducer<byte[], byte[]> producer;
    private final String testTopic;
    private final TopicPartition testTopicPartition = new TopicPartition(this.testTopic(), 0);
    private final IndexedSeq<byte[]> messages = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.multiByteArray(1), this.multiByteArray(500), this.multiByteArray(1040), this.multiByteArray(500), this.multiByteArray(50)}));

    @Override
    public int brokerCount() {
        return 1;
    }

    private KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    private String testTopic() {
        return this.testTopic;
    }

    private TopicPartition testTopicPartition() {
        return this.testTopicPartition;
    }

    private IndexedSeq<byte[]> messages() {
        return this.messages;
    }

    private byte[] multiByteArray(int length) {
        byte[] array = new byte[length];
        new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(array)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            array$1[i] = (byte)(i % 5);
        });
        return array;
    }

    private byte[] oneByteArray(byte value) {
        byte[] array = new byte[]{value};
        return array;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.producer_$eq(TestUtils$.MODULE$.createProducer(this.bootstrapServers(this.bootstrapServers$default$1()), TestUtils$.MODULE$.createProducer$default$2(), TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        super.tearDown();
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        super.brokerPropertyOverrides(properties);
        properties.put(KafkaConfig$.MODULE$.FetchMaxBytes(), "1024");
    }

    private void createTopics() {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("min.insync.replicas", Integer.toString(1));
        this.createTopic(this.testTopic(), 1, 1, topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        this.messages().indices().foreach((Function1 & Serializable & scala.Serializable)i -> FetchRequestMaxBytesTest.$anonfun$createTopics$1(this, BoxesRunTime.unboxToInt((Object)i)));
    }

    private FetchResponse sendFetchRequest(int leaderId, FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConsumeMultipleRecords(String quorum) {
        this.createTopics();
        this.expectNextRecords((IndexedSeq<byte[]>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])this.messages().apply(0), (byte[])this.messages().apply(1)}))), 0L);
        this.expectNextRecords((IndexedSeq<byte[]>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])this.messages().apply(2)}))), 2L);
        this.expectNextRecords((IndexedSeq<byte[]>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])this.messages().apply(3), (byte[])this.messages().apply(4)}))), 3L);
    }

    private void expectNextRecords(IndexedSeq<byte[]> expected, long fetchOffset) {
        Iterable records = FetchResponse.recordsOrFail((FetchResponseData.PartitionData)((FetchResponseData.PartitionData)this.sendFetchRequest(0, FetchRequest.Builder.forConsumer((short)3, (int)Integer.MAX_VALUE, (int)0, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.testTopicPartition()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, fetchOffset, 0L, Integer.MAX_VALUE, Optional.empty()))}))).asJava())).build((short)3)).responseData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.getTopicNames()).asJava(), (short)3).get(this.testTopicPartition()))).records();
        Assertions.assertNotNull((Object)records);
        List recordsList = ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records).asScala()).toList();
        Assertions.assertEquals((int)expected.size(), (int)recordsList.size());
        ((List)recordsList.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FetchRequestMaxBytesTest.$anonfun$expectNextRecords$1(expected, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ RecordMetadata $anonfun$createTopics$1(FetchRequestMaxBytesTest $this, int i) {
        ProducerRecord record = new ProducerRecord($this.testTopic(), Predef$.MODULE$.int2Integer(0), (Object)$this.oneByteArray((byte)i), $this.messages().apply(i));
        Future future = $this.producer().send(record);
        $this.producer().flush();
        return (RecordMetadata)future.get();
    }

    public static final /* synthetic */ void $anonfun$expectNextRecords$1(IndexedSeq expected$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            Record record = (Record)x0$1._1();
            int i = x0$1._2$mcI$sp();
            ByteBuffer buffer = record.value().duplicate();
            byte[] array = new byte[buffer.remaining()];
            buffer.get(array);
            Assertions.assertArrayEquals((byte[])((byte[])expected$1.apply(i)), (byte[])array, (String)new StringBuilder(37).append("expectNextRecords unexpected element ").append(i).toString());
            return;
        }
        throw new MatchError(null);
    }

    public FetchRequestMaxBytesTest() {
        this.testTopic = "testTopic";
    }
}

