/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.network.SocketServer;
import kafka.server.AbstractMetadataRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001\u0002\n\u0014\u0001aAQ!\b\u0001\u0005\u0002yAQ\u0001\t\u0001\u0005B\u0005BQA\u000f\u0001\u0005\u0002mBQ\u0001\u0019\u0001\u0005\u0002\u0005DQA\u001a\u0001\u0005\u0002\u001dDQ\u0001\u001c\u0001\u0005\u00025DQA\u001d\u0001\u0005\u0002MDQ\u0001\u001f\u0001\u0005\u0002eDQA \u0001\u0005\u0002}Dq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!!\u0018\u0001\t\u0003\tyFA\nNKR\fG-\u0019;b%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0015+\u000511/\u001a:wKJT\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b75\t1#\u0003\u0002\u001d'\tY\u0012IY:ue\u0006\u001cG/T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#A\u0010\u0011\u0005i\u0001\u0011!B:fiV\u0003HC\u0001\u0012)!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0011)f.\u001b;\t\u000b%\u0012\u0001\u0019\u0001\u0016\u0002\u0011Q,7\u000f^%oM>\u0004\"a\u000b\u001b\u000e\u00031R!!\f\u0018\u0002\u0007\u0005\u0004\u0018N\u0003\u00020a\u00059!.\u001e9ji\u0016\u0014(BA\u00193\u0003\u0015QWO\\5u\u0015\u0005\u0019\u0014aA8sO&\u0011Q\u0007\f\u0002\t)\u0016\u001cH/\u00138g_\"\u0012!a\u000e\t\u0003WaJ!!\u000f\u0017\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0011uKN$8\t\\;ti\u0016\u0014\u0018\nZ,ji\"\u0014V-];fgR4VM]:j_:\fDC\u0001\u0012=\u0011\u0015i4\u00011\u0001?\u0003\u0019\tXo\u001c:v[B\u0011qH\u0012\b\u0003\u0001\u0012\u0003\"!\u0011\u0013\u000e\u0003\tS!aQ\f\u0002\rq\u0012xn\u001c;?\u0013\t)E%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000f\"\u0013aa\u0015;sS:<'BA#%Q\u0011\u0019!JU*\u0011\u0005-\u0003V\"\u0001'\u000b\u00055s\u0015\u0001\u00039s_ZLG-\u001a:\u000b\u0005=s\u0013A\u00029be\u0006l7/\u0003\u0002R\u0019\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd#\u0001\u0016,\"\u0003U\u000b!A_6\"\u0003]\u000bQa\u001b:bMRDCaA-^=B\u0011!lW\u0007\u0002\u001d&\u0011AL\u0014\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013aX\u0001#w\u0012L7\u000f\u001d7bs:\u000bW.Z?/w\u0006\u0014x-^7f]R\u001cx+\u001b;i\u001d\u0006lWm]?\u0002)Q,7\u000f^\"mkN$XM]%e\u0013N4\u0016\r\\5e)\t\u0011#\rC\u0003>\t\u0001\u0007a\b\u000b\u0003\u0005\u0015J#GF\u0001+WQ\u0011!\u0011,\u00180\u0002!Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe&#GC\u0001\u0012i\u0011\u0015iT\u00011\u0001?Q\u0011)!J\u00156-\u0003QCC!B-^=\u0006AA/Z:u%\u0006\u001c7\u000e\u0006\u0002#]\")QH\u0002a\u0001}!\"aA\u0013*qY\t!f\u000b\u000b\u0003\u00073vs\u0016A\u0004;fgRL5/\u00138uKJt\u0017\r\u001c\u000b\u0003EQDQ!P\u0004A\u0002yBCa\u0002&Sm2\u0012AK\u0016\u0015\u0005\u000fekf,A\nuKN$hj\u001c+pa&\u001c7OU3rk\u0016\u001cH\u000f\u0006\u0002#u\")Q\b\u0003a\u0001}!\"\u0001B\u0013*}Y\t!f\u000b\u000b\u0003\t3vs\u0016!\u0006;fgR\fU\u000f^8U_BL7m\u0011:fCRLwN\u001c\u000b\u0004E\u0005\u0005\u0001\"B\u001f\n\u0001\u0004q\u0004&B\u0005K%\u0006\u0015AF\u0001+WQ\u0011I\u0011,\u00180\u0002_Q,7\u000f^!vi>\u001c%/Z1uKR{\u0007/[2XSRD\u0017J\u001c<bY&$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0015\u0007\t\ni\u0001C\u0003>\u0015\u0001\u0007a\bK\u0003\u000b\u0015J\u000b\t\u0002\f\u0002U-\"\"!\"W/_\u0003}!Xm\u001d;BkR|7I]3bi\u0016|emQ8mY&$\u0017N\\4U_BL7m\u001d\u000b\u0004E\u0005e\u0001\"B\u001f\f\u0001\u0004q\u0004&B\u0006K%\u0006uA&\u0001+)\t-IVLX\u0001\u0015i\u0016\u001cH/\u00117m)>\u0004\u0018nY:SKF,Xm\u001d;\u0015\u0007\t\n)\u0003C\u0003>\u0019\u0001\u0007a\bK\u0003\r\u0015J\u000bI\u0003\f\u0002U-\"\"A\"W/_\u0003Y!Xm\u001d;U_BL7-\u00133t\u0013:\u0014Vm\u001d9p]N,Gc\u0001\u0012\u00022!)Q(\u0004a\u0001}!*QB\u0013*\u000261\u0012AK\u0016\u0015\u0005\u001bekf,\u0001\u000buKN$\bK]3gKJ\u0014X\r\u001a*fa2L7-\u0019\u000b\u0004E\u0005u\u0002\"B\u001f\u000f\u0001\u0004q\u0004&\u0002\bK%\u0006\u0005CF\u0001+WQ\u0011q\u0011,\u00180\u0002/Q,7\u000f\u001e*fa2L7-\u0019#po:\u0014Vm\u001d9p]N,Gc\u0001\u0012\u0002J!)Qh\u0004a\u0001}!*qB\u0013*\u0002N1\u0012AK\u0016\u0015\u0005\u001fekf,\u0001\u0014uKN$\u0018j\u001d:BMR,'O\u0011:pW\u0016\u00148\u000b[;u\t><h.\u00118e\u0015>Lgn\u001d\"bG.$2AIA+\u0011\u0015i\u0004\u00031\u0001?Q\u0015\u0001\"JUA-Y\t!f\u000b\u000b\u0003\u00113vs\u0016\u0001\b;fgR\fE.\u001b<f\u0005J|7.\u001a:t/&$\bNT8U_BL7m\u001d\u000b\u0004E\u0005\u0005\u0004\"B\u001f\u0012\u0001\u0004q\u0004&B\tK%\u0006\u0015DF\u0001+WQ\u0011\t\u0012,\u00180")
public class MetadataRequestTest
extends AbstractMetadataRequestTest {
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterIdWithRequestVersion1(String quorum) {
        Assertions.assertNull((Object)this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2()).clusterId(), (String)"v1 clusterId should be null");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterIdIsValid(String quorum) {
        TestUtils.isValidClusterId((String)this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)2), this.sendMetadataRequest$default$2()).clusterId());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testControllerId(String quorum) {
        KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testControllerId$1(x$1))).get();
        int controllerId = controllerServer.config().brokerId();
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)controllerId, (int)metadataResponse.controller().id(), (String)"Controller id should match the active controller");
        controllerServer.shutdown();
        controllerServer.startup();
        KafkaServer controllerServer2 = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testControllerId$2(x$2))).get();
        int controllerId2 = controllerServer2.config().brokerId();
        Assertions.assertNotEquals((int)controllerId, (int)controllerId2, (String)"Controller id should switch to a new broker");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testControllerId$3(this, controllerServer2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MetadataRequestTest.$anonfun$testControllerId$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testRack(String quorum) {
        this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2()).brokers().forEach(broker -> Assertions.assertEquals((Object)new StringBuilder(5).append("rack/").append(broker.id()).toString(), (Object)broker.rack(), (String)"Rack information should match config"));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIsInternal(String quorum) {
        String internalTopic = "__consumer_offsets";
        String notInternalTopic = "notInternal";
        this.createTopic(internalTopic, 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(notInternalTopic, 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Iterable topicMetadata = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala();
        MetadataResponse.TopicMetadata internalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$1(internalTopic, x$3))).get();
        MetadataResponse.TopicMetadata notInternalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$2(notInternalTopic, x$4))).get();
        Assertions.assertTrue((boolean)internalTopicMetadata.isInternal(), (String)"internalTopic should show isInternal");
        Assertions.assertFalse((boolean)notInternalTopicMetadata.isInternal(), (String)"notInternalTopic topic not should show isInternal");
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{internalTopic}))).asJava(), (Object)metadataResponse.buildCluster().internalTopics());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNoTopicsRequest(String quorum) {
        this.createTopic("t1", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("t2", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponse = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), true, (short)1).build(), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertTrue((boolean)metadataResponse.topicMetadata().isEmpty(), (String)"Response should have no topics");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoTopicCreation(String quorum) {
        String topic1 = "t1";
        String topic2 = "t2";
        String topic3 = "t3";
        String topic4 = "t4";
        String topic5 = "t5";
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertNull(response1.errors().get(topic1));
        this.checkAutoCreatedTopic(topic2, response1);
        MetadataResponse response2 = this.sendMetadataRequest(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic(topic3, response2);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)new .colon.colon((Object)topic4, (List)Nil$.MODULE$), false), (short)3), this.sendMetadataRequest$default$2()));
        MetadataResponse response3 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic4, (List)new .colon.colon((Object)topic5, (List)Nil$.MODULE$))).asJava(), false, (short)4).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic4));
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic5));
        if (!this.isKRaftTest()) {
            Assertions.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(topic5));
            return;
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoCreateTopicWithInvalidReplicationFactor(String quorum) {
        ((IterableLike)this.brokers().tail()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        ((IterableLike)this.brokers().tail()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        String topic1 = "testAutoCreateTopic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)1, (int)response1.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).head();
        if (this.isKRaftTest()) {
            Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)topicMetadata.error());
        } else {
            Assertions.assertEquals((Object)Errors.INVALID_REPLICATION_FACTOR, (Object)topicMetadata.error());
        }
        Assertions.assertEquals((Object)topic1, (Object)topicMetadata.topic());
        Assertions.assertEquals((int)0, (int)topicMetadata.partitionMetadata().size());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testAutoCreateOfCollidingTopics(String quorum) {
        String topic1 = "testAutoCreate.Topic";
        String topic2 = "testAutoCreate_Topic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)2, (int)response1.topicMetadata().size());
        scala.collection.immutable.Map responseMap = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).map((Function1 & Serializable & scala.Serializable)metadata -> new Tuple2((Object)metadata.topic(), (Object)metadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (Object)responseMap.keySet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.LEADER_NOT_AVAILABLE, Errors.INVALID_TOPIC_EXCEPTION})), (Object)responseMap.values().toSet());
        String topicCreated = (String)((Tuple2)responseMap.head())._1();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topicCreated, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$7());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), topicCreated, 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        MetadataResponse response2 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicCreated, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        MetadataResponse.TopicMetadata topicMetadata1 = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response2.topicMetadata()).asScala()).head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata1.error());
        Assertions.assertEquals((Object)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata1.partitionMetadata()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.error, Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((int)1, (int)topicMetadata1.partitionMetadata().size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata1.partitionMetadata()).asScala()).head();
        Assertions.assertEquals((int)0, (int)partitionMetadata.partition());
        Assertions.assertEquals((int)2, (int)partitionMetadata.replicaIds.size());
        Assertions.assertTrue((boolean)partitionMetadata.leaderId.isPresent());
        Assertions.assertTrue((Predef$.MODULE$.Integer2int((Integer)partitionMetadata.leaderId.get()) >= 0 ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAllTopicsRequest(String quorum) {
        this.createTopic("t1", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("t2", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponseV0 = this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)Nil$.MODULE$, true), (short)0), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponseV0.errors().isEmpty(), (String)"V0 Response should have no errors");
        Assertions.assertEquals((int)2, (int)metadataResponseV0.topicMetadata().size(), (String)"V0 Response should have 2 (all) topics");
        MetadataResponse metadataResponseV1 = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponseV1.errors().isEmpty(), (String)"V1 Response should have no errors");
        Assertions.assertEquals((int)2, (int)metadataResponseV1.topicMetadata().size(), (String)"V1 Response should have 2 (all) topics");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicIdsInResponse(String quorum) {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopicWithAssignment(topic1, (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(topic2, (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        MetadataResponse resp1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true, 0, 9).build(), (Option<SocketServer>)new Some((Object)this.anySocketServer()));
        Assertions.assertEquals((int)2, (int)resp1.topicMetadata().size());
        resp1.topicMetadata().forEach(topicMetadata -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
            Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)topicMetadata.topicId());
        });
        MetadataResponse resp2 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true, 10, 10).build(), (Option<SocketServer>)new Some((Object)this.anySocketServer()));
        Assertions.assertEquals((int)2, (int)resp2.topicMetadata().size());
        resp2.topicMetadata().forEach(topicMetadata -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
            Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)topicMetadata.topicId());
            Assertions.assertNotNull((Object)topicMetadata.topicId());
        });
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testPreferredReplica(String quorum) {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        this.createTopicWithAssignment("t1", (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        ((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))).map((Function1 & Serializable & scala.Serializable)index -> this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"t1", (List)Nil$.MODULE$)).asJava(), true).build(), (Option<SocketServer>)new Some((Object)((KafkaBroker)this.brokers().apply(BoxesRunTime.unboxToInt((Object)index))).socketServer())), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)response -> {
            MetadataRequestTest.$anonfun$testPreferredReplica$2(replicaAssignment, response);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testReplicaDownResponse(String quorum) {
        String replicaDownTopic = "replicaDown";
        int replicaCount = 3;
        this.createTopic(replicaDownTopic, 1, replicaCount, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponse = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        KafkaBroker downNode = (KafkaBroker)this.brokers().find((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$1(partitionMetadata, broker))).get();
        downNode.shutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 50000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testReplicaDownResponse$2(this, replicaDownTopic, downNode)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MetadataRequestTest.$anonfun$testReplicaDownResponse$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        MetadataResponse v0MetadataResponse = this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$), true), (short)0), this.sendMetadataRequest$default$2());
        Seq v0BrokerIds = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(v0MetadataResponse.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        Assertions.assertTrue((boolean)v0MetadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertFalse((boolean)v0BrokerIds.contains((Object)BoxesRunTime.boxToInteger((int)downNode.config().brokerId())), (String)"The downed broker should not be in the brokers list");
        Assertions.assertTrue((v0MetadataResponse.topicMetadata().size() == 1 ? 1 : 0) != 0, (String)"Response should have one topic");
        MetadataResponse.PartitionMetadata v0PartitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(v0MetadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        Errors errors = v0PartitionMetadata.error;
        Errors errors2 = Errors.REPLICA_NOT_AVAILABLE;
        Assertions.assertTrue((!(errors != null ? !errors.equals(errors2) : errors2 != null) ? 1 : 0) != 0, (String)"PartitionMetadata should have an error");
        Assertions.assertTrue((v0PartitionMetadata.replicaIds.size() == replicaCount - 1 ? 1 : 0) != 0, (String)new StringBuilder(30).append("Response should have ").append(replicaCount - 1).append(" replicas").toString());
        MetadataResponse v1MetadataResponse = this.sendMetadataRequest(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        Seq v1BrokerIds = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(v1MetadataResponse.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        Assertions.assertTrue((boolean)v1MetadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertFalse((boolean)v1BrokerIds.contains((Object)BoxesRunTime.boxToInteger((int)downNode.config().brokerId())), (String)"The downed broker should not be in the brokers list");
        Assertions.assertEquals((int)1, (int)v1MetadataResponse.topicMetadata().size(), (String)"Response should have one topic");
        MetadataResponse.PartitionMetadata v1PartitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(v1MetadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)v1PartitionMetadata.error, (String)"PartitionMetadata should have no errors");
        Assertions.assertEquals((int)replicaCount, (int)v1PartitionMetadata.replicaIds.size(), (String)new StringBuilder(30).append("Response should have ").append(replicaCount).append(" replicas").toString());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIsrAfterBrokerShutDownAndJoinsBack(String quorum) {
        String topic = "isr-after-broker-shutdown";
        int replicaCount = 3;
        this.createTopic(topic, 1, replicaCount, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        ((KafkaBroker)this.brokers().last()).shutdown();
        ((KafkaBroker)this.brokers().last()).awaitShutdown();
        ((KafkaBroker)this.brokers().last()).startup();
        this.checkIsr$1((Seq)this.brokers(), topic);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAliveBrokersWithNoTopics(String quorum) {
        KafkaBroker brokerToShutdown = this.isKRaftTest() ? (KafkaBroker)this.brokers().last() : (KafkaBroker)((TraversableLike)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$11(x$20)))).last();
        brokerToShutdown.shutdown();
        brokerToShutdown.awaitShutdown();
        this.checkMetadata$1((Seq)this.brokers(), this.brokers().size() - 1);
        brokerToShutdown.startup();
        this.checkMetadata$1((Seq)this.brokers(), this.brokers().size());
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$1(KafkaServer x$1) {
        return x$1.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$2(KafkaServer x$2) {
        return x$2.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$3(MetadataRequestTest $this, KafkaServer controllerServer2$1) {
        MetadataResponse metadataResponse2 = $this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), $this.sendMetadataRequest$default$2());
        return metadataResponse2.controller() != null && controllerServer2$1.dataPlaneRequestProcessor().brokerId() == metadataResponse2.controller().id();
    }

    public static final /* synthetic */ String $anonfun$testControllerId$4() {
        return "Controller id should match the active controller after failover";
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$1(String internalTopic$1, MetadataResponse.TopicMetadata x$3) {
        String string = x$3.topic();
        return !(string != null ? !string.equals(internalTopic$1) : internalTopic$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$2(String notInternalTopic$1, MetadataResponse.TopicMetadata x$4) {
        String string = x$4.topic();
        return !(string != null ? !string.equals(notInternalTopic$1) : notInternalTopic$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplica$2(scala.collection.immutable.Map replicaAssignment$1, MetadataResponse response) {
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)response.topicMetadata().iterator().next();
        Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        Assertions.assertEquals((Object)"t1", (Object)topicMetadata.topic());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.partition()), Buffer$.MODULE$.canBuildFrom())).toSet());
        topicMetadata.partitionMetadata().forEach(partitionMetadata -> {
            Seq assignment = (Seq)replicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)partitionMetadata.partition()));
            Assertions.assertEquals((Object)assignment, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicaIds).asScala());
            Assertions.assertEquals((Object)assignment, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.inSyncReplicaIds).asScala());
            Assertions.assertEquals(Optional.of(assignment.head()), (Object)partitionMetadata.leaderId);
        });
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$1(MetadataResponse.PartitionMetadata partitionMetadata$1, KafkaBroker broker) {
        int serverId = broker.dataPlaneRequestProcessor().brokerId();
        Optional leaderId = partitionMetadata$1.leaderId;
        Buffer replicaIds = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata$1.replicaIds).asScala();
        return leaderId.isPresent() && !BoxesRunTime.equals(leaderId.get(), (Object)BoxesRunTime.boxToInteger((int)serverId)) && replicaIds.contains((Object)BoxesRunTime.boxToInteger((int)serverId));
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$3(KafkaBroker downNode$1, Node x$9) {
        return x$9.id() == downNode$1.dataPlaneRequestProcessor().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$2(MetadataRequestTest $this, String replicaDownTopic$1, KafkaBroker downNode$1) {
        MetadataResponse response = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)replicaDownTopic$1, (List)Nil$.MODULE$)).asJava(), true).build(), $this.sendMetadataRequest$default$2());
        return !((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response.brokers()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$3(downNode$1, x$9)));
    }

    public static final /* synthetic */ String $anonfun$testReplicaDownResponse$4() {
        return "Replica was not found down";
    }

    public static final /* synthetic */ boolean $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(KafkaBroker x$12) {
        BrokerState brokerState = x$12.brokerState();
        BrokerState brokerState2 = BrokerState.NOT_RUNNING;
        return brokerState == null ? brokerState2 != null : !brokerState.equals(brokerState2);
    }

    public static final /* synthetic */ int $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$2(KafkaBroker x$13) {
        return x$13.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(Object x) {
        return BoxesRunTime.unboxToInt((Object)x);
    }

    public static final /* synthetic */ boolean $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4(MetadataRequestTest $this, String topic$1, KafkaBroker broker$1, ObjectRef actualIsr$1, scala.collection.immutable.Set expectedIsr$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic$1, (List)Nil$.MODULE$)).asJava(), false).build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker$1.config().brokerId())));
        Option firstPartitionMetadata = ((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).headOption().flatMap((Function1 & Serializable & scala.Serializable)x$14 -> ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(x$14.partitionMetadata()).asScala()).headOption());
        actualIsr$1.elem = (scala.collection.immutable.Set)firstPartitionMetadata.map((Function1 & Serializable & scala.Serializable)partitionMetadata -> ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.inSyncReplicaIds).asScala()).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(x)), Buffer$.MODULE$.canBuildFrom())).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        scala.collection.immutable.Set set = expectedIsr$1;
        scala.collection.immutable.Set set2 = (scala.collection.immutable.Set)actualIsr$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$9(KafkaBroker broker$1, scala.collection.immutable.Set expectedIsr$1, ObjectRef actualIsr$1) {
        return new StringBuilder(77).append("Topic metadata not updated correctly in broker ").append(broker$1).append("\n").append("Expected ISR: ").append(expectedIsr$1).append(" \n").append("Actual ISR : ").append((scala.collection.immutable.Set)actualIsr$1.elem).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$3(MetadataRequestTest $this, String topic$1, scala.collection.immutable.Set expectedIsr$1, KafkaBroker broker) {
        ObjectRef actualIsr = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4($this, topic$1, broker, actualIsr, expectedIsr$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$9(broker, expectedIsr$1, actualIsr));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private final void checkIsr$1(Seq brokers, String topic) {
        Seq activeBrokers = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(x$12)));
        scala.collection.immutable.Set expectedIsr = ((TraversableOnce)activeBrokers.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$2(x$13)), Seq$.MODULE$.canBuildFrom())).toSet();
        activeBrokers.foreach((Function1 & Serializable & scala.Serializable)broker -> {
            MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$3(this, topic, expectedIsr, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$1(MetadataRequestTest $this, ObjectRef response$1, int expectedBrokersCount$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)$this.anySocketServer()));
        response$1.elem = new Some((Object)metadataResponse);
        return metadataResponse.brokers().size() == expectedBrokersCount$1;
    }

    public static final /* synthetic */ String $anonfun$testAliveBrokersWithNoTopics$2(int expectedBrokersCount$1, ObjectRef response$1) {
        return new StringBuilder(33).append("Expected ").append(expectedBrokersCount$1).append(" brokers, but there are ").append(((MetadataResponse)((Option)response$1.elem).get()).brokers().size()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$4(KafkaBroker x$16) {
        BrokerState brokerState = x$16.brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$6(MetadataRequestTest $this, KafkaBroker broker$2, Seq brokersSorted$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker$2.config().brokerId())));
        Seq brokers = (Seq)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.brokers()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.id()), (Ordering)Ordering.Int$.MODULE$);
        Seq topicMetadata = (Seq)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$18 -> x$18.topic(), (Ordering)Ordering.String$.MODULE$);
        Seq seq = brokersSorted$1;
        if (!(seq != null ? !seq.equals(brokers) : brokers != null)) {
            Object object = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$19 -> x$19.topic(), (Ordering)Ordering.String$.MODULE$);
            if (!(object != null ? !object.equals(topicMetadata) : topicMetadata != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testAliveBrokersWithNoTopics$10() {
        return "Topic metadata not updated correctly";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAliveBrokersWithNoTopics$5(MetadataRequestTest $this, Seq brokersSorted$1, KafkaBroker broker) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$6($this, broker, brokersSorted$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMetadata$1(Seq brokers, int expectedBrokersCount) {
        ObjectRef response = ObjectRef.create((Object)None$.MODULE$);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$1(this, response, expectedBrokersCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$2(expectedBrokersCount, response));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Seq brokersSorted = (Seq)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((MetadataResponse)((Option)response.elem).get()).brokers()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.id()), (Ordering)Ordering.Int$.MODULE$);
        ((IterableLike)brokers.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$4(x$16)))).foreach((Function1 & Serializable & scala.Serializable)broker -> {
            MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$5(this, brokersSorted, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$11(KafkaServer x$20) {
        return x$20.kafkaController().isActive();
    }
}

