/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.KafkaConfig;
import kafka.server.NodeToControllerQueueItem;
import kafka.server.NodeToControllerRequestThread;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$TestControllerRequestCompletionHandler$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.EnvelopeResponseData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]4Aa\u0004\t\u0001+!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0005C!)Q\u0007\u0001C\u0005m!)q\u0007\u0001C\u0001q!)q\t\u0001C\u0001q!)\u0011\n\u0001C\u0001q!)1\n\u0001C\u0001q!)Q\n\u0001C\u0001q!)q\n\u0001C\u0001q!)\u0011\u000b\u0001C\u0001q!)1\u000b\u0001C\u0001q!)Q\u000b\u0001C\u0001q!)q\u000b\u0001C\u00051\"91\u000eAI\u0001\n\u0013a'!\t(pI\u0016$vnQ8oiJ|G\u000e\\3s%\u0016\fX/Z:u)\"\u0014X-\u00193UKN$(BA\t\u0013\u0003\u0019\u0019XM\u001d<fe*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002!\u0005q1m\u001c8ue>dG.\u001a:J]\u001a|GC\u0001\u0012&!\ty2%\u0003\u0002%!\t)2i\u001c8ue>dG.\u001a:J]\u001a|'/\\1uS>t\u0007\"\u0002\u0014\u0003\u0001\u00049\u0013\u0001\u00028pI\u0016\u00042a\u0006\u0015+\u0013\tI\u0003D\u0001\u0004PaRLwN\u001c\t\u0003WMj\u0011\u0001\f\u0006\u0003[9\naaY8n[>t'BA\n0\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\n\u0005Qb#\u0001\u0002(pI\u0016\f1#Z7qif\u001cuN\u001c;s_2dWM]%oM>,\u0012AI\u0001,i\u0016\u001cHOU3uef$\u0016.\\3pkR<\u0006.\u001b7f\u0007>tGO]8mY\u0016\u0014hj\u001c;Bm\u0006LG.\u00192mKR\t\u0011\b\u0005\u0002\u0018u%\u00111\b\u0007\u0002\u0005+:LG\u000f\u000b\u0002\u0005{A\u0011a(R\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0004CBL'B\u0001\"D\u0003\u001dQW\u000f]5uKJT!\u0001R\u0019\u0002\u000b),h.\u001b;\n\u0005\u0019{$\u0001\u0002+fgR\f\u0001\u0003^3tiJ+\u0017/^3tiN\u001cVM\u001c;)\u0005\u0015i\u0014!\u0006;fgR\u001cuN\u001c;s_2dWM]\"iC:<W\r\u001a\u0015\u0003\ru\n\u0011\u0003^3ti:{GoQ8oiJ|G\u000e\\3sQ\t9Q(\u0001\u0016uKN$XI\u001c<fY>\u0004XMU3ta>t7/Z,ji\"tu\u000e^\"p]R\u0014x\u000e\u001c7fe\u0016\u0013(o\u001c:)\u0005!i\u0014\u0001\u0005;fgR\u0014V\r\u001e:z)&lWm\\;uQ\tIQ(\u0001\u0010uKN$XK\\:vaB|'\u000f^3e-\u0016\u00148/[8o\u0011\u0006tG\r\\5oO\"\u0012!\"P\u0001$i\u0016\u001cH/Q;uQ\u0016tG/[2bi&|g.\u0012=dKB$\u0018n\u001c8IC:$G.\u001b8hQ\tYQ(\u0001\u000buKN$H\u000b\u001b:fC\u0012tu\u000e^*uCJ$X\r\u001a\u0015\u0003\u0019u\n\u0011\u0002]8mYVsG/\u001b7\u0015\teJfL\u001a\u0005\u000656\u0001\raW\u0001\u000ee\u0016\fX/Z:u)\"\u0014X-\u00193\u0011\u0005}a\u0016BA/\u0011\u0005uqu\u000eZ3U_\u000e{g\u000e\u001e:pY2,'OU3rk\u0016\u001cH\u000f\u00165sK\u0006$\u0007\"B0\u000e\u0001\u0004\u0001\u0017!C2p]\u0012LG/[8o!\r9\u0012mY\u0005\u0003Eb\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u0005]!\u0017BA3\u0019\u0005\u001d\u0011un\u001c7fC:DqaZ\u0007\u0011\u0002\u0003\u0007\u0001.\u0001\u0006nCb\u0014V\r\u001e:jKN\u0004\"aF5\n\u0005)D\"aA%oi\u0006\u0019\u0002o\u001c7m+:$\u0018\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\tQN\u000b\u0002i].\nq\u000e\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003ib\t!\"\u00198o_R\fG/[8o\u0013\t1\u0018OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class NodeToControllerRequestThreadTest {
    private ControllerInformation controllerInfo(Option<Node> node) {
        return new ControllerInformation(node, new ListenerName(""), SecurityProtocol.PLAINTEXT, "", true);
    }

    private ControllerInformation emptyControllerInfo() {
        return this.controllerInfo((Option<Node>)None$.MODULE$);
    }

    @Test
    public void testRetryTimeoutWhileControllerNotAvailable() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Mockito.when((Object)controllerNodeProvider.getControllerInfo()).thenReturn((Object)this.emptyControllerInfo());
        int retryTimeoutMs = 30000;
        NodeToControllerRequestThread testRequestThread = new NodeToControllerRequestThread((KafkaClient)mockClient, true, (Function1 & Serializable & scala.Serializable)x$1 -> mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", (long)retryTimeoutMs);
        testRequestThread.started_$eq(true);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler((Option<AbstractResponse>)None$.MODULE$);
        NodeToControllerQueueItem queueItem = new NodeToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        testRequestThread.doWork();
        Assertions.assertEquals((int)1, (int)testRequestThread.queueSize());
        time.sleep((long)retryTimeoutMs);
        testRequestThread.doWork();
        Assertions.assertEquals((int)0, (int)testRequestThread.queueSize());
        Assertions.assertTrue((boolean)completionHandler.timedOut().get());
    }

    @Test
    public void testRequestsSent() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        int controllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node activeController = new Node(controllerId, "host", 1234);
        Mockito.when((Object)controllerNodeProvider.getControllerInfo()).thenReturn((Object)this.controllerInfo((Option<Node>)new Some((Object)activeController)));
        MetadataResponse expectedResponse = RequestTestUtils.metadataUpdateWith((int)2, Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        NodeToControllerRequestThread testRequestThread = new NodeToControllerRequestThread((KafkaClient)mockClient, true, (Function1 & Serializable & scala.Serializable)x$2 -> mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.started_$eq(true);
        mockClient.prepareResponse((AbstractResponse)expectedResponse);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler((Option<AbstractResponse>)new Some((Object)expectedResponse));
        NodeToControllerQueueItem queueItem = new NodeToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        Assertions.assertEquals((int)1, (int)testRequestThread.queueSize());
        testRequestThread.doWork();
        testRequestThread.doWork();
        Assertions.assertEquals((int)0, (int)testRequestThread.queueSize());
        Assertions.assertTrue((boolean)completionHandler.completed().get());
    }

    @Test
    public void testControllerChanged() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        int oldControllerId = 1;
        int newControllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node oldController = new Node(oldControllerId, "host1", 1234);
        Node newController = new Node(newControllerId, "host2", 1234);
        Mockito.when((Object)controllerNodeProvider.getControllerInfo()).thenReturn((Object)this.controllerInfo((Option<Node>)new Some((Object)oldController)), (Object[])new ControllerInformation[]{this.controllerInfo((Option<Node>)new Some((Object)newController))});
        MetadataResponse expectedResponse = RequestTestUtils.metadataUpdateWith((int)3, Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        NodeToControllerRequestThread testRequestThread = new NodeToControllerRequestThread((KafkaClient)mockClient, true, (Function1 & Serializable & scala.Serializable)x$3 -> mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.started_$eq(true);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler((Option<AbstractResponse>)new Some((Object)expectedResponse));
        NodeToControllerQueueItem queueItem = new NodeToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        mockClient.prepareResponse((AbstractResponse)expectedResponse);
        testRequestThread.doWork();
        Assertions.assertFalse((boolean)completionHandler.completed().get());
        mockClient.setUnreachable(oldController, time.milliseconds() + 5000L);
        testRequestThread.doWork();
        testRequestThread.doWork();
        testRequestThread.doWork();
        Assertions.assertTrue((boolean)completionHandler.completed().get());
    }

    @Test
    public void testNotController() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        int oldControllerId = 1;
        int newControllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        int port = 1234;
        Node oldController = new Node(oldControllerId, "host1", port);
        Node newController = new Node(newControllerId, "host2", port);
        Mockito.when((Object)controllerNodeProvider.getControllerInfo()).thenReturn((Object)this.controllerInfo((Option<Node>)new Some((Object)oldController)), (Object[])new ControllerInformation[]{this.controllerInfo((Option<Node>)new Some((Object)newController))});
        MetadataResponse responseWithNotControllerError = RequestTestUtils.metadataUpdateWith((String)"cluster1", (int)2, Collections.singletonMap("a", Errors.NOT_CONTROLLER), Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        MetadataResponse expectedResponse = RequestTestUtils.metadataUpdateWith((int)3, Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        NodeToControllerRequestThread testRequestThread = new NodeToControllerRequestThread((KafkaClient)mockClient, true, (Function1 & Serializable & scala.Serializable)x$4 -> mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.started_$eq(true);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler((Option<AbstractResponse>)new Some((Object)expectedResponse));
        NodeToControllerQueueItem queueItem = new NodeToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData().setAllowAutoTopicCreation(true)), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        testRequestThread.doWork();
        Node oldBrokerNode = new Node(oldControllerId, "host1", port);
        Assertions.assertEquals((Object)new Some((Object)oldBrokerNode), (Object)testRequestThread.activeControllerAddress());
        mockClient.prepareResponse(body -> body instanceof MetadataRequest && ((MetadataRequest)body).allowAutoTopicCreation(), (AbstractResponse)responseWithNotControllerError);
        testRequestThread.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)testRequestThread.activeControllerAddress());
        testRequestThread.doWork();
        mockClient.prepareResponse((AbstractResponse)expectedResponse);
        testRequestThread.doWork();
        Node newControllerNode = new Node(newControllerId, "host2", port);
        Assertions.assertEquals((Object)new Some((Object)newControllerNode), (Object)testRequestThread.activeControllerAddress());
        Assertions.assertTrue((boolean)completionHandler.completed().get());
    }

    @Test
    public void testEnvelopeResponseWithNotControllerError() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        int oldControllerId = 1;
        int newControllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        mockClient.setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.ENVELOPE.id, (short)((short)0), (short)((short)0)));
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        int port = 1234;
        Node oldController = new Node(oldControllerId, "host1", port);
        Node newController = new Node(newControllerId, "host2", port);
        Mockito.when((Object)controllerNodeProvider.getControllerInfo()).thenReturn((Object)this.controllerInfo((Option<Node>)new Some((Object)oldController)), (Object[])new ControllerInformation[]{this.controllerInfo((Option<Node>)new Some((Object)newController))});
        EnvelopeResponse envelopeResponseWithNotControllerError = new EnvelopeResponse(new EnvelopeResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()));
        MetadataResponse expectedResponse = RequestTestUtils.metadataUpdateWith((int)3, Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        NodeToControllerRequestThread testRequestThread = new NodeToControllerRequestThread((KafkaClient)mockClient, true, (Function1 & Serializable & scala.Serializable)x$5 -> mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.started_$eq(true);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler((Option<AbstractResponse>)new Some((Object)expectedResponse));
        KafkaPrincipal kafkaPrincipal = new KafkaPrincipal("User", "principal", true);
        DefaultKafkaPrincipalBuilder kafkaPrincipalBuilder = new DefaultKafkaPrincipalBuilder(null, null);
        EnvelopeRequest.Builder envelopeRequestBuilder = new EnvelopeRequest.Builder(ByteBuffer.allocate(0), kafkaPrincipalBuilder.serialize(kafkaPrincipal), "client-address".getBytes());
        NodeToControllerQueueItem queueItem = new NodeToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)envelopeRequestBuilder, (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        testRequestThread.doWork();
        Node oldBrokerNode = new Node(oldControllerId, "host1", port);
        Assertions.assertEquals((Object)new Some((Object)oldBrokerNode), (Object)testRequestThread.activeControllerAddress());
        mockClient.prepareResponse(body -> body instanceof EnvelopeRequest, (AbstractResponse)envelopeResponseWithNotControllerError);
        testRequestThread.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)testRequestThread.activeControllerAddress());
        testRequestThread.doWork();
        mockClient.prepareResponse((AbstractResponse)expectedResponse);
        testRequestThread.doWork();
        Node newControllerNode = new Node(newControllerId, "host2", port);
        Assertions.assertEquals((Object)new Some((Object)newControllerNode), (Object)testRequestThread.activeControllerAddress());
        Assertions.assertTrue((boolean)completionHandler.completed().get());
    }

    @Test
    public void testRetryTimeout() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        int controllerId = 1;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node controller = new Node(controllerId, "host1", 1234);
        Mockito.when((Object)controllerNodeProvider.getControllerInfo()).thenReturn((Object)this.controllerInfo((Option<Node>)new Some((Object)controller)));
        int retryTimeoutMs = 30000;
        MetadataResponse responseWithNotControllerError = RequestTestUtils.metadataUpdateWith((String)"cluster1", (int)2, Collections.singletonMap("a", Errors.NOT_CONTROLLER), Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        NodeToControllerRequestThread testRequestThread = new NodeToControllerRequestThread((KafkaClient)mockClient, true, (Function1 & Serializable & scala.Serializable)x$6 -> mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", (long)retryTimeoutMs);
        testRequestThread.started_$eq(true);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler(TestUtils$TestControllerRequestCompletionHandler$.MODULE$.$lessinit$greater$default$1());
        NodeToControllerQueueItem queueItem = new NodeToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData().setAllowAutoTopicCreation(true)), (ControllerRequestCompletionHandler)completionHandler);
        testRequestThread.enqueue(queueItem);
        testRequestThread.doWork();
        time.sleep((long)retryTimeoutMs);
        mockClient.prepareResponse(body -> body instanceof MetadataRequest && ((MetadataRequest)body).allowAutoTopicCreation(), (AbstractResponse)responseWithNotControllerError);
        testRequestThread.doWork();
        Assertions.assertTrue((boolean)completionHandler.timedOut().get());
    }

    @Test
    public void testUnsupportedVersionHandling() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        int controllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node activeController = new Node(controllerId, "host", 1234);
        Mockito.when((Object)controllerNodeProvider.getControllerInfo()).thenReturn((Object)this.controllerInfo((Option<Node>)new Some((Object)activeController)));
        AtomicReference callbackResponse = new AtomicReference();
        ControllerRequestCompletionHandler completionHandler = new ControllerRequestCompletionHandler(null, callbackResponse){
            private final AtomicReference callbackResponse$1;

            public void onTimeout() {
                Assertions.fail((String)"Unexpected timeout exception");
            }

            public void onComplete(ClientResponse response) {
                this.callbackResponse$1.set(response);
            }
            {
                this.callbackResponse$1 = callbackResponse$1;
            }
        };
        NodeToControllerQueueItem queueItem = new NodeToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), completionHandler);
        mockClient.prepareUnsupportedVersionResponse(request -> {
            ApiKeys apiKeys = request.apiKey();
            ApiKeys apiKeys2 = ApiKeys.METADATA;
            return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
        });
        NodeToControllerRequestThread testRequestThread = new NodeToControllerRequestThread((KafkaClient)mockClient, true, (Function1 & Serializable & scala.Serializable)x$7 -> mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.started_$eq(true);
        testRequestThread.enqueue(queueItem);
        int pollUntil_maxRetries = this.pollUntil$default$3();
        int pollUntil_tries = 0;
        do {
            testRequestThread.doWork();
        } while (!NodeToControllerRequestThreadTest.$anonfun$testUnsupportedVersionHandling$3(callbackResponse) && ++pollUntil_tries < pollUntil_maxRetries);
        if (!NodeToControllerRequestThreadTest.$anonfun$testUnsupportedVersionHandling$3(callbackResponse)) {
            Assertions.fail((String)new StringBuilder(47).append("Condition failed to be met after polling ").append(pollUntil_tries).append(" times").toString());
        }
        Assertions.assertNotNull((Object)((ClientResponse)callbackResponse.get()).versionMismatch());
    }

    @Test
    public void testAuthenticationExceptionHandling() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        int controllerId = 2;
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Node activeController = new Node(controllerId, "host", 1234);
        Mockito.when((Object)controllerNodeProvider.getControllerInfo()).thenReturn((Object)this.controllerInfo((Option<Node>)new Some((Object)activeController)));
        AtomicReference callbackResponse = new AtomicReference();
        ControllerRequestCompletionHandler completionHandler = new ControllerRequestCompletionHandler(null, callbackResponse){
            private final AtomicReference callbackResponse$2;

            public void onTimeout() {
                Assertions.fail((String)"Unexpected timeout exception");
            }

            public void onComplete(ClientResponse response) {
                this.callbackResponse$2.set(response);
            }
            {
                this.callbackResponse$2 = callbackResponse$2;
            }
        };
        NodeToControllerQueueItem queueItem = new NodeToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), completionHandler);
        mockClient.createPendingAuthenticationError(activeController, 50L);
        NodeToControllerRequestThread testRequestThread = new NodeToControllerRequestThread((KafkaClient)mockClient, true, (Function1 & Serializable & scala.Serializable)x$8 -> mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        testRequestThread.started_$eq(true);
        testRequestThread.enqueue(queueItem);
        int pollUntil_maxRetries = this.pollUntil$default$3();
        int pollUntil_tries = 0;
        do {
            testRequestThread.doWork();
        } while (!NodeToControllerRequestThreadTest.$anonfun$testAuthenticationExceptionHandling$2(callbackResponse) && ++pollUntil_tries < pollUntil_maxRetries);
        if (!NodeToControllerRequestThreadTest.$anonfun$testAuthenticationExceptionHandling$2(callbackResponse)) {
            Assertions.fail((String)new StringBuilder(47).append("Condition failed to be met after polling ").append(pollUntil_tries).append(" times").toString());
        }
        Assertions.assertNotNull((Object)((ClientResponse)callbackResponse.get()).authenticationException());
    }

    @Test
    public void testThreadNotStarted() {
        MockTime time = new MockTime();
        KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        MockClient mockClient = new MockClient((Time)time, metadata);
        ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
        Mockito.when((Object)controllerNodeProvider.getControllerInfo()).thenReturn((Object)this.emptyControllerInfo());
        NodeToControllerRequestThread testRequestThread = new NodeToControllerRequestThread((KafkaClient)mockClient, true, (Function1 & Serializable & scala.Serializable)x$9 -> mockClient, new ManualMetadataUpdater(), controllerNodeProvider, config, (Time)time, "", Long.MAX_VALUE);
        TestUtils.TestControllerRequestCompletionHandler completionHandler = new TestUtils.TestControllerRequestCompletionHandler((Option<AbstractResponse>)None$.MODULE$);
        NodeToControllerQueueItem queueItem = new NodeToControllerQueueItem(time.milliseconds(), (AbstractRequest.Builder)new MetadataRequest.Builder(new MetadataRequestData()), (ControllerRequestCompletionHandler)completionHandler);
        Assertions.assertThrows(IllegalStateException.class, () -> testRequestThread.enqueue(queueItem));
        Assertions.assertEquals((int)0, (int)testRequestThread.queueSize());
    }

    private void pollUntil(NodeToControllerRequestThread requestThread, Function0<Object> condition, int maxRetries) {
        int tries = 0;
        do {
            requestThread.doWork();
        } while (!condition.apply$mcZ$sp() && ++tries < maxRetries);
        if (!condition.apply$mcZ$sp()) {
            Assertions.fail((String)new StringBuilder(47).append("Condition failed to be met after polling ").append(tries).append(" times").toString());
            return;
        }
    }

    private int pollUntil$default$3() {
        return 10;
    }

    public static final /* synthetic */ boolean $anonfun$testUnsupportedVersionHandling$3(AtomicReference callbackResponse$1) {
        return callbackResponse$1.get() != null;
    }

    public static final /* synthetic */ boolean $anonfun$testAuthenticationExceptionHandling$2(AtomicReference callbackResponse$2) {
        return callbackResponse$2.get() != null;
    }
}

