/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.LocalLeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaAlterLogDirsThread;
import kafka.server.ReplicaAlterLogDirsThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.Truncating$;
import kafka.server.metadata.ZkMetadataCache;
import kafka.server.metadata.ZkMetadataCache$;
import kafka.utils.DelayedItem;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.MapLike;
import scala.jdk.CollectionConverters$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}e\u0001B\u0016-\u0001EBQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004J\u0001\u0001\u0006IA\u0010\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003>\u0011\u0019Y\u0005\u0001)A\u0005}!9A\n\u0001b\u0001\n\u0013i\u0005BB)\u0001A\u0003%a\nC\u0004S\u0001\t\u0007I\u0011B*\t\r\u0011\u0004\u0001\u0015!\u0003U\u0011\u001d)\u0007A1A\u0005\n\u0019Da\u0001\u001b\u0001!\u0002\u00139\u0007bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007]\u0002\u0001\u000b\u0011B6\t\u000f=\u0004!\u0019!C\u0005a\"1A\u000f\u0001Q\u0001\nEDq!\u001e\u0001C\u0002\u0013%a\u000fC\u0004\u0002\u0010\u0001\u0001\u000b\u0011B<\t\u0013\u0005E\u0001A1A\u0005\n\u0005M\u0001\u0002CA\u0011\u0001\u0001\u0006I!!\u0006\t\u0013\u0005\r\u0002A1A\u0005\n\u0005\u0015\u0002\u0002CA\u001a\u0001\u0001\u0006I!a\n\t\u000f\u0005U\u0002\u0001\"\u0003\u00028!I\u00111\u000b\u0001\u0012\u0002\u0013%\u0011Q\u000b\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\tY\t\u0001C\u0001\u0003[Bq!a$\u0001\t\u0003\ti\u0007C\u0004\u0002\u0014\u0002!I!!&\t\u000f\u0005-\u0007\u0001\"\u0001\u0002n!9\u0011q\u001a\u0001\u0005\u0002\u00055\u0004bBAj\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\u0011i\u0002\u0001C\u0001\u0003[BqA!\t\u0001\t\u0003\ti\u0007C\u0004\u0003&\u0001!\t!!\u001c\t\u000f\t%\u0002\u0001\"\u0001\u0002n!9!Q\u0006\u0001\u0005\u0002\u00055\u0004b\u0002B\u0019\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0005k\u0001A\u0011AA7\u0011\u001d\u0011I\u0004\u0001C\u0001\u0003[BqA!\u0010\u0001\t\u0003\ti\u0007C\u0004\u0003B\u0001!\tAa\u0011\t\u000f\t5\u0004\u0001\"\u0001\u0003p\ti\"+\u001a9mS\u000e\f\u0017\t\u001c;fe2{w\rR5sgRC'/Z1e)\u0016\u001cHO\u0003\u0002.]\u000511/\u001a:wKJT\u0011aL\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0007\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0002\"a\u000f\u0001\u000e\u00031\nA\u0001^\u0019qaU\ta\b\u0005\u0002@\u000f6\t\u0001I\u0003\u0002B\u0005\u000611m\\7n_:T!aL\"\u000b\u0005\u0011+\u0015AB1qC\u000eDWMC\u0001G\u0003\ry'oZ\u0005\u0003\u0011\u0002\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0003ucA\u0004\u0004%\u0001\u0003ucA\f\u0014!\u0002;2aF\u0002\u0013a\u0002;pa&\u001c\u0017\nZ\u000b\u0002\u001dB\u0011qhT\u0005\u0003!\u0002\u0013A!V;jI\u0006AAo\u001c9jG&#\u0007%\u0001\u0005u_BL7-\u00133t+\u0005!\u0006\u0003B+[9:k\u0011A\u0016\u0006\u0003/b\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005e#\u0014AC2pY2,7\r^5p]&\u00111L\u0016\u0002\u0004\u001b\u0006\u0004\bCA/c\u001b\u0005q&BA0a\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\fAA[1wC&\u00111M\u0018\u0002\u0007'R\u0014\u0018N\\4\u0002\u0013Q|\u0007/[2JIN\u0004\u0013A\u0003;pa&\u001cg*Y7fgV\tq\r\u0005\u0003V5:c\u0016a\u0003;pa&\u001cg*Y7fg\u0002\na\u0001^5ecA\u0004T#A6\u0011\u0005}b\u0017BA7A\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.A\u0004uS\u0012\f\u0004\u000f\r\u0011\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001cX#A9\u0011\u0005m\u0012\u0018BA:-\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/A\tgC&dW\r\u001a)beRLG/[8og\u0002\nq\u0002]1si&$\u0018n\u001c8Ti\u0006$Xm]\u000b\u0002oB\u0019\u0001p_?\u000e\u0003eT!A\u001f1\u0002\tU$\u0018\u000e\\\u0005\u0003yf\u0014A\u0001T5tiB\u0019a0!\u0003\u000f\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001!\u0002\u000f5,7o]1hK&!\u0011qAA\u0001\u0003e)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR$\u0015\r^1\n\t\u0005-\u0011Q\u0002\u0002\u001d+B$\u0017\r^3NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0015\u0011\t9!!\u0001\u0002!A\f'\u000f^5uS>t7\u000b^1uKN\u0004\u0013!F;qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f^\u000b\u0003\u0003+\u0001B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037\u0001\u0015\u0001\u0003:fcV,7\u000f^:\n\t\u0005}\u0011\u0011\u0004\u0002\u0016+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\u0003Y)\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u0004\u0013!D7fi\u0006$\u0017\r^1DC\u000eDW-\u0006\u0002\u0002(A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.1\n\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003c\tYCA\b[W6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00039iW\r^1eCR\f7)Y2iK\u0002\n\u0011#\u001b8ji&\fGNR3uG\"\u001cF/\u0019;f)\u0019\tI$a\u0010\u0002JA\u00191(a\u000f\n\u0007\u0005uBFA\tJ]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016Dq!!\u0011\u0017\u0001\u0004\t\u0019%A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bcA\u001a\u0002F%\u0019\u0011q\t\u001b\u0003\t1{gn\u001a\u0005\n\u0003\u00172\u0002\u0013!a\u0001\u0003\u001b\n1\u0002\\3bI\u0016\u0014X\t]8dQB\u00191'a\u0014\n\u0007\u0005ECGA\u0002J]R\f1$\u001b8ji&\fGNR3uG\"\u001cF/\u0019;fI\u0011,g-Y;mi\u0012\u0012TCAA,U\u0011\ti%!\u0017,\u0005\u0005m\u0003\u0003BA/\u0003Oj!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001a5\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\nyFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAf\u001d5pk2$gj\u001c;BI\u0012\u0004\u0016M\u001d;ji&|g.\u00134GkR,(/\u001a'pO&\u001bhj\u001c;EK\u001aLg.\u001a3\u0015\u0005\u0005=\u0004cA\u001a\u0002r%\u0019\u00111\u000f\u001b\u0003\tUs\u0017\u000e\u001e\u0015\u00041\u0005]\u0004\u0003BA=\u0003\u000fk!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0004CBL'\u0002BAA\u0003\u0007\u000bqA[;qSR,'OC\u0002\u0002\u0006\u0016\u000bQA[;oSRLA!!#\u0002|\t!A+Z:u\u00031\u001a\bn\\;mIV\u0003H-\u0019;f\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u00114uKJ4UM\\2fI\u0016\u0003xn\u00195FeJ|'\u000fK\u0002\u001a\u0003o\nae\u001d5pk2$'+\u001a9mC\u000e,7)\u001e:sK:$Hj\\4ESJ<\u0006.\u001a8DCV<\u0007\u000e^+qQ\rQ\u0012qO\u0001\u0018kB$\u0017\r^3SK\u0006\u001c8/[4o[\u0016tGo\u0015;bi\u0016$\u0002\"a&\u0002\u001e\u0006\u001d\u00161\u0016\t\u0006g\u0005e\u0015qN\u0005\u0004\u00037#$AB(qi&|g\u000eC\u0004\u0002 n\u0001\r!!)\u0002\rQD'/Z1e!\rY\u00141U\u0005\u0004\u0003Kc#!\u0007*fa2L7-Y!mi\u0016\u0014Hj\\4ESJ\u001cH\u000b\u001b:fC\u0012Dq!!+\u001c\u0001\u0004\ti%A\u0006qCJ$\u0018\u000e^5p]&#\u0007bBAW7\u0001\u0007\u0011qV\u0001\t]\u0016<8\u000b^1uKB!\u0011\u0011WAc\u001d\u0011\t\u0019,!1\u000f\t\u0005U\u0016q\u0018\b\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111\u0018\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0013BA\u0017/\u0013\r\t\u0019\rL\u0001\u001a%\u0016\u0004H.[2b\u00032$XM\u001d'pO\u0012K'o\u001d+ie\u0016\fG-\u0003\u0003\u0002H\u0006%'!\u0005*fCN\u001c\u0018n\u001a8nK:$8\u000b^1uK*\u0019\u00111\u0019\u0017\u0002!NDw.\u001e7e%\u0016\u0004H.Y2f\u0007V\u0014(/\u001a8u\u0019><G)\u001b:XQ\u0016t7)Y;hQR,\u0006oV5uQ\u00063G/\u001a:BgNLwM\\7f]R\u0014V-];fgRD\u0015m\u001d\"fK:\u001cu.\u001c9mKR,G\rK\u0002\u001d\u0003o\n\u0001i\u001d5pk2$'+\u001a<feR\fe._*dQ\u0016$W\u000f\\3e\u0003N\u001c\u0018n\u001a8nK:$(+Z9vKN$\u0018JZ!tg&<g.\\3oi&\u001b8)\u00198dK2dW\r\u001a\u0015\u0004;\u0005]\u0014!P:i_VdGMU3wKJ$(+Z1tg&<g.\\3oiN4uN]%oG>l\u0007\u000f\\3uK\u001a+H/\u001e:f%\u0016\u0004H.[2b!J|Wn\u001c;j_:\u001c\bf\u0001\u0010\u0002x\u00059Rn\\2l\r\u0016$8\r\u001b$s_6\u001cUO\u001d:f]Rdun\u001a\u000b\r\u0003_\nY.a8\u0002r\u0006m(Q\u0001\u0005\u0007\u0003;|\u0002\u0019A6\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007bBAq?\u0001\u0007\u00111]\u0001\fe\u0016\fX/Z:u\t\u0006$\u0018\r\u0005\u0003\u0002f\u0006-h\u0002BA\f\u0003OLA!!;\u0002\u001a\u0005aa)\u001a;dQJ+\u0017/^3ti&!\u0011Q^Ax\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*!\u0011\u0011^A\r\u0011\u001d\t\u0019p\ba\u0001\u0003k\faaY8oM&<\u0007cA\u001e\u0002x&\u0019\u0011\u0011 \u0017\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\u0003{|\u0002\u0019AA\u0000\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u00042a\u000fB\u0001\u0013\r\u0011\u0019\u0001\f\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u001d\u00119a\ba\u0001\u0005\u0013\tAB]3ta>t7/\u001a#bi\u0006\u0004BAa\u0003\u0003\u001a5\u0011!Q\u0002\u0006\u0005\u0005\u001f\u0011\t\"A\u0002m_\u001eTAAa\u0005\u0003\u0016\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0005/\u0011\u0015aB:u_J\fw-Z\u0005\u0005\u00057\u0011iA\u0001\nGKR\u001c\u0007\u000eU1si&$\u0018n\u001c8ECR\f\u0017AI5tgV,7/\u00129pG\"\u0014V-];fgR4%o\\7M_\u000e\fGNU3qY&\u001c\u0017\rK\u0002!\u0003o\nQHZ3uG\",\u0005o\\2ig\u001a\u0013x.\u001c'fC\u0012,'o\u00155pk2$\u0007*\u00198eY\u0016,\u0005pY3qi&|gN\u0012:p[\u001e+G\u000fT8dC2\u0014V\r\u001d7jG\u0006D3!IA<\u0003u\u0019\bn\\;mIR\u0013XO\\2bi\u0016$vNU3qY&\u001c\u0017m\u00144gg\u0016$\bf\u0001\u0012\u0002x\u0005i3\u000f[8vY\u0012$&/\u001e8dCR,Gk\\#oI>3gm]3u\u001f\u001ad\u0015M]4fgR\u001cu.\\7p]\u0016\u0003xn\u00195)\u0007\r\n9(A!tQ>,H\u000e\u001a+sk:\u001c\u0017\r^3U_&s\u0017\u000e^5bY\u001a+Go\u00195PM\u001a\u001cX\r^%g%\u0016\u0004H.[2b%\u0016$XO\u001d8t+:$WMZ5oK\u0012|eMZ:fi\"\u001aA%a\u001e\u0002WMDw.\u001e7e!>dG.\u00138eK\u001aLg.\u001b;fYfLeMU3qY&\u001c\u0017MT8u\u0003Z\f\u0017\u000e\\1cY\u0016D3!JA<\u0003\u0019\u001a\bn\\;mI\u001a+Go\u00195MK\u0006$WM]#q_\u000eDwJ\u001c$jeN$h)\u001a;dQ>sG.\u001f\u0015\u0004M\u0005]\u0014\u0001H:i_VdGMR3uG\"|e.\u001a*fa2L7-Y!u\u0003RKW.\u001a\u0015\u0004O\u0005]\u0014!L:i_VdGMR3uG\"tuN\u001c#fY\u0006LX\rZ!oI:{g\u000e\u0016:v]\u000e\fG/\u001b8h%\u0016\u0004H.[2bg\"\u001a\u0001&a\u001e\u0002\tM$XO\u0019\u000b\r\u0003_\u0012)Ea\u0015\u0003X\tm#1\u000e\u0005\b\u0005\u000fJ\u0003\u0019\u0001B%\u0003\u001dawn\u001a+2aB\u0002BAa\u0013\u0003P5\u0011!Q\n\u0006\u0004\u0005\u001fq\u0013\u0002\u0002B)\u0005\u001b\u0012!\"\u00168jM&,G\rT8h\u0011\u001d\u0011)&\u000ba\u0001\u0005\u0013\nq\u0001\\8h)F\u0002\u0018\u0007C\u0004\u0003Z%\u0002\rA!\u0013\u0002\u0013\u0019,H/\u001e:f\u0019><\u0007b\u0002B/S\u0001\u0007!qL\u0001\na\u0006\u0014H/\u001b;j_:\u0004BA!\u0019\u0003h5\u0011!1\r\u0006\u0004\u0005Kr\u0013aB2mkN$XM]\u0005\u0005\u0005S\u0012\u0019GA\u0005QCJ$\u0018\u000e^5p]\"9\u0011Q`\u0015A\u0002\u0005}\u0018!F:uk\n<\u0016\u000e\u001e5GKR\u001c\u0007.T3tg\u0006<Wm\u001d\u000b\u000f\u0003_\u0012\tHa\u001d\u0003v\t]$\u0011\u0010B>\u0011\u001d\u00119E\u000ba\u0001\u0005\u0013BqA!\u0016+\u0001\u0004\u0011I\u0005C\u0004\u0003Z)\u0002\rA!\u0013\t\u000f\tu#\u00061\u0001\u0003`!9\u0011Q \u0016A\u0002\u0005}\bb\u0002B?U\u0001\u0007!qP\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004bA!!\u0003\b\n-UB\u0001BB\u0015\r\u0011))R\u0001\b[>\u001c7.\u001b;p\u0013\u0011\u0011IIa!\u0003\u001d\u0005\u0013x-^7f]R\u001c\u0015\r\u001d;peB91G!$\u0003\u0012\u0006=\u0014b\u0001BHi\tIa)\u001e8di&|g.\r\t\u0007\u0005'\u0013)J!'\u000e\u0003aK1Aa&Y\u0005\r\u0019V-\u001d\t\u0007g\tm5N!\u0003\n\u0007\tuEG\u0001\u0004UkBdWM\r")
public class ReplicaAlterLogDirsThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final Uuid topicId = Uuid.randomUuid();
    private final scala.collection.immutable.Map<String, Uuid> topicIds = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)this.topicId())}));
    private final scala.collection.immutable.Map<Uuid, String> topicNames = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicId()), (Object)"topic1")}));
    private final TopicIdPartition tid1p0 = new TopicIdPartition(this.topicId(), this.t1p0());
    private final FailedPartitions failedPartitions = new FailedPartitions();
    private final java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic1").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0), (List)Nil$.MODULE$)).asJava();
    private final UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, this.partitionStates(), Collections.emptyList(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.topicIds()).asJava()).build();
    private final ZkMetadataCache metadataCache = new ZkMetadataCache(0, MetadataVersion.latestTesting(), BrokerFeatures$.MODULE$.createEmpty(), ZkMetadataCache$.MODULE$.$lessinit$greater$default$4(), ZkMetadataCache$.MODULE$.$lessinit$greater$default$5());

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private Uuid topicId() {
        return this.topicId;
    }

    private scala.collection.immutable.Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    private scala.collection.immutable.Map<Uuid, String> topicNames() {
        return this.topicNames;
    }

    private TopicIdPartition tid1p0() {
        return this.tid1p0;
    }

    private FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates() {
        return this.partitionStates;
    }

    private UpdateMetadataRequest updateMetadataRequest() {
        return this.updateMetadataRequest;
    }

    private ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private InitialFetchState initialFetchState(long fetchOffset, int leaderEpoch) {
        Some x$1 = new Some((Object)this.topicId());
        BrokerEndPoint x$2 = new BrokerEndPoint(0, "localhost", 9092);
        return new InitialFetchState((Option)x$1, x$2, leaderEpoch, fetchOffset);
    }

    private int initialFetchState$default$2() {
        return 1;
    }

    @Test
    public void shouldNotAddPartitionIfFutureLogIsNotDefined() {
        int brokerId = 1;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$8());
        Set addedPartitions = thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)addedPartitions);
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
    }

    @Test
    public void shouldUpdateLeaderEpochAfterFencedEpochError() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"gOZOXHnkR9eiA1W9ZuLk8A")));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FetchRequest.PartitionData fencedRequestData = new FetchRequest.PartitionData(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)));
        FetchPartitionData fencedResponseData = new FetchPartitionData(Errors.FENCED_LEADER_EPOCH, -1L, -1L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        this.mockFetchFromCurrentLog(this.tid1p0(), fencedRequestData, config, replicaManager, fencedResponseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-log-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$8());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch - 1))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertTrue((boolean)this.failedPartitions().contains(this.t1p0()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)), (Object)thread.fetchState(this.t1p0()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.currentLeaderEpoch())));
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        FetchRequest.PartitionData requestData = new FetchRequest.PartitionData(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        this.mockFetchFromCurrentLog(this.tid1p0(), requestData, config, replicaManager, responseData);
        thread.doWork();
        Assertions.assertFalse((boolean)this.failedPartitions().contains(this.t1p0()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
    }

    @Test
    public void shouldReplaceCurrentLogDirWhenCaughtUp() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"PGLOjDjKQaCOXFOtxymIig")));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FetchRequest.PartitionData requestData = new FetchRequest.PartitionData(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        this.mockFetchFromCurrentLog(this.tid1p0(), requestData, config, replicaManager, responseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$8());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
    }

    private Option<BoxedUnit> updateReassignmentState(ReplicaAlterLogDirsThread thread, int partitionId, ReplicaAlterLogDirsThread.ReassignmentState newState) {
        return this.topicNames().get((Object)this.topicId()).map((Function1 & Serializable & scala.Serializable)topicName -> {
            thread.updateReassignmentState(new TopicPartition(topicName, partitionId), newState);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void shouldReplaceCurrentLogDirWhenCaughtUpWithAfterAssignmentRequestHasBeenCompleted() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        DirectoryEventHandler directoryEventHandler = (DirectoryEventHandler)Mockito.mock(DirectoryEventHandler.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Uuid currentDirectoryId = Uuid.fromString((String)"EzI9SqkFQKW1iFc1ZwP9SQ");
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)partition.futureReplicaDirectoryId()).thenReturn((Object)new Some((Object)Uuid.randomUuid()));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.runCallbackIfFutureReplicaCaughtUp((Function1)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)currentDirectoryId));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FetchRequest.PartitionData requestData = new FetchRequest.PartitionData(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        this.mockFetchFromCurrentLog(this.tid1p0(), requestData, config, replicaManager, responseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), directoryEventHandler);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        this.updateReassignmentState(thread, partitionId, (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.Queued$.MODULE$);
        thread.doWork();
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        this.updateReassignmentState(thread, partitionId, (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.Accepted$.MODULE$);
        thread.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        Mockito.verifyNoInteractions((Object[])new Object[]{directoryEventHandler});
    }

    @Test
    public void shouldRevertAnyScheduledAssignmentRequestIfAssignmentIsCancelled() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        DirectoryEventHandler directoryEventHandler = (DirectoryEventHandler)Mockito.mock(DirectoryEventHandler.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)partition.futureReplicaDirectoryId()).thenReturn((Object)new Some((Object)Uuid.randomUuid()));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.randomUuid()));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.runCallbackIfFutureReplicaCaughtUp((Function1)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FetchRequest.PartitionData requestData = new FetchRequest.PartitionData(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        this.mockFetchFromCurrentLog(this.tid1p0(), requestData, config, replicaManager, responseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), directoryEventHandler);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        this.updateReassignmentState(thread, partitionId, (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.Queued$.MODULE$);
        thread.removePartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.t1p0()})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isEmpty());
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        ArgumentCaptor topicIdPartitionCaptureT1p0 = ArgumentCaptor.forClass(org.apache.kafka.server.common.TopicIdPartition.class);
        ArgumentCaptor logIdCaptureT1p0 = ArgumentCaptor.forClass(Uuid.class);
        ((DirectoryEventHandler)Mockito.verify((Object)directoryEventHandler)).handleAssignment((org.apache.kafka.server.common.TopicIdPartition)topicIdPartitionCaptureT1p0.capture(), (Uuid)logIdCaptureT1p0.capture(), (Runnable)ArgumentMatchers.any());
        Assertions.assertEquals((Object)new org.apache.kafka.server.common.TopicIdPartition(this.topicId(), this.t1p0().partition()), (Object)topicIdPartitionCaptureT1p0.getValue());
        Assertions.assertEquals((Object)partition.logDirectoryId().get(), (Object)logIdCaptureT1p0.getValue());
    }

    @Test
    public void shouldRevertReassignmentsForIncompleteFutureReplicaPromotions() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        DirectoryEventHandler directoryEventHandler = (DirectoryEventHandler)Mockito.mock(DirectoryEventHandler.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, (BrokerTopicStats)Mockito.mock(BrokerTopicStats.class), 0, directoryEventHandler);
        Seq tp2 = (Seq)((TraversableLike)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)4), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$2 -> ReplicaAlterLogDirsThreadTest.$anonfun$shouldRevertReassignmentsForIncompleteFutureReplicaPromotions$1(BoxesRunTime.unboxToInt((Object)x$2)), Seq$.MODULE$.canBuildFrom());
        Seq tips = (Seq)((TraversableLike)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)4), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$3 -> ReplicaAlterLogDirsThreadTest.$anonfun$shouldRevertReassignmentsForIncompleteFutureReplicaPromotions$2(this, BoxesRunTime.unboxToInt((Object)x$3)), Seq$.MODULE$.canBuildFrom());
        Seq dirIds = (Seq)((TraversableLike)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)4), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)i -> ReplicaAlterLogDirsThreadTest.$anonfun$shouldRevertReassignmentsForIncompleteFutureReplicaPromotions$3(BoxesRunTime.unboxToInt((Object)i)), Seq$.MODULE$.canBuildFrom());
        tp2.foreach((Function1 & Serializable & scala.Serializable)tp -> thread.promotionStates().put(tp, new ReplicaAlterLogDirsThread.PromotionState((ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.None$.MODULE$, (Option)new Some((Object)this.topicId()), (Option)new Some(dirIds.apply(tp.partition())))));
        thread.updateReassignmentState((TopicPartition)tp2.apply(0), (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.None$.MODULE$);
        thread.updateReassignmentState((TopicPartition)tp2.apply(1), (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.Queued$.MODULE$);
        thread.updateReassignmentState((TopicPartition)tp2.apply(2), (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.Accepted$.MODULE$);
        thread.updateReassignmentState((TopicPartition)tp2.apply(3), (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.Effective$.MODULE$);
        thread.removePartitions((Set)tp2.toSet());
        ((DirectoryEventHandler)Mockito.verify((Object)directoryEventHandler)).handleAssignment((org.apache.kafka.server.common.TopicIdPartition)ArgumentMatchers.eq((Object)tips.apply(1)), (Uuid)ArgumentMatchers.eq((Object)dirIds.apply(1)), (Runnable)ArgumentMatchers.any());
        ((DirectoryEventHandler)Mockito.verify((Object)directoryEventHandler)).handleAssignment((org.apache.kafka.server.common.TopicIdPartition)ArgumentMatchers.eq((Object)tips.apply(2)), (Uuid)ArgumentMatchers.eq((Object)dirIds.apply(2)), (Runnable)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{directoryEventHandler});
    }

    private void mockFetchFromCurrentLog(TopicIdPartition topicIdPartition, FetchRequest.PartitionData requestData, KafkaConfig config, ReplicaManager replicaManager, FetchPartitionData responseData) {
        ArgumentCaptor callbackCaptor = ArgumentCaptor.forClass(Function1.class);
        FetchParams expectedFetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), -3, -1L, 0L, 0, Predef$.MODULE$.Integer2int(config.replicaFetchResponseMaxBytes()), FetchIsolation.LOG_END, Optional.empty());
        replicaManager.fetchMessages((FetchParams)ArgumentMatchers.eq((Object)expectedFetchParams), (Seq)ArgumentMatchers.eq((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)requestData), (List)Nil$.MODULE$)), (ReplicaQuota)ArgumentMatchers.eq((Object)QuotaFactory.UnboundedQuota$.MODULE$), (Function1)callbackCaptor.capture());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$mockFetchFromCurrentLog$1(callbackCaptor, topicIdPartition, responseData, x$4);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void issuesEpochRequestFromLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        Partition partitionT1p0 = (Partition)Mockito.mock(Partition.class);
        Partition partitionT1p1 = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int partitionT1p0Id = 0;
        int partitionT1p1Id = 1;
        int leaderEpochT1p0 = 2;
        int leaderEpochT1p1 = 5;
        int leoT1p0 = 13;
        int leoT1p1 = 232;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p0Id));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p1Id));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partitionT1p0);
        Mockito.when((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p0, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p0Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p0).setEndOffset((long)leoT1p0));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partitionT1p1);
        Mockito.when((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p1, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p1Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p1).setEndOffset((long)leoT1p1));
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, null);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, null, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$8()).leader().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(leaderEpochT1p0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(leaderEpochT1p1))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p0().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p0).setEndOffset((long)leoT1p0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p1().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p1).setEndOffset((long)leoT1p1))}))), (Object)result, (String)"results from leader epoch request should have offset from local replica");
    }

    @Test
    public void fetchEpochsFromLeaderShouldHandleExceptionFromGetLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        Partition partitionT1p0 = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int partitionId = 0;
        int leaderEpoch = 2;
        int leo = 13;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partitionT1p0);
        Mockito.when((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)leo));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenThrow(new Throwable[]{new KafkaStorageException()});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, null);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, null, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$8()).leader().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(leaderEpoch))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p0().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)leo)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p1().partition()).setErrorCode(Errors.KAFKA_STORAGE_ERROR.code()))}))), (Object)result);
    }

    @Test
    public void shouldTruncateToReplicaOffset() {
        ArgumentCaptor truncateCaptureT1p0 = ArgumentCaptor.forClass(Long.TYPE);
        ArgumentCaptor truncateCaptureT1p1 = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog logT1p0 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog logT1p1 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLogT1p0 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLogT1p1 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partitionT1p0 = (Partition)Mockito.mock(Partition.class);
        Partition partitionT1p1 = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionT1p0Id = 0;
        int partitionT1p1Id = 1;
        int leaderEpoch = 2;
        int futureReplicaLEO = 191;
        int replicaT1p0LEO = 190;
        int replicaT1p1LEO = 192;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p0Id));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p1.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p1Id));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partitionT1p0);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partitionT1p1);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLogT1p0);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p1())).thenReturn((Object)futureLogT1p1);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p1()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLogT1p0.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLogT1p1.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO));
        Mockito.when((Object)futureLogT1p0.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)futureLogT1p0.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        Mockito.when((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p0Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaT1p0LEO));
        Mockito.when((Object)futureLogT1p1.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)futureLogT1p1.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        Mockito.when((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p1Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaT1p1LEO));
        Mockito.when((Object)partitionT1p0.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"Jsg8ufNCQYONNquPt7VYpA")));
        Mockito.when((Object)partitionT1p1.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"D2Yf6FtNROGVKoIZadSFIg")));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.stubWithFetchMessages(logT1p0, logT1p1, futureLogT1p0, partitionT1p0, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$8());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partitionT1p0)).truncateTo(BoxesRunTime.unboxToLong((Object)truncateCaptureT1p0.capture()), ArgumentMatchers.anyBoolean());
        ((Partition)Mockito.verify((Object)partitionT1p1)).truncateTo(BoxesRunTime.unboxToLong((Object)truncateCaptureT1p1.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)replicaT1p0LEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p0.getValue()));
        Assertions.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p1.getValue()));
    }

    @Test
    public void shouldTruncateToEndOffsetOfLargestCommonEpoch() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionId = 0;
        int leaderEpoch = 5;
        int futureReplicaLEO = 195;
        int replicaLEO = 200;
        int replicaEpochEndOffset = 190;
        int futureReplicaEpochEndOffset = 191;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch - 2))));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch - 1).setEndOffset((long)replicaLEO));
        Mockito.when((Object)futureLog.endOffsetForEpoch(leaderEpoch - 1)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch - 2)));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch - 2, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch - 2).setEndOffset((long)replicaEpochEndOffset));
        Mockito.when((Object)futureLog.endOffsetForEpoch(leaderEpoch - 2)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaEpochEndOffset, leaderEpoch - 2)));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"n6WOe2zPScqZLIreCWN6Ug")));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$8());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        thread.doWork();
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getAllValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)replicaEpochEndOffset)), (String)new StringBuilder(48).append("Expected offset ").append(replicaEpochEndOffset).append(" in captured truncation offsets ").append(truncateToCapture.getAllValues()).toString());
    }

    @Test
    public void shouldTruncateToInitialFetchOffsetIfReplicaReturnsUndefinedOffset() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int initialFetchOffset = 100;
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"b2e1ihvGQiu6A504oKoddQ")));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$8());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(initialFetchOffset, this.initialFetchState$default$2()))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertEquals((long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()), (String)"Expected future replica to truncate to initial fetch offset if replica returns UNDEFINED_EPOCH_OFFSET");
    }

    @Test
    public void shouldPollIndefinitelyIfReplicaNotAvailable() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionId = 0;
        int futureReplicaLeaderEpoch = 1;
        int futureReplicaLEO = 290;
        int replicaLEO = 300;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"wO7bUpvcSZC0QKEK6P6AiA")));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpoch)));
        Mockito.when((Object)futureLog.endOffsetForEpoch(futureReplicaLeaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, futureReplicaLeaderEpoch)));
        Mockito.when((Object)replicaManager.localLog(this.t1p0())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), futureReplicaLeaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.REPLICA_NOT_AVAILABLE.code())).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.REPLICA_NOT_AVAILABLE.code())).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.REPLICA_NOT_AVAILABLE.code())).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(futureReplicaLeaderEpoch).setEndOffset((long)replicaLEO));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        replicaManager.fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), (Function1)responseCallback.capture());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$shouldPollIndefinitelyIfReplicaNotAvailable$1(responseCallback, x$5);
            return BoxedUnit.UNIT;
        });
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$8());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> thread.doWork());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.never())).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertEquals((int)0, (int)truncated.getAllValues().size());
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnly() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionId = 0;
        int leaderEpoch = 5;
        int futureReplicaLEO = 190;
        int replicaLEO = 213;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"dybMM9CpRP2s6HSslW4NHg")));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaLEO));
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO));
        Mockito.when((Object)futureLog.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$8());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$7 -> thread.doWork());
        ((Partition)Mockito.verify((Object)partition)).lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false);
        ((Partition)Mockito.verify((Object)partition)).truncateTo((long)futureReplicaLEO, true);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchOneReplicaAtATime() {
        void var14_14;
        void var13_13;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partition);
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"Y0qUL19gSmKAXmohmrUM4g")));
        this.stub(log, null, futureLog, partition, replicaManager);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$8());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.leader().buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 150L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))})));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Set partitionsWithError = resultWithPartitions.partitionsWithError();
        void fetchRequestOpt2 = var13_13;
        void partitionsWithError2 = var14_14;
        Assertions.assertTrue((boolean)fetchRequestOpt2.isDefined());
        FetchRequest.Builder fetchRequest = ((AbstractFetcherThread.ReplicaFetch)fetchRequestOpt2.get()).fetchRequest();
        Assertions.assertFalse((boolean)fetchRequest.fetchData().isEmpty());
        Assertions.assertFalse((boolean)partitionsWithError2.nonEmpty());
        FetchRequest request = (FetchRequest)fetchRequest.build();
        Assertions.assertEquals((int)0, (int)request.minBytes());
        Seq fetchInfos = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.topicNames()).asJava())).asScala()).toSeq();
        Assertions.assertEquals((int)1, (int)fetchInfos.length());
        Assertions.assertEquals((Object)this.t1p0(), (Object)((TopicIdPartition)((Tuple2)fetchInfos.head())._1()).topicPartition(), (String)"Expected fetch request for first partition");
        Assertions.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchNonDelayedAndNonTruncatingReplicas() {
        void var29_29;
        void var28_28;
        void var22_22;
        void var21_21;
        void var15_15;
        void var14_14;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int startOffset = 123;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partition);
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"rtrdy3nsQwO1OQUEUYGxRQ")));
        this.stub(log, null, futureLog, partition, replicaManager);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$8());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.leader().buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)PartitionFetchState$.MODULE$.apply((Option)new Some((Object)this.topicId()), 150L, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)PartitionFetchState$.MODULE$.apply((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$))})));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Set partitionsWithError = resultWithPartitions.partitionsWithError();
        void fetchRequestOpt2 = var14_14;
        void partitionsWithError2 = var15_15;
        Assertions.assertTrue((boolean)fetchRequestOpt2.isDefined());
        AbstractFetcherThread.ReplicaFetch fetchRequest = (AbstractFetcherThread.ReplicaFetch)fetchRequestOpt2.get();
        Assertions.assertFalse((boolean)fetchRequest.partitionData().isEmpty());
        Assertions.assertFalse((boolean)partitionsWithError2.nonEmpty());
        Seq fetchInfos = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((FetchRequest)fetchRequest.fetchRequest().build()).fetchData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.topicNames()).asJava())).asScala()).toSeq();
        Assertions.assertEquals((int)1, (int)fetchInfos.length());
        Assertions.assertEquals((Object)this.t1p0(), (Object)((TopicIdPartition)((Tuple2)fetchInfos.head())._1()).topicPartition(), (String)"Expected fetch request for non-truncating partition");
        Assertions.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.leader().buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)PartitionFetchState$.MODULE$.apply((Option)new Some((Object)this.topicId()), 140L, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))})));
        if (resultWithPartitions2 == null) {
            throw new MatchError(null);
        }
        Option fetchRequest2Opt = (Option)resultWithPartitions2.result();
        Set partitionsWithError22 = resultWithPartitions2.partitionsWithError();
        void fetchRequest2Opt2 = var21_21;
        void partitionsWithError23 = var22_22;
        Assertions.assertTrue((boolean)fetchRequest2Opt2.isDefined());
        AbstractFetcherThread.ReplicaFetch fetchRequest2 = (AbstractFetcherThread.ReplicaFetch)fetchRequest2Opt2.get();
        Assertions.assertFalse((boolean)fetchRequest2.partitionData().isEmpty());
        Assertions.assertFalse((boolean)partitionsWithError23.nonEmpty());
        Seq fetchInfos2 = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((FetchRequest)fetchRequest2.fetchRequest().build()).fetchData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.topicNames()).asJava())).asScala()).toSeq();
        Assertions.assertEquals((int)1, (int)fetchInfos2.length());
        Assertions.assertEquals((Object)this.t1p0(), (Object)((TopicIdPartition)((Tuple2)fetchInfos2.head())._1()).topicPartition(), (String)"Expected fetch request for non-delayed partition");
        Assertions.assertEquals((long)140L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos2.head())._2()).fetchOffset);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions3 = thread.leader().buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 140L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))})));
        if (resultWithPartitions3 == null) {
            throw new MatchError(null);
        }
        Option fetchRequest3Opt = (Option)resultWithPartitions3.result();
        Set partitionsWithError3 = resultWithPartitions3.partitionsWithError();
        void fetchRequest3Opt2 = var28_28;
        void partitionsWithError32 = var29_29;
        Assertions.assertTrue((boolean)fetchRequest3Opt2.isEmpty(), (String)"Expected no fetch requests since all partitions are delayed");
        Assertions.assertFalse((boolean)partitionsWithError32.nonEmpty());
    }

    public void stub(UnifiedLog logT1p0, UnifiedLog logT1p1, UnifiedLog futureLog, Partition partition, ReplicaManager replicaManager) {
        Mockito.when((Object)replicaManager.localLog(this.t1p0())).thenReturn((Object)new Some((Object)logT1p0));
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p0())).thenReturn((Object)logT1p0);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.localLog(this.t1p1())).thenReturn((Object)new Some((Object)logT1p1));
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p1())).thenReturn((Object)logT1p1);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p1())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p1()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p1())).thenReturn((Object)new Some((Object)partition));
    }

    public void stubWithFetchMessages(UnifiedLog logT1p0, UnifiedLog logT1p1, UnifiedLog futureLog, Partition partition, ReplicaManager replicaManager, ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>> responseCallback) {
        this.stub(logT1p0, logT1p1, futureLog, partition, replicaManager);
        replicaManager.fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), (Function1)responseCallback.capture());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$12 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$stubWithFetchMessages$1(responseCallback, x$12);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ TopicPartition $anonfun$shouldRevertReassignmentsForIncompleteFutureReplicaPromotions$1(int x$2) {
        return new TopicPartition("t", x$2);
    }

    public static final /* synthetic */ org.apache.kafka.server.common.TopicIdPartition $anonfun$shouldRevertReassignmentsForIncompleteFutureReplicaPromotions$2(ReplicaAlterLogDirsThreadTest $this, int x$3) {
        return new org.apache.kafka.server.common.TopicIdPartition($this.topicId(), x$3);
    }

    public static final /* synthetic */ Uuid $anonfun$shouldRevertReassignmentsForIncompleteFutureReplicaPromotions$3(int i) {
        return Uuid.fromString((String)new StringBuilder(21).append("TESTBROKER0000DIR").append(i).append("AAAA").toString());
    }

    public static final /* synthetic */ void $anonfun$mockFetchFromCurrentLog$1(ArgumentCaptor callbackCaptor$1, TopicIdPartition topicIdPartition$1, FetchPartitionData responseData$1, InvocationOnMock x$4) {
        ((Function1)callbackCaptor$1.getValue()).apply((Object)new .colon.colon((Object)new Tuple2((Object)topicIdPartition$1, (Object)responseData$1), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$shouldPollIndefinitelyIfReplicaNotAvailable$1(ArgumentCaptor responseCallback$1, InvocationOnMock x$5) {
        ((Function1)responseCallback$1.getValue()).apply((Object)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$stubWithFetchMessages$1(ArgumentCaptor responseCallback$2, InvocationOnMock x$12) {
        ((Function1)responseCallback$2.getValue()).apply((Object)Nil$.MODULE$);
    }

    public ReplicaAlterLogDirsThreadTest() {
        this.metadataCache().updateMetadata(0, this.updateMetadataRequest());
    }
}

