/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\r\u001b\u0001}AQ\u0001\n\u0001\u0005\u0002\u0015B\u0011b\n\u0001A\u0002\u0003\u0007I\u0011\u0001\u0015\t\u00131\u0002\u0001\u0019!a\u0001\n\u0003i\u0003\"\u0003\u001c\u0001\u0001\u0004\u0005\t\u0015)\u0003*\u0011%9\u0004\u00011AA\u0002\u0013\u0005\u0001\u0006C\u00059\u0001\u0001\u0007\t\u0019!C\u0001s!I1\b\u0001a\u0001\u0002\u0003\u0006K!\u000b\u0005\ny\u0001\u0001\r\u00111A\u0005\u0002!B\u0011\"\u0010\u0001A\u0002\u0003\u0007I\u0011\u0001 \t\u0013\u0001\u0003\u0001\u0019!A!B\u0013I\u0003bB!\u0001\u0001\u0004%\tA\u0011\u0005\b\u0019\u0002\u0001\r\u0011\"\u0001N\u0011\u0019y\u0005\u0001)Q\u0005\u0007\")\u0001\u000b\u0001C!#\")A\r\u0001C!K\")!\u000e\u0001C\u0001K\")q\u000e\u0001C\u0001K\")\u0011\u000f\u0001C\u0001K\")1\u000f\u0001C\u0001K\")Q\u000f\u0001C\u0001K\")q\u000f\u0001C\u0001K\")\u0011\u0010\u0001C\u0001u\"1\u0011\u0010\u0001C\u0001\u0003CAq!a\u000b\u0001\t\u0003\tiCA\u000eTKJ4XM]$f]\u0016\u0014\u0018\r^3DYV\u001cH/\u001a:JIR+7\u000f\u001e\u0006\u00037q\taa]3sm\u0016\u0014(\"A\u000f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\tj\u0011AG\u0005\u0003Gi\u0011\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\ta\u0005\u0005\u0002\"\u0001\u000591m\u001c8gS\u001e\fT#A\u0015\u0011\u0005\u0005R\u0013BA\u0016\u001b\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0017\r|gNZ5hc}#S-\u001d\u000b\u0003]Q\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012A!\u00168ji\"9QgAA\u0001\u0002\u0004I\u0013a\u0001=%c\u0005A1m\u001c8gS\u001e\f\u0004%A\u0004d_:4\u0017n\u001a\u001a\u0002\u0017\r|gNZ5he}#S-\u001d\u000b\u0003]iBq!\u000e\u0004\u0002\u0002\u0003\u0007\u0011&\u0001\u0005d_:4\u0017n\u001a\u001a!\u0003\u001d\u0019wN\u001c4jON\n1bY8oM&<7g\u0018\u0013fcR\u0011af\u0010\u0005\bk%\t\t\u00111\u0001*\u0003!\u0019wN\u001c4jON\u0002\u0013aB:feZ,'o]\u000b\u0002\u0007B\u0019AiR%\u000e\u0003\u0015S!A\u0012\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002I\u000b\n\u00191+Z9\u0011\u0005\u0005R\u0015BA&\u001b\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003]9Cq!\u000e\u0007\u0002\u0002\u0003\u00071)\u0001\u0005tKJ4XM]:!\u0003\u0015\u0019X\r^+q)\tq#\u000bC\u0003T\u001d\u0001\u0007A+\u0001\u0005uKN$\u0018J\u001c4p!\t)f,D\u0001W\u0015\t9\u0006,A\u0002ba&T!!\u0017.\u0002\u000f),\b/\u001b;fe*\u00111\fX\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002;\u0006\u0019qN]4\n\u0005}3&\u0001\u0003+fgRLeNZ8)\u00059\t\u0007CA+c\u0013\t\u0019gK\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002]!\u0012qb\u001a\t\u0003+\"L!!\u001b,\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\u0007;fgR\fU\u000f^8HK:,'/\u0019;f\u00072,8\u000f^3s\u0013\u0012D#\u0001\u00057\u0011\u0005Uk\u0017B\u00018W\u0005\u0011!Vm\u001d;\u0002eQ,7\u000f^!vi><UM\\3sCR,7\t\\;ti\u0016\u0014\u0018\n\u001a$pe.\u000bgm[1DYV\u001cH/\u001a:TKF,XM\u001c;jC2D#!\u00057\u0002aQ,7\u000f^!vi><UM\\3sCR,7\t\\;ti\u0016\u0014\u0018\n\u001a$pe.\u000bgm[1DYV\u001cH/\u001a:QCJ\fG\u000e\\3mQ\t\u0011B.\u0001\u001buKN$8i\u001c8tSN$XM\u001c;DYV\u001cH/\u001a:JI\u001a\u0013x.\u001c.p_.,W\r]3s\u0003:$gI]8n\u001b\u0016$\u0018\r\u0015:paND#a\u00057\u0002mQ,7\u000f^%oG>t7/[:uK:$8\t\\;ti\u0016\u0014\u0018\n\u001a$s_6Tvn\\6fKB,'/\u00118e\rJ|W.T3uCB\u0013x\u000e]:)\u0005Qa\u0017\u0001\u000e;fgRLenY8og&\u001cH/\u001a8u\u0005J|7.\u001a:NKR\fG-\u0019;b\u0005\u0016$x/Z3o\u001bVdG/\u001b9mK2{w\rR5sg\"\u0012Q\u0003\\\u0001\u0014M>\u0014x-\u001a\"s_.,'/T3uC\u0012\fG/\u0019\u000b\u0007]m\f\u0019\"!\b\t\u000bq4\u0002\u0019A?\u0002\u000f1|w\rR5sgB\u0019Ai\u0012@\u0011\u0007}\fiA\u0004\u0003\u0002\u0002\u0005%\u0001cAA\u0002a5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000fq\u0012A\u0002\u001fs_>$h(C\u0002\u0002\fA\na\u0001\u0015:fI\u00164\u0017\u0002BA\b\u0003#\u0011aa\u0015;sS:<'bAA\u0006a!9\u0011Q\u0003\fA\u0002\u0005]\u0011\u0001\u00032s_.,'/\u00133\u0011\u0007=\nI\"C\u0002\u0002\u001cA\u00121!\u00138u\u0011\u0019\tyB\u0006a\u0001}\u0006I1\r\\;ti\u0016\u0014\u0018\n\u001a\u000b\b]\u0005\r\u0012qEA\u0015\u0011\u0019\t)c\u0006a\u0001}\u00061An\\4ESJDq!!\u0006\u0018\u0001\u0004\t9\u0002\u0003\u0004\u0002 ]\u0001\rA`\u0001\u0015m\u0016\u0014\u0018NZ=Ce>\\WM]'fi\u0006$\u0017\r^1\u0015\r\u0005=\u0012QGA\u001c!\ry\u0013\u0011G\u0005\u0004\u0003g\u0001$a\u0002\"p_2,\u0017M\u001c\u0005\u0006yb\u0001\r! \u0005\u0007\u0003?A\u0002\u0019\u0001@")
public class ServerGenerateClusterIdTest
extends QuorumTestHarness {
    private KafkaConfig config1;
    private KafkaConfig config2;
    private KafkaConfig config3;
    private Seq<KafkaServer> servers = Nil$.MODULE$;

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public KafkaConfig config3() {
        return this.config3;
    }

    public void config3_$eq(KafkaConfig x$1) {
        this.config3 = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(2, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())));
        this.config3_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    @Test
    public void testAutoGenerateClusterId() {
        Assertions.assertFalse((boolean)this.zkClient().getClusterId().isDefined());
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        String clusterIdOnFirstBoot = server1.clusterId();
        TestUtils.isValidClusterId((String)clusterIdOnFirstBoot);
        server1.shutdown();
        Assertions.assertTrue((boolean)this.zkClient().getClusterId().isDefined());
        Assertions.assertEquals((Object)this.zkClient().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        server1 = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        String clusterIdOnSecondBoot = server1.clusterId();
        Assertions.assertEquals((Object)clusterIdOnFirstBoot, (Object)clusterIdOnSecondBoot);
        server1.shutdown();
        Assertions.assertTrue((boolean)this.zkClient().getClusterId().isDefined());
        Assertions.assertEquals((Object)this.zkClient().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testAutoGenerateClusterIdForKafkaClusterSequential() {
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterIdFromServer1 = server1.clusterId();
        KafkaServer server2 = TestUtils$.MODULE$.createServer(this.config2(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterIdFromServer2 = server2.clusterId();
        KafkaServer server3 = TestUtils$.MODULE$.createServer(this.config3(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterIdFromServer3 = server3.clusterId();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)new .colon.colon((Object)server3, (List)Nil$.MODULE$))));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assertions.assertEquals((Object)clusterIdFromServer1, (Object)clusterIdFromServer2, (String)clusterIdFromServer3);
        server1.startup();
        Assertions.assertEquals((Object)clusterIdFromServer1, (Object)server1.clusterId());
        server2.startup();
        Assertions.assertEquals((Object)clusterIdFromServer2, (Object)server2.clusterId());
        server3.startup();
        Assertions.assertEquals((Object)clusterIdFromServer3, (Object)server3.clusterId());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoGenerateClusterIdForKafkaClusterParallel() {
        void var6_6;
        void var5_5;
        void var4_4;
        Future firstBoot = Future$.MODULE$.traverse((TraversableOnce)new .colon.colon((Object)this.config1(), (List)new .colon.colon((Object)this.config2(), (List)new .colon.colon((Object)this.config3(), (List)Nil$.MODULE$))), (Function1 & Serializable & scala.Serializable)config -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.createServer((KafkaConfig)config, (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName())), ExecutionContext.Implicits$.MODULE$.global()), Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)firstBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
        Seq<KafkaServer> seq = this.servers();
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) {
            throw new MatchError(seq);
        }
        KafkaServer server1 = (KafkaServer)((SeqLike)some.get()).apply(0);
        KafkaServer server2 = (KafkaServer)((SeqLike)some.get()).apply(1);
        KafkaServer server3 = (KafkaServer)((SeqLike)some.get()).apply(2);
        void server12 = var4_4;
        void server22 = var5_5;
        void server32 = var6_6;
        String clusterIdFromServer1 = server12.clusterId();
        String clusterIdFromServer2 = server22.clusterId();
        String clusterIdFromServer3 = server32.clusterId();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assertions.assertEquals((Object)clusterIdFromServer1, (Object)clusterIdFromServer2, (String)clusterIdFromServer3);
        Future secondBoot = Future$.MODULE$.traverse((TraversableOnce)new .colon.colon((Object)server12, (List)new .colon.colon((Object)server22, (List)new .colon.colon((Object)server32, (List)Nil$.MODULE$))), (Function1 & Serializable & scala.Serializable)server -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            server.startup();
            return server;
        }, ExecutionContext.Implicits$.MODULE$.global()), Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)secondBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            ServerGenerateClusterIdTest.$anonfun$testAutoGenerateClusterIdForKafkaClusterParallel$6(clusterIdFromServer1, server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testConsistentClusterIdFromZookeeperAndFromMetaProps() {
        KafkaServer server = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterId = server.clusterId();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server.config().logDirs(), clusterId));
        server.shutdown();
        server.startup();
        Assertions.assertEquals((Object)clusterId, (Object)server.clusterId());
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server.config().logDirs(), server.clusterId()));
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testInconsistentClusterIdFromZookeeperAndFromMetaProps() {
        this.forgeBrokerMetadata((Seq<String>)this.config1().logDirs(), this.config1().brokerId(), "aclusterid");
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(x$1, x$3, x$2, x$4);
        Assertions.assertThrows(RuntimeException.class, () -> server.startup());
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testInconsistentBrokerMetadataBetweenMultipleLogDirs() {
        String logDir1 = TestUtils$.MODULE$.tempDir().getAbsolutePath();
        String logDir2 = TestUtils$.MODULE$.tempDir().getAbsolutePath();
        String logDirs = new StringBuilder(1).append(logDir1).append(",").append(logDir2).toString();
        this.forgeBrokerMetadata(logDir1, 1, "ebwOKU-zSieInaFQh_qP4g");
        this.forgeBrokerMetadata(logDir2, 1, "blaOKU-zSieInaFQh_qP4g");
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        props.setProperty("log.dir", logDirs);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(config, x$3, x$2, x$4);
        Assertions.assertThrows(RuntimeException.class, () -> server.startup());
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    public void forgeBrokerMetadata(Seq<String> logDirs, int brokerId, String clusterId) {
        logDirs.foreach((Function1 & Serializable & scala.Serializable)logDir -> {
            this.forgeBrokerMetadata(logDir, brokerId, clusterId);
            return BoxedUnit.UNIT;
        });
    }

    public void forgeBrokerMetadata(String logDir, int brokerId, String clusterId) {
        PropertiesUtils.writePropertiesFile((Properties)new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V0).setNodeId(brokerId).setClusterId(clusterId).build().toProperties(), (String)new File(logDir, "meta.properties").getAbsolutePath(), (boolean)false);
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, String clusterId) {
        Object object = new Object();
        try {
            logDirs.foreach((Function1 & Serializable & scala.Serializable)logDir -> {
                ServerGenerateClusterIdTest.$anonfun$verifyBrokerMetadata$1(clusterId, object, logDir);
                return BoxedUnit.UNIT;
            });
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$testAutoGenerateClusterIdForKafkaClusterParallel$6(String clusterIdFromServer1$1, KafkaServer server) {
        Assertions.assertEquals((Object)clusterIdFromServer1$1, (Object)server.clusterId());
    }

    public static final /* synthetic */ void $anonfun$verifyBrokerMetadata$1(String clusterId$2, Object nonLocalReturnKey1$1, String logDir) {
        Properties properties = PropertiesUtils.readPropertiesFile((String)new File(logDir, "meta.properties").getAbsolutePath());
        if (!new MetaProperties.Builder(properties).build().clusterId().equals(Optional.of(clusterId$2))) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }
}

