/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.Collections;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.server.common.CheckpointFile;
import org.apache.kafka.storage.internals.checkpoint.CheckpointFileWithFailureHandler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u2A\u0001C\u0005\u0001!!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!)1\u0007\u0001C\u0001E!)Q\u0007\u0001C\u0001E!)q\u0007\u0001C\u0001E!)\u0011\b\u0001C\u0001E!)1\b\u0001C\u0001E\tQsJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016<\u0016\u000e\u001e5GC&dWO]3IC:$G.\u001a:UKN$(B\u0001\u0006\f\u0003-\u0019\u0007.Z2la>Lg\u000e^:\u000b\u00051i\u0011AB:feZ,'OC\u0001\u000f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\t\u0018!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019\te.\u001f*fMB\u0011\u0001dG\u0007\u00023)\u0011!$D\u0001\u0006kRLGn]\u0005\u00039e\u0011q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0013\u000513\u000f[8vY\u0012\u0004VM]:jgR\fe\u000eZ(wKJ<(/\u001b;f\u0003:$'+\u001a7pC\u00124\u0015\u000e\\3\u0015\u0003\r\u0002\"A\u0005\u0013\n\u0005\u0015\u001a\"\u0001B+oSRD#AA\u0014\u0011\u0005!\nT\"A\u0015\u000b\u0005)Z\u0013aA1qS*\u0011A&L\u0001\bUV\u0004\u0018\u000e^3s\u0015\tqs&A\u0003kk:LGOC\u00011\u0003\ry'oZ\u0005\u0003e%\u0012A\u0001V3ti\u0006I2\u000f[8vY\u0012D\u0015M\u001c3mK6+H\u000e^5qY\u0016d\u0015N\\3tQ\t\u0019q%\u0001\u0011tQ>,H\u000e\u001a*fiV\u0014h.R7qifl\u0015\r\u001d$pe\u0016k\u0007\u000f^=GS2,\u0007F\u0001\u0003(\u0003\r\u001a\bn\\;mIRC'o\\<JMZ+'o]5p]&\u001bhj\u001c;SK\u000e|wM\\5tK\u0012D#!B\u0014\u00021Q,7\u000f\u001e'buf|eMZ:fi\u000eCWmY6q_&tG\u000f\u000b\u0002\u0007O\u0005IC/Z:u\u0019\u0006T\u0018p\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0017J\u001c<bY&$Gj\\4ESJD#aB\u0014")
public class OffsetCheckpointFileWithFailureHandlerTest
implements Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Test
    public void shouldPersistAndOverwriteAndReloadFile() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils$.MODULE$.tempFile(), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        Map offsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 2)), (Object)BoxesRunTime.boxToLong((long)10L))}));
        checkpoint.write(offsets);
        Assertions.assertEquals((Object)offsets, (Object)checkpoint.read());
        Map offsets2 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)15L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 3)), (Object)BoxesRunTime.boxToLong((long)20L))}));
        checkpoint.write(offsets2);
        Assertions.assertEquals((Object)offsets2, (Object)checkpoint.read());
    }

    @Test
    public void shouldHandleMultipleLines() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils$.MODULE$.tempFile(), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        Map offsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 6)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 7)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 8)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 9)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 10)), (Object)BoxesRunTime.boxToLong((long)10L))}));
        checkpoint.write(offsets);
        Assertions.assertEquals((Object)offsets, (Object)checkpoint.read());
    }

    @Test
    public void shouldReturnEmptyMapForEmptyFile() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils$.MODULE$.tempFile(), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
        checkpoint.write((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
    }

    @Test
    public void shouldThrowIfVersionIsNotRecognised() {
        File file = TestUtils$.MODULE$.tempFile();
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        CheckpointFileWithFailureHandler checkpointFile = new CheckpointFileWithFailureHandler(file, OffsetCheckpointFile$.MODULE$.CurrentVersion() + 1, (CheckpointFile.EntryFormatter)OffsetCheckpointFile.Formatter$.MODULE$, logDirFailureChannel, file.getParent());
        checkpointFile.write(Collections.singletonList(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)BoxesRunTime.boxToLong((long)10L))), true);
        Assertions.assertThrows(KafkaStorageException.class, () -> new OffsetCheckpointFile(checkpointFile$1.file, logDirFailureChannel).read());
    }

    @Test
    public void testLazyOffsetCheckpoint() {
        String logDir = "/tmp/kafka-logs";
        OffsetCheckpointFile mockCheckpointFile = (OffsetCheckpointFile)Mockito.mock(OffsetCheckpointFile.class);
        LazyOffsetCheckpoints lazyCheckpoints = new LazyOffsetCheckpoints((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir), (Object)mockCheckpointFile)})));
        ((OffsetCheckpointFile)Mockito.verify((Object)mockCheckpointFile, (VerificationMode)Mockito.never())).read();
        TopicPartition partition0 = new TopicPartition("foo", 0);
        TopicPartition partition1 = new TopicPartition("foo", 1);
        TopicPartition partition2 = new TopicPartition("foo", 2);
        Mockito.when((Object)mockCheckpointFile.read()).thenReturn((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)BoxesRunTime.boxToLong((long)1000L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)BoxesRunTime.boxToLong((long)2000L))})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)1000L)), (Object)lazyCheckpoints.fetch(logDir, partition0));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2000L)), (Object)lazyCheckpoints.fetch(logDir, partition1));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lazyCheckpoints.fetch(logDir, partition2));
        ((OffsetCheckpointFile)Mockito.verify((Object)mockCheckpointFile, (VerificationMode)Mockito.times((int)1))).read();
    }

    @Test
    public void testLazyOffsetCheckpointFileInvalidLogDir() {
        String logDir = "/tmp/kafka-logs";
        OffsetCheckpointFile mockCheckpointFile = (OffsetCheckpointFile)Mockito.mock(OffsetCheckpointFile.class);
        LazyOffsetCheckpoints lazyCheckpoints = new LazyOffsetCheckpoints((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir), (Object)mockCheckpointFile)})));
        Assertions.assertThrows(IllegalArgumentException.class, () -> lazyCheckpoints.fetch("/invalid/kafka-logs", new TopicPartition("foo", 0)));
    }

    public OffsetCheckpointFileWithFailureHandlerTest() {
        Logging.$init$((Logging)this);
    }
}

