/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001\u0002\u001b6\u0001qBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004U\u0001\u0001\u0006I!\u0013\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0011\u0019\u0001\u0007\u0001)A\u0005/\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007B\u00025\u0001A\u0003%1\rC\u0003j\u0001\u0011\u0005!\u000eC\u0003z\u0001\u0011\u0005!\u000eC\u0003|\u0001\u0011\u0005!\u000eC\u0003~\u0001\u0011\u0005!\u000eC\u0003\u0000\u0001\u0011\u0005!\u000e\u0003\u0004\u0002\u0004\u0001!\tA\u001b\u0005\u0007\u0003\u000f\u0001A\u0011\u00016\t\r\u0005-\u0001\u0001\"\u0001k\u0011\u0019\ty\u0001\u0001C\u0001U\"1\u00111\u0003\u0001\u0005\u0002)Da!a\u0006\u0001\t\u0003Q\u0007BBA\u000e\u0001\u0011\u0005!\u000e\u0003\u0004\u0002 \u0001!\tA\u001b\u0005\u0007\u0003G\u0001A\u0011\u00016\t\r\u0005\u001d\u0002\u0001\"\u0001k\u0011\u0019\tY\u0003\u0001C\u0001U\"1\u0011q\u0006\u0001\u0005\u0002)Da!a\r\u0001\t\u0003Q\u0007bBA\u001c\u0001\u0011%\u0011\u0011\b\u0005\u0007\u0003\u000f\u0003A\u0011\u00016\t\r\u0005-\u0005\u0001\"\u0001k\u0011\u0019\ty\t\u0001C\u0001U\"1\u00111\u0013\u0001\u0005\u0002)Da!a&\u0001\t\u0003Q\u0007BBAN\u0001\u0011\u0005!\u000e\u0003\u0004\u0002 \u0002!\tA\u001b\u0005\u0007\u0003G\u0003A\u0011\u00016\t\r\u0005\u001d\u0006\u0001\"\u0001k\u0011\u0019\tY\u000b\u0001C\u0001U\"1\u0011q\u0016\u0001\u0005\u0002)Da!a-\u0001\t\u0003Q\u0007BBA\\\u0001\u0011\u0005!\u000e\u0003\u0004\u0002<\u0002!\tA\u001b\u0005\u0007\u0003\u007f\u0003A\u0011\u00016\t\r\u0005\r\u0007\u0001\"\u0001k\u0011\u0019\t9\r\u0001C\u0001U\"1\u00111\u001a\u0001\u0005\u0002)Da!a4\u0001\t\u0003Q\u0007BBAj\u0001\u0011\u0005!\u000e\u0003\u0004\u0002X\u0002!\tA\u001b\u0005\u0007\u00037\u0004A\u0011\u00016\t\r\u0005}\u0007\u0001\"\u0001k\u0011\u0019\t\u0019\u000f\u0001C\u0001U\"1\u0011q\u001d\u0001\u0005\u0002)\u0014\u0001\u0004T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",G+Z:u\u0015\t1t'A\u0003fa>\u001c\u0007N\u0003\u00029s\u000511/\u001a:wKJT\u0011AO\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\b\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0003\"A\u0012\u0001\u000e\u0003U\n!\u0001\u001e9\u0016\u0003%\u0003\"A\u0013*\u000e\u0003-S!\u0001T'\u0002\r\r|W.\\8o\u0015\tQdJ\u0003\u0002P!\u00061\u0011\r]1dQ\u0016T\u0011!U\u0001\u0004_J<\u0017BA*L\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0001\u001e9!\u0003)\u0019\u0007.Z2la>Lg\u000e^\u000b\u0002/B\u0011\u0001LX\u0007\u00023*\u0011QK\u0017\u0006\u00037r\u000b\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005uk\u0015aB:u_J\fw-Z\u0005\u0003?f\u0013Q\u0003T3bI\u0016\u0014X\t]8dQ\u000eCWmY6q_&tG/A\u0006dQ\u0016\u001c7\u000e]8j]R\u0004\u0013!B2bG\",W#A2\u0011\u0005\u00114W\"A3\u000b\u0005YR\u0016BA4f\u0005QaU-\u00193fe\u0016\u0003xn\u00195GS2,7)Y2iK\u000611-Y2iK\u0002\n\u0011\u0003^3tiB\u0013XM^5pkN,\u0005o\\2i)\u0005Y\u0007C\u0001 m\u0013\tiwH\u0001\u0003V]&$\bF\u0001\u0005p!\t\u0001x/D\u0001r\u0015\t\u00118/A\u0002ba&T!\u0001^;\u0002\u000f),\b/\u001b;fe*\u0011a\u000fU\u0001\u0006UVt\u0017\u000e^\u0005\u0003qF\u0014A\u0001V3ti\u0006)3\u000f[8vY\u0012\fE\rZ#q_\u000eD\u0017I\u001c3NKN\u001c\u0018mZ3PM\u001a\u001cX\r\u001e+p\u0007\u0006\u001c\u0007.\u001a\u0015\u0003\u0013=\faf\u001d5pk2$'+\u001a;ve:dunZ#oI>3gm]3u\u0013\u001ad\u0015\r^3ti\u0016\u0003xn\u00195SKF,Xm\u001d;fI\"\u0012!b\\\u00015g\"|W\u000f\u001c3SKR,(O\\+oI\u00164\u0017N\\3e\u001f\u001a47/\u001a;JMVsG-\u001a4j]\u0016$W\t]8dQJ+\u0017/^3ti\u0016$\u0007FA\u0006p\u0003\t\u001b\bn\\;mI:{Go\u0014<fe^\u0014\u0018\u000e^3M_\u001e,e\u000eZ(gMN,GOR8s\u00032+\u0017\rZ3s\u000bB|7\r[(oG\u0016LE\u000fS1t\u0005\u0016,g.Q:tS\u001etW\r\u001a\u0015\u0003\u0019=\f\u0001g\u001d5pk2$WI\u001c4pe\u000e,Wj\u001c8pi>t\u0017nY1mYfLen\u0019:fCNLgnZ*uCJ$xJ\u001a4tKR\u001c\bFA\u0007p\u0003q\u001a\bn\\;mI:{Go\u0014<fe^\u0014\u0018\u000e^3PM\u001a\u001cX\r\u001e$pe\u0006cU-\u00193fe\u0016\u0003xn\u00195P]\u000e,\u0017\n\u001e%bg\n+WM\\!tg&<g.\u001a3)\u00059y\u0017\u0001K:i_VdGMU3ukJtWK\\:vaB|'\u000f^3e\u0013\u001atu.\u00129pG\"\u0014VmY8sI\u0016$\u0007FA\bp\u0003\t\u001b\bn\\;mIJ+G/\u001e:o+:\u001cX\u000f\u001d9peR,G-\u00134O_\u0016\u0003xn\u00195SK\u000e|'\u000fZ3e\u0003:$WK\u001c3fM&tW\rZ#q_\u000eD'+Z9vKN$X\r\u001a\u0015\u0003!=\f\u0001h\u001d5pk2$'+\u001a;ve:4\u0015N]:u\u000bB|7\r[%g%\u0016\fX/Z:uK\u0012,\u0005o\\2i\u0019\u0016\u001c8\u000f\u00165b]\u001aK'o\u001d;Fa>\u001c\u0007\u000e\u000b\u0002\u0012_\u0006)4\u000f[8vY\u0012$&/\u001e8dCR,\u0017JZ'bi\u000eD\u0017N\\4Fa>\u001c\u0007NQ;u\u000b\u0006\u0014H.[3s'R\f'\u000f^5oO>3gm]3uQ\t\u0011r.\u0001%tQ>,H\u000eZ$fi\u001aK'o\u001d;PM\u001a\u001cX\r^(g'V\u00147/Z9vK:$X\t]8dQ^CWM\\(gMN,GOU3rk\u0016\u001cH/\u001a3G_J\u0004&/\u001a<j_V\u001cX\t]8dQ\"\u00121c\\\u0001Fg\"|W\u000f\u001c3SKR,(O\u001c(fqR\fe/Y5mC\ndW-\u00129pG\"Le\r\u00165fe\u0016L5OT8Fq\u0006\u001cG/\u00129pG\"4uN\u001d+iK>sWMU3rk\u0016\u001cH/\u001a3)\u0005Qy\u0017AM:i_VdGMT8u+B$\u0017\r^3Fa>\u001c\u0007.\u00118e'R\f'\u000f^(gMN,G/\u00134Ji\u0012KGMT8u\u0007\"\fgnZ3)\u0005Uy\u0017!R:i_VdGMU3ukJt\u0017J\u001c<bY&$wJ\u001a4tKRLe-\u00129pG\"L5OU3rk\u0016\u001cH/\u001a3XQ&\u001c\u0007.S:O_R\u001cUO\u001d:f]Rd\u0017\u0010\u0016:bG.,G\r\u000b\u0002\u0017_\u0006I3\u000f[8vY\u0012\u001cV\u000f\u001d9peR,\u0005o\\2igRC\u0017\r\u001e#p\u001d>$8\u000b^1si\u001a\u0013x.\u001c.fe>D#aF8\u0002GMDw.\u001e7e!\u0016\u00148/[:u\u000bB|7\r[:CKR<X-\u001a8J]N$\u0018M\\2fg\"\u0012\u0001d\\\u0001+g\"|W\u000f\u001c3F]\u001a|'oY3N_:|Go\u001c8jG\u0006dG._%oGJ,\u0017m]5oO\u0016\u0003xn\u00195tQ\tIr.A\u0004u_R+\b\u000f\\3\u0016\r\u0005m\u0012qIA.)\u0011\ti$a\u0018\u0011\u000fy\ny$a\u0011\u0002Z%\u0019\u0011\u0011I \u0003\rQ+\b\u000f\\33!\u0011\t)%a\u0012\r\u0001\u00119\u0011\u0011\n\u000eC\u0002\u0005-#!A&\u0012\t\u00055\u00131\u000b\t\u0004}\u0005=\u0013bAA)\u007f\t9aj\u001c;iS:<\u0007c\u0001 \u0002V%\u0019\u0011qK \u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002F\u0005mCaBA/5\t\u0007\u00111\n\u0002\u0002-\"9\u0011\u0011\r\u000eA\u0002\u0005\r\u0014!B3oiJL\b\u0003CA3\u0003\u0003\u000b\u0019%!\u0017\u000f\t\u0005\u001d\u00141\u0010\b\u0005\u0003S\n)H\u0004\u0003\u0002l\u0005ETBAA7\u0015\r\tygO\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005M\u0014\u0001\u00026bm\u0006LA!a\u001e\u0002z\u0005!Q\u000f^5m\u0015\t\t\u0019(\u0003\u0003\u0002~\u0005}\u0014aA'ba*!\u0011qOA=\u0013\u0011\t\u0019)!\"\u0003\u000b\u0015sGO]=\u000b\t\u0005u\u0014qP\u0001*g\"|W\u000f\u001c3F]\u001a|'oY3PM\u001a\u001cX\r^:J]\u000e\u0014X-Y:f\u001b>tw\u000e^8oS\u000e\fG\u000e\\=)\u0005my\u0017\u0001N:i_VdG-\u00138de\u0016\f7/Z!oIR\u0013\u0018mY6Fa>\u001c\u0007n]!t\u0019\u0016\fG-\u001a:t\u0007\"\fgnZ3NC:LH+[7fg\"\u0012Ad\\\u0001;g\"|W\u000f\u001c3J]\u000e\u0014X-Y:f\u0003:$GK]1dW\u0016\u0003xn\u00195t\u0003N4u\u000e\u001c7po\u0016\u0014(+Z2fSZ,7/T1os6+7o]1hKND#!H8\u0002sMDw.\u001e7e\tJ|\u0007/\u00128ue&,7o\u00148Fa>\u001c\u0007NQ8v]\u0012\f'/_,iK:\u0014V-\\8wS:<G*\u0019;fgR,e\u000e\u001e:jKND#AH8\u0002gMDw.\u001e7e!J,7/\u001a:wKJ+7/\u001a;PM\u001a\u001cX\r^(o\u00072,\u0017M]#be2LWm\u001d;JM>sW-\u0012=jgR\u001c\bFA\u0010p\u0003e\u001a\bn\\;mIV\u0003H-\u0019;f'\u00064X\rZ(gMN,Go\u00165f]>3gm]3u)>\u001cE.Z1s)>L5OQ3uo\u0016,g.\u00129pG\"\u001c\bF\u0001\u0011p\u0003\u0015\u001a\bn\\;mI:{Go\u00117fCJ\fe.\u001f;iS:<\u0017JZ(gMN,G\u000fV8FCJd\u0017\u0010\u000b\u0002\"_\u0006Y3\u000f[8vY\u0012tu\u000e^\"mK\u0006\u0014\u0018I\\=uQ&tw-\u00134PM\u001a\u001cX\r\u001e+p\r&\u00148\u000f^(gMN,G\u000f\u000b\u0002#_\u0006I3\u000f[8vY\u0012\u0014V\r^1j]2\u000bG/Z:u\u000bB|7\r[(o\u00072,\u0017M]!mY\u0016\u000b'\u000f\\5fgRD#aI8\u0002oMDw.\u001e7e+B$\u0017\r^3PM\u001a\u001cX\r\u001e\"fi^,WM\\#q_\u000eD'i\\;oI\u0006\u0014\u0018.Z:P]\u000ecW-\u0019:FCJd\u0017.Z:uQ\t!s.\u0001\u001dtQ>,H\u000eZ+qI\u0006$Xm\u00144gg\u0016$()\u001a;xK\u0016tW\t]8dQ\n{WO\u001c3be&,7o\u00148DY\u0016\f'/R1sY&,7\u000f\u001e\u001a)\u0005\u0015z\u0017aO:i_VdGMU3uC&tG*\u0019;fgR,\u0005o\\2i\u001f:\u001cE.Z1s\u00032dW)\u0019:mS\u0016\u001cH/\u00118e+B$\u0017\r^3JiN|eMZ:fi\"\u0012ae\\\u00018g\"|W\u000f\u001c3Ee>\u0004XI\u001c;sS\u0016\u001c()\u001a;xK\u0016tW\t]8dQ\n{WO\u001c3bef<\u0006.\u001a8SK6|g/\u001b8h\u001d\u0016<Xm\u001d;)\u0005\u001dz\u0017!F:i_VdGm\u00117fCJ\fE\u000e\\#oiJLWm\u001d\u0015\u0003Q=\fqf\u001d5pk2$gj\u001c;SKN,G/\u00129pG\"D\u0015n\u001d;pefDU-\u00193JMVsG-\u001a4j]\u0016$\u0007+Y:tK\u0012D#!K8\u0002_MDw.\u001e7e\u001d>$(+Z:fi\u0016\u0003xn\u00195ISN$xN]=UC&d\u0017JZ+oI\u00164\u0017N\\3e!\u0006\u001c8/\u001a3)\u0005)z\u0017AI:i_VdGMR3uG\"d\u0015\r^3ti\u0016\u0003xn\u00195PM\u0016k\u0007\u000f^=DC\u000eDW\r\u000b\u0002,_\u0006\u00013\u000f[8vY\u00124U\r^2i\u000b:$wJ\u001a4tKR|e-R7qif\u001c\u0015m\u00195fQ\tas.A\u0010tQ>,H\u000eZ\"mK\u0006\u0014X)\u0019:mS\u0016\u001cHo\u00148F[B$\u0018pQ1dQ\u0016D#!L8\u0002;MDw.\u001e7e\u00072,\u0017M\u001d'bi\u0016\u001cHo\u00148F[B$\u0018pQ1dQ\u0016D#AL8\u0002+Q,7\u000f\u001e$j]\u0012\u0004&/\u001a<j_V\u001cX\t]8dQ\"\u0012qf\\\u0001\u0016i\u0016\u001cHOR5oIB\u0013XM^5pkN,e\u000e\u001e:zQ\t\u0001t.A\tuKN$h)\u001b8e\u001d\u0016DH/\u00129pG\"D#!M8\u0002#Q,7\u000f^$fi\u0016\u0003xn\u00195F]R\u0014\u0018\u0010\u000b\u00023_\u0006q2\u000f[8vY\u00124U\r^2i\u000bB|7\r\u001b$pe\u001eKg/\u001a8PM\u001a\u001cX\r\u001e\u0015\u0003g=\u0004")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private final LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
        private Seq<EpochEntry> epochs;

        public void write(Collection<EpochEntry> x$1) {
            super.write(x$1);
        }

        private Seq<EpochEntry> epochs() {
            return this.epochs;
        }

        private void epochs_$eq(Seq<EpochEntry> x$1) {
            this.epochs = x$1;
        }

        public void write(Collection<EpochEntry> epochs, boolean ignored) {
            this.epochs_$eq((Seq<EpochEntry>)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(epochs).asScala()).toSeq());
        }

        public List<EpochEntry> read() {
            return (List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.epochs()).asJava();
        }
        {
            this.epochs = Nil$.MODULE$;
        }
    };
    private final LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), this.checkpoint());

    public TopicPartition tp() {
        return this.tp;
    }

    private LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    private LeaderEpochFileCache cache() {
        return this.cache;
    }

    @Test
    public void testPreviousEpoch() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch());
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch());
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch());
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)OptionalInt.of(4), (Object)this.cache().previousEpoch());
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch());
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        this.cache().assign(2, 10L);
        int logEndOffset = 11;
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new EpochEntry(2, 10L), this.cache().epochEntries().get(0));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        this.cache().assign(2, 11L);
        this.cache().assign(2, 12L);
        int logEndOffset = 14;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        Tuple2.mcIJ.sp expectedEpochEndOffset = new Tuple2.mcIJ.sp(-1, -1L);
        this.cache().assign(2, 11L);
        this.cache().assign(3, 12L);
        Tuple2 epochAndOffsetFor = this.toTuple(this.cache().endOffsetFor(-1, 0L));
        Assertions.assertEquals((Object)expectedEpochEndOffset, epochAndOffsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Cache not empty.");
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        int logEndOffset = 9;
        this.cache().assign(2, (long)logEndOffset);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)logEndOffset, (long)((EpochEntry)this.cache().epochEntries().get((int)0)).startOffset);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(2, 9L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingStartOffsets() {
        this.cache().assign(2, 9L);
        this.cache().assign(3, 9L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(3, 9L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)6L, (long)((EpochEntry)this.cache().epochEntries().get((int)0)).startOffset);
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(0, 0L)));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        Tuple2 offsetFor = this.toTuple(this.cache().endOffsetFor(-1, 73L));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), offsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Empty cache.");
    }

    @Test
    public void shouldReturnFirstEpochIfRequestedEpochLessThanFirstEpoch() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        Tuple2 epochAndOffset = this.toTuple(this.cache().endOffsetFor(4, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(4, 11), epochAndOffset);
    }

    @Test
    public void shouldTruncateIfMatchingEpochButEarlierStartingOffset() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        this.cache().assign(7, 12L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), this.toTuple(this.cache().endOffsetFor(5, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), this.toTuple(this.cache().endOffsetFor(6, 0L)));
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        this.cache().assign(1, 11L);
        this.cache().assign(1, 12L);
        this.cache().assign(2, 13L);
        this.cache().assign(2, 14L);
        this.cache().assign(3, 15L);
        this.cache().assign(3, 16L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 15), this.toTuple(this.cache().endOffsetFor(2, 17L)));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        this.cache().assign(0, 10L);
        this.cache().assign(2, 13L);
        this.cache().assign(4, 17L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 13), this.toTuple(this.cache().endOffsetFor(1, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), this.toTuple(this.cache().endOffsetFor(2, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), this.toTuple(this.cache().endOffsetFor(3, 0L)));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        this.cache().assign(2, 100L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(3, 100L)));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        this.cache().assign(2, 6L);
        int logEndOffset = 7;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils$.MODULE$.tempFile().getAbsolutePath();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(new File(checkpointPath), new LogDirFailureChannel(1));
        new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint).assign(2, 6L);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), new LogDirFailureChannel(1));
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint2);
        Assertions.assertEquals((int)1, (int)cache2.epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), cache2.epochEntries().get(0));
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingEpochs() {
        this.cache().assign(1, 5L);
        this.cache().assign(2, 6L);
        this.cache().assign(1, 7L);
        int logEndOffset = 8;
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 8), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((Object)new EpochEntry(1, 7L), this.cache().epochEntries().get(0));
    }

    private <K, V> Tuple2<K, V> toTuple(Map.Entry<K, V> entry) {
        return new Tuple2(entry.getKey(), entry.getValue());
    }

    @Test
    public void shouldEnforceOffsetsIncreaseMonotonically() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 5L);
        Assertions.assertEquals((Object)new EpochEntry(3, 5L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        long logEndOffset = 0L;
        this.cache().assign(0, 0L);
        this.cache().assign(1, 0L);
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 0), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
        logEndOffset = 5L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
        this.cache().assign(2, 5L);
        logEndOffset = 10L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 10), this.toTuple(this.cache().endOffsetFor(2, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        this.cache().assign(0, 0L);
        this.cache().assign(0, 1L);
        this.cache().assign(0, 2L);
        int logEndOffset = 3;
        Assertions.assertEquals((Object)OptionalInt.of(0), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, logEndOffset), this.toTuple(this.cache().endOffsetFor(0, (long)logEndOffset)));
        this.cache().assign(1, 3L);
        this.cache().assign(1, 4L);
        this.cache().assign(1, 5L);
        logEndOffset = 6;
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, logEndOffset), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        this.cache().assign(2, 8L);
        logEndOffset = 9;
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 3), this.toTuple(this.cache().endOffsetFor(0, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 6), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(8L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(2, 6L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(8L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(3, 8L), new EpochEntry(4, 11L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(1L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(6L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(11L);
        Assertions.assertEquals(Collections.singletonList(new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 7L);
        this.cache().assign(2, 10L);
        this.cache().truncateFromStart(5L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(15L);
        Assertions.assertEquals(Collections.singletonList(new EpochEntry(4, 15L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(9L);
        Assertions.assertEquals((Object)OptionalInt.of(3), (Object)this.cache().latestEpoch());
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldClearAllEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().clearAndFlush();
        Assertions.assertEquals((int)0, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(7, 0L)));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        this.cache().truncateFromStart(7L);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        this.cache().truncateFromEnd(7L);
    }

    @Test
    public void testFindPreviousEpoch() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch(2));
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch(2));
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch(4));
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)OptionalInt.of(4), (Object)this.cache().previousEpoch(10));
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch(this.cache().latestEpoch().getAsInt()));
    }

    @Test
    public void testFindPreviousEntry() {
        Assertions.assertEquals(Optional.empty(), (Object)this.cache().previousEntry(2));
        this.cache().assign(2, 10L);
        Assertions.assertEquals(Optional.empty(), (Object)this.cache().previousEntry(2));
        this.cache().assign(4, 15L);
        Assertions.assertEquals(Optional.of(new EpochEntry(2, 10L)), (Object)this.cache().previousEntry(4));
        this.cache().assign(10, 20L);
        Assertions.assertEquals(Optional.of(new EpochEntry(4, 15L)), (Object)this.cache().previousEntry(10));
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals(Optional.of(new EpochEntry(2, 10L)), (Object)this.cache().previousEntry(this.cache().latestEpoch().getAsInt()));
    }

    @Test
    public void testFindNextEpoch() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 100L);
        this.cache().assign(2, 200L);
        Assertions.assertEquals((Object)OptionalInt.of(0), (Object)this.cache().nextEpoch(-1));
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().nextEpoch(0));
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().nextEpoch(1));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().nextEpoch(2));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().nextEpoch(100));
    }

    @Test
    public void testGetEpochEntry() {
        this.cache().assign(2, 100L);
        this.cache().assign(3, 500L);
        this.cache().assign(5, 1000L);
        Assertions.assertEquals((Object)new EpochEntry(2, 100L), this.cache().epochEntry(2).get());
        Assertions.assertEquals((Object)new EpochEntry(3, 500L), this.cache().epochEntry(3).get());
        Assertions.assertEquals((Object)new EpochEntry(5, 1000L), this.cache().epochEntry(5).get());
    }

    @Test
    public void shouldFetchEpochForGivenOffset() {
        this.cache().assign(0, 10L);
        this.cache().assign(1, 20L);
        this.cache().assign(5, 30L);
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().epochForOffset(25L));
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().epochForOffset(20L));
        Assertions.assertEquals((Object)OptionalInt.of(5), (Object)this.cache().epochForOffset(30L));
        Assertions.assertEquals((Object)OptionalInt.of(5), (Object)this.cache().epochForOffset(50L));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().epochForOffset(5L));
    }
}

