/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tools.StorageTool$;
import kafka.tools.TerseFailure;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@Timeout(value=40L)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\n-BQ\u0001\u000e\u0001\u0005\u0002UBQA\u0012\u0001\u0005\u0002UBQ\u0001\u0013\u0001\u0005\u0002UBQA\u0013\u0001\u0005\u0002UBQ\u0001\u0014\u0001\u0005\u0002UBQA\u0014\u0001\u0005\u0002UBQ\u0001\u0015\u0001\u0005\u0002UBQA\u0015\u0001\u0005\u0002UBQ\u0001\u0016\u0001\u0005\u0002UBQA\u0016\u0001\u0005\u0002UBQ\u0001\u0017\u0001\u0005\u0002UBQA\u0017\u0001\u0005\u0002UBQ\u0001\u0018\u0001\u0005\u0002U2AA\u0018\u0001\u0001?\"A\u0011\u000e\u0005B\u0001B\u0003%!\u000eC\u0003'!\u0011\u0005Q\u000fC\u0003z\u0001\u0011\u0005Q\u0007C\u0003|\u0001\u0011\u0005Q\u0007C\u0003~\u0001\u0011\u0005Q\u0007\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\u0007\u0003c\u0001A\u0011A\u001b\t\r\u0005U\u0002\u0001\"\u00016\u0005=\u0019Fo\u001c:bO\u0016$vn\u001c7UKN$(BA\u000e\u001d\u0003\u0015!xn\u001c7t\u0015\u0005i\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u001b\u0003aqWm^*fY\u001al\u0015M\\1hK\u0012\u0004&o\u001c9feRLWm\u001d\u000b\u0002YA\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0005kRLGNC\u00012\u0003\u0011Q\u0017M^1\n\u0005Mr#A\u0003)s_B,'\u000f^5fg\u0006QB/Z:u\u0007>tg-[4U_2{w\rR5sK\u000e$xN]5fgR\ta\u0007\u0005\u0002\"o%\u0011\u0001H\t\u0002\u0005+:LG\u000f\u000b\u0002\u0004uA\u00111\bR\u0007\u0002y)\u0011QHP\u0001\u0004CBL'BA A\u0003\u001dQW\u000f]5uKJT!!\u0011\"\u0002\u000b),h.\u001b;\u000b\u0003\r\u000b1a\u001c:h\u0013\t)EH\u0001\u0003UKN$\u0018\u0001\u000b;fgR\u001cuN\u001c4jOR{Gj\\4ESJ,7\r^8sS\u0016\u001cx+\u001b;i\u001b\u0016$\u0018\rT8h\t&\u0014\bF\u0001\u0003;\u0003}!Xm\u001d;J]\u001a|7i\\7nC:$wJ\\#naRLH)\u001b:fGR|'/\u001f\u0015\u0003\u000bi\n\u0011\u0005^3ti&sgm\\\"p[6\fg\u000eZ(o\u001b&\u001c8/\u001b8h\t&\u0014Xm\u0019;pefD#A\u0002\u001e\u0002AQ,7\u000f^%oM>\u001cu.\\7b]\u0012|e\u000eR5sK\u000e$xN]=Bg\u001aKG.\u001a\u0015\u0003\u000fi\nq\u0005^3ti&sgm\\,ji\"l\u0015n]7bi\u000eDW\r\u001a'fO\u0006\u001c\u0017pS1gW\u0006\u001cuN\u001c4jO\"\u0012\u0001BO\u0001-i\u0016\u001cH/\u00138g_^KG\u000f['jg6\fGo\u00195fIN+GNZ'b]\u0006<W\rZ&bM.\f7i\u001c8gS\u001eD#!\u0003\u001e\u00021Q,7\u000f\u001e$pe6\fG/R7qif$\u0015N]3di>\u0014\u0018\u0010\u000b\u0002\u000bu\u0005qB/Z:u\r>\u0014X.\u0019;XSRD\u0017J\u001c<bY&$7\t\\;ti\u0016\u0014\u0018\n\u001a\u0015\u0003\u0017i\n!\u0004^3ti\u0012+g-Y;mi6+G/\u00193bi\u00064VM]:j_:D#\u0001\u0004\u001e\u0002;Q,7\u000f^\"p]\u001aLw-\u001e:fI6+G/\u00193bi\u00064VM]:j_:D#!\u0004\u001e\u00021Q,7\u000f^'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8GY\u0006<7\u000f\u000b\u0002\u000fu\u0005aA/Z:u\u0003\u0012$7k\u0019:b[\"\u0012qB\u000f\u0002\u0019'R|'/Y4f)>|G\u000eV3ti\u0016C8-\u001a9uS>t7C\u0001\ta!\t\tw-D\u0001c\u0015\t\u0019G-\u0001\u0004d_6lwN\u001c\u0006\u0003;\u0015T!A\u001a\"\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tA'M\u0001\bLC\u001a\\\u0017-\u0012=dKB$\u0018n\u001c8\u0002\u000f5,7o]1hKB\u00111N\u001d\b\u0003YB\u0004\"!\u001c\u0012\u000e\u00039T!a\u001c\u0010\u0002\rq\u0012xn\u001c;?\u0013\t\t(%\u0001\u0004Qe\u0016$WMZ\u0005\u0003gR\u0014aa\u0015;sS:<'BA9#)\t1\b\u0010\u0005\u0002x!5\t\u0001\u0001C\u0003j%\u0001\u0007!.A\u0010uKN$8k\u0019:b[^KG\u000f\u001b\"bI6+G/\u00193bi\u00064VM]:j_:D#a\u0005\u001e\u0002=Q,7\u000f\u001e(p'\u000e\u0014\u0018-\\,ji\"lU\r^1eCR\fg+\u001a:tS>t\u0007F\u0001\u000b;\u0003U!Xm\u001d;ESJ,V/\u001b3HK:,'/\u0019;j_:D#!\u0006\u001e\u0002YQ,7\u000f\u001e$pe6\fG\u000f^5oOVs7\u000f^1cY\u0016lU\r^1eCR\fg+\u001a:tS>t'\t\\8dW\u0016$Gc\u0001\u001c\u0002\u0004!9\u0011Q\u0001\fA\u0002\u0005\u001d\u0011AD3oC\ndW-\u00168ti\u0006\u0014G.\u001a\t\u0004C\u0005%\u0011bAA\u0006E\t9!i\\8mK\u0006t\u0007f\u0002\f\u0002\u0010\u0005}\u0011\u0011\u0005\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003!\u0001(o\u001c<jI\u0016\u0014(bAA\r}\u00051\u0001/\u0019:b[NLA!!\b\u0002\u0014\tYa+\u00197vKN{WO]2f\u0003!\u0011wn\u001c7fC:\u001cH\u0006BA\u0012\u0003KI\u0012\u0001A\r\u0002\u0003!\u001aa#!\u000b\u0011\t\u0005-\u0012QF\u0007\u0003\u0003/IA!a\f\u0002\u0018\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002WQ,7\u000f\u001e$pe6\fGOV1mS\u0012\fG/Z:D_:4\u0017n\u001a$pe6+G/\u00193bi\u00064VM]:j_:D#a\u0006\u001e\u00023Q,7\u000f\u001e&c_\u0012\u001cV\u000f\u001d9peR4\u0016\r\\5eCRLwN\u001c\u0015\u00031iBs\u0001AA\u001e\u0003\u0003\n\u0019\u0005E\u0002<\u0003{I1!a\u0010=\u0005\u001d!\u0016.\\3pkR\fQA^1mk\u0016t\u0012\u0001\u000b")
public class StorageToolTest {
    private Properties newSelfManagedProperties() {
        Properties properties = new Properties();
        properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), "/tmp/foo,/tmp/bar");
        properties.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        properties.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9092");
        properties.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "PLAINTEXT");
        return properties;
    }

    @Test
    public void testConfigToLogDirectories() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$)), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testConfigToLogDirectoriesWithMetaLogDir() {
        Properties properties = this.newSelfManagedProperties();
        properties.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), "/tmp/baz");
        KafkaConfig config = new KafkaConfig((Map)properties);
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/baz", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$))), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testInfoCommandOnEmptyDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(62).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound problem:\n  ").append(tempDir.toString()).append(" is not formatted.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnMissingDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        tempDir.delete();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(34).append("Found problem:\n  ").append(tempDir.toString()).append(" does not exist\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnDirectoryAsFile() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempFile = TestUtils$.MODULE$.tempFile();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempFile.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(38).append("Found problem:\n  ").append(tempFile.toString()).append(" is not a directory\n\n").toString(), (Object)stream.toString());
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testInfoWithMismatchedLegacyKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList((Object[])new String[]{"version=1", "node.id=1", "cluster.id=XcZZOzUqS4yHOjhMQB6JLQ"})).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), false, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(246).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {cluster.id=XcZZOzUqS4yHOjhMQB6JLQ, node.id=1, version=1}\n\nFound problem:\n  The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoWithMismatchedSelfManagedKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList((Object[])new String[]{"version=0", "broker.id=1", "cluster.id=26c36907-4158-4a35-919d-6534229f5241"})).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(257).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {broker.id=1, cluster.id=26c36907-4158-4a35-919d-6534229f5241, version=0}\n\nFound problem:\n  The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testFormatEmptyDirectory() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("XcZZOzUqS4yHOjhMQB6JLQ").setNodeId(2).build();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            BootstrapMetadata bootstrapMetadata = StorageTool$.MODULE$.buildBootstrapMetadata(MetadataVersion.latestTesting(), (Option)None$.MODULE$, "test format command");
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(stream), (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latestTesting(), false));
            Assertions.assertTrue((boolean)stream.toString().startsWith(new StringOps(Predef$.MODULE$.augmentString("Formatting %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempDir}))));
            try {
                Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(new ByteArrayOutputStream()), (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latestTesting(), false));
            }
            catch (TerseFailure e) {
                Assertions.assertEquals((Object)new StringBuilder(107).append("Log directory ").append(tempDir).append(" is already ").append("formatted. Use --ignore-formatted to ignore this directory and format the ").append("others.").toString(), (Object)e.getMessage());
            }
            ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(stream2), (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latestTesting(), true));
            Assertions.assertEquals((Object)new StringOps(Predef$.MODULE$.augmentString("All of the log directories are already formatted.%n")).format((Seq)Nil$.MODULE$), (Object)stream2.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testFormatWithInvalidClusterId() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)"Cluster ID string invalid does not appear to be a valid UUID: Input string `invalid` decoded as 5 bytes, which is not equal to the expected 16 bytes of a base64-encoded UUID", (Object)Assertions.assertThrows(TerseFailure.class, () -> StorageTool$.MODULE$.buildMetadataProperties("invalid", config)).getMessage());
    }

    @Test
    public void testDefaultMetadataVersion() {
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        MetadataVersion mv = StorageTool$.MODULE$.getMetadataVersion(namespace, (Option)None$.MODULE$);
        Assertions.assertEquals((short)MetadataVersion.LATEST_PRODUCTION.featureLevel(), (short)mv.featureLevel(), (String)"Expected the default metadata.version to be the latest production version");
    }

    @Test
    public void testConfiguredMetadataVersion() {
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        MetadataVersion mv = StorageTool$.MODULE$.getMetadataVersion(namespace, (Option)new Some((Object)MetadataVersion.IBP_3_3_IV2.toString()));
        Assertions.assertEquals((short)MetadataVersion.IBP_3_3_IV2.featureLevel(), (short)mv.featureLevel(), (String)"Expected the default metadata.version to be 3.3-IV2");
    }

    @Test
    public void testMetadataVersionFlags() {
        MetadataVersion mv = StorageToolTest.parseMetadataVersion$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.0"}));
        Assertions.assertEquals((Object)"3.0", (Object)mv.shortVersion());
        mv = StorageToolTest.parseMetadataVersion$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.0-IV1"}));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)mv);
        Assertions.assertThrows(IllegalArgumentException.class, () -> StorageToolTest.parseMetadataVersion$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "0.0"})));
    }

    @Test
    public void testAddScram() {
        Option scramRecords = StorageToolTest.parseAddScram$1((Seq)Nil$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)scramRecords);
        scramRecords = StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]", "-S", "SCRAM-SHA-256=[name=george,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"}));
        Assertions.assertEquals((int)2, (int)((SeqLike)scramRecords.get()).size());
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must supply 'name' to add-scram", (Object)e.getMessage());
        }
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must only supply one of 'password' or 'saltedpassword' to add-scram", (Object)e.getMessage());
        }
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must supply one of 'password' or 'saltedpassword' to add-scram", (Object)e.getMessage());
        }
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must supply 'salt' with 'saltedpassword' to add-scram", (Object)e.getMessage());
        }
        Assertions.assertEquals((int)1, (int)((SeqLike)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,password=alice,iterations=4096]"})).get()).size());
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=16385]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"The 'iterations' value must be <= 16384 for add-scram", (Object)e.getMessage());
        }
        Assertions.assertEquals((int)1, (int)((SeqLike)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=16384]"})).get()).size());
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=4095]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"The 'iterations' value must be >= 4096 for add-scram", (Object)e.getMessage());
        }
        Assertions.assertEquals((int)1, (int)((SeqLike)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=4096]"})).get()).size());
        Assertions.assertEquals((int)1, (int)((SeqLike)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,password=alice]"})).get()).size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testScramWithBadMetadataVersion() {
        void setExitProcedure_exitProcedure;
        ObjectRef exitString = ObjectRef.create((Object)"");
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(exitStatus, message) -> this.exitProcedure$1(BoxesRunTime.unboxToInt((Object)exitStatus), message, exitString);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Properties properties = this.newSelfManagedProperties();
        File propsFile = TestUtils$.MODULE$.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        properties.store(propsStream, "config.props");
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"format", "-c", String.valueOf(propsFile.toPath()), "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.4", "-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=8192]"});
        try {
            try {
                Integer n = BoxesRunTime.boxToInteger((int)1);
                StorageTool$.MODULE$.main(args);
                Assertions.assertEquals((Object)n, (Object)BoxedUnit.UNIT);
            }
            catch (StorageToolTestException storageToolTestException) {
                Assertions.assertEquals((Object)"SCRAM is only supported in metadataVersion IBP_3_5_IV2 or later.", (Object)((String)exitString.elem));
            }
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoScramWithMetadataVersion() {
        void setExitProcedure_exitProcedure;
        ObjectRef exitString = ObjectRef.create((Object)"");
        IntRef exitStatus = IntRef.create((int)1);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(status, message) -> this.exitProcedure$2(BoxesRunTime.unboxToInt((Object)status), message, exitStatus, exitString);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Properties properties = this.newSelfManagedProperties();
        File propsFile = TestUtils$.MODULE$.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), TestUtils$.MODULE$.tempDir().toString());
        properties.store(propsStream, "config.props");
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"format", "-c", String.valueOf(propsFile.toPath()), "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.4"});
        try {
            try {
                StorageTool$.MODULE$.main(args);
            }
            catch (StorageToolTestException storageToolTestException) {
                Assertions.assertEquals((Object)"", (Object)((String)exitString.elem));
                Assertions.assertEquals((int)0, (int)exitStatus.elem);
            }
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void testDirUuidGeneration() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            MetaProperties metaProperties = new MetaProperties.Builder().setClusterId("XcZZOzUqS4yHOjhMQB6JLQ").setNodeId(2).build();
            BootstrapMetadata bootstrapMetadata = StorageTool$.MODULE$.buildBootstrapMetadata(MetadataVersion.latestTesting(), (Option)None$.MODULE$, "test format command");
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM), (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latestTesting(), false));
            File metaPropertiesFile = Paths.get(tempDir.toURI()).resolve("meta.properties").toFile();
            Assertions.assertTrue((boolean)metaPropertiesFile.exists());
            MetaProperties metaProps = new MetaProperties.Builder(PropertiesUtils.readPropertiesFile((String)metaPropertiesFile.getAbsolutePath())).build();
            Assertions.assertTrue((boolean)metaProps.directoryId().isPresent());
            Assertions.assertFalse((boolean)DirectoryId.reserved((Uuid)((Uuid)metaProps.directoryId().get())));
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormattingUnstableMetadataVersionBlocked(boolean enableUnstable) {
        void setExitProcedure_exitProcedure;
        ObjectRef exitString = ObjectRef.create((Object)"");
        IntRef exitStatus = IntRef.create((int)1);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(status, message) -> this.exitProcedure$3(BoxesRunTime.unboxToInt((Object)status), message, exitStatus, exitString);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Properties properties = this.newSelfManagedProperties();
        File propsFile = TestUtils$.MODULE$.tempFile();
        try (OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);){
            properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), TestUtils$.MODULE$.tempDir().toString());
            properties.setProperty(KafkaConfig$.MODULE$.UnstableMetadataVersionsEnableProp(), Boolean.toString(enableUnstable));
            properties.store(propsStream, "config.props");
        }
        String[] args = (String[])((Object[])new String[]{"format", "-c", String.valueOf(propsFile.toPath()), "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", MetadataVersion.latestTesting().toString()});
        try {
            try {
                StorageTool$.MODULE$.main(args);
            }
            catch (StorageToolTestException storageToolTestException) {}
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
        if (enableUnstable) {
            Assertions.assertEquals((Object)"", (Object)((String)exitString.elem));
            Assertions.assertEquals((int)0, (int)exitStatus.elem);
            return;
        }
        Assertions.assertEquals((Object)new StringBuilder(54).append("Metadata version ").append(MetadataVersion.latestTesting().toString()).append(" is not ready for ").append("production use yet.").toString(), (Object)((String)exitString.elem));
        Assertions.assertEquals((int)1, (int)exitStatus.elem);
    }

    @Test
    public void testFormatValidatesConfigForMetadataVersion() {
        KafkaConfig config = (KafkaConfig)Mockito.spy((Object)new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(10, null, TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())));
        String[] args = (String[])((Object[])new String[]{"format", "-c", "dummy.properties", "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", MetadataVersion.LATEST_PRODUCTION.toString()});
        int exitCode = StorageTool$.MODULE$.runFormatCommand(StorageTool$.MODULE$.parseArguments(args), config);
        ((KafkaConfig)Mockito.verify((Object)config, (VerificationMode)Mockito.times((int)1))).validateWithMetadataVersion(MetadataVersion.LATEST_PRODUCTION);
        Assertions.assertEquals((int)0, (int)exitCode);
    }

    @Test
    public void testJbodSupportValidation() {
        Assertions.assertEquals((int)0, (Integer)StorageToolTest.formatWith$1(1, MetadataVersion.IBP_3_6_IV2));
        Assertions.assertEquals((Object)"Invalid configuration for metadata version: requirement failed: Multiple log directories (aka JBOD) are not supported in the current MetadataVersion 3.6-IV2. Need 3.7-IV2 or higher", (Object)Assertions.assertThrows(TerseFailure.class, () -> StorageToolTest.formatWith$1(2, MetadataVersion.IBP_3_6_IV2)).getMessage());
        Assertions.assertEquals((int)0, (Integer)StorageToolTest.formatWith$1(1, MetadataVersion.IBP_3_7_IV2));
        Assertions.assertEquals((int)0, (Integer)StorageToolTest.formatWith$1(2, MetadataVersion.IBP_3_7_IV2));
    }

    private static final MetadataVersion parseMetadataVersion$1(Seq strings) {
        scala.collection.mutable.Seq args = (scala.collection.mutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        args = (scala.collection.mutable.Seq)args.$plus$plus((GenTraversableOnce)strings, Seq$.MODULE$.canBuildFrom());
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)));
        return StorageTool$.MODULE$.getMetadataVersion(namespace, (Option)None$.MODULE$);
    }

    private static final Option parseAddScram$1(Seq strings) {
        scala.collection.mutable.Seq args = (scala.collection.mutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        args = (scala.collection.mutable.Seq)args.$plus$plus((GenTraversableOnce)strings, Seq$.MODULE$.canBuildFrom());
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)));
        return StorageTool$.MODULE$.getUserScramCredentialRecords(namespace);
    }

    private final Nothing$ exitProcedure$1(int exitStatus, Option message, ObjectRef exitString$1) {
        exitString$1.elem = (String)message.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        throw new StorageToolTestException((String)exitString$1.elem);
    }

    private final Nothing$ exitProcedure$2(int status, Option message, IntRef exitStatus$1, ObjectRef exitString$2) {
        exitStatus$1.elem = status;
        exitString$2.elem = (String)message.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        throw new StorageToolTestException((String)exitString$2.elem);
    }

    private final Nothing$ exitProcedure$3(int status, Option message, IntRef exitStatus$2, ObjectRef exitString$3) {
        exitStatus$2.elem = status;
        exitString$3.elem = (String)message.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        throw new StorageToolTestException((String)exitString$3.elem);
    }

    private static final Integer formatWith$1(int logDirCount, MetadataVersion metadataVersion) {
        int x$1 = 10;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$12 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$17 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, logDirCount, x$18, x$19, x$20, x$21);
        properties.remove(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp());
        String configFile = ((Object)TestUtils$.MODULE$.tempPropertiesFile(properties).toPath()).toString();
        return Predef$.MODULE$.int2Integer(StorageTool$.MODULE$.execute((String[])((Object[])new String[]{"format", "-c", configFile, "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", metadataVersion.toString()})));
    }

    public class StorageToolTestException
    extends KafkaException {
        public /* synthetic */ StorageToolTest kafka$tools$StorageToolTest$StorageToolTestException$$$outer() {
            return StorageToolTest.this;
        }

        public StorageToolTestException(String message) {
            if (StorageToolTest.this == null) {
                throw null;
            }
            super(message);
        }
    }
}

