/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.security.authorizer.AclEntry$;
import kafka.server.ConfigType$;
import kafka.server.ControllerMigrationSupport;
import kafka.server.ControllerServer;
import kafka.server.KRaftCachedControllerId;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.test.ClusterGenerator;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.NoOpPasswordEncoder;
import kafka.utils.PasswordEncoder;
import kafka.utils.PasswordEncoder$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import kafka.zk.TopicZNode;
import kafka.zk.ZkMigrationClient;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkMigrationIntegrationTest$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.migration.MigrationDriverState;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.SetLike;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ExtendWith(value={ClusterTestExtensions.class})
@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0001\r\rv!\u0002\u00192\u0011\u00031d!\u0002\u001d2\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005\"\u0002\"\u0002\t\u0003\u0019\u0005\"B)\u0002\t\u0003\u0011f\u0001\u0002\u001d2\u0001mCQ\u0001Q\u0003\u0005\u0002qCqAX\u0003C\u0002\u0013\u0005q\f\u0003\u0004i\u000b\u0001\u0006I\u0001\u0019\u0004\u0005S\u0016\u0001!\u000eC\u0003A\u0013\u0011\u00051\u000eC\u0004o\u0013\t\u0007I\u0011A8\t\reL\u0001\u0015!\u0003q\u0011\u001dQ\u0018\u00021A\u0005\u0002mD\u0001b`\u0005A\u0002\u0013\u0005\u0011\u0011\u0001\u0005\b\u0003\u000fI\u0001\u0015)\u0003}\u0011\u001d\tI!\u0003C\u0001\u0003\u0017Aq!a\n\n\t\u0003\tI\u0003C\u0004\u0002<\u0015!\t!!\u0010\t\u000f\u0005\u0005V\u0001\"\u0001\u0002$\"9\u0011\u0011[\u0003\u0005\u0002\u0005M\u0007bBAm\u000b\u0011\u0005\u00111\u001c\u0005\b\u0003S,A\u0011AAv\u0011\u001d\t\u00190\u0002C\u0001\u0003kDqAa\u0001\u0006\t\u0003\u0011)\u0001C\u0004\u0003\f\u0015!\tA!\u0004\t\u000f\tUQ\u0001\"\u0001\u0003\u0018!9!qD\u0003\u0005\u0002\t\u0005\u0002b\u0002B\u0019\u000b\u0011\u0005!1\u0007\u0005\b\u0005w)A\u0011\u0001B\u001f\u0011\u001d\u0011\u0019)\u0002C\u0001\u0005\u000bCqAa'\u0006\t\u0003\u0011i\nC\u0004\u0003(\u0016!\tA!+\t\u000f\tEV\u0001\"\u0001\u00034\"9!1X\u0003\u0005\u0002\tu\u0006b\u0002Bd\u000b\u0011\u0005!\u0011\u001a\u0005\b\u0005;,A\u0011\u0001Bp\u0011\u001d\u0019)\"\u0002C\u0001\u0007/Aqa!\t\u0006\t\u0003\u0019\u0019\u0003C\u0004\u0004(\u0015!\ta!\u000b\t\u000f\r5R\u0001\"\u0001\u00040!911G\u0003\u0005\u0002\rU\u0002bBB \u000b\u0011\u00051\u0011\t\u0005\b\u0007\u000b*A\u0011AB$\u0011\u001d\u0019Y%\u0002C\u0001\u0007\u001bBqa!\u0015\u0006\t\u0003\u0019\u0019\u0006C\u0004\u0004X\u0015!\ta!\u0017\t\u000f\ruS\u0001\"\u0001\u0004`\u0005Q\"l['jOJ\fG/[8o\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011!gM\u0001\u0003u.T\u0011\u0001N\u0001\u0006W\u000647.Y\u0002\u0001!\t9\u0014!D\u00012\u0005iQ6.T5he\u0006$\u0018n\u001c8J]R,wM]1uS>tG+Z:u'\t\t!\b\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDH\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\n\u0001#\u00193e5.\u0014%o\\6feB\u0013x\u000e]:\u0015\u0005\u0011;\u0005CA\u001eF\u0013\t1EH\u0001\u0003V]&$\b\"\u0002%\u0004\u0001\u0004I\u0015!\u00029s_B\u001c\bC\u0001&P\u001b\u0005Y%B\u0001'N\u0003\u0011)H/\u001b7\u000b\u00039\u000bAA[1wC&\u0011\u0001k\u0013\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\t>l\u00072,8\u000f^3sg\u001a{'/\u00117m\u001b&<'/\u0019;j_:4VM]:j_:\u001cHC\u0001#T\u0011\u0015!F\u00011\u0001V\u0003A\u0019G.^:uKJ<UM\\3sCR|'\u000f\u0005\u0002W36\tqK\u0003\u0002Yg\u0005!A/Z:u\u0013\tQvK\u0001\tDYV\u001cH/\u001a:HK:,'/\u0019;peN\u0011QA\u000f\u000b\u0002;B\u0011q'B\u0001\u0004Y><W#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017!B:mMRR'\"A3\u0002\u0007=\u0014x-\u0003\u0002hE\n1Aj\\4hKJ\fA\u0001\\8hA\t)R*\u001a;bI\u0006$\u0018\rR3mi\u00064VM]5gS\u0016\u00148CA\u0005;)\u0005a\u0007CA7\n\u001b\u0005)\u0011!D7fi\u0006$\u0017\r^1EK2$\u0018-F\u0001q!\t\tx/D\u0001s\u0015\t\u0019H/A\u0003j[\u0006<WM\u0003\u00025k*\u0011a\u000fZ\u0001\u0007CB\f7\r[3\n\u0005a\u0014(!D'fi\u0006$\u0017\r^1EK2$\u0018-\u0001\bnKR\fG-\u0019;b\t\u0016dG/\u0019\u0011\u0002\r=4gm]3u+\u0005a\bCA\u001e~\u0013\tqHHA\u0002J]R\f!b\u001c4gg\u0016$x\fJ3r)\r!\u00151\u0001\u0005\t\u0003\u000bq\u0011\u0011!a\u0001y\u0006\u0019\u0001\u0010J\u0019\u0002\u000f=4gm]3uA\u00051\u0011mY2faR$2\u0001RA\u0007\u0011\u001d\ty\u0001\u0005a\u0001\u0003#\tQAY1uG\"\u0004RASA\n\u0003/I1!!\u0006L\u0005\u0011a\u0015n\u001d;\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u000511m\\7n_:T1!!\tu\u0003\u0019\u0019XM\u001d<fe&!\u0011QEA\u000e\u0005Q\t\u0005/['fgN\fw-Z!oIZ+'o]5p]\u00061a/\u001a:jMf$2\u0001RA\u0016\u0011\u001d\ti#\u0005a\u0001\u0003_\t\u0001B^3sS\u001aLWM\u001d\t\u0007w\u0005E\u0012Q\u0007#\n\u0007\u0005MBHA\u0005Gk:\u001cG/[8ocA\u0019\u0011/a\u000e\n\u0007\u0005e\"OA\u0007NKR\fG-\u0019;b\u00136\fw-Z\u0001\u0010i\u0016\u001cH/T5he\u0006$X-Q2mgR\u0019A)a\u0010\t\u000f\u0005\u0005#\u00031\u0001\u0002D\u0005y1\r\\;ti\u0016\u0014\u0018J\\:uC:\u001cW\rE\u0002W\u0003\u000bJ1!a\u0012X\u0005=\u0019E.^:uKJLen\u001d;b]\u000e,\u0007f\u0006\n\u0002L\u0005]\u0013\u0011LA.\u0003;\n9'!\u001b\u0002t\u0005U\u0014qPAA!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)/\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u0013q\n\u0002\f\u00072,8\u000f^3s)\u0016\u001cH/A\u0004ce>\\WM]:\u001e\u0003\r\t1b\u00197vgR,'\u000fV=qK\u0012\u0012\u0011qL\u0005\u0005\u0003C\n\u0019'\u0001\u0002[\u0017*!\u0011QMA(\u0003\u0011!\u0016\u0010]3\u0002\u0013\u0005,Ho\\*uCJ$HEAA6\u0013\u0011\ti'a\u001c\u0002\u0007e+5K\u0003\u0003\u0002r\u0005=\u0013!C!vi>\u001cF/\u0019:u\u0003=iW\r^1eCR\fg+\u001a:tS>tGEAA<\u0013\u0011\tI(a\u001f\u0002\u0017%\u0013\u0005kX\u001a`m}Ke+\r\u0006\u0005\u0003{\nY\"A\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003A\u0019XM\u001d<feB\u0013x\u000e]3si&,7\u000f\f\u0003\u0002\u0004\u0006]5FCAC\u0003\u0017\u000bi)!%\u0002\u0014B!\u0011QJAD\u0013\u0011\tI)a\u0014\u0003+\rcWo\u001d;fe\u000e{gNZ5h!J|\u0007/\u001a:us\u0006\u00191.Z=\"\u0005\u0005=\u0015!F1vi\"|'/\u001b>fe:\u001aG.Y:t]9\fW.Z\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003+\u000bqe[1gW\u0006t3/Z2ve&$\u0018PL1vi\"|'/\u001b>fe:\n5\r\\!vi\"|'/\u001b>fe.R\u0011QQAF\u00033\u000b\t*!(\"\u0005\u0005m\u0015aC:va\u0016\u0014h&^:feN\f#!a(\u0002\u001dU\u001bXM\u001d\u001eB\u001d>s\u0015,T(V'\u0006yB/Z:u'R\f'\u000f\u001e.l\u0005J|7.\u001a:XSRD\u0017)\u001e;i_JL'0\u001a:\u0015\u0007\u0011\u000b)\u000bC\u0004\u0002(N\u0001\r!a\u0011\u0002\u0013i\\7\t\\;ti\u0016\u0014\bfF\n\u0002L\u0005]\u0013\u0011LA.\u0003;\n9'!\u001b\u0002t\u0005U\u0014qPAVY1\t\u0019)a&\u0002.\u0006]\u0016\u0011YAdW)\t))a#\u00020\u0006E\u00151W\u0011\u0003\u0003c\u000b!$\u001b8uKJt#M]8lKJtC.[:uK:,'O\f8b[\u0016\f#!!.\u0002\u0011\u0015CF+\u0012*O\u00032[#\"!\"\u0002\f\u0006e\u0016\u0011SA_C\t\tY,A\u0005mSN$XM\\3sg\u0006\u0012\u0011qX\u0001/!2\u000b\u0015J\u0014+F1RStf\f7pG\u0006d\u0007n\\:uuAbS\t\u0017+F%:\u000bEJO\u00180Y>\u001c\u0017\r\u001c5pgRT\u0004g\u000b\u0006\u0002\u0006\u0006-\u00151YAI\u0003{\u000b#!!2\u0002)\u0005$g/\u001a:uSN,GM\f7jgR,g.\u001a:tW)\t))a#\u0002J\u0006E\u0015QZ\u0011\u0003\u0003\u0017\fa\u0004\\5ti\u0016tWM\u001d\u0018tK\u000e,(/\u001b;z]A\u0014x\u000e^8d_2tS.\u00199\"\u0005\u0005=\u0017AJ#Y)\u0016\u0013f*\u0011';!2\u000b\u0015J\u0014+F1Rc\u0003\u000bT!J\u001dR+\u0005\f\u0016\u001eQ\u0019\u0006Ke\nV#Y)\u0006YA/Z:u\u001b&<'/\u0019;f)\r!\u0015Q\u001b\u0005\b\u0003\u0003\"\u0002\u0019AA\"Q=!\u00121JA,\u00033\nY&!\u0018\u0002t\u0005U\u0014!\u0007;fgRl\u0015n\u001a:bi\u0016$v\u000e]5d\t\u0016dW\r^5p]N$2\u0001RAo\u0011\u001d\t9+\u0006a\u0001\u0003\u0007Bs!FAq\u0003#\u000b9\u000f\u0005\u0003\u0002N\u0005\r\u0018\u0002BAs\u0003\u001f\u0012qb\u00117vgR,'\u000fV3na2\fG/Z\u0011\u0002#\u0006\u0011B/Z:u\tV\fGn\u0016:ji\u0016\u001c6M]1n)\r!\u0015Q\u001e\u0005\b\u0003O3\u0002\u0019AA\"QM1\u00121JA.\u0003;\n9&!\u0017\u0002t\u0005U\u0014qPAyY!\ti+a.\u0002B\u0006\u001d\u0017A\u0006;fgR$U\r\\3uK2{wm\u00148Ti\u0006\u0014H/\u001e9\u0015\u0007\u0011\u000b9\u0010C\u0004\u0002(^\u0001\r!a\u0011)']\tY%a\u0017\u0002^\u0005]\u0013\u0011LA:\u0003w\fyH!\u0001%\u0005\u0005u\u0018\u0002BA\u0000\u0003w\n1\"\u0013\"Q?Nz\u0006hX%Wa1B\u0011QVA\\\u0003\u0003\f9-A\u0007uKN$H)^1m/JLG/\u001a\u000b\u0004\t\n\u001d\u0001bBAT1\u0001\u0007\u00111\t\u0015\b1\u0005\u0005\u0018\u0011SAt\u0003i!Xm\u001d;Ek\u0006dwK]5uKF+x\u000e^1B]\u0012\u001c6M]1n)\r!%q\u0002\u0005\b\u0003OK\u0002\u0019AA\"QMI\u00121JA.\u0003;\n9&!\u0017\u0002t\u0005U\u0014q\u0010B\nY!\ti+a.\u0002B\u0006\u001d\u0017A\t;fgRtUm^!oI\u000eC\u0017M\\4fIR{\u0007/[2t\u0013:$U/\u00197Xe&$X\rF\u0002E\u00053Aq!a*\u001b\u0001\u0004\t\u0019\u0005K\n\u001b\u0003\u0017\nY&!\u0018\u0002X\u0005e\u00131OA;\u0003\u007f\u0012i\u0002\f\u0005\u0002.\u0006]\u0016\u0011YAd\u0003\u0015\"Xm\u001d;QCJ$\u0018\u000e^5p]J+\u0017m]:jO:lWM\u001c;J]\"K(M]5e\u001b>$W\rF\u0002E\u0005GAq!a*\u001c\u0001\u0004\t\u0019\u0005K\n\u001c\u0003\u0017\nY&!\u0018\u0002X\t\u001d\u00121\u000fB\u0015\u0003\u007f\u0012y#H\u0001\u0005I\t\u0011Y#\u0003\u0003\u0003.\u0005m\u0014aC%C!~\u001btlN0J-Bb\u0003\"!,\u00028\u0006\u0005\u0017qY\u0001(i\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:Qe\u0016l\u0015n\u001a:bi&|g\u000eF\u0002E\u0005kAq!a*\u001d\u0001\u0004\t\u0019\u0005K\n\u001d\u0003\u0017\nY&!\u0018\u0002X\u0005e\u00131OA;\u0003\u007f\u0012I\u0004\f\u0005\u0002.\u0006]\u0016\u0011YAd\u0003-\u0019'/Z1uKR{\u0007/[2\u0015\u0017\u0011\u0013yD!\u0017\u0003^\t\u001d$\u0011\u000f\u0005\b\u0005\u0003j\u0002\u0019\u0001B\"\u0003%!x\u000e]5d\u001d\u0006lW\r\u0005\u0003\u0003F\tMc\u0002\u0002B$\u0005\u001f\u00022A!\u0013=\u001b\t\u0011YEC\u0002\u0003NU\na\u0001\u0010:p_Rt\u0014b\u0001B)y\u00051\u0001K]3eK\u001aLAA!\u0016\u0003X\t11\u000b\u001e:j]\u001eT1A!\u0015=\u0011\u0019\u0011Y&\ba\u0001y\u0006ia.^7QCJ$\u0018\u000e^5p]NDqAa\u0018\u001e\u0001\u0004\u0011\t'A\tsKBd\u0017nY1uS>tg)Y2u_J\u00042a\u000fB2\u0013\r\u0011)\u0007\u0010\u0002\u0006'\"|'\u000f\u001e\u0005\b\u0005Sj\u0002\u0019\u0001B6\u0003\u001d\u0019wN\u001c4jON\u0004rA\u0013B7\u0005\u0007\u0012\u0019%C\u0002\u0003p-\u00131!T1q\u0011\u001d\u0011\u0019(\ba\u0001\u0005k\nQ!\u00193nS:\u0004BAa\u001e\u0003\u00005\u0011!\u0011\u0010\u0006\u0005\u0005g\u0012YHC\u0002\u0003~Q\fqa\u00197jK:$8/\u0003\u0003\u0003\u0002\ne$!B!e[&t\u0017a\u0003<fe&4\u0017\u0010V8qS\u000e$R\u0002\u0012BD\u0005\u0013\u0013YI!$\u0003\u0010\nE\u0005b\u0002B!=\u0001\u0007!1\t\u0005\u0007\u00057r\u0002\u0019\u0001?\t\u000f\t}c\u00041\u0001\u0003b!9!\u0011\u000e\u0010A\u0002\t-\u0004b\u0002B:=\u0001\u0007!Q\u000f\u0005\b\u0005's\u0002\u0019\u0001BK\u0003!Q8n\u00117jK:$\bcA\u001c\u0003\u0018&\u0019!\u0011T\u0019\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003\u00052XM]5gs.\u0013\u0016M\u001a;U_BL7\rU1si&$\u0018n\u001c8NKR\fG-\u0019;b)%!%q\u0014BQ\u0005G\u0013)\u000bC\u0004\u0003B}\u0001\rAa\u0011\t\r\tms\u00041\u0001}\u0011\u001d\u0011yf\ba\u0001\u0005CBqAa\u001d \u0001\u0004\u0011)(A\fwKJLg-_&SC\u001a$Hk\u001c9jG\u000e{gNZ5hgR9AIa+\u0003.\n=\u0006b\u0002B!A\u0001\u0007!1\t\u0005\b\u0005S\u0002\u0003\u0019\u0001B6\u0011\u001d\u0011\u0019\b\ta\u0001\u0005k\nAC^3sS\u001aL(l\u0013+pa&\u001c7i\u001c8gS\u001e\u001cHc\u0002#\u00036\n]&\u0011\u0018\u0005\b\u0005\u0003\n\u0003\u0019\u0001B\"\u0011\u001d\u0011I'\ta\u0001\u0005WBqAa%\"\u0001\u0004\u0011)*\u0001\u0010wKJLg-\u001f.L)>\u0004\u0018n\u0019)beRLG/[8o\u001b\u0016$\u0018\rZ1uCRIAIa0\u0003B\n\r'Q\u0019\u0005\b\u0005\u0003\u0012\u0003\u0019\u0001B\"\u0011\u0019\u0011YF\ta\u0001y\"9!q\f\u0012A\u0002\t\u0005\u0004b\u0002BJE\u0001\u0007!QS\u0001\ni>\u0004\u0018n\u0019#fg\u000e$bAa3\u0003X\nm\u0007#B\u001e\u0003N\nE\u0017b\u0001Bhy\t1q\n\u001d;j_:\u0004BAa\u001e\u0003T&!!Q\u001bB=\u0005A!v\u000e]5d\t\u0016\u001c8M]5qi&|g\u000eC\u0004\u0003Z\u000e\u0002\rAa\u0011\u0002\u000bQ|\u0007/[2\t\u000f\tM4\u00051\u0001\u0003v\u000592/\u001a8e\u00032dwnY1uKB\u0013x\u000eZ;dKJLEm\u001d\u000b\u0005\u0005C\u0014\u0019\u0010\u0005\u0004\u0003d\n%(Q^\u0007\u0003\u0005KT1Aa:L\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0005W\u0014)OA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u00042a\u000fBx\u0013\r\u0011\t\u0010\u0010\u0002\u0005\u0019>tw\rC\u0004\u0003v\u0012\u0002\rAa>\u0002#i\\7\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW\r\u0005\u0003\u0003z\u000e=a\u0002\u0002B~\u0007\u0013qAA!@\u0004\u00069!!q`B\u0002\u001d\u0011\u0011Ie!\u0001\n\u0003QJ!\u0001W\u001a\n\u0007\r\u001dq+A\u0003kk:LG/\u0003\u0003\u0004\f\r5\u0011A\u0007.l\u00072,8\u000f^3s\u0013:4xnY1uS>t7i\u001c8uKb$(bAB\u0004/&!1\u0011CB\n\u0005EQ6n\u00117vgR,'/\u00138ti\u0006t7-\u001a\u0006\u0005\u0007\u0017\u0019i!A\nsK\u0006$\u0007K]8ek\u000e,'/\u00133CY>\u001c7\u000e\u0006\u0003\u0004\u001a\r}\u0001\u0003BA\r\u00077IAa!\b\u0002\u001c\t\u0001\u0002K]8ek\u000e,'/\u00133t\u00052|7m\u001b\u0005\b\u0005'+\u0003\u0019\u0001BK\u0003I\tG\u000e^3s\u0005J|7.\u001a:D_:4\u0017nZ:\u0015\u0007\u0011\u001b)\u0003C\u0004\u0003t\u0019\u0002\rA!\u001e\u0002!\u0005dG/\u001a:U_BL7mQ8oM&<Gc\u0001#\u0004,!9!1O\u0014A\u0002\tU\u0014!E1mi\u0016\u00148\t\\5f]R\fVo\u001c;bgR\u0019Ai!\r\t\u000f\tM\u0004\u00061\u0001\u0003v\u0005Q2M]3bi\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgR!1qGB\u001f!\u0011\u00119h!\u000f\n\t\rm\"\u0011\u0010\u0002 \u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3tk2$\bb\u0002B:S\u0001\u0007!QO\u0001\u001aC2$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7\u000f\u0006\u0003\u00048\r\r\u0003b\u0002B:U\u0001\u0007!QO\u0001\u0013m\u0016\u0014\u0018NZ=U_BL7mQ8oM&<7\u000fF\u0002E\u0007\u0013BqAa%,\u0001\u0004\u0011)*A\nwKJLg-\u001f\"s_.,'oQ8oM&<7\u000fF\u0002E\u0007\u001fBqAa%-\u0001\u0004\u0011)*\u0001\nwKJLg-_\"mS\u0016tG/U;pi\u0006\u001cHc\u0001#\u0004V!9!1S\u0017A\u0002\tU\u0015A\u0007<fe&4\u00170V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001cHc\u0001#\u0004\\!9!1\u0013\u0018A\u0002\tU\u0015AE:ikR$wn\u001e8J]N+\u0017/^3oG\u0016$R\u0001RB1\u0007GBq!a*0\u0001\u0004\t\u0019\u0005C\u0004\u0004f=\u0002\raa\u001a\u0002\u0019-\u0014\u0018M\u001a;DYV\u001cH/\u001a:\u0011\t\r%4qN\u0007\u0003\u0007WR1a!\u001c4\u0003\u001d!Xm\u001d;lSRLAa!\u001d\u0004l\t\u00192*\u00194lC\u000ecWo\u001d;feR+7\u000f^&ji\":Qa!\u001e\u0002\u0012\u000e\u001d\u0005\u0003BB<\u0007\u0007k!a!\u001f\u000b\t\rm4QP\u0001\u0004CBL'\u0002BB@\u0007\u0003\u000bqA[;qSR,'OC\u0002\u0004\b\u0011LAa!\"\u0004z\t9A+[7f_V$hDA\u0001-Q\u001d)11RAI\u0007/\u0003Ba!$\u0004\u00146\u00111q\u0012\u0006\u0005\u0007#\u001bI(A\u0005fqR,gn]5p]&!1QSBH\u0005))\u0005\u0010^3oI^KG\u000f\u001b\u0017\u0003\u00073\u001b#aa'\u0011\t\ru5qT\u0007\u0003\u0007\u001bIAa!)\u0004\u000e\t)2\t\\;ti\u0016\u0014H+Z:u\u000bb$XM\\:j_:\u001c\b")
public class ZkMigrationIntegrationTest {
    private final Logger log = LoggerFactory.getLogger(ZkMigrationIntegrationTest.class);

    public static void zkClustersForAllMigrationVersions(ClusterGenerator clusterGenerator) {
        if (ZkMigrationIntegrationTest$.MODULE$ == null) {
            throw null;
        }
        new .colon.colon((Object)MetadataVersion.IBP_3_6_IV1, (List)new .colon.colon((Object)MetadataVersion.IBP_3_6_IV2, (List)new .colon.colon((Object)MetadataVersion.IBP_3_7_IV0, (List)new .colon.colon((Object)MetadataVersion.IBP_3_7_IV1, (List)new .colon.colon((Object)MetadataVersion.IBP_3_7_IV2, (List)new .colon.colon((Object)MetadataVersion.IBP_3_7_IV4, (List)new .colon.colon((Object)MetadataVersion.IBP_3_8_IV0, (List)Nil$.MODULE$))))))).foreach(arg_0 -> ZkMigrationIntegrationTest$.$anonfun$zkClustersForAllMigrationVersions$1$adapted(clusterGenerator, arg_0));
    }

    public static void addZkBrokerProps(Properties properties) {
        ZkMigrationIntegrationTest$.MODULE$.addZkBrokerProps(properties);
    }

    public Logger log() {
        return this.log;
    }

    @ClusterTest(brokers=3, clusterType=Type.ZK, autoStart=AutoStart.YES, metadataVersion=MetadataVersion.IBP_3_6_IV1, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="kafka.security.authorizer.AclAuthorizer"), @ClusterConfigProperty(key="super.users", value="User:ANONYMOUS")})
    public void testMigrateAcls(ClusterInstance clusterInstance) {
        Admin admin = clusterInstance.createAdminClient();
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        String username = "alice";
        KafkaPrincipal principal = new KafkaPrincipal("User", username);
        KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(wildcardPrincipal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        admin.createAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$))))).asJava()).all().get();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().zkClient();
        ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, (PasswordEncoder)PasswordEncoder$.MODULE$.noop());
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        migrationClient.readAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), x$1 -> {});
        verifier.verify((Function1<MetadataImage, BoxedUnit>)(Function1 & Serializable & scala.Serializable)image -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrateAcls$3(acl1, acl2, acl3, acl4, image);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(brokers=3, clusterType=Type.ZK, autoStart=AutoStart.YES, metadataVersion=MetadataVersion.IBP_3_6_IV1, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="kafka.security.authorizer.AclAuthorizer"), @ClusterConfigProperty(key="super.users", value="User:ANONYMOUS"), @ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testStartZkBrokerWithAuthorizer(ClusterInstance zkCluster) {
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV1).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(kraftCluster.controllers().values()).asScala()).head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = 30000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testStartZkBrokerWithAuthorizer$1(zkClient)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testStartZkBrokerWithAuthorizer$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.inDualWrite$1(kraftCluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testStartZkBrokerWithAuthorizer$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    @ClusterTest(brokers=3, clusterType=Type.ZK, metadataVersion=MetadataVersion.IBP_3_6_IV1)
    public void testMigrate(ClusterInstance clusterInstance) {
        NoOpPasswordEncoder noOpPasswordEncoder;
        Admin admin = clusterInstance.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test-topic-1", 2, (short)3).configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        newTopics.add(new NewTopic("test-topic-2", 1, (short)3));
        newTopics.add(new NewTopic("test-topic-3", 10, (short)3));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        ClientQuotaEntity defaultUserEntity = new ClientQuotaEntity(Collections.singletonMap("user", null));
        quotas.add(new ClientQuotaAlteration(defaultUserEntity, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(900.0)), (List)Nil$.MODULE$)).asJava()));
        ClientQuotaEntity defaultClientIdEntity = new ClientQuotaEntity(Collections.singletonMap("client-id", null));
        quotas.add(new ClientQuotaAlteration(defaultClientIdEntity, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(900.0)), (List)Nil$.MODULE$)).asJava()));
        ClientQuotaEntity defaultIpEntity = new ClientQuotaEntity(Collections.singletonMap("ip", null));
        quotas.add(new ClientQuotaAlteration(defaultIpEntity, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(9.0)), (List)Nil$.MODULE$)).asJava()));
        ClientQuotaEntity userEntity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user/1@prod")}))).asJava());
        quotas.add(new ClientQuotaAlteration(userEntity, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        ClientQuotaEntity userClientEntity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user/1@prod"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client/1@domain")}))).asJava());
        quotas.add(new ClientQuotaAlteration(userClientEntity, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        ClientQuotaEntity ipEntity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava());
        quotas.add(new ClientQuotaAlteration(ipEntity, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        admin.alterClientQuotas(quotas).all().get(60L, TimeUnit.SECONDS);
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().zkClient();
        KafkaConfig kafkaConfig = ((KafkaServer)((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().servers().head()).config();
        Option option = kafkaConfig.passwordEncoderSecret();
        if (option instanceof Some) {
            Password secret = (Password)((Some)option).value();
            noOpPasswordEncoder = PasswordEncoder$.MODULE$.encrypting(secret, kafkaConfig.passwordEncoderKeyFactoryAlgorithm(), kafkaConfig.passwordEncoderCipherAlgorithm(), Predef$.MODULE$.Integer2int(kafkaConfig.passwordEncoderKeyLength()), Predef$.MODULE$.Integer2int(kafkaConfig.passwordEncoderIterations()));
        } else if (None$.MODULE$.equals(option)) {
            noOpPasswordEncoder = PasswordEncoder$.MODULE$.noop();
        } else {
            throw new MatchError((Object)option);
        }
        NoOpPasswordEncoder zkConfigEncoder = noOpPasswordEncoder;
        ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, (PasswordEncoder)zkConfigEncoder);
        ZkMigrationLeadershipState migrationState = migrationClient.getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState.EMPTY);
        migrationState = migrationState.withNewKRaftController(3000, 42);
        migrationState = migrationClient.claimControllerLeadership(migrationState);
        HashSet brokers = new HashSet();
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        migrationClient.readAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(brokers).asScala()).toSeq());
        verifier.verify((Function1<MetadataImage, BoxedUnit>)(Function1 & Serializable & scala.Serializable)image -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrate$3(defaultUserEntity, defaultClientIdEntity, defaultIpEntity, userEntity, userClientEntity, ipEntity, image);
            return BoxedUnit.UNIT;
        });
        migrationClient.releaseControllerLeadership(migrationState);
        migrationState = null;
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTemplate(value="zkClustersForAllMigrationVersions")
    public void testMigrateTopicDeletions(ClusterInstance zkCluster) {
        ObjectRef admin = ObjectRef.create((Object)zkCluster.createAdminClient());
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test-topic-1", 10, (short)3));
        newTopics.add(new NewTopic("test-topic-2", 10, (short)3));
        newTopics.add(new NewTopic("test-topic-3", 10, (short)3));
        ((Admin)admin.elem).createTopics(newTopics).all().get(300L, TimeUnit.SECONDS);
        ((Admin)admin.elem).close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(zkCluster.config().metadataVersion()).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(kraftCluster.controllers().values()).asScala()).head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkClient.createDeleteTopicPath("test-topic-1");
            zkClient.createDeleteTopicPath("test-topic-2");
            zkClient.createDeleteTopicPath("test-topic-3");
            zkCluster.waitForReadyBrokers();
            readyFuture.get(60L, TimeUnit.SECONDS);
            Assumptions.assumeTrue((boolean)zkClient.getTopicDeletions().nonEmpty(), (String)"This test needs pending topic deletions after a migration in order to verify the behavior");
            this.log().info("Waiting for ZK migration to complete");
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = 30000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testMigrateTopicDeletions$1(zkClient)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testMigrateTopicDeletions$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            admin.elem = zkCluster.createAdminClient();
            this.log().info("Waiting for topics to be deleted");
            long l3 = 1000L;
            long l4 = 30000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.topicsAllDeleted$1((Admin)admin.elem)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testMigrateTopicDeletions$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ArrayList<NewTopic> newTopics2 = new ArrayList<NewTopic>();
            newTopics2.add(new NewTopic("test-topic-1", 2, (short)3));
            newTopics2.add(new NewTopic("test-topic-2", 1, (short)3));
            newTopics2.add(new NewTopic("test-topic-3", 10, (short)3));
            ((Admin)admin.elem).createTopics(newTopics2).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Waiting for topics to be re-created");
            long l5 = 1000L;
            long l6 = 30000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.topicsAllRecreated$1((Admin)admin.elem)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testMigrateTopicDeletions$6());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            long l7 = 300000L;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ retry_this = testUtils$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    ZkMigrationIntegrationTest.$anonfun$testMigrateTopicDeletions$7(admin);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
            ((Admin)admin.elem).close();
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_6_IV1, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWriteScram(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        this.createUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV1).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(kraftCluster.controllers().values()).asScala()).head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = 30000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWriteScram$1(zkClient)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testDualWriteScram$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyUserScramCredentials(zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_8_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDeleteLogOnStartup(ClusterInstance zkCluster) {
        ObjectRef admin = ObjectRef.create((Object)zkCluster.createAdminClient());
        try {
            ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
            newTopics.add(new NewTopic("testDeleteLogOnStartup", 2, (short)3).configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
            ((Admin)admin.elem).createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        }
        finally {
            ((Admin)admin.elem).close();
        }
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_8_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(kraftCluster.controllers().values()).asScala()).head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = 30000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDeleteLogOnStartup$1(zkClient)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testDeleteLogOnStartup$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.hasKRaftController$1(zkCluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testDeleteLogOnStartup$5());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Restart brokers again");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            admin.elem = zkCluster.createAdminClient();
            try {
                long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l6 = 30000L;
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime3 = System.currentTimeMillis();
                while (!ZkMigrationIntegrationTest.$anonfun$testDeleteLogOnStartup$6(admin)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testDeleteLogOnStartup$7());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
            finally {
                ((Admin)admin.elem).close();
            }
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTemplate(value="zkClustersForAllMigrationVersions")
    public void testDualWrite(ClusterInstance zkCluster) {
        String topicName = "test";
        Admin admin = zkCluster.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic(topicName, 2, (short)3).configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        Properties propsBefore = zkClient.getEntityConfigs(ConfigType$.MODULE$.Topic(), topicName);
        Assertions.assertEquals((Object)"102400", (Object)propsBefore.getProperty("segment.bytes"));
        Assertions.assertEquals((Object)"300000", (Object)propsBefore.getProperty("segment.ms"));
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(zkCluster.config().metadataVersion()).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(kraftCluster.controllers().values()).asScala()).head()).controller().waitForReadyBrokers(3);
            LongRef nextProducerId = LongRef.create((long)-1L);
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            long l = 60000L;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ retry_this = testUtils$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    ZkMigrationIntegrationTest.$anonfun$testDualWrite$1(this, nextProducerId, zkCluster);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
            Assertions.assertEquals((long)0L, (long)nextProducerId.elem);
            this.log().info("Restart brokers in migration mode");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l3 = 30000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWrite$3(zkClient)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testDualWrite$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterTopicConfig(admin);
            this.alterClientQuotas(admin);
            this.alterBrokerConfigs(admin);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyTopicConfigs(zkClient);
            this.verifyClientQuotas(zkClient);
            this.verifyBrokerConfigs(zkClient);
            LongRef nextKRaftProducerId = LongRef.create((long)-1L);
            TestUtils$ testUtils$2 = TestUtils$.MODULE$;
            long l4 = 60000L;
            if (testUtils$2 == null) {
                throw null;
            }
            TestUtils$ retry_this2 = testUtils$2;
            LongRef retry_wait2 = LongRef.create((long)1L);
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    ZkMigrationIntegrationTest.$anonfun$testDualWrite$5(this, nextKRaftProducerId, zkCluster);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                    }
                    Thread.sleep(retry_wait2.elem);
                    retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                    continue;
                }
                break;
            }
            Assertions.assertNotEquals((long)nextProducerId.elem, (long)nextKRaftProducerId.elem);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_6_IV1, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWriteQuotaAndScram(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        this.createUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV1).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(kraftCluster.controllers().values()).asScala()).head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = 30000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWriteQuotaAndScram$1(zkClient)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testDualWriteQuotaAndScram$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
            this.alterClientQuotas(admin);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyUserScramCredentials(zkClient);
            this.verifyClientQuotas(zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_6_IV1, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testNewAndChangedTopicsInDualWrite(ClusterInstance zkCluster) {
        String topic1 = "test1";
        String topic2 = "test2";
        ObjectRef admin = ObjectRef.create((Object)zkCluster.createAdminClient());
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV1).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            void var13_21;
            Tuple2 tuple2;
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(kraftCluster.controllers().values()).asScala()).head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = 30000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$1(zkClient)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            admin.elem = zkCluster.createAdminClient();
            this.log().info(new StringBuilder(52).append("Create new topic ").append(topic1).append(" with AdminClient with some configs").toString());
            java.util.Map<String, String> topicConfigs = Collections.singletonMap("cleanup.policy", "compact");
            this.createTopic(topic1, 2, (short)3, topicConfigs, (Admin)admin.elem);
            this.verifyTopic(topic1, 2, (short)3, topicConfigs, (Admin)admin.elem, zkClient);
            this.log().info(new StringBuilder(50).append("Create new topic ").append(topic2).append(" with AdminClient without configs").toString());
            java.util.Map<String, String> emptyTopicConfigs = Collections.emptyMap();
            this.createTopic(topic2, 2, (short)3, emptyTopicConfigs, (Admin)admin.elem);
            this.verifyTopic(topic2, 2, (short)3, emptyTopicConfigs, (Admin)admin.elem, zkClient);
            int newPartitionCount = 3;
            this.log().info(new StringBuilder(42).append("Create new partitions with AdminClient to ").append(topic1).toString());
            ((Admin)admin.elem).createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)newPartitionCount))}))).asJava()).all().get(60L, TimeUnit.SECONDS);
            long l3 = TestUtils$.MODULE$.computeUntilTrue$default$3();
            long l4 = TestUtils$.MODULE$.computeUntilTrue$default$2();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long computeUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                void computeUntilTrue_pause;
                void computeUntilTrue_waitTime;
                Option computeUntilTrue_result;
                Option option;
                if (ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$4(newPartitionCount, option = (computeUntilTrue_result = this.topicDesc(topic1, (Admin)admin.elem)))) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    break;
                }
                if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    break;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Option topicDescOpt = (Option)tuple22._1();
            Assertions.assertTrue((boolean)var13_21.isDefined());
            Buffer partitions = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicDescription)var13_21.get()).partitions()).asScala();
            Assertions.assertEquals((int)newPartitionCount, (int)partitions.size());
            this.verifyZKTopicPartitionMetadata(topic1, newPartitionCount, (short)3, zkClient);
            this.verifyKRaftTopicPartitionMetadata(topic1, newPartitionCount, (short)3, (Admin)admin.elem);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=4, metadataVersion=MetadataVersion.IBP_3_7_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testPartitionReassignmentInHybridMode(ClusterInstance zkCluster) {
        String topicName = "test";
        ObjectRef admin = ObjectRef.create((Object)zkCluster.createAdminClient());
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_7_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(kraftCluster.controllers().values()).asScala()).head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = 30000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testPartitionReassignmentInHybridMode$1(zkClient)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testPartitionReassignmentInHybridMode$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Create new topic with AdminClient");
            admin.elem = zkCluster.createAdminClient();
            ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
            java.util.Map<Integer, Object> replicaAssignment = Collections.singletonMap(0, CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))).map((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava());
            newTopics.add(new NewTopic(topicName, replicaAssignment));
            ((Admin)admin.elem).createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
            TopicPartition topicPartition = new TopicPartition(topicName, 0);
            this.verifyZKTopicPartitionMetadata(topicName, 1, (short)3, zkClient);
            ((Admin)admin.elem).alterPartitionReassignments(Collections.singletonMap(topicPartition, Optional.of(new NewPartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava())))).all().get();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testPartitionReassignmentInHybridMode$5(admin)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testPartitionReassignmentInHybridMode$6());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testPartitionReassignmentInHybridMode$7(zkCluster, topicPartition)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$testPartitionReassignmentInHybridMode$8());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_6_IV1, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testIncrementalAlterConfigsPreMigration(ClusterInstance zkCluster) {
        zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
        zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9999");
        zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
        ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).rollingBrokerRestart();
        zkCluster.waitForReadyBrokers();
        Admin admin = zkCluster.createAdminClient();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        try {
            this.alterBrokerConfigs(admin);
            this.verifyBrokerConfigs(zkClient);
        }
        finally {
            admin.close();
            zkClient.close();
            zkCluster.stop();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createTopic(String topicName, int numPartitions, short replicationFactor, java.util.Map<String, String> configs, Admin admin) {
        NewTopic newTopic = new NewTopic(topicName, numPartitions, replicationFactor).configs(configs);
        admin.createTopics(Collections.singletonList(newTopic)).all().get(60L, TimeUnit.SECONDS);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZkMigrationIntegrationTest.$anonfun$createTopic$1(admin, topicName)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$createTopic$2(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public void verifyTopic(String topicName, int numPartitions, short replicationFactor, java.util.Map<String, String> configs, Admin admin, KafkaZkClient zkClient) {
        this.verifyZKTopicPartitionMetadata(topicName, numPartitions, replicationFactor, zkClient);
        this.verifyZKTopicConfigs(topicName, configs, zkClient);
        this.verifyKRaftTopicPartitionMetadata(topicName, numPartitions, replicationFactor, admin);
        this.verifyKRaftTopicConfigs(topicName, configs, admin);
    }

    public void verifyKRaftTopicPartitionMetadata(String topicName, int numPartitions, short replicationFactor, Admin admin) {
        TopicDescription description = (TopicDescription)this.topicDesc(topicName, admin).get();
        Assertions.assertEquals((int)numPartitions, (int)description.partitions().size());
        description.partitions().forEach(p -> Assertions.assertEquals((int)replicationFactor, (int)p.isr().size()));
    }

    public void verifyKRaftTopicConfigs(String topicName, java.util.Map<String, String> configs, Admin admin) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, topicName);
        Collection entries = ((Config)((KafkaFuture)admin.describeConfigs(Collections.singletonList(configResource)).values().get(configResource)).get()).entries();
        List dynamicConfigs = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(entries).asScala()).filter((Function1 & Serializable & scala.Serializable)configEntry -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyKRaftTopicConfigs$1(configEntry)))).toList();
        Assertions.assertEquals((int)configs.size(), (int)dynamicConfigs.size());
        dynamicConfigs.foreach((Function1 & Serializable & scala.Serializable)c -> {
            ZkMigrationIntegrationTest.$anonfun$verifyKRaftTopicConfigs$2(configs, c);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void verifyZKTopicConfigs(String topicName, java.util.Map<String, String> configs, KafkaZkClient zkClient) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!zkClient.pathExists(ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Topic(), topicName))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$verifyZKTopicConfigs$2(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Properties props = zkClient.getEntityConfigs(ConfigType$.MODULE$.Topic(), topicName);
        Assertions.assertEquals((int)configs.size(), (int)props.size());
        configs.forEach((x0$1, x1$1) -> {
            String k = x0$1;
            Assertions.assertEquals((Object)x1$1, (Object)props.get(k));
        });
    }

    /*
     * WARNING - void declaration
     */
    public void verifyZKTopicPartitionMetadata(String topicName, int numPartitions, short replicationFactor, KafkaZkClient zkClient) {
        void var7_11;
        Tuple2 tuple2;
        IndexedSeq partitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)pId -> ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$1(topicName, BoxesRunTime.unboxToInt((Object)pId)), IndexedSeq$.MODULE$.canBuildFrom());
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Option computeUntilTrue_result;
            if ((computeUntilTrue_result = ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$2(zkClient, topicName)).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$4(partitions$1, x$2)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Option topicIdReplicaAssignment = (Option)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)"Unable to find topic metadata in Zk");
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$5(zkClient, partitions, replicationFactor, (Option)var7_11)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public Option<TopicDescription> topicDesc(String topic, Admin admin) {
        try {
            return ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)admin.describeTopics(Collections.singleton(topic)).allTopicNames().get()).asScala()).get((Object)topic);
        }
        catch (Throwable throwable) {
            return None$.MODULE$;
        }
    }

    public CompletableFuture<Object> sendAllocateProducerIds(ZkClusterInvocationContext.ZkClusterInstance zkClusterInstance) {
        NodeToControllerChannelManager channel = ((KafkaBroker)zkClusterInstance.getUnderlying().brokers().head()).clientToControllerChannelManager();
        int brokerId = ((KafkaBroker)zkClusterInstance.getUnderlying().brokers().head()).config().brokerId();
        long brokerEpoch = ((KafkaBroker)zkClusterInstance.getUnderlying().brokers().head()).replicaManager().brokerEpochSupplier().apply$mcJ$sp();
        AllocateProducerIdsRequest.Builder request = new AllocateProducerIdsRequest.Builder(new AllocateProducerIdsRequestData().setBrokerId(brokerId).setBrokerEpoch(brokerEpoch));
        CompletableFuture<Object> producerIdStart = new CompletableFuture<Object>();
        channel.sendRequest((AbstractRequest.Builder)request, new ControllerRequestCompletionHandler(null, producerIdStart){
            private final CompletableFuture producerIdStart$1;

            public void onTimeout() {
                this.producerIdStart$1.completeExceptionally((Throwable)new TimeoutException("Request timed out"));
            }

            public void onComplete(ClientResponse response) {
                AllocateProducerIdsResponse body = (AllocateProducerIdsResponse)response.responseBody();
                this.producerIdStart$1.complete(BoxesRunTime.boxToLong((long)body.data().producerIdStart()));
            }
            {
                this.producerIdStart$1 = producerIdStart$1;
            }
        });
        return producerIdStart;
    }

    /*
     * WARNING - void declaration
     */
    public ProducerIdsBlock readProducerIdBlock(KafkaZkClient zkClient) {
        void var3_3;
        Tuple2 tuple2 = zkClient.getDataAndVersion(ProducerIdBlockZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        return (ProducerIdsBlock)var3_3.map((Function1 & Serializable & scala.Serializable)jsonData -> ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData(jsonData)).get();
    }

    /*
     * WARNING - void declaration
     */
    public void alterBrokerConfigs(Admin admin) {
        ConfigResource defaultBrokerResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        Collection defaultBrokerConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "86400000"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        ConfigResource broker1Resource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        Collection specificBrokerConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "43200000"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$alterBrokerConfigs$1(admin, defaultBrokerResource, defaultBrokerConfigs, broker0Resource, specificBrokerConfigs, broker1Resource);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void alterTopicConfig(Admin admin) {
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "test");
        Collection alterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.bytes", "204800"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.ms", null), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))).asJavaCollection();
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$alterTopicConfig$1(admin, topicResource, alterConfigs);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void alterClientQuotas(Admin admin) {
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user@1")}))).asJava()), (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user@1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("user", null)), (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(900.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava()), (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$alterClientQuotas$1(admin, quotas);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public AlterUserScramCredentialsResult createUserScramCredentials(Admin admin) {
        ArrayList<UserScramCredentialUpsertion> alterations = new ArrayList<UserScramCredentialUpsertion>();
        alterations.add(new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8190), "password0"));
        return admin.alterUserScramCredentials(alterations);
    }

    public AlterUserScramCredentialsResult alterUserScramCredentials(Admin admin) {
        ArrayList<UserScramCredentialUpsertion> alterations = new ArrayList<UserScramCredentialUpsertion>();
        alterations.add(new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8191), "password1"));
        alterations.add(new UserScramCredentialUpsertion("user@2", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8192), "password2"));
        return admin.alterUserScramCredentials(alterations);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyTopicConfigs(KafkaZkClient zkClient) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyTopicConfigs$1(zkClient);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void verifyBrokerConfigs(KafkaZkClient zkClient) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyBrokerConfigs$1(zkClient);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void verifyClientQuotas(KafkaZkClient zkClient) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyClientQuotas$1(zkClient);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void verifyUserScramCredentials(KafkaZkClient zkClient) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyUserScramCredentials$1(zkClient);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public void shutdownInSequence(ClusterInstance zkCluster, KafkaClusterTestKit kraftCluster) {
        zkCluster.brokerIds().forEach(x$5 -> zkCluster.shutdownBroker(Predef$.MODULE$.Integer2int(x$5)));
        kraftCluster.close();
        zkCluster.stop();
    }

    public static final /* synthetic */ void $anonfun$testMigrateAcls$3(AclBinding acl1$1, AclBinding acl2$1, AclBinding acl3$1, AclBinding acl4$1, MetadataImage image) {
        java.util.Map aclMap = image.acls().acls();
        Assertions.assertEquals((int)4, (int)aclMap.size());
        Assertions.assertTrue((boolean)aclMap.values().containsAll((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl1$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl2$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl3$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl4$1), (List)Nil$.MODULE$))))).asJava()));
    }

    public static final /* synthetic */ boolean $anonfun$testStartZkBrokerWithAuthorizer$1(KafkaZkClient zkClient$1) {
        return zkClient$1.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testStartZkBrokerWithAuthorizer$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    private static final boolean inDualWrite$1(KafkaClusterTestKit kraftCluster$1) {
        return ((MigrationDriverState)((ControllerMigrationSupport)kraftCluster$1.controllers().get(BoxesRunTime.boxToInteger((int)3000)).migrationSupport().get()).migrationDriver().migrationState().get(10L, TimeUnit.SECONDS)).allowDualWrite();
    }

    public static final /* synthetic */ String $anonfun$testStartZkBrokerWithAuthorizer$4() {
        return "Timed out waiting for dual-write mode";
    }

    public static final /* synthetic */ void $anonfun$testMigrate$3(ClientQuotaEntity defaultUserEntity$1, ClientQuotaEntity defaultClientIdEntity$1, ClientQuotaEntity defaultIpEntity$1, ClientQuotaEntity userEntity$1, ClientQuotaEntity userClientEntity$1, ClientQuotaEntity ipEntity$1, MetadataImage image) {
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-1"));
        Assertions.assertEquals((int)2, (int)image.topics().getTopic("test-topic-1").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-2"));
        Assertions.assertEquals((int)1, (int)image.topics().getTopic("test-topic-2").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-3"));
        Assertions.assertEquals((int)10, (int)image.topics().getTopic("test-topic-3").partitions().size());
        java.util.Map clientQuotas = image.clientQuotas().entities();
        Assertions.assertEquals(new HashSet<Object>(Arrays.asList((Object[])new ClientQuotaEntity[]{defaultUserEntity$1, defaultClientIdEntity$1, defaultIpEntity$1, userEntity$1, userClientEntity$1, ipEntity$1})), clientQuotas.keySet());
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateTopicDeletions$1(KafkaZkClient zkClient$2) {
        return zkClient$2.getOrCreateMigrationState(ZkMigrationLeadershipState.EMPTY).initialZkMigrationComplete();
    }

    public static final /* synthetic */ String $anonfun$testMigrateTopicDeletions$2() {
        return "Timed out waiting for migration to complete";
    }

    private static final boolean topicsAllDeleted$1(Admin admin) {
        Set topics = (Set)admin.listTopics().names().get(60L, TimeUnit.SECONDS);
        topics.retainAll(Arrays.asList((Object[])new String[]{"test-topic-1", "test-topic-2", "test-topic-3"}));
        return topics.isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testMigrateTopicDeletions$4() {
        return "Timed out waiting for topics to be deleted";
    }

    private static final boolean topicsAllRecreated$1(Admin admin) {
        Set topics = (Set)admin.listTopics().names().get(60L, TimeUnit.SECONDS);
        topics.retainAll(Arrays.asList((Object[])new String[]{"test-topic-1", "test-topic-2", "test-topic-3"}));
        return topics.size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testMigrateTopicDeletions$6() {
        return "Timed out waiting for topics to be created";
    }

    public static final /* synthetic */ void $anonfun$testMigrateTopicDeletions$9(Tuple2 x0$2) {
        if (x0$2 != null) {
            String topic = (String)x0$2._1();
            ((TopicDescription)x0$2._2()).partitions().forEach(partition -> {
                Assertions.assertEquals((int)3, (int)partition.replicas().size(), (String)new StringBuilder(35).append("Unexpected number of replicas for ").append(topic).append("-").append(partition.partition()).toString());
                Assertions.assertEquals((int)3, (int)partition.isr().size(), (String)new StringBuilder(20).append("Unexpected ISR for ").append(topic).append("-").append(partition.partition()).toString());
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testMigrateTopicDeletions$7(ObjectRef admin$1) {
        scala.collection.immutable.Map map;
        try {
            map = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((Admin)admin$1.elem).describeTopics(Arrays.asList((Object[])new String[]{"test-topic-1", "test-topic-2", "test-topic-3"})).topicNameValues()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String name = (String)x0$1._1();
                    KafkaFuture description = (KafkaFuture)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), description.get(60L, TimeUnit.SECONDS));
                }
                throw new MatchError(null);
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                map = Predef$.MODULE$.Map().empty();
            }
            if (throwable != null) {
                map = (scala.collection.immutable.Map)Assertions.fail((String)"Error describing topics", (Throwable)throwable.getCause());
            }
            throw null;
        }
        scala.collection.immutable.Map topicDescriptions = map;
        Assertions.assertEquals((int)2, (int)((TopicDescription)topicDescriptions.apply((Object)"test-topic-1")).partitions().size());
        Assertions.assertEquals((int)1, (int)((TopicDescription)topicDescriptions.apply((Object)"test-topic-2")).partitions().size());
        Assertions.assertEquals((int)10, (int)((TopicDescription)topicDescriptions.apply((Object)"test-topic-3")).partitions().size());
        topicDescriptions.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrateTopicDeletions$9(x0$2);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Set absentTopics = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.asScalaSetConverter((Set)((Admin)admin$1.elem).listTopics().names().get(60L, TimeUnit.SECONDS)).asScala();
        Assertions.assertTrue((boolean)absentTopics.contains((Object)"test-topic-1"));
        Assertions.assertTrue((boolean)absentTopics.contains((Object)"test-topic-2"));
        Assertions.assertTrue((boolean)absentTopics.contains((Object)"test-topic-3"));
    }

    public static final /* synthetic */ boolean $anonfun$testDualWriteScram$1(KafkaZkClient zkClient$3) {
        return zkClient$3.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWriteScram$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLogOnStartup$1(KafkaZkClient zkClient$4) {
        return zkClient$4.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDeleteLogOnStartup$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLogOnStartup$3(KafkaBroker broker) {
        Option option = broker.metadataCache().getControllerId();
        return option instanceof Some && ((Some)option).value() instanceof KRaftCachedControllerId;
    }

    private static final boolean hasKRaftController$1(ClusterInstance zkCluster$1) {
        return ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster$1).getUnderlying().brokers().forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$testDeleteLogOnStartup$3(broker)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteLogOnStartup$5() {
        return "Timed out waiting for ZK brokers to see a KRaft controller";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLogOnStartup$6(ObjectRef admin$2) {
        return ((scala.collection.SetLike)CollectionConverters$.MODULE$.asScalaSetConverter((Set)((Admin)admin$2.elem).listTopics().names().get(30L, TimeUnit.SECONDS)).asScala()).contains((Object)"testDeleteLogOnStartup");
    }

    public static final /* synthetic */ String $anonfun$testDeleteLogOnStartup$7() {
        return "Timed out listing topics";
    }

    public static final /* synthetic */ void $anonfun$testDualWrite$1(ZkMigrationIntegrationTest $this, LongRef nextProducerId$1, ClusterInstance zkCluster$2) {
        Assertions.assertDoesNotThrow(() -> {
            nextProducerId$1.elem = BoxesRunTime.unboxToLong((Object)$this.sendAllocateProducerIds((ZkClusterInvocationContext.ZkClusterInstance)zkCluster$2).get(20L, TimeUnit.SECONDS));
        });
    }

    public static final /* synthetic */ boolean $anonfun$testDualWrite$3(KafkaZkClient zkClient$5) {
        return zkClient$5.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWrite$4() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ void $anonfun$testDualWrite$5(ZkMigrationIntegrationTest $this, LongRef nextKRaftProducerId$1, ClusterInstance zkCluster$2) {
        Assertions.assertDoesNotThrow(() -> {
            nextKRaftProducerId$1.elem = BoxesRunTime.unboxToLong((Object)$this.sendAllocateProducerIds((ZkClusterInvocationContext.ZkClusterInstance)zkCluster$2).get(20L, TimeUnit.SECONDS));
        });
    }

    public static final /* synthetic */ boolean $anonfun$testDualWriteQuotaAndScram$1(KafkaZkClient zkClient$6) {
        return zkClient$6.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWriteQuotaAndScram$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testNewAndChangedTopicsInDualWrite$1(KafkaZkClient zkClient$7) {
        return zkClient$7.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testNewAndChangedTopicsInDualWrite$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testNewAndChangedTopicsInDualWrite$4(int newPartitionCount$1, Option td) {
        return td.isDefined() && ((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicDescription)td.get()).partitions()).asScala()).size() == newPartitionCount$1;
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentInHybridMode$1(KafkaZkClient zkClient$8) {
        return zkClient$8.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentInHybridMode$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentInHybridMode$5(ObjectRef admin$4) {
        return ((java.util.Map)((Admin)admin$4.elem).listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentInHybridMode$6() {
        return "Timed out waiting for reassignments to complete.";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentInHybridMode$7(ClusterInstance zkCluster$3, TopicPartition topicPartition$1) {
        Buffer<KafkaBroker> brokers = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster$3).getUnderlying().brokers();
        Assertions.assertTrue((brokers.size() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((((KafkaBroker)brokers.head()).config().brokerId() == 0 ? 1 : 0) != 0);
        return ((KafkaBroker)brokers.head()).replicaManager().onlinePartition(topicPartition$1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentInHybridMode$8() {
        return "Timed out waiting for removed replica reassignment to be marked offline";
    }

    public static final /* synthetic */ boolean $anonfun$createTopic$1(Admin admin$5, String topicName$1) {
        return ((Set)admin$5.listTopics().names().get()).contains(topicName$1);
    }

    public static final /* synthetic */ String $anonfun$createTopic$2(String topicName$1) {
        return new StringBuilder(21).append("Unable to find topic ").append(topicName$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyKRaftTopicConfigs$1(ConfigEntry configEntry) {
        ConfigEntry.ConfigSource configSource = configEntry.source();
        ConfigEntry.ConfigSource configSource2 = ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG;
        return !(configSource != null ? !configSource.equals(configSource2) : configSource2 != null);
    }

    public static final /* synthetic */ void $anonfun$verifyKRaftTopicConfigs$2(java.util.Map configs$1, ConfigEntry c) {
        Assertions.assertEquals(configs$1.get(c.name()), (Object)c.value());
    }

    public static final /* synthetic */ String $anonfun$verifyZKTopicConfigs$2(String topicName$2) {
        return new StringBuilder(28).append("Unable to find ").append(ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Topic(), topicName$2)).append(" in ZooKeeper").toString();
    }

    public static final /* synthetic */ TopicPartition $anonfun$verifyZKTopicPartitionMetadata$1(String topicName$3, int pId) {
        return new TopicPartition(topicName$3, pId);
    }

    public static final /* synthetic */ Option $anonfun$verifyZKTopicPartitionMetadata$2(KafkaZkClient zkClient$10, String topicName$3) {
        return zkClient$10.getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName$3}))).headOption();
    }

    public static final /* synthetic */ boolean $anonfun$verifyZKTopicPartitionMetadata$4(IndexedSeq partitions$1, TopicZNode.TopicIdReplicaAssignment x$2) {
        return x$2.assignment().size() == partitions$1.size();
    }

    public static final /* synthetic */ boolean $anonfun$verifyZKTopicPartitionMetadata$7(TopicPartition tp$1, LeaderIsrAndControllerEpoch lisr$1, TopicZNode.TopicIdReplicaAssignment x$4) {
        Seq seq = ((ReplicaAssignment)x$4.assignment().apply((Object)tp$1)).replicas();
        List list = lisr$1.leaderAndIsr().isr();
        return !(seq != null ? !seq.equals(list) : list != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyZKTopicPartitionMetadata$6(short replicationFactor$2, Option topicIdReplicaAssignment$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            LeaderIsrAndControllerEpoch lisr = (LeaderIsrAndControllerEpoch)x0$1._2();
            return lisr.leaderAndIsr().isr().size() == replicationFactor$2 && lisr.leaderAndIsr().leader() >= 0 && topicIdReplicaAssignment$1.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$7(tp, lisr, x$4)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyZKTopicPartitionMetadata$5(KafkaZkClient zkClient$10, IndexedSeq partitions$1, short replicationFactor$2, Option topicIdReplicaAssignment$1) {
        Map lisrMap = zkClient$10.getTopicPartitionStates((Seq)partitions$1);
        return lisrMap.size() == partitions$1.size() && lisrMap.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$6(replicationFactor$2, topicIdReplicaAssignment$1, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$verifyZKTopicPartitionMetadata$8() {
        return "Unable to find topic partition metadata";
    }

    public static final /* synthetic */ void $anonfun$alterBrokerConfigs$1(Admin admin$6, ConfigResource defaultBrokerResource$1, Collection defaultBrokerConfigs$1, ConfigResource broker0Resource$1, Collection specificBrokerConfigs$1, ConfigResource broker1Resource$1) {
        try {
            admin$6.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBrokerResource$1), (Object)defaultBrokerConfigs$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource$1), (Object)specificBrokerConfigs$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker1Resource$1), (Object)specificBrokerConfigs$1)}))).asJava()).all().get(10L, TimeUnit.SECONDS);
            return;
        }
        catch (Throwable t) {
            Assertions.fail((String)"Alter Broker Configs had an error", (Throwable)t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$alterTopicConfig$1(Admin admin$7, ConfigResource topicResource$1, Collection alterConfigs$1) {
        try {
            admin$7.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource$1), (Object)alterConfigs$1)}))).asJava()).all().get(10L, TimeUnit.SECONDS);
            return;
        }
        catch (Throwable t) {
            Assertions.fail((String)"Alter Topic Configs had an error", (Throwable)t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$alterClientQuotas$1(Admin admin$8, ArrayList quotas$1) {
        try {
            admin$8.alterClientQuotas((Collection)quotas$1).all().get(10L, TimeUnit.SECONDS);
            return;
        }
        catch (Throwable t) {
            Assertions.fail((String)"Alter Client Quotas had an error", (Throwable)t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$verifyTopicConfigs$1(KafkaZkClient zkClient$11) {
        Properties propsAfter = zkClient$11.getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((Object)"204800", (Object)propsAfter.getProperty("segment.bytes"));
        Assertions.assertFalse((boolean)propsAfter.containsKey("segment.ms"));
    }

    public static final /* synthetic */ void $anonfun$verifyBrokerConfigs$1(KafkaZkClient zkClient$12) {
        Properties defaultBrokerProps = zkClient$12.getEntityConfigs(ConfigType$.MODULE$.Broker(), "<default>");
        Assertions.assertEquals((Object)"86400000", (Object)defaultBrokerProps.getProperty(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp()));
        Properties broker0Props = zkClient$12.getEntityConfigs(ConfigType$.MODULE$.Broker(), "0");
        Assertions.assertEquals((Object)"43200000", (Object)broker0Props.getProperty(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp()));
        Properties broker1Props = zkClient$12.getEntityConfigs(ConfigType$.MODULE$.Broker(), "1");
        Assertions.assertEquals((Object)"43200000", (Object)broker1Props.getProperty(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp()));
    }

    public static final /* synthetic */ void $anonfun$verifyClientQuotas$1(KafkaZkClient zkClient$13) {
        Assertions.assertEquals((Object)"1000", (Object)zkClient$13.getEntityConfigs(ConfigType$.MODULE$.User(), Sanitizer.sanitize((String)"user@1")).getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"900", (Object)zkClient$13.getEntityConfigs(ConfigType$.MODULE$.User(), "<default>").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"800", (Object)zkClient$13.getEntityConfigs(new StringBuilder(14).append("users/").append(Sanitizer.sanitize((String)"user@1")).append("/clients").toString(), "clientA").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"100", (Object)zkClient$13.getEntityConfigs(new StringBuilder(14).append("users/").append(Sanitizer.sanitize((String)"user@1")).append("/clients").toString(), "clientA").getProperty("producer_byte_rate"));
        Assertions.assertEquals((Object)"10", (Object)zkClient$13.getEntityConfigs(ConfigType$.MODULE$.Ip(), "8.8.8.8").getProperty("connection_creation_rate"));
    }

    public static final /* synthetic */ void $anonfun$verifyUserScramCredentials$1(KafkaZkClient zkClient$14) {
        ScramCredential scramCredentials1 = ScramCredentialUtils.credentialFromString((String)zkClient$14.getEntityConfigs(ConfigType$.MODULE$.User(), Sanitizer.sanitize((String)"user1")).getProperty("SCRAM-SHA-256"));
        Assertions.assertEquals((int)8191, (int)scramCredentials1.iterations());
        String propertyValue2 = zkClient$14.getEntityConfigs(ConfigType$.MODULE$.User(), Sanitizer.sanitize((String)"user@2")).getProperty("SCRAM-SHA-256");
        Assertions.assertNotNull((Object)propertyValue2);
        ScramCredential scramCredentials2 = ScramCredentialUtils.credentialFromString((String)propertyValue2);
        Assertions.assertEquals((int)8192, (int)scramCredentials2.iterations());
    }

    public static final /* synthetic */ Object $anonfun$testNewAndChangedTopicsInDualWrite$4$adapted(int newPartitionCount$1, Option td) {
        return BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$4(newPartitionCount$1, td));
    }

    public static final /* synthetic */ Object $anonfun$verifyZKTopicPartitionMetadata$3$adapted(IndexedSeq partitions$1, Option x) {
        return BoxesRunTime.boxToBoolean((boolean)x.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$4(partitions$1, x$2))));
    }

    public class MetadataDeltaVerifier {
        private final MetadataDelta metadataDelta;
        private int offset;

        public MetadataDelta metadataDelta() {
            return this.metadataDelta;
        }

        public int offset() {
            return this.offset;
        }

        public void offset_$eq(int x$1) {
            this.offset = x$1;
        }

        public void accept(java.util.List<ApiMessageAndVersion> batch) {
            batch.forEach(message -> {
                this.metadataDelta().replay(message.message());
                this.offset_$eq(this.offset() + 1);
            });
        }

        public void verify(Function1<MetadataImage, BoxedUnit> verifier) {
            MetadataImage image = this.metadataDelta().apply(new MetadataProvenance((long)this.offset(), 0, 0L));
            verifier.apply((Object)image);
        }

        public /* synthetic */ ZkMigrationIntegrationTest kafka$zk$ZkMigrationIntegrationTest$MetadataDeltaVerifier$$$outer() {
            return ZkMigrationIntegrationTest.this;
        }

        public MetadataDeltaVerifier() {
            if (ZkMigrationIntegrationTest.this == null) {
                throw null;
            }
            this.metadataDelta = new MetadataDelta(MetadataImage.EMPTY);
            this.offset = 0;
        }
    }
}

