/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.RackAwareMode;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.log.LogCleaner;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015h\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001A\u0002\u0013\u0005!\bC\u0004G\u0001\u0001\u0007I\u0011A$\t\r9\u0003\u0001\u0015)\u0003<\u0011%Q\u0003\u00011AA\u0002\u0013\u0005q\nC\u0005]\u0001\u0001\u0007\t\u0019!C\u0001;\"Iq\f\u0001a\u0001\u0002\u0003\u0006K\u0001\u0015\u0005\bA\u0002\u0011\r\u0011\"\u0001b\u0011\u0019Q\u0007\u0001)A\u0005E\"91\u000e\u0001b\u0001\n\u0003a\u0007BB=\u0001A\u0003%Q\u000eC\u0004{\u0001\t\u0007I\u0011A>\t\u000f\u0005\u001d\u0001\u0001)A\u0005y\"9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003O\u0002A\u0011AA5\u0011\u001d\t\u0019\b\u0001C\u0001\u0003\u0017Aq!! \u0001\t\u0003\ty\bC\u0004\u0002\n\u0002!I!a#\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0018\"9\u0011Q\u0017\u0001\u0005\n\u0005]\u0006bBAc\u0001\u0011%\u00111\u0002\u0005\b\u0003\u000f\u0004A\u0011BAe\u0011\u001d\t\t\u000f\u0001C\u0001\u0003GDq!!<\u0001\t\u0003\ty\u000fC\u0004\u0002z\u0002!\t!a?\t\u000f\t\u0015\u0001\u0001\"\u0001\u0003\b!9!\u0011\u0003\u0001\u0005\u0002\tM\u0001b\u0002B\u000f\u0001\u0011\u0005!q\u0004\u0005\b\u0005S\u0001A\u0011AA\u0006\u0011\u001d\u0011i\u0003\u0001C\u0005\u0005_A\u0011Ba\u0016\u0001#\u0003%IA!\u0017\t\u0013\t=\u0004!%A\u0005\n\tE\u0004\"\u0003B;\u0001E\u0005I\u0011\u0002B<\u0011\u001d\u0011i\u0003\u0001C\u0005\u0005wBqAa%\u0001\t\u0013\u0011)\nC\u0004\u00032\u0002!\tAa-\t\u000f\tu\u0006\u0001\"\u0001\u0002\f!9!\u0011\u0019\u0001\u0005\n\t\r'a\u0004#fY\u0016$X\rV8qS\u000e$Vm\u001d;\u000b\u0005)Z\u0013!B1e[&t'\"\u0001\u0017\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\f\t\u0003aMj\u0011!\r\u0006\u0003e-\naa]3sm\u0016\u0014\u0018B\u0001\u001b2\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0002\"\u0001\u000f\u0001\u000e\u0003%\nqA\u0019:pW\u0016\u00148/F\u0001<!\ra\u0014iQ\u0007\u0002{)\u0011ahP\u0001\u000bG>dG.Z2uS>t'\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tk$aA*fcB\u0011\u0001\u0007R\u0005\u0003\u000bF\u00121bS1gW\u0006\u0014%o\\6fe\u0006Y!M]8lKJ\u001cx\fJ3r)\tAE\n\u0005\u0002J\u00156\tq(\u0003\u0002L\u007f\t!QK\\5u\u0011\u001di5!!AA\u0002m\n1\u0001\u001f\u00132\u0003!\u0011'o\\6feN\u0004S#\u0001)\u0011\u0005ESV\"\u0001*\u000b\u0005)\u001a&B\u0001+V\u0003\u001d\u0019G.[3oiNT!\u0001\f,\u000b\u0005]C\u0016AB1qC\u000eDWMC\u0001Z\u0003\ry'oZ\u0005\u00037J\u0013Q!\u00113nS:\f\u0011\"\u00193nS:|F%Z9\u0015\u0005!s\u0006bB'\u0007\u0003\u0003\u0005\r\u0001U\u0001\u0007C\u0012l\u0017N\u001c\u0011\u0002\u000bQ|\u0007/[2\u0016\u0003\t\u0004\"a\u00195\u000e\u0003\u0011T!!\u001a4\u0002\t1\fgn\u001a\u0006\u0002O\u0006!!.\u0019<b\u0013\tIGM\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u00023\u0015D\b/Z2uK\u0012\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e^\u000b\u0002[B!AH\u001c9t\u0013\tyWHA\u0002NCB\u0004\"!S9\n\u0005I|$aA%oiB\u0019Ao\u001e9\u000e\u0003UT!A^\u001f\u0002\u0013%lW.\u001e;bE2,\u0017B\u0001=v\u0005\u0011a\u0015n\u001d;\u00025\u0015D\b/Z2uK\u0012\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0011\u0002;\u0015D\b/Z2uK\u0012\u0014V\r\u001d7jG\u00064U\u000f\u001c7BgNLwM\\7f]R,\u0012\u0001 \t\u0005y9\u0004X\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003Y\u0013AC2p]R\u0014x\u000e\u001c7fe&\u0019\u0011QA@\u0003#I+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG/\u0001\u0010fqB,7\r^3e%\u0016\u0004H.[2b\rVdG.Q:tS\u001etW.\u001a8uA\u0005AA/Z1s\t><h\u000eF\u0001IQ\rq\u0011q\u0002\t\u0005\u0003#\ty\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\r\t\u0007/\u001b\u0006\u0005\u00033\tY\"A\u0004kkBLG/\u001a:\u000b\u0007\u0005u\u0001,A\u0003kk:LG/\u0003\u0003\u0002\"\u0005M!!C!gi\u0016\u0014X)Y2i\u0003\r\"Xm\u001d;EK2,G/\u001a+pa&\u001cw+\u001b;i\u00032d\u0017\t\\5wKJ+\u0007\u000f\\5dCN$2\u0001SA\u0014\u0011\u001d\tIc\u0004a\u0001\u0003W\ta!];peVl\u0007\u0003BA\u0017\u0003wqA!a\f\u00028A\u0019\u0011\u0011G \u000e\u0005\u0005M\"bAA\u001b[\u00051AH]8pizJ1!!\u000f@\u0003\u0019\u0001&/\u001a3fM&\u0019\u0011.!\u0010\u000b\u0007\u0005er\bK\u0004\u0010\u0003\u0003\n\t&a\u0015\u0011\t\u0005\r\u0013QJ\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005A\u0001O]8wS\u0012,'O\u0003\u0003\u0002L\u0005]\u0011A\u00029be\u0006l7/\u0003\u0003\u0002P\u0005\u0015#a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0003\u0002V\u0005e\u0013EAA,\u0003\tQ8.\t\u0002\u0002\\\u0005)1N]1gi\"\u001aq\"a\u0018\u0011\t\u0005\u0005\u00141M\u0007\u0003\u0003\u0013JA!!\u001a\u0002J\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002UQ,7\u000f\u001e*fgVlW\rR3mKR,Gk\u001c9jG^KG\u000f\u001b*fG>4XM]3e\r>dGn\\<feR\u0019\u0001*a\u001b\t\u000f\u0005%\u0002\u00031\u0001\u0002,!:\u0001#!\u0011\u0002R\u0005=D\u0006BA+\u00033B3\u0001EA0\u0003%\"Xm\u001d;SKN,X.\u001a#fY\u0016$X\rV8qS\u000e|enQ8oiJ|G\u000e\\3s\r\u0006LGn\u001c<fe\"\u001a\u0011#a\u001e\u0011\t\u0005E\u0011\u0011P\u0005\u0005\u0003w\n\u0019B\u0001\u0003UKN$\u0018A\u000b;fgR\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]R$UO]5oO\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u000b\u0004\u0011\u0006\u0005\u0005bBA\u0015%\u0001\u0007\u00111\u0006\u0015\b%\u0005\u0005\u0013\u0011KACY\u0011\t)&!\u0017)\u0007I\ty&\u0001\nxC&$XK\u001c;jYR{\u0007/[2H_:,G#\u0002%\u0002\u000e\u0006E\u0005BBAH'\u0001\u0007\u0001+A\u0006bI6Lgn\u00117jK:$\bbBAJ'\u0001\u0007\u00111F\u0001\ni>\u0004\u0018n\u0019(b[\u0016\f\u0011E^3sS\u001aL(+Z1tg&<g.\\3oi\u001a\u000b\u0017\u000e\\:G_Jl\u0015n]:j]\u001e$r\u0001SAM\u00037\u000bY\u000b\u0003\u0004\u0002\u0010R\u0001\r\u0001\u0015\u0005\b\u0003;#\u0002\u0019AAP\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0002\"\u0006\u001dVBAAR\u0015\r\t)+V\u0001\u0007G>lWn\u001c8\n\t\u0005%\u00161\u0015\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\ti\u000b\u0006a\u0001\u0003_\u000bAB]3bgNLwM\\7f]R\u00042!UAY\u0013\r\t\u0019L\u0015\u0002\u0019\u001d\u0016<\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$\u0018!D4fi\u000e{g\u000e\u001e:pY2,'\u000f\u0006\u0002\u0002:B1\u0011*a/\u0002@BL1!!0@\u0005\u0019!V\u000f\u001d7feA\u0019\u0001'!1\n\u0007\u0005\r\u0017GA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018AF3ogV\u0014XmQ8oiJ|G\u000e\\3s\u000bbL7\u000f^:\u00029\u001d,G/\u00117m%\u0016\u0004H.[2bg\u001a\u0013x.\\!tg&<g.\\3oiR1\u00111ZAl\u00033\u0004b!!\f\u0002N\u0006E\u0017\u0002BAh\u0003{\u00111aU3u!\rq\u00181[\u0005\u0004\u0003+|(a\u0005)beRLG/[8o\u0003:$'+\u001a9mS\u000e\f\u0007B\u00021\u0018\u0001\u0004\tY\u0003C\u0004\u0002\\^\u0001\r!!8\u0002\u0015\u0005\u001c8/[4o[\u0016tG\u000fE\u0003=]B\fy\u000eE\u0002=\u0003B\f1\u0006^3ti&s7M]3bg\u0016\u0004\u0016M\u001d;ji&|gnQ8v]R$UO]5oO\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u000b\u0004\u0011\u0006\u0015\bbBA\u00151\u0001\u0007\u00111\u0006\u0015\b1\u0005\u0005\u0013\u0011KAuY\u0011\t)&!\u0017)\u0007a\ty&A\u0011uKN$H)\u001a7fi\u0016$v\u000e]5d\tV\u0014\u0018N\\4BI\u0012\u0004\u0016M\u001d;ji&|g\u000eF\u0002I\u0003cDq!!\u000b\u001a\u0001\u0004\tY\u0003K\u0004\u001a\u0003\u0003\n\t&!>-\t\u0005U\u0013\u0011\f\u0015\u00043\u0005}\u0013!\t;fgR\fE\r\u001a)beRLG/[8o\tV\u0014\u0018N\\4EK2,G/\u001a+pa&\u001cGc\u0001%\u0002~\"9\u0011\u0011\u0006\u000eA\u0002\u0005-\u0002f\u0002\u000e\u0002B\u0005E#\u0011\u0001\u0017\u0005\u0003+\nI\u0006K\u0002\u001b\u0003?\na\u0004^3tiJ+7M]3bi\u0016$v\u000e]5d\u0003\u001a$XM\u001d#fY\u0016$\u0018n\u001c8\u0015\u0007!\u0013I\u0001C\u0004\u0002*m\u0001\r!a\u000b)\u000fm\t\t%!\u0015\u0003\u000e1\"\u0011QKA-Q\rY\u0012qL\u0001\u001bi\u0016\u001cH\u000fR3mKR,gj\u001c8Fq&\u001cH/\u001b8h)>\u0004\u0018n\u0019\u000b\u0004\u0011\nU\u0001bBA\u00159\u0001\u0007\u00111\u0006\u0015\b9\u0005\u0005\u0013\u0011\u000bB\rY\u0011\t)&!\u0017)\u0007q\ty&\u0001\u000euKN$H)\u001a7fi\u0016$v\u000e]5d/&$\bn\u00117fC:,'\u000fF\u0002I\u0005CAq!!\u000b\u001e\u0001\u0004\tY\u0003K\u0004\u001e\u0003\u0003\n\tF!\n-\t\u0005U\u0013\u0011\f\u0015\u0004;\u0005}\u0013!\n;fgR$U\r\\3uKR{\u0007/[2BYJ,\u0017\rZ=NCJ\\W\rZ!t\t\u0016dW\r^3eQ\rq\u0012qO\u0001\u001aGJ,\u0017\r^3UKN$Hk\u001c9jG\u0006sGm\u00117vgR,'\u000fF\u0005<\u0005c\u0011\u0019Da\u000e\u0003B!1\u0001m\ba\u0001\u0003WA\u0001B!\u000e !\u0003\u0005\r\u0001]\u0001\r]VlwJZ\"p]\u001aLwm\u001d\u0005\n\u0005sy\u0002\u0013!a\u0001\u0005w\t!\u0003Z3mKR,Gk\u001c9jG\u0016s\u0017M\u00197fIB\u0019\u0011J!\u0010\n\u0007\t}rHA\u0004C_>dW-\u00198\t\u0013\t\rs\u0004%AA\u0002\t\u0015\u0013!\u0005:fa2L7-Y!tg&<g.\\3oiB)AH\u001c9\u0003HA)!\u0011\nB*a:!!1\nB(\u001d\u0011\t\tD!\u0014\n\u0003\u0001K1A!\u0015@\u0003\u001d\u0001\u0018mY6bO\u0016L1\u0001\u001fB+\u0015\r\u0011\tfP\u0001$GJ,\u0017\r^3UKN$Hk\u001c9jG\u0006sGm\u00117vgR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011YFK\u0002q\u0005;Z#Aa\u0018\u0011\t\t\u0005$1N\u0007\u0003\u0005GRAA!\u001a\u0003h\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005Sz\u0014AC1o]>$\u0018\r^5p]&!!Q\u000eB2\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001$GJ,\u0017\r^3UKN$Hk\u001c9jG\u0006sGm\u00117vgR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\u0019H\u000b\u0003\u0003<\tu\u0013aI2sK\u0006$X\rV3tiR{\u0007/[2B]\u0012\u001cE.^:uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005sRCA!\u0012\u0003^Q91H! \u0003\u0000\tE\u0005B\u00021$\u0001\u0004\tY\u0003C\u0004\u0003\u0002\u000e\u0002\rAa!\u0002\u001b\t\u0014xn[3s\u0007>tg-[4t!\u0011a\u0014I!\"\u0011\t\t\u001d%QR\u0007\u0003\u0005\u0013S1Aa#g\u0003\u0011)H/\u001b7\n\t\t=%\u0011\u0012\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002B\"G\u0001\u0007!QI\u0001\noJLG/\u001a#vaN$\u0002Ba&\u0003\u001c\n}%1\u0015\t\u0005y\u0005\u0013I\nE\u0003J\u0003w\u0003\b\u000f\u0003\u0004\u0003\u001e\u0012\u0002\r\u0001]\u0001\b]Vl7*Z=t\u0011\u0019\u0011\t\u000b\na\u0001a\u00069a.^7EkB\u001c\bb\u0002BSI\u0001\u0007!qU\u0001\u0004Y><\u0007\u0003\u0002BU\u0005[k!Aa+\u000b\u0007\t\u00156&\u0003\u0003\u00030\n-&AC+oS\u001aLW\r\u001a'pO\u00061B/Z:u\t&\u001c\u0018M\u00197f\t\u0016dW\r^3U_BL7\rF\u0002I\u0005kCq!!\u000b&\u0001\u0004\tY\u0003K\u0004&\u0003\u0003\n\tF!/-\t\u0005U\u0013\u0011\f\u0015\u0004K\u0005}\u0013!\t;fgR$U\r\\3uS:<\u0007+\u0019:uS\u0006dG.\u001f#fY\u0016$X\r\u001a+pa&\u001c\u0007f\u0001\u0014\u0002x\u0005\u0011\u0012N\\2sK\u0006\u001cX\rU1si&$\u0018n\u001c8t+\u0011\u0011)M!7\u0015\u0013!\u00139M!3\u0003L\n=\u0007\"\u0002\u0016(\u0001\u0004\u0001\u0006B\u00021(\u0001\u0004\tY\u0003\u0003\u0004\u0003N\u001e\u0002\r\u0001]\u0001\u0014i>$\u0018\r\u001c)beRLG/[8o\u0007>,h\u000e\u001e\u0005\b\u0005#<\u0003\u0019\u0001Bj\u0003E\u0011'o\\6feN$vNV1mS\u0012\fG/\u001a\t\u0005y\u0005\u0013)\u000e\u0005\u0003\u0003X\neG\u0002\u0001\u0003\b\u00057<#\u0019\u0001Bo\u0005\u0005\u0011\u0015c\u0001Bp\u0007B\u0019\u0011J!9\n\u0007\t\rxHA\u0004O_RD\u0017N\\4")
public class DeleteTopicTest
extends QuorumTestHarness {
    private Seq<KafkaBroker> brokers = Nil$.MODULE$;
    private Admin admin;
    private final String topic;
    private final Map<Object, List<Object>> expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
    private final Map<Object, ReplicaAssignment> expectedReplicaFullAssignment = (Map)this.expectedReplicaAssignment().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
        if (x0$1 != null) {
            int k = x0$1._1$mcI$sp();
            List v = (List)x0$1._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)v, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$));
        }
        throw new MatchError(null);
    }, Map$.MODULE$.canBuildFrom());

    public Seq<KafkaBroker> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaBroker> x$1) {
        this.brokers = x$1;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public Map<Object, List<Object>> expectedReplicaAssignment() {
        return this.expectedReplicaAssignment;
    }

    public Map<Object, ReplicaAssignment> expectedReplicaFullAssignment() {
        return this.expectedReplicaFullAssignment;
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.brokers(), TestUtils$.MODULE$.shutdownServers$default$2());
        if (this.admin() != null) {
            this.admin().close();
        }
        super.tearDown();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteTopicWithAllAliveReplicas(String quorum) {
        this.brokers_$eq(this.createTestTopicAndCluster(this.topic(), this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3(), this.createTestTopicAndCluster$default$4()));
        this.admin().deleteTopics(Collections.singletonList(this.topic())).all().get();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), this.topic(), 1, this.brokers());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testResumeDeleteTopicWithRecoveredFollower(String quorum) {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.brokers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3(), this.createTestTopicAndCluster$default$4()));
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(topic, 0), TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
        KafkaBroker follower = (KafkaBroker)((TraversableLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$1(leaderId, s)))).last();
        follower.shutdown();
        this.admin().deleteTopics(Collections.singletonList(topic)).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$2(this, follower, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (!this.isKRaftTest()) {
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$6(this, topic)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$7());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topic, 1, this.brokers());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        String topic = new TopicPartition("test", 0).topic();
        this.brokers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3(), this.createTestTopicAndCluster$default$4()));
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Controller doesn't exist")));
        KafkaBroker controller = (KafkaBroker)((IterableLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$2(controllerId, s)))).head();
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        KafkaBroker follower = (KafkaBroker)((TraversableLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$3(leaderIdOpt, controllerId, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        controller.shutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$4(this, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        controller.startup();
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.brokers());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testPartitionReassignmentDuringDeleteTopic(String quorum) {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        this.brokers_$eq(this.createTestTopicAndCluster(this.topic(), 4, this.createTestTopicAndCluster$default$3(), this.createTestTopicAndCluster$default$4()));
        Seq servers = (Seq)this.brokers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$1(this, s)));
        int leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), topicPartition, TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
        KafkaBroker follower = (KafkaBroker)((TraversableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$2(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.admin().deleteTopics(Collections.singletonList(this.topic())).all().get();
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", TestUtils$.MODULE$.plaintextBootstrapServers(servers));
        try (Admin adminClient = Admin.create((Properties)props);){
            this.waitUntilTopicGone(adminClient, "test");
            this.verifyReassignmentFailsForMissing(adminClient, new TopicPartition(this.topic(), 0), new NewPartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)})));
        }
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), this.topic(), 1, servers);
    }

    /*
     * WARNING - void declaration
     */
    private void waitUntilTopicGone(Admin adminClient, String topicName) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$waitUntilTopicGone$1(adminClient, topicName)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$waitUntilTopicGone$2(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyReassignmentFailsForMissing(Admin adminClient, TopicPartition partition, NewPartitionReassignment reassignment) {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> adminClient.alterPartitionReassignments(Collections.singletonMap(partition, Optional.of(reassignment))).all().get());
        Assertions.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
    }

    private Tuple2<KafkaServer, Object> getController() {
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)"Controller doesn't exist");
        }));
        KafkaServer controller = (KafkaServer)this.brokers().find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$getController$2(controllerId, s))).get();
        return new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
    }

    /*
     * WARNING - void declaration
     */
    private void ensureControllerExists() {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$ensureControllerExists$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$ensureControllerExists$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private scala.collection.immutable.Set<PartitionAndReplica> getAllReplicasFromAssignment(String topic, Map<Object, Seq<Object>> assignment) {
        return ((TraversableOnce)assignment.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partition = x0$1._1$mcI$sp();
                return (Seq)((Seq)x0$1._2()).map((Function1 & Serializable & scala.Serializable)r -> DeleteTopicTest.$anonfun$getAllReplicasFromAssignment$2(topic, partition, BoxesRunTime.unboxToInt((Object)r)), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIncreasePartitionCountDuringDeleteTopic(String quorum) {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        Seq<KafkaBroker> allBrokers = this.createTestTopicAndCluster(this.topic(), 4, this.createTestTopicAndCluster$default$3(), this.createTestTopicAndCluster$default$4());
        this.brokers_$eq(allBrokers);
        Seq partitionHostingBrokers = (Seq)allBrokers.filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$1(this, b)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!partitionHostingBrokers.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$3(topicPartition$2, x$2)))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsKnown(partitionHostingBrokers, topicPartition, TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
        if (this.isKRaftTest()) {
            KafkaBroker follower = (KafkaBroker)((TraversableLike)partitionHostingBrokers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$5(leaderIdOpt, s)))).last();
            follower.shutdown();
            this.admin().deleteTopics(Collections.singletonList(this.topic())).all().get();
            Properties props = new Properties();
            props.setProperty("bootstrap.servers", TestUtils$.MODULE$.plaintextBootstrapServers(partitionHostingBrokers));
            Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Admin.create((Properties)props), (Function1 & Serializable & scala.Serializable)adminClient -> {
                try {
                    return adminClient.createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)NewPartitions.increaseTo((int)2))}))).asJava()).all().get();
                }
                catch (ExecutionException executionException) {
                    return BoxedUnit.UNIT;
                }
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            follower.startup();
        } else {
            void var11_14;
            List partitionHostingServers = ((TraversableOnce)partitionHostingBrokers.map((Function1 & Serializable & scala.Serializable)x$3 -> (KafkaServer)x$3, Seq$.MODULE$.canBuildFrom())).toList();
            KafkaServer follower = (KafkaServer)((LinearSeqOptimized)partitionHostingServers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$9(leaderIdOpt, s)))).last();
            follower.shutdown();
            this.adminZkClient().deleteTopic(this.topic());
            this.ensureControllerExists();
            Tuple2<KafkaServer, Object> tuple2 = this.getController();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            KafkaServer controller = (KafkaServer)tuple2._1();
            int n = tuple2._2$mcI$sp();
            scala.collection.immutable.Set<PartitionAndReplica> allReplicasForTopic = this.getAllReplicasFromAssignment(this.topic(), this.expectedReplicaAssignment());
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$10(this, (KafkaServer)var11_14, allReplicasForTopic)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$11(this));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Properties props = new Properties();
            props.setProperty("bootstrap.servers", TestUtils$.MODULE$.plaintextBootstrapServers(partitionHostingServers));
            Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Admin.create((Properties)props), (Function1 & Serializable & scala.Serializable)adminClient -> {
                try {
                    return adminClient.createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic()), (Object)NewPartitions.increaseTo((int)2))}))).asJava()).all().get();
                }
                catch (ExecutionException executionException) {
                    return BoxedUnit.UNIT;
                }
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            var11_14.shutdown();
            this.ensureControllerExists();
            long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$14(this, n)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$15());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            follower.startup();
            var11_14.startup();
        }
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), this.topic(), 2, partitionHostingBrokers);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteTopicDuringAddPartition(String quorum) {
        this.brokers_$eq(this.createTestTopicAndCluster(this.topic(), this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3(), this.createTestTopicAndCluster$default$4()));
        int leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(this.topic(), 0), TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
        KafkaBroker follower = (KafkaBroker)((TraversableLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$1(leaderIdOpt, x$5)))).last();
        TopicPartition newPartition = new TopicPartition(this.topic(), 1);
        if (this.isKRaftTest()) {
            follower.shutdown();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$2(follower)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$3(follower));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.increasePartitions(this.admin(), this.topic(), 3, (Seq)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$4(follower, x$6))));
        } else {
            AdminZkClient qual$1 = this.adminZkClient();
            RackAwareMode x$1 = qual$1.getBrokerMetadatas$default$1();
            Option x$2 = qual$1.getBrokerMetadatas$default$2();
            Seq brokersMetadata = qual$1.getBrokerMetadatas(x$1, x$2);
            follower.shutdown();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$5(this, follower)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$6(follower));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            AdminZkClient qual$2 = this.adminZkClient();
            String x$3 = this.topic();
            Map<Object, ReplicaAssignment> x$4 = this.expectedReplicaFullAssignment();
            int x$62 = 2;
            Some x$7 = new Some((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$8 = qual$2.addPartitions$default$6();
            qual$2.addPartitions(x$3, x$4, brokersMetadata, x$62, (Option)x$7, x$8);
        }
        this.admin().deleteTopics(Collections.singletonList(this.topic())).all().get();
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), this.topic(), 1, this.brokers());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$7(this, newPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testAddPartitionDuringDeleteTopic(String quorum) {
        this.brokers_$eq(this.createTestTopicAndCluster(this.topic(), this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3(), this.createTestTopicAndCluster$default$4()));
        TopicPartition newPartition = new TopicPartition(this.topic(), 1);
        if (this.isKRaftTest()) {
            this.admin().deleteTopics(Collections.singletonList(this.topic())).all().get();
            this.increasePartitions(this.admin(), this.topic(), 3, (Seq)Nil$.MODULE$);
        } else {
            this.zkClient().createTopLevelPaths();
            AdminZkClient qual$1 = this.adminZkClient();
            RackAwareMode x$1 = qual$1.getBrokerMetadatas$default$1();
            Option x$2 = qual$1.getBrokerMetadatas$default$2();
            Seq brokersMetadata = qual$1.getBrokerMetadatas(x$1, x$2);
            this.admin().deleteTopics(Collections.singletonList(this.topic())).all().get();
            AdminZkClient qual$2 = this.adminZkClient();
            String x$3 = this.topic();
            Map<Object, ReplicaAssignment> x$4 = this.expectedReplicaFullAssignment();
            int x$6 = 2;
            Some x$7 = new Some((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$82 = qual$2.addPartitions$default$6();
            qual$2.addPartitions(x$3, x$4, brokersMetadata, x$6, (Option)x$7, x$82);
        }
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), this.topic(), 1, this.brokers());
        Assertions.assertTrue((boolean)this.brokers().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testAddPartitionDuringDeleteTopic$1(newPartition, x$8))), (String)"Replica logs not deleted after delete topic is complete");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testRecreateTopicAfterDeletion(String quorum) {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        this.brokers_$eq(this.createTestTopicAndCluster(this.topic(), this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3(), this.createTestTopicAndCluster$default$4()));
        this.admin().deleteTopics(Collections.singletonList(this.topic())).all().get();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), this.topic(), 1, this.brokers());
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$5();
        int x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$6();
        Properties x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$8();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)expectedReplicaAssignment, x$8);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$1(this, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteNonExistingTopic(String quorum) {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.brokers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3(), this.createTestTopicAndCluster$default$4()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), "test2", 1, this.brokers());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$3(this, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (!this.isKRaftTest()) {
            Assertions.assertTrue((boolean)this.zkClient().topicExists(topic), (String)"Topic test mistakenly deleted");
        }
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$6());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteTopicWithCleaner(String quorum) {
        String topicName = "test";
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        String topic = topicPartition.topic();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnectOrNull(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18());
        ((Properties)brokerConfigs.head()).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.dedupe.buffer.size", "1048577");
        this.brokers_$eq(this.createTestTopicAndCluster(topic, brokerConfigs, this.expectedReplicaAssignment()));
        KafkaBroker server = (KafkaBroker)this.brokers().head();
        LogManager qual$1 = server.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        UnifiedLog log = (UnifiedLog)qual$1.getLog(topicPartition, x$2).get();
        this.writeDups(100, 3, log);
        LogCleaner qual$2 = server.logManager().cleaner();
        TopicPartition x$3 = new TopicPartition(topicName, 0);
        long x$4 = 0L;
        long x$5 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$3, x$4, x$5);
        this.admin().deleteTopics(Collections.singletonList(topic)).all().get();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), "test", 1, this.brokers());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteTopicAlreadyMarkedAsDeleted() {
        String topic = new TopicPartition("test", 0).topic();
        this.brokers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3(), this.createTestTopicAndCluster$default$4()));
        this.admin().deleteTopics(Collections.singletonList(topic)).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteTopicAlreadyMarkedAsDeleted$1(this, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testDeleteTopicAlreadyMarkedAsDeleted$2(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.brokers());
    }

    private Seq<KafkaBroker> createTestTopicAndCluster(String topic, int numOfConfigs, boolean deleteTopicEnabled, Map<Object, List<Object>> replicaAssignment) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(numOfConfigs, this.zkConnectOrNull(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)x$11 -> x$11.setProperty("delete.topic.enable", Boolean.toString(deleteTopicEnabled)));
        return this.createTestTopicAndCluster(topic, brokerConfigs, replicaAssignment);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<KafkaBroker> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs, Map<Object, List<Object>> replicaAssignment) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq brokers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> this.createBroker(KafkaConfig$.MODULE$.fromProps(b), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4()), Seq$.MODULE$.canBuildFrom());
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(brokers, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), TestUtils$.MODULE$.createAdminClient$default$3()));
        Admin x$1 = this.admin();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$5();
        int x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$6();
        Properties x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$8();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, topic, brokers, x$4, x$6, x$7, replicaAssignment, x$8);
        Seq brokersHostingTopicPartition = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$createTestTopicAndCluster$3(this, s)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokersHostingTopicPartition.forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$createTestTopicAndCluster$5(topicPartition$5, x$12)))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$createTestTopicAndCluster$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return brokers;
    }

    private int createTestTopicAndCluster$default$2() {
        return 3;
    }

    private boolean createTestTopicAndCluster$default$3() {
        return true;
    }

    private Map<Object, List<Object>> createTestTopicAndCluster$default$4() {
        return this.expectedReplicaAssignment();
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, UnifiedLog log) {
        IntRef counter = IntRef.create((int)0);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> DeleteTopicTest.$anonfun$writeDups$1(numKeys, counter, log, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDisableDeleteTopic(String quorum) {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        if (this.isKRaftTest()) {
            Properties overridingProps = new Properties();
            overridingProps.put("delete.topic.enable", Boolean.toString(false));
            if (this.implementation() != null) {
                this.implementation().shutdown();
            }
            this.implementation_$eq(this.newKRaftQuorum(overridingProps));
        }
        String x$1 = this.topic();
        boolean x$2 = false;
        int x$3 = this.createTestTopicAndCluster$default$2();
        Map<Object, List<Object>> x$4 = this.createTestTopicAndCluster$default$4();
        this.brokers_$eq(this.createTestTopicAndCluster(x$1, x$3, x$2, x$4));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDisableDeleteTopic$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testDisableDeleteTopic$2(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (!this.isKRaftTest()) {
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!DeleteTopicTest.$anonfun$testDisableDeleteTopic$3(this)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DeleteTopicTest.$anonfun$testDisableDeleteTopic$4(this));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)this.zkClient().topicExists(this.topic()), (String)"Topic path disappeared");
        }
        Assertions.assertTrue((boolean)this.brokers().forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDisableDeleteTopic$5(topicPartition, x$13))));
        Assertions.assertDoesNotThrow(() -> TestUtils$.MODULE$.describeTopic(this.admin(), this.topic()));
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), topicPartition, TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletingPartiallyDeletedTopic() {
        Map replicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        this.brokers_$eq(this.createTestTopicAndCluster(this.topic(), 4, true, (Map<Object, List<Object>>)replicaAssignment));
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.shutdown();
            return BoxedUnit.UNIT;
        });
        KafkaZkClient qual$1 = this.zkClient();
        String x$1 = TopicPartitionZNode$.MODULE$.path(new TopicPartition(this.topic(), 0));
        int x$2 = qual$1.deleteRecursive$default$2();
        qual$1.deleteRecursive(x$1, x$2);
        this.adminZkClient().deleteTopic(this.topic());
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.startup();
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), this.topic(), 2, this.brokers());
    }

    private <B extends KafkaBroker> void increasePartitions(Admin admin, String topic, int totalPartitionCount, Seq<B> brokersToValidate) {
        Map newPartitionSet = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)NewPartitions.increaseTo((int)totalPartitionCount))}));
        admin.createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(newPartitionSet).asJava());
        if (brokersToValidate.nonEmpty()) {
            Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> allPartitionsMetadata = TestUtils$.MODULE$.waitForAllPartitionsMetadata(brokersToValidate, topic, totalPartitionCount);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalPartitionCount - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> allPartitionsMetadata.get((Object)new TopicPartition(topic, i)).foreach((Function1 & Serializable & scala.Serializable)partitionMetadata -> {
                DeleteTopicTest.$anonfun$increasePartitions$2(totalPartitionCount, partitionMetadata);
                return BoxedUnit.UNIT;
            }));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$1(int leaderId$1, KafkaBroker s) {
        return s.config().brokerId() != leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$3(KafkaBroker follower$1, KafkaBroker s) {
        return s.config().brokerId() != follower$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$4(TopicPartition topicPartition$1, KafkaBroker x$1) {
        LogManager qual$1 = x$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$1, x$2).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$2(DeleteTopicTest $this, KafkaBroker follower$1, TopicPartition topicPartition$1) {
        return ((IterableLike)$this.brokers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$3(follower$1, s)))).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$4(topicPartition$1, x$1)));
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicWithRecoveredFollower$5() {
        return "Replicas 0,1 have not deleted log.";
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$6(DeleteTopicTest $this, String topic$1) {
        return $this.zkClient().isTopicMarkedForDeletion(topic$1);
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicWithRecoveredFollower$7() {
        return "Admin path /admin/delete_topics/test path deleted even when a follower replica is down";
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$2(int controllerId$1, KafkaBroker s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$3(Option leaderIdOpt$1, int controllerId$1, KafkaBroker s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$1.get()) && s.config().brokerId() != controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$4(DeleteTopicTest $this, String topic$2) {
        return $this.zkClient().isTopicMarkedForDeletion(topic$2);
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicOnControllerFailover$5() {
        return "Admin path /admin/delete_topics/test path deleted even when a replica is down";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$1(DeleteTopicTest $this, KafkaBroker s) {
        return ((LinearSeqOptimized)$this.expectedReplicaAssignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$2(int leaderIdOpt$2, KafkaBroker s) {
        return s.config().brokerId() != leaderIdOpt$2;
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilTopicGone$1(Admin adminClient$1, String topicName$1) {
        try {
            adminClient$1.describeTopics(Collections.singletonList(topicName$1)).allTopicNames().get();
            return false;
        }
        catch (ExecutionException e) {
            return UnknownTopicOrPartitionException.class.equals(e.getCause().getClass());
        }
    }

    public static final /* synthetic */ String $anonfun$waitUntilTopicGone$2(String topicName$1) {
        return new StringBuilder(25).append("Topic ").append(topicName$1).append(" should be deleted.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$getController$2(int controllerId$2, KafkaBroker s) {
        return s.config().brokerId() == controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$ensureControllerExists$1(DeleteTopicTest $this) {
        try {
            $this.getController();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$ensureControllerExists$2() {
        return "Controller should eventually exist";
    }

    public static final /* synthetic */ PartitionAndReplica $anonfun$getAllReplicasFromAssignment$2(String topic$3, int partition$2, int r) {
        return new PartitionAndReplica(new TopicPartition(topic$3, partition$2), r);
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$1(DeleteTopicTest $this, KafkaBroker b) {
        return ((LinearSeqOptimized)$this.expectedReplicaAssignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)b.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$3(TopicPartition topicPartition$2, KafkaBroker x$2) {
        LogManager qual$1 = x$2.logManager();
        boolean x$22 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$2, x$22).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$4() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$5(int leaderIdOpt$3, KafkaBroker s) {
        return s.config().brokerId() != leaderIdOpt$3;
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$9(int leaderIdOpt$3, KafkaServer s) {
        return s.config().brokerId() != leaderIdOpt$3;
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$10(DeleteTopicTest $this, KafkaServer controller$1, scala.collection.immutable.Set allReplicasForTopic$1) {
        Set replicasInDeletionSuccessful = controller$1.kafkaController().controllerContext().replicasInState($this.topic(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        Set offlineReplicas = controller$1.kafkaController().controllerContext().replicasInState($this.topic(), (ReplicaState)OfflineReplica$.MODULE$);
        scala.collection.immutable.Set set = allReplicasForTopic$1;
        Set set2 = replicasInDeletionSuccessful.union((GenSet)offlineReplicas);
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$11(DeleteTopicTest $this) {
        return new StringBuilder(95).append("Not all replicas for topic ").append($this.topic()).append(" are in states of either ReplicaDeletionSuccessful or OfflineReplica").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$14(DeleteTopicTest $this, int previousControllerId$1) {
        void var3_3;
        Tuple2<KafkaServer, Object> tuple2 = $this.getController();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int newControllerId = tuple2._2$mcI$sp();
        return var3_3 != previousControllerId$1;
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$15() {
        return "The new controller should not have the failed controller id";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$1(int leaderIdOpt$4, KafkaBroker x$5) {
        return x$5.config().brokerId() != leaderIdOpt$4;
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$2(KafkaBroker follower$2) {
        BrokerState brokerState = follower$2.brokerState();
        BrokerState brokerState2 = BrokerState.SHUTTING_DOWN;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicDuringAddPartition$3(KafkaBroker follower$2) {
        return new StringBuilder(27).append("Follower ").append(follower$2.config().brokerId()).append(" was not shut down").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$4(KafkaBroker follower$2, KafkaBroker x$6) {
        return x$6.config().brokerId() != follower$2.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$5(DeleteTopicTest $this, KafkaBroker follower$2) {
        return $this.zkClient().getBroker(follower$2.config().brokerId()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicDuringAddPartition$6(KafkaBroker follower$2) {
        return new StringBuilder(33).append("Follower ").append(follower$2.config().brokerId()).append(" was not removed from ZK").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$8(TopicPartition newPartition$1, KafkaBroker x$7) {
        LogManager qual$3 = x$7.logManager();
        boolean x$10 = qual$3.getLog$default$2();
        return qual$3.getLog(newPartition$1, x$10).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$7(DeleteTopicTest $this, TopicPartition newPartition$1) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$8(newPartition$1, x$7)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicDuringAddPartition$9() {
        return "Replica logs not for new partition [test,1] not deleted after delete topic is complete.";
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitionDuringDeleteTopic$1(TopicPartition newPartition$2, KafkaBroker x$8) {
        LogManager qual$3 = x$8.logManager();
        boolean x$10 = qual$3.getLog$default$2();
        return qual$3.getLog(newPartition$2, x$10).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRecreateTopicAfterDeletion$2(TopicPartition topicPartition$3, KafkaBroker x$9) {
        LogManager qual$1 = x$9.logManager();
        boolean x$10 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$3, x$10).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testRecreateTopicAfterDeletion$1(DeleteTopicTest $this, TopicPartition topicPartition$3) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$2(topicPartition$3, x$9)));
    }

    public static final /* synthetic */ String $anonfun$testRecreateTopicAfterDeletion$3() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$1(DeleteTopicTest $this) {
        try {
            $this.admin().deleteTopics(Collections.singletonList("test2")).all().get();
            return false;
        }
        catch (ExecutionException e) {
            return UnknownTopicOrPartitionException.class.equals(e.getCause().getClass());
        }
    }

    public static final /* synthetic */ String $anonfun$testDeleteNonExistingTopic$2() {
        return "Topic test2 should not exist.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$4(TopicPartition topicPartition$4, KafkaBroker x$10) {
        LogManager qual$1 = x$10.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$4, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$3(DeleteTopicTest $this, TopicPartition topicPartition$4) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$4(topicPartition$4, x$10)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteNonExistingTopic$5() {
        return "Replicas for topic test not created";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicAlreadyMarkedAsDeleted$1(DeleteTopicTest $this, String topic$4) {
        try {
            $this.admin().deleteTopics(Collections.singletonList(topic$4)).all().get();
            return false;
        }
        catch (ExecutionException e) {
            return UnknownTopicOrPartitionException.class.equals(e.getCause().getClass());
        }
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicAlreadyMarkedAsDeleted$2(String topic$4) {
        return new StringBuilder(56).append("Topic ").append(topic$4).append(" should be marked for deletion or already deleted.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$3(DeleteTopicTest $this, KafkaBroker s) {
        return ((LinearSeqOptimized)$this.expectedReplicaAssignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$5(TopicPartition topicPartition$5, KafkaBroker x$12) {
        LogManager qual$1 = x$12.logManager();
        boolean x$10 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$5, x$10).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTestTopicAndCluster$6() {
        return "Replicas for topic test not created";
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(IntRef counter$1, UnifiedLog log$1, int key) {
        int count = counter$1.elem;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(counter$1.elem).getBytes(), Integer.toString(key).getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5(), log$1.appendAsLeader$default$6());
        ++counter$1.elem;
        return new Tuple2.mcII.sp(key, count);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDups$1(int numKeys$1, IntRef counter$1, UnifiedLog log$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> DeleteTopicTest.$anonfun$writeDups$2(counter$1, log$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$1(DeleteTopicTest $this) {
        try {
            $this.admin().deleteTopics(Collections.singletonList($this.topic())).all().get();
            return false;
        }
        catch (ExecutionException e) {
            return TopicDeletionDisabledException.class.equals(e.getCause().getClass());
        }
    }

    public static final /* synthetic */ String $anonfun$testDisableDeleteTopic$2(DeleteTopicTest $this) {
        return new StringBuilder(65).append("TopicDeletionDisabledException should be returned when deleting ").append($this.topic()).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$3(DeleteTopicTest $this) {
        return !$this.zkClient().isTopicMarkedForDeletion($this.topic());
    }

    public static final /* synthetic */ String $anonfun$testDisableDeleteTopic$4(DeleteTopicTest $this) {
        return new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topics/%s path not deleted even if deleteTopic is disabled")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.topic()}));
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$5(TopicPartition topicPartition$6, KafkaBroker x$13) {
        LogManager qual$1 = x$13.logManager();
        boolean x$6 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$6, x$6).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeletingPartiallyDeletedTopic$4(KafkaBroker x$16) {
        return ((KafkaServer)x$16).kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testDeletingPartiallyDeletedTopic$3(DeleteTopicTest $this) {
        return $this.brokers().exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$4(x$16)));
    }

    public static final /* synthetic */ String $anonfun$testDeletingPartiallyDeletedTopic$5() {
        return "No controller is elected";
    }

    public static final /* synthetic */ void $anonfun$increasePartitions$2(int totalPartitionCount$1, UpdateMetadataRequestData.UpdateMetadataPartitionState partitionMetadata) {
        Assertions.assertEquals((int)totalPartitionCount$1, (int)partitionMetadata.replicas().size());
    }

    public DeleteTopicTest() {
        this.topic = "test";
    }
}

