/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.api.AdminClientWithPoliciesIntegrationTest$;
import kafka.api.PlaintextAdminIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001B\u0011#\u0001\u001dBQ\u0001\u000e\u0001\u0005\u0002UB\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011A\u001d\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0003A\u0005\"C)\u0001\u0001\u0004\u0005\t\u0015)\u0003;\u0011\u001d\u0011\u0006A1A\u0005\u0002MCaa\u0016\u0001!\u0002\u0013!\u0006\"\u0002-\u0001\t\u0003J\u0006\"B5\u0001\t\u0003R\u0007\"B8\u0001\t\u0003\u0001\bbBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001bBq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002\u0004\u0002!\t!!\"\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\u001e9\u0011q\u0015\u0012\t\u0002\u0005%fAB\u0011#\u0011\u0003\tY\u000b\u0003\u00045#\u0011\u0005\u00111\u0017\u0005\n\u0003k\u000b\"\u0019!C\u0001\u0003oC\u0001\"a7\u0012A\u0003%\u0011\u0011\u0018\u0005\b\u0003;\fB\u0011AAp\r\u0019\t90\u0005\u0001\u0002z\"1AG\u0006C\u0001\u0005\u0003A1Ba\u0002\u0017\u0001\u0004\u0005\r\u0011\"\u0001\u0003\n!Y!\u0011\u0006\fA\u0002\u0003\u0007I\u0011\u0001B\u0016\u0011-\u0011IB\u0006a\u0001\u0002\u0003\u0006KAa\u0003\t\u0013\t]b\u00031A\u0005\u0002\te\u0002\"\u0003B!-\u0001\u0007I\u0011\u0001B\"\u0011!\u00119E\u0006Q!\n\tm\u0002b\u0002B%-\u0011\u0005!1\n\u0005\b\u000532B\u0011\u0001B.\u0011\u0019\u0011\tG\u0006C\u0001U\n1\u0013\tZ7j]\u000ec\u0017.\u001a8u/&$\b\u000eU8mS\u000eLWm]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005\r\"\u0013aA1qS*\tQ%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Ac\u0006\u0005\u0002*Y5\t!F\u0003\u0002,I\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\ti#F\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\ty#'D\u00011\u0015\t\tD%A\u0003vi&d7/\u0003\u00024a\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00017!\t9\u0004!D\u0001#\u0003\u0019\u0019G.[3oiV\t!\b\u0005\u0002<\u000b6\tAH\u0003\u0002>}\u0005)\u0011\rZ7j]*\u0011q\bQ\u0001\bG2LWM\u001c;t\u0015\t)\u0013I\u0003\u0002C\u0007\u00061\u0011\r]1dQ\u0016T\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$=\u0005\u0015\tE-\\5o\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0003\u0013>\u0003\"AS'\u000e\u0003-S\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u0013A!\u00168ji\"9\u0001kAA\u0001\u0002\u0004Q\u0014a\u0001=%c\u000591\r\\5f]R\u0004\u0013a\u00032s_.,'oQ8v]R,\u0012\u0001\u0016\t\u0003\u0015VK!AV&\u0003\u0007%sG/\u0001\u0007ce>\\WM]\"pk:$\b%A\u0003tKR,\u0006\u000f\u0006\u0002J5\")1l\u0002a\u00019\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002^G6\taL\u0003\u0002$?*\u0011\u0001-Y\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00117)A\u0003kk:LG/\u0003\u0002e=\nAA+Z:u\u0013:4w\u000e\u000b\u0002\bMB\u0011QlZ\u0005\u0003Qz\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#A%)\u0005!a\u0007CA/n\u0013\tqgLA\u0005BMR,'/R1dQ\u0006a1M]3bi\u0016\u001cuN\u001c4jOV\t\u0011\u000fE\u0003sof\fI!D\u0001t\u0015\t!X/\u0001\u0003vi&d'\"\u0001<\u0002\t)\fg/Y\u0005\u0003qN\u00141!T1q!\rQ\u00181\u0001\b\u0003w~\u0004\"\u0001`&\u000e\u0003uT!A \u0014\u0002\rq\u0012xn\u001c;?\u0013\r\t\taS\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u00051\n\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty!^\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0014\u00055!AB(cU\u0016\u001cG/A\bhK:,'/\u0019;f\u0007>tg-[4t+\t\tI\u0002\u0005\u0004\u0002\u001c\u0005\u0005\u0012QE\u0007\u0003\u0003;Q1!a\bL\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\tiBA\u0002TKF\u0004B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W!\u0013AB:feZ,'/\u0003\u0003\u00020\u0005%\"aC&bM.\f7i\u001c8gS\u001e\fac\u001b:bMR\u001cuN\u001c;s_2dWM]\"p]\u001aLwm\u001d\u000b\u0003\u0003k\u0001b!a\u000e\u0002B\u0005\u0015c\u0002BA\u001d\u0003{q1\u0001`A\u001e\u0013\u0005a\u0015bAA \u0017\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0012\u0003\u0007R1!a\u0010L!\r\u0011\u0018qI\u0005\u0004\u0003\u0013\u001a(A\u0003)s_B,'\u000f^5fg\u0006\u0019rN^3se&$WMT8eK\u000e{gNZ5hgR\u0019\u0011*a\u0014\t\u000f\u0005EC\u00021\u0001\u0002F\u0005)\u0001O]8qg\u0006)B/Z:u-\u0006d\u0017\u000eZ!mi\u0016\u00148i\u001c8gS\u001e\u001cHcA%\u0002X!1\u0011\u0011L\u0007A\u0002e\fa!];peVl\u0007fB\u0007\u0002^\u00055\u0014q\u000e\t\u0005\u0003?\nI'\u0004\u0002\u0002b)!\u00111MA3\u0003!\u0001(o\u001c<jI\u0016\u0014(bAA4?\u00061\u0001/\u0019:b[NLA!a\u001b\u0002b\tYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!!\u001d\u0002v\u0005\u0012\u00111O\u0001\u0003u.\f#!a\u001e\u0002\u000b-\u0014\u0018M\u001a;)\u00075\tY\b\u0005\u0003\u0002~\u0005}TBAA3\u0013\u0011\t\t)!\u001a\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/A\fuKN$\u0018J\u001c<bY&$\u0017\t\u001c;fe\u000e{gNZ5hgR\u0019\u0011*a\"\t\r\u0005ec\u00021\u0001zQ\u001dq\u0011QLA7\u0003\u0017cC!!\u001d\u0002v!\u001aa\"a\u001f\u0002EQ,7\u000f^%om\u0006d\u0017\u000eZ!mi\u0016\u00148i\u001c8gS\u001e\u001cH)^3U_B{G.[2z)\rI\u00151\u0013\u0005\u0007\u00033z\u0001\u0019A=)\u000f=\ti&!\u001c\u0002\u00182\"\u0011\u0011OA;Q\ry\u00111\u0010\u0015\b\u0001\u0005u\u00151UAS!\ri\u0016qT\u0005\u0004\u0003Cs&a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0002q\u00061\u0013\tZ7j]\u000ec\u0017.\u001a8u/&$\b\u000eU8mS\u000eLWm]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u0005]\n2cA\t\u0002.B\u0019!*a,\n\u0007\u0005E6J\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003S\u000b1B^1mS\u0012\fG/[8ogV\u0011\u0011\u0011\u0018\t\u0007\u0003w\u000b\t-!2\u000e\u0005\u0005u&\u0002BA`\u0003;\tq!\\;uC\ndW-\u0003\u0003\u0002D\u0006u&A\u0003'jgR\u0014UO\u001a4feB!\u0011qYAk\u001d\u0011\tI-!5\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\fa\u0001]8mS\u000eL(bAA\u0016\u0001&!\u00111[Af\u0003E\tE\u000e^3s\u0007>tg-[4Q_2L7-_\u0005\u0005\u0003/\fINA\bSKF,Xm\u001d;NKR\fG-\u0019;b\u0015\u0011\t\u0019.a3\u0002\u0019Y\fG.\u001b3bi&|gn\u001d\u0011\u0002-Y\fG.\u001b3bi&|gn\u001d$peJ+7o\\;sG\u0016$B!!9\u0002dB1\u0011qGA!\u0003\u000bDq!!:\u0016\u0001\u0004\t9/\u0001\u0005sKN|WO]2f!\u0011\tI/a=\u000e\u0005\u0005-(\u0002BAw\u0003_\faaY8oM&<'bAAy\u0001\u000611m\\7n_:LA!!>\u0002l\nq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,'A\u0002)pY&\u001c\u0017pE\u0003\u0017\u0003\u0013\tY\u0010\u0005\u0003\u0002J\u0006u\u0018\u0002BA\u0000\u0003\u0017\u0014\u0011#\u00117uKJ\u001cuN\u001c4jOB{G.[2z)\t\u0011\u0019\u0001E\u0002\u0003\u0006Yi\u0011!E\u0001\bG>tg-[4t+\t\u0011Y\u0001\r\u0003\u0003\u000e\tU\u0001C\u0002>\u0003\u0010e\u0014\t\"C\u0002y\u0003\u000f\u0001BAa\u0005\u0003\u00161\u0001Aa\u0003B\f5\u0005\u0005\t\u0011!B\u0001\u00057\u00111a\u0018\u00132\u0003!\u0019wN\u001c4jON\u0004\u0013\u0003\u0002B\u000f\u0005G\u00012A\u0013B\u0010\u0013\r\u0011\tc\u0013\u0002\b\u001d>$\b.\u001b8h!\rQ%QE\u0005\u0004\u0005OY%aA!os\u0006Y1m\u001c8gS\u001e\u001cx\fJ3r)\rI%Q\u0006\u0005\t!f\t\t\u00111\u0001\u00030A\"!\u0011\u0007B\u001b!\u0019Q(qB=\u00034A!!1\u0003B\u001b\t1\u00119B!\f\u0002\u0002\u0003\u0005)\u0011\u0001B\u000e\u0003\u0019\u0019Gn\\:fIV\u0011!1\b\t\u0004\u0015\nu\u0012b\u0001B \u0017\n9!i\\8mK\u0006t\u0017AC2m_N,Gm\u0018\u0013fcR\u0019\u0011J!\u0012\t\u0011Ac\u0012\u0011!a\u0001\u0005w\tqa\u00197pg\u0016$\u0007%A\u0005d_:4\u0017nZ;sKR\u0019\u0011J!\u0014\t\u000f\t\u001da\u00041\u0001\u0003PA\"!\u0011\u000bB+!\u0015\u0011x/\u001fB*!\u0011\u0011\u0019B!\u0016\u0005\u0019\t]#QJA\u0001\u0002\u0003\u0015\tAa\u0007\u0003\u0007}##'\u0001\u0005wC2LG-\u0019;f)\rI%Q\f\u0005\b\u0005?z\u0002\u0019AAc\u0003=\u0011X-];fgRlU\r^1eCR\f\u0017!B2m_N,\u0007")
public class AdminClientWithPoliciesIntegrationTest
extends KafkaServerTestHarness {
    private Admin client;
    private final int brokerCount;

    public static Seq<AlterConfigPolicy.RequestMetadata> validationsForResource(ConfigResource configResource) {
        return AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(configResource);
    }

    public static ListBuffer<AlterConfigPolicy.RequestMetadata> validations() {
        return AdminClientWithPoliciesIntegrationTest$.MODULE$.validations();
    }

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.brokers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public java.util.Map<String, Object> createConfig() {
        return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServers(this.bootstrapServers$default$1()))}))).asJava();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnectOrNull(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18());
        configs.foreach((Function1 & Serializable & scala.Serializable)props -> {
            this.overrideNodeConfigs(props);
            return BoxedUnit.UNIT;
        });
        return (Seq)configs.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<Properties> kraftControllerConfigs() {
        Properties props = new Properties();
        this.overrideNodeConfigs(props);
        return new .colon.colon((Object)props, (List)Nil$.MODULE$);
    }

    private void overrideNodeConfigs(Properties props) {
        props.put("alter.config.policy.class.name", Policy.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testValidAlterConfigs(String quorum) {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty("max.message.bytes", "500000");
        topicConfig1.setProperty("retention.ms", "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1, this.createTopic$default$5(), this.createTopic$default$6());
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), this, topicResource1, topicResource2);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidAlterConfigs(String quorum) {
        this.client_$eq(Admin.create(this.createConfig()));
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this, this.client());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidAlterConfigsDueToPolicy(String quorum) {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "invalid-alter-configs-due-to-policy-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topic2 = "invalid-alter-configs-due-to-policy-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topic3 = "invalid-alter-configs-due-to-policy-topic-3";
        ConfigResource topicResource3 = new ConfigResource(ConfigResource.Type.TOPIC, topic3);
        this.createTopic(topic3, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaBroker)this.brokers().head()).config().brokerId()));
        java.util.List brokerConfigs = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry("message.max.bytes", "50000"), (List)Nil$.MODULE$)).asJava();
        this.client().alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigs))}))).asJava()).all().get();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.bytes"})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(((AlterConfigPolicy.RequestMetadata)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).head()).configs().keySet()).asScala());
        AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
        java.util.List topicConfigEntries1 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry("min.cleanable.dirty.ratio", "0.9"), (List)new .colon.colon((Object)new ConfigEntry("min.insync.replicas", "2"), (List)Nil$.MODULE$))).asJava();
        java.util.List topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry("min.cleanable.dirty.ratio", "0.8"), (List)Nil$.MODULE$)).asJava();
        java.util.List topicConfigEntries3 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry("min.insync.replicas", "-1"), (List)Nil$.MODULE$)).asJava();
        java.util.List brokerConfigEntries = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry("ssl.truststore.password", "12313"), (List)Nil$.MODULE$)).asJava();
        AlterConfigsResult alterResult = this.client().alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource1), PolicyViolationException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        ((KafkaFuture)alterResult.values().get(topicResource2)).get();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource3), InvalidConfigurationException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(brokerResource), InvalidRequestException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assertions.assertTrue((boolean)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).isEmpty(), (String)"Should not see the broker resource in the AlterConfig policy when the broker configs are not being updated.");
        AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
        this.ensureConsistentKRaftMetadata();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)topicResource3, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$))))).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(0.5), (Object)((Config)configs.get(topicResource1)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertEquals((Object)Integer.toString(1), (Object)((Config)configs.get(topicResource1)).get("min.insync.replicas").value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get("ssl.truststore.password").value());
        topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry("min.cleanable.dirty.ratio", "0.7"), (List)Nil$.MODULE$)).asJava();
        alterResult = this.client().alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource1), PolicyViolationException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        ((KafkaFuture)alterResult.values().get(topicResource2)).get();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topicResource3), InvalidConfigurationException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(brokerResource), InvalidRequestException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assertions.assertTrue((boolean)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).isEmpty(), (String)"Should not see the broker resource in the AlterConfig policy when the broker configs are not being updated.");
        AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
        this.ensureConsistentKRaftMetadata();
        configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)topicResource3, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$))))).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(0.5), (Object)((Config)configs.get(topicResource1)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertEquals((Object)Integer.toString(1), (Object)((Config)configs.get(topicResource1)).get("min.insync.replicas").value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get("ssl.truststore.password").value());
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections", "9999"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection())}))).asJava());
        alterResult.all().get();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max.connections"})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(((AlterConfigPolicy.RequestMetadata)AdminClientWithPoliciesIntegrationTest$.MODULE$.validationsForResource(brokerResource).head()).configs().keySet()).asScala());
    }

    public AdminClientWithPoliciesIntegrationTest() {
        this.brokerCount = 3;
    }

    public static class Policy
    implements AlterConfigPolicy {
        private scala.collection.immutable.Map<String, ?> configs;
        private boolean closed = false;

        public scala.collection.immutable.Map<String, ?> configs() {
            return this.configs;
        }

        public void configs_$eq(scala.collection.immutable.Map<String, ?> x$1) {
            this.configs = x$1;
        }

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void configure(java.util.Map<String, ?> configs) {
            AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().clear();
            this.configs_$eq(((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(configs).asScala()).toMap(Predef$.MODULE$.$conforms()));
        }

        public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
            AdminClientWithPoliciesIntegrationTest$.MODULE$.validations().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigPolicy.RequestMetadata[]{requestMetadata}));
            Predef$.MODULE$.require(!this.closed(), (Function0 & Serializable & scala.Serializable)() -> "Policy should not be closed");
            Predef$.MODULE$.require(this.configs().nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "configure should have been called with non empty configs");
            Predef$.MODULE$.require(!requestMetadata.configs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "request configs should not be empty");
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(requestMetadata.resource().name())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "resource name should not be empty");
            if (requestMetadata.configs().containsKey("min.insync.replicas")) {
                throw new PolicyViolationException("Min in sync replicas cannot be updated");
            }
        }

        public void close() {
            this.closed_$eq(true);
        }
    }
}

