/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.security.authorizer.AclEntry;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0001\u0005-f!B\f\u0019\u0003\u0003i\u0002\"\u0002\u0015\u0001\t\u0003I\u0003\"B\u0016\u0001\t\u0003a\u0003\"B\u001a\u0001\t\u0003b\u0003\"\u0003\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u00016\u0011%\t\u0005\u00011AA\u0002\u0013\u0005!\tC\u0005I\u0001\u0001\u0007\t\u0011)Q\u0005m!I\u0011\n\u0001a\u0001\u0002\u0004%\tA\u0013\u0005\n-\u0002\u0001\r\u00111A\u0005\u0002]C\u0011\"\u0017\u0001A\u0002\u0003\u0005\u000b\u0015B&\t\u000bi\u0003A\u0011I.\t\u000b\u0005\u0004A\u0011\t2\t\u000b\u001d\u0004A\u0011\u00012\t\u000b1\u0004A\u0011\u00012\t\u000b9\u0004A\u0011A8\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0005\u0007\u0003\u0017\u0002A\u0011\u0001&\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003\"CAA\u0001E\u0005I\u0011AAB\u0011%\tI\nAI\u0001\n\u0003\tYJ\u0001\rCCN,\u0017\tZ7j]&sG/Z4sCRLwN\u001c+fgRT!!\u0007\u000e\u0002\u0007\u0005\u0004\u0018NC\u0001\u001c\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0010#!\ty\u0002%D\u0001\u0019\u0013\t\t\u0003D\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\t\u0019c%D\u0001%\u0015\t)#$A\u0003vi&d7/\u0003\u0002(I\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001+!\ty\u0002!A\u0006ce>\\WM]\"pk:$X#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\u0007%sG/A\u0006m_\u001e$\u0015N]\"pk:$\u0018\u0001\u0003;fgRLeNZ8\u0016\u0003Y\u0002\"aN \u000e\u0003aR!!G\u001d\u000b\u0005iZ\u0014a\u00026va&$XM\u001d\u0006\u0003yu\nQA[;oSRT\u0011AP\u0001\u0004_J<\u0017B\u0001!9\u0005!!Vm\u001d;J]\u001a|\u0017\u0001\u0004;fgRLeNZ8`I\u0015\fHCA\"G!\tqC)\u0003\u0002F_\t!QK\\5u\u0011\u001d9U!!AA\u0002Y\n1\u0001\u001f\u00132\u0003%!Xm\u001d;J]\u001a|\u0007%\u0001\u0004dY&,g\u000e^\u000b\u0002\u0017B\u0011A\nV\u0007\u0002\u001b*\u0011ajT\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003!F\u000bqa\u00197jK:$8O\u0003\u0002\u001c%*\u00111+P\u0001\u0007CB\f7\r[3\n\u0005Uk%!B!e[&t\u0017AC2mS\u0016tGo\u0018\u0013fcR\u00111\t\u0017\u0005\b\u000f\"\t\t\u00111\u0001L\u0003\u001d\u0019G.[3oi\u0002\nQa]3u+B$\"a\u0011/\t\u000bQR\u0001\u0019\u0001\u001c)\u0005)q\u0006CA\u001c`\u0013\t\u0001\u0007H\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002\u0007\"\u00121\u0002\u001a\t\u0003o\u0015L!A\u001a\u001d\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0006;fgR\u001c%/Z1uK\u0012+G.\u001a;f)>\u0004\u0018nY:)\u00051I\u0007CA\u001ck\u0013\tY\u0007H\u0001\u0003UKN$\u0018\u0001\u0007;fgR\fU\u000f\u001e5pe&TX\rZ(qKJ\fG/[8og\"\u0012Q\"[\u0001\u001dG>tg-[4ve\u0016$7\t\\;ti\u0016\u0014\b+\u001a:nSN\u001c\u0018n\u001c8t+\u0005\u0001\bcA9yw:\u0011!O\u001e\t\u0003g>j\u0011\u0001\u001e\u0006\u0003kr\ta\u0001\u0010:p_Rt\u0014BA<0\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011P\u001f\u0002\u0004'\u0016$(BA<0!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\u0004C\u000ed'bAA\u0001#\u000611m\\7n_:L1!!\u0002~\u00051\t5\r\\(qKJ\fG/[8o\u00035iw\u000eZ5gs\u000e{gNZ5hgR\u00191)a\u0003\t\u000f\u00055q\u00021\u0001\u0002\u0010\u000591m\u001c8gS\u001e\u001c\bCBA\t\u0003/\tY\"\u0004\u0002\u0002\u0014)\u0019\u0011QC\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001a\u0005M!aA*fcB!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001B;uS2T!!!\n\u0002\t)\fg/Y\u0005\u0005\u0003S\tyB\u0001\u0006Qe>\u0004XM\u001d;jKN\fac\u001b:bMR\u001cuN\u001c;s_2dWM]\"p]\u001aLwm\u001d\u000b\u0003\u0003\u001f\tAb\u0019:fCR,7i\u001c8gS\u001e,\"!a\r\u0011\u0011\u0005u\u0011QGA\u001d\u0003\u007fIA!a\u000e\u0002 \t\u0019Q*\u00199\u0011\u0007E\fY$C\u0002\u0002>i\u0014aa\u0015;sS:<\u0007\u0003BA!\u0003\u000fj!!a\u0011\u000b\t\u0005\u0015\u00131E\u0001\u0005Y\u0006tw-\u0003\u0003\u0002J\u0005\r#AB(cU\u0016\u001cG/A\tde\u0016\fG/Z!e[&t7\t\\5f]R\fQb^1ji\u001a{'\u000fV8qS\u000e\u001cHcB\"\u0002R\u0005M\u0013\u0011\f\u0005\u0006\u0013N\u0001\ra\u0013\u0005\b\u0003+\u001a\u0002\u0019AA,\u0003=)\u0007\u0010]3di\u0016$\u0007K]3tK:$\bCBA\t\u0003/\tI\u0004C\u0004\u0002\\M\u0001\r!a\u0016\u0002\u001f\u0015D\b/Z2uK\u0012l\u0015n]:j]\u001e\f\u0001cZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u0015\u0015\u0005\u0005\u0014qMA5\u0003[\n9\bE\u0002M\u0003GJ1!!\u001aN\u0005A!v\u000e]5d\t\u0016\u001c8M]5qi&|g\u000eC\u0003J)\u0001\u00071\nC\u0004\u0002lQ\u0001\r!!\u000f\u0002\u000bQ|\u0007/[2\t\u0013\u0005=D\u0003%AA\u0002\u0005E\u0014a\u00043fg\u000e\u0014\u0018NY3PaRLwN\\:\u0011\u00071\u000b\u0019(C\u0002\u0002v5\u0013Q\u0003R3tGJL'-\u001a+pa&\u001c7o\u00149uS>t7\u000fC\u0005\u0002zQ\u0001\n\u00111\u0001\u0002|\u0005AR\r\u001f9fGR,GMT;n!\u0006\u0014H/\u001b;j_:\u001cx\n\u001d;\u0011\t9\ni(L\u0005\u0004\u0003\u007fz#AB(qi&|g.\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0006*\"\u0011\u0011OADW\t\tI\t\u0005\u0003\u0002\f\u0006UUBAAG\u0015\u0011\ty)!%\u0002\u0013Ut7\r[3dW\u0016$'bAAJ_\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0015Q\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AG4fiR{\u0007/[2NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\"TCAAOU\u0011\tY(a\")\u000f\u0001\t\t+a*\u0002*B\u0019q'a)\n\u0007\u0005\u0015\u0006HA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0003a\u0004")
public abstract class BaseAdminIntegrationTest
extends IntegrationTestHarness {
    private TestInfo testInfo;
    private Admin client;

    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public int logDirCount() {
        return 2;
    }

    public TestInfo testInfo() {
        return this.testInfo;
    }

    public void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        super.setUp(testInfo);
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.brokers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    @Test
    public void testCreateDeleteTopics() {
        this.client_$eq(this.createAdminClient());
        .colon.colon topics = new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)new .colon.colon((Object)"mytopic3", (List)Nil$.MODULE$)));
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic("mytopic", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)Nil$.MODULE$))).asJava())}))).asJava()), (List)new .colon.colon((Object)new NewTopic("mytopic2", 3, (short)3), (List)new .colon.colon((Object)new NewTopic("mytopic3", OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty()))), (List)Nil$.MODULE$)));
        CreateTopicsResult validateResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava(), new CreateTopicsOptions().validateOnly(true));
        validateResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.validateMetadataAndConfigs$1(validateResult);
        CreateTopicsResult createResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava());
        createResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        this.validateMetadataAndConfigs$1(createResult);
        scala.collection.immutable.Map<String, Uuid> topicIds = this.getTopicIds();
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            BaseAdminIntegrationTest.$anonfun$testCreateDeleteTopics$1(createResult, topicIds, topic);
            return BoxedUnit.UNIT;
        });
        CreateTopicsResult failedCreateResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava());
        java.util.Map results = failedCreateResult.values();
        Assertions.assertTrue((boolean)results.containsKey("mytopic"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assertions.assertTrue((boolean)results.containsKey("mytopic2"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assertions.assertTrue((boolean)results.containsKey("mytopic3"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.numPartitions("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.replicationFactor("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.config("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava()).allTopicNames().get();
        Assertions.assertEquals((Object)topics.toSet(), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assertions.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assertions.assertEquals((int)2, (int)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assertions.assertEquals((int)1, (int)topic0Partition0.leader().id());
        Assertions.assertEquals((int)0, (int)topic0Partition0.partition());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assertions.assertEquals((int)2, (int)topic0Partition1.leader().id());
        Assertions.assertEquals((int)1, (int)topic0Partition1.partition());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assertions.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assertions.assertEquals((int)3, (int)topic1.partitions().size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            TopicPartitionInfo partition = (TopicPartitionInfo)topic1.partitions().get(partitionId);
            Assertions.assertEquals((int)partitionId, (int)partition.partition());
            Assertions.assertEquals((int)3, (int)partition.replicas().size());
            partition.replicas().forEach(replica -> {
                Assertions.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
                Assertions.assertTrue((replica.id() < this.brokerCount() ? 1 : 0) != 0);
            });
            Assertions.assertEquals((int)partition.replicas().size(), (int)((SeqLike)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Buffer$.MODULE$.canBuildFrom())).distinct()).size(), (String)"No duplicate replica ids");
            Assertions.assertEquals((int)3, (int)partition.isr().size());
            Assertions.assertEquals((Object)partition.replicas(), (Object)partition.isr());
            Assertions.assertTrue((boolean)partition.replicas().contains(partition.leader()));
        });
        TopicDescription topic3 = (TopicDescription)topicToDescription.get("mytopic3");
        Assertions.assertEquals((Object)"mytopic3", (Object)topic3.name());
        Assertions.assertEquals((Integer)((KafkaConfig)this.configs().head()).numPartitions(), (int)topic3.partitions().size());
        Assertions.assertEquals((int)((KafkaConfig)this.configs().head()).defaultReplicationFactor(), (int)((TopicPartitionInfo)topic3.partitions().get(0)).replicas().size());
        this.client().deleteTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testAuthorizedOperations() {
        this.client_$eq(this.createAdminClient());
        DescribeClusterResult result = this.client().describeCluster();
        Assertions.assertNull((Object)result.authorizedOperations().get());
        result = this.client().describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true));
        Assertions.assertEquals((Object)((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(this.configuredClusterPermissions()).asJava()), (Object)result.authorizedOperations().get());
        String topic = "mytopic";
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic(topic, 3, (short)3), (List)Nil$.MODULE$);
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
        TopicDescription topicResult = this.getTopicMetadata(this.client(), topic, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        Assertions.assertNull((Object)topicResult.authorizedOperations());
        topicResult = this.getTopicMetadata(this.client(), topic, new DescribeTopicsOptions().includeAuthorizedOperations(true), this.getTopicMetadata$default$4());
        Assertions.assertEquals((Object)AclEntry.supportedOperations((ResourceType)ResourceType.TOPIC), (Object)topicResult.authorizedOperations());
    }

    public scala.collection.immutable.Set<AclOperation> configuredClusterPermissions() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(AclEntry.supportedOperations((ResourceType)ResourceType.CLUSTER)).asScala()).toSet();
    }

    @Override
    public void modifyConfigs(Seq<Properties> configs) {
        super.modifyConfigs(configs);
        if (this.testInfo().getTestMethod().toString().contains("testCreateTopicsReturnsConfigs")) {
            configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
                config.setProperty("log.roll.hours", "2");
                config.setProperty("log.retention.minutes", "240");
                return config.setProperty(ServerLogConfigs.LOG_ROLL_TIME_JITTER_MILLIS_CONFIG, "123");
            });
        }
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty("delete.topic.enable", "true");
            config.setProperty("group.initial.rebalance.delay.ms", "0");
            config.setProperty("auto.leader.rebalance.enable", "false");
            config.setProperty("controlled.shutdown.enable", "false");
            if (!config.containsKey("ssl.truststore.password")) {
                return config.setProperty("ssl.truststore.password", "some.invalid.pass");
            }
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs() {
        Properties controllerConfig = new Properties();
        .colon.colon controllerConfigs = new .colon.colon((Object)controllerConfig, (List)Nil$.MODULE$);
        this.modifyConfigs((Seq<Properties>)controllerConfigs);
        return controllerConfigs;
    }

    public java.util.Map<String, Object> createConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        config.put("request.timeout.ms", "20000");
        config.put("default.api.timeout.ms", "40000");
        return config;
    }

    public Admin createAdminClient() {
        Properties props = new Properties();
        props.putAll(this.createConfig());
        ListenerName x$2 = this.createAdminClient$default$1();
        return this.createAdminClient(x$2, props);
    }

    /*
     * WARNING - void declaration
     */
    public void waitForTopics(Admin client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseAdminIntegrationTest.$anonfun$waitForTopics$1(client, expectedPresent, expectedMissing)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseAdminIntegrationTest.$anonfun$waitForTopics$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public TopicDescription getTopicMetadata(Admin client, String topic, DescribeTopicsOptions describeOptions, Option<Object> expectedNumPartitionsOpt) {
        ObjectRef result = ObjectRef.create(null);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseAdminIntegrationTest.$anonfun$getTopicMetadata$1(client, topic, describeOptions, result, expectedNumPartitionsOpt)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseAdminIntegrationTest.$anonfun$getTopicMetadata$4(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (TopicDescription)result.elem;
    }

    public DescribeTopicsOptions getTopicMetadata$default$3() {
        return new DescribeTopicsOptions();
    }

    public Option<Object> getTopicMetadata$default$4() {
        return None$.MODULE$;
    }

    private final void validateMetadataAndConfigs$1(CreateTopicsResult result) {
        Assertions.assertEquals((int)2, (Integer)((Integer)result.numPartitions("mytopic").get()));
        Assertions.assertEquals((int)2, (Integer)((Integer)result.replicationFactor("mytopic").get()));
        Assertions.assertEquals((int)3, (Integer)((Integer)result.numPartitions("mytopic2").get()));
        Assertions.assertEquals((int)3, (Integer)((Integer)result.replicationFactor("mytopic2").get()));
        Assertions.assertEquals((Integer)((KafkaConfig)this.configs().head()).numPartitions(), (Integer)((Integer)result.numPartitions("mytopic3").get()));
        Assertions.assertEquals((int)((KafkaConfig)this.configs().head()).defaultReplicationFactor(), (Integer)((Integer)result.replicationFactor("mytopic3").get()));
        Assertions.assertFalse((boolean)((Config)result.config("mytopic").get()).entries().isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTopics$1(CreateTopicsResult createResult$1, scala.collection.immutable.Map topicIds$1, String topic) {
        Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)createResult$1.topicId(topic).get());
        Assertions.assertEquals((Object)topicIds$1.apply((Object)topic), (Object)createResult$1.topicId(topic).get());
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$3(java.util.Set topics$1, String topicName) {
        return !topics$1.contains(topicName);
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$1(Admin client$1, Seq expectedPresent$1, Seq expectedMissing$1) {
        java.util.Set topics = (java.util.Set)client$1.listTopics().names().get();
        return expectedPresent$1.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)topics.contains(topicName))) && expectedMissing$1.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)BaseAdminIntegrationTest.$anonfun$waitForTopics$3(topics, topicName)));
    }

    public static final /* synthetic */ String $anonfun$waitForTopics$4() {
        return "timed out waiting for topics";
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$1(Admin client$2, String topic$1, DescribeTopicsOptions describeOptions$1, ObjectRef result$1, Option expectedNumPartitionsOpt$1) {
        KafkaFuture topicResult = (KafkaFuture)client$2.describeTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))).asJava(), describeOptions$1).topicNameValues().get(topic$1);
        try {
            result$1.elem = (TopicDescription)topicResult.get();
            return BoxesRunTime.unboxToBoolean((Object)expectedNumPartitionsOpt$1.map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 == ((TopicDescription)result$1.elem).partitions().size()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ String $anonfun$getTopicMetadata$4(String topic$1) {
        return new StringBuilder(35).append("Timed out waiting for metadata for ").append(topic$1).toString();
    }
}

