/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import kafka.api.AbstractConsumerTest;
import kafka.api.PlaintextConsumerAssignorsTest$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.CooperativeStickyAssignor;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedAssignorException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001\u0002\b\u0010\u0001QAQ!\u0007\u0001\u0005\u0002iAQ\u0001\b\u0001\u0005\u0002uAQA\u0014\u0001\u0005\u0002=CQ!\u0016\u0001\u0005\u0002YCQ\u0001\u0018\u0001\u0005\u0002uCQa\u0019\u0001\u0005\u0002\u0011DQA\u001b\u0001\u0005\u0002-DQA\u001e\u0001\u0005\u0002]DQ! \u0001\u0005\u0002y<q!!\u000b\u0010\u0011\u0003\tYC\u0002\u0004\u000f\u001f!\u0005\u0011Q\u0006\u0005\u00073-!\t!!\u000e\t\r\u0015[A\u0011AA\u001c\u0005y\u0001F.Y5oi\u0016DHoQ8ogVlWM]!tg&<gn\u001c:t)\u0016\u001cHO\u0003\u0002\u0011#\u0005\u0019\u0011\r]5\u000b\u0003I\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001+A\u0011acF\u0007\u0002\u001f%\u0011\u0001d\u0004\u0002\u0015\u0003\n\u001cHO]1di\u000e{gn];nKJ$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\f\u0001\u0003a!Xm\u001d;S_VtGMU8cS:\f5o]5h]6,g\u000e\u001e\u000b\u0004=\u0011\n\u0004CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSRDQ!\n\u0002A\u0002\u0019\na!];peVl\u0007CA\u0014/\u001d\tAC\u0006\u0005\u0002*A5\t!F\u0003\u0002,'\u00051AH]8pizJ!!\f\u0011\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[\u0001BQA\r\u0002A\u0002\u0019\nQb\u001a:pkB\u0004&o\u001c;pG>d\u0007\u0006\u0002\u00025\u0005\u000e\u0003\"!\u000e!\u000e\u0003YR!a\u000e\u001d\u0002\u0011A\u0014xN^5eKJT!!\u000f\u001e\u0002\rA\f'/Y7t\u0015\tYD(A\u0004kkBLG/\u001a:\u000b\u0005ur\u0014!\u00026v]&$(\"A \u0002\u0007=\u0014x-\u0003\u0002Bm\taQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\nA)I\u0001F\u0003}:W\r\u001e+fgR\fVo\u001c:v[\u0006sGm\u0012:pkB\u0004&o\u001c;pG>d\u0007+\u0019:b[\u0016$XM]:DY\u0006\u001c8/[2He>,\b\u000f\u0015:pi>\u001cw\u000e\\(oYfDCAA$L\u0019B\u0011\u0001*S\u0007\u0002q%\u0011!\n\u000f\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013!T\u0001+w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBjhf\u001a:pkB\u0004&o\u001c;pG>dWh_\u0019~\u0003\r\"Xm\u001d;Nk2$\u0018nQ8ogVlWM\u001d*pk:$'k\u001c2j]\u0006\u001b8/[4o_J$2A\b)R\u0011\u0015)3\u00011\u0001'\u0011\u0015\u00114\u00011\u0001'Q\u0011\u0019AGQ*-\u0003\u0011CCaA$L\u0019\u0006yB/Z:u\u001bVdG/[\"p]N,X.\u001a:Ti&\u001c7._!tg&<gn\u001c:\u0015\u0007y9\u0006\fC\u0003&\t\u0001\u0007a\u0005C\u00033\t\u0001\u0007a\u0005\u000b\u0003\u0005i\tSF&\u0001#)\t\u001195\nT\u00014i\u0016\u001cH/T;mi&\u001cuN\\:v[\u0016\u0014H)\u001a4bk2$\u0018i]:jO:|'/\u00118e-\u0016\u0014\u0018NZ=BgNLwM\\7f]R$2A\b0`\u0011\u0015)S\u00011\u0001'\u0011\u0015\u0011T\u00011\u0001'Q\u0011)AGQ1-\u0003\u0011CC!B$L\u0019\u0006\u0001C/Z:u\u001bVdG/[\"p]N,X.\u001a:EK\u001a\fW\u000f\u001c;BgNLwM\\8s)\rqRM\u001a\u0005\u0006K\u0019\u0001\rA\n\u0005\u0006e\u0019\u0001\rA\n\u0015\u0005\rQ\u0012\u0005\u000eL\u0001EQ\u00111qi\u0013'\u00023Q,7\u000f\u001e*f[>$X-Q:tS\u001etwN]%om\u0006d\u0017\u000e\u001a\u000b\u0004=1l\u0007\"B\u0013\b\u0001\u00041\u0003\"\u0002\u001a\b\u0001\u00041\u0003\u0006B\u0004p\u0005J\u0004\"!\u000e9\n\u0005E4$!C\"tmN{WO]2fY\u0005\u0019\u0018%\u0001;\u0002--\u0014\u0018M\u001a;,W&\u0004\b\b\u000e\u001d-A\r|gn];nKJDCaB$L\u0019\u00069B/Z:u%\u0016lw\u000e^3BgNLwM\\8s%\u0006tw-\u001a\u000b\u0004=aL\b\"B\u0013\t\u0001\u00041\u0003\"\u0002\u001a\t\u0001\u00041\u0003\u0006\u0002\u0005p\u0005nd\u0013a\u001d\u0015\u0005\u0011\u001d[E*\u0001\fuKN$(+\u001a2bY\u0006t7-Z!oIJ+'n\\5o)\u0011qr0a\u0001\t\r\u0005\u0005\u0011\u00021\u0001'\u0003I\t7o]5h]6,g\u000e^*ue\u0006$XmZ=\t\u000b\u0015J\u0001\u0019\u0001\u0014)\u000b%y')a\u0002-\u0011\u0005%\u0011QBA\t\u0003+\t#!a\u0003\u0002\u0003>\u0014xML1qC\u000eDWML6bM.\fgf\u00197jK:$8OL2p]N,X.\u001a:/\u0007>|\u0007/\u001a:bi&4Xm\u0015;jG.L\u0018i]:jO:|'\u000f\f\u0011!Ai\\\u0017EAA\b\u0003\u0005{'o\u001a\u0018ba\u0006\u001c\u0007.\u001a\u0018lC\u001a\\\u0017ML2mS\u0016tGo\u001d\u0018d_:\u001cX/\\3s]I\u000bgnZ3BgNLwM\\8sY\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001R8.\t\u0002\u0002\u0014\u0005!uN]4/CB\f7\r[3/W\u000647.\u0019\u0018dY&,g\u000e^:/G>t7/^7fe:\u001aun\u001c9fe\u0006$\u0018N^3Ti&\u001c7._!tg&<gn\u001c:-A\u0001\u00023N]1gi\u0006\u0012\u0011qC\u0001E_J<g&\u00199bG\",gf[1gW\u0006t3\r\\5f]R\u001chfY8ogVlWM\u001d\u0018SC:<W-Q:tS\u001etwN\u001d\u0017!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!WJ\fg\r\u001e\u0015\u0003\u0013\u001dCc\u0001AA\u000f\u0005\u0006\u001d\u0002\u0003BA\u0010\u0003Gi!!!\t\u000b\u0005AQ\u0014\u0002BA\u0013\u0003C\u0011q\u0001V5nK>,HO\b\u0002\u00031\u0006q\u0002\u000b\\1j]R,\u0007\u0010^\"p]N,X.\u001a:BgNLwM\\8sgR+7\u000f\u001e\t\u0003--\u00192aCA\u0018!\ry\u0012\u0011G\u0005\u0004\u0003g\u0001#AB!osJ+g\r\u0006\u0002\u0002,U\u0011\u0011\u0011\b\t\u0007\u0003w\tI%!\u0014\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\naa\u001d;sK\u0006l'\u0002BA\"\u0003\u000b\nA!\u001e;jY*\u0011\u0011qI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002L\u0005u\"AB*ue\u0016\fW\u000eE\u00026\u0003\u001fJ1!!\u00157\u0005%\t%oZ;nK:$8\u000f")
public class PlaintextConsumerAssignorsTest
extends AbstractConsumerTest {
    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly() {
        return PlaintextConsumerAssignorsTest$.MODULE$.getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly"})
    public void testRoundRobinAssignment(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Set expectedAssignment = (Set)this.createTopicAndSendRecords(producer, topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 2, 100));
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)expectedAssignment);
        String topic3 = "topic3";
        this.createTopicAndSendRecords(producer, topic3, 2, 100);
        Set newExpectedAssignment = (Set)expectedAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)newExpectedAssignment);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)expectedAssignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly"})
    public void testMultiConsumerRoundRobinAssignor(String quorum, String groupProtocol) {
        void var9_9;
        void var8_8;
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Set subscriptions = (Set)this.createTopicAndSendRecords(producer, topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 8, 100));
        Tuple2<Buffer<Consumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (Set<TopicPartition>)subscriptions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        void consumerGroup2 = var8_8;
        void consumerPollers2 = var9_9;
        try {
            this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
            this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<Consumer<byte[], byte[]>>)consumerGroup2, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (Set<TopicPartition>)subscriptions, "roundrobin-group");
        }
        finally {
            consumerPollers2.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly"})
    public void testMultiConsumerStickyAssignor(String quorum, String groupProtocol) {
        void var9_9;
        void var8_8;
        this.consumerConfig().setProperty("group.id", "sticky-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", StickyAssignor.class.getName());
        String topic = "single-topic";
        int rand = 1 + Random$.MODULE$.nextInt(10);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Set<TopicPartition> partitions = this.createTopicAndSendRecords(producer, topic, rand * 10, 100);
        Tuple2<Buffer<Consumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(9, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        void consumerGroup2 = var8_8;
        void consumerPollers2 = var9_9;
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, partitions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        Map prePartition2PollerId = PlaintextConsumerAssignorsTest.reverse$1(((TraversableOnce)consumerPollers2.map((Function1 & Serializable & scala.Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<Consumer<byte[], byte[]>>)consumerGroup2, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, "sticky-group");
        Map postPartition2PollerId = PlaintextConsumerAssignorsTest.reverse$1(((TraversableOnce)consumerPollers2.map((Function1 & Serializable & scala.Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        Set keys = (Set)prePartition2PollerId.keySet().union((GenSet)postPartition2PollerId.keySet());
        IntRef changes = IntRef.create((int)0);
        keys.foreach((Function1 & Serializable & scala.Serializable)key -> {
            PlaintextConsumerAssignorsTest.$anonfun$testMultiConsumerStickyAssignor$5(prePartition2PollerId, postPartition2PollerId, changes, key);
            return BoxedUnit.UNIT;
        });
        consumerPollers2.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)rand, (int)changes.elem, (String)"Expected only two topic partitions that have switched to other consumers.");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly"})
    public void testMultiConsumerDefaultAssignorAndVerifyAssignment(String quorum, String groupProtocol) {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topic2, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        TopicPartition tp1_0 = new TopicPartition(topic1, 0);
        TopicPartition tp1_1 = new TopicPartition(topic1, 1);
        TopicPartition tp1_2 = new TopicPartition(topic1, 2);
        TopicPartition tp2_0 = new TopicPartition(topic2, 0);
        TopicPartition tp2_1 = new TopicPartition(topic2, 1);
        TopicPartition tp2_2 = new TopicPartition(topic2, 2);
        Set subscriptions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0, tp1_1, tp1_2, tp2_0, tp2_1, tp2_2}));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<Consumer<byte[], byte[]>>)consumersInGroup, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)));
        Buffer expectedAssignment = (Buffer)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Set[]{(Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0, tp1_1, tp2_0, tp2_1})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_2, tp2_2}))}));
        try {
            Option<String> x$4 = this.validateGroupAssignment$default$3();
            long x$5 = this.validateGroupAssignment$default$4();
            this.validateGroupAssignment(consumerPollers, (Set<TopicPartition>)subscriptions, x$4, x$5, (Buffer<Set<TopicPartition>>)expectedAssignment);
        }
        finally {
            consumerPollers.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly"})
    public void testMultiConsumerDefaultAssignor(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 100, this.tp2(), this.sendRecords$default$4());
        String topic1 = "topic1";
        Set subscriptions = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 5, 100));
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<Consumer<byte[], byte[]>>)consumersInGroup, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)));
        try {
            this.validateGroupAssignment(consumerPollers, (Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
            this.addConsumersToGroupAndWaitForGroupAssignment(2, (Buffer<Consumer<byte[], byte[]>>)consumersInGroup, consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), (Set<TopicPartition>)subscriptions, this.addConsumersToGroupAndWaitForGroupAssignment$default$6());
            String topic2 = "topic2";
            Set expandedSubscriptions = (Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(producer, topic2, 3, 100));
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))), (Set<TopicPartition>)expandedSubscriptions);
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), (Set<TopicPartition>)subscriptions);
        }
        finally {
            consumerPollers.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @CsvSource(value={"kraft+kip848, consumer"})
    public void testRemoteAssignorInvalid(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("group.id", "invalid-assignor-group");
        this.consumerConfig().setProperty("group.remote.assignor", "invalid");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Set<TopicPartition> expectedAssignment = this.createTopicAndSendRecords(producer, topic1, 2, 100);
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJava());
        Assertions.assertTrue((boolean)((UnsupportedAssignorException)Assertions.assertThrows(UnsupportedAssignorException.class, () -> this.awaitAssignment(consumer, expectedAssignment))).getMessage().startsWith("ServerAssignor invalid is not supported. Supported assignors: "));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @CsvSource(value={"kraft+kip848, consumer"})
    public void testRemoteAssignorRange(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("group.id", "range-group");
        this.consumerConfig().setProperty("group.remote.assignor", "range");
        this.consumerConfig().setProperty("max.poll.interval.ms", "30000");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Set expectedAssignment = (Set)this.createTopicAndSendRecords(producer, topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 2, 100));
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)expectedAssignment);
        String topic3 = "topic3";
        Set<TopicPartition> additionalAssignment = this.createTopicAndSendRecords(producer, topic3, 2, 100);
        Set newExpectedAssignment = (Set)expectedAssignment.$plus$plus(additionalAssignment);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)newExpectedAssignment);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)expectedAssignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @CsvSource(value={"org.apache.kafka.clients.consumer.CooperativeStickyAssignor,   zk", "org.apache.kafka.clients.consumer.RangeAssignor,               zk", "org.apache.kafka.clients.consumer.CooperativeStickyAssignor,   kraft", "org.apache.kafka.clients.consumer.RangeAssignor,               kraft"})
    public void testRebalanceAndRejoin(String assignmentStrategy, String quorum) {
        String stableMemberId1;
        int stableGeneration;
        this.consumerConfig().setProperty("group.protocol", "classic");
        this.consumerConfig().setProperty("group.id", "rebalance-and-rejoin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", assignmentStrategy);
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        Consumer consumer1 = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Consumer consumer2 = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic = "topic1";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Set<TopicPartition> expectedAssignment = this.createTopicAndSendRecords(producer, topic, 2, 100);
        Assertions.assertEquals((int)0, (int)consumer1.assignment().size());
        Assertions.assertEquals((int)0, (int)consumer2.assignment().size());
        ReentrantLock lock = new ReentrantLock();
        IntRef generationId1 = IntRef.create((int)-1);
        ObjectRef memberId1 = ObjectRef.create((Object)"");
        ConsumerRebalanceListener customRebalanceListener = new ConsumerRebalanceListener(null, lock, generationId1, consumer1, memberId1){
            private final ReentrantLock lock$1;
            private final IntRef generationId1$1;
            private final Consumer consumer1$1;
            private final ObjectRef memberId1$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                if (!this.lock$1.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    Assertions.fail((String)"Time out while awaiting for lock.");
                }
                try {
                    this.generationId1$1.elem = this.consumer1$1.groupMetadata().generationId();
                    this.memberId1$1.elem = this.consumer1$1.groupMetadata().memberId();
                }
                finally {
                    this.lock$1.unlock();
                }
            }
            {
                this.lock$1 = lock$1;
                this.generationId1$1 = generationId1$1;
                this.consumer1$1 = consumer1$1;
                this.memberId1$1 = memberId1$1;
            }
        };
        AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller1 = new AbstractConsumerTest.ConsumerAssignmentPoller(this, consumer1, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (Set<TopicPartition>)Predef$.MODULE$.Set().empty(), customRebalanceListener);
        consumerPoller1.start();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerAssignorsTest.$anonfun$testRebalanceAndRejoin$1(consumerPoller1, expectedAssignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerAssignorsTest.$anonfun$testRebalanceAndRejoin$2(expectedAssignment));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (!lock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            Assertions.fail((String)"Time out while awaiting for lock.");
        }
        try {
            stableGeneration = generationId1.elem;
            stableMemberId1 = (String)memberId1.elem;
        }
        finally {
            lock.unlock();
        }
        AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller2 = this.subscribeConsumerAndStartPolling(consumer2, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), this.subscribeConsumerAndStartPolling$default$3());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextConsumerAssignorsTest.$anonfun$testRebalanceAndRejoin$3(consumerPoller1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerAssignorsTest.$anonfun$testRebalanceAndRejoin$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!PlaintextConsumerAssignorsTest.$anonfun$testRebalanceAndRejoin$5(consumerPoller2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerAssignorsTest.$anonfun$testRebalanceAndRejoin$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (!lock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            Assertions.fail((String)"Time out while awaiting for lock.");
        }
        try {
            if (assignmentStrategy.equals(CooperativeStickyAssignor.class.getName())) {
                Assertions.assertEquals((int)(stableGeneration + 2), (int)generationId1.elem);
            } else {
                Assertions.assertEquals((int)(stableGeneration + 1), (int)generationId1.elem);
            }
            Assertions.assertEquals((Object)stableMemberId1, (Object)((String)memberId1.elem));
        }
        finally {
            lock.unlock();
        }
        consumerPoller1.shutdown();
        consumerPoller2.shutdown();
    }

    private static final Map reverse$1(Map m) {
        return ((TraversableOnce)((SetLike)m.values().toSet().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, ((IterableLike)m.keys().filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> ((SetLike)m.apply((Object)BoxesRunTime.boxToLong((long)x$3))).contains(v))).head()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$testMultiConsumerStickyAssignor$5(Map prePartition2PollerId$1, Map postPartition2PollerId$1, IntRef changes$1, TopicPartition key) {
        Option preVal = prePartition2PollerId$1.get((Object)key);
        Option postVal = postPartition2PollerId$1.get((Object)key);
        if (preVal.nonEmpty() && postVal.nonEmpty()) {
            if (BoxesRunTime.unboxToLong((Object)preVal.get()) != BoxesRunTime.unboxToLong((Object)postVal.get())) {
                ++changes$1.elem;
                return;
            }
            return;
        }
        ++changes$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testRebalanceAndRejoin$1(AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller1$1, Set expectedAssignment$2) {
        Set<TopicPartition> set = consumerPoller1$1.consumerAssignment();
        return !(set != null ? !set.equals((Object)expectedAssignment$2) : expectedAssignment$2 != null);
    }

    public static final /* synthetic */ String $anonfun$testRebalanceAndRejoin$2(Set expectedAssignment$2) {
        return new StringBuilder(56).append("Timed out while awaiting expected assignment change to ").append(expectedAssignment$2).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testRebalanceAndRejoin$3(AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller1$1) {
        return consumerPoller1$1.consumerAssignment().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testRebalanceAndRejoin$4() {
        return "Timed out while awaiting expected assignment size change to 1.";
    }

    public static final /* synthetic */ boolean $anonfun$testRebalanceAndRejoin$5(AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller2$1) {
        return consumerPoller2$1.consumerAssignment().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testRebalanceAndRejoin$6() {
        return "Timed out while awaiting expected assignment size change to 1.";
    }
}

