/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.api.AbstractConsumerTest;
import kafka.api.PlaintextConsumerFetchTest$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Predef$;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001\u0002\t\u0012\u0001YAQa\u0007\u0001\u0005\u0002qAQA\b\u0001\u0005\u0002}AQ\u0001\u0015\u0001\u0005\u0002ECQa\u0016\u0001\u0005\u0002aCQA\u0018\u0001\u0005\u0002}CQ!\u001a\u0001\u0005\n\u0019DQ\u0001\u001c\u0001\u0005\u00025DQa\u001d\u0001\u0005\nQDQa\u001e\u0001\u0005\u0002aDQA \u0001\u0005\u0002}Dq!a\u0003\u0001\t\u0003\tiaB\u0004\u0002(EA\t!!\u000b\u0007\rA\t\u0002\u0012AA\u0016\u0011\u0019YR\u0002\"\u0001\u00024!1q)\u0004C\u0001\u0003k\u0011!\u0004\u00157bS:$X\r\u001f;D_:\u001cX/\\3s\r\u0016$8\r\u001b+fgRT!AE\n\u0002\u0007\u0005\u0004\u0018NC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aIR\"A\t\n\u0005i\t\"\u0001F!cgR\u0014\u0018m\u0019;D_:\u001cX/\\3s)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011\u0001\u0004A\u0001\u0017i\u0016\u001cHOR3uG\"LeN^1mS\u0012|eMZ:fiR\u0019\u0001EJ\u001a\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006O\t\u0001\r\u0001K\u0001\u0007cV|'/^7\u0011\u0005%\u0002dB\u0001\u0016/!\tY#%D\u0001-\u0015\tiS#\u0001\u0004=e>|GOP\u0005\u0003_\t\na\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011qF\t\u0005\u0006i\t\u0001\r\u0001K\u0001\u000eOJ|W\u000f\u001d)s_R|7m\u001c7)\t\t1D)\u0012\t\u0003o\tk\u0011\u0001\u000f\u0006\u0003si\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003wq\na\u0001]1sC6\u001c(BA\u001f?\u0003\u001dQW\u000f]5uKJT!a\u0010!\u0002\u000b),h.\u001b;\u000b\u0003\u0005\u000b1a\u001c:h\u0013\t\u0019\u0005H\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\rL\u0001GC\u00059\u0015AK4fiR+7\u000f^)v_J,X.\u00118e\u000fJ|W\u000f\u001d)s_R|7m\u001c7QCJ\fW.\u001a;feN\fE\u000e\u001c\u0015\u0005\u0005%ke\n\u0005\u0002K\u00176\t!(\u0003\u0002Mu\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002\u001f\u0006Q3\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?/OJ|W\u000f\u001d)s_R|7m\u001c7>wFj\u0018\u0001\f;fgR4U\r^2i\u001fV$xJ\u001a*b]\u001e,wJ\u001a4tKR\u0014Vm]3u\u0007>tg-[4FCJd\u0017.Z:u)\r\u0001#k\u0015\u0005\u0006O\r\u0001\r\u0001\u000b\u0005\u0006i\r\u0001\r\u0001\u000b\u0015\u0005\u0007Y\"U\u000bL\u0001GQ\u0011\u0019\u0011*\u0014(\u0002UQ,7\u000f\u001e$fi\u000eDw*\u001e;PMJ\u000bgnZ3PM\u001a\u001cX\r\u001e*fg\u0016$8i\u001c8gS\u001ed\u0015\r^3tiR\u0019\u0001%\u0017.\t\u000b\u001d\"\u0001\u0019\u0001\u0015\t\u000bQ\"\u0001\u0019\u0001\u0015)\t\u00111D\t\u0018\u0017\u0002\r\"\"A!S'O\u0003\u0019\"Xm\u001d;GKR\u001c\u0007NU3d_J$G*\u0019:hKJ$\u0006.\u00198GKR\u001c\u0007.T1y\u0005f$Xm\u001d\u000b\u0004A\u0001\f\u0007\"B\u0014\u0006\u0001\u0004A\u0003\"\u0002\u001b\u0006\u0001\u0004A\u0003\u0006B\u00037\t\u000ed\u0013A\u0012\u0015\u0005\u000b%ke*\u0001\tdQ\u0016\u001c7\u000eT1sO\u0016\u0014VmY8sIR\u0011\u0001e\u001a\u0005\u0006Q\u001a\u0001\r![\u0001\u0013aJ|G-^2feJ+7m\u001c:e'&TX\r\u0005\u0002\"U&\u00111N\t\u0002\u0004\u0013:$\u0018A\f;fgR4U\r^2i\u0011>tw.\u001e:t\r\u0016$8\r[*ju\u0016Le\rT1sO\u0016\u0014VmY8sI:{GOR5sgR$2\u0001\t8p\u0011\u00159s\u00011\u0001)\u0011\u0015!t\u00011\u0001)Q\u00119a\u0007R9-\u0003\u0019CCaB%N\u001d\u0006Q3\r[3dW\u001a+Go\u00195I_:|WO]:TSj,\u0017J\u001a'be\u001e,'+Z2pe\u0012tu\u000e\u001e$jeN$HC\u0001\u0011v\u0011\u00151\b\u00021\u0001j\u0003]a\u0017M]4f!J|G-^2feJ+7m\u001c:e'&TX-A\u001euKN$h)\u001a;dQ\"{gn\\;sg6\u000b\u0007\u0010U1si&$\u0018n\u001c8GKR\u001c\u0007NQ=uKNLe\rT1sO\u0016\u0014VmY8sI:{GOR5sgR$2\u0001I={\u0011\u00159\u0013\u00021\u0001)\u0011\u0015!\u0014\u00021\u0001)Q\u0011Ia\u0007\u0012?-\u0003\u0019CC!C%N\u001d\u0006yC/Z:u\r\u0016$8\r\u001b*fG>\u0014H\rT1sO\u0016\u0014H\u000b[1o\u001b\u0006D\b+\u0019:uSRLwN\u001c$fi\u000eD')\u001f;fgR)\u0001%!\u0001\u0002\u0004!)qE\u0003a\u0001Q!)AG\u0003a\u0001Q!*!B\u000e#\u0002\b1\na\t\u000b\u0003\u000b\u00136s\u0015!\u000b;fgRdun^'bq\u001a+Go\u00195TSj,gi\u001c:SKF,Xm\u001d;B]\u0012\u0004\u0016M\u001d;ji&|g\u000eF\u0003!\u0003\u001f\t\t\u0002C\u0003(\u0017\u0001\u0007\u0001\u0006C\u00035\u0017\u0001\u0007\u0001\u0006K\u0003\fm\u0011\u000b)\u0002L\u0001GQ\u0011Y\u0011*\u0014()\r\u0001\tY\u0002RA\u0013!\u0011\ti\"!\t\u000e\u0005\u0005}!B\u0001\n=\u0013\u0011\t\u0019#a\b\u0003\u000fQKW.Z8viz\u0011!\u0001W\u0001\u001b!2\f\u0017N\u001c;fqR\u001cuN\\:v[\u0016\u0014h)\u001a;dQR+7\u000f\u001e\t\u000315\u00192!DA\u0017!\r\t\u0013qF\u0005\u0004\u0003c\u0011#AB!osJ+g\r\u0006\u0002\u0002*U\u0011\u0011q\u0007\t\u0007\u0003s\t9%a\u0013\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\taa\u001d;sK\u0006l'\u0002BA!\u0003\u0007\nA!\u001e;jY*\u0011\u0011QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0005m\"AB*ue\u0016\fW\u000eE\u00028\u0003\u001bJ1!a\u00149\u0005%\t%oZ;nK:$8\u000f")
public class PlaintextConsumerFetchTest
extends AbstractConsumerTest {
    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersAll() {
        return PlaintextConsumerFetchTest$.MODULE$.getTestQuorumAndGroupProtocolParametersAll();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchInvalidOffset(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        Properties x$1 = this.consumerConfig();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
        int totalRecords = 2;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, totalRecords, this.tp(), this.sendRecords$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertThrows(NoOffsetForPartitionException.class, () -> consumer.poll(Duration.ofMillis(15000L)));
        int outOfRangePos = totalRecords + 1;
        consumer.seek(this.tp(), (long)outOfRangePos);
        Map outOfRangePartitions = ((OffsetOutOfRangeException)Assertions.assertThrows(OffsetOutOfRangeException.class, () -> consumer.poll(Duration.ofMillis(20000L)))).offsetOutOfRangePartitions();
        Assertions.assertNotNull((Object)outOfRangePartitions);
        Assertions.assertEquals((int)1, (int)outOfRangePartitions.size());
        Assertions.assertEquals((long)outOfRangePos, (Long)((Long)outOfRangePartitions.get(this.tp())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchOutOfRangeOffsetResetConfigEarliest(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        Properties x$1 = this.consumerConfig();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
        long totalRecords = 10L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int startingTimestamp = 0;
        this.sendRecords(producer, (int)totalRecords, this.tp(), startingTimestamp);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeAndVerifyRecords(consumer, (int)totalRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        long outOfRangePos = totalRecords + 1L;
        consumer.seek(this.tp(), outOfRangePos);
        this.consumeAndVerifyRecords(consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchOutOfRangeOffsetResetConfigLatest(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("auto.offset.reset", "latest");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        Properties x$1 = this.consumerConfig();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
        long totalRecords = 10L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int startingTimestamp = 0;
        this.sendRecords(producer, (int)totalRecords, this.tp(), startingTimestamp);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        this.consumeAndVerifyRecords(consumer, (int)totalRecords / 2, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        long outOfRangePos = totalRecords + 17L;
        consumer.seek(this.tp(), outOfRangePos);
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        this.sendRecords(producer, (int)totalRecords, this.tp(), totalRecords);
        ConsumerRecord nextRecord = (ConsumerRecord)consumer.poll(Duration.ofMillis(50L)).iterator().next();
        Assertions.assertEquals((long)totalRecords, (long)nextRecord.offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchRecordLargerThanFetchMaxBytes(String quorum, String groupProtocol) {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", Integer.toString(maxFetchBytes));
        this.checkLargeRecord(maxFetchBytes + 1);
    }

    private void checkLargeRecord(int producerRecordSize) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[producerRecordSize]);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(record);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = consumer.poll(Duration.ofMillis(20000L));
        Assertions.assertEquals((int)1, (int)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assertions.assertEquals((long)0L, (long)consumerRecord.offset());
        Assertions.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assertions.assertEquals((int)this.tp().partition(), (int)consumerRecord.partition());
        Assertions.assertArrayEquals((byte[])((byte[])record.key()), (byte[])((byte[])consumerRecord.key()));
        Assertions.assertArrayEquals((byte[])((byte[])record.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchHonoursFetchSizeIfLargeRecordNotFirst(String quorum, String groupProtocol) {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", Integer.toString(maxFetchBytes));
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxFetchBytes);
    }

    private void checkFetchHonoursSizeIfLargeRecordNotFirst(int largeProducerRecordSize) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord smallRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"small".getBytes(), (Object)"value".getBytes());
        ProducerRecord largeRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"large".getBytes(), (Object)new byte[largeProducerRecordSize]);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(smallRecord).get();
        producer.send(largeRecord).get();
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = consumer.poll(Duration.ofMillis(20000L));
        Assertions.assertEquals((int)1, (int)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assertions.assertEquals((long)0L, (long)consumerRecord.offset());
        Assertions.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assertions.assertEquals((int)this.tp().partition(), (int)consumerRecord.partition());
        Assertions.assertArrayEquals((byte[])((byte[])smallRecord.key()), (byte[])((byte[])consumerRecord.key()));
        Assertions.assertArrayEquals((byte[])((byte[])smallRecord.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchHonoursMaxPartitionFetchBytesIfLargeRecordNotFirst(String quorum, String groupProtocol) {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(maxPartitionFetchBytes));
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxPartitionFetchBytes);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchRecordLargerThanMaxPartitionFetchBytes(String quorum, String groupProtocol) {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(maxPartitionFetchBytes));
        this.checkLargeRecord(maxPartitionFetchBytes + 1);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testLowMaxFetchSizeForRequestAndPartition(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("fetch.max.bytes", "500");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", "100");
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(20000));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        int partitionCount = 30;
        .colon.colon topics = new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)));
        topics.foreach((Function1 & Serializable & scala.Serializable)topicName -> this.createTopic((String)topicName, partitionCount, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6()));
        Seq partitions = (Seq)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionCount).map((Function1 & Serializable & scala.Serializable)x$1 -> PlaintextConsumerFetchTest.$anonfun$testLowMaxFetchSizeForRequestAndPartition$3(topic, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)partitions.toSet());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Seq producerRecords = (Seq)partitions.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, partitionCount, (TopicPartition)x$2, this.sendRecords$default$4()), Seq$.MODULE$.canBuildFrom());
        ArrayBuffer consumerRecords = this.consumeRecords(consumer, producerRecords.size(), this.consumeRecords$default$3());
        Set expected = ((TraversableOnce)producerRecords.map((Function1 & Serializable & scala.Serializable)record -> new Tuple5((Object)record.topic(), (Object)record.partition(), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)record.timestamp()), Seq$.MODULE$.canBuildFrom())).toSet();
        Set actual = ((TraversableOnce)consumerRecords.map((Function1 & Serializable & scala.Serializable)record -> new Tuple5((Object)record.topic(), (Object)BoxesRunTime.boxToInteger((int)record.partition()), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)BoxesRunTime.boxToLong((long)record.timestamp())), ArrayBuffer$.MODULE$.canBuildFrom())).toSet();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testLowMaxFetchSizeForRequestAndPartition$3(String topic$1, int x$1) {
        return new TopicPartition(topic$1, x$1);
    }
}

