/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest;
import kafka.server.KafkaBroker;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockProducerInterceptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0001\rEf\u0001B\u001a5\u0001eBQA\u0010\u0001\u0005\u0002}BQ!\u0011\u0001\u0005\u0002\t3qa\u001d\u0001\u0011\u0002\u0007\u0005A\u000fC\u0004\u0002\u001e\r!\t!a\b\t\u0013\u0005\u00052\u00011A\u0005\u0002\u0005\r\u0002\"CA\u0016\u0007\u0001\u0007I\u0011AA\u0017\u0011\u001d\t\u0019d\u0001C!\u0003kAq!a\u0014\u0004\t\u0003\n\t\u0006C\u0004\u0002\u0006\u000e!\t%a\b\t\u000f\u0005M2\u0001\"\u0011\u0002\b\u001aI\u0011Q\u0012\u0001\u0011\u0002\u0007\u0005\u0011q\u0012\u0005\b\u0003;YA\u0011AA\u0010\u0011%\t9j\u0003a\u0001\n\u0003\tI\nC\u0005\u0002\".\u0001\r\u0011\"\u0001\u0002$\"9\u0011qU\u0006\u0005B\u0005%\u0006bBA(\u0017\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003\u000b[A\u0011IA\u0010\u0011\u001d\t9k\u0003C!\u0003\u0003Dq!a2\u0001\t\u0013\tI\rC\u0004\u0002P\u0002!\t!!5\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\"9\u00111\u001e\u0001\u0005\u0002\u00055\bbBA}\u0001\u0011\u0005\u00111 \u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/AqAa\t\u0001\t\u0003\u0011)\u0003C\u0004\u00032\u0001!IAa\r\t\u000f\t-\u0003\u0001\"\u0001\u0003N!9!\u0011\f\u0001\u0005\u0002\tm\u0003b\u0002B4\u0001\u0011\u0005!\u0011\u000e\u0005\b\u0005k\u0002A\u0011\u0001B<\u0011\u001d\u0011\u0019\t\u0001C\u0001\u0005\u000bCqA!%\u0001\t\u0003\u0011\u0019\nC\u0004\u0003 \u0002!\tA!)\t\u000f\t5\u0006\u0001\"\u0001\u00030\"9!1\u0018\u0001\u0005\u0002\tu\u0006b\u0002Be\u0001\u0011\u0005!1\u001a\u0005\b\u0005/\u0004A\u0011\u0001Bm\u0011\u001d\u0011)\u000f\u0001C\u0001\u0005ODqAa=\u0001\t\u0003\u0011)\u0010C\u0004\u0004\u0002\u0001!\taa\u0001\t\u000f\r=\u0001\u0001\"\u0001\u0004\u0012!91Q\u0004\u0001\u0005\u0002\r}\u0001bBB\u0018\u0001\u0011\u00051\u0011\u0007\u0005\b\u0007\u000f\u0002A\u0011AB%\u0011\u001d\u0019)\u0006\u0001C\u0001\u0007/Bqaa\u0019\u0001\t\u0003\u0019)\u0007C\u0004\u0004r\u0001!\taa\u001d\t\u000f\r5\u0005\u0001\"\u0001\u0004\u0010\"91Q\u0014\u0001\u0005\u0002\r}%!\u0006)mC&tG/\u001a=u\u0007>t7/^7feR+7\u000f\u001e\u0006\u0003kY\n1!\u00199j\u0015\u00059\u0014!B6bM.\f7\u0001A\n\u0003\u0001i\u0002\"a\u000f\u001f\u000e\u0003QJ!!\u0010\u001b\u0003!\t\u000b7/Z\"p]N,X.\u001a:UKN$\u0018A\u0002\u001fj]&$h\bF\u0001A!\tY\u0004!A\u0006uKN$\b*Z1eKJ\u001cHcA\"J-B\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n!QK\\5u\u0011\u0015Q%\u00011\u0001L\u0003\u0019\tXo\u001c:v[B\u0011Aj\u0015\b\u0003\u001bF\u0003\"AT#\u000e\u0003=S!\u0001\u0015\u001d\u0002\rq\u0012xn\u001c;?\u0013\t\u0011V)\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u0013aa\u0015;sS:<'B\u0001*F\u0011\u00159&\u00011\u0001L\u000359'o\\;q!J|Go\\2pY\"\"!!W4i!\tQV-D\u0001\\\u0015\taV,\u0001\u0005qe>4\u0018\u000eZ3s\u0015\tqv,\u0001\u0004qCJ\fWn\u001d\u0006\u0003A\u0006\fqA[;qSR,'O\u0003\u0002cG\u0006)!.\u001e8ji*\tA-A\u0002pe\u001eL!AZ.\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003%\f\u0013A[\u0001+O\u0016$H+Z:u#V|'/^7B]\u0012<%o\\;q!J|Go\\2pYB\u000b'/Y7fi\u0016\u00148/\u00117mQ\u0011\u0011A\u000e]9\u0011\u00055tW\"A/\n\u0005=l&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005\u0011\u0018AK>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{::'o\\;q!J|Go\\2pYvZ\u0018' \u0002\u000f'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018*\u001c9m'\r\u0019Q/ \t\u0003mnl\u0011a\u001e\u0006\u0003qf\fA\u0001\\1oO*\t!0\u0001\u0003kCZ\f\u0017B\u0001?x\u0005\u0019y%M[3diB)a0!\u0004\u0002\u00125\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011!D:fe&\fG.\u001b>bi&|gN\u0003\u0003\u0002\u0006\u0005\u001d\u0011AB2p[6|gNC\u00028\u0003\u0013Q1!a\u0003d\u0003\u0019\t\u0007/Y2iK&\u0019\u0011qB@\u0003\u0015M+'/[1mSj,'\u000fE\u0003E\u0003'\t9\"C\u0002\u0002\u0016\u0015\u0013Q!\u0011:sCf\u00042\u0001RA\r\u0013\r\tY\"\u0012\u0002\u0005\u0005f$X-\u0001\u0004%S:LG\u000f\n\u000b\u0002\u0007\u0006Q1/\u001a:jC2L'0\u001a:\u0016\u0005\u0005\u0015\u0002c\u0001@\u0002(%\u0019\u0011\u0011F@\u0003'\tKH/Z!se\u0006L8+\u001a:jC2L'0\u001a:\u0002\u001dM,'/[1mSj,'o\u0018\u0013fcR\u00191)a\f\t\u0013\u0005Eb!!AA\u0002\u0005\u0015\u0012a\u0001=%c\u0005I1/\u001a:jC2L'0\u001a\u000b\t\u0003#\t9$a\u000f\u0002L!1\u0011\u0011H\u0004A\u0002-\u000bQ\u0001^8qS\u000eDq!!\u0010\b\u0001\u0004\ty$A\u0004iK\u0006$WM]:\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007RA!!\u0012\u0002\u0004\u00051\u0001.Z1eKJLA!!\u0013\u0002D\t9\u0001*Z1eKJ\u001c\bbBA'\u000f\u0001\u0007\u0011\u0011C\u0001\u0005I\u0006$\u0018-A\u0005d_:4\u0017nZ;sKR)1)a\u0015\u0002|!9\u0011Q\u000b\u0005A\u0002\u0005]\u0013aB2p]\u001aLwm\u001d\u0019\u0005\u00033\nI\u0007E\u0004\u0002\\\u0005\u00054*!\u001a\u000e\u0005\u0005u#bAA0s\u0006!Q\u000f^5m\u0013\u0011\t\u0019'!\u0018\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002h\u0005%D\u0002\u0001\u0003\r\u0003W\n\u0019&!A\u0001\u0002\u000b\u0005\u0011Q\u000e\u0002\u0004?\u0012\n\u0014\u0003BA8\u0003k\u00022\u0001RA9\u0013\r\t\u0019(\u0012\u0002\b\u001d>$\b.\u001b8h!\r!\u0015qO\u0005\u0004\u0003s*%aA!os\"9\u0011Q\u0010\u0005A\u0002\u0005}\u0014!B5t\u0017\u0016L\bc\u0001#\u0002\u0002&\u0019\u00111Q#\u0003\u000f\t{w\u000e\\3b]\u0006)1\r\\8tKR1\u0011\u0011CAE\u0003\u0017Ca!!\u000f\u000b\u0001\u0004Y\u0005bBA'\u0015\u0001\u0007\u0011\u0011\u0003\u0002\u0011\t\u0016\u001cXM]5bY&TXM]%na2\u001cBaC;\u0002\u0012B)a0a%\u0002\u0012%\u0019\u0011QS@\u0003\u0019\u0011+7/\u001a:jC2L'0\u001a:\u0002\u0019\u0011,7/\u001a:jC2L'0\u001a:\u0016\u0005\u0005m\u0005c\u0001@\u0002\u001e&\u0019\u0011qT@\u0003+\tKH/Z!se\u0006LH)Z:fe&\fG.\u001b>fe\u0006\u0001B-Z:fe&\fG.\u001b>fe~#S-\u001d\u000b\u0004\u0007\u0006\u0015\u0006\"CA\u0019\u001d\u0005\u0005\t\u0019AAN\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0011\u0005E\u00111VAW\u0003_Ca!!\u000f\u0010\u0001\u0004Y\u0005bBA\u001f\u001f\u0001\u0007\u0011q\b\u0005\b\u0003\u001bz\u0001\u0019AA\t)\u0015\u0019\u00151WA`\u0011\u001d\t)\u0006\u0005a\u0001\u0003k\u0003D!a.\u0002<B9\u00111LA1\u0017\u0006e\u0006\u0003BA4\u0003w#A\"!0\u00024\u0006\u0005\t\u0011!B\u0001\u0003[\u00121a\u0018\u00133\u0011\u001d\ti\b\u0005a\u0001\u0003\u007f\"b!!\u0005\u0002D\u0006\u0015\u0007BBA\u001d%\u0001\u00071\nC\u0004\u0002NI\u0001\r!!\u0005\u0002?Q,7\u000f\u001e%fC\u0012,'o]*fe&\fG.\u001b>f\t\u0016\u001cXM]5bY&TX\rF\u0003D\u0003\u0017\fi\r\u0003\u0004\u0002\"M\u0001\r! \u0005\b\u0003/\u001b\u0002\u0019AAI\u0003\u0005\"Xm\u001d;IK\u0006$WM]:TKJL\u0017\r\\5{KJ$Um]3sS\u0006d\u0017N_3s)\u0015\u0019\u00151[Ak\u0011\u0015QE\u00031\u0001L\u0011\u00159F\u00031\u0001LQ\u0015!\u0012lZAmY\u0005I\u0007\u0006\u0002\u000bmaF\f1\u0003^3ti\u0006+Ho\\(gMN,GOU3tKR$RaQAq\u0003GDQAS\u000bA\u0002-CQaV\u000bA\u0002-CS!F-h\u0003Od\u0013!\u001b\u0015\u0005+1\u0004\u0018/\u0001\u000buKN$xI]8va\u000e{gn];naRLwN\u001c\u000b\u0006\u0007\u0006=\u0018\u0011\u001f\u0005\u0006\u0015Z\u0001\ra\u0013\u0005\u0006/Z\u0001\ra\u0013\u0015\u0006-e;\u0017Q\u001f\u0017\u0002S\"\"a\u0003\u001c9r\u0003E!Xm\u001d;QCJ$\u0018\u000e^5p]N4uN\u001d\u000b\u0006\u0007\u0006u\u0018q \u0005\u0006\u0015^\u0001\ra\u0013\u0005\u0006/^\u0001\ra\u0013\u0015\u0006/e;'1\u0001\u0017\u0002S\"\"q\u0003\u001c9r\u0003m!Xm\u001d;QCJ$\u0018\u000e^5p]N4uN]!vi>\u001c%/Z1uKR)1Ia\u0003\u0003\u000e!)!\n\u0007a\u0001\u0017\")q\u000b\u0007a\u0001\u0017\"*\u0001$W4\u0003\u00121\n\u0011\u000e\u000b\u0003\u0019YB\f\u0018!\b;fgR\u0004\u0016M\u001d;ji&|gn\u001d$pe&sg/\u00197jIR{\u0007/[2\u0015\u000b\r\u0013IBa\u0007\t\u000b)K\u0002\u0019A&\t\u000b]K\u0002\u0019A&)\u000beIvMa\b-\u0003%DC!\u00077qc\u0006AA/Z:u'\u0016,7\u000eF\u0003D\u0005O\u0011I\u0003C\u0003K5\u0001\u00071\nC\u0003X5\u0001\u00071\nK\u0003\u001b3\u001e\u0014i\u0003L\u0001jQ\u0011QB\u000e]9\u0002-M,g\u000eZ\"p[B\u0014Xm]:fI6+7o]1hKN$Ra\u0011B\u001b\u0005\u007fAqAa\u000e\u001c\u0001\u0004\u0011I$\u0001\u0006ok6\u0014VmY8sIN\u00042\u0001\u0012B\u001e\u0013\r\u0011i$\u0012\u0002\u0004\u0013:$\bb\u0002B!7\u0001\u0007!1I\u0001\u0003iB\u0004BA!\u0012\u0003H5\u0011\u00111A\u0005\u0005\u0005\u0013\n\u0019A\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u00027Q,7\u000f\u001e)beRLG/[8o!\u0006,8/Z!oIJ+7/^7f)\u0015\u0019%q\nB)\u0011\u0015QE\u00041\u0001L\u0011\u00159F\u00041\u0001LQ\u0015a\u0012l\u001aB+Y\u0005I\u0007\u0006\u0002\u000fmaF\f\u0001\u0003^3ti&sG/\u001a:dKB$xN]:\u0015\u000b\r\u0013iFa\u0018\t\u000b)k\u0002\u0019A&\t\u000b]k\u0002\u0019A&)\u000buIvMa\u0019-\u0003%DC!\b7qc\u0006\tC/Z:u\u0013:$XM]2faR|'o],ji\"<&o\u001c8h\u0017\u0016Lh+\u00197vKR)1Ia\u001b\u0003n!)!J\ba\u0001\u0017\")qK\ba\u0001\u0017\"*a$W4\u0003r1\n\u0011\u000e\u000b\u0003\u001fYB\f\u0018!\t;fgR\u001cuN\\:v[\u0016lUm]:bO\u0016\u001cx+\u001b;i\u0007J,\u0017\r^3US6,G#B\"\u0003z\tm\u0004\"\u0002& \u0001\u0004Y\u0005\"B, \u0001\u0004Y\u0005&B\u0010ZO\n}D&A5)\t}a\u0007/]\u0001%i\u0016\u001cHoQ8ogVlW-T3tg\u0006<Wm],ji\"dunZ!qa\u0016tG\rV5nKR)1Ia\"\u0003\n\")!\n\ta\u0001\u0017\")q\u000b\ta\u0001\u0017\"*\u0001%W4\u0003\u000e2\n\u0011\u000e\u000b\u0003!YB\f\u0018A\u0004;fgRd\u0015n\u001d;U_BL7m\u001d\u000b\u0006\u0007\nU%q\u0013\u0005\u0006\u0015\u0006\u0002\ra\u0013\u0005\u0006/\u0006\u0002\ra\u0013\u0015\u0006Ce;'1\u0014\u0017\u0002S\"\"\u0011\u0005\u001c9r\u0003\u0015\"Xm\u001d;QCV\u001cXm\u0015;bi\u0016tu\u000e\u001e)sKN,'O^3e\u0005f\u0014VMY1mC:\u001cW\rF\u0003D\u0005G\u0013)\u000bC\u0003KE\u0001\u00071\nC\u0003XE\u0001\u00071\nK\u0003#3\u001e\u0014I\u000bL\u0001jQ\u0011\u0011C\u000e]9\u0002_Q,7\u000f\u001e)feB\u000b'\u000f^5uS>tG*Z1e\u001b\u0016$(/[2t\u00072,\u0017M\\+q/&$\bnU;cg\u000e\u0014\u0018NY3\u0015\u000b\r\u0013\tLa-\t\u000b)\u001b\u0003\u0019A&\t\u000b]\u001b\u0003\u0019A&)\u000b\rJvMa.-\u0003%DCa\t7qc\u0006qC/Z:u!\u0016\u0014\b+\u0019:uSRLwN\u001c'bO6+GO]5dg\u000ecW-\u00198Va^KG\u000f[*vEN\u001c'/\u001b2f)\u0015\u0019%q\u0018Ba\u0011\u0015QE\u00051\u0001L\u0011\u00159F\u00051\u0001LQ\u0015!\u0013l\u001aBcY\u0005I\u0007\u0006\u0002\u0013maF\fA\u0006^3tiB+'\u000fU1si&$\u0018n\u001c8MK\u0006$W*\u001a;sS\u000e\u001c8\t\\3b]V\u0003x+\u001b;i\u0003N\u001c\u0018n\u001a8\u0015\u000b\r\u0013iMa4\t\u000b)+\u0003\u0019A&\t\u000b]+\u0003\u0019A&)\u000b\u0015JvMa5-\u0003%DC!\n7qc\u0006YC/Z:u!\u0016\u0014\b+\u0019:uSRLwN\u001c'bO6+GO]5dg\u000ecW-\u00198Va^KG\u000f[!tg&<g\u000eF\u0003D\u00057\u0014i\u000eC\u0003KM\u0001\u00071\nC\u0003XM\u0001\u00071\nK\u0003'3\u001e\u0014\t\u000fL\u0001jQ\u00111C\u000e]9\u0002WQ,7\u000f\u001e)feB\u000b'\u000f^5uS>tG*Y4NKR\u0014\u0018nY:XQ\u0016t'+Z1e\u0007>lW.\u001b;uK\u0012$Ra\u0011Bu\u0005WDQAS\u0014A\u0002-CQaV\u0014A\u0002-CSaJ-h\u0005_d\u0013!\u001b\u0015\u0005O1\u0004\u0018/\u0001\u0018uKN$\u0018+^8uC6+GO]5dg:{Go\u0011:fCR,G-\u00134O_F+x\u000e^1t\u0007>tg-[4ve\u0016$G#B\"\u0003x\ne\b\"\u0002&)\u0001\u0004Y\u0005\"B,)\u0001\u0004Y\u0005&\u0002\u0015ZO\nuH&A5)\t!b\u0007/]\u0001\u001di\u0016\u001cHoQ8ogVl\u0017N\\4XSRDg*\u001e7m\u000fJ|W\u000f]%e)\u0015\u00195QAB\u0004\u0011\u0015Q\u0015\u00061\u0001L\u0011\u00159\u0016\u00061\u0001LQ\u0015I\u0013lZB\u0006Y\u0005I\u0007\u0006B\u0015maF\fq\u0005^3ti:+H\u000e\\$s_V\u0004\u0018\n\u001a(piN+\b\u000f]8si\u0016$\u0017JZ\"p[6LG\u000f^5oOR)1ia\u0005\u0004\u0016!)!J\u000ba\u0001\u0017\")qK\u000ba\u0001\u0017\"*!&W4\u0004\u001a1\n\u0011\u000e\u000b\u0003+YB\f\u0018!\b;fgR\u001cuN\\:v[&twmV5uQ\u0016k\u0007\u000f^=He>,\b/\u00133\u0015\u000b\r\u001b\tca\t\t\u000b)[\u0003\u0019A&\t\u000b][\u0003\u0019A&)\u000b-Jvma\n-\u0005\r%\u0012EAB\u0016\u0003}:W\r\u001e+fgR\fVo\u001c:v[\u0006sGm\u0012:pkB\u0004&o\u001c;pG>d\u0007+\u0019:b[\u0016$XM]:DY\u0006\u001c8/[2He>,\b\u000f\u0015:pi>\u001cw\u000e\\(oYfDCa\u000b7qc\u0006aB/Z:u\u000b6\u0004H/_$s_V\u0004\u0018\n\u001a(piN+\b\u000f]8si\u0016$G#B\"\u00044\rU\u0002\"\u0002&-\u0001\u0004Y\u0005\"B,-\u0001\u0004Y\u0005F\u0002\u0017\u0004:\u001d\u001cy\u0004E\u0002[\u0007wI1a!\u0010\\\u0005%\u00195O^*pkJ\u001cW\r\f\u0002\u0004B\u0005\u001211I\u0001\u0017WJ\fg\r^\u0016lSBDD\u0007\u000f\u0017!G>t7/^7fe\"\"A\u0006\u001c9r\u0003a\"Xm\u001d;Ti\u0006$\u0018nY\"p]N,X.\u001a:EKR,7\r^:OK^\u0004\u0016M\u001d;ji&|gn\u0011:fCR,G-\u00114uKJ\u0014Vm\u001d;beR$RaQB&\u0007\u001bBQAS\u0017A\u0002-CQaV\u0017A\u0002-CS!L-h\u0007#b\u0013!\u001b\u0015\u0005[1\u0004\u0018/\u0001\buKN$XI\u001c3PM\u001a\u001cX\r^:\u0015\u000b\r\u001bIfa\u0017\t\u000b)s\u0003\u0019A&\t\u000b]s\u0003\u0019A&)\u000b9Jvma\u0018-\u0003%DCA\f7qc\u00069B/Z:u\r\u0016$8\r[(gMN,Go\u001d$peRKW.\u001a\u000b\u0006\u0007\u000e\u001d4\u0011\u000e\u0005\u0006\u0015>\u0002\ra\u0013\u0005\u0006/>\u0002\ra\u0013\u0015\u0006_e;7Q\u000e\u0017\u0002S\"\"q\u0006\u001c9r\u0003m!Xm\u001d;Q_NLG/[8o%\u0016\u001c\b/Z2ugRKW.Z8viR)1i!\u001e\u0004x!)!\n\ra\u0001\u0017\")q\u000b\ra\u0001\u0017\"2\u0001ga\u001fh\u0007\u000b\u0003Ba! \u0004\u00026\u00111q\u0010\u0006\u0003k}KAaa!\u0004\u0000\t9A+[7f_V$h$A\b)\u000bAJvm!#-\u0003%DC\u0001\r7qc\u0006QB/Z:u!>\u001c\u0018\u000e^5p]J+7\u000f]3diN<\u0016m[3vaR)1i!%\u0004\u0014\")!*\ra\u0001\u0017\")q+\ra\u0001\u0017\"2\u0011ga\u001fh\u0007\u000bCS!M-h\u00073c\u0013!\u001b\u0015\u0005c1\u0004\u0018/A\u0017uKN$\bk\\:ji&|gnV5uQ\u0016\u0013(o\u001c:D_:tWm\u0019;j_:\u0014Vm\u001d9fGR\u001cx+Y6fkB$RaQBQ\u0007GCQA\u0013\u001aA\u0002-CQa\u0016\u001aA\u0002-CcAMB>O\u000e\u0015\u0005&\u0002\u001aZO\u000e%F&A5)\tIb\u0007/\u001d\u0015\u0007\u0001\rmtma,\u001f\u0005\tA\u0006")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testHeaders(String quorum, String groupProtocol) {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        record.headers().add("headerKey", "headerValue".getBytes());
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(record);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Header header = ((ConsumerRecord)records.apply(i)).headers().lastHeader("headerKey");
            Assertions.assertEquals((Object)"headerValue", (Object)(header == null ? null : new String(header.value())));
        });
    }

    private void testHeadersSerializeDeserialize(Serializer<byte[]> serializer, Deserializer<byte[]> deserializer) {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.createProducer(new ByteArraySerializer(), serializer, this.createProducer$default$3()).send(record);
        Consumer consumer = this.createConsumer(new ByteArrayDeserializer(), deserializer, this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testHeadersSerializerDeserializer(String quorum, String groupProtocol) {
        SerializerImpl extendedSerializer = new SerializerImpl(this){
            private ByteArraySerializer serializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] serialize(String topic, Headers headers, byte[] data) {
                return SerializerImpl.serialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                SerializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                SerializerImpl.close$(this);
            }

            public byte[] serialize(String topic, byte[] data) {
                return SerializerImpl.serialize$(this, topic, data);
            }

            public ByteArraySerializer serializer() {
                return this.serializer;
            }

            public void serializer_$eq(ByteArraySerializer x$1) {
                this.serializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                SerializerImpl.$init$(this);
            }
        };
        Deserializer<byte[]> extendedDeserializer = new Deserializer<byte[]>(this){
            private ByteArrayDeserializer deserializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] deserialize(String topic, Headers headers, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                DeserializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                DeserializerImpl.close$(this);
            }

            public byte[] deserialize(String topic, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, data);
            }

            public Object deserialize(String x$1, Headers x$2, ByteBuffer x$3) {
                return super.deserialize(x$1, x$2, x$3);
            }

            public ByteArrayDeserializer deserializer() {
                return this.deserializer;
            }

            public void deserializer_$eq(ByteArrayDeserializer x$1) {
                this.deserializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                DeserializerImpl.$init$(this);
            }
        };
        this.testHeadersSerializeDeserialize(extendedSerializer, extendedDeserializer);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAutoOffsetReset(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 1, this.tp(), startingTimestamp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$2 = 1;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testGroupConsumption(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 10, this.tp(), startingTimestamp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        int x$2 = 1;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPartitionsFor(String quorum, String groupProtocol) {
        int numParts = 2;
        this.createTopic("part-test", numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        java.util.List parts = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).partitionsFor("part-test");
        Assertions.assertNotNull((Object)parts);
        Assertions.assertEquals((int)2, (int)parts.size());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPartitionsForAutoCreate(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.partitionsFor("non-exist-topic");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testPartitionsForAutoCreate$1(consumer)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$testPartitionsForAutoCreate$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPartitionsForInvalidTopic(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(InvalidTopicException.class, () -> consumer.partitionsFor(";3# ads,{234"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSeek(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int startingTimestamp = 0;
        this.sendRecords(producer, (int)totalRecords, this.tp(), startingTimestamp);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seekToEnd((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp()));
        int x$2 = 1;
        int x$3 = 0;
        long x$4 = startingTimestamp;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, x$2, x$3, x$5, x$4, x$6, x$7, x$8);
        consumer.seek(this.tp(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords(consumer, 1, (int)mid, (int)mid, mid, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        consumer.seekToEnd((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp2()));
        int x$10 = 1;
        int x$11 = 0;
        TopicPartition x$12 = this.tp2();
        int x$13 = this.consumeAndVerifyRecords$default$4();
        long x$14 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, x$10, x$11, x$13, x$14, x$15, x$12, x$16);
        consumer.seek(this.tp2(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        int x$18 = 1;
        int x$19 = (int)mid;
        int x$20 = (int)mid;
        TopicPartition x$22 = this.tp2();
        TimestampType x$23 = this.consumeAndVerifyRecords$default$6();
        int x$24 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, x$18, x$19, x$20, mid, x$23, x$22, x$24);
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", Integer.toString(Integer.MAX_VALUE));
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, producerProps);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes())));
        producer.close();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPartitionPauseAndResume(String quorum, String groupProtocol) {
        java.util.List partitions = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)partitions);
        int x$2 = 5;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
        consumer.pause((Collection)partitions);
        startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(100L)).isEmpty());
        consumer.resume((Collection)partitions);
        int x$10 = 5;
        int x$11 = 5;
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, x$10, x$11, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testInterceptors(String quorum, String groupProtocol) {
        String appendStr = "mock";
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
        Properties producerProps = new Properties();
        producerProps.put("interceptor.classes", MockProducerInterceptor.class.getName());
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), producerProps);
        int numRecords = 10;
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString())), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> (RecordMetadata)x$1.get());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ONSEND_COUNT.intValue());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ON_SUCCESS_COUNT.intValue());
        Assertions.assertThrows(Throwable.class, () -> testProducer.send(null), () -> "Should not allow sending a null record");
        Assertions.assertEquals((int)1, (int)MockProducerInterceptor.ON_ERROR_COUNT.intValue(), (String)"Interceptor should be notified about exception");
        Assertions.assertEquals((int)0, (int)MockProducerInterceptor.ON_ERROR_WITH_METADATA_COUNT.intValue(), (String)"Interceptor should not receive metadata with an exception when record is null");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        Consumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        testConsumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(testConsumer, numRecords, this.consumeRecords$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            Assertions.assertEquals((Object)new StringBuilder(4).append("key ").append(i).toString(), (Object)new String((String)record.key()));
            Assertions.assertEquals((Object)new StringBuilder(6).append("value ").append(i).append(appendStr).toString().toUpperCase(Locale.ROOT), (Object)new String((String)record.value()));
        });
        int commitCountBefore = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(2L))}))).asJava());
        Assertions.assertEquals((long)2L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 1), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        this.sendAndAwaitAsyncCommit(testConsumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata(5L))}))));
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 2), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        testConsumer.close();
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testInterceptorsWithWrongKeyValue(String quorum, String groupProtocol) {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)"value will not be modified".getBytes()));
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        Consumer testConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        testConsumer.seek(this.tp(), 0L);
        ConsumerRecord record = (ConsumerRecord)this.consumeRecords(testConsumer, 1, this.consumeRecords$default$3()).head();
        Assertions.assertEquals((Object)"value will not be modified", (Object)new String((byte[])record.value()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumeMessagesWithCreateTime(String quorum, String groupProtocol) {
        int numRecords = 50;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
        this.sendCompressedMessages(numRecords, this.tp2());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        TopicPartition x$11 = this.tp2();
        int x$12 = 0;
        int x$13 = this.consumeAndVerifyRecords$default$4();
        long x$14 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, x$12, x$13, x$14, x$15, x$11, x$16);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumeMessagesWithLogAppendTime(String quorum, String groupProtocol) {
        String topicName = "testConsumeMessagesWithLogAppendTime";
        Properties topicProps = new Properties();
        topicProps.setProperty("message.timestamp.type", "LogAppendTime");
        this.createTopic(topicName, 2, 2, topicProps, this.createTopic$default$5(), this.createTopic$default$6());
        long startTime = System.currentTimeMillis();
        int numRecords = 50;
        TopicPartition tp1 = new TopicPartition(topicName, 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, tp1, this.sendRecords$default$4());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp1, (List)Nil$.MODULE$)).asJava());
        int x$4 = 0;
        TimestampType x$6 = TimestampType.LOG_APPEND_TIME;
        int x$7 = this.consumeAndVerifyRecords$default$4();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, x$4, x$7, startTime, x$6, tp1, x$8);
        TopicPartition tp2 = new TopicPartition(topicName, 1);
        this.sendCompressedMessages(numRecords, tp2);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        int x$12 = 0;
        TimestampType x$14 = TimestampType.LOG_APPEND_TIME;
        int x$15 = this.consumeAndVerifyRecords$default$4();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, x$12, x$15, startTime, x$14, tp2, x$16);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testListTopics(String quorum, String groupProtocol) {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        this.createTopic(topic1, numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topic2, numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topic3, numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        java.util.Map topics = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).listTopics();
        Assertions.assertNotNull((Object)topics);
        Assertions.assertEquals((int)5, (int)topics.size());
        Assertions.assertEquals((int)5, (int)topics.keySet().size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic1)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic2)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic3)).size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPauseStateNotPreservedByRebalance(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        int x$2 = 5;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
        consumer.pause((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"topic2", (List)Nil$.MODULE$)).asJava());
        int x$10 = 0;
        int x$11 = 5;
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, x$10, x$11, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLeadMetricsCleanUpWithSubscribe(String quorum, String groupProtocol) {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLead0 = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLead0);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead0.metricValue(), (String)new StringBuilder(19).append("The lead should be ").append(records.count()).toString());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLagMetricsCleanUpWithSubscribe(String quorum, String groupProtocol) {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLag0 = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLag0);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag0.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(expectedLag).toString());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLeadMetricsCleanUpWithAssign(String quorum, String groupProtocol) {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLead);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead.metricValue(), (String)new StringBuilder(19).append("The lead should be ").append(records.count()).toString());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords(consumer, this.tp2(), this.awaitNonEmptyRecords$default$3());
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLagMetricsCleanUpWithAssign(String quorum, String groupProtocol) {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLag);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(expectedLag).toString());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords(consumer, this.tp2(), this.awaitNonEmptyRecords$default$3());
        Assertions.assertNull(consumer.metrics().get(new MetricName(new StringBuilder(12).append(this.tp().toString()).append(".records-lag").toString(), "consumer-fetch-manager-metrics", "", tags)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLagMetricsWhenReadCommitted(String quorum, String groupProtocol) {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("isolation.level", "read_committed");
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Assertions.assertNotNull((Object)((Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testQuotaMetricsNotCreatedIfNoQuotasConfigured(String quorum, String groupProtocol) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        int x$32 = 0;
        int x$52 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$62 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$72 = this.consumeAndVerifyRecords$default$7();
        int x$82 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, x$32, x$52, startingTimestamp, x$62, x$72, x$82);
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$2, "byte-rate", (QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$3, "throttle-time", (QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$4, "byte-rate", (QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$5, "throttle-time", (QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$6, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$7, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$8, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$9, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumingWithNullGroupId(String quorum, String groupProtocol) {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k3".getBytes(), (Object)"v3".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("auto.offset.reset", "earliest");
        consumer1Config.put("client.id", "consumer1");
        .colon.colon x$2 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        Consumer consumer1 = this.createConsumer(x$3, x$4, consumer1Config, (List<String>)x$2);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("client.id", "consumer2");
        .colon.colon x$6 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$7 = this.createConsumer$default$1();
        ByteArrayDeserializer x$8 = this.createConsumer$default$2();
        Consumer consumer2 = this.createConsumer(x$7, x$8, consumer2Config, (List<String>)x$6);
        Properties consumer3Config = new Properties(this.consumerConfig());
        consumer3Config.put("client.id", "consumer3");
        .colon.colon x$10 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$11 = this.createConsumer$default$1();
        ByteArrayDeserializer x$12 = this.createConsumer$default$2();
        Consumer consumer3 = this.createConsumer(x$11, x$12, consumer3Config, (List<String>)x$10);
        consumer1.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer2.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer3.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer3.seek(tp, 1L);
        int numRecords1 = consumer1.poll(Duration.ofMillis(5000L)).count();
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer1.commitSync());
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer2.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()));
        int numRecords2 = consumer2.poll(Duration.ofMillis(5000L)).count();
        int numRecords3 = consumer3.poll(Duration.ofMillis(5000L)).count();
        consumer1.unsubscribe();
        consumer2.unsubscribe();
        consumer3.unsubscribe();
        consumer1.close();
        consumer2.close();
        consumer3.close();
        Assertions.assertEquals((int)3, (int)numRecords1, (String)"Expected consumer1 to consume from earliest offset");
        Assertions.assertEquals((int)0, (int)numRecords2, (String)"Expected consumer2 to consume from latest offset");
        Assertions.assertEquals((int)2, (int)numRecords3, (String)"Expected consumer3 to consume from offset 1");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testNullGroupIdNotSupportedIfCommitting(String quorum, String groupProtocol) {
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("auto.offset.reset", "earliest");
        consumer1Config.put("client.id", "consumer1");
        .colon.colon x$2 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        Consumer consumer1 = this.createConsumer(x$3, x$4, consumer1Config, (List<String>)x$2);
        consumer1.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer1.commitSync());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly"})
    public void testConsumingWithEmptyGroupId(String quorum, String groupProtocol) {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("group.id", "");
        consumer1Config.put("client.id", "consumer1");
        consumer1Config.put("max.poll.records", "1");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer1 = this.createConsumer(x$2, x$3, consumer1Config, x$4);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("group.id", "");
        consumer2Config.put("client.id", "consumer2");
        consumer2Config.put("max.poll.records", "1");
        ByteArrayDeserializer x$6 = this.createConsumer$default$1();
        ByteArrayDeserializer x$7 = this.createConsumer$default$2();
        List<String> x$8 = this.createConsumer$default$4();
        Consumer consumer2 = this.createConsumer(x$6, x$7, consumer2Config, x$8);
        consumer1.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer2.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        ConsumerRecords records1 = consumer1.poll(Duration.ofMillis(5000L));
        consumer1.commitSync();
        ConsumerRecords records2 = consumer2.poll(Duration.ofMillis(5000L));
        consumer2.commitSync();
        consumer1.close();
        consumer2.close();
        Assertions.assertTrue((records1.count() == 1 && ((ConsumerRecord)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(records1.records(tp)).asScala()).head()).offset() == 0L ? 1 : 0) != 0, (String)"Expected consumer1 to consume one message from offset 0");
        Assertions.assertTrue((records2.count() == 1 && ((ConsumerRecord)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(records2.records(tp)).asScala()).head()).offset() == 1L ? 1 : 0) != 0, (String)"Expected consumer2 to consume one message from offset 1, which is the committed offset of consumer1");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @CsvSource(value={"kraft+kip848, consumer"})
    public void testEmptyGroupIdNotSupported(String quorum, String groupProtocol) {
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("group.id", "");
        consumer1Config.put("auto.offset.reset", "earliest");
        consumer1Config.put("client.id", "consumer1");
        Assertions.assertThrows(KafkaException.class, () -> {
            ByteArrayDeserializer x$2 = this.createConsumer$default$1();
            ByteArrayDeserializer x$3 = this.createConsumer$default$2();
            List<String> x$4 = this.createConsumer$default$4();
            this.createConsumer(x$2, x$3, consumer1Config, x$4);
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testStaticConsumerDetectsNewPartitionCreatedAfterRestart(String quorum, String groupProtocol) {
        String foo = "foo";
        TopicPartition foo0 = new TopicPartition(foo, 0);
        TopicPartition foo1 = new TopicPartition(foo, 1);
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        admin.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new NewTopic(foo, 1, (short)1), (List)Nil$.MODULE$)).asJava()).all().get();
        Properties consumerConfig = new Properties();
        consumerConfig.put("group.id", "my-group-id");
        consumerConfig.put("group.instance.id", "my-instance-id");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer1 = this.createConsumer(x$2, x$3, consumerConfig, x$4);
        consumer1.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)foo, (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer1, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0}))));
        consumer1.close();
        ByteArrayDeserializer x$6 = this.createConsumer$default$1();
        ByteArrayDeserializer x$7 = this.createConsumer$default$2();
        List<String> x$8 = this.createConsumer$default$4();
        Consumer consumer2 = this.createConsumer(x$6, x$7, consumerConfig, x$8);
        consumer2.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)foo, (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer2, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0}))));
        admin.createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo), (Object)NewPartitions.increaseTo((int)2))}))).asJava()).all().get();
        this.awaitAssignment(consumer2, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0, foo1}))));
        consumer2.close();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testEndOffsets(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        int numRecords = 10000;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> PlaintextConsumerTest.$anonfun$testEndOffsets$1(this, startingTimestamp, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        java.util.Map endOffsets = consumer.endOffsets((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertEquals((long)numRecords, (Long)((Long)endOffsets.get(this.tp())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchOffsetsForTime(String quorum, String groupProtocol) {
        int numPartitions = 2;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        HashMap timestampsToSearch = new HashMap();
        IntRef i = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)part -> {
            TopicPartition tp = new TopicPartition(this.topic(), part);
            this.sendRecords((KafkaProducer<byte[], byte[]>)producer, 100, tp, 0L);
            timestampsToSearch.put(tp, Predef$.MODULE$.long2Long((long)(i$1.elem * 20)));
            ++i$1.elem;
        });
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(IllegalArgumentException.class, () -> consumer.offsetsForTimes(Collections.singletonMap(new TopicPartition(this.topic(), 0), Predef$.MODULE$.long2Long(-1L))));
        java.util.Map timestampOffsets = consumer.offsetsForTimes(timestampsToSearch);
        OffsetAndTimestamp timestampTp0 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(this.topic(), 0));
        Assertions.assertEquals((long)0L, (long)timestampTp0.offset());
        Assertions.assertEquals((long)0L, (long)timestampTp0.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTp0.leaderEpoch());
        OffsetAndTimestamp timestampTp1 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(this.topic(), 1));
        Assertions.assertEquals((long)20L, (long)timestampTp1.offset());
        Assertions.assertEquals((long)20L, (long)timestampTp1.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTp1.leaderEpoch());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    @Timeout(value=15L)
    public void testPositionRespectsTimeout(String quorum, String groupProtocol) {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        Assertions.assertThrows(TimeoutException.class, () -> consumer.position(topicPartition, Duration.ofSeconds(3L)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    @Timeout(value=15L)
    public void testPositionRespectsWakeup(String quorum, String groupProtocol) {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        CompletableFuture.runAsync(() -> {
            TimeUnit.SECONDS.sleep(1L);
            consumer.wakeup();
        });
        Assertions.assertThrows(WakeupException.class, () -> consumer.position(topicPartition, Duration.ofSeconds(3L)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    @Timeout(value=15L)
    public void testPositionWithErrorConnectionRespectsWakeup(String quorum, String groupProtocol) {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        Properties properties = new Properties();
        properties.put("bootstrap.servers", "localhost:12345");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, properties, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        CompletableFuture.runAsync(() -> {
            TimeUnit.SECONDS.sleep(1L);
            consumer.wakeup();
        });
        Assertions.assertThrows(WakeupException.class, () -> consumer.position(topicPartition, Duration.ofSeconds(100L)));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionsForAutoCreate$1(Consumer consumer$1) {
        return !consumer$1.partitionsFor("non-exist-topic").isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testPartitionsForAutoCreate$2() {
        return "Timed out while awaiting non empty partitions.";
    }

    private static final void assertNoMetric$1(KafkaBroker broker, String name, QuotaType quotaType, String clientId) {
        MetricName metricName = broker.metrics().metricName("throttle-time", quotaType.toString(), "", new String[]{"user", "", "client-id", clientId});
        Assertions.assertNull((Object)broker.metrics().metric(metricName), (String)new StringBuilder(36).append("Metric should not have been created ").append(metricName).toString());
    }

    public static final /* synthetic */ ProducerRecord $anonfun$testEndOffsets$1(PlaintextConsumerTest $this, long startingTimestamp$1, KafkaProducer producer$2, int i) {
        long timestamp = startingTimestamp$1 + (long)i;
        ProducerRecord record = new ProducerRecord($this.tp().topic(), Predef$.MODULE$.int2Integer($this.tp().partition()), Predef$.MODULE$.long2Long(timestamp), (Object)new StringBuilder(4).append("key ").append(i).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(i).toString().getBytes());
        producer$2.send(record);
        return record;
    }

    public interface DeserializerImpl
    extends Deserializer<byte[]> {
        public ByteArrayDeserializer deserializer();

        public void deserializer_$eq(ByteArrayDeserializer var1);

        public static /* synthetic */ byte[] deserialize$(DeserializerImpl $this, String topic, Headers headers, byte[] data) {
            return $this.deserialize(topic, headers, data);
        }

        default public byte[] deserialize(String topic, Headers headers, byte[] data) {
            Header header = headers.lastHeader("content-type");
            Assertions.assertEquals((Object)"application/octet-stream", (Object)(header == null ? null : new String(header.value())));
            return this.deserializer().deserialize(topic, data);
        }

        public static /* synthetic */ void configure$(DeserializerImpl $this, java.util.Map configs, boolean isKey) {
            $this.configure(configs, isKey);
        }

        default public void configure(java.util.Map<String, ?> configs, boolean isKey) {
            this.deserializer().configure(configs, isKey);
        }

        public static /* synthetic */ void close$(DeserializerImpl $this) {
            $this.close();
        }

        default public void close() {
            this.deserializer().close();
        }

        public static /* synthetic */ byte[] deserialize$(DeserializerImpl $this, String topic, byte[] data) {
            return $this.deserialize(topic, data);
        }

        default public byte[] deserialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer();

        public static void $init$(DeserializerImpl $this) {
            $this.deserializer_$eq(new ByteArrayDeserializer());
        }
    }

    public interface SerializerImpl
    extends Serializer<byte[]> {
        public ByteArraySerializer serializer();

        public void serializer_$eq(ByteArraySerializer var1);

        public static /* synthetic */ byte[] serialize$(SerializerImpl $this, String topic, Headers headers, byte[] data) {
            return $this.serialize(topic, headers, data);
        }

        default public byte[] serialize(String topic, Headers headers, byte[] data) {
            headers.add("content-type", "application/octet-stream".getBytes());
            return this.serializer().serialize(topic, data);
        }

        public static /* synthetic */ void configure$(SerializerImpl $this, java.util.Map configs, boolean isKey) {
            $this.configure(configs, isKey);
        }

        default public void configure(java.util.Map<String, ?> configs, boolean isKey) {
            this.serializer().configure(configs, isKey);
        }

        public static /* synthetic */ void close$(SerializerImpl $this) {
            $this.close();
        }

        default public void close() {
            this.serializer().close();
        }

        public static /* synthetic */ byte[] serialize$(SerializerImpl $this, String topic, byte[] data) {
            return $this.serialize(topic, data);
        }

        default public byte[] serialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer();

        public static void $init$(SerializerImpl $this) {
            $this.serializer_$eq(new ByteArraySerializer());
        }
    }
}

