/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.BaseProducerSendTest;
import kafka.api.PlaintextProducerSendTest$;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.BufferExhaustedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uAQa\b\u0001\u0005\u0002\u0001BQA\u0014\u0001\u0005\u0002=CQ\u0001\u0016\u0001\u0005\u0002UCQA\u001e\u0001\u0005\u0002]DQ\u0001 \u0001\u0005\u0002uDq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0003C\u0002A\u0011AA2\u000f\u001d\tiG\u0005E\u0001\u0003_2a!\u0005\n\t\u0002\u0005E\u0004B\u0002\u000f\u000f\t\u0003\tI\bC\u0004\u000229!\t!a\u001f\u00033Ac\u0017-\u001b8uKb$\bK]8ek\u000e,'oU3oIR+7\u000f\u001e\u0006\u0003'Q\t1!\u00199j\u0015\u0005)\u0012!B6bM.\f7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000e\u000e\u0003II!a\u0007\n\u0003)\t\u000b7/\u001a)s_\u0012,8-\u001a:TK:$G+Z:u\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002\u001a\u0001\u0005\u0019B/Z:u/J|gnZ*fe&\fG.\u001b>feR\u0011\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0005+:LG\u000fC\u0003)\u0005\u0001\u0007\u0011&\u0001\u0004rk>\u0014X/\u001c\t\u0003UEr!aK\u0018\u0011\u00051\u001aS\"A\u0017\u000b\u000592\u0012A\u0002\u001fs_>$h(\u0003\u00021G\u00051\u0001K]3eK\u001aL!AM\u001a\u0003\rM#(/\u001b8h\u0015\t\u00014\u0005\u000b\u0003\u0003k\r#\u0005C\u0001\u001cB\u001b\u00059$B\u0001\u001d:\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001\u001e<\u0003\u0019\u0001\u0018M]1ng*\u0011A(P\u0001\bUV\u0004\u0018\u000e^3s\u0015\tqt(A\u0003kk:LGOC\u0001A\u0003\ry'oZ\u0005\u0003\u0005^\u00121BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHFA#HC\u00051\u0015A\u0001>lC\u0005A\u0015!B6sC\u001a$\bF\u0001\u0002K!\tYE*D\u0001:\u0013\ti\u0015HA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f\u0011\u0003^3ti\n\u000bGo\u00195TSj,',\u001a:p)\t\t\u0003\u000bC\u0003)\u0007\u0001\u0007\u0011\u0006\u000b\u0003\u0004k\r\u0013FFA#HQ\t\u0019!*A\u0014uKN$()\u0019;dQNK'0\u001a.fe>tu\u000eU1si&$\u0018n\u001c8O_J+7m\u001c:e\u0017\u0016LHCA\u0011W\u0011\u0015AC\u00011\u0001*Q\u0011!Qg\u0011--\u0005\u0015;\u0005F\u0001\u0003KQ!!1\fY1cG:|\u0007C\u0001/_\u001b\u0005i&BA\n<\u0013\tyVLA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0003=\tA!\u001e8ji\u0012\nA-\u0003\u0002fM\u000691+R\"P\u001d\u0012\u001b&BA4i\u0003!!\u0016.\\3V]&$(BA5k\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003W2\fA!\u001e;jY*\tQ.\u0001\u0003kCZ\f\u0017A\u0003;ie\u0016\fG-T8eK\u0012\n\u0001/\u0003\u0002re\u0006y1+\u0012)B%\u0006#Vi\u0018+I%\u0016\u000bEI\u0003\u0002ti\u0006QA\u000b\u001b:fC\u0012lu\u000eZ3\u000b\u0005Ul\u0016a\u0002+j[\u0016|W\u000f^\u0001+i\u0016\u001cHoU3oI\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ2{w-\u00119qK:$G+[7f)\t\t\u0003\u0010C\u0003)\u000b\u0001\u0007\u0011\u0006\u000b\u0003\u0006k\rSHFA#HQ\t)!*A\u0017uKN$8+\u001a8e\u001d>t7i\\7qe\u0016\u001c8/\u001a3NKN\u001c\u0018mZ3XSRDGj\\4BaB,g\u000e\u001a+j[\u0016$\"!\t@\t\u000b!2\u0001\u0019A\u0015)\u000b\u0019)4)!\u0001-\u0005\u0015;\u0005F\u0001\u0004K\u0003M!Xm\u001d;BkR|7I]3bi\u0016$v\u000e]5d)\r\t\u0013\u0011\u0002\u0005\u0006Q\u001d\u0001\r!\u000b\u0015\u0006\u000fU\u001a\u0015Q\u0002\u0017\u0003\u000b\u001eC#a\u0002&\u0002UQ,7\u000f^*f]\u0012<\u0016\u000e\u001e5J]Z\fG.\u001b3CK\u001a|'/Z!oI\u00063G/\u001a:US6,7\u000f^1naR9\u0011%!\u0006\u0002\u0018\u0005m\u0001\"\u0002\u0015\t\u0001\u0004I\u0003BBA\r\u0011\u0001\u0007\u0011&\u0001\fnKN\u001c\u0018mZ3US6,7\u000b^1na\u000e{gNZ5h\u0011\u001d\ti\u0002\u0003a\u0001\u0003?\tqB]3d_J$G+[7fgR\fW\u000e\u001d\t\u0004E\u0005\u0005\u0012bAA\u0012G\t!Aj\u001c8hQ\u0019A\u0011q\u00051\u0002.A\u0019a'!\u000b\n\u0007\u0005-rG\u0001\u0007NKRDw\u000eZ*pkJ\u001cW\r\f\u0002\u00020\u0005\u0012\u0011\u0011G\u0001!cV|'/^7B]\u0012$\u0016.\\3ti\u0006l\u0007oQ8oM&<\u0007K]8wS\u0012,'\u000f\u000b\u0002\t\u0015\u0006aC/Z:u-\u0006d\u0017\u000e\u001a\"fM>\u0014X-\u00118e\u0003\u001a$XM\u001d+j[\u0016\u001cH/Y7qg\u0006#H\u000b\u001b:fg\"|G\u000e\u001a\u000b\bC\u0005e\u00121HA\u001f\u0011\u0015A\u0013\u00021\u0001*\u0011\u0019\tI\"\u0003a\u0001S!9\u0011QD\u0005A\u0002\u0005}\u0001FB\u0005\u0002(\u0001\f\t\u0005\f\u0002\u00020!\u0012\u0011BS\u00011i\u0016\u001cHOV1mS\u0012\u0014UMZ8sK\u0006sG-\u00114uKJ$\u0016.\\3ti\u0006l\u0007o],ji\"Lg\u000e\u00165sKNDw\u000e\u001c3\u0015\u000f\u0005\nI%a\u0013\u0002N!)\u0001F\u0003a\u0001S!1\u0011\u0011\u0004\u0006A\u0002%Bq!!\b\u000b\u0001\u0004\ty\u0002\u000b\u0004\u000b\u0003O\u0001\u0017\u0011\u000b\u0017\u0003\u0003_A#A\u0003&\u0002/Q,7\u000f\u001e(p]\ncwnY6j]\u001e\u0004&o\u001c3vG\u0016\u0014HcA\u0011\u0002Z!)\u0001f\u0003a\u0001S!*1\"N\"\u0002^1\u0012Qi\u0012\u0015\u0003\u0017)\u000ba\u0006^3tiN+g\u000e\u001a*fG>\u0014HMQ1uG\"<\u0016\u000e\u001e5NCb\u0014V-];fgR\u001c\u0016N_3B]\u0012D\u0015n\u001a5feR\u0019\u0011%!\u001a\t\u000b!b\u0001\u0019A\u0015)\u000b1)4)!\u001b-\u0005\u0015;\u0005F\u0001\u0007K\u0003e\u0001F.Y5oi\u0016DH\u000f\u0015:pIV\u001cWM]*f]\u0012$Vm\u001d;\u0011\u0005eq1c\u0001\b\u0002tA\u0019!%!\u001e\n\u0007\u0005]4E\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003_*\"!! \u0011\r\u0005}\u0014QQAE\u001b\t\t\tIC\u0002\u0002\u0004*\faa\u001d;sK\u0006l\u0017\u0002BAD\u0003\u0003\u0013aa\u0015;sK\u0006l\u0007c\u0001\u001c\u0002\f&\u0019\u0011QR\u001c\u0003\u0013\u0005\u0013x-^7f]R\u001c\b")
public class PlaintextProducerSendTest
extends BaseProducerSendTest {
    public static Stream<Arguments> quorumAndTimestampConfigProvider() {
        return PlaintextProducerSendTest$.MODULE$.quorumAndTimestampConfigProvider();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testWrongSerializer(String quorum) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps));
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(SerializationException.class, () -> producer.send(record));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testBatchSizeZero(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerify(producer, this.sendAndVerify$default$2(), this.sendAndVerify$default$3());
    }

    @Timeout(value=15L, unit=TimeUnit.SECONDS, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testBatchSizeZeroNoPartitionNoRecordKey(String quorum) {
        int x$1 = 0;
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        String x$4 = this.createProducer$default$4();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        int numRecords = 10;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$1, x$4, x$5, x$6);){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), this.controllerServers(), 2, TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7(), TestUtils$.MODULE$.createTopicWithAdmin$default$8());
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1 & Serializable & scala.Serializable)i -> PlaintextProducerSendTest.$anonfun$testBatchSizeZeroNoPartitionNoRecordKey$1(this, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            producer.flush();
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)PlaintextProducerSendTest.$anonfun$testBatchSizeZeroNoPartitionNoRecordKey$2(this, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assertions.assertEquals((int)numRecords, (int)lastOffset);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testSendCompressedMessageWithLogAppendTime(String quorum) {
        String x$1 = "gzip";
        int x$2 = Integer.MAX_VALUE;
        int x$3 = Integer.MAX_VALUE;
        int x$4 = this.createProducer$default$3();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$1, x$5, x$6);
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testSendNonCompressedMessageWithLogAppendTime(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoCreateTopic(String quorum) {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            ProducerRecord record = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assertions.assertEquals((long)0L, (long)((RecordMetadata)producer.send(record).get()).offset(), (String)"Should have offset 0");
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$6());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testSendWithInvalidBeforeAndAfterTimestamp(String quorum, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        long oneMinuteInMs = 3600000L;
        topicProps.setProperty(messageTimeStampConfig, Long.toString(oneMinuteInMs));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = 1;
        int x$6 = 2;
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicProps);
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
        String x$9 = "gzip";
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        try (KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, x$9, x$13, x$14);){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testValidBeforeAndAfterTimestampsAtThreshold(String quorum, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        topicProps.setProperty(messageTimeStampConfig, Long.toString(recordTimestamp));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = 1;
        int x$6 = 2;
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicProps);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        Assertions.assertDoesNotThrow(() -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        producer.close();
        String x$9 = "gzip";
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, x$9, x$13, x$14);
        Assertions.assertDoesNotThrow(() -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        compressedProducer.close();
    }

    @ParameterizedTest
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testValidBeforeAndAfterTimestampsWithinThreshold(String quorum, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        long tenMinutesInMs = 36000000L;
        topicProps.setProperty(messageTimeStampConfig, Long.toString(tenMinutesInMs));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = 1;
        int x$6 = 2;
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicProps);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        Assertions.assertDoesNotThrow(() -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        producer.close();
        String x$9 = "gzip";
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, x$9, x$13, x$14);
        Assertions.assertDoesNotThrow(() -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        compressedProducer.close();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testNonBlockingProducer(String quorum) {
        long x$1 = 0L;
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        String x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$5, x$1, x$6);
        PlaintextProducerSendTest.verifyMetadataNotAvailable$1(this.send$1(producer));
        Future future = this.sendUntilQueued$1(producer);
        this.verifySendSuccess$1(future);
        long x$7 = 0L;
        int x$8 = 15000;
        int x$9 = 1100;
        long x$10 = 1500L;
        int x$11 = this.createProducer$default$2();
        String x$12 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer2 = this.createProducer(x$8, x$11, x$9, x$12, x$7, x$10);
        Future future2 = this.sendUntilQueued$1(producer2);
        PlaintextProducerSendTest.verifyBufferExhausted$1(this.send$1(producer2));
        this.verifySendSuccess$1(future2);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testSendRecordBatchWithMaxRequestSizeAndHigher(String quorum) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer()));
        int keyLengthSize = 1;
        int headerLengthSize = 1;
        int valueLengthSize = 3;
        int overhead = 94 + keyLengthSize + headerLengthSize + valueLengthSize;
        int valueSize = 0x10000C - overhead;
        ProducerRecord record0 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize]);
        Assertions.assertEquals((int)((byte[])record0.value()).length, (int)((RecordMetadata)producer.send(record0).get()).serializedValueSize());
        ProducerRecord record1 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize + 1]);
        Assertions.assertEquals(RecordTooLargeException.class, Assertions.assertThrows(ExecutionException.class, () -> producer.send(record1).get()).getCause().getClass());
    }

    public static final /* synthetic */ Future $anonfun$testBatchSizeZeroNoPartitionNoRecordKey$1(PlaintextProducerSendTest $this, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), null, (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return producer$2.send(record);
    }

    public static final /* synthetic */ int $anonfun$testBatchSizeZeroNoPartitionNoRecordKey$2(PlaintextProducerSendTest $this, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        return offset + 1;
    }

    private final Future send$1(KafkaProducer producer) {
        return producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)new byte[1000]));
    }

    public static final /* synthetic */ boolean $anonfun$testNonBlockingProducer$2(Future future) {
        if (future.isDone()) {
            try {
                future.get();
                return true;
            }
            catch (ExecutionException executionException) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Future sendUntilQueued$1(KafkaProducer producer) {
        void var3_7;
        Tuple2 tuple2;
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Future computeUntilTrue_result;
            if (PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(computeUntilTrue_result = this.send$1(producer))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Future future = (Future)tuple22._1();
        return var3_7;
    }

    private final void verifySendSuccess$1(Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get(30L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)this.topic(), (Object)recordMetadata.topic());
        Assertions.assertEquals((int)0, (int)recordMetadata.partition());
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString());
    }

    private static final void verifyMetadataNotAvailable$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(TimeoutException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    private static final void verifyBufferExhausted$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(BufferExhaustedException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    public static final /* synthetic */ Object $anonfun$testNonBlockingProducer$2$adapted(Future future) {
        return BoxesRunTime.boxToBoolean((boolean)PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(future));
    }
}

