/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.api.FixedPortTestUtils$;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.util.ShutdownableThread;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u000f\u001f\u0001\rBQ\u0001\u000b\u0001\u0005\u0002%Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u00044\u0001\u0001\u0006I!\f\u0005\bi\u0001\u0011\r\u0011\"\u0003-\u0011\u0019)\u0004\u0001)A\u0005[!9a\u0007\u0001b\u0001\n\u0013a\u0003BB\u001c\u0001A\u0003%Q\u0006C\u00049\u0001\t\u0007I\u0011\u0002\u0017\t\re\u0002\u0001\u0015!\u0003.\u0011\u001dQ\u0004A1A\u0005\nmBa\u0001\u0012\u0001!\u0002\u0013a\u0004bB#\u0001\u0005\u0004%Ia\u000f\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\u001f\t\u000f\u001d\u0003!\u0019!C\u0001\u0011\"1q\n\u0001Q\u0001\n%CQ\u0001\u0015\u0001\u0005BECQA\u0018\u0001\u0005R1BQa\u0018\u0001\u0005\u0002\u0001Dq!!\u0006\u0001\t\u0003\t9\u0002C\u0004\u0002\"\u0001!I!a\t\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`!9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0004\"CAG\u0001E\u0005I\u0011BAH\u0011\u001d\t)\u000b\u0001C\u0005\u0003O3a!!.\u0001\t\u0005]\u0006B\u0002\u0015\u001a\t\u0003\t)\rC\u0004\u0002Lf!\t%!4\t\u000f\u0005=\u0017\u0004\"\u0011\u0002N\n1BK]1og\u0006\u001cG/[8og\n{WO\\2f)\u0016\u001cHO\u0003\u0002 A\u0005\u0019\u0011\r]5\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001IA\u0011QEJ\u0007\u0002=%\u0011qE\b\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012A\u000b\t\u0003K\u0001\tAcY8ogVlWMU3d_J$G+[7f_V$X#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\u0007%sG/A\u000bd_:\u001cX/\\3SK\u000e|'\u000f\u001a+j[\u0016|W\u000f\u001e\u0011\u0002%A\u0014x\u000eZ;dKJ\u0014UO\u001a4feNK'0Z\u0001\u0014aJ|G-^2fe\n+hMZ3s'&TX\rI\u0001\u0016g\u0016\u0014h/\u001a:NKN\u001c\u0018mZ3NCb\u0014\u0015\u0010^3t\u0003Y\u0019XM\u001d<fe6+7o]1hK6\u000b\u0007PQ=uKN\u0004\u0013!\u00048v[B\u000b'\u000f^5uS>t7/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u0017=,H\u000f];u)>\u0004\u0018nY\u000b\u0002yA\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0005Y\u0006twMC\u0001B\u0003\u0011Q\u0017M^1\n\u0005\rs$AB*ue&tw-\u0001\u0007pkR\u0004X\u000f\u001e+pa&\u001c\u0007%\u0001\u0006j]B,H\u000fV8qS\u000e\f1\"\u001b8qkR$v\u000e]5dA\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001J!\tQU*D\u0001L\u0015\ta\u0005)\u0001\u0003vi&d\u0017B\u0001(L\u0005)\u0001&o\u001c9feRLWm]\u0001\u0011_Z,'O]5eS:<\u0007K]8qg\u0002\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002%B\u00191K\u0016-\u000e\u0003QS!!V\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002X)\n\u00191+Z9\u0011\u0005ecV\"\u0001.\u000b\u0005m\u0003\u0013AB:feZ,'/\u0003\u0002^5\nY1*\u00194lC\u000e{gNZ5h\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0002\u001fQ,7\u000f^,ji\"<%o\\;q\u0013\u0012$\"!\u00193\u0011\u00059\u0012\u0017BA20\u0005\u0011)f.\u001b;\t\u000b\u0015\u0014\u0002\u0019\u00014\u0002\rE,xN];n!\t9gN\u0004\u0002iYB\u0011\u0011nL\u0007\u0002U*\u00111NI\u0001\u0007yI|w\u000e\u001e \n\u00055|\u0013A\u0002)sK\u0012,g-\u0003\u0002D_*\u0011Qn\f\u0015\u0006%E|\u0018\u0011\u0001\t\u0003evl\u0011a\u001d\u0006\u0003iV\f\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003m^\fa\u0001]1sC6\u001c(B\u0001=z\u0003\u001dQW\u000f]5uKJT!A_>\u0002\u000b),h.\u001b;\u000b\u0003q\f1a\u001c:h\u0013\tq8OA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003\u0007\t9!\t\u0002\u0002\u0006\u0005\u0011!p[\u0011\u0003\u0003\u0013\tQa\u001b:bMRD3AEA\u0007!\u0011\ty!!\u0005\u000e\u0003UL1!a\u0005v\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0016i\u0016\u001cHoV5uQ\u001e\u0013x.\u001e9NKR\fG-\u0019;b)\r\t\u0017\u0011\u0004\u0005\u0006KN\u0001\rA\u001a\u0015\u0006'E|\u0018Q\u0004\u0017\u0005\u0003\u0007\t9\u0001K\u0002\u0014\u0003\u001b\t\u0011\u0003^3ti\n\u0013xn[3s\r\u0006LG.\u001e:f)\r\t\u0017Q\u0005\u0005\b\u0003O!\u0002\u0019AA\u0015\u0003\u0019\u0019w.\\7jiBIa&a\u000b\u00020\u0019\f\t&Y\u0005\u0004\u0003[y#!\u0003$v]\u000e$\u0018n\u001c84!!\t\t$!\u0011\u0002F\u0005\u0015SBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0011A\u0014x\u000eZ;dKJTA!!\u000f\u0002<\u000591\r\\5f]R\u001c(bA\u0011\u0002>)\u0019\u0011qH>\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\u0019%a\r\u0003\u001b-\u000bgm[1Qe>$WoY3s!\u0015q\u0013qIA&\u0013\r\tIe\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004]\u00055\u0013bAA(_\t!!)\u001f;f!!\t\u0019&!\u0017\u0002F\u0005\u0015SBAA+\u0015\u0011\t9&a\u000e\u0002\u0011\r|gn];nKJLA!a\u0017\u0002V\tA1i\u001c8tk6,'/A\u000ede\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM\u001d\u000b\u0005\u0003_\t\t\u0007\u0003\u0004\u0002dU\u0001\rAZ\u0001\u0010iJ\fgn]1di&|g.\u00197JI\u0006Q2M]3bi\u0016\u001cuN\\:v[\u0016\u0014\u0018I\u001c3Tk\n\u001c8M]5cKRA\u0011\u0011KA5\u0003[\n\u0019\t\u0003\u0004\u0002lY\u0001\rAZ\u0001\bOJ|W\u000f]%e\u0011\u001d\tyG\u0006a\u0001\u0003c\na\u0001^8qS\u000e\u001c\b#BA:\u0003{2g\u0002BA;\u0003sr1![A<\u0013\u0005\u0001\u0014bAA>_\u00059\u0001/Y2lC\u001e,\u0017\u0002BA@\u0003\u0003\u0013A\u0001T5ti*\u0019\u00111P\u0018\t\u0013\u0005\u0015e\u0003%AA\u0002\u0005\u001d\u0015!\u0004:fC\u0012\u001cu.\\7jiR,G\rE\u0002/\u0003\u0013K1!a#0\u0005\u001d\u0011un\u001c7fC:\fAe\u0019:fCR,7i\u001c8tk6,'/\u00118e'V\u00147o\u0019:jE\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0003#SC!a\"\u0002\u0014.\u0012\u0011Q\u0013\t\u0005\u0003/\u000b\t+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003%)hn\u00195fG.,GMC\u0002\u0002 >\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019+!'\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0007de\u0016\fG/\u001a+pa&\u001c7\u000f\u0006\u0002\u0002*B1\u00111VAY[5j!!!,\u000b\u0007\u0005=F+A\u0005j[6,H/\u00192mK&!\u00111WAW\u0005\ri\u0015\r\u001d\u0002\u0010\u0005>,hnY3TG\",G-\u001e7feN\u0019\u0011$!/\u0011\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{S1\u0001TA`\u0015\rY\u00161H\u0005\u0005\u0003\u0007\fiL\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$GCAAd!\r\tI-G\u0007\u0002\u0001\u00051Am\\,pe.$\u0012!Y\u0001\tg\",H\u000fZ8x]\u0002")
public class TransactionsBounceTest
extends IntegrationTestHarness {
    private final int consumeRecordTimeout;
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int kafka$api$TransactionsBounceTest$$numPartitions;
    private final String kafka$api$TransactionsBounceTest$$outputTopic;
    private final String inputTopic;
    private final Properties overridingProps = new Properties();

    private int consumeRecordTimeout() {
        return this.consumeRecordTimeout;
    }

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    public int kafka$api$TransactionsBounceTest$$numPartitions() {
        return this.kafka$api$TransactionsBounceTest$$numPartitions;
    }

    public String kafka$api$TransactionsBounceTest$$outputTopic() {
        return this.kafka$api$TransactionsBounceTest$$outputTopic;
    }

    private String inputTopic() {
        return this.inputTopic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnectOrNull(), FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$3(), FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public int brokerCount() {
        return 4;
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testWithGroupId(String quorum) {
        String testBrokerFailure_consumerGroup = "myGroup";
        int testBrokerFailure_numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), testBrokerFailure_numInputRecords, this.brokers());
        Consumer<byte[], byte[]> testBrokerFailure_consumer = this.createConsumerAndSubscribe(testBrokerFailure_consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), this.createConsumerAndSubscribe$default$3());
        KafkaProducer<byte[], byte[]> testBrokerFailure_producer = this.createTransactionalProducer("test-txn");
        testBrokerFailure_producer.initTransactions();
        BounceScheduler testBrokerFailure_scheduler = new BounceScheduler();
        testBrokerFailure_scheduler.start();
        try {
            IntRef testBrokerFailure_numMessagesProcessed = IntRef.create((int)0);
            IntRef testBrokerFailure_iteration = IntRef.create((int)0);
            while (testBrokerFailure_numMessagesProcessed.elem < testBrokerFailure_numInputRecords) {
                int testBrokerFailure_toRead = Math.min(200, testBrokerFailure_numInputRecords - testBrokerFailure_numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> testBrokerFailure_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_consumer, testBrokerFailure_toRead, this.consumeRecordTimeout());
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received ").append(testBrokerFailure_records.size()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString());
                testBrokerFailure_producer.beginTransaction();
                boolean testBrokerFailure_shouldAbort = testBrokerFailure_iteration.elem % 3 == 0;
                testBrokerFailure_records.foreach((Function1 & Serializable & scala.Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.size()).append(" messages. Committing offsets.").toString());
                testBrokerFailure_producer.sendOffsetsToTransaction((Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)testBrokerFailure_consumer)).asJava(), testBrokerFailure_consumerGroup);
                if (testBrokerFailure_shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    testBrokerFailure_producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(testBrokerFailure_consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    testBrokerFailure_producer.commitTransaction();
                    testBrokerFailure_numMessagesProcessed.elem += testBrokerFailure_records.size();
                }
                ++testBrokerFailure_iteration.elem;
            }
        }
        finally {
            testBrokerFailure_scheduler.shutdown();
        }
        Consumer<byte[], byte[]> testBrokerFailure_verifyingConsumer = this.createConsumerAndSubscribe("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap testBrokerFailure_recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_verifyingConsumer, testBrokerFailure_numInputRecords, this.consumeRecordTimeout()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$7(testBrokerFailure_recordsByPartition, record);
            return BoxedUnit.UNIT;
        });
        ListBuffer testBrokerFailure_outputRecords = new ListBuffer();
        testBrokerFailure_recordsByPartition.values().foreach((Function1 & Serializable & scala.Serializable)partitionValues -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$9(testBrokerFailure_outputRecords, partitionValues);
            return BoxedUnit.UNIT;
        });
        Set testBrokerFailure_recordSet = testBrokerFailure_outputRecords.toSet();
        Assertions.assertEquals((int)testBrokerFailure_numInputRecords, (int)testBrokerFailure_recordSet.size());
        Set testBrokerFailure_expectedValues = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), testBrokerFailure_numInputRecords).toSet();
        Assertions.assertEquals((Object)testBrokerFailure_expectedValues, (Object)testBrokerFailure_recordSet, (String)new StringBuilder(18).append("Missing messages: ").append(testBrokerFailure_expectedValues.$minus$minus((GenTraversableOnce)testBrokerFailure_recordSet)).toString());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testWithGroupMetadata(String quorum) {
        String testBrokerFailure_consumerGroup = "myGroup";
        int testBrokerFailure_numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), testBrokerFailure_numInputRecords, this.brokers());
        Consumer<byte[], byte[]> testBrokerFailure_consumer = this.createConsumerAndSubscribe(testBrokerFailure_consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), this.createConsumerAndSubscribe$default$3());
        KafkaProducer<byte[], byte[]> testBrokerFailure_producer = this.createTransactionalProducer("test-txn");
        testBrokerFailure_producer.initTransactions();
        BounceScheduler testBrokerFailure_scheduler = new BounceScheduler();
        testBrokerFailure_scheduler.start();
        try {
            IntRef testBrokerFailure_numMessagesProcessed = IntRef.create((int)0);
            IntRef testBrokerFailure_iteration = IntRef.create((int)0);
            while (testBrokerFailure_numMessagesProcessed.elem < testBrokerFailure_numInputRecords) {
                int testBrokerFailure_toRead = Math.min(200, testBrokerFailure_numInputRecords - testBrokerFailure_numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> testBrokerFailure_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_consumer, testBrokerFailure_toRead, this.consumeRecordTimeout());
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received ").append(testBrokerFailure_records.size()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString());
                testBrokerFailure_producer.beginTransaction();
                boolean testBrokerFailure_shouldAbort = testBrokerFailure_iteration.elem % 3 == 0;
                testBrokerFailure_records.foreach((Function1 & Serializable & scala.Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.size()).append(" messages. Committing offsets.").toString());
                testBrokerFailure_producer.sendOffsetsToTransaction((Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)testBrokerFailure_consumer)).asJava(), testBrokerFailure_consumer.groupMetadata());
                if (testBrokerFailure_shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    testBrokerFailure_producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(testBrokerFailure_consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    testBrokerFailure_producer.commitTransaction();
                    testBrokerFailure_numMessagesProcessed.elem += testBrokerFailure_records.size();
                }
                ++testBrokerFailure_iteration.elem;
            }
        }
        finally {
            testBrokerFailure_scheduler.shutdown();
        }
        Consumer<byte[], byte[]> testBrokerFailure_verifyingConsumer = this.createConsumerAndSubscribe("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap testBrokerFailure_recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_verifyingConsumer, testBrokerFailure_numInputRecords, this.consumeRecordTimeout()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$7(testBrokerFailure_recordsByPartition, record);
            return BoxedUnit.UNIT;
        });
        ListBuffer testBrokerFailure_outputRecords = new ListBuffer();
        testBrokerFailure_recordsByPartition.values().foreach((Function1 & Serializable & scala.Serializable)partitionValues -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$9(testBrokerFailure_outputRecords, partitionValues);
            return BoxedUnit.UNIT;
        });
        Set testBrokerFailure_recordSet = testBrokerFailure_outputRecords.toSet();
        Assertions.assertEquals((int)testBrokerFailure_numInputRecords, (int)testBrokerFailure_recordSet.size());
        Set testBrokerFailure_expectedValues = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), testBrokerFailure_numInputRecords).toSet();
        Assertions.assertEquals((Object)testBrokerFailure_expectedValues, (Object)testBrokerFailure_recordSet, (String)new StringBuilder(18).append("Missing messages: ").append(testBrokerFailure_expectedValues.$minus$minus((GenTraversableOnce)testBrokerFailure_recordSet)).toString());
    }

    private void testBrokerFailure(Function3<KafkaProducer<byte[], byte[]>, String, Consumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroup = "myGroup";
        int numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), numInputRecords, this.brokers());
        Consumer<byte[], byte[]> consumer = this.createConsumerAndSubscribe(consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), this.createConsumerAndSubscribe$default$3());
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("test-txn");
        producer.initTransactions();
        BounceScheduler scheduler = new BounceScheduler();
        scheduler.start();
        try {
            IntRef numMessagesProcessed = IntRef.create((int)0);
            IntRef iteration = IntRef.create((int)0);
            while (numMessagesProcessed.elem < numInputRecords) {
                int toRead = Math.min(200, numInputRecords - numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, toRead, this.consumeRecordTimeout());
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received ").append(testBrokerFailure_records.size()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString());
                producer.beginTransaction();
                boolean shouldAbort = iteration.elem % 3 == 0;
                records.foreach((Function1 & Serializable & scala.Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.size()).append(" messages. Committing offsets.").toString());
                commit.apply(producer, (Object)consumerGroup, consumer);
                if (shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    producer.commitTransaction();
                    numMessagesProcessed.elem += records.size();
                }
                ++iteration.elem;
            }
        }
        finally {
            scheduler.shutdown();
        }
        Consumer<byte[], byte[]> verifyingConsumer = this.createConsumerAndSubscribe("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numInputRecords, this.consumeRecordTimeout()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$7(testBrokerFailure_recordsByPartition, record);
            return BoxedUnit.UNIT;
        });
        ListBuffer outputRecords = new ListBuffer();
        recordsByPartition.values().foreach((Function1 & Serializable & scala.Serializable)partitionValues -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$9(testBrokerFailure_outputRecords, partitionValues);
            return BoxedUnit.UNIT;
        });
        Set recordSet = outputRecords.toSet();
        Assertions.assertEquals((int)numInputRecords, (int)recordSet.size());
        Set expectedValues = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numInputRecords).toSet();
        Assertions.assertEquals((Object)expectedValues, (Object)recordSet, (String)new StringBuilder(18).append("Missing messages: ").append(expectedValues.$minus$minus((GenTraversableOnce)recordSet)).toString());
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId) {
        Properties props = new Properties();
        props.put("acks", "all");
        props.put("batch.size", "512");
        props.put("transactional.id", transactionalId);
        props.put("enable.idempotence", "true");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        return this.createProducer(x$2, x$3, props);
    }

    private Consumer<byte[], byte[]> createConsumerAndSubscribe(String groupId, List<String> topics, boolean readCommitted) {
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", groupId);
        consumerProps.put("enable.auto.commit", "false");
        consumerProps.put("isolation.level", readCommitted ? "read_committed" : "read_uncommitted");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, consumerProps, x$4);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava());
        return consumer;
    }

    private boolean createConsumerAndSubscribe$default$3() {
        return false;
    }

    private scala.collection.immutable.Map<Object, Object> createTopics() {
        Properties topicConfig = new Properties();
        topicConfig.put(ServerLogConfigs.MIN_IN_SYNC_REPLICAS_CONFIG, Integer.toString(2));
        this.createTopic(this.inputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        return this.createTopic(this.kafka$api$TransactionsBounceTest$$outputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
    }

    public static final /* synthetic */ void $anonfun$testBrokerFailure$7(HashMap recordsByPartition$1, ConsumerRecord record) {
        int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record))).toInt();
        TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
        ((BufferLike)recordsByPartition$1.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> new ListBuffer())).append((Seq)Predef$.MODULE$.wrapIntArray(new int[]{value}));
    }

    public static final /* synthetic */ void $anonfun$testBrokerFailure$9(ListBuffer outputRecords$1, ListBuffer partitionValues) {
        Assertions.assertEquals((Object)partitionValues, (Object)partitionValues.sorted((Ordering)Ordering.Int$.MODULE$), (String)"Out of order messages detected");
        outputRecords$1.appendAll((TraversableOnce)partitionValues);
    }

    public TransactionsBounceTest() {
        this.consumeRecordTimeout = 30000;
        this.producerBufferSize = 65536;
        this.kafka$api$TransactionsBounceTest$$numPartitions = 3;
        this.kafka$api$TransactionsBounceTest$$outputTopic = "output-topic";
        this.inputTopic = "input-topic";
        this.overridingProps().put("auto.create.topics.enable", Boolean.toString(false));
        this.overridingProps().put("message.max.bytes", Integer.toString(this.serverMessageMaxBytes()));
        this.overridingProps().put("controlled.shutdown.enable", Boolean.toString(true));
        this.overridingProps().put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, Boolean.toString(false));
        this.overridingProps().put("auto.leader.rebalance.enable", Boolean.toString(false));
        this.overridingProps().put("offsets.topic.num.partitions", Integer.toString(1));
        this.overridingProps().put("offsets.topic.replication.factor", Integer.toString(3));
        this.overridingProps().put(ServerLogConfigs.MIN_IN_SYNC_REPLICAS_CONFIG, Integer.toString(2));
        this.overridingProps().put("group.min.session.timeout.ms", "10");
        this.overridingProps().put("group.initial.rebalance.delay.ms", "0");
        this.overridingProps().put("transaction.state.log.num.partitions", Integer.toString(1));
        this.overridingProps().put("transaction.state.log.replication.factor", Integer.toString(3));
    }

    public static final /* synthetic */ Object $anonfun$testWithGroupId$1$adapted(KafkaProducer producer, String groupId, Consumer consumer) {
        producer.sendOffsetsToTransaction((Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)consumer)).asJava(), groupId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testWithGroupMetadata$1$adapted(KafkaProducer producer, String x$2, Consumer consumer) {
        producer.sendOffsetsToTransaction((Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }

    private class BounceScheduler
    extends ShutdownableThread {
        public void doWork() {
            this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().brokers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                BounceScheduler.$anonfun$doWork$1(this, server);
                return BoxedUnit.UNIT;
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$numPartitions()).foreach((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)partition -> TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().createAdminClient(this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().createAdminClient$default$1(), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().createAdminClient$default$2()), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$outputTopic(), partition, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$6()));
        }

        public void shutdown() {
            super.shutdown();
        }

        public /* synthetic */ TransactionsBounceTest kafka$api$TransactionsBounceTest$BounceScheduler$$$outer() {
            return TransactionsBounceTest.this;
        }

        public static final /* synthetic */ void $anonfun$doWork$1(BounceScheduler $this, KafkaBroker server) {
            $this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Shutting down server : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())})));
            server.shutdown();
            server.awaitShutdown();
            Thread.sleep(500L);
            $this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Server %s shut down. Starting it up again.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())})));
            server.startup();
            $this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Restarted server: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())})));
            Thread.sleep(500L);
        }

        public BounceScheduler() {
            if (TransactionsBounceTest.this == null) {
                throw null;
            }
            super("daemon-broker-bouncer", false);
        }
    }
}

