/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.MetricName;
import java.util.Collections;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000112A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/!)\u0001\u0006\u0001C\u0001/!)!\u0006\u0001C\u0001/\t)2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9UKN$(BA\u0004\t\u0003\u001diW\r\u001e:jGNT\u0011!C\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\u0001\"!\u0006\u0001\u000e\u0003\u0019\ta\u0003^3tiVsG/Y4hK\u0012lU\r\u001e:jG:\u000bW.\u001a\u000b\u00021A\u0011Q\"G\u0005\u000359\u0011A!\u00168ji\"\u0012!\u0001\b\t\u0003;\u0019j\u0011A\b\u0006\u0003?\u0001\n1!\u00199j\u0015\t\t#%A\u0004kkBLG/\u001a:\u000b\u0005\r\"\u0013!\u00026v]&$(\"A\u0013\u0002\u0007=\u0014x-\u0003\u0002(=\t!A+Z:u\u0003Q!Xm\u001d;UC\u001e<W\rZ'fiJL7MT1nK\"\u00121\u0001H\u0001#i\u0016\u001cH\u000fV1hO\u0016$W*\u001a;sS\u000et\u0015-\\3XSRDW)\u001c9usZ\u000bG.^3)\u0005\u0011a\u0002")
public class KafkaMetricsGroupTest {
    @Test
    public void testUntaggedMetricName() {
        MetricName metricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.metrics", (String)"TestMetrics", (String)"TaggedMetric", Collections.emptyMap());
        Assertions.assertEquals((Object)"kafka.metrics", (Object)metricName.getGroup());
        Assertions.assertEquals((Object)"TestMetrics", (Object)metricName.getType());
        Assertions.assertEquals((Object)"TaggedMetric", (Object)metricName.getName());
        Assertions.assertEquals((Object)"kafka.metrics:type=TestMetrics,name=TaggedMetric", (Object)metricName.getMBeanName());
        Assertions.assertNull((Object)metricName.getScope());
    }

    @Test
    public void testTaggedMetricName() {
        java.util.Map tags = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"baz"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"baz"), (Object)"raz.taz")}))).asJava();
        MetricName metricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.metrics", (String)"TestMetrics", (String)"TaggedMetric", (java.util.Map)tags);
        Assertions.assertEquals((Object)"kafka.metrics", (Object)metricName.getGroup());
        Assertions.assertEquals((Object)"TestMetrics", (Object)metricName.getType());
        Assertions.assertEquals((Object)"TaggedMetric", (Object)metricName.getName());
        Assertions.assertEquals((Object)"kafka.metrics:type=TestMetrics,name=TaggedMetric,foo=bar,bar=baz,baz=raz.taz", (Object)metricName.getMBeanName());
        Assertions.assertEquals((Object)"bar.baz.baz.raz_taz.foo.bar", (Object)metricName.getScope());
    }

    @Test
    public void testTaggedMetricNameWithEmptyValue() {
        java.util.Map tags = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"baz"), (Object)"raz.taz")}))).asJava();
        MetricName metricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.metrics", (String)"TestMetrics", (String)"TaggedMetric", (java.util.Map)tags);
        Assertions.assertEquals((Object)"kafka.metrics", (Object)metricName.getGroup());
        Assertions.assertEquals((Object)"TestMetrics", (Object)metricName.getType());
        Assertions.assertEquals((Object)"TaggedMetric", (Object)metricName.getName());
        Assertions.assertEquals((Object)"kafka.metrics:type=TestMetrics,name=TaggedMetric,foo=bar,baz=raz.taz", (Object)metricName.getMBeanName());
        Assertions.assertEquals((Object)"baz.raz_taz.foo.bar", (Object)metricName.getScope());
    }
}

