/*
 * Decompiled with CFR 0.152.
 */
package kafka.migration;

import java.io.Serializable;
import java.util.Collections;
import kafka.cluster.Broker$;
import kafka.migration.MigrationPropagator$;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/!)q\u0006\u0001C\u0001a!)Q\t\u0001C\u0001\r\n9R*[4sCRLwN\u001c)s_B\fw-\u0019;peR+7\u000f\u001e\u0006\u0003\u000f!\t\u0011\"\\5he\u0006$\u0018n\u001c8\u000b\u0003%\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u000b\u0011\u0005U\u0001Q\"\u0001\u0004\u0002\u001b\t\u0014xn[3s\u0005VLG\u000eZ3s)\u0011A2\u0005K\u0017\u0011\u0005e\tS\"\u0001\u000e\u000b\u0005ma\u0012\u0001C7fi\u0006$\u0017\r^1\u000b\u0005%i\"B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001eL!A\t\u000e\u0003%\t\u0013xn[3s%\u0016<\u0017n\u001d;sCRLwN\u001c\u0005\u0006I\t\u0001\r!J\u0001\tEJ|7.\u001a:JIB\u0011QBJ\u0005\u0003O9\u00111!\u00138u\u0011\u0015I#\u00011\u0001+\u0003)I7OW6Ce>\\WM\u001d\t\u0003\u001b-J!\u0001\f\b\u0003\u000f\t{w\u000e\\3b]\")aF\u0001a\u0001U\u0005A\u0011n\u001d$f]\u000e,G-A\u000bce>\\WM]:U_\u000ecWo\u001d;fe&k\u0017mZ3\u0015\u0005E:\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u001d\u0003\u0015IW.Y4f\u0013\t14G\u0001\u0007DYV\u001cH/\u001a:J[\u0006<W\rC\u00039\u0007\u0001\u0007\u0011(A\u0004ce>\\WM]:\u0011\u0007i\u0012\u0005D\u0004\u0002<\u0001:\u0011AhP\u0007\u0002{)\u0011aHC\u0001\u0007yI|w\u000e\u001e \n\u0003=I!!\u0011\b\u0002\u000fA\f7m[1hK&\u00111\t\u0012\u0002\u0004'\u0016\f(BA!\u000f\u0003i!Xm\u001d;DC2\u001cW\u000f\\1uK\n\u0013xn[3s\u0007\"\fgnZ3t)\u00059\u0005CA\u0007I\u0013\tIeB\u0001\u0003V]&$\bF\u0001\u0003L!\ta5+D\u0001N\u0015\tqu*A\u0002ba&T!\u0001U)\u0002\u000f),\b/\u001b;fe*\u0011!kH\u0001\u0006UVt\u0017\u000e^\u0005\u0003)6\u0013A\u0001V3ti\u0002")
public class MigrationPropagatorTest {
    public BrokerRegistration brokerBuilder(int brokerId, boolean isZkBroker, boolean isFenced) {
        return BrokerRegistration.fromRecord((RegisterBrokerRecord)new RegisterBrokerRecord().setBrokerId(brokerId).setIsMigratingZkBroker(isZkBroker).setBrokerEpoch(10L).setFenced(isFenced));
    }

    public ClusterImage brokersToClusterImage(Seq<BrokerRegistration> brokers) {
        java.util.Map brokerMap = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)brokers.map((Function1 & Serializable & scala.Serializable)broker -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker.id()), broker), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        return new ClusterImage(brokerMap, Collections.emptyMap());
    }

    @Test
    public void testCalculateBrokerChanges() {
        BrokerRegistration broker1;
        BrokerRegistration broker0 = this.brokerBuilder(0, true, true);
        Tuple2 tuple2 = MigrationPropagator$.MODULE$.calculateBrokerChanges(ClusterImage.EMPTY, this.brokersToClusterImage((Seq<BrokerRegistration>)new .colon.colon((Object)broker0, (List)new .colon.colon((Object)(broker1 = this.brokerBuilder(1, true, false)), (List)Nil$.MODULE$))));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Set addedBrokers = (Set)tuple2._1();
        Set removedBrokers = (Set)tuple2._2();
        Assertions.assertFalse((boolean)addedBrokers.contains((Object)Broker$.MODULE$.fromBrokerRegistration(broker0)));
        Assertions.assertTrue((boolean)addedBrokers.contains((Object)Broker$.MODULE$.fromBrokerRegistration(broker1)));
        Assertions.assertTrue((boolean)removedBrokers.isEmpty());
        ClusterImage prevImage = this.brokersToClusterImage((Seq<BrokerRegistration>)new .colon.colon((Object)broker0, (List)new .colon.colon((Object)broker1, (List)Nil$.MODULE$)));
        broker0 = this.brokerBuilder(0, true, false);
        broker1 = this.brokerBuilder(1, true, false);
        Tuple2 tuple22 = MigrationPropagator$.MODULE$.calculateBrokerChanges(prevImage, this.brokersToClusterImage((Seq<BrokerRegistration>)new .colon.colon((Object)broker0, (List)new .colon.colon((Object)broker1, (List)Nil$.MODULE$))));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Set addedBrokers2 = (Set)tuple22._1();
        Set removedBrokers2 = (Set)tuple22._2();
        Assertions.assertTrue((boolean)addedBrokers2.contains((Object)Broker$.MODULE$.fromBrokerRegistration(broker0)));
        Assertions.assertFalse((boolean)addedBrokers2.contains((Object)Broker$.MODULE$.fromBrokerRegistration(broker1)));
        Assertions.assertTrue((boolean)removedBrokers2.isEmpty());
        prevImage = this.brokersToClusterImage((Seq<BrokerRegistration>)new .colon.colon((Object)broker0, (List)new .colon.colon((Object)broker1, (List)Nil$.MODULE$)));
        broker0 = this.brokerBuilder(0, false, false);
        broker1 = this.brokerBuilder(1, false, false);
        Tuple2 tuple23 = MigrationPropagator$.MODULE$.calculateBrokerChanges(prevImage, this.brokersToClusterImage((Seq<BrokerRegistration>)new .colon.colon((Object)broker0, (List)new .colon.colon((Object)broker1, (List)Nil$.MODULE$))));
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Set addedBrokers3 = (Set)tuple23._1();
        Set removedBrokers3 = (Set)tuple23._2();
        Assertions.assertTrue((boolean)addedBrokers3.isEmpty());
        Assertions.assertTrue((boolean)removedBrokers3.contains((Object)Broker$.MODULE$.fromBrokerRegistration(broker0)));
        Assertions.assertTrue((boolean)removedBrokers3.contains((Object)Broker$.MODULE$.fromBrokerRegistration(broker0)));
        prevImage = this.brokersToClusterImage((Seq<BrokerRegistration>)new .colon.colon((Object)broker0, (List)new .colon.colon((Object)broker1, (List)Nil$.MODULE$)));
        broker0 = this.brokerBuilder(0, true, false);
        broker1 = this.brokerBuilder(1, false, false);
        Tuple2 tuple24 = MigrationPropagator$.MODULE$.calculateBrokerChanges(prevImage, this.brokersToClusterImage((Seq<BrokerRegistration>)new .colon.colon((Object)broker0, (List)new .colon.colon((Object)broker1, (List)Nil$.MODULE$))));
        if (tuple24 != null) {
            Set addedBrokers4 = (Set)tuple24._1();
            Set removedBrokers4 = (Set)tuple24._2();
            Assertions.assertTrue((boolean)addedBrokers4.contains((Object)Broker$.MODULE$.fromBrokerRegistration(broker0)));
            Assertions.assertFalse((boolean)addedBrokers4.contains((Object)Broker$.MODULE$.fromBrokerRegistration(broker1)));
            Assertions.assertTrue((boolean)removedBrokers4.isEmpty());
            return;
        }
        throw new MatchError(null);
    }
}

