/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tef\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBQa\u000f\u0001\u0005BqBqa\u0011\u0001C\u0002\u0013\u0005A\t\u0003\u0004N\u0001\u0001\u0006I!\u0012\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001P\u0011\u0019a\u0006\u0001)A\u0005!\"9Q\f\u0001b\u0001\n\u0003q\u0006BB3\u0001A\u0003%q\fC\u0004g\u0001\t\u0007I\u0011\u0001#\t\r\u001d\u0004\u0001\u0015!\u0003F\u0011\u001dA\u0007A1A\u0005\u0002qBa!\u001b\u0001!\u0002\u0013i\u0004\"\u00036\u0001\u0001\u0004\u0005\r\u0011\"\u0001l\u0011%!\b\u00011AA\u0002\u0013\u0005Q\u000fC\u0005|\u0001\u0001\u0007\t\u0011)Q\u0005Y\"IA\u0010\u0001a\u0001\u0002\u0004%\t! \u0005\f\u0003\u0017\u0001\u0001\u0019!a\u0001\n\u0003\ti\u0001\u0003\u0006\u0002\u0012\u0001\u0001\r\u0011!Q!\nyDq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003G\u0003A\u0011AAS\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!a/\u0001\t\u0013\ti\fC\u0004\u0002X\u0002!I!!7\t\u000f\u0005%\b\u0001\"\u0003\u0002l\"9\u0011\u0011\u001f\u0001\u0005\n\u0005M\b\"\u0003B\u0004\u0001E\u0005I\u0011\u0002B\u0005\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005CAaAa\f\u0001\t\u0003a\u0004b\u0002B\u0019\u0001\u0011\u0005!1\u0007\u0005\b\u0005{\u0001A\u0011\u0002B \u0011%\u0011\u0019\u0005AI\u0001\n\u0013\u0011)\u0005C\u0004\u0003J\u0001!IAa\u0013\t\u000f\tE\u0003\u0001\"\u0003\u0003T!9!1\r\u0001\u0005\n\t\u0015\u0004b\u0002B7\u0001\u0011%!q\u000e\u0005\b\u0005k\u0002A\u0011\u0002B<\u0011\u001d\u0011)\t\u0001C\u0005\u0005\u000f\u0013!\u0004R=oC6L7mQ8o]\u0016\u001cG/[8o#V|G/\u0019+fgRT!\u0001L\u0017\u0002\u000f9,Go^8sW*\ta&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b.\u0003\u0019\u0019XM\u001d<fe&\u0011ag\r\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012!\u000f\t\u0003u\u0001i\u0011aK\u0001\fEJ|7.\u001a:D_VtG/F\u0001>!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\rIe\u000e^\u0001\u0006i>\u0004\u0018nY\u000b\u0002\u000bB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0005Y\u0006twMC\u0001K\u0003\u0011Q\u0017M^1\n\u00051;%AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\tY&\u001cH/\u001a8feV\t\u0001\u000b\u0005\u0002R56\t!K\u0003\u0002-'*\u0011A+V\u0001\u0007G>lWn\u001c8\u000b\u000592&BA,Y\u0003\u0019\t\u0007/Y2iK*\t\u0011,A\u0002pe\u001eL!a\u0017*\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002\u00131L7\u000f^3oKJ\u0004\u0013\u0001\u00047pG\u0006d\u0017\t\u001a3sKN\u001cX#A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\tL\u0015a\u00018fi&\u0011A-\u0019\u0002\f\u0013:,G/\u00113ee\u0016\u001c8/A\u0007m_\u000e\fG.\u00113ee\u0016\u001c8\u000fI\u0001\fk:\\gn\\<o\u0011>\u001cH/\u0001\u0007v].twn\u001e8I_N$\b%A\u000fqY\u0006Lg\u000e^3yi2K7\u000f^3oKJ$UMZ1vYR\fVo\u001c;b\u0003y\u0001H.Y5oi\u0016DH\u000fT5ti\u0016tWM\u001d#fM\u0006,H\u000e^)v_R\f\u0007%\u0001\u0005fq\u0016\u001cW\u000f^8s+\u0005a\u0007CA7s\u001b\u0005q'BA8q\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003c&\u000bA!\u001e;jY&\u00111O\u001c\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006aQ\r_3dkR|'o\u0018\u0013fcR\u0011a/\u001f\t\u0003}]L!\u0001_ \u0003\tUs\u0017\u000e\u001e\u0005\bu:\t\t\u00111\u0001m\u0003\rAH%M\u0001\nKb,7-\u001e;pe\u0002\nQ!\u00193nS:,\u0012A \t\u0004\u007f\u0006\u001dQBAA\u0001\u0015\ra\u00181\u0001\u0006\u0004\u0003\u000b)\u0016aB2mS\u0016tGo]\u0005\u0005\u0003\u0013\t\tAA\u0003BI6Lg.A\u0005bI6Lgn\u0018\u0013fcR\u0019a/a\u0004\t\u000fi\f\u0012\u0011!a\u0001}\u00061\u0011\rZ7j]\u0002\nqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u0007Y\f9\u0002C\u0004\u0002\u001aM\u0001\r!a\u0007\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0003\u0002\u001e\u0005}Q\"\u00019\n\u0007\u0005\u0005\u0002O\u0001\u0006Qe>\u0004XM\u001d;jKN\fQa]3u+B$2A^A\u0014\u0011\u001d\tI\u0003\u0006a\u0001\u0003W\t\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003[\tY$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\r\t\u0007/\u001b\u0006\u0005\u0003k\t9$A\u0004kkBLG/\u001a:\u000b\u0007\u0005e\u0002,A\u0003kk:LG/\u0003\u0003\u0002>\u0005=\"\u0001\u0003+fgRLeNZ8)\u0007Q\t\t\u0005\u0005\u0003\u0002.\u0005\r\u0013\u0002BA#\u0003_\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#\u0001<)\u0007U\ti\u0005\u0005\u0003\u0002.\u0005=\u0013\u0002BA)\u0003_\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u00025Q,7\u000f\u001e#z]\u0006l\u0017nY\"p]:,7\r^5p]F+x\u000e^1\u0015\u0007Y\f9\u0006C\u0004\u0002ZY\u0001\r!a\u0017\u0002\rE,xN];n!\u0011\ti&a\u001b\u000f\t\u0005}\u0013q\r\t\u0004\u0003CzTBAA2\u0015\r\t)gL\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%t(\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u0019\u00065$bAA5\u007f!:a#!\u001d\u0002\u0002\u0006\r\u0005\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\taJ|g/\u001b3fe*!\u00111PA\u001a\u0003\u0019\u0001\u0018M]1ng&!\u0011qPA;\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"\u0011QQAEC\t\t9)\u0001\u0002{W\u0006\u0012\u00111R\u0001\u0006WJ\fg\r\u001e\u0015\u0004-\u0005=\u0005\u0003BAI\u0003'k!!!\u001f\n\t\u0005U\u0015\u0011\u0010\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018A\t;fgR$\u0015P\\1nS\u000ed\u0015n\u001d;f]\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018\rF\u0002w\u00037Cq!!\u0017\u0018\u0001\u0004\tY\u0006K\u0004\u0018\u0003c\n\t)a(-\t\u0005\u0015\u0015\u0011\u0012\u0015\u0004/\u0005=\u0015A\f;fgR$\u0015P\\1nS\u000ed\u0015n\u001d;f]\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8De\u0016\fG/[8o%\u0006$X-U;pi\u0006$2A^AT\u0011\u001d\tI\u0006\u0007a\u0001\u00037Bs\u0001GA9\u0003\u0003\u000bY\u000b\f\u0003\u0002\u0006\u0006%\u0005f\u0001\r\u0002\u0010\u0006\u0001C/Z:u\tft\u0017-\\5d\u0013B\u001cuN\u001c8fGRLwN\u001c*bi\u0016\fVo\u001c;b)\r1\u00181\u0017\u0005\b\u00033J\u0002\u0019AA.Q\u001dI\u0012\u0011OAA\u0003ocC!!\"\u0002\n\"\u001a\u0011$a$\u0002%I,7m\u001c8gS\u001e,(/Z*feZ,'o\u001d\u000b\bm\u0006}\u00161YAg\u0011\u001d\t\tM\u0007a\u0001\u00037\t\u0001B\\3x!J|\u0007o\u001d\u0005\b\u0003\u000bT\u0002\u0019AAd\u0003=\u0001XM\u001d\"s_.,'oQ8oM&<\u0007c\u0001 \u0002J&\u0019\u00111Z \u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u001a\u000eA\u0002\u0005E\u0017!D1Qe>\u0004Hk\u001c,fe&4\u0017\u0010E\u0004?\u0003'\fY&a\u0017\n\u0007\u0005UwH\u0001\u0004UkBdWMM\u0001\u0017kB$\u0017\r^3Ja\u000e{gN\\3di&|gNU1uKR)a/a7\u0002f\"9\u0011Q\\\u000eA\u0002\u0005}\u0017AA5q!\u0015q\u0014\u0011]A.\u0013\r\t\u0019o\u0010\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005\u001d8\u00041\u0001>\u0003-)\b\u000fZ1uK\u0012\u0014\u0016\r^3\u0002\u001f]\f\u0017\u000e\u001e$pe2K7\u000f^3oKJ$2A^Aw\u0011\u001d\ty\u000f\ba\u0001\u00037\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016\fQc^1ji\u001a{'oQ8oM&<wJ\\*feZ,'\u000fF\u0004w\u0003k\fI0!@\t\u000f\u0005]X\u00041\u0001\u0002\\\u0005A\u0001O]8q\u001d\u0006lW\rC\u0004\u0002|v\u0001\r!a\u0017\u0002\u0013A\u0014x\u000e\u001d,bYV,\u0007\"CA\u0000;A\u0005\t\u0019\u0001B\u0001\u0003%i\u0017\r_,bSRl5\u000fE\u0002?\u0005\u0007I1A!\u0002@\u0005\u0011auN\\4\u0002?]\f\u0017\u000e\u001e$pe\u000e{gNZ5h\u001f:\u001cVM\u001d<fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\f)\"!\u0011\u0001B\u0007W\t\u0011y\u0001\u0005\u0003\u0003\u0012\tmQB\u0001B\n\u0015\u0011\u0011)Ba\u0006\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\r\u007f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tu!1\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00049s_\u0012,8-\u001a*fcV,7\u000f^\u000b\u0003\u0005G\u0001BA!\n\u0003,5\u0011!q\u0005\u0006\u0004\u0005S\u0019\u0016\u0001\u0003:fcV,7\u000f^:\n\t\t5\"q\u0005\u0002\u000f!J|G-^2f%\u0016\fX/Z:u\u0003=\u0019wN\u001c8fGRLwN\\\"pk:$\u0018aB2p]:,7\r\u001e\u000b\u0005\u0005k\u0011Y\u0004E\u0002a\u0005oI1A!\u000fb\u0005\u0019\u0019vnY6fi\"1a*\ta\u0001\u00037\n\u0011d\u0019:fCR,\u0017I\u001c3WKJLg-_\"p]:,7\r^5p]R\u0019aO!\u0011\t\u00119\u0013\u0003\u0013!a\u0001\u00037\n1e\u0019:fCR,\u0017I\u001c3WKJLg-_\"p]:,7\r^5p]\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003H)\"\u00111\fB\u0007\u0003A1XM]5gs\u000e{gN\\3di&|g\u000eF\u0002w\u0005\u001bBqAa\u0014%\u0001\u0004\u0011)$\u0001\u0004t_\u000e\\W\r^\u0001\u0015m\u0016\u0014\u0018NZ=NCb\u001cuN\u001c8fGRLwN\\:\u0015\u000bY\u0014)F!\u0017\t\r\t]S\u00051\u0001>\u00039i\u0017\r_\"p]:,7\r^5p]NDqAa\u0017&\u0001\u0004\u0011i&\u0001\nd_:tWm\u0019;XSRDg)Y5mkJ,\u0007\u0003\u0002 \u0003`YL1A!\u0019@\u0005%1UO\\2uS>t\u0007'\u0001\td_:tWm\u0019;B]\u00124VM]5gsR)aOa\u001a\u0003j!1aJ\na\u0001\u00037BqAa\u001b'\u0001\u0004\t9-\u0001\njO:|'/Z%P\u000bb\u001cW\r\u001d;j_:\u001c\u0018AF<bSR4uN]\"p]:,7\r^5p]\u000e{WO\u001c;\u0015\u0007Y\u0014\t\b\u0003\u0004\u0003t\u001d\u0002\r!P\u0001\u0018Kb\u0004Xm\u0019;fI\u000e{gN\\3di&|gnQ8v]R\fAC^3sS\u001aL8i\u001c8oK\u000e$\u0018n\u001c8SCR,G#\u0003<\u0003z\tu$\u0011\u0011BB\u0011\u0019\u0011Y\b\u000ba\u0001{\u0005\tR.\u001b8D_:tWm\u0019;j_:\u0014\u0016\r^3\t\r\t}\u0004\u00061\u0001>\u0003Ei\u0017\r_\"p]:,7\r^5p]J\u000bG/\u001a\u0005\u0007\u001d\"\u0002\r!a\u0017\t\u000f\t-\u0004\u00061\u0001\u0002H\u0006\t\u0012\r\u001c;fe\u000ec\u0017.\u001a8u#V|G/Y:\u0015\r\t%%q\u0012BJ!\ry(1R\u0005\u0005\u0005\u001b\u000b\tAA\fBYR,'o\u00117jK:$\u0018+^8uCN\u0014Vm];mi\"1!\u0011S\u0015A\u0002y\f1\"\u00193nS:\u001cE.[3oi\"9!QS\u0015A\u0002\t]\u0015a\u0002:fcV,7\u000f\u001e\t\t\u00053\u0013yJa)\u000306\u0011!1\u0014\u0006\u0004\u0005;{\u0014AC2pY2,7\r^5p]&!!\u0011\u0015BN\u0005\ri\u0015\r\u001d\t\u0005\u0005K\u0013Y+\u0004\u0002\u0003(*\u0019!\u0011V*\u0002\u000bE,x\u000e^1\n\t\t5&q\u0015\u0002\u0012\u00072LWM\u001c;Rk>$\u0018-\u00128uSRL\b\u0003\u0003BM\u0005?\u000bYF!-\u0011\u000by\n\tOa-\u0011\u0007y\u0012),C\u0002\u00038~\u0012a\u0001R8vE2,\u0007")
public class DynamicConnectionQuotaTest
extends BaseRequestTest {
    private final String topic;
    private final ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private final InetAddress localAddress = InetAddress.getByName("127.0.0.1");
    private final String unknownHost;
    private final int plaintextListenerDefaultQuota;
    private ExecutorService executor;
    private Admin admin;

    @Override
    public int brokerCount() {
        return 1;
    }

    public String topic() {
        return this.topic;
    }

    public ListenerName listener() {
        return this.listener;
    }

    public InetAddress localAddress() {
        return this.localAddress;
    }

    public String unknownHost() {
        return this.unknownHost;
    }

    public int plaintextListenerDefaultQuota() {
        return this.plaintextListenerDefaultQuota;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("quota.window.num", "2");
        properties.put("listener.name.plaintext.max.connection.creation.rate", Integer.toString(this.plaintextListenerDefaultQuota()));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.admin_$eq(this.createAdminClient(this.listener(), this.createAdminClient$default$2()));
        TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), this.controllerServers(), TestUtils$.MODULE$.createTopicWithAdmin$default$5(), TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7(), TestUtils$.MODULE$.createTopicWithAdmin$default$8());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.admin() != null) {
            this.admin().close();
        }
        try {
            if (this.executor() != null) {
                this.executor().shutdownNow();
                Assertions.assertTrue((boolean)this.executor().awaitTermination(10L, TimeUnit.SECONDS));
            }
        }
        finally {
            super.tearDown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicConnectionQuota(String quorum) {
        int maxConnectionsPerIP = 5;
        Properties props = new Properties();
        props.put("max.connections.per.ip", Integer.toString(maxConnectionsPerIP));
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)"max.connections.per.ip", (Object)Integer.toString(maxConnectionsPerIP)));
        JFunction0.mcV.sp & Serializable & scala.Serializable verifyMaxConnections_connectWithFailure = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPerIP - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        verifyMaxConnections_conns.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        int maxConnectionsPerIPOverride = 7;
        props.put("max.connections.per.ip.overrides", new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)"max.connections.per.ip.overrides", (Object)new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString()));
        JFunction0.mcV.sp & Serializable & scala.Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPerIPOverride - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure2));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        verifyMaxConnections_conns2.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicListenerConnectionQuota(String quorum) {
        void verifyMaxConnections_connectWithFailure;
        int initialConnectionCount = this.connectionCount();
        Properties props = new Properties();
        props.put("max.connections", "5");
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)"max.connections", (Object)"5"));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_maxConnections = 5;
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), verifyMaxConnections_maxConnections - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        verifyMaxConnections_conns.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        String newListeners = "PLAINTEXT://localhost:0,INTERNAL://localhost:0";
        props.put("listeners", newListeners);
        props.put("listener.security.protocol.map", "PLAINTEXT:PLAINTEXT,INTERNAL:PLAINTEXT, CONTROLLER: PLAINTEXT");
        props.put("max.connections", "10");
        props.put("listener.name.internal.max.connections", "5");
        props.put("listener.name.plaintext.max.connections", "5");
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)"listeners", (Object)newListeners));
        this.waitForListener("INTERNAL");
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1 & Serializable & scala.Serializable)x$1 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        conns = (IndexedSeq)conns.$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).map((Function1 & Serializable & scala.Serializable)x$2 -> this.connect("INTERNAL"), IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
        conns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        conns.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$6(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int maxConnectionsPlaintext = 7;
        String listenerProp = new StringBuilder(15).append(this.listener().configPrefix()).append("max.connections").toString();
        props.put(listenerProp, Integer.toString(maxConnectionsPlaintext));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)listenerProp, (Object)Integer.toString(maxConnectionsPlaintext)));
        JFunction0.mcV.sp & Serializable & scala.Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPlaintext - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure2));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        verifyMaxConnections_conns2.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l13 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l14 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            void verifyMaxConnections_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        IndexedSeq plaintextConnections = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPlaintext).map((Function1 & Serializable & scala.Serializable)x$4 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.executor_$eq(Executors.newSingleThreadExecutor());
        Future<?> future = this.executor().submit(() -> this.createAndVerifyConnection(this.createAndVerifyConnection$default$1()));
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)future.isDone());
        ((Socket)plaintextConnections.head()).close();
        future.get(30L, TimeUnit.SECONDS);
        plaintextConnections.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        long l15 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l16 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$12(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$13());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        IndexedSeq plaintextConns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1 & Serializable & scala.Serializable)x$6 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq internalConns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).map((Function1 & Serializable & scala.Serializable)x$7 -> this.connect("INTERNAL"), IndexedSeq$.MODULE$.canBuildFrom());
        plaintextConns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        plaintextConns = (IndexedSeq)plaintextConns.$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).map((Function1 & Serializable & scala.Serializable)x$8 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
        long l17 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l18 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$19(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$20());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        plaintextConns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        Assertions.assertThrows(IOException.class, () -> internalConns.foreach((Function1 & Serializable & scala.Serializable)socket -> (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), (Socket)socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class))));
        plaintextConns.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.close();
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.close();
            return BoxedUnit.UNIT;
        });
        long l19 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l20 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$26(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$27());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicListenerConnectionCreationRateQuota(String quorum) {
        .colon.colon newListenerNames = new .colon.colon((Object)"PLAINTEXT", (List)new .colon.colon((Object)"EXTERNAL", (List)Nil$.MODULE$));
        String newListeners = "PLAINTEXT://localhost:0,EXTERNAL://localhost:0";
        Properties props = new Properties();
        props.put("listeners", newListeners);
        props.put("listener.security.protocol.map", "PLAINTEXT:PLAINTEXT,EXTERNAL:PLAINTEXT,CONTROLLER:PLAINTEXT");
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)"listeners", (Object)newListeners));
        this.waitForListener("EXTERNAL");
        int initialConnectionCount = this.connectionCount();
        int connRateLimit = 9;
        this.verifyConnectionRate(2 * connRateLimit, this.plaintextListenerDefaultQuota(), "PLAINTEXT", false);
        this.waitForConnectionCount(initialConnectionCount);
        props.clear();
        props.put("max.connection.creation.rate", Integer.toString(connRateLimit));
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)"max.connection.creation.rate", (Object)Integer.toString(connRateLimit)));
        this.verifyConnectionRate(8, connRateLimit, "EXTERNAL", false);
        this.waitForConnectionCount(initialConnectionCount);
        int listenerConnRateLimit = 4;
        String plaintextListenerProp = new StringBuilder(28).append(this.listener().configPrefix()).append("max.connection.creation.rate").toString();
        props.put(new StringBuilder(51).append("listener.name.external.").append("max.connection.creation.rate").toString(), Integer.toString(listenerConnRateLimit));
        props.put(plaintextListenerProp, Integer.toString(listenerConnRateLimit));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)plaintextListenerProp, (Object)Integer.toString(listenerConnRateLimit)));
        this.executor_$eq(Executors.newFixedThreadPool(newListenerNames.size()));
        ((Seq)newListenerNames.map((Function1 & Serializable & scala.Serializable)listener -> this.executor().submit(() -> this.verifyConnectionRate(3, listenerConnRateLimit, (String)listener, false)), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$11 -> x$11.get(40L, TimeUnit.SECONDS));
        this.waitForConnectionCount(initialConnectionCount);
        int newPlaintextRateLimit = 12;
        props.put(plaintextListenerProp, Integer.toString(newPlaintextRateLimit));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)plaintextListenerProp, (Object)Integer.toString(newPlaintextRateLimit)));
        Future<?> plaintextFuture = this.executor().submit(() -> this.verifyConnectionRate(10, newPlaintextRateLimit, "PLAINTEXT", false));
        Future<?> externalFuture = this.executor().submit(() -> this.verifyConnectionRate(3, listenerConnRateLimit, "EXTERNAL", false));
        plaintextFuture.get(40L, TimeUnit.SECONDS);
        externalFuture.get(40L, TimeUnit.SECONDS);
        this.waitForConnectionCount(initialConnectionCount);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicIpConnectionRateQuota(String quorum) {
        int connRateLimit = 10;
        int initialConnectionCount = this.connectionCount();
        this.verifyConnectionRate(2 * connRateLimit, this.plaintextListenerDefaultQuota(), "PLAINTEXT", false);
        this.waitForConnectionCount(initialConnectionCount);
        this.updateIpConnectionRate((Option<String>)None$.MODULE$, connRateLimit);
        this.verifyConnectionRate(8, connRateLimit, "PLAINTEXT", true);
        this.waitForConnectionCount(initialConnectionCount);
        int newRateLimit = 18;
        this.updateIpConnectionRate((Option<String>)new Some((Object)this.localAddress().getHostAddress()), newRateLimit);
        this.verifyConnectionRate(14, newRateLimit, "PLAINTEXT", true);
        this.waitForConnectionCount(initialConnectionCount);
    }

    /*
     * WARNING - void declaration
     */
    private void reconfigureServers(Properties newProps, boolean perBrokerConfig, Tuple2<String, String> aPropToVerify) {
        int initialConnectionCount = this.connectionCount();
        TestUtils$.MODULE$.incrementalAlterConfigs(this.brokers(), this.admin(), newProps, perBrokerConfig, TestUtils$.MODULE$.incrementalAlterConfigs$default$5()).all().get();
        this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), this.waitForConfigOnServer$default$3());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$reconfigureServers$1(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$reconfigureServers$2(this, initialConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateIpConnectionRate(Option<String> ip, int updatedRate) {
        int initialConnectionCount = this.connectionCount();
        ClientQuotaEntity entity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), ip.orNull(Predef$.MODULE$.$conforms()))}))).asJava());
        Map request = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)updatedRate)))})))}));
        this.alterClientQuotas(this.admin(), (Map<ClientQuotaEntity, Map<String, Option<Object>>>)request).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$1(this, ip, updatedRate)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$4(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$5(this, initialConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForListener(String listenerName) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForListener$1(this, listenerName);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForConfigOnServer$1(this, propValue, propName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    private ProduceRequest produceRequest() {
        return (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(this.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())}))))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build();
    }

    public int connectionCount() {
        return ((KafkaBroker)this.brokers().head()).socketServer().connectionCount(this.localAddress());
    }

    public Socket connect(String listener) {
        ListenerName listenerName = ListenerName.normalised((String)listener);
        return new Socket("localhost", ((KafkaBroker)this.brokers().head()).socketServer().boundPort(listenerName));
    }

    private void createAndVerifyConnection(String listener) {
        try (Socket socket = this.connect(listener);){
            this.verifyConnection(socket);
        }
    }

    private String createAndVerifyConnection$default$1() {
        return "PLAINTEXT";
    }

    private void verifyConnection(Socket socket) {
        ProduceResponse produceResponse = (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class));
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse.data().responses()).asScala()).head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse.partitionResponses()).asScala()).head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
    }

    /*
     * WARNING - void declaration
     */
    private void verifyMaxConnections(int maxConnections, Function0<BoxedUnit> connectWithFailure) {
        int initialConnectionCount = this.connectionCount();
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnections - 1).map((Function1 & Serializable & scala.Serializable)x$12 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnections)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        conns = (IndexedSeq)conns.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertThrows(IOException.class, () -> connectWithFailure.apply$mcV$sp());
        ((Socket)conns.head()).close();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnections)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        conns.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void connectAndVerify(String listener, boolean ignoreIOExceptions) {
        try (Socket socket = this.connect(listener);){
            try {
                this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class));
            }
            catch (IOException e) {
                if (!ignoreIOExceptions) {
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForConnectionCount(int expectedConnectionCount) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$waitForConnectionCount$1(this, expectedConnectionCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$waitForConnectionCount$2(this, expectedConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyConnectionRate(int minConnectionRate, int maxConnectionRate, String listener, boolean ignoreIOExceptions) {
        long runTimeMs = TimeUnit.SECONDS.toMillis(13L);
        long startTimeMs = System.currentTimeMillis();
        long endTimeMs = startTimeMs + runTimeMs;
        int connCount = 0;
        while (System.currentTimeMillis() < endTimeMs) {
            this.connectAndVerify(listener, ignoreIOExceptions);
            ++connCount;
        }
        long elapsedMs = System.currentTimeMillis() - startTimeMs;
        double actualRate = (double)connCount / (double)elapsedMs * (double)1000;
        double rateCap = maxConnectionRate < Integer.MAX_VALUE ? 1.2 * (double)maxConnectionRate : (double)Integer.MAX_VALUE;
        Assertions.assertTrue((actualRate <= rateCap ? 1 : 0) != 0, (String)new StringBuilder(41).append("Listener ").append(listener).append(" connection rate ").append(actualRate).append(" must be below ").append(rateCap).toString());
        Assertions.assertTrue((actualRate >= (double)minConnectionRate ? 1 : 0) != 0, (String)new StringBuilder(41).append("Listener ").append(listener).append(" connection rate ").append(actualRate).append(" must be above ").append(minConnectionRate).toString());
    }

    private AlterClientQuotasResult alterClientQuotas(Admin adminClient, Map<ClientQuotaEntity, Map<String, Option<Object>>> request) {
        Collection entries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)request.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
                Map alter = (Map)x0$1._2();
                Collection ops = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)alter.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        String key = (String)x0$2._1();
                        Option value = (Option)x0$2._2();
                        return new ClientQuotaAlteration.Op(key, (Double)value.map((Function1 & Serializable & scala.Serializable)x -> DynamicConnectionQuotaTest.$anonfun$alterClientQuotas$3(BoxesRunTime.unboxToDouble((Object)x))).orNull(Predef$.MODULE$.$conforms()));
                    }
                    throw new MatchError(null);
                }, Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
                return new ClientQuotaAlteration(entity, ops);
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
        return adminClient.alterClientQuotas(entries);
    }

    private final void connectAndVerify$1() {
        try (Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class));
        }
    }

    private final void connectAndVerify$2() {
        socket.setSoTimeout(1000);
        try (Socket socket = this.connect("PLAINTEXT");){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$6(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$7() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$12(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$13() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$19(DynamicConnectionQuotaTest $this) {
        return $this.connectionCount() <= 10;
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$20() {
        return "Internal connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$26(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$27() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$reconfigureServers$1(DynamicConnectionQuotaTest $this, int initialConnectionCount$2) {
        return initialConnectionCount$2 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$reconfigureServers$2(DynamicConnectionQuotaTest $this, int initialConnectionCount$2) {
        return new StringBuilder(59).append("Admin client connection not closed (initial = ").append(initialConnectionCount$2).append(", current = ").append($this.connectionCount()).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$updateIpConnectionRate$1(DynamicConnectionQuotaTest $this, Option ip$1, int updatedRate$1) {
        return ((KafkaBroker)$this.brokers().head()).socketServer().connectionQuotas().connectionRateForIp(InetAddress.getByName((String)ip$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.unknownHost()))) == updatedRate$1;
    }

    public static final /* synthetic */ String $anonfun$updateIpConnectionRate$3() {
        return "Timed out waiting for connection rate update to propagate";
    }

    public static final /* synthetic */ boolean $anonfun$updateIpConnectionRate$4(DynamicConnectionQuotaTest $this, int initialConnectionCount$3) {
        return initialConnectionCount$3 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$updateIpConnectionRate$5(DynamicConnectionQuotaTest $this, int initialConnectionCount$3) {
        return new StringBuilder(59).append("Admin client connection not closed (initial = ").append(initialConnectionCount$3).append(", current = ").append($this.connectionCount()).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$waitForListener$1(DynamicConnectionQuotaTest $this, String listenerName$1) {
        try {
            Assertions.assertTrue((((KafkaBroker)$this.brokers().head()).socketServer().boundPort(ListenerName.normalised((String)listenerName$1)) > 0 ? 1 : 0) != 0);
            return;
        }
        catch (KafkaException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final /* synthetic */ void $anonfun$waitForConfigOnServer$1(DynamicConnectionQuotaTest $this, String propValue$1, String propName$1) {
        Assertions.assertEquals((Object)propValue$1, ((KafkaBroker)$this.brokers().head()).config().originals().get(propName$1));
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$2(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$3() {
        return "produce request connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$5(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$6() {
        return "connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$8(DynamicConnectionQuotaTest $this, int initialConnectionCount$4) {
        return initialConnectionCount$4 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$9() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$waitForConnectionCount$1(DynamicConnectionQuotaTest $this, int expectedConnectionCount$1) {
        return expectedConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$waitForConnectionCount$2(DynamicConnectionQuotaTest $this, int expectedConnectionCount$1) {
        return new StringBuilder(47).append("Connections not closed (expected = ").append(expectedConnectionCount$1).append(" current = ").append($this.connectionCount()).append(")").toString();
    }

    public static final /* synthetic */ Double $anonfun$alterClientQuotas$3(double x) {
        return BoxesRunTime.boxToDouble((double)x);
    }

    public DynamicConnectionQuotaTest() {
        this.topic = "test";
        this.unknownHost = "255.255.0.1";
        this.plaintextListenerDefaultQuota = 30;
    }
}

