/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.Serializable;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005BQ\u0001\n\u0001\u0005B\u0015Bq\u0001\f\u0001C\u0002\u0013\u0005Q\u0006\u0003\u00047\u0001\u0001\u0006IA\f\u0005\bo\u0001\u0011\r\u0011\"\u0001.\u0011\u0019A\u0004\u0001)A\u0005]!I\u0011\b\u0001a\u0001\u0002\u0004%\tA\u000f\u0005\n\u000f\u0002\u0001\r\u00111A\u0005\u0002!C\u0011B\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B\u001e\t\u000b=\u0003A\u0011\t)\t\u000be\u0003A\u0011\t.\t\u000b-\u0004A\u0011\t7\t\u000bE\u0004A\u0011\u0001:\t\r}\u0004A\u0011AA\u0001\u0011\u001d\ty\u0003\u0001C\u0005\u0003cAq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002F\u0001!I!a\u0012\t\u0013\u0005m\u0003!%A\u0005\n\u0005u#\u0001\b#z]\u0006l\u0017n\u0019(v[:+Go^8sWRC'/Z1egR+7\u000f\u001e\u0006\u0003+Y\tqA\\3uo>\u00148NC\u0001\u0018\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0005u1\u0012AB:feZ,'/\u0003\u0002 9\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002)\u0005Y!M]8lKJ\u001cu.\u001e8u+\u00051\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#aA%oi\u0006A\u0011N\u001c;fe:\fG.F\u0001/!\tyC'D\u00011\u0015\t\t$'\u0001\u0003mC:<'\"A\u001a\u0002\t)\fg/Y\u0005\u0003kA\u0012aa\u0015;sS:<\u0017!C5oi\u0016\u0014h.\u00197!\u0003!)\u0007\u0010^3s]\u0006d\u0017!C3yi\u0016\u0014h.\u00197!\u0003\u0015\tG-\\5o+\u0005Y\u0004C\u0001\u001fF\u001b\u0005i$BA\u001d?\u0015\ty\u0004)A\u0004dY&,g\u000e^:\u000b\u0005]\t%B\u0001\"D\u0003\u0019\t\u0007/Y2iK*\tA)A\u0002pe\u001eL!AR\u001f\u0003\u000b\u0005#W.\u001b8\u0002\u0013\u0005$W.\u001b8`I\u0015\fHCA%M!\t9#*\u0003\u0002LQ\t!QK\\5u\u0011\u001di\u0005\"!AA\u0002m\n1\u0001\u001f\u00132\u0003\u0019\tG-\\5oA\u00059\"M]8lKJ\u0004&o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u0003\u0013FCQA\u0015\u0006A\u0002M\u000b!\u0002\u001d:pa\u0016\u0014H/[3t!\t!v+D\u0001V\u0015\t1&'\u0001\u0003vi&d\u0017B\u0001-V\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0013nCQ\u0001X\u0006A\u0002u\u000b\u0001\u0002^3ti&sgm\u001c\t\u0003=\u0016l\u0011a\u0018\u0006\u0003A\u0006\f1!\u00199j\u0015\t\u00117-A\u0004kkBLG/\u001a:\u000b\u0005\u0011\u001c\u0015!\u00026v]&$\u0018B\u00014`\u0005!!Vm\u001d;J]\u001a|\u0007FA\u0006i!\tq\u0016.\u0003\u0002k?\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\u0012!\u0013\u0015\u0003\u00199\u0004\"AX8\n\u0005A|&!C!gi\u0016\u0014X)Y2i\u0003Q9W\r\u001e(v[:+Go^8sWRC'/Z1egR\u0011ae\u001d\u0005\u0006i6\u0001\r!^\u0001\tY&\u001cH/\u001a8feB\u0011a/ \b\u0003on\u0004\"\u0001\u001f\u0015\u000e\u0003eT!A\u001f\r\u0002\rq\u0012xn\u001c;?\u0013\ta\b&\u0001\u0004Qe\u0016$WMZ\u0005\u0003kyT!\u0001 \u0015\u00029Q,7\u000f\u001e#z]\u0006l\u0017n\u0019(v[:+Go^8sWRC'/Z1egR\u0019\u0011*a\u0001\t\r\u0005\u0015a\u00021\u0001v\u0003\u0019\tXo\u001c:v[\":a\"!\u0003\u0002\u001a\u0005m\u0001\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\taJ|g/\u001b3fe*\u0019\u00111C1\u0002\rA\f'/Y7t\u0013\u0011\t9\"!\u0004\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\ti\"!\t\"\u0005\u0005}\u0011A\u0001>lC\t\t\u0019#A\u0003le\u00064G\u000fK\u0002\u000f\u0003O\u0001B!!\u000b\u0002,5\u0011\u0011\u0011C\u0005\u0005\u0003[\t\tBA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f!C]3d_:4\u0017nZ;sKN+'O^3sgR)\u0011*a\r\u00028!1\u0011QG\bA\u0002M\u000b\u0001B\\3x!J|\u0007o\u001d\u0005\b\u0003sy\u0001\u0019AA\u001e\u00035\t\u0007K]8q)>4VM]5gsB)q%!\u0010vk&\u0019\u0011q\b\u0015\u0003\rQ+\b\u000f\\33\u0003E\u0019'/Z1uK\u0006#W.\u001b8DY&,g\u000e\u001e\u000b\u0002w\u0005)r/Y5u\r>\u00148i\u001c8gS\u001e|enU3sm\u0016\u0014HcB%\u0002J\u00055\u0013\u0011\u000b\u0005\u0007\u0003\u0017\n\u0002\u0019A;\u0002\u0011A\u0014x\u000e\u001d(b[\u0016Da!a\u0014\u0012\u0001\u0004)\u0018!\u00039s_B4\u0016\r\\;f\u0011%\t\u0019&\u0005I\u0001\u0002\u0004\t)&A\u0005nCb<\u0016-\u001b;NgB\u0019q%a\u0016\n\u0007\u0005e\u0003F\u0001\u0003M_:<\u0017aH<bSR4uN]\"p]\u001aLwm\u00148TKJ4XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\f\u0016\u0005\u0003+\n\tg\u000b\u0002\u0002dA!\u0011QMA8\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014!C;oG\",7m[3e\u0015\r\ti\u0007K\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA9\u0003O\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class DynamicNumNetworkThreadsTest
extends BaseRequestTest {
    private final String internal;
    private final String external;
    private Admin admin;

    @Override
    public int brokerCount() {
        return 1;
    }

    public String internal() {
        return this.internal;
    }

    public String external() {
        return this.external;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("listeners", new StringBuilder(30).append(this.internal()).append("://localhost:0, ").append(this.external()).append("://localhost:0").toString());
        properties.put("listener.security.protocol.map", new StringBuilder(22).append(this.internal()).append(":PLAINTEXT, ").append(this.external()).append(":PLAINTEXT").toString());
        properties.put(new StringBuilder(34).append("listener.name.").append(this.internal().toLowerCase()).append(".").append("num.network.threads").toString(), "2");
        properties.put("num.network.threads", Integer.toString(3));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), TestUtils$.MODULE$.createAdminClient$default$3()));
        Assertions.assertEquals((int)2, (int)this.getNumNetworkThreads(this.internal()));
        TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), "test", this.brokers(), this.controllerServers(), TestUtils$.MODULE$.createTopicWithAdmin$default$5(), TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7(), TestUtils$.MODULE$.createTopicWithAdmin$default$8());
        Assertions.assertEquals((int)3, (int)this.getNumNetworkThreads(this.external()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.admin() != null) {
            this.admin().close();
        }
        super.tearDown();
    }

    public int getNumNetworkThreads(String listener) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(((KafkaBroker)this.brokers().head()).metrics().metrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicNumNetworkThreadsTest.$anonfun$getNumNetworkThreads$1(x$1)))).count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicNumNetworkThreadsTest.$anonfun$getNumNetworkThreads$2(listener, x$2)));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicNumNetworkThreads(String quorum) {
        int newBaseNetworkThreadsCount = 4;
        Properties props = new Properties();
        props.put("num.network.threads", Integer.toString(newBaseNetworkThreadsCount));
        this.reconfigureServers(props, (Tuple2<String, String>)new Tuple2((Object)"num.network.threads", (Object)Integer.toString(newBaseNetworkThreadsCount)));
        Assertions.assertEquals((int)2, (int)this.getNumNetworkThreads(this.internal()));
        Assertions.assertEquals((int)newBaseNetworkThreadsCount, (int)this.getNumNetworkThreads(this.external()));
        int newInternalNetworkThreadsCount = 3;
        props = new Properties();
        props.put(new StringBuilder(34).append("listener.name.").append(this.internal().toLowerCase()).append(".").append("num.network.threads").toString(), Integer.toString(newInternalNetworkThreadsCount));
        this.reconfigureServers(props, (Tuple2<String, String>)new Tuple2((Object)new StringBuilder(34).append("listener.name.").append(this.internal().toLowerCase()).append(".").append("num.network.threads").toString(), (Object)Integer.toString(newInternalNetworkThreadsCount)));
        Assertions.assertEquals((int)newInternalNetworkThreadsCount, (int)this.getNumNetworkThreads(this.internal()));
        Assertions.assertEquals((int)newBaseNetworkThreadsCount, (int)this.getNumNetworkThreads(this.external()));
    }

    private void reconfigureServers(Properties newProps, Tuple2<String, String> aPropToVerify) {
        Admin adminClient = this.createAdminClient();
        TestUtils$.MODULE$.incrementalAlterConfigs(this.brokers(), adminClient, newProps, false, TestUtils$.MODULE$.incrementalAlterConfigs$default$5()).all().get();
        this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), this.waitForConfigOnServer$default$3());
        adminClient.close();
    }

    private Admin createAdminClient() {
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers(this.brokers(), new ListenerName(this.securityProtocol().name));
        Properties config = new Properties();
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicNumNetworkThreadsTest.$anonfun$waitForConfigOnServer$1(this, propValue, propName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    public static final /* synthetic */ boolean $anonfun$getNumNetworkThreads$1(MetricName x$1) {
        String string = x$1.name();
        String string2 = "request-rate";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$getNumNetworkThreads$2(String listener$1, MetricName x$2) {
        String string = listener$1;
        Object v = x$2.tags().get("listener");
        return !(string != null ? !string.equals(v) : v != null);
    }

    public static final /* synthetic */ void $anonfun$waitForConfigOnServer$1(DynamicNumNetworkThreadsTest $this, String propValue$1, String propName$1) {
        Assertions.assertEquals((Object)propValue$1, ((KafkaBroker)$this.brokers().head()).config().originals().get(propName$1));
    }

    public DynamicNumNetworkThreadsTest() {
        this.internal = "PLAINTEXT";
        this.external = "EXTERNAL";
    }
}

