/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLogTest$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.SegmentPosition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchBuilder;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0001\r=a\u0001B\"E\u0005%CQ\u0001\u0015\u0001\u0005\u0002EC\u0011\u0002\u0016\u0001A\u0002\u0003\u0007I\u0011A+\t\u0013y\u0003\u0001\u0019!a\u0001\n\u0003y\u0006\"C3\u0001\u0001\u0004\u0005\t\u0015)\u0003W\u0011\u001d1\u0007A1A\u0005\u0002\u001dDa!\u001e\u0001!\u0002\u0013A\u0007\"\u0002<\u0001\t\u00039\bBBA\u0004\u0001\u0011\u0005q\u000f\u0003\u0004\u0002\u0012\u0001!\ta\u001e\u0005\u0007\u00037\u0001A\u0011A<\t\r\u0005}\u0001\u0001\"\u0001x\u0011\u0019\t\u0019\u0003\u0001C\u0001o\"1\u0011q\u0005\u0001\u0005\u0002]Da!a\u000b\u0001\t\u00039\bBBA\u0018\u0001\u0011\u0005q\u000f\u0003\u0004\u00024\u0001!\ta\u001e\u0005\u0007\u0003o\u0001A\u0011A<\t\r\u0005m\u0002\u0001\"\u0001x\u0011\u0019\ty\u0004\u0001C\u0001o\"1\u00111\t\u0001\u0005\u0002]Da!a\u0012\u0001\t\u00039\bBBA&\u0001\u0011\u0005q\u000f\u0003\u0004\u0002P\u0001!\ta\u001e\u0005\u0007\u0003'\u0002A\u0011A<\t\r\u0005]\u0003\u0001\"\u0001x\u0011\u0019\tY\u0006\u0001C\u0001o\"1\u0011q\f\u0001\u0005\u0002]Dq!a\u0019\u0001\t\u0013\t)\u0007C\u0004\u0002l\u0001!I!!\u001c\t\r\u0005\u0005\u0005\u0001\"\u0001x\u0011\u0019\t)\t\u0001C\u0001o\"1\u0011\u0011\u0012\u0001\u0005\u0002]Da!!$\u0001\t\u00039\bBBAI\u0001\u0011\u0005q\u000f\u0003\u0004\u0002\u0016\u0002!\ta\u001e\u0005\b\u00033\u0003A\u0011BAN\u0011\u0019\ty\f\u0001C\u0001o\"1\u00111\u0019\u0001\u0005\u0002]Da!a2\u0001\t\u00039\bBBAf\u0001\u0011\u0005q\u000f\u0003\u0004\u0002P\u0002!\ta\u001e\u0005\u0007\u0003'\u0004A\u0011A<\t\r\u0005]\u0007\u0001\"\u0001x\u0011\u0019\tY\u000e\u0001C\u0001o\"1\u0011q\u001c\u0001\u0005\u0002]Da!a9\u0001\t\u00039\bBBAt\u0001\u0011\u0005q\u000f\u0003\u0004\u0002l\u0002!\ta\u001e\u0005\u0007\u0003_\u0004A\u0011A<\b\u000f\u0005MH\t#\u0001\u0002v\u001a11\t\u0012E\u0001\u0003oDa\u0001U\u001a\u0005\u0002\u0005ehABA~g\u0001\ti\u0010\u0003\u0004Qk\u0011\u0005!Q\u0005\u0005\b\u0003s+D\u0011\tB\u0016\u0011\u001d\u0011\t%\u000eC!\u0005\u0007BqAa\u00156\t\u0003\u0012)\u0006C\u0005\u0003fM\u0012\r\u0011\"\u0001\u0003h!A!qN\u001a!\u0002\u0013\u0011I\u0007C\u0004\u0003rM\"\tAa\u001d\t\u0013\tm5'%A\u0005\u0002\tu\u0005b\u0002BZg\u0011\u0005!Q\u0017\u0005\n\u0005{\u001b\u0014\u0013!C\u0001\u0005;CqAa04\t\u0003\u0011\t\rC\u0004\u0003@N\"\tAa7\t\u000f\t=8\u0007\"\u0003\u0003r\n!2*\u00194lC6+G/\u00193bi\u0006dun\u001a+fgRT!!\u0012$\u0002\tI\fg\r\u001e\u0006\u0002\u000f\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001K!\tYe*D\u0001M\u0015\u0005i\u0015!B:dC2\f\u0017BA(M\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0015\t\u0003'\u0002i\u0011\u0001R\u0001\bi\u0016l\u0007\u000fR5s+\u00051\u0006CA,]\u001b\u0005A&BA-[\u0003\tIwNC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uC&\u0001\u0002$jY\u0016\f1\u0002^3na\u0012K'o\u0018\u0013fcR\u0011\u0001m\u0019\t\u0003\u0017\u0006L!A\u0019'\u0003\tUs\u0017\u000e\u001e\u0005\bI\u000e\t\t\u00111\u0001W\u0003\rAH%M\u0001\ti\u0016l\u0007\u000fR5sA\u0005AQn\\2l)&lW-F\u0001i!\tI7/D\u0001k\u0015\tYG.\u0001\u0003vi&d'BA7o\u0003\u0019\u0019XM\u001d<fe*\u0011qi\u001c\u0006\u0003aF\fa!\u00199bG\",'\"\u0001:\u0002\u0007=\u0014x-\u0003\u0002uU\nAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fA\u0005)1/\u001a;VaR\t\u0001\r\u000b\u0002\bsB\u0019!0a\u0001\u000e\u0003mT!\u0001`?\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u007f\u007f\u00069!.\u001e9ji\u0016\u0014(bAA\u0001c\u0006)!.\u001e8ji&\u0019\u0011QA>\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\rA\u00111\u0002\t\u0004u\u00065\u0011bAA\bw\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u000bi\u0016\u001cHoQ8oM&<\u0007fA\u0005\u0002\u0016A\u0019!0a\u0006\n\u0007\u0005e1P\u0001\u0003UKN$\u0018A\u0007;fgR,f.\u001a=qK\u000e$X\rZ!qa\u0016tGm\u00144gg\u0016$\bf\u0001\u0006\u0002\u0016\u0005\u0011B/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8uQ\rY\u0011QC\u0001 i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|GO\u0012:p[\u0016sGm\u00144gg\u0016$\bf\u0001\u0007\u0002\u0016\u0005AC/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u\u0019\u0006$XM\u001d+iC:D\u0015n\u001a5XCR,'/\\1sW\"\u001aQ\"!\u0006\u0002AQ,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e^'vG\"d\u0015\r^3s\u000bB|7\r\u001b\u0015\u0004\u001d\u0005U\u0011a\b;fgRD\u0015n\u001a5XCR,'/\\1sW>3gm]3u\u001b\u0016$\u0018\rZ1uC\"\u001aq\"!\u0006\u0002MQ,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e\u001e\"fM>\u0014X\rT8h'R\f'\u000f^(gMN,G\u000fK\u0002\u0011\u0003+\t\u0001\u0005^3ti\u000e\u0013X-\u0019;f':\f\u0007o\u001d5pi\u0012Kg/\u001a:hS:<W\t]8dQ\"\u001a\u0011#!\u0006\u00029Q,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e^(mI\u0016\u0014X\t]8dQ\"\u001a!#!\u0006\u0002EQ,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e^,ji\"l\u0015n]:j]\u001e,\u0005o\\2iQ\r\u0019\u0012QC\u0001\u001bi\u0016\u001cHo\u0011:fCR,W\t_5ti&twm\u00158baNDw\u000e\u001e\u0015\u0004)\u0005U\u0011a\u0003;fgR$v\u000e]5d\u0013\u0012D3!FA\u000b\u0003]!Xm\u001d;SK\u0006$W*[:tS:<7K\\1qg\"|G\u000fK\u0002\u0017\u0003+\tQ\u0004^3ti\u0012+G.\u001a;f\u001d>tW\t_5ti\u0016tGo\u00158baNDw\u000e\u001e\u0015\u0004/\u0005U\u0011!\t;fgR$&/\u001e8dCR,g)\u001e7msR{G*\u0019;fgR\u001cf.\u00199tQ>$\bf\u0001\r\u0002\u0016\u0005\u0019C/Z:u)J,hnY1uK^KG\u000e\u001c*f[>4Xm\u00147eKJ\u001cf.\u00199tQ>$\bfA\r\u0002\u0016\u0005\u0019C/Z:u'R\f'\u000f^;q/&$\b.\u00138wC2LGm\u00158baNDw\u000e^*uCR,\u0007f\u0001\u000e\u0002\u0016\u0005aC/Z:u':\f\u0007o\u001d5pi\u0012+G.\u001a;j_:<\u0016\u000e\u001e5J]Z\fG.\u001b3T]\u0006\u00048\u000f[8u'R\fG/\u001a\u0015\u00047\u0005U\u0011AD7fi\u0006$\u0017\r^1M_\u001e$\u0015N\u001d\u000b\u0004-\u0006\u001d\u0004BBA59\u0001\u0007a+\u0001\u0004m_\u001e$\u0015N]\u0001\u0013oJLG/Z#naRL8K\\1qg\"|G\u000fF\u0003a\u0003_\n\u0019\b\u0003\u0004\u0002ru\u0001\rAV\u0001\f[\u0016$\u0018\rZ1uC\u0012K'\u000fC\u0004\u0002vu\u0001\r!a\u001e\u0002\u0015Mt\u0017\r]:i_RLE\r\u0005\u0003\u0002z\u0005uTBAA>\u0015\t)e.\u0003\u0003\u0002\u0000\u0005m$AD(gMN,G/\u00118e\u000bB|7\r[\u0001\u0018i\u0016\u001cH\u000fR8fg:$HK];oG\u0006$XMR;mYfD3AHA\u000b\u0003m!Xm\u001d;DY\u0016\fg.\u001e9QCJ$\u0018.\u00197T]\u0006\u00048\u000f[8ug\"\u001aq$!\u0006\u00023Q,7\u000f^\"mK\u0006tW\u000f](mI\u0016\u00148K\\1qg\"|Go\u001d\u0015\u0004A\u0005U\u0011!\n;fgR\u001c%/Z1uKJ+\u0007\u000f\\5dCR,G\rT8h)J,hnY1uKN4U\u000f\u001c7zQ\r\t\u0013QC\u0001\u0011i\u0016\u001cH/T1y\u0005\u0006$8\r[*ju\u0016D3AIA\u000b\u0003y!Xm\u001d;UeVt7-\u0019;f\u0005\u0016dwn\u001e%jO\"<\u0016\r^3s[\u0006\u00148\u000eK\u0002$\u0003+\taBY;jY\u00124U\u000f\u001c7CCR\u001c\u0007\u000e\u0006\u0005\u0002\u001e\u00065\u0016qWA^!\u0011\ty*!+\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000baA]3d_J$'bAAT]\u000611m\\7n_:LA!a+\u0002\"\niQ*Z7pef\u0014VmY8sINDq!a,%\u0001\u0004\t\t,A\u0006mK\u0006$WM]#q_\u000eD\u0007cA&\u00024&\u0019\u0011Q\u0017'\u0003\u0007%sG\u000fC\u0004\u0002:\u0012\u0002\r!!-\u0002\u0015I,7m\u001c:e'&TX\rC\u0004\u0002>\u0012\u0002\r!!-\u0002'5\f\u0007PQ1uG\"\u001c\u0016N_3J]\nKH/Z:\u0002UQ,7\u000f\u001e,bY&$\u0017\r^3Fa>\u001c\u0007n\u0012:fCR,'\u000f\u00165b]2\u000b7\u000f^&o_^tW\t]8dQ\"\u001aQ%!\u0006\u0002YQ,7\u000f\u001e,bY&$\u0017\r^3Fa>\u001c\u0007\u000eT3tgRC\u0017M\\(mI\u0016\u001cHo\u00158baNDw\u000e^#q_\u000eD\u0007f\u0001\u0014\u0002\u0016\u0005qC/Z:u-\u0006d\u0017\u000eZ1uK>3gm]3u\u0019\u0016\u001c8\u000f\u00165b]>cG-Z:u':\f\u0007o\u001d5pi>3gm]3uQ\r9\u0013QC\u0001.i\u0016\u001cHOV1mS\u0012\fG/Z(gMN,G/R9vC2$vn\u00147eKN$8K\\1qg\"|Go\u00144gg\u0016$\bf\u0001\u0015\u0002\u0016\u0005\u0011E/Z:u-\u0006d\u0017\u000eZ1uKVs7N\\8x]\u0016\u0003xn\u00195MKN\u001cH\u000b[1o\u0019\u0006\u001cHo\u00138po:<%/Z1uKJ$\u0006.\u00198PY\u0012,7\u000f^*oCB\u001c\bn\u001c;)\u0007%\n)\"\u0001\u0015uKN$h+\u00197jI\u0006$X-\u00129pG\"dUm]:UQ\u0006tg)\u001b:ti\u0016\u0003xn\u00195J]2{w\rK\u0002+\u0003+\tA\u0005^3tiZ\u000bG.\u001b3bi\u0016|eMZ:fi\u001e\u0013X-\u0019;UQ\u0006tWI\u001c3PM\u001a\u001cX\r\u001e\u0015\u0004W\u0005U\u0011!\b;fgR4\u0016\r\\5eCR,wJ\u001a4tKRdUm]:UQ\u0006tG*R()\u00071\n)\"A\u0010uKN$h+\u00197jI\u0006$XMV1mS\u0012,\u0005o\\2i\u0003:$wJ\u001a4tKRD3!LA\u000b\u0003\u0019\"Xm\u001d;BIZ\fgnY3M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;BMR,'o\u00117fC:Lgn\u001a\u0015\u0004]\u0005U\u0011a\u0005;fgR$U\r\\3uKNs\u0017\r]:i_R\u001c\bfA\u0018\u0002\u0016\u00051B/Z:u'>4GOU3uK:$\u0018n\u001c8MS6LG\u000fK\u00021\u0003+\t!\u0005^3tiN+w-\\3oiNdUm]:UQ\u0006tG*\u0019;fgR\u001cf.\u00199tQ>$\bfA\u0019\u0002\u0016\u0005!2*\u00194lC6+G/\u00193bi\u0006dun\u001a+fgR\u0004\"aU\u001a\u0014\u0005MRECAA{\u00059\u0011\u0015\u0010^3BeJ\f\u0017pU3sI\u0016\u001cR!NA\u0000\u0005\u0017\u0001BA!\u0001\u0003\b5\u0011!1\u0001\u0006\u0004\u0005\u000bQ\u0016\u0001\u00027b]\u001eLAA!\u0003\u0003\u0004\t1qJ\u00196fGR\u0004bA!\u0004\u0003\u0016\teQB\u0001B\b\u0015\u0011\u0011\tBa\u0005\u0002\u001bM,'/[1mSj\fG/[8o\u0015\r\t9\u000b\\\u0005\u0005\u0005/\u0011yAA\u0006SK\u000e|'\u000fZ*fe\u0012,\u0007#B&\u0003\u001c\t}\u0011b\u0001B\u000f\u0019\n)\u0011I\u001d:bsB\u00191J!\t\n\u0007\t\rBJ\u0001\u0003CsR,GC\u0001B\u0014!\r\u0011I#N\u0007\u0002gQ1\u0011\u0011\u0017B\u0017\u0005cAqAa\f8\u0001\u0004\u0011I\"\u0001\u0003eCR\f\u0007b\u0002B\u001ao\u0001\u0007!QG\u0001\u0013g\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8DC\u000eDW\r\u0005\u0003\u00038\tuRB\u0001B\u001d\u0015\u0011\u0011Y$!*\u0002\u0011A\u0014x\u000e^8d_2LAAa\u0010\u0003:\tArJ\u00196fGR\u001cVM]5bY&T\u0018\r^5p]\u000e\u000b7\r[3\u0002\u000b]\u0014\u0018\u000e^3\u0015\u000f\u0001\u0014)Ea\u0012\u0003J!9!q\u0006\u001dA\u0002\te\u0001b\u0002B\u001aq\u0001\u0007!Q\u0007\u0005\b\u0005\u0017B\u0004\u0019\u0001B'\u0003\ryW\u000f\u001e\t\u0005\u0005o\u0011y%\u0003\u0003\u0003R\te\"\u0001C,sSR\f'\r\\3\u0002\tI,\u0017\r\u001a\u000b\u0007\u00053\u00119F!\u0019\t\u000f\te\u0013\b1\u0001\u0003\\\u0005)\u0011N\u001c9viB!!q\u0007B/\u0013\u0011\u0011yF!\u000f\u0003\u0011I+\u0017\rZ1cY\u0016DqAa\u0019:\u0001\u0004\t\t,\u0001\u0003tSj,\u0017\u0001\u0007#fM\u0006,H\u000e^'fi\u0006$\u0017\r^1M_\u001e\u001cuN\u001c4jOV\u0011!\u0011\u000e\t\u0004'\n-\u0014b\u0001B7\t\n\tR*\u001a;bI\u0006$\u0018\rT8h\u0007>tg-[4\u00023\u0011+g-Y;mi6+G/\u00193bi\u0006dunZ\"p]\u001aLw\rI\u0001\u0017EVLG\u000eZ'fi\u0006$\u0017\r^1M_\u001e\fe\u000e\u001a#jeRA!Q\u000fBI\u0005'\u00139\nE\u0005L\u0005o\u0012YHa#\u0003j%\u0019!\u0011\u0010'\u0003\rQ+\b\u000f\\34!\u0011\u0011iHa\"\u000e\u0005\t}$\u0002\u0002BA\u0005\u0007\u000bAAZ5mK*\u0019!Q\u0011.\u0002\u00079Lw.\u0003\u0003\u0003\n\n}$\u0001\u0002)bi\"\u00042a\u0015BG\u0013\r\u0011y\t\u0012\u0002\u0011\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001eDQ\u0001\u0016\u001fA\u0002YCaA!&=\u0001\u0004A\u0017\u0001\u0002;j[\u0016D\u0011B!'=!\u0003\u0005\rA!\u001b\u0002#5,G/\u00193bi\u0006dunZ\"p]\u001aLw-\u0001\u0011ck&dG-T3uC\u0012\fG/\u0019'pO\u0006sG\rR5sI\u0011,g-Y;mi\u0012\u001aTC\u0001BPU\u0011\u0011IG!),\u0005\t\r\u0006\u0003\u0002BS\u0005_k!Aa*\u000b\t\t%&1V\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!,M\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005c\u00139KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001CY;jY\u0012lU\r^1eCR\fGj\\4\u0015\u0011\t-%q\u0017B]\u0005wCQ\u0001\u0016 A\u0002YCaA!&?\u0001\u0004A\u0007\"\u0003BM}A\u0005\t\u0019\u0001B5\u0003i\u0011W/\u001b7e\u001b\u0016$\u0018\rZ1uC2{w\r\n3fM\u0006,H\u000e\u001e\u00134\u0003\u0019\t\u0007\u000f]3oIRA!1\u0019Be\u0005'\u00149\u000e\u0005\u0003\u0002z\t\u0015\u0017\u0002\u0002Bd\u0003w\u0012Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007b\u0002Bf\u0001\u0002\u0007!QZ\u0001\u0004Y><\u0007\u0003BA=\u0005\u001fLAA!5\u0002|\ti!+\u001a9mS\u000e\fG/\u001a3M_\u001eDqA!6A\u0001\u0004\t\t,A\bok6\u0014WM](g%\u0016\u001cwN\u001d3t\u0011\u001d\u0011I\u000e\u0011a\u0001\u0003c\u000bQ!\u001a9pG\"$R\u0001\u0019Bo\u0005[DqAa8B\u0001\u0004\u0011\t/\u0001\bt]\u0006\u00048\u000f[8u/JLG/\u001a:\u0011\t\t\r(\u0011^\u0007\u0003\u0005KT1Aa:o\u0003!\u0019h.\u00199tQ>$\u0018\u0002\u0002Bv\u0005K\u0014\u0011CU1x':\f\u0007o\u001d5pi^\u0013\u0018\u000e^3s\u0011\u001d\u0011).\u0011a\u0001\u0003c\u000b!c\u0019:fCR,Gj\\4ESJ,7\r^8ssR)aKa=\u0003v\"1\u0011\u0011\u000e\"A\u0002YCqAa>C\u0001\u0004\u0011I0\u0001\u0006m_\u001e$\u0015N\u001d(b[\u0016\u0004BAa?\u0004\n9!!Q`B\u0003!\r\u0011y\u0010T\u0007\u0003\u0007\u0003Q1aa\u0001I\u0003\u0019a$o\\8u}%\u00191q\u0001'\u0002\rA\u0013X\rZ3g\u0013\u0011\u0019Ya!\u0004\u0003\rM#(/\u001b8h\u0015\r\u00199\u0001\u0014")
public final class KafkaMetadataLogTest {
    private File tempDir;
    private final MockTime mockTime = new MockTime();

    public static void append(RawSnapshotWriter rawSnapshotWriter, int n) {
        KafkaMetadataLogTest$.MODULE$.append(rawSnapshotWriter, n);
    }

    public static LogAppendInfo append(ReplicatedLog replicatedLog, int n, int n2) {
        return KafkaMetadataLogTest$.MODULE$.append(replicatedLog, n, n2);
    }

    public static MetadataLogConfig buildMetadataLog$default$3() {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3();
    }

    public static KafkaMetadataLog buildMetadataLog(File file, MockTime mockTime, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLog(file, mockTime, metadataLogConfig);
    }

    public static MetadataLogConfig buildMetadataLogAndDir$default$3() {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3();
    }

    public static Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> buildMetadataLogAndDir(File file, MockTime mockTime, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(file, mockTime, metadataLogConfig);
    }

    public static MetadataLogConfig DefaultMetadataLogConfig() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    @BeforeEach
    public void setUp() {
        this.tempDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tempDir());
    }

    @Test
    public void testConfig() {
        Properties props = new Properties();
        props.put("process.roles", Arrays.asList((Object[])new String[]{"broker"}));
        props.put("controller.quorum.voters", "1@localhost:9093");
        props.put("node.id", BoxesRunTime.boxToInteger((int)2));
        props.put("controller.listener.names", "SSL");
        props.put("metadata.log.segment.bytes", BoxesRunTime.boxToInteger((int)10240));
        props.put("metadata.log.segment.ms", BoxesRunTime.boxToInteger((int)10240));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply(kafkaConfig, 0x800000, 0x800000);
            KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
        });
        props.put("metadata.log.segment.min.bytes", BoxesRunTime.boxToInteger((int)10240));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply(kafkaConfig, 0x800000, 0x800000);
        KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
    }

    @Test
    public void testUnexpectedAppendOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        SimpleRecord recordFoo = new SimpleRecord("foo".getBytes());
        int currentEpoch = 3;
        long initialOffset = log.endOffset().offset;
        log.appendAsLeader((Records)MemoryRecords.withRecords((long)initialOffset, (Compression)Compression.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo}), currentEpoch);
        Assertions.assertThrows(RuntimeException.class, () -> log.appendAsLeader((Records)MemoryRecords.withRecords((long)initialOffset, (Compression)Compression.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo}), currentEpoch));
        Assertions.assertThrows(RuntimeException.class, () -> log.appendAsFollower((Records)MemoryRecords.withRecords((long)initialOffset, (Compression)Compression.NONE, (Integer)Predef$.MODULE$.int2Integer(currentEpoch), (SimpleRecord[])new SimpleRecord[]{recordFoo})));
    }

    @Test
    public void testCreateSnapshot() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshot(snapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Assertions.assertEquals((long)0L, (long)((RawSnapshotReader)log.readSnapshot(snapshotId).get()).sizeInBytes());
    }

    @Test
    public void testCreateSnapshotFromEndOffset() {
        int numberOfRecords = 10;
        int firstEpoch = 1;
        int secondEpoch = 3;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)(2 * numberOfRecords)));
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords - 1), firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch(1L, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords - 1), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), secondEpoch)).get()).close();
    }

    @Test
    public void testCreateSnapshotLaterThanHighWatermark() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), epoch)));
    }

    @Test
    public void testCreateSnapshotMuchLaterEpoch() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, epoch + 1)));
    }

    @Test
    public void testHighWatermarkOffsetMetadata() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        LogOffsetMetadata highWatermarkMetadata = log.highWatermark();
        Assertions.assertEquals((long)numberOfRecords, (long)highWatermarkMetadata.offset);
        Assertions.assertTrue((boolean)highWatermarkMetadata.metadata.isPresent());
        SegmentPosition segmentPosition = (SegmentPosition)highWatermarkMetadata.metadata.get();
        Assertions.assertEquals((long)0L, (long)segmentPosition.baseOffset());
        Assertions.assertTrue((segmentPosition.relativePosition() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSnapshotBeforeLogStartOffset() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 4), epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshot(snapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        log.log().maybeIncrementLogStartOffset(snapshotId.offset() - 1L, LogStartOffsetIncrementReason.SegmentDeletion);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset() - 2L, snapshotId.epoch())));
    }

    @Test
    public void testCreateSnapshotDivergingEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    @Test
    public void testCreateSnapshotOlderEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshot(snapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    @Test
    public void testCreateSnapshotWithMissingEpoch() {
        int firstBatchRecords = 5;
        int firstEpoch = 1;
        int missingEpoch = firstEpoch + 1;
        int secondBatchRecords = 5;
        int secondEpoch = missingEpoch + 1;
        int numberOfRecords = firstBatchRecords + secondBatchRecords;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, firstBatchRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, secondBatchRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(1L, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)firstBatchRecords, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)secondBatchRecords, missingEpoch)));
    }

    @Test
    public void testCreateExistingSnapshot() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshot(snapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(snapshotId), (String)"Creating an existing snapshot should not do anything");
    }

    @Test
    public void testTopicId() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopicId(), (Object)log.topicId());
    }

    @Test
    public void testReadMissingSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals(Optional.empty(), (Object)log.readSnapshot(new OffsetAndEpoch(10L, 0)));
    }

    @Test
    public void testDeleteNonExistentSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int offset = 10;
        int epoch = 0;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        Assertions.assertFalse((boolean)log.deleteBeforeSnapshot(new OffsetAndEpoch(2L, epoch)));
        Assertions.assertEquals((long)0L, (long)log.startOffset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)offset, (long)log.highWatermark().offset);
    }

    @Test
    public void testTruncateFullyToLatestSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 0;
        OffsetAndEpoch sameEpochSnapshotId = new OffsetAndEpoch((long)(2 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshotUnchecked(sameEpochSnapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)sameEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.endOffset().offset);
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.highWatermark().offset);
        OffsetAndEpoch greaterEpochSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshotUnchecked(greaterEpochSnapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)greaterEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.endOffset().offset);
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.highWatermark().offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateWillRemoveOlderSnapshot() {
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        void logDir2 = var2_2;
        void log2 = var3_3;
        void config2 = var4_4;
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        Using$.MODULE$.apply(() -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$1((KafkaMetadataLog)log2, oldSnapshotId1), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        Using$.MODULE$.apply(() -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$3((KafkaMetadataLog)log2, oldSnapshotId2), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        Using$.MODULE$.apply(() -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$5((KafkaMetadataLog)log2, oldSnapshotId3), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords, epoch);
        Using$.MODULE$.apply(() -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$7((KafkaMetadataLog)log2, greaterSnapshotId), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Assertions.assertNotEquals((Object)log2.earliestSnapshotId(), (Object)log2.latestSnapshotId());
        Assertions.assertTrue((boolean)log2.truncateToLatestSnapshot());
        Assertions.assertEquals((Object)log2.earliestSnapshotId(), (Object)log2.latestSnapshotId());
        log2.close();
        this.mockTime().sleep(config2.fileDeleteDelayMs());
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$2 -> x$2.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$11((KafkaMetadataLog)log2, arg_0));
    }

    @Test
    public void testStartupWithInvalidSnapshotState() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        UnifiedLog qual$1 = log.log();
        long x$1 = 100L;
        Option x$2 = qual$1.truncateFullyAndStartAt$default$2();
        qual$1.truncateFullyAndStartAt(x$1, x$2);
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(50L, 1));
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(100L, 1));
        log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        UnifiedLog qual$2 = log.log();
        long x$3 = 200L;
        Option x$4 = qual$2.truncateFullyAndStartAt$default$2();
        qual$2.truncateFullyAndStartAt(x$3, x$4);
        log.close();
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(500L, 1));
        log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((long)500L, (long)log.log().logStartOffset());
    }

    @Test
    public void testSnapshotDeletionWithInvalidSnapshotState() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        log.log().truncateFullyAndStartAt(100L, log.log().truncateFullyAndStartAt$default$2());
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(100L, 1);
        this.writeEmptySnapshot(metadataDir, snapshotId);
        Path deletedPath = Snapshots.markForDelete((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId);
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3()));
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
    }

    private File metadataLogDir(File logDir) {
        return new File(logDir.getAbsolutePath(), UnifiedLog$.MODULE$.logDirName(KafkaRaftServer$.MODULE$.MetadataPartition()));
    }

    private void writeEmptySnapshot(File metadataDir, OffsetAndEpoch snapshotId) {
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FileRawSnapshotWriter.create((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId), (Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testDoesntTruncateFully() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderEpochSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch - 1);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshotUnchecked(olderEpochSnapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderOffsetSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshotUnchecked(olderOffsetSnapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupPartialSnapshots() {
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        void logDir2 = var2_2;
        void log2 = var3_3;
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(1L, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords, epoch);
        Using$.MODULE$.apply(() -> KafkaMetadataLogTest.$anonfun$testCleanupPartialSnapshots$1((KafkaMetadataLog)log2, snapshotId), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        log2.close();
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(0L, epoch - 1));
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(1L, epoch));
        Snapshots.createTempFile((Path)logDir2, (OffsetAndEpoch)new OffsetAndEpoch(2L, epoch + 1));
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)0L, (long)log2.startOffset());
        Assertions.assertEquals((int)epoch, (int)log2.lastFetchedEpoch());
        Assertions.assertEquals((long)numberOfRecords, (long)log2.endOffset().offset);
        Assertions.assertEquals((long)0L, (long)secondLog.highWatermark().offset);
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$5 -> x$5.isPresent()).forEach(path -> Assertions.assertFalse((boolean)((SnapshotPath)path.get()).partial));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupOlderSnapshots() {
        void var4_4;
        void var3_3;
        void var2_2;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir$default$3());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        void logDir2 = var2_2;
        void log2 = var3_3;
        void config2 = var4_4;
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        Using$.MODULE$.apply(() -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$1((KafkaMetadataLog)log2, oldSnapshotId1), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        Using$.MODULE$.apply(() -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$3((KafkaMetadataLog)log2, oldSnapshotId2), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        Using$.MODULE$.apply(() -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$5((KafkaMetadataLog)log2, oldSnapshotId3), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log2, numberOfRecords, epoch);
        Using$.MODULE$.apply(() -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$7((KafkaMetadataLog)log2, greaterSnapshotId), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        log2.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((Object)greaterSnapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)(3 * numberOfRecords), (long)secondLog.startOffset());
        Assertions.assertEquals((int)epoch, (int)secondLog.lastFetchedEpoch());
        this.mockTime().sleep(config2.fileDeleteDelayMs());
        Files.walk((Path)logDir2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$7 -> x$7.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$11((KafkaMetadataLog)log2, arg_0));
    }

    @Test
    public void testCreateReplicatedLogTruncatesFully() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords + 1), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshotUnchecked(snapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        log.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.startOffset());
        Assertions.assertEquals((int)snapshotId.epoch(), (int)secondLog.lastFetchedEpoch());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.endOffset().offset);
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.highWatermark().offset);
    }

    @Test
    public void testMaxBatchSize() {
        int leaderEpoch = 5;
        int maxBatchSizeInBytes = 16384;
        int recordSize = 64;
        int x$2 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$1();
        int x$3 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$2();
        long x$4 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$3();
        long x$5 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$4();
        long x$6 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$5();
        int x$7 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7();
        long x$8 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8();
        int x$9 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9();
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(x$2, x$3, x$4, x$5, x$6, maxBatchSizeInBytes, x$7, x$8, x$9));
        MemoryRecords oversizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes + recordSize);
        Assertions.assertThrows(RecordTooLargeException.class, () -> log.appendAsLeader((Records)oversizeBatch, leaderEpoch));
        MemoryRecords undersizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes);
        LogAppendInfo appendInfo = log.appendAsLeader((Records)undersizeBatch, leaderEpoch);
        Assertions.assertEquals((long)0L, (long)appendInfo.firstOffset);
    }

    @Test
    public void testTruncateBelowHighWatermark() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numRecords = 10;
        int epoch = 5;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numRecords, epoch);
        Assertions.assertEquals((long)numRecords, (long)log.endOffset().offset);
        log.updateHighWatermark(new LogOffsetMetadata((long)numRecords));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.truncateTo(5L));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
    }

    private MemoryRecords buildFullBatch(int leaderEpoch, int recordSize, int maxBatchSizeInBytes) {
        ByteBuffer buffer = ByteBuffer.allocate(maxBatchSizeInBytes);
        BatchBuilder batchBuilder = new BatchBuilder(buffer, (RecordSerde)new ByteArraySerde(), (Compression)Compression.NONE, 0L, this.mockTime().milliseconds(), false, leaderEpoch, maxBatchSizeInBytes);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        List<byte[]> records = Collections.singletonList(new byte[recordSize]);
        while (!batchBuilder.bytesNeeded(records, serializationCache).isPresent()) {
            batchBuilder.appendRecord((Object)records.get(0), serializationCache);
        }
        return batchBuilder.build();
    }

    @Test
    public void testValidateEpochGreaterThanLastKnownEpoch() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch + 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateEpochLessThanOldestSnapshotEpoch() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshot(snapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch - 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanOldestSnapshotOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshot(snapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        log.log().maybeIncrementLogStartOffset((long)offset, LogStartOffsetIncrementReason.SegmentDeletion);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(offset - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetEqualToOldestSnapshotOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshot(snapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)offset, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot() {
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshotUnchecked(snapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 2);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 4);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 3);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(20L, 2), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateEpochLessThanFirstEpochInLog() {
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshotUnchecked(snapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 3);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 2);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetGreatThanEndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords + 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanLEO() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch + 1);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(11L, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(10L, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateValidEpochAndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.buildMetadataLog$default$3());
        int numberOfRecords = 5;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)(numberOfRecords - 1), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testAdvanceLogStartOffsetAfterCleaning() {
        MetadataLogConfig config = new MetadataLogConfig(512, 512, 10000L, 256L, 60000L, 512, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().maxFetchSizeInBytes(), 60000L, 1);
        config.copy(config.copy$default$1(), config.copy$default$2(), config.copy$default$3(), config.copy$default$4(), config.copy$default$5(), config.copy$default$6(), config.copy$default$7(), config.copy$default$8(), config.copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 47, 1));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since HW was still 0");
        log.updateHighWatermark(new LogOffsetMetadata(4000L));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since no snapshots exist");
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshotUnchecked(snapshotId1).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$3(snapshot);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshotUnchecked(snapshotId2).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$5(snapshot);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        long lsoBefore = log.startOffset();
        Assertions.assertTrue((boolean)log.maybeClean(), (String)"Expected to clean since there was at least one snapshot");
        long lsoAfter = log.startOffset();
        Assertions.assertTrue((lsoAfter > lsoBefore ? 1 : 0) != 0, (String)"Log Start Offset should have increased after cleaning");
        Assertions.assertTrue((lsoAfter == snapshotId2.offset() ? 1 : 0) != 0, (String)"Expected the Log Start Offset to be less than or equal to the snapshot offset");
    }

    @Test
    public void testDeleteSnapshots() {
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(1024, 1024, 10000L, 1024L, 60000L, 100, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach((Function1 & Serializable & scala.Serializable)_ -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(1001L));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 200, 300, 400, 500, 600}))).foreach((Function1 & Serializable & scala.Serializable)offset -> KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$2(log, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)6, (int)log.snapshotCount());
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected only one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$5((OffsetAndEpoch)assertOptional_optional.get());
        } else {
            Assertions.fail((String)"Missing value from Optional");
        }
        Assertions.assertEquals((long)log.startOffset(), (long)600L);
    }

    @Test
    public void testSoftRetentionLimit() {
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(10240, 10240, 10000L, 10240L, 60000L, 100, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable & scala.Serializable)_ -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(2000L));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshotUnchecked(snapshotId1).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3(snapshot);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshotUnchecked(snapshotId2).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$5(snapshot);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$6(log, config, offsetAndEpoch);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    @Test
    public void testSegmentsLessThanLatestSnapshot() {
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(10240, 10240, 10000L, 10240L, 60000L, 200, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable & scala.Serializable)_ -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 10, 1));
        log.updateHighWatermark(new LogOffsetMetadata(log.endOffset().offset));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(((LogSegment)((IterableLike)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(log.log().logSegments()).asScala()).drop(1)).head()).baseOffset(), 1);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshotUnchecked(snapshotId1).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(((LogSegment)((IterableLike)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(log.log().logSegments()).asScala()).drop(2)).head()).baseOffset(), 1);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log.createNewSnapshotUnchecked(snapshotId2).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            snapshot.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        long defaultLogRetentionMs = 1209600000L;
        this.mockTime().sleep(defaultLogRetentionMs);
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount());
        Assertions.assertTrue((log.startOffset() > 0L ? 1 : 0) != 0, (String)new StringBuilder(23).append(log.startOffset()).append(" must be greater than 0").toString());
        long latestSnapshotOffset = ((OffsetAndEpoch)log.latestSnapshotId().get()).offset();
        Assertions.assertTrue((latestSnapshotOffset >= log.startOffset() ? 1 : 0) != 0, (String)new StringBuilder(56).append("latest snapshot offset (").append(latestSnapshotOffset).append(") must be >= log start offset (").append(log.startOffset()).append(")").toString());
    }

    public static final /* synthetic */ RawSnapshotWriter $anonfun$testTruncateWillRemoveOlderSnapshot$1(KafkaMetadataLog log$11, OffsetAndEpoch oldSnapshotId1$1) {
        return (RawSnapshotWriter)log$11.createNewSnapshotUnchecked(oldSnapshotId1$1).get();
    }

    public static final /* synthetic */ RawSnapshotWriter $anonfun$testTruncateWillRemoveOlderSnapshot$3(KafkaMetadataLog log$11, OffsetAndEpoch oldSnapshotId2$1) {
        return (RawSnapshotWriter)log$11.createNewSnapshotUnchecked(oldSnapshotId2$1).get();
    }

    public static final /* synthetic */ RawSnapshotWriter $anonfun$testTruncateWillRemoveOlderSnapshot$5(KafkaMetadataLog log$11, OffsetAndEpoch oldSnapshotId3$1) {
        return (RawSnapshotWriter)log$11.createNewSnapshotUnchecked(oldSnapshotId3$1).get();
    }

    public static final /* synthetic */ RawSnapshotWriter $anonfun$testTruncateWillRemoveOlderSnapshot$7(KafkaMetadataLog log$11, OffsetAndEpoch greaterSnapshotId$1) {
        return (RawSnapshotWriter)log$11.createNewSnapshotUnchecked(greaterSnapshotId$1).get();
    }

    public static final /* synthetic */ void $anonfun$testTruncateWillRemoveOlderSnapshot$11(KafkaMetadataLog log$11, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset() < log$11.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ RawSnapshotWriter $anonfun$testCleanupPartialSnapshots$1(KafkaMetadataLog log$13, OffsetAndEpoch snapshotId$7) {
        return (RawSnapshotWriter)log$13.createNewSnapshotUnchecked(snapshotId$7).get();
    }

    public static final /* synthetic */ RawSnapshotWriter $anonfun$testCleanupOlderSnapshots$1(KafkaMetadataLog log$14, OffsetAndEpoch oldSnapshotId1$2) {
        return (RawSnapshotWriter)log$14.createNewSnapshotUnchecked(oldSnapshotId1$2).get();
    }

    public static final /* synthetic */ RawSnapshotWriter $anonfun$testCleanupOlderSnapshots$3(KafkaMetadataLog log$14, OffsetAndEpoch oldSnapshotId2$2) {
        return (RawSnapshotWriter)log$14.createNewSnapshotUnchecked(oldSnapshotId2$2).get();
    }

    public static final /* synthetic */ RawSnapshotWriter $anonfun$testCleanupOlderSnapshots$5(KafkaMetadataLog log$14, OffsetAndEpoch oldSnapshotId3$2) {
        return (RawSnapshotWriter)log$14.createNewSnapshotUnchecked(oldSnapshotId3$2).get();
    }

    public static final /* synthetic */ RawSnapshotWriter $anonfun$testCleanupOlderSnapshots$7(KafkaMetadataLog log$14, OffsetAndEpoch greaterSnapshotId$2) {
        return (RawSnapshotWriter)log$14.createNewSnapshotUnchecked(greaterSnapshotId$2).get();
    }

    public static final /* synthetic */ void $anonfun$testCleanupOlderSnapshots$11(KafkaMetadataLog log$14, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset() < log$14.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$5(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$4(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 10);
        snapshot.freeze();
    }

    public static final /* synthetic */ Try $anonfun$testDeleteSnapshots$2(KafkaMetadataLog log$24, int offset) {
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        return Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (RawSnapshotWriter)log$24.createNewSnapshotUnchecked(snapshotId).get(), (Function1 & Serializable & scala.Serializable)snapshot -> {
            KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$4(snapshot);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$5(OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)600L, (long)snapshotId.offset());
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$5(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$7(KafkaMetadataLog log$25, MetadataLogConfig config$1, RawSnapshotReader reader) {
        Assertions.assertTrue((reader.sizeInBytes() + log$25.log().size() > config$1.retentionMaxBytes() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$6(KafkaMetadataLog log$25, MetadataLogConfig config$1, OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)2000L, (long)snapshotId.offset(), (String)"Unexpected offset for latest snapshot");
        Optional assertOptional_optional = log$25.readSnapshot(snapshotId);
        if (assertOptional_optional.isPresent()) {
            RawSnapshotReader rawSnapshotReader = (RawSnapshotReader)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$7(log$25, config$1, rawSnapshotReader);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    public static class ByteArraySerde
    implements RecordSerde<byte[]> {
        public int recordSize(byte[] data, ObjectSerializationCache serializationCache) {
            return data.length;
        }

        public void write(byte[] data, ObjectSerializationCache serializationCache, Writable out) {
            out.writeByteArray(data);
        }

        public byte[] read(Readable input, int size) {
            return input.readArray(size);
        }
    }
}

