/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.List;
import java.util.UUID;
import kafka.server.KafkaConfig;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.security.authorizer.AclEntry;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-ga\u0002\u000f\u001e!\u0003\r\t\u0001\n\u0005\u0006W\u0001!\t\u0001\f\u0005\u0006=\u00011\t\u0001\r\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0011\u001d9\u0005A1A\u0005\u0002yBq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\nC\u0004T\u0001\t\u0007I\u0011\u0001+\t\u000fm\u0003!\u0019!C\u0001}!IA\f\u0001a\u0001\u0002\u0004%\t!\u0018\u0005\nG\u0002\u0001\r\u00111A\u0005\u0002\u0011D\u0011b\u001a\u0001A\u0002\u0003\u0007I\u0011\u00015\t\u0013=\u0004\u0001\u0019!a\u0001\n\u0003\u0001\b\"\u0003:\u0001\u0001\u0004\u0005\r\u0011\"\u0001t\u0011%I\b\u00011AA\u0002\u0013\u0005!\u0010C\u0003}\u0001\u0011\u0005A\u0006\u0003\u0004\u0002\u0012\u0001!\t\u0001\f\u0005\u0007\u0003+\u0001A\u0011\u0001\u0017\t\r\u0005e\u0001\u0001\"\u0001-\u0011\u0019\ti\u0002\u0001C\u0001Y!1\u0011\u0011\u0005\u0001\u0005\u00021Ba!!\n\u0001\t\u0003a\u0003BBA\u0015\u0001\u0011\u0005A\u0006\u0003\u0004\u0002.\u0001!\t\u0001\f\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011%\t9\u0006AI\u0001\n\u0003\tI\u0006C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r'A\u0005\"bg\u0016\fU\u000f\u001e5pe&TXM\u001d+fgRT!AH\u0010\u0002\u0015\u0005,H\u000f[8sSj,'O\u0003\u0002!C\u0005A1/Z2ve&$\u0018PC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\tQ\u0006\u0005\u0002']%\u0011qf\n\u0002\u0005+:LG/F\u00012!\t\u00114(D\u00014\u0015\tqBG\u0003\u00026m\u000511/\u001a:wKJT!AI\u001c\u000b\u0005aJ\u0014AB1qC\u000eDWMC\u0001;\u0003\ry'oZ\u0005\u0003yM\u0012!\"Q;uQ>\u0014\u0018N_3s\u0003)\u0019X\u000f]3s+N,'o]\u000b\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\u0005Y\u0006twMC\u0001E\u0003\u0011Q\u0017M^1\n\u0005\u0019\u000b%AB*ue&tw-\u0001\u0005vg\u0016\u0014h.Y7f\u0003%\u0001(/\u001b8dSB\fG.F\u0001K!\tY\u0015+D\u0001M\u0015\tie*\u0001\u0003bkRD'B\u0001\u0011P\u0015\t\u0001f'\u0001\u0004d_6lwN\\\u0005\u0003%2\u0013abS1gW\u0006\u0004&/\u001b8dSB\fG.\u0001\bsKF,Xm\u001d;D_:$X\r\u001f;\u0016\u0003U\u0003\"AV-\u000e\u0003]S!\u0001W(\u0002\u0011I,\u0017/^3tiNL!AW,\u0003\u001dI+\u0017/^3ti\u000e{g\u000e^3yi\u0006i1/\u001e9feV\u001bXM\u001d(b[\u0016\faaY8oM&<W#\u00010\u0011\u0005}\u000bW\"\u00011\u000b\u0005U\n\u0013B\u00012a\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0002.K\"9a-CA\u0001\u0002\u0004q\u0016a\u0001=%c\u0005y!p\\8LK\u0016\u0004XM]\"mS\u0016tG/F\u0001j!\tQW.D\u0001l\u0015\ta\u0017%A\u0005{_>\\W-\u001a9fe&\u0011an\u001b\u0002\u00105>|7*Z3qKJ\u001cE.[3oi\u0006\u0019\"p\\8LK\u0016\u0004XM]\"mS\u0016tGo\u0018\u0013fcR\u0011Q&\u001d\u0005\bM.\t\t\u00111\u0001j\u0003!\u0011Xm]8ve\u000e,W#\u0001;\u0011\u0005U<X\"\u0001<\u000b\u0005I|\u0015B\u0001=w\u0005=\u0011Vm]8ve\u000e,\u0007+\u0019;uKJt\u0017\u0001\u0004:fg>,(oY3`I\u0015\fHCA\u0017|\u0011\u001d1W\"!AA\u0002Q\fq\u0006^3ti\u0006+H\u000f[8sSj,')\u001f*fg>,(oY3UsB,W*\u001e7uSBdW-\u00113e\u0003:$'+Z7pm\u0016D#A\u0004@\u0011\u0007}\fi!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u000f\tI!A\u0004kkBLG/\u001a:\u000b\u0007\u0005-\u0011(A\u0003kk:LG/\u0003\u0003\u0002\u0010\u0005\u0005!\u0001\u0002+fgR\f!\t^3ti\u0006+H\u000f[8sSj,')\u001f*fg>,(oY3UsB,\u0017j]8mCRLwN\\+oe\u0016d\u0017\r^3e\t\u0016t\u0017pV8oi\u0012{W.\u001b8bi\u0016\fE\u000e\\8xQ\tya0\u0001\u0018uKN$\u0018)\u001e;i_JL'0\u001a\"z%\u0016\u001cx.\u001e:dKRK\b/\u001a#f]f$\u0016m[3t!J,7-\u001a3f]\u000e,\u0007F\u0001\t\u007f\u0003]\"Xm\u001d;BkRDwN]5{K\nK(+Z:pkJ\u001cW\rV=qKB\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,G)\u001a8z\t>l\u0017N\\1uK\"\u0012\u0011C`\u00018i\u0016\u001cH/Q;uQ>\u0014\u0018N_3CsJ+7o\\;sG\u0016$\u0016\u0010]3XS2$7-\u0019:e%\u0016\u001cx.\u001e:dK\u0012+g.\u001f#p[&t\u0017\r^3)\u0005Iq\u0018A\f;fgR\fU\u000f\u001e5pe&TXMQ=SKN|WO]2f)f\u0004XmV5uQ\u0006cGn\u00149fe\u0006$\u0018n\u001c8BG\u0016D#a\u0005@\u0002SQ,7\u000f^!vi\"|'/\u001b>f\u0005f\u0014Vm]8ve\u000e,G+\u001f9f/&$\b.\u00117m\u0011>\u001cH/Q2fQ\t!b0\u0001\u0018uKN$\u0018)\u001e;i_JL'0\u001a\"z%\u0016\u001cx.\u001e:dKRK\b/Z,ji\"\fE\u000e\u001c)sS:\u001c\u0017\u000e]1m\u0003\u000e,\u0007FA\u000b\u007f\u00035\"Xm\u001d;BkRDwN]5{K\nK(+Z:pkJ\u001cW\rV=qKN+\b/\u001a:Vg\u0016\u0014\b*Y:BG\u000e,7o\u001d\u0015\u0003-y\f\u0011C\\3x%\u0016\fX/Z:u\u0007>tG/\u001a=u)\u001d)\u0016QGA\u001c\u0003\u000fBQ\u0001S\fA\u0002)Cq!!\u000f\u0018\u0001\u0004\tY$A\u0007dY&,g\u000e^!eIJ,7o\u001d\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011I\"\u0002\u00079,G/\u0003\u0003\u0002F\u0005}\"aC%oKR\fE\r\u001a:fgND\u0011\"!\u0013\u0018!\u0003\u0005\r!a\u0013\u0002\r\u0005\u0004\u0018nS3z!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)\u001f\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002V\u0005=#aB!qS.+\u0017p]\u0001\u001c]\u0016<(+Z9vKN$8i\u001c8uKb$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005m#\u0006BA&\u0003;Z#!a\u0018\u0011\t\u0005\u0005\u00141N\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003S:\u0013AC1o]>$\u0018\r^5p]&!\u0011QNA2\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0018CV$\bn\u001c:ju\u0016\u0014\u0015PU3t_V\u00148-\u001a+za\u0016$\"\"a\u001d\u0002z\u0005m\u0014QPAG!\r1\u0013QO\u0005\u0004\u0003o:#a\u0002\"p_2,\u0017M\u001c\u0005\u0006=e\u0001\r!\r\u0005\u0006'f\u0001\r!\u0016\u0005\b\u0003\u007fJ\u0002\u0019AAA\u0003%y\u0007/\u001a:bi&|g\u000e\u0005\u0003\u0002\u0004\u0006%UBAAC\u0015\r\t9iT\u0001\u0004C\u000ed\u0017\u0002BAF\u0003\u000b\u0013A\"Q2m\u001fB,'/\u0019;j_:Dq!a$\u001a\u0001\u0004\t\t*\u0001\u0007sKN|WO]2f)f\u0004X\rE\u0002v\u0003'K1!!&w\u00051\u0011Vm]8ve\u000e,G+\u001f9f\u0003\u001d\tG\rZ!dYN$r!LAN\u0003;\u000bi\fC\u0003\u001f5\u0001\u0007\u0011\u0007C\u0004\u0002 j\u0001\r!!)\u0002\t\u0005\u001cWm\u001d\t\u0007\u0003G\u000b\t,a.\u000f\t\u0005\u0015\u0016Q\u0016\t\u0004\u0003O;SBAAU\u0015\r\tYkI\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=v%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\u000b)LA\u0002TKRT1!a,(!\u0011\t\u0019)!/\n\t\u0005m\u0016Q\u0011\u0002\u0013\u0003\u000e\u001cWm]:D_:$(o\u001c7F]R\u0014\u0018\u0010\u0003\u0004\u0002@j\u0001\r\u0001^\u0001\u0010e\u0016\u001cx.\u001e:dKB\u000bG\u000f^3s]\u0006Q!/Z7pm\u0016\f5\r\\:\u0015\u0011\u0005M\u0014QYAd\u0003\u0013DQAH\u000eA\u0002EBq!a(\u001c\u0001\u0004\t\t\u000b\u0003\u0004\u0002@n\u0001\r\u0001\u001e")
public interface BaseAuthorizerTest {
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq(String var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq(String var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(KafkaPrincipal var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq(RequestContext var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq(String var1);

    public Authorizer authorizer();

    public String superUsers();

    public String username();

    public KafkaPrincipal principal();

    public RequestContext requestContext();

    public String superUserName();

    public KafkaConfig config();

    public void config_$eq(KafkaConfig var1);

    public ZooKeeperClient zooKeeperClient();

    public void zooKeeperClient_$eq(ZooKeeperClient var1);

    public ResourcePattern resource();

    public void resource_$eq(ResourcePattern var1);

    public static /* synthetic */ void testAuthorizeByResourceTypeMultipleAddAndRemove$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeMultipleAddAndRemove();
    }

    @Test
    default public void testAuthorizeByResourceTypeMultipleAddAndRemove() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry denyRead = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowRead = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_2 -> {
            Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
            this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
            Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyRead}))), resource1);
                Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
                this.removeAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyRead}))), resource1);
                this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
                Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
            });
            this.removeAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
            Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
        });
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow();
    }

    @Test
    default public void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        KafkaPrincipal user2 = new KafkaPrincipal("User", "user2");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb2").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource3 = new ResourcePattern(ResourceType.GROUP, "s", PatternType.PREFIXED);
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl7 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl6, acl7}))), resource1);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl4}))), resource2);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), resource3);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u1h2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host2 should not have READ access to any consumer group");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TRANSACTIONAL_ID), (String)"User1 from host2 should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.CLUSTER), (String)"User1 from host2 should not have READ access to any topic");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should have READ access to at least one topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeDenyTakesPrecedence$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeDenyTakesPrecedence();
    }

    @Test
    default public void testAuthorizeByResourceTypeDenyTakesPrecedence() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.TOPIC), (String)"User1 from host1 should have WRITE access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.TOPIC), (String)"User1 from host1 should not have WRITE access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypePrefixedResourceDenyDominate$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypePrefixedResourceDenyDominate();
    }

    @Test
    default public void testAuthorizeByResourceTypePrefixedResourceDenyDominate() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern a = new ResourcePattern(ResourceType.GROUP, "a", PatternType.PREFIXED);
        ResourcePattern ab = new ResourcePattern(ResourceType.GROUP, "ab", PatternType.PREFIXED);
        ResourcePattern abc = new ResourcePattern(ResourceType.GROUP, "abc", PatternType.PREFIXED);
        ResourcePattern abcd = new ResourcePattern(ResourceType.GROUP, "abcd", PatternType.PREFIXED);
        ResourcePattern abcde = new ResourcePattern(ResourceType.GROUP, "abcde", PatternType.PREFIXED);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry allowAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), abcde);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 should have READ access to at least one group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), abcd);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should not have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), abc);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), a);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should not have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), ab);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 still should not have READ access to any group");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWildcardResourceDenyDominate$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWildcardResourceDenyDominate();
    }

    @Test
    default public void testAuthorizeByResourceTypeWildcardResourceDenyDominate() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern wildcard = new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL);
        ResourcePattern prefixed = new ResourcePattern(ResourceType.GROUP, "hello", PatternType.PREFIXED);
        ResourcePattern literal = new ResourcePattern(ResourceType.GROUP, "aloha", PatternType.LITERAL);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry allowAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry denyAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), prefixed);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 should have WRITE access to at least one group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), wildcard);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 now should not have WRITE access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), wildcard);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 still should not have WRITE access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), literal);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 still should not have WRITE access to any group");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllOperationAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllOperationAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllOperationAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry denyAll = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        AccessControlEntry allowAll = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyWrite = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWrite, allowAll}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAll}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllHostAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllHostAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllHostAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        String allHost = "*";
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb2").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry allowHost1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyHost1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry denyAllHost = new AccessControlEntry(user1.toString(), allHost, AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowAllHost = new AccessControlEntry(user1.toString(), allHost, AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u1h2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowHost1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllHost}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now shouldn't have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyHost1}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 still should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should not have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllHost}))), resource2);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllHost}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 now shouldn't have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllPrincipalAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllPrincipalAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllPrincipalAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        KafkaPrincipal user2 = new KafkaPrincipal("User", "user2");
        String allUser = AclEntry.WILDCARD_PRINCIPAL_STRING;
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb2").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry allowUser1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyUser1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry denyAllUser = new AccessControlEntry(allUser, host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowAllUser = new AccessControlEntry(allUser, host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u2h1Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowUser1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllUser}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now shouldn't have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyUser1}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 still should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 should not have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllUser}))), resource2);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllUser}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 now shouldn't have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeSuperUserHasAccess$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeSuperUserHasAccess();
    }

    @Test
    default public void testAuthorizeByResourceTypeSuperUserHasAccess() {
        AccessControlEntry denyAllAce = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.ALL, AclPermissionType.DENY);
        KafkaPrincipal superUser1 = new KafkaPrincipal("User", this.superUserName());
        InetAddress host1 = InetAddress.getByName("192.0.4.4");
        ResourcePattern allTopicsResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        ResourcePattern clusterResource = new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL);
        ResourcePattern groupResource = new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL);
        ResourcePattern transactionIdResource = new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "*", PatternType.LITERAL);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), allTopicsResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), clusterResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), groupResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), transactionIdResource);
        RequestContext superUserContext = this.newRequestContext(superUser1, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.TOPIC), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.CLUSTER), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.GROUP), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.TRANSACTIONAL_ID), (String)"superuser always has access, no matter what acls.");
    }

    public static /* synthetic */ RequestContext newRequestContext$(BaseAuthorizerTest $this, KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        return $this.newRequestContext(principal, clientAddress, apiKey);
    }

    default public RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        RequestHeader header = new RequestHeader(apiKey, 2, "", 1);
        return new RequestContext(header, "", clientAddress, principal, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, ClientInformation.EMPTY, false);
    }

    public static /* synthetic */ ApiKeys newRequestContext$default$3$(BaseAuthorizerTest $this) {
        return $this.newRequestContext$default$3();
    }

    default public ApiKeys newRequestContext$default$3() {
        return ApiKeys.PRODUCE;
    }

    public static /* synthetic */ boolean authorizeByResourceType$(BaseAuthorizerTest $this, Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        return $this.authorizeByResourceType(authorizer, requestContext, operation, resourceType);
    }

    default public boolean authorizeByResourceType(Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        AuthorizationResult authorizationResult = authorizer.authorizeByResourceType((AuthorizableRequestContext)requestContext, operation, resourceType);
        AuthorizationResult authorizationResult2 = AuthorizationResult.ALLOWED;
        return !(authorizationResult != null ? !authorizationResult.equals(authorizationResult2) : authorizationResult2 != null);
    }

    public static /* synthetic */ void addAcls$(BaseAuthorizerTest $this, Authorizer authorizer, Set aces, ResourcePattern resourcePattern) {
        $this.addAcls(authorizer, (Set<AccessControlEntry>)aces, resourcePattern);
    }

    default public void addAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = (Set)aces.map((Function1 & Serializable & scala.Serializable)ace -> new AclBinding(resourcePattern, ace), Set$.MODULE$.canBuildFrom());
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizer.createAcls((AuthorizableRequestContext)this.requestContext(), (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (AclCreateResult)x$1.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)result -> {
            BaseAuthorizerTest.$anonfun$addAcls$3(result);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ boolean removeAcls$(BaseAuthorizerTest $this, Authorizer authorizer, Set aces, ResourcePattern resourcePattern) {
        return $this.removeAcls(authorizer, (Set<AccessControlEntry>)aces, resourcePattern);
    }

    default public boolean removeAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = aces.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY)})) : (Set)aces.map((Function1 & Serializable & scala.Serializable)ace -> new AclBinding(resourcePattern, ace).toFilter(), Set$.MODULE$.canBuildFrom());
        return ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> (AclDeleteResult)x$2.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)BaseAuthorizerTest.$anonfun$removeAcls$3(result)));
    }

    public static /* synthetic */ void $anonfun$addAcls$3(AclCreateResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public static /* synthetic */ boolean $anonfun$removeAcls$3(AclDeleteResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
        result.aclBindingDeleteResults().forEach(r -> r.exception().ifPresent(e -> {
            throw e;
        }));
        return !result.aclBindingDeleteResults().isEmpty();
    }

    public static void $init$(BaseAuthorizerTest $this) {
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq("User:superuser1; User:superuser2");
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq("alice");
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(new KafkaPrincipal("User", $this.username()));
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq($this.newRequestContext($this.principal(), InetAddress.getByName("192.168.0.1"), $this.newRequestContext$default$3()));
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq("superuser1");
    }
}

