/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001B\u0015+\u0001=BQ\u0001\u000e\u0001\u0005\u0002UBqa\u000e\u0001A\u0002\u0013E\u0001\bC\u0004F\u0001\u0001\u0007I\u0011\u0003$\t\r=\u0003\u0001\u0015)\u0003:\u0011\u0015\u0001\u0006\u0001\"\u00159\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Daa\u001b\u0001!\u0002\u0013)\u0007b\u00027\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007[\u0002\u0001\u000b\u0011B3\t\u000f9\u0004!\u0019!C\u0005_\"1\u0001\u0010\u0001Q\u0001\nADq!\u001f\u0001C\u0002\u0013%q\u000e\u0003\u0004{\u0001\u0001\u0006I\u0001\u001d\u0005\bw\u0002\u0011\r\u0011\"\u0003p\u0011\u0019a\b\u0001)A\u0005a\"9Q\u0010\u0001b\u0001\n\u0013y\u0007B\u0002@\u0001A\u0003%\u0001\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003/\u0003A\u0011AAM\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!a-\u0001\t\u0013\t)\fC\u0005\u0002`\u0002\t\n\u0011\"\u0003\u0002b\"9\u0011q\u001f\u0001\u0005\n\u0005e\b\"\u0003B\u0006\u0001E\u0005I\u0011BAq\u0011\u001d\u0011i\u0001\u0001C\u0005\u0005\u001fAqAa\u0017\u0001\t\u0013\u0011i\u0006C\u0004\u0003b\u0001!IAa\u0019\t\u000f\t-\u0004\u0001\"\u0003\u0003n!9!q\u000e\u0001\u0005\n\tE\u0004b\u0002B<\u0001\u0011%!\u0011\u0010\u0005\b\u0005\u001f\u0003A\u0011\u0002BI\u0011\u001d\u00119\n\u0001C\u0005\u00053\u0013A%\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003W1\naa]3sm\u0016\u0014(\"A\u0017\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\r\t\u0003cIj\u0011AK\u0005\u0003g)\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"!\r\u0001\u0002'Q,7\u000f^'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0016\u0003e\u0002\"AO\"\u000e\u0003mR!\u0001P\u001f\u0002\r\r|W.\\8o\u0015\tYcH\u0003\u0002.\u007f)\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h\u0013\t!5HA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003]!Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8o?\u0012*\u0017\u000f\u0006\u0002H\u001bB\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n!QK\\5u\u0011\u001dq5!!AA\u0002e\n1\u0001\u001f\u00132\u0003Q!Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8oA\u0005yQ.\u001a;bI\u0006$\u0018MV3sg&|g.A\u0003tKR,\u0006\u000f\u0006\u0002H'\")AK\u0002a\u0001+\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002W;6\tqK\u0003\u0002Y3\u0006\u0019\u0011\r]5\u000b\u0005i[\u0016a\u00026va&$XM\u001d\u0006\u00039\u0006\u000bQA[;oSRL!AX,\u0003\u0011Q+7\u000f^%oM>D#A\u00021\u0011\u0005Y\u000b\u0017B\u00012X\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0014g\u0006dG/\u001a3QCN\u001cxo\u001c:e\u0005f$Xm]\u000b\u0002KB\u0019\u0001J\u001a5\n\u0005\u001dL%!B!se\u0006L\bC\u0001%j\u0013\tQ\u0017J\u0001\u0003CsR,\u0017\u0001F:bYR,G\rU1tg^|'\u000f\u001a\"zi\u0016\u001c\b%A\u0005tC2$()\u001f;fg\u0006Q1/\u00197u\u0005f$Xm\u001d\u0011\u0002\u000bU\u001cXM]\u0019\u0016\u0003A\u0004\"!\u001d<\u000e\u0003IT!a\u001d;\u0002\t1\fgn\u001a\u0006\u0002k\u0006!!.\u0019<b\u0013\t9(O\u0001\u0004TiJLgnZ\u0001\u0007kN,'/\r\u0011\u0002\u000bU\u001cXM\u001d\u001a\u0002\rU\u001cXM\u001d\u001a!\u0003\u0015)8/\u001a:4\u0003\u0019)8/\u001a:4A\u0005YQO\\6o_^tWk]3s\u00031)hn\u001b8po:,6/\u001a:!\u0003A!Xm\u001d;BYR,'OT8uQ&tw\rF\u0002H\u0003\u0007Aq!!\u0002\u0014\u0001\u0004\t9!\u0001\u0004rk>\u0014X/\u001c\t\u0005\u0003\u0013\t9B\u0004\u0003\u0002\f\u0005M\u0001cAA\u0007\u00136\u0011\u0011q\u0002\u0006\u0004\u0003#q\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0016%\u000ba\u0001\u0015:fI\u00164\u0017bA<\u0002\u001a)\u0019\u0011QC%)\u000fM\ti\"!\f\u00020A!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005\u001d\u0012,\u0001\u0004qCJ\fWn]\u0005\u0005\u0003W\t\tCA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003c\t)$\t\u0002\u00024\u0005)1N]1gi\u0006\u0012\u0011qG\u0001\u0003u.D3aEA\u001e!\u0011\ti$a\u0010\u000e\u0005\u0005\u0015\u0012\u0002BA!\u0003K\u0011\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003]!Xm\u001d;BYR,'oU1nKRC\u0017N\\4Uo&\u001cW\rF\u0002H\u0003\u000fBq!!\u0002\u0015\u0001\u0004\t9\u0001K\u0004\u0015\u0003;\ti#a\u0013-\t\u0005E\u0012Q\u0007\u0015\u0004)\u0005m\u0012A\u0005;fgR\fE\u000e^3s\u000b6\u0004H/_+tKJ$2aRA*\u0011\u001d\t)!\u0006a\u0001\u0003\u000fAs!FA\u000f\u0003[\t9\u0006\f\u0003\u00022\u0005U\u0002fA\u000b\u0002<\u0005IB/Z:u\u00032$XM]+oW:|wO\\'fG\"\fg.[:n)\r9\u0015q\f\u0005\b\u0003\u000b1\u0002\u0019AA\u0004Q\u001d1\u0012QDA\u0017\u0003GbC!!\r\u00026!\u001aa#a\u000f\u00023Q,7\u000f^!mi\u0016\u0014Hk\\8GK^LE/\u001a:bi&|gn\u001d\u000b\u0004\u000f\u0006-\u0004bBA\u0003/\u0001\u0007\u0011q\u0001\u0015\b/\u0005u\u0011QFA8Y\u0011\t\t$!\u000e)\u0007]\tY$\u0001\u000euKN$\u0018\t\u001c;feR{w.T1os&#XM]1uS>t7\u000fF\u0002H\u0003oBq!!\u0002\u0019\u0001\u0004\t9\u0001K\u0004\u0019\u0003;\ti#a\u001f-\t\u0005E\u0012Q\u0007\u0015\u00041\u0005m\u0012a\t;fgR$U\r\\3uKN{W.\u001a;iS:<G\u000b[1u\t>,7OT8u\u000bbL7\u000f\u001e\u000b\u0004\u000f\u0006\r\u0005bBA\u00033\u0001\u0007\u0011q\u0001\u0015\b3\u0005u\u0011QFADY\u0011\t\t$!\u000e)\u0007e\tY$\u0001\fuKN$\u0018\t\u001c;fe:{GoQ8oiJ|G\u000e\\3s)\u00059\u0005f\u0001\u000e\u0002\u0012B\u0019a+a%\n\u0007\u0005UuK\u0001\u0003UKN$\u0018\u0001\u0006;fgR\fE\u000e^3s\u0003:$G)Z:de&\u0014W\rF\u0002H\u00037Cq!!\u0002\u001c\u0001\u0004\t9\u0001K\u0004\u001c\u0003;\ti#a(-\t\u0005E\u0012Q\u0007\u0015\u00047\u0005m\u0012!\u0007;fgRlU\r^1eCR\fg+\u001a:tS>tGk\\8M_^$2aRAT\u0011\u001d\t)\u0001\ba\u0001\u0003\u000fAs\u0001HA\u000f\u0003[\tY\u000b\f\u0002\u0002.\u0006\u0012\u0011qV\u0001\u000eWJ\fg\r^\u0017J\u0005B{6g\u0018\u001b)\u0007q\tY$\u0001\u0013tK:$\u0017\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:u)\u0019\t9,!2\u0002PB!\u0011\u0011XAa\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016\u0001\u0003:fcV,7\u000f^:\u000b\u0005qr\u0014\u0002BAb\u0003w\u0013\u0011%\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+7\u000f]8og\u0016Dq!a2\u001e\u0001\u0004\tI-A\u0004sKF,Xm\u001d;\u0011\t\u0005e\u00161Z\u0005\u0005\u0003\u001b\fYL\u0001\u0011BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z9vKN$\b\"CAi;A\u0005\t\u0019AAj\u00031\u0019xnY6fiN+'O^3s!\u0011\t).a7\u000e\u0005\u0005]'bAAmY\u00059a.\u001a;x_J\\\u0017\u0002BAo\u0003/\u0014AbU8dW\u0016$8+\u001a:wKJ\faf]3oI\u0006cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001d\u0016\u0005\u0003'\f)o\u000b\u0002\u0002hB!\u0011\u0011^Az\u001b\t\tYO\u0003\u0003\u0002n\u0006=\u0018!C;oG\",7m[3e\u0015\r\t\t0S\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA{\u0003W\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u001d\u001aXM\u001c3EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;\u0015\r\u0005m(\u0011\u0001B\u0005!\u0011\tI,!@\n\t\u0005}\u00181\u0018\u0002%\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001c\bo\u001c8tK\"9\u0011qY\u0010A\u0002\t\r\u0001\u0003BA]\u0005\u000bIAAa\u0002\u0002<\n\u0019C)Z:de&\u0014W-V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z9vKN$\b\"CAi?A\u0005\t\u0019AAj\u0003E\u001aXM\u001c3EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII\n\u0011e\u00195fG.\fE\u000e\\#se>\u00148/\u00117uKJLgnZ\"sK\u0012,g\u000e^5bYN$ra\u0012B\t\u0005\u000f\u00129\u0006C\u0004\u0003\u0014\u0005\u0002\rA!\u0006\u0002\u001dI,7/\u001e7ugR{7\t[3dWB1!q\u0003B\u000f\u0005Ci!A!\u0007\u000b\u0007\tmA/\u0001\u0003vi&d\u0017\u0002\u0002B\u0010\u00053\u0011A\u0001T5tiB!!1\u0005B!\u001d\u0011\u0011)Ca\u000f\u000f\t\t\u001d\"q\u0007\b\u0005\u0005S\u0011)D\u0004\u0003\u0003,\tMb\u0002\u0002B\u0017\u0005cqA!!\u0004\u00030%\t!)\u0003\u0002A\u0003&\u0011QfP\u0005\u0003yyJAA!\u000f\u0002@\u00069Q.Z:tC\u001e,\u0017\u0002\u0002B\u001f\u0005\u007f\tQ%\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+7\u000f]8og\u0016$\u0015\r^1\u000b\t\te\u0012qX\u0005\u0005\u0005\u0007\u0012)EA\u0010BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z:vYRTAA!\u0010\u0003@!9!\u0011J\u0011A\u0002\t-\u0013!D3ya\u0016\u001cG/\u001a3FeJ|'\u000f\u0005\u0003\u0003N\tMSB\u0001B(\u0015\u0011\u0011\t&a0\u0002\u0011A\u0014x\u000e^8d_2LAA!\u0016\u0003P\t1QI\u001d:peNDqA!\u0017\"\u0001\u0004\t9!\u0001\u0006d_:$X\r\u001f;Ng\u001e\f\u0001e\u00195fG.tu.\u0012:s_J\u001c\u0018\t\u001c;fe&twm\u0011:fI\u0016tG/[1mgR\u0019qIa\u0018\t\u000f\tM!\u00051\u0001\u0003\u0016\u0005q2\r[3dWV\u001bXM]!qa\u0016\f'o]%o\u00032$XM\u001d*fgVdGo\u001d\u000b\u0006\u000f\n\u0015$q\r\u0005\b\u0005'\u0019\u0003\u0019\u0001B\u000b\u0011\u001d\u0011Ig\ta\u0001\u0003\u000f\tA!^:fe\u00069C-Z:de&\u0014W-\u00117m/&$\bNT8U_BdUM^3m\u000bJ\u0014xN]\"p]\u001aL'/\\3e)\t\tY0A\u0015dQ\u0016\u001c7NT8U_BdUM^3m\u000bJ\u0014xN\u001d#fg\u000e\u0014\u0018NY5oO\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0004\u000f\nM\u0004b\u0002B;K\u0001\u0007\u00111`\u0001\u0010e\u0016\u001c\bo\u001c8tKR{7\t[3dW\u0006Q2\r[3dWV\u001bXM\u001d%bgR;xn\u0011:fI\u0016tG/[1mgR)qIa\u001f\u0003\u000e\"9!1\u0003\u0014A\u0002\tu\u0004C\u0002B\f\u0005;\u0011y\b\u0005\u0003\u0003\u0002\n\u001de\u0002\u0002B\u0013\u0005\u0007KAA!\"\u0003@\u0005AC)Z:de&\u0014W-V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z:q_:\u001cX\rR1uC&!!\u0011\u0012BF\u0005\t\"Um]2sS\n,Wk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014Vm];mi*!!Q\u0011B \u0011\u001d\u0011IG\na\u0001\u0003\u000f\tAf\u00195fG.4uN]*j]\u001edWm\u00155bkE\u0012\u0014\n^3sCRLwN\\:9ce\u00124I]3eK:$\u0018.\u00197\u0015\u000b\u001d\u0013\u0019J!&\t\u000f\tMq\u00051\u0001\u0003~!9!\u0011N\u0014A\u0002\u0005\u001d\u0011!F2iK\u000e\\G)Z:de&\u0014WMR8s\u000bJ\u0014xN\u001d\u000b\b\u000f\nm%Q\u0014BP\u0011\u001d\u0011\u0019\u0002\u000ba\u0001\u0005{BqA!\u001b)\u0001\u0004\t9\u0001C\u0004\u0003J!\u0002\rAa\u0013")
public class AlterUserScramCredentialsRequestTest
extends BaseRequestTest {
    private MetadataVersion testMetadataVersion = MetadataVersion.latestTesting();
    private final byte[] saltedPasswordBytes = "saltedPassword".getBytes(StandardCharsets.UTF_8);
    private final byte[] saltBytes = "salt".getBytes(StandardCharsets.UTF_8);
    private final String user1;
    private final String user2;
    private final String user3;
    private final String unknownUser;

    public MetadataVersion testMetadataVersion() {
        return this.testMetadataVersion;
    }

    public void testMetadataVersion_$eq(MetadataVersion x$1) {
        this.testMetadataVersion = x$1;
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this.testMetadataVersion();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.serverConfig().setProperty("authorizer.class.name", StandardAuthorizer.class.getName());
            if (testInfo.getDisplayName().contains("quorum=kraft-IBP_3_4")) {
                this.testMetadataVersion_$eq(MetadataVersion.IBP_3_4_IV0);
            }
        } else {
            this.serverConfig().setProperty("authorizer.class.name", AlterCredentialsTest.TestAuthorizer.class.getName());
        }
        this.serverConfig().setProperty("principal.builder.class", AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        this.serverConfig().setProperty("controlled.shutdown.enable", "false");
        super.setUp(testInfo);
    }

    private byte[] saltedPasswordBytes() {
        return this.saltedPasswordBytes;
    }

    private byte[] saltBytes() {
        return this.saltBytes;
    }

    private String user1() {
        return this.user1;
    }

    private String user2() {
        return this.user2;
    }

    private String user3() {
        return this.user3;
    }

    private String unknownUser() {
        return this.unknownUser;
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterNothing(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)0, (int)results.size());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterSameThingTwice(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion1 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion2 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertion1, upsertion2}))).build()), (List)Nil$.MODULE$).foreach((Function1 & Serializable & scala.Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$1(this, request);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletion1, deletion1})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertion2, upsertion2}))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletion1, deletion2})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertion1, upsertion2}))).build()), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$2(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterEmptyUser(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletionEmpty})).setUpsertions(new ArrayList())).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionEmpty}))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletionEmpty, deletionEmpty})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionEmpty}))).build()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterEmptyUser$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterUnknownMechanism(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.UNKNOWN.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionValid1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism((byte)10);
        String user4 = "user4";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionValid4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user5 = "user5";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown5 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user5).setMechanism((byte)10).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user6 = "user6";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown6 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user6).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletionUnknown1, deletionValid1, deletionUnknown2})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionUnknown4, upsertionValid4, upsertionUnknown5, upsertionUnknown6}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)5, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_SASL_MECHANISM, "when altering the credentials with unknown SCRAM mechanisms");
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(results).asScala()).foreach((Function1 & Serializable & scala.Serializable)result -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterUnknownMechanism$1(result);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterTooFewIterations(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(1).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionTooFewIterations}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too few iterations");
        Assertions.assertEquals((Object)"Too few iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterTooManyIterations(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(Integer.MAX_VALUE).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionTooFewIterations}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too many iterations");
        Assertions.assertEquals((Object)"Too many iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testDeleteSomethingThatDoesNotExist(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type())})).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.RESOURCE_NOT_FOUND, "when deleting a non-existing credential");
    }

    @Test
    public void testAlterNotController() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type())})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.notControllerSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.NOT_CONTROLLER, "when routed incorrectly to a non-Controller broker");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterAndDescribe(String quorum) {
        AlterUserScramCredentialsRequest request1_0 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())}))).build();
        java.util.List results1_0 = this.sendAlterUserScramCredentialsRequest(request1_0, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results1_0.size());
        this.checkNoErrorsAlteringCredentials(results1_0);
        this.checkUserAppearsInAlterResults(results1_0, this.user1());
        AlterUserScramCredentialsRequest request1_1 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user3()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())}))).build();
        java.util.List results1_1 = this.sendAlterUserScramCredentialsRequest(request1_1, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)3, (int)results1_1.size());
        this.checkNoErrorsAlteringCredentials(results1_1);
        this.checkUserAppearsInAlterResults(results1_1, this.user1());
        this.checkUserAppearsInAlterResults(results1_1, this.user2());
        this.checkUserAppearsInAlterResults(results1_1, this.user3());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results2 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)3, (int)results2.size());
        this.checkUserHasTwoCredentials(results2, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user2());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user3());
        DescribeUserScramCredentialsRequest request3 = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList((Object[])new DescribeUserScramCredentialsRequestData.UserName[]{new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1())}))).build();
        DescribeUserScramCredentialsResponse response3 = this.sendDescribeUserScramCredentialsRequest(request3, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(response3);
        java.util.List results3 = response3.data().results();
        Assertions.assertEquals((int)1, (int)results3.size());
        this.checkUserHasTwoCredentials(results3, this.user1());
        DescribeUserScramCredentialsRequest requestUnknown = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList((Object[])new DescribeUserScramCredentialsRequestData.UserName[]{new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.unknownUser())}))).build();
        DescribeUserScramCredentialsResponse responseUnknown = this.sendDescribeUserScramCredentialsRequest(requestUnknown, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(responseUnknown);
        java.util.List resultsUnknown = responseUnknown.data().results();
        Assertions.assertEquals((int)2, (int)resultsUnknown.size());
        this.checkUserHasTwoCredentials(resultsUnknown, this.user1());
        this.checkDescribeForError(resultsUnknown, this.unknownUser(), Errors.RESOURCE_NOT_FOUND);
        DescribeUserScramCredentialsRequest requestDuplicateUser = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList((Object[])new DescribeUserScramCredentialsRequestData.UserName[]{new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2())}))).build();
        DescribeUserScramCredentialsResponse responseDuplicateUser = this.sendDescribeUserScramCredentialsRequest(requestDuplicateUser, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(responseDuplicateUser);
        java.util.List resultsDuplicateUser = responseDuplicateUser.data().results();
        Assertions.assertEquals((int)2, (int)resultsDuplicateUser.size());
        this.checkUserHasTwoCredentials(resultsDuplicateUser, this.user1());
        this.checkDescribeForError(resultsDuplicateUser, this.user2(), Errors.DUPLICATE_RESOURCE);
        AlterUserScramCredentialsRequest request4 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())}))).build();
        java.util.List results4 = this.sendAlterUserScramCredentialsRequest(request4, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results4.size());
        this.checkNoErrorsAlteringCredentials(results4);
        this.checkUserAppearsInAlterResults(results4, this.user1());
        this.checkUserAppearsInAlterResults(results4, this.user2());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results5 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)2, (int)results5.size());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user3());
        AlterUserScramCredentialsRequest request6 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user3()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())}))).build();
        java.util.List results6 = this.sendAlterUserScramCredentialsRequest(request6, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results6.size());
        this.checkNoErrorsAlteringCredentials(results6);
        this.checkUserAppearsInAlterResults(results6, this.user1());
        this.checkUserAppearsInAlterResults(results6, this.user3());
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results7 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)0, (int)results7.size());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft-IBP_3_4"})
    public void testMetadataVersionTooLow(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionMetadataVersionTooLow = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionMetadataVersionTooLow}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_VERSION, "when altering the credentials on unsupported IBP version");
        Assertions.assertEquals((Object)"The current metadata.version does not support SCRAM", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    private AlterUserScramCredentialsResponse sendAlterUserScramCredentialsRequest(AlterUserScramCredentialsRequest request, SocketServer socketServer) {
        return (AlterUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterUserScramCredentialsResponse.class));
    }

    private SocketServer sendAlterUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private void checkAllErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, Errors expectedError, String contextMsg) {
        Assertions.assertEquals((int)0, (int)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkAllErrorsAlteringCredentials$1(expectedError, x$1)))).size(), (String)new StringBuilder(49).append("Expected all '").append(expectedError.name()).append("' errors when altering credentials ").append(contextMsg).toString());
    }

    private void checkNoErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck) {
        Assertions.assertEquals((int)0, (int)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkNoErrorsAlteringCredentials$1(x$2)))).size(), (String)"Expected no error when altering credentials");
    }

    private void checkUserAppearsInAlterResults(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserAppearsInAlterResults$1(user, x$3))), (String)new StringBuilder(29).append("Expected result to contain '").append(user).append("'").toString());
    }

    private DescribeUserScramCredentialsResponse describeAllWithNoTopLevelErrorConfirmed() {
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest((DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build(), this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(response);
        return response;
    }

    private void checkNoTopLevelErrorDescribingCredentials(DescribeUserScramCredentialsResponse responseToCheck) {
        Assertions.assertEquals((short)Errors.NONE.code(), (short)responseToCheck.data().errorCode(), (String)"Expected no top-level error when describing the credentials");
    }

    private void checkUserHasTwoCredentials(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$1(user, result))), (String)new StringBuilder(50).append("Expected result to contain '").append(user).append("' with 2 credentials: ").append(resultsToCheck).toString());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$2(user, result))), (String)new StringBuilder(90).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_256/4096 and SCRAM_SHA_512/8192 credentials: ").append(resultsToCheck).toString());
    }

    private void checkForSingleSha512Iterations8192Credential(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$1(user, result))), (String)new StringBuilder(49).append("Expected result to contain '").append(user).append("' with 1 credential: ").append(resultsToCheck).toString());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$2(user, result))), (String)new StringBuilder(66).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_512/8192 credential: ").append(resultsToCheck).toString());
    }

    private void checkDescribeForError(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user, Errors expectedError) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkDescribeForError$1(user, expectedError, result))), (String)new StringBuilder(45).append("Expected result to contain '").append(user).append("' with a ").append(expectedError.name()).append(" error: ").append(resultsToCheck).toString());
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        $this.checkNoErrorsAlteringCredentials(results);
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$2(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.DUPLICATE_RESOURCE, "when altering the same credential twice in a single request");
    }

    public static final /* synthetic */ void $anonfun$testAlterEmptyUser$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering an empty user");
        Assertions.assertEquals((Object)"Username must not be empty", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    public static final /* synthetic */ void $anonfun$testAlterUnknownMechanism$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult result) {
        Assertions.assertEquals((Object)"Unknown SCRAM mechanism", (Object)result.errorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$1(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$2() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see 3 users";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$3(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$4() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see only 2 users";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$5(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$6() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see empty user";
    }

    public static final /* synthetic */ boolean $anonfun$checkAllErrorsAlteringCredentials$1(Errors expectedError$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$1) {
        return x$1.errorCode() == expectedError$1.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkNoErrorsAlteringCredentials$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$2) {
        return x$2.errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkUserAppearsInAlterResults$1(String user$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$3) {
        String string = x$3.user();
        return !(string != null ? !string.equals(user$1) : user$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$1(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (result.credentialInfos().size() == 2 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_256.type() && info.iterations() == 4096;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$4(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$2(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.credentialInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$3(info))) && ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.credentialInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$4(info)))) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$1(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$3) : user$3 != null)) {
            if (result.credentialInfos().size() == 1 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$2(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        return !(string != null ? !string.equals(user$3) : user$3 != null) && ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.credentialInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$3(info)));
    }

    public static final /* synthetic */ boolean $anonfun$checkDescribeForError$1(String user$4, Errors expectedError$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$4) : user$4 != null)) {
            if (result.credentialInfos().size() == 0 && result.errorCode() == expectedError$2.code()) {
                return true;
            }
        }
        return false;
    }

    public AlterUserScramCredentialsRequestTest() {
        this.user1 = "user1";
        this.user2 = "user2";
        this.user3 = "user3@user3.com";
        this.unknownUser = "unknownUser";
    }
}

