/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.controller.KafkaController;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.DefaultAutoTopicCreationManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.UnboundedControllerMutationQuota$;
import kafka.server.ZkAdminManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tef\u0001B\u001d;\u0001}BQA\u0012\u0001\u0005\u0002\u001dCqA\u0013\u0001C\u0002\u0013%1\n\u0003\u0004P\u0001\u0001\u0006I\u0001\u0014\u0005\n!\u0002\u0001\r\u00111A\u0005\nEC\u0011\"\u0016\u0001A\u0002\u0003\u0007I\u0011\u0002,\t\u0013q\u0003\u0001\u0019!A!B\u0013\u0011\u0006bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007E\u0002\u0001\u000b\u0011B0\t\u000f\r\u0004!\u0019!C\u0005I\"1q\u000e\u0001Q\u0001\n\u0015Dq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004v\u0001\u0001\u0006IA\u001d\u0005\bm\u0002\u0011\r\u0011\"\u0003x\u0011\u0019i\b\u0001)A\u0005q\"9a\u0010\u0001b\u0001\n\u0013y\b\u0002CA\t\u0001\u0001\u0006I!!\u0001\t\u0013\u0005M\u0001A1A\u0005\n\u0005U\u0001\u0002CA\u0013\u0001\u0001\u0006I!a\u0006\t\u0017\u0005\u001d\u0002\u00011AA\u0002\u0013%\u0011\u0011\u0006\u0005\f\u0003c\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0004C\u0006\u00028\u0001\u0001\r\u0011!Q!\n\u0005-\u0002\u0002CA\u001d\u0001\t\u0007I\u0011B&\t\u000f\u0005m\u0002\u0001)A\u0005\u0019\"I\u0011Q\b\u0001C\u0002\u0013%\u0011q\b\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002B!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA2\u0001\u0011\u0005\u00111\n\u0005\b\u0003[\u0002A\u0011AA&\u0011\u001d\t\t\b\u0001C\u0001\u0003\u0017Bq!!\u001e\u0001\t\u0013\t9\bC\u0005\u0002&\u0002\t\n\u0011\"\u0003\u0002(\"I\u0011Q\u0018\u0001\u0012\u0002\u0013%\u0011q\u0018\u0005\b\u0003\u0007\u0004A\u0011AA&\u0011\u001d\t9\r\u0001C\u0001\u0003\u0017Bq!a3\u0001\t\u0003\tY\u0005C\u0004\u0002P\u0002!\t!a\u0013\t\u000f\u0005M\u0007\u0001\"\u0001\u0002L!9\u0011q\u001b\u0001\u0005\u0002\u0005-\u0003bBAn\u0001\u0011\u0005\u00111\n\u0005\b\u0003?\u0004A\u0011AA&\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003\u0017Bq!a:\u0001\t\u0003\tY\u0005C\u0004\u0002l\u0002!\t!a\u0013\t\u000f\u0005=\b\u0001\"\u0001\u0002L!9\u00111\u001f\u0001\u0005\u0002\u0005-\u0003bBA|\u0001\u0011\u0005\u00111\n\u0005\b\u0003w\u0004A\u0011AA&\u0011\u001d\ty\u0010\u0001C\u0001\u0003\u0017BqAa\u0001\u0001\t\u0013\u0011)\u0001C\u0004\u0003H\u0001!IA!\u0013\t\u0013\t%\u0004!%A\u0005\n\t-\u0004b\u0002B8\u0001\u0011%!\u0011\u000f\u0005\n\u0005\u007f\u0002\u0011\u0013!C\u0005\u0005\u0003CqA!\"\u0001\t\u0013\u00119\tC\u0005\u00036\u0002\t\n\u0011\"\u0003\u0002(\"I!q\u0017\u0001\u0012\u0002\u0013%\u0011q\u0018\u0002\u001d\u0003V$x\u000eV8qS\u000e\u001c%/Z1uS>tW*\u00198bO\u0016\u0014H+Z:u\u0015\tYD(\u0001\u0004tKJ4XM\u001d\u0006\u0002{\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001A!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0013\t\u0003\u0013\u0002i\u0011AO\u0001\u000fe\u0016\fX/Z:u)&lWm\\;u+\u0005a\u0005CA!N\u0013\tq%IA\u0002J]R\fqB]3rk\u0016\u001cH\u000fV5nK>,H\u000fI\u0001\u0007G>tg-[4\u0016\u0003I\u0003\"!S*\n\u0005QS$aC&bM.\f7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\t9&\f\u0005\u0002B1&\u0011\u0011L\u0011\u0002\u0005+:LG\u000fC\u0004\\\u000b\u0005\u0005\t\u0019\u0001*\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\u0005y\u0006CA%a\u0013\t\t'HA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003I\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:\u0016\u0003\u0015\u0004\"AZ7\u000e\u0003\u001dT!a\u000f5\u000b\u0005uJ'B\u00016l\u0003\u0019\t\u0007/Y2iK*\tA.A\u0002pe\u001eL!A\\4\u0003=9{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018a\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ\u0004\u0013\u0001D1e[&tW*\u00198bO\u0016\u0014X#\u0001:\u0011\u0005%\u001b\u0018B\u0001;;\u00059Q6.\u00113nS:l\u0015M\\1hKJ\fQ\"\u00193nS:l\u0015M\\1hKJ\u0004\u0013AC2p]R\u0014x\u000e\u001c7feV\t\u0001\u0010\u0005\u0002zw6\t!P\u0003\u0002wy%\u0011AP\u001f\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\u0006Y1m\u001c8ue>dG.\u001a:!\u0003A9'o\\;q\u0007>|'\u000fZ5oCR|'/\u0006\u0002\u0002\u0002A!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011!B4s_V\u0004(bAA\u0006Q\u0006Y1m\\8sI&t\u0017\r^8s\u0013\u0011\ty!!\u0002\u0003!\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\u0018!E4s_V\u00048i\\8sI&t\u0017\r^8sA\u00051BO]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'/\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0011\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011a\u0003;sC:\u001c\u0018m\u0019;j_:T1!a\u0003=\u0013\u0011\t\u0019#a\u0007\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\fq\u0003\u001e:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u00021\u0005,Ho\u001c+pa&\u001c7I]3bi&|g.T1oC\u001e,'/\u0006\u0002\u0002,A\u0019\u0011*!\f\n\u0007\u0005=\"H\u0001\rBkR|Gk\u001c9jG\u000e\u0013X-\u0019;j_:l\u0015M\\1hKJ\fA$Y;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002X\u0003kA\u0001b\u0017\u000b\u0002\u0002\u0003\u0007\u00111F\u0001\u001aCV$x\u000eV8qS\u000e\u001c%/Z1uS>tW*\u00198bO\u0016\u0014\b%A\fj]R,'O\\1m)>\u0004\u0018n\u0019)beRLG/[8og\u0006A\u0012N\u001c;fe:\fG\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002=%tG/\u001a:oC2$v\u000e]5d%\u0016\u0004H.[2bi&|gNR1di>\u0014XCAA!!\r\t\u00151I\u0005\u0004\u0003\u000b\u0012%!B*i_J$\u0018aH5oi\u0016\u0014h.\u00197U_BL7MU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA\u0005)1/\u001a;vaR\tq\u000bK\u0002\u001b\u0003\u001f\u0002B!!\u0015\u0002`5\u0011\u00111\u000b\u0006\u0005\u0003+\n9&A\u0002ba&TA!!\u0017\u0002\\\u00059!.\u001e9ji\u0016\u0014(bAA/W\u0006)!.\u001e8ji&!\u0011\u0011MA*\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0016i\u0016\u001cHo\u0011:fCR,wJ\u001a4tKR$v\u000e]5dQ\rY\u0012q\r\t\u0005\u0003#\nI'\u0003\u0003\u0002l\u0005M#\u0001\u0002+fgR\f!\u0003^3ti\u000e\u0013X-\u0019;f)btGk\u001c9jG\"\u001aA$a\u001a\u00025Q,7\u000f^\"sK\u0006$XMT8o\u0013:$XM\u001d8bYR{\u0007/[2)\u0007u\t9'A\buKN$8I]3bi\u0016$v\u000e]5d)%9\u0016\u0011PAJ\u0003;\u000b\t\u000bC\u0004\u0002|y\u0001\r!! \u0002\u0013Q|\u0007/[2OC6,\u0007\u0003BA@\u0003\u001bsA!!!\u0002\nB\u0019\u00111\u0011\"\u000e\u0005\u0005\u0015%bAAD}\u00051AH]8pizJ1!a#C\u0003\u0019\u0001&/\u001a3fM&!\u0011qRAI\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0012\"\t\u000f\u0005Ue\u00041\u0001\u0002\u0018\u0006Q\u0011n]%oi\u0016\u0014h.\u00197\u0011\u0007\u0005\u000bI*C\u0002\u0002\u001c\n\u0013qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002 z\u0001\n\u00111\u0001M\u00035qW/\u001c)beRLG/[8og\"I\u00111\u0015\u0010\u0011\u0002\u0003\u0007\u0011\u0011I\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\u0018!\u0007;fgR\u001c%/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIM*\"!!++\u00071\u000bYk\u000b\u0002\u0002.B!\u0011qVA]\u001b\t\t\tL\u0003\u0003\u00024\u0006U\u0016!C;oG\",7m[3e\u0015\r\t9LQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA^\u0003c\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003e!Xm\u001d;De\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u0005'\u0006BA!\u0003W\u000ba\u0005^3ti\u000e\u0013X-\u0019;f)>\u0004\u0018nY:XSRDgi\u001c:xCJ$\u0017N\\4ESN\f'\r\\3eQ\r\t\u0013qM\u00011i\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\r>\u0014hj\u001c8J]R,'O\\1m)>\u0004\u0018nY:)\u0007\t\n9'A\u001auKN$\u0018J\u001c<bY&$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:G_J\u001cuN\\:v[\u0016\u0014xJ\u001a4tKR\u001cHk\u001c9jG\"\u001a1%a\u001a\u0002[Q,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u001a{'\u000f\u0016=o\u001f\u001a47/\u001a;U_BL7\rK\u0002%\u0003O\nA\u0006^3tiR{\u0007/[2Fq&\u001cHo]#se>\u00148k^1q\r>\u0014hj\u001c8J]R,'O\\1m)>\u0004\u0018nY:)\u0007\u0015\n9'A\u0018uKN$Hk\u001c9jG\u0016C\u0018n\u001d;t\u000bJ\u0014xN]*xCB4uN]\"p]N,X.\u001a:PM\u001a\u001cX\r^:U_BL7\rK\u0002'\u0003O\n\u0011\u0006^3tiR{\u0007/[2Fq&\u001cHo]#se>\u00148k^1q\r>\u0014H\u000b\u001f8PM\u001a\u001cX\r\u001e+pa&\u001c\u0007fA\u0014\u0002h\u0005yC/Z:u%\u0016\fX/Z:u)&lWm\\;u\u000bJ\u0014xN]*xCB4uN\u001d(p]&sG/\u001a:oC2$v\u000e]5dg\"\u001a\u0001&a\u001a\u0002cQ,7\u000f\u001e*fcV,7\u000f\u001e+j[\u0016|W\u000f^#se>\u00148k^1q\r>\u00148i\u001c8tk6,'o\u00144gg\u0016$Hk\u001c9jG\"\u001a\u0011&a\u001a\u0002YQ,7\u000f\u001e*fcV,7\u000f\u001e+j[\u0016|W\u000f^#se>\u00148k^1q\r>\u0014H\u000b\u001f8PM\u001a\u001cX\r\u001e+pa&\u001c\u0007f\u0001\u0016\u0002h\u0005aC/Z:u+:\\gn\\<o)>\u0004\u0018n\u0019)beRLG/[8o\r>\u0014hj\u001c8J]R,'O^1m)>\u0004\u0018n\u0019\u0015\u0004W\u0005\u001d\u0014a\f;fgR,fn\u001b8po:$v\u000e]5d!\u0006\u0014H/\u001b;j_:4uN]\"p]N,X.\u001a:PM\u001a\u001cX\r\u001e+pa&\u001c\u0007f\u0001\u0017\u0002h\u0005QC/Z:u+:\\gn\\<o)>\u0004\u0018n\u0019)beRLG/[8o\r>\u0014H\u000b\u001f8PM\u001a\u001cX\r\u001e+pa&\u001c\u0007fA\u0017\u0002h\u0005\tD/Z:u)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8XSRDW*\u001a;bI\u0006$\u0018mQ8oi\u0016DH\u000fU1tgB\u0013\u0018N\\2ja\u0006d\u0007f\u0001\u0018\u0002h\u0005\u0001E/Z:u)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8XSRDW*\u001a;bI\u0006$\u0018mQ8oi\u0016DHo\u00165f]B\u0013\u0018N\\2ja\u0006d7+\u001a:eK:{G\u000fR3gS:,G\rK\u00020\u0003O\n\u0011\t^3tiR{\u0007/[2De\u0016\fG/[8o/&$\b.T3uC\u0012\fG/Y\"p]R,\u0007\u0010\u001e(p%\u0016$(/_+q_:,fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8)\u0007A\n9'\u0001\rj]&$\u0018.\u00197ju\u0016\u0014V-];fgR\u001cuN\u001c;fqR$\u0002Ba\u0002\u0003\u0018\te!Q\u0006\t\u0005\u0005\u0013\u0011\u0019\"\u0004\u0002\u0003\f)!!Q\u0002B\b\u0003!\u0011X-];fgR\u001c(b\u0001B\tQ\u000611m\\7n_:LAA!\u0006\u0003\f\tq!+Z9vKN$8i\u001c8uKb$\bbBA>c\u0001\u0007\u0011Q\u0010\u0005\b\u00057\t\u0004\u0019\u0001B\u000f\u00039Y\u0017MZ6b!JLgnY5qC2\u0004BAa\b\u0003*5\u0011!\u0011\u0005\u0006\u0005\u0005G\u0011)#\u0001\u0003bkRD'\u0002\u0002B\u0014\u0005\u001f\t\u0001b]3dkJLG/_\u0005\u0005\u0005W\u0011\tC\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\u000f\t=\u0012\u00071\u0001\u00032\u0005q\u0001O]5oG&\u0004\u0018\r\\*fe\u0012,\u0007C\u0002B\u001a\u0005{\u0011\t%\u0004\u0002\u00036)!!q\u0007B\u001d\u0003\u0011)H/\u001b7\u000b\u0005\tm\u0012\u0001\u00026bm\u0006LAAa\u0010\u00036\tAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0003 \t\r\u0013\u0002\u0002B#\u0005C\u00111cS1gW\u0006\u0004&/\u001b8dSB\fGnU3sI\u0016\f\u0011\u0004^3ti\u0016\u0013(o\u001c:XSRD7I]3bi&|g.\u00138[WRIqKa\u0013\u0003\\\tu#q\f\u0005\b\u0005\u001b\u0012\u0004\u0019\u0001B(\u0003\u0015)'O]8s!\u0011\u0011\tFa\u0016\u000e\u0005\tM#\u0002\u0002B+\u0005\u001f\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u00053\u0012\u0019F\u0001\u0004FeJ|'o\u001d\u0005\b\u0003w\u0012\u0004\u0019AA?\u0011\u001d\t)J\ra\u0001\u0003/C\u0011B!\u00193!\u0003\u0005\rAa\u0019\u0002\u001b\u0015D\b/Z2uK\u0012,%O]8s!\u0015\t%Q\rB(\u0013\r\u00119G\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0002GQ,7\u000f^#se>\u0014x+\u001b;i\u0007J,\u0017\r^5p]&s'l\u001b\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u000e\u0016\u0005\u0005G\nY+\u0001\u000ede\u0016\fG/\u001a+pa&\u001c\u0017I\u001c3WKJLg-\u001f*fgVdG\u000fF\u0005X\u0005g\u0012)Ha\u001e\u0003z!9!Q\n\u001bA\u0002\t=\u0003bBA>i\u0001\u0007\u0011Q\u0010\u0005\b\u0003+#\u0004\u0019AAL\u0011%\u0011Y\b\u000eI\u0001\u0002\u0004\u0011i(A\bnKR\fG-\u0019;b\u0007>tG/\u001a=u!\u0015\t%Q\rB\u0004\u0003\u0011\u001a'/Z1uKR{\u0007/[2B]\u00124VM]5gsJ+7/\u001e7uI\u0011,g-Y;mi\u0012\"TC\u0001BBU\u0011\u0011i(a+\u0002\u0017\u001d,GOT3x)>\u0004\u0018n\u0019\u000b\t\u0005\u0013\u0013yK!-\u00034B!!1\u0012BU\u001d\u0011\u0011iIa)\u000f\t\t=%q\u0014\b\u0005\u0005#\u0013iJ\u0004\u0003\u0003\u0014\nme\u0002\u0002BK\u00053sA!a!\u0003\u0018&\tA.\u0003\u0002kW&\u0011Q([\u0005\u0004\u0005#A\u0017\u0002\u0002BQ\u0005\u001f\tq!\\3tg\u0006<W-\u0003\u0003\u0003&\n\u001d\u0016aF\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$H)\u0019;b\u0015\u0011\u0011\tKa\u0004\n\t\t-&Q\u0016\u0002\u000f\u0007J,\u0017\r^1cY\u0016$v\u000e]5d\u0015\u0011\u0011)Ka*\t\u000f\u0005md\u00071\u0001\u0002~!A\u0011q\u0014\u001c\u0011\u0002\u0003\u0007A\nC\u0005\u0002$Z\u0002\n\u00111\u0001\u0002B\u0005)r-\u001a;OK^$v\u000e]5dI\u0011,g-Y;mi\u0012\u0012\u0014!F4fi:+w\u000fV8qS\u000e$C-\u001a4bk2$He\r")
public class AutoTopicCreationManagerTest {
    private final int requestTimeout;
    private KafkaConfig config;
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final NodeToControllerChannelManager brokerToController = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
    private final ZkAdminManager adminManager = (ZkAdminManager)Mockito.mock(ZkAdminManager.class);
    private final KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private final TransactionCoordinator transactionCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private AutoTopicCreationManager autoTopicCreationManager;
    private final int internalTopicPartitions;
    private final short internalTopicReplicationFactor = (short)2;

    private int requestTimeout() {
        return this.requestTimeout;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private NodeToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private ZkAdminManager adminManager() {
        return this.adminManager;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private TransactionCoordinator transactionCoordinator() {
        return this.transactionCoordinator;
    }

    private AutoTopicCreationManager autoTopicCreationManager() {
        return this.autoTopicCreationManager;
    }

    private void autoTopicCreationManager_$eq(AutoTopicCreationManager x$1) {
        this.autoTopicCreationManager = x$1;
    }

    private int internalTopicPartitions() {
        return this.internalTopicPartitions;
    }

    private short internalTopicReplicationFactor() {
        return this.internalTopicReplicationFactor;
    }

    @BeforeEach
    public void setup() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        props.setProperty("request.timeout.ms", Integer.toString(this.requestTimeout()));
        props.setProperty("offsets.topic.replication.factor", Integer.toString(this.internalTopicPartitions()));
        props.setProperty("transaction.state.log.replication.factor", Integer.toString(this.internalTopicPartitions()));
        props.setProperty("offsets.topic.num.partitions", Short.toString(this.internalTopicReplicationFactor()));
        props.setProperty("transaction.state.log.num.partitions", Short.toString(this.internalTopicReplicationFactor()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        .colon.colon aliveBrokers = new .colon.colon((Object)new Node(0, "host0", 0), (List)new .colon.colon((Object)new Node(1, "host1", 1), (List)Nil$.MODULE$));
        Mockito.reset((Object[])new Object[]{this.metadataCache(), this.controller(), this.brokerToController(), this.groupCoordinator(), this.transactionCoordinator()});
        Mockito.when((Object)this.metadataCache().getAliveBrokerNodes((ListenerName)ArgumentMatchers.any(ListenerName.class))).thenReturn((Object)aliveBrokers);
    }

    @Test
    public void testCreateOffsetTopic() {
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)new Properties());
        this.testCreateTopic("__consumer_offsets", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor());
    }

    @Test
    public void testCreateTxnTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testCreateTopic("__transaction_state", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor());
    }

    @Test
    public void testCreateNonInternalTopic() {
        this.testCreateTopic("topic", false, this.testCreateTopic$default$3(), this.testCreateTopic$default$4());
    }

    private void testCreateTopic(String topicName, boolean isInternal, int numPartitions, short replicationFactor) {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)new Some((Object)this.brokerToController()), (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        CreateTopicsRequestData.CreatableTopicCollection topicsCollection = new CreateTopicsRequestData.CreatableTopicCollection();
        topicsCollection.add((ImplicitLinkedHashCollection.Element)this.getNewTopic(topicName, numPartitions, replicationFactor));
        CreateTopicsRequest.Builder requestBody = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topicsCollection).setTimeoutMs(this.requestTimeout()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal, this.createTopicAndVerifyResult$default$4());
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal, this.createTopicAndVerifyResult$default$4());
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.eq((Object)requestBody), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
    }

    private int testCreateTopic$default$3() {
        return 1;
    }

    private short testCreateTopic$default$4() {
        return 1;
    }

    @Test
    public void testCreateTopicsWithForwardingDisabled() {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)None$.MODULE$, (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        String topicName = "topic";
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, false, this.createTopicAndVerifyResult$default$4());
        ((ZkAdminManager)Mockito.verify((Object)this.adminManager())).createTopics(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)this.getNewTopic(topicName, this.getNewTopic$default$2(), this.getNewTopic$default$3()))}))), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.empty()), (ControllerMutationQuota)ArgumentMatchers.any(ControllerMutationQuota.class), (Function1)ArgumentMatchers.any(Function1.class));
    }

    @Test
    public void testInvalidReplicationFactorForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "topic", false, this.testErrorWithCreationInZk$default$4());
    }

    @Test
    public void testInvalidReplicationFactorForConsumerOffsetsTopic() {
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "__consumer_offsets", true, this.testErrorWithCreationInZk$default$4());
    }

    @Test
    public void testInvalidReplicationFactorForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "__transaction_state", true, this.testErrorWithCreationInZk$default$4());
    }

    @Test
    public void testTopicExistsErrorSwapForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "topic", false, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testTopicExistsErrorSwapForConsumerOffsetsTopic() {
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "__consumer_offsets", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testTopicExistsErrorSwapForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "__transaction_state", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "topic", false, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForConsumerOffsetTopic() {
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "__consumer_offsets", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "__transaction_state", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testUnknownTopicPartitionForNonIntervalTopic() {
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "topic", false, this.testErrorWithCreationInZk$default$4());
    }

    @Test
    public void testUnknownTopicPartitionForConsumerOffsetTopic() {
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "__consumer_offsets", true, this.testErrorWithCreationInZk$default$4());
    }

    @Test
    public void testUnknownTopicPartitionForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "__transaction_state", true, this.testErrorWithCreationInZk$default$4());
    }

    @Test
    public void testTopicCreationWithMetadataContextPassPrincipal() {
        String topicName = "topic";
        KafkaPrincipal userPrincipal = new KafkaPrincipal("User", "user");
        AtomicBoolean serializeIsCalled = new AtomicBoolean(false);
        KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null, userPrincipal, serializeIsCalled){
            private final KafkaPrincipal userPrincipal$1;
            private final AtomicBoolean serializeIsCalled$1;

            public byte[] serialize(KafkaPrincipal principal) {
                Assertions.assertEquals((Object)principal, (Object)this.userPrincipal$1);
                this.serializeIsCalled$1.set(true);
                return Utils.utf8((String)principal.toString());
            }

            public KafkaPrincipal deserialize(byte[] bytes) {
                return SecurityUtils.parseKafkaPrincipal((String)Utils.utf8((byte[])bytes));
            }
            {
                this.userPrincipal$1 = userPrincipal$1;
                this.serializeIsCalled$1 = serializeIsCalled$1;
            }
        };
        RequestContext requestContext = this.initializeRequestContext(topicName, userPrincipal, Optional.of(principalSerde));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        Assertions.assertTrue((boolean)serializeIsCalled.get());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)argumentCaptor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
        EnvelopeRequest capturedRequest = ((EnvelopeRequest.Builder)argumentCaptor.getValue()).build(ApiKeys.ENVELOPE.latestVersion());
        Assertions.assertEquals((Object)userPrincipal, (Object)SecurityUtils.parseKafkaPrincipal((String)Utils.utf8((byte[])capturedRequest.requestPrincipal())));
    }

    @Test
    public void testTopicCreationWithMetadataContextWhenPrincipalSerdeNotDefined() {
        String topicName = "topic";
        RequestContext requestContext = this.initializeRequestContext(topicName, KafkaPrincipal.ANONYMOUS, Optional.empty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext)));
    }

    @Test
    public void testTopicCreationWithMetadataContextNoRetryUponUnsupportedVersion() {
        String topicName = "topic";
        KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

            public byte[] serialize(KafkaPrincipal principal) {
                return Utils.utf8((String)principal.toString());
            }

            public KafkaPrincipal deserialize(byte[] bytes) {
                return SecurityUtils.parseKafkaPrincipal((String)Utils.utf8((byte[])bytes));
            }
        };
        RequestContext requestContext = this.initializeRequestContext(topicName, KafkaPrincipal.ANONYMOUS, Optional.of(principalSerde));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
        RequestHeader header = new RequestHeader(ApiKeys.ENVELOPE, 0, "client", 1);
        EnvelopeResponse response = new EnvelopeResponse(ByteBuffer.allocate(0), Errors.UNSUPPORTED_VERSION);
        ClientResponse clientResponse = new ClientResponse(header, null, null, 0L, 0L, false, null, null, (AbstractResponse)response);
        ((RequestCompletionHandler)argumentCaptor.getValue()).onComplete(clientResponse);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)1))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
    }

    private RequestContext initializeRequestContext(String topicName, KafkaPrincipal kafkaPrincipal, Optional<KafkaPrincipalSerde> principalSerde) {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)new Some((Object)this.brokerToController()), (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        new CreateTopicsRequestData.CreatableTopicCollection().add((ImplicitLinkedHashCollection.Element)this.getNewTopic(topicName, this.getNewTopic$default$2(), this.getNewTopic$default$3()));
        ApiVersionsResponseData.ApiVersion createTopicApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.CREATE_TOPICS.id).setMinVersion((short)0).setMaxVersion((short)0);
        Mockito.when((Object)this.brokerToController().controllerApiVersions()).thenReturn(Optional.of(NodeApiVersions.create(Collections.singleton(createTopicApiVersion))));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        RequestHeader requestHeader = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), "clientId", 0);
        return new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), Optional.empty(), kafkaPrincipal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false, principalSerde);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testErrorWithCreationInZk(Errors error, String topicName, boolean isInternal, Option<Errors> expectedError) {
        CreateTopicsRequestData.CreatableTopic creatableTopic;
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)None$.MODULE$, (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        if (isInternal) {
            if ("__consumer_offsets".equals(topicName)) {
                creatableTopic = this.getNewTopic(topicName, Predef$.MODULE$.Integer2int(this.config().offsetsTopicPartitions()), Predef$.MODULE$.Short2short(this.config().offsetsTopicReplicationFactor()));
            } else {
                if (!"__transaction_state".equals(topicName)) throw new MatchError((Object)topicName);
                creatableTopic = this.getNewTopic(topicName, Predef$.MODULE$.Integer2int(this.config().transactionTopicPartitions()), Predef$.MODULE$.Short2short(this.config().transactionTopicReplicationFactor()));
            }
        } else {
            creatableTopic = this.getNewTopic(topicName, this.getNewTopic$default$2(), this.getNewTopic$default$3());
        }
        CreateTopicsRequestData.CreatableTopic newTopic = creatableTopic;
        Errors errors = error;
        Errors errors2 = Errors.UNKNOWN_TOPIC_OR_PARTITION;
        Map topicErrors = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? null : (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)new ApiError(error))}));
        this.adminManager().createTopics(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)newTopic)}))), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.empty()), (ControllerMutationQuota)ArgumentMatchers.any(ControllerMutationQuota.class), (Function1)ArgumentMatchers.any(Function1.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            AutoTopicCreationManagerTest.$anonfun$testErrorWithCreationInZk$1(topicErrors, invocation);
            return BoxedUnit.UNIT;
        });
        this.createTopicAndVerifyResult((Errors)expectedError.getOrElse((Function0 & Serializable & scala.Serializable)() -> error), topicName, isInternal, this.createTopicAndVerifyResult$default$4());
    }

    private Option<Errors> testErrorWithCreationInZk$default$4() {
        return None$.MODULE$;
    }

    private void createTopicAndVerifyResult(Errors error, String topicName, boolean isInternal, Option<RequestContext> metadataContext) {
        Seq topicResponses = this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, metadataContext);
        Assertions.assertEquals((Object)new .colon.colon((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setIsInternal(isInternal).setName(topicName), (List)Nil$.MODULE$), (Object)topicResponses);
    }

    private Option<RequestContext> createTopicAndVerifyResult$default$4() {
        return None$.MODULE$;
    }

    private CreateTopicsRequestData.CreatableTopic getNewTopic(String topicName, int numPartitions, short replicationFactor) {
        return new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(numPartitions).setReplicationFactor(replicationFactor);
    }

    private int getNewTopic$default$2() {
        return 1;
    }

    private short getNewTopic$default$3() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testErrorWithCreationInZk$1(Map topicErrors$1, InvocationOnMock invocation) {
        ((Function1)invocation.getArgument(5)).apply((Object)topicErrors$1);
    }

    public AutoTopicCreationManagerTest() {
        this.requestTimeout = 100;
        this.internalTopicPartitions = 2;
    }
}

