/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.ControllerServer;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001\u0002\u0005\n\u00019A\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IA\u0006\u0005\u00069\u0001!\t!\b\u0005\u0006C\u0001!\tA\t\u0005\u0006[\u0001!\tA\t\u0005\u0006\u0015\u0002!\tA\t\u0005\u0006\u001d\u0002!\tA\t\u0005\u00065\u0002!Ia\u0017\u0002\"\u0007>t7/^7fe\u001e\u0013x.\u001e9IK\u0006\u0014HOY3biJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u0015-\taa]3sm\u0016\u0014(\"\u0001\u0007\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\u000f\rdWo\u001d;feB\u0011qCG\u0007\u00021)\u0011\u0011dC\u0001\u0005i\u0016\u001cH/\u0003\u0002\u001c1\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003=\u0001\u0002\"a\b\u0001\u000e\u0003%AQ!\u0006\u0002A\u0002Y\t\u0011\u0007^3ti\u000e{gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCRL5/Q2dKN\u001c\u0018N\u00197f/\",g.\u00128bE2,G\rF\u0001$!\t\u0001B%\u0003\u0002&#\t!QK\\5uQ\t\u0019q\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00051J#aC\"mkN$XM\u001d+fgR\fa\t^3ti\u000e{gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCRL5/Q2dKN\u001c\u0018N\u00197f/\",gNT3x\u000fJ|W\u000f]\"p_J$\u0017N\\1u_JL5/\u00128bE2,G\r\u000b\u0004\u0005O=\u0002dgN\u0001\u0006if\u0004Xm\u001d\u0017\u0002c\u0011\n!'\u0003\u00024i\u0005)1JU!G)*\u0011Q'K\u0001\u0005)f\u0004X-\u0001\ttKJ4XM\u001d)s_B,'\u000f^5fg2\u001a\u0001HQ$,\u000bebTh\u0010!\u0011\u0005!R\u0014BA\u001e*\u0005U\u0019E.^:uKJ\u001cuN\u001c4jOB\u0013x\u000e]3sif\f1a[3zC\u0005q\u0014!J4s_V\u0004hfY8pe\u0012Lg.\u0019;pe:\u0012XMY1mC:\u001cWM\f9s_R|7m\u001c7t\u0003\u00151\u0018\r\\;fC\u0005\t\u0015\u0001E2mCN\u001c\u0018n\u0019\u0017d_:\u001cX/\\3sW\u0015IDhQ FC\u0005!\u0015\u0001H8gMN,Go\u001d\u0018u_BL7M\f8v[:\u0002\u0018M\u001d;ji&|gn]\u0011\u0002\r\u0006\t\u0011gK\u0003:y!{T)I\u0001J\u0003\u0001zgMZ:fiNtCo\u001c9jG:\u0012X\r\u001d7jG\u0006$\u0018n\u001c8/M\u0006\u001cGo\u001c:\u0002\u0019R,7\u000f\u001e*fU>Lg.\u001b8h'R\fG/[2NK6\u0014WM]$fiN\f5o]5h]6,g\u000e^:CC\u000e\\w\u000b[3o\u001d\u0016<xI]8va\u000e{wN\u001d3j]\u0006$xN]%t\u000b:\f'\r\\3eQ\u0019)qe\f'7\u001b2\n\u0011\u0007L\u00029\u0005\u001e\u000b\u0001\u000b^3tiN#\u0018\r^5d\u001b\u0016l'-\u001a:SK6|g/\u001a3BMR,'oU3tg&|g\u000eV5nK>,H/\u0012=qSJLx\u000b[3o\u001d\u0016<xI]8va\u000e{wN\u001d3j]\u0006$xN]%t\u000b:\f'\r\\3eQ\u00191qe\f)7#2\n\u0011\u0007L\u00039\u0005\u001e\u0013vkK\u0003:yM{T+I\u0001U\u0003\u0005:'o\\;q]\r|gn];nKJt3/Z:tS>tg\u0006^5nK>,HOL7tC\u00051\u0016\u0001B\u001b1aAZS!\u000f\u001fY\u007fU\u000b\u0013!W\u0001&OJ|W\u000f\u001d\u0018d_:\u001cX/\\3s]5LgNL:fgNLwN\u001c\u0018uS6,w.\u001e;/[N\f\u0011cY8o]\u0016\u001cG/\u00118e%\u0016\u001cW-\u001b<f)\ta\u0016\u000e\u0005\u0002^O6\taL\u0003\u0002`A\u0006A!/Z9vKN$8O\u0003\u0002bE\u000611m\\7n_:T!\u0001D2\u000b\u0005\u0011,\u0017AB1qC\u000eDWMC\u0001g\u0003\ry'oZ\u0005\u0003Qz\u0013adQ8ogVlWM]$s_V\u0004\b*Z1si\n,\u0017\r\u001e*fgB|gn]3\t\u000b)<\u0001\u0019A6\u0002\u000fI,\u0017/^3tiB\u0011Q\f\\\u0005\u0003[z\u0013QdQ8ogVlWM]$s_V\u0004\b*Z1si\n,\u0017\r\u001e*fcV,7\u000f\u001e\u0015\u0005\u0001=|\u0014\u0010\u0005\u0002qo6\t\u0011O\u0003\u0002sg\u0006\u0019\u0011\r]5\u000b\u0005Q,\u0018a\u00026va&$XM\u001d\u0006\u0003m\u0016\fQA[;oSRL!\u0001_9\u0003\u0007Q\u000bw-I\u0001{\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8)\u000b\u0001ax(!\u0002\u0011\u0007u\f\t!D\u0001\u007f\u0015\ty\u0018/A\u0005fqR,gn]5p]&\u0019\u00111\u0001@\u0003\u0015\u0015CH/\u001a8e/&$\b\u000e\f\u0002\u0002\b\r\u0012\u0011\u0011\u0002\t\u0005\u0003\u0017\ty!\u0004\u0002\u0002\u000e)\u0011a\u000fG\u0005\u0005\u0003#\tiAA\u000bDYV\u001cH/\u001a:UKN$X\t\u001f;f]NLwN\\:)\r\u0001\t)bPA\u000e!\r\u0001\u0018qC\u0005\u0004\u00033\t(a\u0002+j[\u0016|W\u000f\u001e\u0010\u0002q\u0002")
public class ConsumerGroupHeartbeatRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest
    public void testConsumerGroupHeartbeatIsAccessibleWhenEnabled() {
        ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData()).build();
        ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse = this.connectAndReceive(consumerGroupHeartbeatRequest);
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.UNSUPPORTED_VERSION.code()), (Object)consumerGroupHeartbeatResponse.data());
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled() {
        RaftClusterInvocationContext.RaftClusterInstance raftCluster = (RaftClusterInvocationContext.RaftClusterInstance)this.cluster;
        Admin admin = this.cluster.createAdminClient();
        TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(raftCluster.brokers().values()).asScala()).toSeq(), (Seq<ControllerServer>)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(raftCluster.controllers().values()).asScala()).toSeq());
        ObjectRef consumerGroupHeartbeatRequest = ObjectRef.create((Object)((ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava())).build()));
        ObjectRef consumerGroupHeartbeatResponse = ObjectRef.create(null);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$1(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$2(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotNull((Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId());
        Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        Uuid topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, TestUtils$.MODULE$.createTopicWithAdminRaw$default$4(), TestUtils$.MODULE$.createTopicWithAdminRaw$default$5(), TestUtils$.MODULE$.createTopicWithAdminRaw$default$6());
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId()).setMemberEpoch(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch())).build();
        ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
        consumerGroupHeartbeatResponse.elem = null;
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$3(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest, expectedAssignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$4(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)2, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)expectedAssignment, (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setMemberId(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId()).setMemberEpoch(-1)).build();
        consumerGroupHeartbeatResponse.elem = this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest.elem);
        Assertions.assertEquals((int)-1, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled() {
        RaftClusterInvocationContext.RaftClusterInstance raftCluster = (RaftClusterInvocationContext.RaftClusterInstance)this.cluster;
        Admin admin = this.cluster.createAdminClient();
        String instanceId = "instanceId";
        TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(raftCluster.brokers().values()).asScala()).toSeq(), (Seq<ControllerServer>)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(raftCluster.controllers().values()).asScala()).toSeq());
        ObjectRef consumerGroupHeartbeatRequest = ObjectRef.create((Object)((ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava())).build()));
        ObjectRef consumerGroupHeartbeatResponse = ObjectRef.create(null);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$1(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$2(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotNull((Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId());
        Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        Uuid topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, TestUtils$.MODULE$.createTopicWithAdminRaw$default$4(), TestUtils$.MODULE$.createTopicWithAdminRaw$default$5(), TestUtils$.MODULE$.createTopicWithAdminRaw$default$6());
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberId(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId()).setMemberEpoch(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch())).build();
        ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
        consumerGroupHeartbeatResponse.elem = null;
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$3(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest, expectedAssignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$4(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotNull((Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId());
        Assertions.assertEquals((int)2, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)expectedAssignment, (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        String oldMemberId = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId();
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberId(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId()).setMemberEpoch(-2)).build();
        consumerGroupHeartbeatResponse.elem = this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest.elem);
        Assertions.assertEquals((int)-2, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava())).build();
        consumerGroupHeartbeatResponse.elem = this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest.elem);
        Assertions.assertNotNull((Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId());
        Assertions.assertEquals((int)2, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)expectedAssignment, (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        Assertions.assertNotEquals((Object)oldMemberId, (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId());
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1"), @ClusterConfigProperty(key="group.consumer.session.timeout.ms", value="5000"), @ClusterConfigProperty(key="group.consumer.min.session.timeout.ms", value="5000")})
    public void testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled() {
        RaftClusterInvocationContext.RaftClusterInstance raftCluster = (RaftClusterInvocationContext.RaftClusterInstance)this.cluster;
        Admin admin = this.cluster.createAdminClient();
        String instanceId = "instanceId";
        TestUtils$.MODULE$.createOffsetsTopicWithAdmin(admin, ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(raftCluster.brokers().values()).asScala()).toSeq(), (Seq<ControllerServer>)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(raftCluster.controllers().values()).asScala()).toSeq());
        ObjectRef consumerGroupHeartbeatRequest = ObjectRef.create((Object)((ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava())).build()));
        ObjectRef consumerGroupHeartbeatResponse = ObjectRef.create(null);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$1(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$2(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotNull((Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId());
        Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData.Assignment(), (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        Uuid topicId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, "foo", 3, TestUtils$.MODULE$.createTopicWithAdminRaw$default$4(), TestUtils$.MODULE$.createTopicWithAdminRaw$default$5(), TestUtils$.MODULE$.createTopicWithAdminRaw$default$6());
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberId(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberId()).setMemberEpoch(((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch())).build();
        ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava());
        consumerGroupHeartbeatResponse.elem = null;
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$3(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest, expectedAssignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$4(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)2, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)expectedAssignment, (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
        consumerGroupHeartbeatRequest.elem = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId("grp").setInstanceId(instanceId).setMemberEpoch(0).setRebalanceTimeoutMs(300000).setSubscribedTopicNames((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()).setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava())).build();
        consumerGroupHeartbeatResponse.elem = this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest.elem);
        Assertions.assertEquals((short)Errors.UNRELEASED_INSTANCE_ID.code(), (short)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().errorCode());
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ConsumerGroupHeartbeatRequestTest.$anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$5(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest, expectedAssignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerGroupHeartbeatRequestTest.$anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$6(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)4, (int)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().memberEpoch());
        Assertions.assertEquals((Object)expectedAssignment, (Object)((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data().assignment());
    }

    private ConsumerGroupHeartbeatResponse connectAndReceive(ConsumerGroupHeartbeatRequest request) {
        return (ConsumerGroupHeartbeatResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$1, ObjectRef consumerGroupHeartbeatRequest$1) {
        consumerGroupHeartbeatResponse$1.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$1.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$2(ObjectRef consumerGroupHeartbeatResponse$1) {
        return new StringBuilder(54).append("Could not join the group successfully. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$1, ObjectRef consumerGroupHeartbeatRequest$1, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$1) {
        consumerGroupHeartbeatResponse$1.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$1.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$1) : expectedAssignment$1 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled$4(ObjectRef consumerGroupHeartbeatResponse$1) {
        return new StringBuilder(50).append("Could not get partitions assigned. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$2, ObjectRef consumerGroupHeartbeatRequest$2) {
        consumerGroupHeartbeatResponse$2.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$2.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$2(ObjectRef consumerGroupHeartbeatResponse$2) {
        return new StringBuilder(68).append("Static member could not join the group successfully. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$2, ObjectRef consumerGroupHeartbeatRequest$2, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$2) {
        consumerGroupHeartbeatResponse$2.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$2.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$2) : expectedAssignment$2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testRejoiningStaticMemberGetsAssignmentsBackWhenNewGroupCoordinatorIsEnabled$4(ObjectRef consumerGroupHeartbeatResponse$2) {
        return new StringBuilder(64).append("Static member could not get partitions assigned. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$2.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$1(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$3, ObjectRef consumerGroupHeartbeatRequest$3) {
        consumerGroupHeartbeatResponse$3.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$3.elem);
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).data().errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ String $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$2(ObjectRef consumerGroupHeartbeatResponse$3) {
        return new StringBuilder(54).append("Could not join the group successfully. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$3(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$3, ObjectRef consumerGroupHeartbeatRequest$3, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$3) {
        consumerGroupHeartbeatResponse$3.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$3.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$3) : expectedAssignment$3 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$4(ObjectRef consumerGroupHeartbeatResponse$3) {
        return new StringBuilder(50).append("Could not get partitions assigned. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$5(ConsumerGroupHeartbeatRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$3, ObjectRef consumerGroupHeartbeatRequest$3, ConsumerGroupHeartbeatResponseData.Assignment expectedAssignment$3) {
        consumerGroupHeartbeatResponse$3.elem = $this.connectAndReceive((ConsumerGroupHeartbeatRequest)consumerGroupHeartbeatRequest$3.elem);
        if (((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).data().errorCode() == Errors.NONE.code()) {
            ConsumerGroupHeartbeatResponseData.Assignment assignment = ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).data().assignment();
            if (!(assignment != null ? !assignment.equals(expectedAssignment$3) : expectedAssignment$3 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testStaticMemberRemovedAfterSessionTimeoutExpiryWhenNewGroupCoordinatorIsEnabled$6(ObjectRef consumerGroupHeartbeatResponse$3) {
        return new StringBuilder(57).append("Could not re-join the group successfully. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$3.elem).append(".").toString();
    }

    public ConsumerGroupHeartbeatRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

