/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001E4Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C!-!)Q\u0004\u0001C!=!)Q\u0006\u0001C!]!)1\u0007\u0001C\u0001i!)q\f\u0001C\u0005A\nYC)\u001a7fi\u0016$v\u000e]5dgJ+\u0017/^3ti^KG\u000f\u001b#fY\u0016$\u0018n\u001c8ESN\f'\r\\3e)\u0016\u001cHO\u0003\u0002\n\u0015\u000511/\u001a:wKJT\u0011aC\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\t\u0001\"\u0003\u0002\u0012\u0011\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0011q\u0002A\u0001\fEJ|7.\u001a:D_VtG/F\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\rIe\u000e^\u0001\u0017WJ\fg\r^\"p]R\u0014x\u000e\u001c7fe\u000e{gNZ5hgR\tq\u0004E\u0002!G\u0015j\u0011!\t\u0006\u0003Ee\t!bY8mY\u0016\u001cG/[8o\u0013\t!\u0013EA\u0002TKF\u0004\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\tU$\u0018\u000e\u001c\u0006\u0002U\u0005!!.\u0019<b\u0013\tasE\u0001\u0006Qe>\u0004XM\u001d;jKN\fqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002_A\u0019\u0001e\t\u0019\u0011\u0005=\t\u0014B\u0001\u001a\t\u0005-Y\u0015MZ6b\u0007>tg-[4\u00021Q,7\u000f\u001e#fY\u0016$XMU3d_J$7OU3rk\u0016\u001cH\u000f\u0006\u00026qA\u0011\u0001DN\u0005\u0003oe\u0011A!\u00168ji\")\u0011(\u0002a\u0001u\u00051\u0011/^8sk6\u0004\"a\u000f\"\u000f\u0005q\u0002\u0005CA\u001f\u001a\u001b\u0005q$BA \r\u0003\u0019a$o\\8u}%\u0011\u0011)G\u0001\u0007!J,G-\u001a4\n\u0005\r#%AB*ue&twM\u0003\u0002B3!\"QA\u0012+V!\t9%+D\u0001I\u0015\tI%*\u0001\u0005qe>4\u0018\u000eZ3s\u0015\tYE*\u0001\u0004qCJ\fWn\u001d\u0006\u0003\u001b:\u000bqA[;qSR,'O\u0003\u0002P!\u0006)!.\u001e8ji*\t\u0011+A\u0002pe\u001eL!a\u0015%\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\t1\u0006,I\u0001X\u0003\tQ8.I\u0001Z\u0003\u0015Y'/\u00194uQ\t)1\f\u0005\u0002];6\t!*\u0003\u0002_\u0015\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002/M,g\u000e\u001a#fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$HCA1m!\t\u0011'.D\u0001d\u0015\t!W-\u0001\u0005sKF,Xm\u001d;t\u0015\t1w-\u0001\u0004d_6lwN\u001c\u0006\u0003\u0017!T!!\u001b)\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tY7M\u0001\u000bEK2,G/\u001a+pa&\u001c7OU3ta>t7/\u001a\u0005\u0006[\u001a\u0001\rA\\\u0001\be\u0016\fX/Z:u!\t\u0011w.\u0003\u0002qG\n\u0019B)\u001a7fi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0002")
public class DeleteTopicsRequestWithDeletionDisabledTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public Seq<Properties> kraftControllerConfigs() {
        Seq<Properties> props = super.kraftControllerConfigs();
        ((Properties)props.head()).setProperty("delete.topic.enable", "false");
        return props;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = this.brokerCount();
        String x$2 = this.zkConnectOrNull();
        boolean x$3 = false;
        boolean x$4 = false;
        Some x$5 = new Some((Object)this.securityProtocol());
        Option<File> x$6 = this.trustStoreFile();
        Option<Properties> x$7 = this.serverSaslProperties();
        int x$8 = this.logDirCount();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$15();
        short x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfigs$default$18();
        Seq<Properties> props2 = TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$3, x$4, (Option<SecurityProtocol>)x$5, x$6, x$7, x$9, x$10, x$11, x$12, x$13, x$8, x$14, x$15, x$16, x$17, x$18);
        props2.foreach((Function1 & Serializable & scala.Serializable)properties -> {
            this.brokerPropertyOverrides(properties);
            return BoxedUnit.UNIT;
        });
        return (Seq)props2.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteRecordsRequest(String quorum) {
        String topic = "topic-1";
        DeleteTopicsRequest request = (DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Collections.singletonList(topic)).setTimeoutMs(1000)).build();
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request);
        Assertions.assertEquals((short)Errors.TOPIC_DELETION_DISABLED.code(), (short)response.data().responses().find(topic).errorCode());
        DeleteTopicsRequest v2request = new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Collections.singletonList(topic)).setTimeoutMs(1000)).build((short)2);
        DeleteTopicsResponse v2response = this.sendDeleteTopicsRequest(v2request);
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)v2response.data().responses().find(topic).errorCode());
    }

    private DeleteTopicsResponse sendDeleteTopicsRequest(DeleteTopicsRequest request) {
        return (DeleteTopicsResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.isKRaftTest() ? ListenerName.normalised((String)"CONTROLLER") : this.listenerName(), ClassTag$.MODULE$.apply(DeleteTopicsResponse.class));
    }
}

