/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.security.authorizer.AclEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0005\u000b\u0001=AQ\u0001\u0006\u0001\u0005\u0002UAQa\u0006\u0001\u0005BaAQ!\u000b\u0001\u0005B)BQ!\u0010\u0001\u0005\u0002yBQ\u0001\u0019\u0001\u0005\u0002\u0005DQA\u001a\u0001\u0005\u0002\u001dDQ!\u001c\u0001\u0005\n9D\u0011\"!\u0006\u0001#\u0003%I!a\u0006\u00035\u0011+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014V-];fgR$Vm\u001d;\u000b\u0005-a\u0011AB:feZ,'OC\u0001\u000e\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0006\n\u0005MQ!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u00051\u0002CA\t\u0001\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0002\u001a?A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t!QK\\5u\u0011\u0015\u0001#\u00011\u0001\"\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nA!\u001e;jY*\ta%\u0001\u0003kCZ\f\u0017B\u0001\u0015$\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00033-BQ\u0001L\u0002A\u00025\n\u0001\u0002^3ti&sgm\u001c\t\u0003]]j\u0011a\f\u0006\u0003aE\n1!\u00199j\u0015\t\u00114'A\u0004kkBLG/\u001a:\u000b\u0005Q*\u0014!\u00026v]&$(\"\u0001\u001c\u0002\u0007=\u0014x-\u0003\u00029_\tAA+Z:u\u0013:4w\u000e\u000b\u0002\u0004uA\u0011afO\u0005\u0003y=\u0012!BQ3g_J,W)Y2i\u0003y\"Xm\u001d;EKN\u001c'/\u001b2f\u00072,8\u000f^3s%\u0016\fX/Z:u\u0013:\u001cG.\u001e3j]\u001e\u001cE.^:uKJ\fU\u000f\u001e5pe&TX\rZ(qKJ\fG/[8ogR\u0011\u0011d\u0010\u0005\u0006\u0001\u0012\u0001\r!Q\u0001\u0007cV|'/^7\u0011\u0005\tKeBA\"H!\t!5$D\u0001F\u0015\t1e\"\u0001\u0004=e>|GOP\u0005\u0003\u0011n\ta\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001j\u0007\u0015\u0005\t5+f\u000b\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006A\u0001O]8wS\u0012,'O\u0003\u0002Sc\u00051\u0001/\u0019:b[NL!\u0001V(\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\t9\u0016,I\u0001Y\u0003\tQ8.I\u0001[\u0003\u0015Y'/\u00194uQ\t!A\f\u0005\u0002^=6\t\u0011+\u0003\u0002`#\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002}Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKF,Xm\u001d;Fq\u000edW\u000fZ5oO\u000ecWo\u001d;fe\u0006+H\u000f[8sSj,Gm\u00149fe\u0006$\u0018n\u001c8t)\tI\"\rC\u0003A\u000b\u0001\u0007\u0011\t\u000b\u0003\u0006\u001bV#GFA,ZQ\t)A,\u0001\u000euKN$H)Z:de&\u0014Wm\u00117vgR,'OU3rk\u0016\u001cH\u000f\u0006\u0002\u001aQ\")\u0011N\u0002a\u0001U\u0006\u0011\u0013N\\2mk\u0012,7\t\\;ti\u0016\u0014\u0018)\u001e;i_JL'0\u001a3Pa\u0016\u0014\u0018\r^5p]N\u0004\"AG6\n\u00051\\\"a\u0002\"p_2,\u0017M\\\u0001\u001bg\u0016tG\u000fR3tGJL'-Z\"mkN$XM\u001d*fcV,7\u000f\u001e\u000b\u0004_j|\bC\u00019y\u001b\u0005\t(B\u0001:t\u0003!\u0011X-];fgR\u001c(B\u0001;v\u0003\u0019\u0019w.\\7p]*\u0011QB\u001e\u0006\u0003oV\na!\u00199bG\",\u0017BA=r\u0005]!Um]2sS\n,7\t\\;ti\u0016\u0014(+Z:q_:\u001cX\rC\u0003|\u000f\u0001\u0007A0A\u0004sKF,Xm\u001d;\u0011\u0005Al\u0018B\u0001@r\u0005Y!Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$\b\"CA\u0001\u000fA\u0005\t\u0019AA\u0002\u0003-!Wm\u001d;j]\u0006$\u0018n\u001c8\u0011\u000bi\t)!!\u0003\n\u0007\u0005\u001d1D\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002\u0007\u0002\u000f9,Go^8sW&!\u00111CA\u0007\u00051\u0019vnY6fiN+'O^3s\u0003\u0011\u001aXM\u001c;EKN\u001c'/\u001b2f\u00072,8\u000f^3s%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012TCAA\rU\u0011\t\u0019!a\u0007,\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\n\u001c\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\t\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DescribeClusterRequestTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty("offsets.topic.num.partitions", "1");
        properties.setProperty("default.replication.factor", "2");
        properties.setProperty("broker.rack", new StringBuilder(5).append("rack/").append(properties.getProperty("broker.id")).toString());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeClusterRequestIncludingClusterAuthorizedOperations(String quorum) {
        this.testDescribeClusterRequest(true);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeClusterRequestExcludingClusterAuthorizedOperations(String quorum) {
        this.testDescribeClusterRequest(false);
    }

    public void testDescribeClusterRequest(boolean includeClusterAuthorizedOperations) {
        scala.collection.immutable.Set expectedBrokers = ((TraversableOnce)this.brokers().map((Function1 & Serializable & scala.Serializable)server -> new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(server.config().brokerId()).setHost("localhost").setPort(server.socketServer().boundPort(this.listenerName())).setRack((String)server.config().rack().orNull(Predef$.MODULE$.$conforms())), Buffer$.MODULE$.canBuildFrom())).toSet();
        IntRef expectedControllerId = IntRef.create((int)0);
        if (!this.isKRaftTest()) {
            expectedControllerId.elem = ((KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeClusterRequestTest.$anonfun$testDescribeClusterRequest$2(x$1)))).last()).config().brokerId();
        }
        String expectedClusterId = ((KafkaBroker)this.brokers().last()).clusterId();
        int expectedClusterAuthorizedOperations = includeClusterAuthorizedOperations ? Utils.to32BitField((Set)((Set)CollectionConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(AclEntry.supportedOperations((ResourceType)ResourceType.CLUSTER)).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)x$2.code()), Set$.MODULE$.canBuildFrom())).asJava())) : Integer.MIN_VALUE;
        this.ensureConsistentKRaftMetadata();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.DESCRIBE_CLUSTER.oldestVersion()), (int)ApiKeys.DESCRIBE_CLUSTER.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            DescribeClusterRequest describeClusterRequest = new DescribeClusterRequest.Builder(new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(includeClusterAuthorizedOperations)).build((short)version);
            DescribeClusterResponse describeClusterResponse = this.sentDescribeClusterRequest(describeClusterRequest, this.sentDescribeClusterRequest$default$2());
            if (this.isKRaftTest()) {
                Assertions.assertTrue((boolean)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).contains(describeClusterResponse.data().controllerId()));
            } else {
                Assertions.assertEquals((int)expectedControllerId$1.elem, (int)describeClusterResponse.data().controllerId());
            }
            Assertions.assertEquals((Object)expectedClusterId, (Object)describeClusterResponse.data().clusterId());
            Assertions.assertEquals((int)expectedClusterAuthorizedOperations, (int)describeClusterResponse.data().clusterAuthorizedOperations());
            Assertions.assertEquals((Object)expectedBrokers, (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeClusterResponse.data().brokers()).asScala()).toSet());
        });
    }

    private DescribeClusterResponse sentDescribeClusterRequest(DescribeClusterRequest request, Option<SocketServer> destination) {
        return (DescribeClusterResponse)this.connectAndReceive((AbstractRequest)request, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeClusterResponse.class));
    }

    private Option<SocketServer> sentDescribeClusterRequest$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClusterRequest$2(KafkaServer x$1) {
        return x$1.kafkaController().isActive();
    }
}

