/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchManager;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.FetchSessionCache;
import kafka.server.FetchSessionCache$;
import kafka.server.FetchSessionCacheShard;
import kafka.server.FetchSessionCacheShard$;
import kafka.server.FetchSessionTest$;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0001\t\u0015e\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBQa\u000f\u0001\u0005\u0002qBQ!\u0014\u0001\u0005\u0002qBQA\u0015\u0001\u0005\u0002MCQ!\u0019\u0001\u0005\n\tDQ\u0001\u001c\u0001\u0005\u0002qBQA\u001c\u0001\u0005\u0002qBq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000fC\u0004\u0002\b\u0001\u0001\u000b\u0011\u0002:\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!I\u0011\u0011\f\u0001\u0012\u0002\u0013\u0005\u00111\f\u0005\b\u0003c\u0002A\u0011AA:\u0011\u0019\ti\b\u0001C\u0001y!1\u0011\u0011\u0011\u0001\u0005\u0002qBa!!\"\u0001\t\u0003a\u0004bBAE\u0001\u0011\u0005\u00111\u0012\u0005\u0007\u0003k\u0003A\u0011\u0001\u001f\t\r\u0005e\u0006\u0001\"\u0001=\u0011\u0019\ti\f\u0001C\u0001y!1\u0011\u0011\u0019\u0001\u0005\u0002qBa!!2\u0001\t\u0003a\u0004bBAe\u0001\u0011%\u00111\u001a\u0005\b\u0003?\u0004A\u0011BAq\u0011\u0019\t9\u000f\u0001C\u0001y!9\u00111\u001e\u0001\u0005\u0002\u00055\bB\u0002B\u0005\u0001\u0011\u0005A\b\u0003\u0004\u0003\u000e\u0001!\t\u0001\u0010\u0005\u0007\u0005#\u0001A\u0011\u0001\u001f\t\r\tU\u0001\u0001\"\u0001=\u0011\u0019\u0011I\u0002\u0001C\u0001y!1!Q\u0004\u0001\u0005\u0002qBaA!\t\u0001\t\u0003a\u0004B\u0002B\u0013\u0001\u0011\u0005A\bC\u0004\u0003*\u0001!IAa\u000b\t\r\tM\u0003\u0001\"\u0001=\u0011\u0019\u00119\u0006\u0001C\u0001y!1!1\f\u0001\u0005\u0002q:qA!\u001b,\u0011\u0003\u0011YG\u0002\u0004+W!\u0005!Q\u000e\u0005\u0007o\u001d\"\tAa\u001c\t\u000f\t\u0015q\u0005\"\u0001\u0003r\t\u0001b)\u001a;dQN+7o]5p]R+7\u000f\u001e\u0006\u0003Y5\naa]3sm\u0016\u0014(\"\u0001\u0018\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\r\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0004C\u0001\u001e\u0001\u001b\u0005Y\u0013!C1gi\u0016\u0014X)Y2i)\u0005i\u0004C\u0001\u001a?\u0013\ty4G\u0001\u0003V]&$\bF\u0001\u0002B!\t\u00115*D\u0001D\u0015\t!U)A\u0002ba&T!AR$\u0002\u000f),\b/\u001b;fe*\u0011\u0001*S\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0015\u0006\u0019qN]4\n\u00051\u001b%!C!gi\u0016\u0014X)Y2i\u0003A!Xm\u001d;OK^\u001cVm]:j_:LE\r\u000b\u0002\u0004\u001fB\u0011!\tU\u0005\u0003#\u000e\u0013A\u0001V3ti\u0006\u0019\u0012m]:feR\u001c\u0015m\u00195f\u0007>tG/Y5ogR\u0019Q\bV-\t\u000bU#\u0001\u0019\u0001,\u0002\u0015\r\f7\r[3TQ\u0006\u0014H\r\u0005\u0002;/&\u0011\u0001l\u000b\u0002\u0017\r\u0016$8\r[*fgNLwN\\\"bG\",7\u000b[1sI\")!\f\u0002a\u00017\u0006Q1/Z:tS>t\u0017\nZ:\u0011\u0007Ibf,\u0003\u0002^g\tQAH]3qK\u0006$X\r\u001a \u0011\u0005Iz\u0016B\u000114\u0005\rIe\u000e^\u0001\fIVlW._\"sK\u0006$X\r\u0006\u0002dUB\u0011Am\u001a\b\u0003u\u0015L!AZ\u0016\u0002\u0019\u0019+Go\u00195TKN\u001c\u0018n\u001c8\n\u0005!L'!C\"B\u0007\"+u,T!Q\u0015\t17\u0006C\u0003l\u000b\u0001\u0007a,\u0001\u0003tSj,\u0017\u0001\u0005;fgR\u001cVm]:j_:\u001c\u0015m\u00195fQ\t1q*\u0001\ruKN$(+Z:ju\u0016\u001c\u0015m\u00195fIN+7o]5p]ND#aB(\u0002\u001f\u0015k\u0005\u000bV-`!\u0006\u0013Fk\u0018'J'R+\u0012A\u001d\t\u0004gbTX\"\u0001;\u000b\u0005U4\u0018\u0001B;uS2T\u0011a^\u0001\u0005U\u00064\u0018-\u0003\u0002zi\n!A*[:u!\rY\u00181A\u0007\u0002y*\u0011QP`\u0001\u0007G>lWn\u001c8\u000b\u00059z(bAA\u0001\u0013\u00061\u0011\r]1dQ\u0016L1!!\u0002}\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0001\tF\u001bB#\u0016l\u0018)B%R{F*S*UA\u0005i1M]3bi\u0016\u0014V-];fgR$B\"!\u0004\u0002\u001a\u0005\r\u0012\u0011IA#\u0003\u001f\u0002B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'a\u0018\u0001\u0003:fcV,7\u000f^:\n\t\u0005]\u0011\u0011\u0003\u0002\r\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0005\b\u00037Q\u0001\u0019AA\u000f\u0003!iW\r^1eCR\f\u0007\u0003BA\b\u0003?IA!!\t\u0002\u0012\tia)\u001a;dQ6+G/\u00193bi\u0006Dq!!\n\u000b\u0001\u0004\t9#A\u0005gKR\u001c\u0007\u000eR1uCB91/!\u000b\u0002.\u0005M\u0012bAA\u0016i\n\u0019Q*\u00199\u0011\u0007m\fy#C\u0002\u00022q\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u00026\u0005mb\u0002BA\b\u0003oIA!!\u000f\u0002\u0012\u0005aa)\u001a;dQJ+\u0017/^3ti&!\u0011QHA \u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*!\u0011\u0011HA\t\u0011\u0019\t\u0019E\u0003a\u0001e\u0006AAo\u001c$pe\u001e,G\u000fC\u0004\u0002H)\u0001\r!!\u0013\u0002\u001d%\u001chI]8n\r>dGn\\<feB\u0019!'a\u0013\n\u0007\u000553GA\u0004C_>dW-\u00198\t\u0013\u0005E#\u0002%AA\u0002\u0005M\u0013a\u0002<feNLwN\u001c\t\u0004e\u0005U\u0013bAA,g\t)1\u000b[8si\u000692M]3bi\u0016\u0014V-];fgR$C-\u001a4bk2$H%N\u000b\u0003\u0003;RC!a\u0015\u0002`-\u0012\u0011\u0011\r\t\u0005\u0003G\ni'\u0004\u0002\u0002f)!\u0011qMA5\u0003%)hn\u00195fG.,GMC\u0002\u0002lM\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty'!\u001a\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000fde\u0016\fG/\u001a*fcV,7\u000f^,ji\"|W\u000f\u001e+pa&\u001c\u0017\nZ:\u0015\u0015\u00055\u0011QOA<\u0003s\nY\bC\u0004\u0002\u001c1\u0001\r!!\b\t\u000f\u0005\u0015B\u00021\u0001\u0002(!1\u00111\t\u0007A\u0002IDq!a\u0012\r\u0001\u0004\tI%A\u000buKN$8)Y2iK\u0012dU-\u00193fe\u0016\u0003xn\u00195)\u00055y\u0015\u0001\u0006;fgRd\u0015m\u001d;GKR\u001c\u0007.\u001a3Fa>\u001c\u0007\u000e\u000b\u0002\u000f\u001f\u0006\tB/Z:u\r\u0016$8\r\u001b*fcV,7\u000f^:)\u0005=y\u0015a\u0007;fgRLen\u0019:f[\u0016tG/\u00197GKR\u001c\u0007nU3tg&|g\u000eF\u0002>\u0003\u001bCq!a$\u0011\u0001\u0004\tI%\u0001\u0007vg\u0016\u001cHk\u001c9jG&#7\u000fK\u0004\u0011\u0003'\u000b\u0019+!*\u0011\t\u0005U\u0015qT\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006A\u0001O]8wS\u0012,'OC\u0002\u0002\u001e\u0016\u000ba\u0001]1sC6\u001c\u0018\u0002BAQ\u0003/\u00131BV1mk\u0016\u001cv.\u001e:dK\u0006A!m\\8mK\u0006t7\u000f\f\u0003\u0002(\u0006%\u0016$A\u0001\u001a\u0003\u0001A3\u0001EAW!\u0011\ty+!-\u000e\u0005\u0005m\u0015\u0002BAZ\u00037\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u00039\"Xm\u001d;GKR\u001c\u0007nU3tg&|gnV5uQVs7N\\8x]&#w\n\u001c3SKF,Xm\u001d;WKJ\u001c\u0018n\u001c8)\u0005Ey\u0015!\b;fgR4U\r^2i'\u0016\u001c8/[8o/&$\b.\u00168l]><h.\u00133)\u0005Iy\u0015A\u000f;fgRLen\u0019:f[\u0016tG/\u00197GKR\u001c\u0007nU3tg&|gnV5uQ&#7o\u00165f]N+7o]5p]\u0012{Wm\u001d(piV\u001bX-\u00133tQ\t\u0019r*A\u001cuKN$\u0018J\\2sK6,g\u000e^1m\r\u0016$8\r[*fgNLwN\\,ji\"|W\u000f^%eg^CWM\\*fgNLwN\\+tKNLEm\u001d\u0015\u0003)=\u000b\u0001\u0006^3ti\u001a+Go\u00195TKN\u001c\u0018n\u001c8Va\u0012\fG/\u001a+pa&\u001c\u0017\nZ:Ce>\\WM]*jI\u0016D#!F(\u0002\u001f9|WI\u001d:peJ+7\u000f]8og\u0016,\"!!4\u0011\t\u0005=\u00171\u001c\b\u0005\u0003#\f9.\u0004\u0002\u0002T*\u0019\u0011Q\u001b?\u0002\u000f5,7o]1hK&!\u0011\u0011\\Aj\u0003E1U\r^2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003{\tiN\u0003\u0003\u0002Z\u0006M\u0017!D3se>\u0014(+Z:q_:\u001cX\r\u0006\u0003\u0002N\u0006\r\bbBAs/\u0001\u0007\u00111K\u0001\nKJ\u0014xN]\"pI\u0016\fA\u0004^3tiJ+7o\u001c7wKVs7N\\8x]B\u000b'\u000f^5uS>t7\u000f\u000b\u0002\u0019\u001f\u00061B/Z:u)>4uN]4fiB\u000b'\u000f^5uS>t7\u000fF\u0003>\u0003_\f\u0019\u0010C\u0004\u0002rf\u0001\r!!\u0013\u0002#\u0019|wn\u0015;beR\u001c(+Z:pYZ,G\rC\u0004\u0002vf\u0001\r!!\u0013\u0002\u001f\u0019|w.\u00128egJ+7o\u001c7wK\u0012Ds!GA}\u0003\u007f\u0014\t\u0001\u0005\u0003\u0002\u0016\u0006m\u0018\u0002BA\u007f\u0003/\u0013A\"T3uQ>$7k\\;sG\u0016\fQA^1mk\u0016d#Aa\u0001\"\u0005\t\u0015\u0011aE5e+N\fw-Z\"p[\nLg.\u0019;j_:\u001c\bfA\r\u0002.\u0006\tC/Z:u+B$\u0017\r^3B]\u0012<UM\\3sCR,'+Z:q_:\u001cX\rR1uC\"\u0012!dT\u0001\u001bi\u0016\u001cHOR3uG\"\u001cVm]:j_:,\u0005\u0010]5sCRLwN\u001c\u0015\u00037=\u000bQ\u0004^3tiB\u0013\u0018N^5mK\u001e,GmU3tg&|g\u000eS1oI2Lgn\u001a\u0015\u00039=\u000b\u0001\u0004^3tij+'o\\*ju\u00164U\r^2i'\u0016\u001c8/[8oQ\tir*\u0001\nuKN$H)\u001b<fe\u001eLgnZ#q_\u000eD\u0007F\u0001\u0010P\u0003)\"Xm\u001d;EKB\u0014\u0018n\u001c:ji&TXm\u001d)beRLG/[8og^KG\u000f\u001b*fG>\u0014Hm](oYfD#aH(\u0002IQ,7\u000f^\"bG\",G\rU1si&$\u0018n\u001c8FcV\fGn]!oI\"\u000b7\u000f[\"pI\u0016D#\u0001I(\u00027Q,7\u000f^'bs\n,'+Z:pYZ,WK\\6o_^tg*Y7fQ\t\ts*A\u000bbgN,'\u000f\u001e)beRLG/[8og>\u0013H-\u001a:\u0015\u000bu\u0012iCa\u000e\t\u000f\t=\"\u00051\u0001\u00032\u000591m\u001c8uKb$\bc\u0001\u001e\u00034%\u0019!QG\u0016\u0003\u0019\u0019+Go\u00195D_:$X\r\u001f;\t\u000f\te\"\u00051\u0001\u0003<\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000b\tu\"Q\n>\u000f\t\t}\"\u0011\n\b\u0005\u0005\u0003\u00129%\u0004\u0002\u0003D)\u0019!QI\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014b\u0001B&g\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B(\u0005#\u00121aU3r\u0015\r\u0011YeM\u0001Gi\u0016\u001cHOR3uG\"\u001cVm]:j_:\u001c\u0015m\u00195f?\u001e,Go\u00155be\u0012,GmQ1dQ\u0016|&/\u001a;sS\u00164Xm]\"bG\",gI]8n\u0007>\u0014(/Z2u'\u0016<W.\u001a8uQ\t\u0019s*A\u0016uKN$h)\u001a;dQN+7o]5p]\u000e\u000b7\r[3`%>,h\u000e\u001a*pE&t7/\u00138u_NC\u0017M\u001d3tQ\t!s*\u0001!uKN$h)\u001a;dQN+7o]5p]\u000e\u000b7\r[3`%>,h\u000e\u001a*pE&t7/\u00138u_NC\u0017M\u001d3t?^CWM\\%oi\u0016<WM](wKJ4Gn\\<tQ\t)s\nK\u0004\u0001\u0005C\nyPa\u001a\u0011\u0007\t\u0013\u0019'C\u0002\u0003f\r\u0013q\u0001V5nK>,HOH\u0001y\u0003A1U\r^2i'\u0016\u001c8/[8o)\u0016\u001cH\u000f\u0005\u0002;OM\u0011q%\r\u000b\u0003\u0005W*\"Aa\u001d\u0011\r\tU$1\u0010B@\u001b\t\u00119HC\u0002\u0003zQ\faa\u001d;sK\u0006l\u0017\u0002\u0002B?\u0005o\u0012aa\u0015;sK\u0006l\u0007\u0003BAK\u0005\u0003KAAa!\u0002\u0018\nI\u0011I]4v[\u0016tGo\u001d")
public class FetchSessionTest {
    private final java.util.List<TopicIdPartition> EMPTY_PART_LIST = Collections.unmodifiableList(new ArrayList());

    public static Stream<Arguments> idUsageCombinations() {
        return FetchSessionTest$.MODULE$.idUsageCombinations();
    }

    @AfterEach
    public void afterEach() {
        FetchSessionCache$.MODULE$.metricsGroup().removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSIONS());
        FetchSessionCache$.MODULE$.metricsGroup().removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED());
        FetchSessionCache$.MODULE$.metricsGroup().removeMetric(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC());
        FetchSessionCache$.MODULE$.counter().set(0);
    }

    @Test
    public void testNewSessionId() {
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(3, 100L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> Assertions.assertTrue((cacheShard.newSessionId() > 0 ? 1 : 0) != 0));
    }

    public void assertCacheContains(FetchSessionCacheShard cacheShard, Seq<Object> sessionIds) {
        IntRef i = IntRef.create((int)0);
        sessionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sessionId -> {
            ++i$1.elem;
            Assertions.assertTrue((boolean)cacheShard.get(sessionId).isDefined(), (String)new StringBuilder(27).append("Missing session ").append(i$1.elem).append(" out of ").append(sessionIds.size()).append(" (").append(sessionId).append(")").toString());
        });
        Assertions.assertEquals((int)sessionIds.size(), (int)cacheShard.size());
    }

    private ImplicitLinkedHashCollection<CachedPartition> dummyCreate(int size) {
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection(size);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> cacheMap.add((ImplicitLinkedHashCollection.Element)new CachedPartition("test", Uuid.randomUuid(), i)));
        return cacheMap;
    }

    @Test
    public void testSessionCache() {
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(3, 100L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertEquals((int)0, (int)cacheShard.size());
        int id1 = cacheShard.maybeCreateSession(0L, false, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id2 = cacheShard.maybeCreateSession(10L, false, 20, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        int id3 = cacheShard.maybeCreateSession(20L, false, 30, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(30));
        Assertions.assertEquals((int)0, (int)cacheShard.maybeCreateSession(30L, false, 40, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(40)));
        Assertions.assertEquals((int)0, (int)cacheShard.maybeCreateSession(40L, false, 5, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5)));
        this.assertCacheContains(cacheShard, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2, id3}));
        cacheShard.touch((FetchSession)cacheShard.get(id1).get(), 200L);
        int id4 = cacheShard.maybeCreateSession(210L, false, 11, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(11));
        this.assertCacheContains(cacheShard, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id3, id4}));
        cacheShard.touch((FetchSession)cacheShard.get(id1).get(), 400L);
        cacheShard.touch((FetchSession)cacheShard.get(id3).get(), 390L);
        cacheShard.touch((FetchSession)cacheShard.get(id4).get(), 400L);
        int id5 = cacheShard.maybeCreateSession(410L, false, 50, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(50));
        this.assertCacheContains(cacheShard, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id4, id5}));
        Assertions.assertEquals((int)0, (int)cacheShard.maybeCreateSession(410L, false, 5, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5)));
        int id6 = cacheShard.maybeCreateSession(410L, true, 5, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cacheShard, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id5, id6}));
    }

    @Test
    public void testResizeCachedSessions() {
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(2, 100L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertEquals((long)0L, (long)cacheShard.totalPartitions());
        Assertions.assertEquals((int)0, (int)cacheShard.size());
        Assertions.assertEquals((long)0L, (long)cacheShard.evictionsMeter().count());
        int id1 = cacheShard.maybeCreateSession(0L, false, 2, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(2));
        Assertions.assertTrue((id1 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cacheShard, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1}));
        FetchSession session1 = (FetchSession)cacheShard.get(id1).get();
        Assertions.assertEquals((int)2, (int)session1.size());
        Assertions.assertEquals((long)2L, (long)cacheShard.totalPartitions());
        Assertions.assertEquals((int)1, (int)cacheShard.size());
        Assertions.assertEquals((long)0L, (long)cacheShard.evictionsMeter().count());
        int id2 = cacheShard.maybeCreateSession(0L, false, 4, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(4));
        FetchSession session2 = (FetchSession)cacheShard.get(id2).get();
        Assertions.assertTrue((id2 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cacheShard, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2}));
        Assertions.assertEquals((long)6L, (long)cacheShard.totalPartitions());
        Assertions.assertEquals((int)2, (int)cacheShard.size());
        Assertions.assertEquals((long)0L, (long)cacheShard.evictionsMeter().count());
        cacheShard.touch(session1, 200L);
        cacheShard.touch(session2, 200L);
        int id3 = cacheShard.maybeCreateSession(200L, false, 5, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        Assertions.assertTrue((id3 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cacheShard, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2, id3}));
        Assertions.assertEquals((long)9L, (long)cacheShard.totalPartitions());
        Assertions.assertEquals((int)2, (int)cacheShard.size());
        Assertions.assertEquals((long)1L, (long)cacheShard.evictionsMeter().count());
        cacheShard.remove(id3);
        this.assertCacheContains(cacheShard, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2}));
        Assertions.assertEquals((int)1, (int)cacheShard.size());
        Assertions.assertEquals((long)1L, (long)cacheShard.evictionsMeter().count());
        Assertions.assertEquals((long)4L, (long)cacheShard.totalPartitions());
        java.util.Iterator iter = session2.partitionMap().iterator();
        iter.next();
        iter.remove();
        Assertions.assertEquals((int)3, (int)session2.size());
        Assertions.assertEquals((int)4, (int)session2.cachedSize());
        cacheShard.touch(session2, session2.lastUsedMs());
        Assertions.assertEquals((long)3L, (long)cacheShard.totalPartitions());
    }

    private java.util.List<TopicIdPartition> EMPTY_PART_LIST() {
        return this.EMPTY_PART_LIST;
    }

    public FetchRequest createRequest(FetchMetadata metadata, java.util.Map<TopicPartition, FetchRequest.PartitionData> fetchData, java.util.List<TopicIdPartition> toForget, boolean isFromFollower, short version) {
        return (FetchRequest)new FetchRequest.Builder(version, version, isFromFollower ? 1 : -1, isFromFollower ? 1L : -1L, 0, 0, fetchData).metadata(metadata).removed(toForget).build();
    }

    public short createRequest$default$5() {
        return ApiKeys.FETCH.latestVersion();
    }

    public FetchRequest createRequestWithoutTopicIds(FetchMetadata metadata, java.util.Map<TopicPartition, FetchRequest.PartitionData> fetchData, java.util.List<TopicIdPartition> toForget, boolean isFromFollower) {
        return (FetchRequest)new FetchRequest.Builder(12, 12, isFromFollower ? 1 : -1, isFromFollower ? 1L : -1L, 0, 0, fetchData).metadata(metadata).removed(toForget).build();
    }

    @Test
    public void testCachedLeaderEpoch() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid())}))).asJava();
        TopicIdPartition tp0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicIds).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        requestData1.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.empty()));
        requestData1.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1))));
        requestData1.put(tp2.topicPartition(), new FetchRequest.PartitionData(tp2.topicId(), 10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(2))));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, requestData1, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        scala.collection.immutable.Map epochs1 = FetchSessionTest.cachedLeaderEpochs$1(context1);
        Assertions.assertEquals(Optional.empty(), (Object)epochs1.apply((Object)tp0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs1.apply((Object)tp1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs1.apply((Object)tp2));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> response = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        response.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(tp0.partition()).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        response.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        response.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.partition()).setHighWatermark(5L).setLastStableOffset(5L).setLogStartOffset(5L));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request2 = this.createRequest(new FetchMetadata(sessionId, 1), requestData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        scala.collection.immutable.Map epochs2 = FetchSessionTest.cachedLeaderEpochs$1(context2);
        Assertions.assertEquals(Optional.empty(), (Object)epochs1.apply((Object)tp0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs2.apply((Object)tp1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs2.apply((Object)tp2));
        context2.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData3 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        requestData3.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(6))));
        requestData3.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 10L, 0L, 100, Optional.empty()));
        requestData3.put(tp2.topicPartition(), new FetchRequest.PartitionData(tp2.topicId(), 10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(3))));
        FetchRequest request3 = this.createRequest(new FetchMetadata(sessionId, 2), requestData3, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        scala.collection.immutable.Map epochs3 = FetchSessionTest.cachedLeaderEpochs$1(fetchManager.newContext(request3.version(), request3.metadata(), request3.isFromFollower(), request3.fetchData(topicNames), request3.forgottenTopics(topicNames), topicNames));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)6)), (Object)epochs3.apply((Object)tp0));
        Assertions.assertEquals(Optional.empty(), (Object)epochs3.apply((Object)tp1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)3)), (Object)epochs3.apply((Object)tp2));
    }

    @Test
    public void testLastFetchedEpoch() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid())}))).asJava();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicIds).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        TopicIdPartition tp0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        requestData1.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.empty(), Optional.empty()));
        requestData1.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()));
        requestData1.put(tp2.topicPartition(), new FetchRequest.PartitionData(tp2.topicId(), 10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(2)), Optional.of(Predef$.MODULE$.int2Integer(1))));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, requestData1, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context1));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context1));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> response = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        response.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(tp0.partition()).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        response.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        response.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.partition()).setHighWatermark(5L).setLastStableOffset(5L).setLogStartOffset(5L));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request2 = this.createRequest(new FetchMetadata(sessionId, 1), requestData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
        context2.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData3 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        requestData3.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(6)), Optional.of(Predef$.MODULE$.int2Integer(5))));
        requestData3.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 10L, 0L, 100, Optional.empty(), Optional.empty()));
        requestData3.put(tp2.topicPartition(), new FetchRequest.PartitionData(tp2.topicId(), 10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(3)), Optional.of(Predef$.MODULE$.int2Integer(3))));
        FetchRequest request3 = this.createRequest(new FetchMetadata(sessionId, 2), requestData3, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context3 = fetchManager.newContext(request3.version(), request3.metadata(), request3.isFromFollower(), request3.fetchData(topicNames), request3.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.of(BoxesRunTime.boxToInteger((int)6))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.of(BoxesRunTime.boxToInteger((int)5))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
    }

    @Test
    public void testFetchRequests() {
        FetchResponse resp8;
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicNames).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        TopicIdPartition tp0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 0));
        TopicIdPartition tp3 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        FetchRequest request = this.createRequest(FetchMetadata.LEGACY, new HashMap<TopicPartition, FetchRequest.PartitionData>(), this.EMPTY_PART_LIST(), true, this.createRequest$default$5());
        FetchContext context = fetchManager.newContext(request.version(), request.metadata(), request.isFromFollower(), request.fetchData(topicNames), request.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(SessionlessFetchContext.class, context.getClass());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.empty()));
        reqData2.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 10L, 0L, 100, Optional.empty()));
        FetchRequest request2 = this.createRequest(FetchMetadata.INITIAL, reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context2.getClass());
        java.util.Iterator<Map.Entry<TopicPartition, FetchRequest.PartitionData>> reqData2Iter = reqData2.entrySet().iterator();
        context2.foreachPartition((Function2 & Serializable & scala.Serializable)(topicIdPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$2(reqData2Iter, topicIds, topicIdPart, data);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(tp0).get()));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(tp1).get()));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData2.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(respData2).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                FetchResponseData.PartitionData data = (FetchResponseData.PartitionData)x0$1._2();
                return new Tuple2((Object)tp.topicPartition(), (Object)data);
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava(), (Object)resp2.responseData(topicNames, request2.version()));
        FetchRequest request3 = this.createRequest(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context3 = fetchManager.newContext(request3.version(), request3.metadata(), request3.isFromFollower(), request3.fetchData(topicNames), request3.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context3.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context3.updateAndGenerateResponseData(respData2).error());
        FetchRequest request4 = this.createRequest(new FetchMetadata(resp2.sessionId() + 1, 1), reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context4 = fetchManager.newContext(request4.version(), request4.metadata(), request4.isFromFollower(), request4.fetchData(topicNames), request4.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_ID_NOT_FOUND, (Object)context4.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData5 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request5 = this.createRequest(new FetchMetadata(resp2.sessionId(), 1), reqData5, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context5 = fetchManager.newContext(request5.version(), request5.metadata(), request5.isFromFollower(), request5.fetchData(topicNames), request5.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context5.getClass());
        java.util.Iterator<Map.Entry<TopicPartition, FetchRequest.PartitionData>> reqData5Iter = reqData2.entrySet().iterator();
        context5.foreachPartition((Function2 & Serializable & scala.Serializable)(topicIdPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$4(reqData5Iter, topicIds, topicIdPart, data);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context5.getFetchOffset(tp1).get()));
        FetchResponse resp5 = context5.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp5.sessionId());
        Assertions.assertEquals((int)0, (int)resp5.responseData(topicNames, request5.version()).size());
        FetchRequest request6 = this.createRequest(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context6 = fetchManager.newContext(request6.version(), request6.metadata(), request6.isFromFollower(), request6.fetchData(topicNames), request6.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context6.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context6.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData7 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request7 = this.createRequest(new FetchMetadata(resp2.sessionId(), 2), reqData7, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchResponse resp7 = fetchManager.newContext(request7.version(), request7.metadata(), request7.isFromFollower(), request7.fetchData(topicNames), request7.forgottenTopics(topicNames), topicNames).getThrottledResponse(100);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp7.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp7.sessionId());
        Assertions.assertEquals((int)100, (int)resp7.throttleTimeMs());
        int prevSessionId = resp5.sessionId();
        do {
            LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData8 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
            reqData8.put(tp2.topicPartition(), new FetchRequest.PartitionData(tp2.topicId(), 0L, 0L, 100, Optional.empty()));
            reqData8.put(tp3.topicPartition(), new FetchRequest.PartitionData(tp3.topicId(), 10L, 0L, 100, Optional.empty()));
            FetchRequest request8 = this.createRequest(new FetchMetadata(prevSessionId, -1), reqData8, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
            FetchContext context8 = fetchManager.newContext(request8.version(), request8.metadata(), request8.isFromFollower(), request8.fetchData(topicNames), request8.forgottenTopics(topicNames), topicNames);
            Assertions.assertEquals(SessionlessFetchContext.class, context8.getClass());
            Assertions.assertEquals((int)0, (int)cacheShard.size());
            LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData8 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
            respData8.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
            respData8.put(tp3, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
            resp8 = context8.updateAndGenerateResponseData(respData8);
            Assertions.assertEquals((Object)Errors.NONE, (Object)resp8.error());
        } while (resp8.sessionId() == prevSessionId);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testIncrementalFetchSession(boolean usesTopicIds) {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        java.util.Map topicNames = usesTopicIds ? (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava() : (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).asJava();
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicNames).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        short version = usesTopicIds ? ApiKeys.FETCH.latestVersion() : (short)12;
        Uuid fooId = topicIds.getOrDefault("foo", Uuid.ZERO_UUID);
        Uuid barId = topicIds.getOrDefault("bar", Uuid.ZERO_UUID);
        TopicIdPartition tp0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition(barId, new TopicPartition("bar", 0));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(tp0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        reqData1.put(tp1.topicPartition(), new FetchRequest.PartitionData(fooId, 10L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false, version);
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, request1.version()).size());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(tp2.topicPartition(), new FetchRequest.PartitionData(barId, 15L, 0L, 0, Optional.empty()));
        ArrayList<TopicIdPartition> removed2 = new ArrayList<TopicIdPartition>();
        removed2.add(tp0);
        FetchRequest request2 = this.createRequest(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false, version);
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        Iterator reqData2Iter = ((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp1, tp2}))).iterator();
        context2.foreachPartition((Function2 & Serializable & scala.Serializable)(topicIdPart, x$5) -> {
            FetchSessionTest.$anonfun$testIncrementalFetchSession$2(reqData2Iter, topicIdPart, x$5);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(tp0));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(tp1).get()));
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(tp2).get()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(new TopicIdPartition(barId, new TopicPartition("bar", 2))));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData2.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)1, (int)resp2.responseData(topicNames, request2.version()).size());
        Assertions.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchSessionWithUnknownIdOldRequestVersion() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicNames).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        TopicIdPartition tp0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.empty()));
        reqData1.put(tp1.topicPartition(), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 10L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequestWithoutTopicIds(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        java.util.Map topicNamesOnlyBar = Collections.singletonMap(topicIds.get("bar"), "bar");
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNamesOnlyBar), request1.forgottenTopics(topicNamesOnlyBar), topicNamesOnlyBar);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, request1.version()).size());
        resp1.responseData(topicNames, request1.version()).forEach((x$7, resp) -> Assertions.assertEquals((short)Errors.NONE.code(), (short)resp.errorCode()));
    }

    @Test
    public void testFetchSessionWithUnknownId() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        Uuid fooId = Uuid.randomUuid();
        Uuid barId = Uuid.randomUuid();
        Uuid zarId = Uuid.randomUuid();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)barId), (Object)"bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zarId), (Object)"zar")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        TopicIdPartition zar0 = new TopicIdPartition(zarId, new TopicPartition("zar", 0));
        TopicIdPartition emptyFoo0 = new TopicIdPartition(fooId, new TopicPartition(null, 0));
        TopicIdPartition emptyFoo1 = new TopicIdPartition(fooId, new TopicPartition(null, 1));
        TopicIdPartition emptyZar0 = new TopicIdPartition(zarId, new TopicPartition(null, 0));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(foo0.topicPartition(), new FetchRequest.PartitionData(foo0.topicId(), 0L, 0L, 100, Optional.empty()));
        reqData1.put(foo1.topicPartition(), new FetchRequest.PartitionData(foo1.topicId(), 10L, 0L, 100, Optional.empty()));
        reqData1.put(zar0.topicPartition(), new FetchRequest.PartitionData(zar0.topicId(), 10L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        java.util.Map<Uuid, String> topicNamesOnlyBar = Collections.singletonMap(barId, "bar");
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNamesOnlyBar), request1.forgottenTopics(topicNamesOnlyBar), topicNamesOnlyBar);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        this.assertPartitionsOrder(context1, (Seq<TopicIdPartition>)new .colon.colon((Object)emptyFoo0, (List)new .colon.colon((Object)emptyFoo1, (List)new .colon.colon((Object)emptyZar0, (List)Nil$.MODULE$))));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(emptyFoo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        respData1.put(emptyFoo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        respData1.put(emptyZar0, new FetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code()))})), (Object)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)resp1.responseData(topicNames, request1.version())).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                FetchResponseData.PartitionData resp = (FetchResponseData.PartitionData)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToShort((short)resp.errorCode()));
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom()));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request2 = this.createRequest(new FetchMetadata(resp1.sessionId(), 1), reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        java.util.Map topicNamesNoZar = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)barId), (Object)"bar")}))).asJava();
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNamesNoZar), request2.forgottenTopics(topicNamesNoZar), topicNamesNoZar);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (Seq<TopicIdPartition>)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)emptyZar0, (List)Nil$.MODULE$))));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData2.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData2.put(emptyZar0, new FetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)3, (int)resp2.responseData(topicNames, request2.version()).size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code()))})), (Object)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)resp2.responseData(topicNames, request2.version())).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition tp = (TopicPartition)x0$2._1();
                FetchResponseData.PartitionData resp = (FetchResponseData.PartitionData)x0$2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToShort((short)resp.errorCode()));
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testIncrementalFetchSessionWithIdsWhenSessionDoesNotUseIds() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        TopicIdPartition foo0 = new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("foo", 0));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(foo0.topicPartition(), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequestWithoutTopicIds(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Uuid fooId = Uuid.randomUuid();
        topicNames.put(fooId, "foo");
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request2 = this.createRequest(new FetchMetadata(resp1.sessionId(), 1), reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_TOPIC_ID_ERROR, (Object)context2.updateAndGenerateResponseData(respData2).error());
    }

    @Test
    public void testIncrementalFetchSessionWithoutIdsWhenSessionUsesIds() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        Uuid fooId = Uuid.randomUuid();
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        topicNames.put(fooId, "foo");
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        topicNames.remove(fooId);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request2 = this.createRequestWithoutTopicIds(new FetchMetadata(resp1.sessionId(), 1), reqData2, this.EMPTY_PART_LIST(), false);
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_TOPIC_ID_ERROR, (Object)context2.updateAndGenerateResponseData(respData2).error());
    }

    @Test
    public void testFetchSessionUpdateTopicIdsBrokerSide() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicNames).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        TopicIdPartition tp0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.empty()));
        reqData1.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 10L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData1.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(-1L).setLastStableOffset(-1L).setLogStartOffset(-1L).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, request1.version()).size());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request2 = this.createRequest(new FetchMetadata(resp1.sessionId(), 1), reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        java.util.Map topicNamesFooChanged = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicIds.get("bar")), (Object)"bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo")}))).asJava();
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNamesFooChanged), request2.forgottenTopics(topicNamesFooChanged), topicNamesFooChanged);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(-1L).setLastStableOffset(-1L).setLogStartOffset(-1L).setErrorCode(Errors.INCONSISTENT_TOPIC_ID.code()));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
        LinkedHashMap responseData2 = resp2.responseData(topicNames, request2.version());
        Assertions.assertEquals((short)Errors.INCONSISTENT_TOPIC_ID.code(), (short)((FetchResponseData.PartitionData)responseData2.get(tp0.topicPartition())).errorCode());
    }

    private FetchResponseData.PartitionData noErrorResponse() {
        return new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L);
    }

    private FetchResponseData.PartitionData errorResponse(short errorCode) {
        return new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(-1L).setLastStableOffset(-1L).setLogStartOffset(-1L).setErrorCode(errorCode);
    }

    @Test
    public void testResolveUnknownPartitions() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        TopicIdPartition foo = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 0));
        TopicIdPartition zar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("zar", 0));
        TopicIdPartition fooUnresolved = new TopicIdPartition(foo.topicId(), new TopicPartition(null, foo.partition()));
        TopicIdPartition barUnresolved = new TopicIdPartition(bar.topicId(), new TopicPartition(null, bar.partition()));
        TopicIdPartition zarUnresolved = new TopicIdPartition(zar.topicId(), new TopicPartition(null, zar.partition()));
        FetchContext context1 = this.newContext$1(FetchMetadata.INITIAL, (Seq)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)zar, (List)Nil$.MODULE$))), Predef$.MODULE$.Map().empty(), fetchManager);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        this.assertPartitionsOrder(context1, (Seq<TopicIdPartition>)new .colon.colon((Object)fooUnresolved, (List)new .colon.colon((Object)barUnresolved, (List)new .colon.colon((Object)zarUnresolved, (List)Nil$.MODULE$))));
        int sessionId = this.updateAndGenerateResponseData$1(context1);
        FetchContext context2 = this.newContext$1(new FetchMetadata(sessionId, 1), (Seq)Nil$.MODULE$, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())})), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (Seq<TopicIdPartition>)new .colon.colon((Object)foo, (List)new .colon.colon((Object)barUnresolved, (List)new .colon.colon((Object)zarUnresolved, (List)Nil$.MODULE$))));
        this.updateAndGenerateResponseData$1(context2);
        FetchContext context3 = this.newContext$1(new FetchMetadata(sessionId, 2), (Seq)new .colon.colon((Object)bar, (List)Nil$.MODULE$), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar.topicId()), (Object)bar.topic())})), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context3.getClass());
        this.assertPartitionsOrder(context3, (Seq<TopicIdPartition>)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)zarUnresolved, (List)Nil$.MODULE$))));
        this.updateAndGenerateResponseData$1(context3);
        FetchContext context4 = this.newContext$1(new FetchMetadata(sessionId, 3), (Seq)Nil$.MODULE$, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar.topicId()), (Object)bar.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar.topicId()), (Object)zar.topic())})), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context4.getClass());
        this.assertPartitionsOrder(context4, (Seq<TopicIdPartition>)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)zar, (List)Nil$.MODULE$))));
        this.updateAndGenerateResponseData$1(context4);
        FetchContext context5 = this.newContext$1(new FetchMetadata(sessionId, 4), (Seq)Nil$.MODULE$, Predef$.MODULE$.Map().empty(), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context5.getClass());
        this.assertPartitionsOrder(context4, (Seq<TopicIdPartition>)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)zar, (List)Nil$.MODULE$))));
    }

    @ParameterizedTest
    @MethodSource(value={"idUsageCombinations"})
    public void testToForgetPartitions(boolean fooStartsResolved, boolean fooEndsResolved) {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        TopicIdPartition foo = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 0));
        TopicIdPartition fooUnresolved = new TopicIdPartition(foo.topicId(), new TopicPartition(null, foo.partition()));
        TopicIdPartition barUnresolved = new TopicIdPartition(bar.topicId(), new TopicPartition(null, bar.partition()));
        scala.collection.immutable.Map context1Names = fooStartsResolved ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())})) : Predef$.MODULE$.Map().empty();
        TopicIdPartition fooContext1 = fooStartsResolved ? foo : fooUnresolved;
        FetchContext context1 = this.newContext$2(FetchMetadata.INITIAL, (Seq)new .colon.colon((Object)fooContext1, (List)new .colon.colon((Object)bar, (List)Nil$.MODULE$)), (Seq)Nil$.MODULE$, context1Names, fetchManager);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        this.assertPartitionsOrder(context1, (Seq<TopicIdPartition>)new .colon.colon((Object)fooContext1, (List)new .colon.colon((Object)barUnresolved, (List)Nil$.MODULE$)));
        int sessionId = this.updateAndGenerateResponseData$2(context1);
        scala.collection.immutable.Map context2Names = fooEndsResolved ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())})) : Predef$.MODULE$.Map().empty();
        TopicIdPartition fooContext2 = fooEndsResolved ? foo : fooUnresolved;
        FetchContext context2 = this.newContext$2(new FetchMetadata(sessionId, 1), (Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)fooContext2, (List)Nil$.MODULE$), context2Names, fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (Seq<TopicIdPartition>)new .colon.colon((Object)barUnresolved, (List)Nil$.MODULE$));
        this.updateAndGenerateResponseData$2(context2);
        FetchContext context3 = this.newContext$2(new FetchMetadata(sessionId, 2), (Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)bar, (List)Nil$.MODULE$), Predef$.MODULE$.Map().empty(), fetchManager);
        Assertions.assertEquals(SessionlessFetchContext.class, context3.getClass());
        this.assertPartitionsOrder(context3, (Seq<TopicIdPartition>)Nil$.MODULE$);
    }

    @Test
    public void testUpdateAndGenerateResponseData() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        TopicIdPartition foo = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 0));
        scala.collection.immutable.Map receivingBrokerTopicNames = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())}));
        scala.collection.immutable.Map sendingTopicNames = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar.topicId()), (Object)bar.topic())}));
        FetchContext context1 = this.newContext$3(FetchMetadata.LEGACY, (Seq)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)Nil$.MODULE$)), receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(SessionlessFetchContext.class, context1.getClass());
        FetchSessionTest.checkResponseData$1(this.updateAndGenerateResponseData$3(context1), foo, bar, sendingTopicNames);
        FetchContext context2 = this.newContext$3(FetchMetadata.INITIAL, (Seq)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)Nil$.MODULE$)), receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(FullFetchContext.class, context2.getClass());
        FetchResponse response2 = this.updateAndGenerateResponseData$3(context2);
        int sessionId = response2.sessionId();
        FetchSessionTest.checkResponseData$1(response2, foo, bar, sendingTopicNames);
        FetchContext context3 = this.newContext$3(new FetchMetadata(sessionId, 1), (Seq)Nil$.MODULE$, receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context3.getClass());
        FetchSessionTest.checkResponseData$1(this.updateAndGenerateResponseData$3(context3), foo, bar, sendingTopicNames);
        FetchContext context4 = this.newContext$3(new FetchMetadata(sessionId, 1), (Seq)Nil$.MODULE$, receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(SessionErrorContext.class, context4.getClass());
        Assertions.assertEquals(Collections.emptyList(), (Object)this.updateAndGenerateResponseData$3(context4).data().responses());
    }

    @Test
    public void testFetchSessionExpiration() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(2, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        Uuid fooId = Uuid.randomUuid();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session1req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session1req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session1req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 10L, 0L, 100, Optional.empty()));
        FetchRequest session1request1 = this.createRequest(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext session1context1 = fetchManager.newContext(session1request1.version(), session1request1.metadata(), session1request1.isFromFollower(), session1request1.fetchData(topicNames), session1request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session1context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session1resp = session1context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData(topicNames, session1request1.version()).size());
        Assertions.assertTrue((boolean)cacheShard.get(session1resp.sessionId()).isDefined());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session2req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session2req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session2req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 10L, 0L, 100, Optional.empty()));
        FetchRequest session2request1 = this.createRequest(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext session2context = fetchManager.newContext(session2request1.version(), session2request1.metadata(), session2request1.isFromFollower(), session2request1.fetchData(topicNames), session2request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> session2RespData = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        session2RespData.put(foo0.topicPartition(), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        session2RespData.put(foo1.topicPartition(), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData(topicNames, session2request1.version()).size());
        Assertions.assertTrue((boolean)cacheShard.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cacheShard.get(session2resp.sessionId()).isDefined());
        time.sleep(500L);
        FetchRequest session1request2 = this.createRequest(new FetchMetadata(session1resp.sessionId(), 1), new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>(), new ArrayList<TopicIdPartition>(), false, this.createRequest$default$5());
        FetchContext context1v2 = fetchManager.newContext(session1request2.version(), session1request2.metadata(), session1request2.isFromFollower(), session1request2.fetchData(topicNames), session1request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context1v2.getClass());
        time.sleep(501L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session3req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session3req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session3req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        FetchRequest session3request1 = this.createRequest(FetchMetadata.INITIAL, session3req, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext session3context = fetchManager.newContext(session3request1.version(), session3request1.metadata(), session3request1.isFromFollower(), session3request1.fetchData(topicNames), session3request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData3.put(new TopicIdPartition(fooId, new TopicPartition("foo", 0)), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData3.put(new TopicIdPartition(fooId, new TopicPartition("foo", 1)), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData(topicNames, session3request1.version()).size());
        Assertions.assertTrue((boolean)cacheShard.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cacheShard.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by latest session, as session 1 was used more recently");
        Assertions.assertTrue((boolean)cacheShard.get(session3resp.sessionId()).isDefined());
    }

    @Test
    public void testPrivilegedSessionHandling() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(2, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        Uuid fooId = Uuid.randomUuid();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session1req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session1req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session1req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 10L, 0L, 100, Optional.empty()));
        FetchRequest session1request = this.createRequest(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), true, this.createRequest$default$5());
        FetchContext session1context = fetchManager.newContext(session1request.version(), session1request.metadata(), session1request.isFromFollower(), session1request.fetchData(topicNames), session1request.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session1context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session1resp = session1context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData(topicNames, session1request.version()).size());
        Assertions.assertEquals((int)1, (int)cacheShard.size());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session2req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session2req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session2req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 10L, 0L, 100, Optional.empty()));
        FetchRequest session2request = this.createRequest(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext session2context = fetchManager.newContext(session2request.version(), session2request.metadata(), session2request.isFromFollower(), session2request.fetchData(topicNames), session2request.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> session2RespData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        session2RespData.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        session2RespData.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(session2RespData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData(topicNames, session2request.version()).size());
        Assertions.assertTrue((boolean)cacheShard.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cacheShard.get(session2resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cacheShard.size());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session3req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session3req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session3req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        FetchRequest session3request = this.createRequest(FetchMetadata.INITIAL, session3req, this.EMPTY_PART_LIST(), true, this.createRequest$default$5());
        FetchContext session3context = fetchManager.newContext(session3request.version(), session3request.metadata(), session3request.isFromFollower(), session3request.fetchData(topicNames), session3request.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData3.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData3.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData(topicNames, session3request.version()).size());
        Assertions.assertTrue((boolean)cacheShard.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cacheShard.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by session 3");
        Assertions.assertTrue((boolean)cacheShard.get(session3resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cacheShard.size());
        time.sleep(501L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session4req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session4req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session4req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        FetchRequest session4request = this.createRequest(FetchMetadata.INITIAL, session4req, this.EMPTY_PART_LIST(), true, this.createRequest$default$5());
        FetchContext session4context = fetchManager.newContext(session4request.version(), session4request.metadata(), session4request.isFromFollower(), session4request.fetchData(topicNames), session4request.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session4context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData4 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData4.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData4.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session4resp = session3context.updateAndGenerateResponseData(respData4);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session4resp.error());
        Assertions.assertTrue((session4resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session4resp.responseData(topicNames, session4request.version()).size());
        Assertions.assertFalse((boolean)cacheShard.get(session1resp.sessionId()).isDefined(), (String)"session 1 should have been evicted by session 4 even though it is privileged as it has hit eviction time");
        Assertions.assertTrue((boolean)cacheShard.get(session3resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cacheShard.get(session4resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cacheShard.size());
    }

    @Test
    public void testZeroSizeFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        Uuid fooId = Uuid.randomUuid();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        reqData1.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 10L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, request1.version()).size());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        ArrayList<TopicIdPartition> removed2 = new ArrayList<TopicIdPartition>();
        removed2.add(foo0);
        removed2.add(foo1);
        FetchRequest request2 = this.createRequest(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false, this.createRequest$default$5());
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(SessionlessFetchContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((int)0, (int)resp2.sessionId());
        Assertions.assertTrue((boolean)resp2.responseData(topicNames, request2.version()).isEmpty());
        Assertions.assertEquals((int)0, (int)cacheShard.size());
    }

    @Test
    public void testDivergingEpoch() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicNames).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 2));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        reqData.put(tp2.topicPartition(), new FetchRequest.PartitionData(tp2.topicId(), 100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, reqData, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L));
        FetchResponseData.EpochEndOffset divergingEpoch = new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(90L);
        respData.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertNotEquals((int)0, (int)resp1.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp1.responseData(topicNames, request1.version()).keySet());
        FetchRequest request2 = this.createRequest(new FetchMetadata(resp1.sessionId(), 1), reqData, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId());
        Assertions.assertEquals(Collections.singleton(tp2.topicPartition()), resp2.responseData(topicNames, request2.version()).keySet());
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp3.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp3.responseData(topicNames, request2.version()).keySet());
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(110L).setLastStableOffset(110L).setLogStartOffset(0L));
        FetchResponse resp4 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp4.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp4.responseData(topicNames, request2.version()).keySet());
    }

    @Test
    public void testDeprioritizesPartitionsWithRecordsOnly() {
        MockTime time = new MockTime();
        FetchSessionCacheShard cacheShard = new FetchSessionCacheShard(10, 1000L, FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$3(), FetchSessionCacheShard$.MODULE$.$lessinit$greater$default$4());
        FetchManager fetchManager = new FetchManager((Time)time, cacheShard);
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zar"), (Object)Uuid.randomUuid())}))).asJava();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicIds).asScala()).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 2));
        TopicIdPartition tp3 = new TopicIdPartition((Uuid)topicIds.get("zar"), new TopicPartition("zar", 3));
        LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> reqData = new LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData>();
        reqData.put(tp1, new FetchRequest.PartitionData(tp1.topicId(), 100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        reqData.put(tp2, new FetchRequest.PartitionData(tp2.topicId(), 100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        reqData.put(tp3, new FetchRequest.PartitionData(tp3.topicId(), 100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        FetchContext context1 = fetchManager.newContext(ApiKeys.FETCH.latestVersion(), FetchMetadata.INITIAL, false, reqData, Collections.emptyList(), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.topicPartition().partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData1.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.topicPartition().partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData1.put(tp3, new FetchResponseData.PartitionData().setPartitionIndex(tp3.topicPartition().partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertNotEquals((int)0, (int)resp1.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition(), tp3.topicPartition()}), resp1.responseData(topicNames, ApiKeys.FETCH.latestVersion()).keySet());
        FetchContext context2 = fetchManager.newContext(ApiKeys.FETCH.latestVersion(), new FetchMetadata(resp1.sessionId(), 1), false, reqData, Collections.emptyList(), topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (Seq<TopicIdPartition>)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)new .colon.colon((Object)tp3, (List)Nil$.MODULE$))));
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId());
        Assertions.assertEquals(Collections.emptySet(), resp2.responseData(topicNames, ApiKeys.FETCH.latestVersion()).keySet());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData3.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.topicPartition().partition()).setHighWatermark(60L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData3.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.topicPartition().partition()).setHighWatermark(60L).setLastStableOffset(50L).setLogStartOffset(0L).setRecords((BaseRecords)MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(100L, null)})));
        respData3.put(tp3, new FetchResponseData.PartitionData().setPartitionIndex(tp3.topicPartition().partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp3.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp3.responseData(topicNames, ApiKeys.FETCH.latestVersion()).keySet());
        this.assertPartitionsOrder(context2, (Seq<TopicIdPartition>)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp3, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$))));
    }

    @Test
    public void testCachedPartitionEqualsAndHashCode() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic";
        int partition = 0;
        CachedPartition cachedPartitionWithIdAndName = new CachedPartition(topicName, topicId, partition);
        CachedPartition cachedPartitionWithIdAndNoName = new CachedPartition(null, topicId, partition);
        CachedPartition cachedPartitionWithDifferentIdAndName = new CachedPartition(topicName, Uuid.randomUuid(), partition);
        CachedPartition cachedPartitionWithZeroIdAndName = new CachedPartition(topicName, Uuid.ZERO_UUID, partition);
        CachedPartition cachedPartitionWithZeroIdAndOtherName = new CachedPartition("otherTopic", Uuid.ZERO_UUID, partition);
        Assertions.assertEquals((Object)cachedPartitionWithIdAndName, (Object)cachedPartitionWithIdAndNoName);
        Assertions.assertEquals((int)cachedPartitionWithIdAndName.hashCode(), (int)cachedPartitionWithIdAndNoName.hashCode());
        Assertions.assertNotEquals((Object)cachedPartitionWithIdAndName, (Object)cachedPartitionWithDifferentIdAndName);
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndName.hashCode(), (int)cachedPartitionWithDifferentIdAndName.hashCode());
        Assertions.assertNotEquals((Object)cachedPartitionWithIdAndName, (Object)cachedPartitionWithZeroIdAndName);
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndName.hashCode(), (int)cachedPartitionWithZeroIdAndName.hashCode());
        Assertions.assertEquals((Object)cachedPartitionWithIdAndNoName, (Object)cachedPartitionWithIdAndName);
        Assertions.assertEquals((int)cachedPartitionWithIdAndNoName.hashCode(), (int)cachedPartitionWithIdAndName.hashCode());
        Assertions.assertNotEquals((Object)cachedPartitionWithIdAndNoName, (Object)cachedPartitionWithDifferentIdAndName);
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndNoName.hashCode(), (int)cachedPartitionWithDifferentIdAndName.hashCode());
        Assertions.assertNotEquals((Object)cachedPartitionWithIdAndNoName, (Object)cachedPartitionWithZeroIdAndName);
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndNoName.hashCode(), (int)cachedPartitionWithZeroIdAndName.hashCode());
        Assertions.assertNotEquals((Object)cachedPartitionWithZeroIdAndName, (Object)cachedPartitionWithZeroIdAndOtherName);
        Assertions.assertNotEquals((int)cachedPartitionWithZeroIdAndName.hashCode(), (int)cachedPartitionWithZeroIdAndOtherName.hashCode());
        Assertions.assertEquals((Object)cachedPartitionWithZeroIdAndName, (Object)cachedPartitionWithZeroIdAndName);
        Assertions.assertEquals((int)cachedPartitionWithZeroIdAndName.hashCode(), (int)cachedPartitionWithZeroIdAndName.hashCode());
    }

    @Test
    public void testMaybeResolveUnknownName() {
        CachedPartition namedPartition = new CachedPartition("topic", Uuid.randomUuid(), 0);
        CachedPartition nullNamePartition1 = new CachedPartition(null, Uuid.randomUuid(), 0);
        CachedPartition nullNamePartition2 = new CachedPartition(null, Uuid.randomUuid(), 0);
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)namedPartition.topicId()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nullNamePartition1.topicId()), (Object)"bar")}))).asJava();
        namedPartition.maybeResolveUnknownName(topicNames);
        Assertions.assertEquals((Object)"topic", (Object)namedPartition.topic());
        nullNamePartition1.maybeResolveUnknownName(topicNames);
        Assertions.assertEquals((Object)"bar", (Object)nullNamePartition1.topic());
        nullNamePartition2.maybeResolveUnknownName(topicNames);
        Assertions.assertEquals(null, (Object)nullNamePartition2.topic());
    }

    private void assertPartitionsOrder(FetchContext context, Seq<TopicIdPartition> partitions) {
        ArrayBuffer partitionsInContext = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, x$14) -> {
            partitionsInContext.$plus$eq((Object)tp);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(partitions, (Object)partitionsInContext.toSeq());
    }

    @Test
    public void testFetchSessionCache_getShardedCache_retrievesCacheFromCorrectSegment() {
        int numShards = 8;
        int sessionIdRange = Integer.MAX_VALUE / numShards;
        IndexedSeq cacheShards = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numShards).map((Function1 & Serializable & scala.Serializable)shardNum -> FetchSessionTest.$anonfun$testFetchSessionCache_getShardedCache_retrievesCacheFromCorrectSegment$1(sessionIdRange, BoxesRunTime.unboxToInt((Object)shardNum)), IndexedSeq$.MODULE$.canBuildFrom());
        FetchSessionCache cache = new FetchSessionCache((Seq)cacheShards);
        FetchSessionCacheShard cache0 = cache.getCacheShard(sessionIdRange - 1);
        FetchSessionCacheShard cache1 = cache.getCacheShard(sessionIdRange);
        FetchSessionCacheShard cache2 = cache.getCacheShard(sessionIdRange * 2);
        Assertions.assertEquals((Object)cache0, (Object)cacheShards.apply(0));
        Assertions.assertEquals((Object)cache1, (Object)cacheShards.apply(1));
        Assertions.assertEquals((Object)cache2, (Object)cacheShards.apply(2));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> cache.getCacheShard(sessionIdRange * numShards));
    }

    @Test
    public void testFetchSessionCache_RoundRobinsIntoShards() {
        int numShards = 8;
        int sessionIdRange = Integer.MAX_VALUE / numShards;
        IndexedSeq cacheShards = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numShards).map((Function1 & Serializable & scala.Serializable)shardNum -> FetchSessionTest.$anonfun$testFetchSessionCache_RoundRobinsIntoShards$1(sessionIdRange, BoxesRunTime.unboxToInt((Object)shardNum)), IndexedSeq$.MODULE$.canBuildFrom());
        FetchSessionCache cache = new FetchSessionCache((Seq)cacheShards);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numShards * 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)shardNum -> Assertions.assertEquals((Object)cacheShards.apply(shardNum % numShards), (Object)cache.getNextCacheShard()));
    }

    @Test
    public void testFetchSessionCache_RoundRobinsIntoShards_WhenIntegerOverflows() {
        int maxInteger = Integer.MAX_VALUE;
        FetchSessionCache$.MODULE$.counter().set(maxInteger + 1);
        int numShards = 8;
        int sessionIdRange = Integer.MAX_VALUE / numShards;
        IndexedSeq cacheShards = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numShards).map((Function1 & Serializable & scala.Serializable)shardNum -> FetchSessionTest.$anonfun$testFetchSessionCache_RoundRobinsIntoShards_WhenIntegerOverflows$1(sessionIdRange, BoxesRunTime.unboxToInt((Object)shardNum)), IndexedSeq$.MODULE$.canBuildFrom());
        FetchSessionCache cache = new FetchSessionCache((Seq)cacheShards);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numShards * 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)shardNum -> Assertions.assertEquals((Object)cacheShards.apply(shardNum % numShards), (Object)cache.getNextCacheShard()));
    }

    private static final scala.collection.immutable.Map cachedLeaderEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch));
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)mapBuilder.result();
    }

    private static final scala.collection.immutable.Map cachedLeaderEpochs$2(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch));
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)mapBuilder.result();
    }

    private static final scala.collection.immutable.Map cachedLastFetchedEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.lastFetchedEpoch));
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)mapBuilder.result();
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$2(java.util.Iterator reqData2Iter$1, java.util.Map topicIds$1, TopicIdPartition topicIdPart, FetchRequest.PartitionData data) {
        Map.Entry entry = (Map.Entry)reqData2Iter$1.next();
        Assertions.assertEquals(entry.getKey(), (Object)topicIdPart.topicPartition());
        Assertions.assertEquals(topicIds$1.get(((TopicPartition)entry.getKey()).topic()), (Object)topicIdPart.topicId());
        Assertions.assertEquals(entry.getValue(), (Object)data);
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$4(java.util.Iterator reqData5Iter$1, java.util.Map topicIds$1, TopicIdPartition topicIdPart, FetchRequest.PartitionData data) {
        Map.Entry entry = (Map.Entry)reqData5Iter$1.next();
        Assertions.assertEquals(entry.getKey(), (Object)topicIdPart.topicPartition());
        Assertions.assertEquals(topicIds$1.get(((TopicPartition)entry.getKey()).topic()), (Object)topicIdPart.topicId());
        Assertions.assertEquals(entry.getValue(), (Object)data);
    }

    public static final /* synthetic */ void $anonfun$testIncrementalFetchSession$2(Iterator reqData2Iter$2, TopicIdPartition topicIdPart, FetchRequest.PartitionData x$5) {
        Assertions.assertEquals((Object)reqData2Iter$2.next(), (Object)topicIdPart);
    }

    private final FetchContext newContext$1(FetchMetadata metadata, Seq partitions, scala.collection.immutable.Map topicNames, FetchManager fetchManager$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> data = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitions.foreach((Function1 & Serializable & scala.Serializable)topicIdPartition -> data.put(topicIdPartition.topicPartition(), new FetchRequest.PartitionData(topicIdPartition.topicId(), 0L, 0L, 100, Optional.empty())));
        FetchRequest fetchRequest = this.createRequest(metadata, data, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        return fetchManager$1.newContext(fetchRequest.version(), fetchRequest.metadata(), fetchRequest.isFromFollower(), fetchRequest.fetchData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava()), fetchRequest.forgottenTopics((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava()), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava());
    }

    private final int updateAndGenerateResponseData$1(FetchContext context) {
        LinkedHashMap data = new LinkedHashMap();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(topicIdPartition, x$9) -> {
            data.put(topicIdPartition, topicIdPartition.topic() == null ? this.errorResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.noErrorResponse());
            return BoxedUnit.UNIT;
        });
        return context.updateAndGenerateResponseData(data).sessionId();
    }

    private final FetchContext newContext$2(FetchMetadata metadata, Seq partitions, Seq toForget, scala.collection.immutable.Map topicNames, FetchManager fetchManager$2) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> data = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitions.foreach((Function1 & Serializable & scala.Serializable)topicIdPartition -> data.put(topicIdPartition.topicPartition(), new FetchRequest.PartitionData(topicIdPartition.topicId(), 0L, 0L, 100, Optional.empty())));
        FetchRequest fetchRequest = this.createRequest(metadata, data, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)toForget.toList()).asJava(), false, this.createRequest$default$5());
        return fetchManager$2.newContext(fetchRequest.version(), fetchRequest.metadata(), fetchRequest.isFromFollower(), fetchRequest.fetchData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava()), fetchRequest.forgottenTopics((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava()), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava());
    }

    private final int updateAndGenerateResponseData$2(FetchContext context) {
        LinkedHashMap data = new LinkedHashMap();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(topicIdPartition, x$10) -> {
            data.put(topicIdPartition, topicIdPartition.topic() == null ? this.errorResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.noErrorResponse());
            return BoxedUnit.UNIT;
        });
        return context.updateAndGenerateResponseData(data).sessionId();
    }

    private final FetchContext newContext$3(FetchMetadata metadata, Seq partitions, scala.collection.immutable.Map topicNames, FetchManager fetchManager$3) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> data = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitions.foreach((Function1 & Serializable & scala.Serializable)topicIdPartition -> data.put(topicIdPartition.topicPartition(), new FetchRequest.PartitionData(topicIdPartition.topicId(), 0L, 0L, 100, Optional.empty())));
        FetchRequest fetchRequest = this.createRequest(metadata, data, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        return fetchManager$3.newContext(fetchRequest.version(), fetchRequest.metadata(), fetchRequest.isFromFollower(), fetchRequest.fetchData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava()), fetchRequest.forgottenTopics((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava()), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava());
    }

    private final FetchResponse updateAndGenerateResponseData$3(FetchContext context) {
        LinkedHashMap data = new LinkedHashMap();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(topicIdPartition, x$11) -> {
            data.put(topicIdPartition, topicIdPartition.topic() == null ? this.errorResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.errorResponse(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
            return BoxedUnit.UNIT;
        });
        return context.updateAndGenerateResponseData(data);
    }

    private static final void checkResponseData$1(FetchResponse response, TopicIdPartition foo$1, TopicIdPartition bar$1, scala.collection.immutable.Map sendingTopicNames$1) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo$1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar$1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code()))})), (Object)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)response.responseData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)sendingTopicNames$1).asJava(), ApiKeys.FETCH.latestVersion())).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                FetchResponseData.PartitionData resp = (FetchResponseData.PartitionData)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToShort((short)resp.errorCode()));
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ FetchSessionCacheShard $anonfun$testFetchSessionCache_getShardedCache_retrievesCacheFromCorrectSegment$1(int sessionIdRange$1, int shardNum) {
        return new FetchSessionCacheShard(10, 1000L, sessionIdRange$1, shardNum);
    }

    public static final /* synthetic */ FetchSessionCacheShard $anonfun$testFetchSessionCache_RoundRobinsIntoShards$1(int sessionIdRange$2, int shardNum) {
        return new FetchSessionCacheShard(10, 1000L, sessionIdRange$2, shardNum);
    }

    public static final /* synthetic */ FetchSessionCacheShard $anonfun$testFetchSessionCache_RoundRobinsIntoShards_WhenIntegerOverflows$1(int sessionIdRange$3, int shardNum) {
        return new FetchSessionCacheShard(10, 1000L, sessionIdRange$3, shardNum);
    }
}

