/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.FinalizedFeatureChangeListener;
import kafka.server.FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$;
import kafka.server.QuorumTestHarness;
import kafka.server.metadata.ZkMetadataCache;
import kafka.server.metadata.ZkMetadataCache$;
import kafka.utils.TestUtils$;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t%a\u0001\u0002\u0015*\u00019BQa\r\u0001\u0005\u0002QB\u0011B\u000e\u0001A\u0002\u0003\u0007I\u0011A\u001c\t\u0013m\u0002\u0001\u0019!a\u0001\n\u0003a\u0004\"C#\u0001\u0001\u0004\u0005\t\u0015)\u00039\r\u00111\u0005\u0001Q$\t\u0011E+!Q3A\u0005\u0002IC\u0001\u0002Z\u0003\u0003\u0012\u0003\u0006Ia\u0015\u0005\tK\u0016\u0011)\u001a!C\u0001M\"A!.\u0002B\tB\u0003%q\rC\u00034\u000b\u0011\u00051\u000eC\u0003q\u000b\u0011\u0005\u0013\u000fC\u0004s\u000b\u0005\u0005I\u0011A:\t\u000fY,\u0011\u0013!C\u0001o\"I\u0011QA\u0003\u0012\u0002\u0013\u0005\u0011q\u0001\u0005\n\u0003\u0017)\u0011\u0011!C!\u0003\u001bA\u0011\"!\b\u0006\u0003\u0003%\t!a\b\t\u0013\u0005\u001dR!!A\u0005\u0002\u0005%\u0002\"CA\u001a\u000b\u0005\u0005I\u0011IA\u001b\u0011%\t\u0019%BA\u0001\n\u0003\t)\u0005C\u0005\u0002P\u0015\t\t\u0011\"\u0011\u0002R!I\u00111K\u0003\u0002\u0002\u0013\u0005\u0013QK\u0004\n\u00033\u0002\u0011\u0011!E\u0001\u000372\u0001B\u0012\u0001\u0002\u0002#\u0005\u0011Q\f\u0005\u0007g]!\t!a\u001b\t\u0011A<\u0012\u0011!C#\u0003[B\u0011\"a\u001c\u0018\u0003\u0003%\t)!\u001d\t\u0013\u0005]t#!A\u0005\u0002\u0006e\u0004bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003C\u0003A\u0011BAR\u0011\u001d\tY\u000b\u0001C\u0005\u0003[Cq!a,\u0001\t\u0013\t\t\fC\u0004\u0002J\u0002!\t!a3\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002L\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005-\u0007bBA{\u0001\u0011\u0005\u00111\u001a\u0005\b\u0003s\u0004A\u0011AAf\u0011\u001d\ti\u0010\u0001C\u0001\u0003\u0017DqA!\u0001\u0001\t\u0003\tY\rC\u0004\u0003\u0006\u0001!\t!a3\u0003E\u0019Kg.\u00197ju\u0016$g)Z1ukJ,7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014H+Z:u\u0015\tQ3&\u0001\u0004tKJ4XM\u001d\u0006\u0002Y\u0005)1.\u00194lC\u000e\u00011C\u0001\u00010!\t\u0001\u0014'D\u0001*\u0013\t\u0011\u0014FA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\u001b\u0011\u0005A\u0002\u0011\u0001\u00037jgR,g.\u001a:\u0016\u0003a\u0002\"\u0001M\u001d\n\u0005iJ#A\b$j]\u0006d\u0017N_3e\r\u0016\fG/\u001e:f\u0007\"\fgnZ3MSN$XM\\3s\u00031a\u0017n\u001d;f]\u0016\u0014x\fJ3r)\ti4\t\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0003V]&$\bb\u0002#\u0004\u0003\u0003\u0005\r\u0001O\u0001\u0004q\u0012\n\u0014!\u00037jgR,g.\u001a:!\u0005e1\u0015N\\1mSj,GMR3biV\u0014Xm]!oI\u0016\u0003xn\u00195\u0014\t\u0015A5J\u0014\t\u0003}%K!AS \u0003\r\u0005s\u0017PU3g!\tqD*\u0003\u0002N\u007f\t9\u0001K]8ek\u000e$\bC\u0001 P\u0013\t\u0001vH\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005gK\u0006$XO]3t+\u0005\u0019\u0006\u0003\u0002+\\=\u0006t!!V-\u0011\u0005Y{T\"A,\u000b\u0005ak\u0013A\u0002\u001fs_>$h(\u0003\u0002[\u007f\u00051\u0001K]3eK\u001aL!\u0001X/\u0003\u00075\u000b\u0007O\u0003\u0002[\u007fA\u0011AkX\u0005\u0003Av\u0013aa\u0015;sS:<\u0007C\u0001 c\u0013\t\u0019wHA\u0003TQ>\u0014H/A\u0005gK\u0006$XO]3tA\u0005)Q\r]8dQV\tq\r\u0005\u0002?Q&\u0011\u0011n\u0010\u0002\u0005\u0019>tw-\u0001\u0004fa>\u001c\u0007\u000e\t\u000b\u0004Y:|\u0007CA7\u0006\u001b\u0005\u0001\u0001\"B)\u000b\u0001\u0004\u0019\u0006\"B3\u000b\u0001\u00049\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003y\u000bAaY8qsR\u0019A\u000e^;\t\u000fEc\u0001\u0013!a\u0001'\"9Q\r\u0004I\u0001\u0002\u00049\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0002q*\u00121+_\u0016\u0002uB\u001910!\u0001\u000e\u0003qT!! @\u0002\u0013Ut7\r[3dW\u0016$'BA@@\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0007a(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u0005U\t9\u00170A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0003mC:<'BAA\r\u0003\u0011Q\u0017M^1\n\u0007\u0001\f\u0019\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\"A\u0019a(a\t\n\u0007\u0005\u0015rHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002,\u0005E\u0002c\u0001 \u0002.%\u0019\u0011qF \u0003\u0007\u0005s\u0017\u0010\u0003\u0005E#\u0005\u0005\t\u0019AA\u0011\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u001c!\u0019\tI$a\u0010\u0002,5\u0011\u00111\b\u0006\u0004\u0003{y\u0014AC2pY2,7\r^5p]&!\u0011\u0011IA\u001e\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u001d\u0013Q\n\t\u0004}\u0005%\u0013bAA&\u007f\t9!i\\8mK\u0006t\u0007\u0002\u0003#\u0014\u0003\u0003\u0005\r!a\u000b\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\t\u0002\r\u0015\fX/\u00197t)\u0011\t9%a\u0016\t\u0011\u0011+\u0012\u0011!a\u0001\u0003W\t\u0011DR5oC2L'0\u001a3GK\u0006$XO]3t\u0003:$W\t]8dQB\u0011QnF\n\u0005/\u0005}c\nE\u0004\u0002b\u0005\u001d4k\u001a7\u000e\u0005\u0005\r$bAA3\u007f\u00059!/\u001e8uS6,\u0017\u0002BA5\u0003G\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\tY\u0006\u0006\u0002\u0002\u0010\u0005)\u0011\r\u001d9msR)A.a\u001d\u0002v!)\u0011K\u0007a\u0001'\")QM\u0007a\u0001O\u00069QO\\1qa2LH\u0003BA>\u0003\u000f\u0003RAPA?\u0003\u0003K1!a @\u0005\u0019y\u0005\u000f^5p]B)a(a!TO&\u0019\u0011QQ \u0003\rQ+\b\u000f\\33\u0011!\tIiGA\u0001\u0002\u0004a\u0017a\u0001=%a\u00051\u0011m\u001d&bm\u0006$B!a$\u0002\u001eB9\u0011\u0011SAL=\u0006eUBAAJ\u0015\u0011\t)*a\u0006\u0002\tU$\u0018\u000e\\\u0005\u00049\u0006M\u0005\u0003BA\t\u00037K1aYA\n\u0011\u0019\ty\n\ba\u0001'\u0006)\u0011N\u001c9vi\u0006!2M]3bi\u0016\u0014%o\\6fe\u001a+\u0017\r^;sKN$\"!!*\u0011\u0007A\n9+C\u0002\u0002*&\u0012aB\u0011:pW\u0016\u0014h)Z1ukJ,7/A\fde\u0016\fG/\u001a$j]\u0006d\u0017N_3e\r\u0016\fG/\u001e:fgR\tA.\u0001\bde\u0016\fG/\u001a'jgR,g.\u001a:\u0015\u000ba\n\u0019,a1\t\u000f\u0005Uv\u00041\u0001\u00028\u0006)1-Y2iKB!\u0011\u0011XA`\u001b\t\tYLC\u0002\u0002>&\n\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003\u0003\fYLA\b[W6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011\u001d\t)m\ba\u0001\u0003\u000f\fA#\u001a=qK\u000e$X\rZ\"bG\",7i\u001c8uK:$\b\u0003\u0002 \u0002~1\fA\u0002^3tiR+\u0017M\u001d#po:$\u0012!\u0010\u0015\u0004A\u0005=\u0007\u0003BAi\u0003Gl!!a5\u000b\t\u0005U\u0017q[\u0001\u0004CBL'\u0002BAm\u00037\fqA[;qSR,'O\u0003\u0003\u0002^\u0006}\u0017!\u00026v]&$(BAAq\u0003\ry'oZ\u0005\u0005\u0003K\f\u0019NA\u0005BMR,'/R1dQ\u0006)C/Z:u\u0013:LGoU;dG\u0016\u001c8/\u00118e\u001d>$\u0018NZ5dCRLwN\\*vG\u000e,7o\u001d\u0015\u0004C\u0005-\b\u0003BAi\u0003[LA!a<\u0002T\n!A+Z:u\u00031\"Xm\u001d;GK\u0006$XO]3[\u001d>$W\rR3mKR,gj\u001c;jM&\u001c\u0017\r^5p]B\u0013xnY3tg&tw\rK\u0002#\u0003W\fq\u0006^3ti\u001a+\u0017\r^;sKjsu\u000eZ3ESN\f'\r\\5oO:{G/\u001b4jG\u0006$\u0018n\u001c8Qe>\u001cWm]:j]\u001eD3aIAv\u00035\"Xm\u001d;DC\u000eDW-\u00169eCR,w+Y5u\r\u0006LGn\u001d$peVs'/Z1dQ\u0006\u0014G.\u001a,feNLwN\u001c\u0015\u0004I\u0005-\u0018A\u000b;fgRLe.\u001b;GC&dWO]3Ek\u0016$vNR3biV\u0014X-\u00138d_6\u0004\u0018\r^5cS2LG/\u001f\u0015\u0004K\u0005-\u0018a\t;fgRLe.\u001b;GC&dWO]3Ek\u0016$v.\u00138wC2LGmV1jiRKW.\u001a\u0015\u0004M\u0005-\u0018A\r;fgRtu\u000e^5gS\u000e\fG/[8o\r\u0006LG.\u001e:f\tV,Gk\u001c$fCR,(/Z%oG>l\u0007/\u0019;jE&d\u0017\u000e^=)\u0007\u001d\nY\u000f")
public class FinalizedFeatureChangeListenerTest
extends QuorumTestHarness {
    private volatile FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$ FinalizedFeaturesAndEpoch$module;
    private FinalizedFeatureChangeListener listener;

    public FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$ FinalizedFeaturesAndEpoch() {
        if (this.FinalizedFeaturesAndEpoch$module == null) {
            this.FinalizedFeaturesAndEpoch$lzycompute$1();
        }
        return this.FinalizedFeaturesAndEpoch$module;
    }

    public FinalizedFeatureChangeListener listener() {
        return this.listener;
    }

    public void listener_$eq(FinalizedFeatureChangeListener x$1) {
        this.listener = x$1;
    }

    public java.util.Map<String, Short> asJava(scala.collection.immutable.Map<String, Object> input) {
        return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)input.map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)((Short)kv._2())), Map$.MODULE$.canBuildFrom())).asJava();
    }

    private BrokerFeatures createBrokerFeatures() {
        scala.collection.immutable.Map supportedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new SupportedVersionRange(1, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_2"), (Object)new SupportedVersionRange(1, 3))}));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault(true);
        brokerFeatures.setSupportedFeatures(Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)supportedFeaturesMap).asJava())));
        return brokerFeatures;
    }

    /*
     * WARNING - void declaration
     */
    private FinalizedFeaturesAndEpoch createFinalizedFeatures() {
        void var3_3;
        scala.collection.immutable.Map finalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)3))}));
        this.zkClient().createFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)finalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var3_3.isEmpty());
        return new FinalizedFeaturesAndEpoch(this, (scala.collection.immutable.Map<String, Object>)finalizedFeaturesMap, n);
    }

    private FinalizedFeatureChangeListener createListener(ZkMetadataCache cache, Option<FinalizedFeaturesAndEpoch> expectedCacheContent) {
        FinalizedFeatureChangeListener listener = new FinalizedFeatureChangeListener(cache, this.zkClient());
        Assertions.assertFalse((boolean)listener.isListenerInitiated());
        Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
        listener.initOrThrow(15000L);
        Assertions.assertTrue((boolean)listener.isListenerInitiated());
        if (expectedCacheContent.isDefined()) {
            Option mayBeNewCacheContent = cache.getFeatureOption();
            Assertions.assertFalse((boolean)mayBeNewCacheContent.isEmpty());
            FinalizedFeatures newCacheContent = (FinalizedFeatures)mayBeNewCacheContent.get();
            Assertions.assertEquals(this.asJava(((FinalizedFeaturesAndEpoch)expectedCacheContent.get()).features()), (Object)newCacheContent.finalizedFeatures());
            Assertions.assertEquals((long)((FinalizedFeaturesAndEpoch)expectedCacheContent.get()).epoch(), (long)newCacheContent.finalizedFeaturesEpoch());
        } else {
            Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
        }
        return listener;
    }

    @AfterEach
    public void testTearDown() {
        if (this.listener() != null) {
            this.listener().close();
            return;
        }
    }

    @Test
    public void testInitSuccessAndNotificationSuccess() {
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        this.listener_$eq(this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures)));
        this.updateAndCheckCache$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)4))})), initialFinalizedFeatures, cache);
        this.updateAndCheckCache$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_2"), (Object)BoxesRunTime.boxToShort((short)3))})), initialFinalizedFeatures, cache);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFeatureZNodeDeleteNotificationProcessing() {
        void var5_5;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        this.listener_$eq(this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures)));
        this.zkClient().deleteFeatureZNode();
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeDeletedBytes = (Option)tuple2._1();
        Assertions.assertEquals((int)tuple2._2$mcI$sp(), (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertTrue((boolean)var5_5.isEmpty());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!FinalizedFeatureChangeListenerTest.$anonfun$testFeatureZNodeDeleteNotificationProcessing$1(cache)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)FinalizedFeatureChangeListenerTest.$anonfun$testFeatureZNodeDeleteNotificationProcessing$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.listener().isListenerInitiated());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFeatureZNodeDisablingNotificationProcessing() {
        void var6_6;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        scala.collection.immutable.Map updatedFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.zkClient().updateFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, (Map)updatedFinalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeNewBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var6_6.isEmpty());
        Assertions.assertTrue(((long)n > initialFinalizedFeatures.epoch() ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCacheUpdateWaitFailsForUnreachableVersion() {
        void var5_5;
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, this.createBrokerFeatures(), ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        this.listener_$eq(this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures)));
        Assertions.assertThrows(TimeoutException.class, () -> cache.waitUntilFeatureEpochOrThrow(initialFinalizedFeatures.epoch() + 1L, 15000L));
        scala.collection.immutable.Map updatedFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.zkClient().updateFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, (Map)updatedFinalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeNewBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var5_5.isEmpty());
        Assertions.assertTrue(((long)n > initialFinalizedFeatures.epoch() ? 1 : 0) != 0);
        Assertions.assertThrows(TimeoutException.class, () -> cache.waitUntilFeatureEpochOrThrow((long)n, 15000L));
        Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
        Assertions.assertTrue((boolean)this.listener().isListenerInitiated());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInitFailureDueToFeatureIncompatibility() {
        void var5_5;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        scala.collection.immutable.Map incompatibleFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)5))}));
        this.zkClient().createFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)incompatibleFinalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
        Assertions.assertNotEquals((int)tuple2._2$mcI$sp(), (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var5_5.isEmpty());
        CountDownLatch exitLatch = new CountDownLatch(1);
        Exit.setExitProcedure((x$7, x$8) -> exitLatch.countDown());
        try {
            this.listener_$eq(new FinalizedFeatureChangeListener(cache, this.zkClient()));
            Assertions.assertFalse((boolean)this.listener().isListenerInitiated());
            Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
            Assertions.assertThrows(TimeoutException.class, () -> this.listener().initOrThrow(5000L));
            exitLatch.await();
            Assertions.assertFalse((boolean)this.listener().isListenerInitiated());
            Assertions.assertTrue((boolean)this.listener().isListenerDead());
            Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testInitFailureDueToInvalidWaitTime() {
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        this.listener_$eq(new FinalizedFeatureChangeListener(cache, this.zkClient()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.listener().initOrThrow(0L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.listener().initOrThrow(-1L));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNotificationFailureDueToFeatureIncompatibility() {
        void var7_7;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        this.listener_$eq(this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures)));
        CountDownLatch exitLatch = new CountDownLatch(1);
        Exit.setExitProcedure((x$9, x$10) -> exitLatch.countDown());
        scala.collection.immutable.Map incompatibleFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)((short)(((SupportedVersionRange)brokerFeatures.supportedFeatures().get("feature_1")).max() + 1))))}));
        this.zkClient().updateFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)incompatibleFinalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeIncompatibleBytes = (Option)tuple2._1();
        Assertions.assertNotEquals((int)tuple2._2$mcI$sp(), (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var7_7.isEmpty());
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!FinalizedFeatureChangeListenerTest.$anonfun$testNotificationFailureDueToFeatureIncompatibility$2(this, exitLatch, cache, initialFinalizedFeatures)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)FinalizedFeatureChangeListenerTest.$anonfun$testNotificationFailureDueToFeatureIncompatibility$3());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    private final void FinalizedFeaturesAndEpoch$lzycompute$1() {
        synchronized (this) {
            if (this.FinalizedFeaturesAndEpoch$module == null) {
                this.FinalizedFeaturesAndEpoch$module = new FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$(this);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAndCheckCache$1(scala.collection.immutable.Map finalizedFeatures, FinalizedFeaturesAndEpoch initialFinalizedFeatures$1, ZkMetadataCache cache$1) {
        void var5_5;
        this.zkClient().updateFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)finalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeNewBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var5_5.isEmpty());
        Assertions.assertTrue(((long)n > initialFinalizedFeatures$1.epoch() ? 1 : 0) != 0);
        cache$1.waitUntilFeatureEpochOrThrow((long)n, 15000L);
        Assertions.assertEquals((Object)new FinalizedFeatures(MetadataVersion.IBP_2_8_IV1, this.asJava((scala.collection.immutable.Map<String, Object>)finalizedFeatures), (long)n, false), (Object)cache$1.getFeatureOption().get());
        Assertions.assertTrue((boolean)this.listener().isListenerInitiated());
    }

    public static final /* synthetic */ boolean $anonfun$testFeatureZNodeDeleteNotificationProcessing$1(ZkMetadataCache cache$2) {
        return cache$2.getFeatureOption().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testFeatureZNodeDeleteNotificationProcessing$2() {
        return "Timed out waiting for FinalizedFeatureCache to become empty";
    }

    public static final /* synthetic */ boolean $anonfun$testNotificationFailureDueToFeatureIncompatibility$2(FinalizedFeatureChangeListenerTest $this, CountDownLatch exitLatch$2, ZkMetadataCache cache$4, FinalizedFeaturesAndEpoch initialFinalizedFeatures$3) {
        return exitLatch$2.getCount() == 0L && !$this.listener().isListenerInitiated() && $this.listener().isListenerDead() && ((FinalizedFeatures)cache$4.getFeatureOption().get()).equals((Object)new FinalizedFeatures(MetadataVersion.IBP_2_8_IV1, $this.asJava(initialFinalizedFeatures$3.features()), initialFinalizedFeatures$3.epoch(), false));
    }

    public static final /* synthetic */ String $anonfun$testNotificationFailureDueToFeatureIncompatibility$3() {
        return "Timed out waiting for listener death and FinalizedFeatureCache to be updated";
    }

    public class FinalizedFeaturesAndEpoch
    implements Product,
    scala.Serializable {
        private final scala.collection.immutable.Map<String, Object> features;
        private final long epoch;
        public final /* synthetic */ FinalizedFeatureChangeListenerTest $outer;

        public scala.collection.immutable.Map<String, Object> features() {
            return this.features;
        }

        public long epoch() {
            return this.epoch;
        }

        public String toString() {
            return new StringBuilder(44).append("FinalizedFeaturesAndEpoch(features=").append(this.features()).append(", epoch=").append(this.epoch()).append(")").toString();
        }

        public FinalizedFeaturesAndEpoch copy(scala.collection.immutable.Map<String, Object> features, long epoch) {
            return new FinalizedFeaturesAndEpoch(this.kafka$server$FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$$$outer(), features, epoch);
        }

        public scala.collection.immutable.Map<String, Object> copy$default$1() {
            return this.features();
        }

        public long copy$default$2() {
            return this.epoch();
        }

        public String productPrefix() {
            return "FinalizedFeaturesAndEpoch";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.features();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.epoch());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FinalizedFeaturesAndEpoch;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash(this.features())), (int)Statics.longHash((long)this.epoch())), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FinalizedFeaturesAndEpoch && ((FinalizedFeaturesAndEpoch)x$1).kafka$server$FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$$$outer() == this.kafka$server$FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$$$outer())) break block3;
                    FinalizedFeaturesAndEpoch finalizedFeaturesAndEpoch = (FinalizedFeaturesAndEpoch)x$1;
                    scala.collection.immutable.Map<String, Object> map = this.features();
                    scala.collection.immutable.Map<String, Object> map2 = finalizedFeaturesAndEpoch.features();
                    if (map != null ? !map.equals(map2) : map2 != null) break block3;
                    if (this.epoch() != finalizedFeaturesAndEpoch.epoch() || !finalizedFeaturesAndEpoch.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ FinalizedFeatureChangeListenerTest kafka$server$FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$$$outer() {
            return this.$outer;
        }

        public FinalizedFeaturesAndEpoch(FinalizedFeatureChangeListenerTest $outer, scala.collection.immutable.Map<String, Object> features, long epoch) {
            this.features = features;
            this.epoch = epoch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

