/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import kafka.server.GroupCoordinatorBaseRequestTest;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0005\u000b\u0001=A\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006I!\u0006\u0005\u00067\u0001!\t\u0001\b\u0005\u0006?\u0001!\t\u0001\t\u0005\u0006\u0013\u0002!\t\u0001\t\u0005\u0006\u001f\u0002!I\u0001\t\u0005\u0006!\u0002!I!\u0015\u0005\u0006]\u0002!Ia\u001c\u0005\u0007\u007f\u0002!I!!\u0001\u0003)){\u0017N\\$s_V\u0004(+Z9vKN$H+Z:u\u0015\tYA\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\u000b\u0013\t\u0019\"BA\u0010He>,\boQ8pe\u0012Lg.\u0019;pe\n\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fqa\u00197vgR,'\u000f\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u0019\u0005!A/Z:u\u0013\tQrCA\bDYV\u001cH/\u001a:J]N$\u0018M\\2f\u0003\u0019a\u0014N\\5u}Q\u0011QD\b\t\u0003#\u0001AQ\u0001\u0006\u0002A\u0002U\tq\b^3ti*{\u0017N\\$s_V\u0004x+\u001b;i\u001f2$7i\u001c8tk6,'o\u0012:pkB\u0004&o\u001c;pG>d\u0017I\u001c3OK^<%o\\;q\u0007>|'\u000fZ5oCR|'\u000fF\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0011)f.\u001b;)\r\rAcfL\u001b7!\tIC&D\u0001+\u0015\tYs#\u0001\u0006b]:|G/\u0019;j_:L!!\f\u0016\u0003\u0017\rcWo\u001d;feR+7\u000f^\u0001\u0006if\u0004Xm\u001d\u0017\u0002a\u0011\n\u0011'\u0003\u00023g\u0005)1JU!G)*\u0011AGK\u0001\u0005)f\u0004X-\u0001\ttKJ4XM\u001d)s_B,'\u000f^5fg2\u001aq'\u0011$,\u000baZDHP \u0011\u0005%J\u0014B\u0001\u001e+\u0005U\u0019E.^:uKJ\u001cuN\u001c4jOB\u0013x\u000e]3sif\f1a[3zC\u0005i\u0014\u0001H4s_V\u0004hfY8pe\u0012Lg.\u0019;pe:rWm\u001e\u0018f]\u0006\u0014G.Z\u0001\u0006m\u0006dW/Z\u0011\u0002\u0001\u0006!AO];fW\u0015A4H\u0011 EC\u0005\u0019\u0015\u0001H8gMN,Go\u001d\u0018u_BL7M\f8v[:\u0002\u0018M\u001d;ji&|gn]\u0011\u0002\u000b\u0006\t\u0011gK\u00039w\u001dsD)I\u0001I\u0003\u0001zgMZ:fiNtCo\u001c9jG:\u0012X\r\u001d7jG\u0006$\u0018n\u001c8/M\u0006\u001cGo\u001c:\u0002\u007fQ,7\u000f\u001e&pS:<%o\\;q/&$\bn\u00147e\u0007>t7/^7fe\u001e\u0013x.\u001e9Qe>$xnY8m\u0003:$w\n\u001c3He>,\boQ8pe\u0012Lg.\u0019;pe\"\"A\u0001K\u001bLY\ra\u0015IR\u0016\u0006qmbd(T\u0011\u0002\u001d\u0006)a-\u00197tK\u0006iA/Z:u\u0015>Lgn\u0012:pkB\fQ\u0003^3ti\u001a+gnY3e'R\fG/[2He>,\b\u000fF\u0003S;~\u000b\u0017\u000e\u0005\u0002T5:\u0011A\u000b\u0017\t\u0003+\u000ej\u0011A\u0016\u0006\u0003/:\ta\u0001\u0010:p_Rt\u0014BA-$\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\u001b\u0003\"\u00020\u0007\u0001\u0004\u0011\u0016A\u00047fC\u0012,'/T3nE\u0016\u0014\u0018\n\u001a\u0005\u0006A\u001a\u0001\rAU\u0001\u0011M>dGn\\<fe6+WNY3s\u0013\u0012DQA\u0019\u0004A\u0002\r\f\u0001\"\\3uC\u0012\fG/\u0019\t\u0004E\u00114\u0017BA3$\u0005\u0015\t%O]1z!\t\u0011s-\u0003\u0002iG\t!!)\u001f;f\u0011\u0015Qg\u00011\u0001l\u0003\u001d1XM]:j_:\u0004\"A\t7\n\u00055\u001c#aA%oi\u0006Ian\u001c:nC2L'0\u001a\u000b\u0003av\u0004\"!]>\u000e\u0003IT!a\u001d;\u0002\u000f5,7o]1hK*\u0011QO^\u0001\u0007G>lWn\u001c8\u000b\u000559(B\u0001=z\u0003\u0019\t\u0007/Y2iK*\t!0A\u0002pe\u001eL!\u0001 :\u0003+){\u0017N\\$s_V\u0004(+Z:q_:\u001cX\rR1uC\")ap\u0002a\u0001a\u0006a!/Z:q_:\u001cX\rR1uC\u0006\tc/\u001a:jMfTu.\u001b8He>,\bOU3ta>t7/\u001a#bi\u0006,\u0015/^1mgR)\u0011%a\u0001\u0002\b!1\u0011Q\u0001\u0005A\u0002A\f\u0001\"\u001a=qK\u000e$X\r\u001a\u0005\u0007\u0003\u0013A\u0001\u0019\u00019\u0002\r\u0005\u001cG/^1mQ\u0019\u0001\u0011Q\u0002 \u0002\"A!\u0011qBA\u000f\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011aA1qS*!\u0011qCA\r\u0003\u001dQW\u000f]5uKJT1!a\u0007z\u0003\u0015QWO\\5u\u0013\u0011\ty\"!\u0005\u0003\u0007Q\u000bw-\t\u0002\u0002$\u0005Y\u0011N\u001c;fOJ\fG/[8oQ\u0019\u0001\u0011q\u0005 \u00024A!\u0011\u0011FA\u0018\u001b\t\tYC\u0003\u0003\u0002.\u0005E\u0011!C3yi\u0016t7/[8o\u0013\u0011\t\t$a\u000b\u0003\u0015\u0015CH/\u001a8e/&$\b\u000e\f\u0002\u00026\r\u0012\u0011q\u0007\t\u0005\u0003s\ti$\u0004\u0002\u0002<)\u0019\u00111D\f\n\t\u0005}\u00121\b\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8tQ\u0019\u0001\u00111\t \u0002JA!\u0011qBA#\u0013\u0011\t9%!\u0005\u0003\u000fQKW.Z8viz\t\u0001\u0010")
public class JoinGroupRequestTest
extends GroupCoordinatorBaseRequestTest {
    @ClusterTest(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testJoinGroupWithOldConsumerGroupProtocolAndNewGroupCoordinator() {
        this.testJoinGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="false"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testJoinGroupWithOldConsumerGroupProtocolAndOldGroupCoordinator() {
        this.testJoinGroup();
    }

    private void testJoinGroup() {
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.JOIN_GROUP.oldestVersion()), (int)ApiKeys.JOIN_GROUP.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            byte[] metadata = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("foo"))).array();
            String x$1 = "grp";
            short x$3 = (short)version;
            String x$4 = this.sendJoinRequest$default$2();
            String x$5 = this.sendJoinRequest$default$3();
            String x$6 = this.sendJoinRequest$default$4();
            String x$7 = this.sendJoinRequest$default$5();
            JoinGroupResponseData joinLeaderResponseData = this.sendJoinRequest(x$1, x$4, x$5, x$6, x$7, metadata, x$3);
            String leaderMemberId = joinLeaderResponseData.memberId();
            if (version >= 4) {
                this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setErrorCode(Errors.MEMBER_ID_REQUIRED.code()).setMemberId(leaderMemberId).setProtocolName(version >= 7 ? null : ""), joinLeaderResponseData);
            } else {
                this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(1).setLeader(leaderMemberId).setMemberId(leaderMemberId).setProtocolName("consumer-range").setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(leaderMemberId).setMetadata(metadata), (List)Nil$.MODULE$)).asJava()), joinLeaderResponseData);
            }
            if (version >= 4) {
                String x$8 = "grp";
                short x$11 = (short)version;
                String x$12 = this.sendJoinRequest$default$3();
                String x$13 = this.sendJoinRequest$default$4();
                String x$14 = this.sendJoinRequest$default$5();
                JoinGroupResponseData rejoinLeaderResponseData = this.sendJoinRequest(x$8, leaderMemberId, x$12, x$13, x$14, metadata, x$11);
                this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(1).setMemberId(leaderMemberId).setProtocolName("consumer-range").setProtocolType(version >= 7 ? "consumer" : null).setLeader(leaderMemberId).setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(leaderMemberId).setMetadata(metadata), (List)Nil$.MODULE$)).asJava()), rejoinLeaderResponseData);
            }
            String x$15 = "grp";
            int x$17 = 1;
            .colon.colon x$18 = new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(leaderMemberId).setAssignment((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$);
            byte[] x$19 = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte());
            String x$20 = this.syncGroupWithOldProtocol$default$4();
            String x$21 = this.syncGroupWithOldProtocol$default$5();
            String x$22 = this.syncGroupWithOldProtocol$default$7();
            String x$23 = this.syncGroupWithOldProtocol$default$8();
            Errors x$24 = this.syncGroupWithOldProtocol$default$10();
            short x$25 = this.syncGroupWithOldProtocol$default$11();
            this.syncGroupWithOldProtocol(x$15, leaderMemberId, x$17, x$20, x$21, (List<SyncGroupRequestData.SyncGroupRequestAssignment>)x$18, x$22, x$23, x$19, x$24, x$25);
            String x$26 = "grp";
            String x$27 = "member-id-unknown";
            short x$28 = (short)version;
            String x$29 = this.sendJoinRequest$default$3();
            String x$30 = this.sendJoinRequest$default$4();
            String x$31 = this.sendJoinRequest$default$5();
            byte[] x$32 = this.sendJoinRequest$default$6();
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setMemberId("member-id-unknown").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()).setProtocolName(version >= 7 ? null : ""), this.sendJoinRequest(x$26, x$27, x$29, x$30, x$31, x$32, x$28));
            String x$33 = "grp";
            String x$34 = "connect";
            short x$35 = (short)version;
            String x$36 = this.sendJoinRequest$default$2();
            String x$37 = this.sendJoinRequest$default$3();
            String x$38 = this.sendJoinRequest$default$5();
            byte[] x$39 = this.sendJoinRequest$default$6();
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setErrorCode(Errors.INCONSISTENT_GROUP_PROTOCOL.code()).setProtocolName(version >= 7 ? null : ""), this.sendJoinRequest(x$33, x$36, x$37, x$34, x$38, x$39, x$35));
            ObjectRef joinFollowerResponseData = ObjectRef.create(null);
            if (version == 4) {
                String x$40 = "grp";
                short x$42 = (short)version;
                String x$43 = this.sendJoinRequest$default$2();
                String x$44 = this.sendJoinRequest$default$3();
                String x$45 = this.sendJoinRequest$default$4();
                String x$46 = this.sendJoinRequest$default$5();
                joinFollowerResponseData.elem = this.sendJoinRequest(x$40, x$43, x$44, x$45, x$46, metadata, x$42);
            }
            Future joinFollowerFuture = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String x$47 = "grp";
                String x$48 = version != 4 ? "" : ((JoinGroupResponseData)joinFollowerResponseData$1.elem).memberId();
                String x$49 = version >= 5 ? "group-instance-id" : null;
                short x$51 = (short)version;
                String x$52 = this.sendJoinRequest$default$4();
                String x$53 = this.sendJoinRequest$default$5();
                return this.sendJoinRequest(x$47, x$48, x$49, x$52, x$53, metadata, x$51);
            }, ExecutionContext.Implicits$.MODULE$.global());
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!JoinGroupRequestTest.$anonfun$testJoinGroup$3(this)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)JoinGroupRequestTest.$anonfun$testJoinGroup$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            String x$54 = "grp";
            short x$57 = (short)version;
            String x$58 = this.sendJoinRequest$default$3();
            String x$59 = this.sendJoinRequest$default$4();
            String x$60 = this.sendJoinRequest$default$5();
            JoinGroupResponseData rejoinLeaderResponseData = this.sendJoinRequest(x$54, leaderMemberId, x$58, x$59, x$60, metadata, x$57);
            JoinGroupResponseData joinFollowerFutureResponseData = (JoinGroupResponseData)Await$.MODULE$.result((Awaitable)joinFollowerFuture, (Duration)Duration$.MODULE$.Inf());
            String followerMemberId = joinFollowerFutureResponseData.memberId();
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(2).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(followerMemberId), joinFollowerFutureResponseData);
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(2).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(leaderMemberId).setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(leaderMemberId).setMetadata(metadata), (List)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(followerMemberId).setGroupInstanceId(version >= 5 ? "group-instance-id" : null).setMetadata(metadata), (List)Nil$.MODULE$))).asJava()), rejoinLeaderResponseData);
            String x$61 = "grp";
            int x$63 = rejoinLeaderResponseData.generationId();
            .colon.colon x$64 = new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(leaderMemberId).setAssignment((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(followerMemberId).setAssignment((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{2}), ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
            byte[] x$65 = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte());
            String x$66 = this.syncGroupWithOldProtocol$default$4();
            String x$67 = this.syncGroupWithOldProtocol$default$5();
            String x$68 = this.syncGroupWithOldProtocol$default$7();
            String x$69 = this.syncGroupWithOldProtocol$default$8();
            Errors x$70 = this.syncGroupWithOldProtocol$default$10();
            short x$71 = this.syncGroupWithOldProtocol$default$11();
            this.syncGroupWithOldProtocol(x$61, leaderMemberId, x$63, x$66, x$67, (List<SyncGroupRequestData.SyncGroupRequestAssignment>)x$64, x$68, x$69, x$65, x$70, x$71);
            String x$72 = "grp";
            int x$74 = joinFollowerFutureResponseData.generationId();
            byte[] x$75 = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{2}), ClassTag$.MODULE$.Byte());
            String x$76 = this.syncGroupWithOldProtocol$default$4();
            String x$77 = this.syncGroupWithOldProtocol$default$5();
            List<SyncGroupRequestData.SyncGroupRequestAssignment> x$78 = this.syncGroupWithOldProtocol$default$6();
            String x$79 = this.syncGroupWithOldProtocol$default$7();
            String x$80 = this.syncGroupWithOldProtocol$default$8();
            Errors x$81 = this.syncGroupWithOldProtocol$default$10();
            short x$82 = this.syncGroupWithOldProtocol$default$11();
            this.syncGroupWithOldProtocol(x$72, followerMemberId, x$74, x$76, x$77, x$78, x$79, x$80, x$75, x$81, x$82);
            String x$83 = "grp";
            String x$84 = version >= 5 ? "group-instance-id" : null;
            short x$87 = (short)version;
            String x$88 = this.sendJoinRequest$default$4();
            String x$89 = this.sendJoinRequest$default$5();
            this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(2).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(followerMemberId), this.sendJoinRequest(x$83, followerMemberId, x$84, x$88, x$89, metadata, x$87));
            if (version >= 5) {
                followerMemberId = this.testFencedStaticGroup(leaderMemberId, followerMemberId, metadata, version);
            }
            this.leaveGroup("grp", leaderMemberId, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            this.leaveGroup("grp", followerMemberId, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            this.deleteGroups((List<String>)new .colon.colon((Object)"grp", (List)Nil$.MODULE$), (List<Errors>)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$), ApiKeys.DELETE_GROUPS.latestVersion(this.isUnstableApiEnabled()));
        });
    }

    /*
     * WARNING - void declaration
     */
    private String testFencedStaticGroup(String leaderMemberId, String followerMemberId, byte[] metadata, int version) {
        Future rejoinLeaderFuture = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String x$1 = "grp";
            short x$4 = (short)version;
            String x$5 = this.sendJoinRequest$default$3();
            String x$6 = this.sendJoinRequest$default$4();
            String x$7 = this.sendJoinRequest$default$5();
            return this.sendJoinRequest(x$1, leaderMemberId, x$5, x$6, x$7, metadata, x$4);
        }, ExecutionContext.Implicits$.MODULE$.global());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!JoinGroupRequestTest.$anonfun$testFencedStaticGroup$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)JoinGroupRequestTest.$anonfun$testFencedStaticGroup$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        String x$8 = "grp";
        String x$9 = "group-instance-id";
        short x$11 = (short)version;
        String x$12 = this.sendJoinRequest$default$2();
        String x$13 = this.sendJoinRequest$default$4();
        String x$14 = this.sendJoinRequest$default$5();
        JoinGroupResponseData joinNewFollowerResponseData = this.sendJoinRequest(x$8, x$12, x$9, x$13, x$14, metadata, x$11);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!JoinGroupRequestTest.$anonfun$testFencedStaticGroup$4(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)JoinGroupRequestTest.$anonfun$testFencedStaticGroup$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        String x$15 = "grp";
        String x$17 = "group-instance-id";
        short x$19 = (short)version;
        String x$20 = this.sendJoinRequest$default$4();
        String x$21 = this.sendJoinRequest$default$5();
        JoinGroupResponseData rejoinFollowerResponseData = this.sendJoinRequest(x$15, followerMemberId, x$17, x$20, x$21, metadata, x$19);
        JoinGroupResponseData rejoinLeaderFutureResponseData = (JoinGroupResponseData)Await$.MODULE$.result((Awaitable)rejoinLeaderFuture, (Duration)Duration$.MODULE$.Inf());
        String newFollowerMemberId = joinNewFollowerResponseData.memberId();
        this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(3).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(leaderMemberId).setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(leaderMemberId).setMetadata(metadata), (List)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(newFollowerMemberId).setGroupInstanceId("group-instance-id").setMetadata(metadata), (List)Nil$.MODULE$))).asJava()), rejoinLeaderFutureResponseData);
        this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setGenerationId(3).setProtocolType(version >= 7 ? "consumer" : null).setProtocolName("consumer-range").setLeader(leaderMemberId).setMemberId(newFollowerMemberId), joinNewFollowerResponseData);
        this.verifyJoinGroupResponseDataEquals(new JoinGroupResponseData().setProtocolName(version >= 7 ? null : "").setMemberId(followerMemberId).setErrorCode(Errors.FENCED_INSTANCE_ID.code()), rejoinFollowerResponseData);
        return newFollowerMemberId;
    }

    private JoinGroupResponseData normalize(JoinGroupResponseData responseData) {
        JoinGroupResponseData newResponseData = responseData.duplicate();
        Collections.sort(newResponseData.members(), (m1, m2) -> m1.memberId().compareTo(m2.memberId()));
        return newResponseData;
    }

    private void verifyJoinGroupResponseDataEquals(JoinGroupResponseData expected, JoinGroupResponseData actual) {
        Assertions.assertEquals((Object)this.normalize(expected), (Object)this.normalize(actual));
    }

    public static final /* synthetic */ boolean $anonfun$testJoinGroup$3(JoinGroupRequestTest $this) {
        List<DescribeGroupsResponseData.DescribedGroup> described = $this.describeGroups((List<String>)new .colon.colon((Object)"grp", (List)Nil$.MODULE$), $this.describeGroups$default$2());
        String string = ClassicGroupState.PREPARING_REBALANCE.toString();
        String string2 = ((DescribeGroupsResponseData.DescribedGroup)described.head()).groupState();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testJoinGroup$4() {
        return "The group is not in PREPARING_REBALANCE state.";
    }

    public static final /* synthetic */ boolean $anonfun$testFencedStaticGroup$2(JoinGroupRequestTest $this) {
        List<DescribeGroupsResponseData.DescribedGroup> described = $this.describeGroups((List<String>)new .colon.colon((Object)"grp", (List)Nil$.MODULE$), $this.describeGroups$default$2());
        String string = ClassicGroupState.PREPARING_REBALANCE.toString();
        String string2 = ((DescribeGroupsResponseData.DescribedGroup)described.head()).groupState();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testFencedStaticGroup$3() {
        return "The group is not in PREPARING_REBALANCE state.";
    }

    public static final /* synthetic */ boolean $anonfun$testFencedStaticGroup$4(JoinGroupRequestTest $this) {
        List<DescribeGroupsResponseData.DescribedGroup> described = $this.describeGroups((List<String>)new .colon.colon((Object)"grp", (List)Nil$.MODULE$), $this.describeGroups$default$2());
        String string = ClassicGroupState.COMPLETING_REBALANCE.toString();
        String string2 = ((DescribeGroupsResponseData.DescribedGroup)described.head()).groupState();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testFencedStaticGroup$5() {
        return "The group is not in COMPLETING_REBALANCE state.";
    }

    public JoinGroupRequestTest(ClusterInstance cluster) {
        super(cluster);
    }
}

